# Generated by Django 3.2.19 on 2024-05-30 12:23

import django.db.models.expressions
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name='AuditLog',
            fields=[
                (
                    'id',
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'purpose',
                    models.CharField(
                        choices=[('uefi', 'UEFI Secure Boot')], max_length=7
                    ),
                ),
                ('fingerprint', models.CharField(max_length=64)),
                (
                    'event',
                    models.CharField(
                        choices=[('generate', 'Generate'), ('sign', 'Sign')],
                        max_length=8,
                    ),
                ),
                ('data', models.JSONField()),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('created_by_work_request_id', models.IntegerField()),
            ],
        ),
        migrations.CreateModel(
            name='Key',
            fields=[
                (
                    'id',
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'purpose',
                    models.CharField(
                        choices=[('uefi', 'UEFI Secure Boot')], max_length=7
                    ),
                ),
                ('fingerprint', models.CharField(max_length=64)),
                ('private_key', models.JSONField()),
                ('public_key', models.BinaryField()),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(blank=True, null=True)),
            ],
        ),
        migrations.AddConstraint(
            model_name='key',
            constraint=models.UniqueConstraint(
                fields=('purpose', 'fingerprint'),
                name='signing_key_unique_purpose_fingerprint',
            ),
        ),
        migrations.AddIndex(
            model_name='auditlog',
            index=models.Index(
                django.db.models.expressions.F('purpose'),
                django.db.models.expressions.F('fingerprint'),
                name='signing_auditlog_key_idx',
            ),
        ),
        migrations.AddIndex(
            model_name='auditlog',
            index=models.Index(
                django.db.models.expressions.F('created_by_work_request_id'),
                name='signing_auditlog_wr_idx',
            ),
        ),
    ]
