% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{Hist}
\alias{Hist}
\title{Plot a Histogram}
\usage{
Hist(
  x,
  groups,
  scale = c("frequency", "percent", "density"),
  xlab = deparse(substitute(x)),
  ylab = scale,
  main = "",
  breaks = "Sturges",
  ...
)
}
\arguments{
\item{x}{a vector of values for which a histogram is to be plotted.}

\item{groups}{a factor (or character or logical variable) to create histograms by group with common horizontal and vertical scales.}

\item{scale}{the scaling of the vertical axis: \code{"frequency"} (the default), \code{"percent"}, or \code{"density"}.}

\item{xlab}{x-axis label, defaults to name of variable.}

\item{ylab}{y-axis label, defaults to value of \code{scale}.}

\item{main}{main title for graph, defaults to empty.}

\item{breaks}{see the \code{breaks} argument for \code{\link[graphics]{hist}}.}

\item{...}{arguments to be passed to \code{hist}.}
}
\value{
This function is primarily called for its side effect ---  plotting a histogram or histograms --- but it also invisibly returns an object of class \code{\link[graphics]{hist}} or a list of \code{hist} objects.
}
\description{
Plot a Histogram
}
\details{
This function is a wrapper for the \code{\link[graphics]{hist}} function in the \code{base} package, permitting percentage scaling of the vertical axis in addition to frequency and density scaling.
}
\examples{
data(Prestige, package="car")
Hist(Prestige$income, scale="percent")
with(Prestige, Hist(income, groups=type))

}
\seealso{
\code{\link[graphics]{hist}}
}
\author{
John Fox
}
\keyword{hplot}
