% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dump.R
\name{dumpEnv}
\alias{dumpEnv}
\alias{dumpImage}
\alias{dumpObjects}
\alias{dumpDF}
\alias{dumpList}
\title{Dump Environment}
\usage{
dumpEnv(env, dbName)

dumpImage(dbName = "Rworkspace", type = NULL)

dumpObjects(
  ...,
  list = character(0),
  dbName,
  type = NULL,
  envir = parent.frame()
)

dumpDF(data, dbName = NULL, type = NULL)

dumpList(data, dbName = NULL, type = NULL)
}
\arguments{
\item{env}{an environment}

\item{dbName}{character, name of the filehash database}

\item{type}{type of filehash database to create}

\item{...}{R objects to be dumped to a filehash database}

\item{list, }{character vector of object names to be dumped}

\item{envir}{environment from which objects are dumped}

\item{data}{a data frame}
}
\value{
An object of class \code{"filehash"} is returned and a database is created.
}
\description{
Dump an enviroment to a filehash database
}
\details{
The \code{dumpEnv} function takes an environment and stores each element of the environment in a \code{filehash} database. Objects dumped to a database can later be loaded via \code{dbLoad} or can be accessed with \code{dbFetch}, \code{dbList}, etc. Alternatively, the \code{with} method can be used to evaluate code in the context of a database.  If a database with name \code{dbName} already exists, objects will be inserted into the existing database (and values for already-existing keys will be overwritten).

\code{dumpDF} is different in that each variable in the data frame is stored as a separate object in the database.  So each variable can be read from the database separately rather than having to load the entire data frame into memory.  \code{dumpList} works in a simlar way.
}
\section{Functions}{
\itemize{
\item \code{dumpImage()}: Dump the Global Environment (analogous to \code{save.image})

\item \code{dumpObjects()}: Dump named objects to a filehash database (analogous to \code{save})

\item \code{dumpDF()}: Dump data frame columns to a filehash database

\item \code{dumpList()}: Dump elements of a list to a filehash database

}}
