#!/bin/sh

: "${PD:=pd}"

resultfile=$(mktemp)
flags="-batch -verbose"

"${PD}" -version ${flags}
runtest() {
    if ! "${PD}" ${flags} -send "start 1" "$1"; then
      echo "$1 FAILED" >> "${resultfile}"
    fi
}

for f in "$@"; do
    echo "testing ${f}"
    runtest "${f}"
done

result=0
if [ -s "${resultfile}" ]; then
  cat "${resultfile}" 1>&2
  result=1
fi
rm -f "${resultfile}"
echo "result: ${result}"
exit "${result}"
