#
# @file    TestModelHistory.py
# @brief   ModelHistory unit tests
#
# @author  Akiya Jouraku (Python conversion)
# @author  Sarah Keating 
# 
# ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
#
# DO NOT EDIT THIS FILE.
#
# This file was generated automatically by converting the file located at
# src/annotation/test/TestModelHistory.c
# using the conversion program dev/utilities/translateTests/translateTests.pl.
# Any changes made here will be lost the next time the file is regenerated.
#
# -----------------------------------------------------------------------------
# This file is part of libSBML.  Please visit http://sbml.org for more
# information about SBML, and the latest version of libSBML.
#
# Copyright 2005-2010 California Institute of Technology.
# Copyright 2002-2005 California Institute of Technology and
#                     Japan Science and Technology Corporation.
# 
# This library is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation.  A copy of the license agreement is provided
# in the file named "LICENSE.txt" included with this software distribution
# and also available online as http://sbml.org/software/libsbml/license.html
# -----------------------------------------------------------------------------

import sys
import unittest
import libsbml


class TestModelHistory(unittest.TestCase):


  def test_Date_create(self):
    date = libsbml.Date(2005,12,30,12,15,45,1,2,0)
    self.assertTrue( date != None )
    self.assertTrue( date.getYear() == 2005 )
    self.assertTrue( date.getMonth() == 12 )
    self.assertTrue( date.getDay() == 30 )
    self.assertTrue( date.getHour() == 12 )
    self.assertTrue( date.getMinute() == 15 )
    self.assertTrue( date.getSecond() == 45 )
    self.assertTrue( date.getSignOffset() == 1 )
    self.assertTrue( date.getHoursOffset() == 2 )
    self.assertTrue( date.getMinutesOffset() == 0 )
    _dummyList = [ date ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_Date_createFromString(self):
    dd =  "2012-12-02T14:56:11Z";
    date = libsbml.Date(dd)
    self.assertTrue( date != None )
    self.assertTrue((  "2012-12-02T14:56:11Z" == date.getDateAsString() ))
    self.assertTrue( date.getYear() == 2012 )
    self.assertTrue( date.getMonth() == 12 )
    self.assertTrue( date.getDay() == 2 )
    self.assertTrue( date.getHour() == 14 )
    self.assertTrue( date.getMinute() == 56 )
    self.assertTrue( date.getSecond() == 11 )
    self.assertTrue( date.getSignOffset() == 0 )
    self.assertTrue( date.getHoursOffset() == 0 )
    self.assertTrue( date.getMinutesOffset() == 0 )
    _dummyList = [ date ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_Date_getDateAsString(self):
    dd =  "2005-02-02T14:56:11Z";
    date = libsbml.Date(dd)
    self.assertTrue( date != None )
    self.assertTrue( date.getYear() == 2005 )
    self.assertTrue( date.getMonth() == 2 )
    self.assertTrue( date.getDay() == 2 )
    self.assertTrue( date.getHour() == 14 )
    self.assertTrue( date.getMinute() == 56 )
    self.assertTrue( date.getSecond() == 11 )
    self.assertTrue( date.getSignOffset() == 0 )
    self.assertTrue( date.getHoursOffset() == 0 )
    self.assertTrue( date.getMinutesOffset() == 0 )
    date.setYear(2012)
    date.setMonth(3)
    date.setDay(28)
    date.setHour(23)
    date.setMinute(4)
    date.setSecond(32)
    date.setSignOffset(1)
    date.setHoursOffset(2)
    date.setMinutesOffset(32)
    self.assertTrue((  "2012-03-28T23:04:32+02:32" == date.getDateAsString() ))
    _dummyList = [ date ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_Date_setters(self):
    date = libsbml.Date(2005,12,30,12,15,45,1,2,0)
    self.assertTrue( date != None )
    date.setYear(2012)
    date.setMonth(3)
    date.setDay(28)
    date.setHour(23)
    date.setMinute(4)
    date.setSecond(32)
    date.setSignOffset(1)
    date.setHoursOffset(2)
    date.setMinutesOffset(32)
    self.assertTrue( date.getYear() == 2012 )
    self.assertTrue( date.getMonth() == 3 )
    self.assertTrue( date.getDay() == 28 )
    self.assertTrue( date.getHour() == 23 )
    self.assertTrue( date.getMinute() == 4 )
    self.assertTrue( date.getSecond() == 32 )
    self.assertTrue( date.getSignOffset() == 1 )
    self.assertTrue( date.getHoursOffset() == 2 )
    self.assertTrue( date.getMinutesOffset() == 32 )
    self.assertTrue((  "2012-03-28T23:04:32+02:32" == date.getDateAsString() ))
    _dummyList = [ date ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ModelCreator_create(self):
    mc = libsbml.ModelCreator()
    self.assertTrue( mc != None )
    _dummyList = [ mc ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ModelCreator_setters(self):
    mc = libsbml.ModelCreator()
    self.assertTrue( mc != None )
    self.assertTrue( mc.isSetFamilyName() == False )
    self.assertTrue( mc.isSetGivenName() == False )
    self.assertTrue( mc.isSetEmail() == False )
    self.assertTrue( mc.isSetOrganisation() == False )
    mc.setFamilyName( "Keating")
    mc.setGivenName( "Sarah")
    mc.setEmail( "sbml-team@caltech.edu")
    mc.setOrganisation( "UH")
    self.assertTrue((  "Keating" == mc.getFamilyName() ))
    self.assertTrue((  "Sarah" == mc.getGivenName() ))
    self.assertTrue((  "sbml-team@caltech.edu" == mc.getEmail() ))
    self.assertTrue((  "UH" == mc.getOrganisation() ))
    self.assertTrue( mc.isSetFamilyName() == True )
    self.assertTrue( mc.isSetGivenName() == True )
    self.assertTrue( mc.isSetEmail() == True )
    self.assertTrue( mc.isSetOrganisation() == True )
    mc.unsetFamilyName()
    mc.unsetGivenName()
    mc.unsetEmail()
    mc.unsetOrganisation()
    self.assertTrue((  "" == mc.getFamilyName() ))
    self.assertTrue((  "" == mc.getGivenName() ))
    self.assertTrue((  "" == mc.getEmail() ))
    self.assertTrue((  "" == mc.getOrganisation() ))
    self.assertTrue( mc.isSetFamilyName() == False )
    self.assertTrue( mc.isSetGivenName() == False )
    self.assertTrue( mc.isSetEmail() == False )
    self.assertTrue( mc.isSetOrganisation() == False )
    self.assertTrue( mc.isSetOrganization() == False )
    mc.setOrganization( "UH")
    self.assertTrue((  "UH" == mc.getOrganization() ))
    self.assertTrue( mc.isSetOrganization() == True )
    mc.unsetOrganisation()
    self.assertTrue((  "" == mc.getOrganization() ))
    self.assertTrue( mc.isSetOrganization() == False )
    _dummyList = [ mc ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ModelHistory_addCreator(self):
    history = libsbml.ModelHistory()
    self.assertTrue( history.getNumCreators() == 0 )
    self.assertTrue( history != None )
    mc = libsbml.ModelCreator()
    self.assertTrue( mc != None )
    mc.setFamilyName( "Keating")
    mc.setGivenName( "Sarah")
    mc.setEmail( "sbml-team@caltech.edu")
    mc.setOrganisation( "UH")
    history.addCreator(mc)
    self.assertTrue( history.getNumCreators() == 1 )
    _dummyList = [ mc ]; _dummyList[:] = []; del _dummyList
    newMC = history.getListCreators().get(0)
    self.assertTrue( newMC != None )
    self.assertTrue((  "Keating" == newMC.getFamilyName() ))
    self.assertTrue((  "Sarah" == newMC.getGivenName() ))
    self.assertTrue((  "sbml-team@caltech.edu" == newMC.getEmail() ))
    self.assertTrue((  "UH" == newMC.getOrganisation() ))
    _dummyList = [ history ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ModelHistory_addModifiedDate(self):
    history = libsbml.ModelHistory()
    self.assertTrue( history != None )
    self.assertTrue( history.isSetModifiedDate() == False )
    self.assertTrue( history.getNumModifiedDates() == 0 )
    date = libsbml.Date(2005,12,30,12,15,45,1,2,0)
    history.addModifiedDate(date)
    _dummyList = [ date ]; _dummyList[:] = []; del _dummyList
    self.assertTrue( history.getNumModifiedDates() == 1 )
    self.assertTrue( history.isSetModifiedDate() == True )
    newdate = history.getListModifiedDates().get(0)
    self.assertTrue( newdate.getYear() == 2005 )
    self.assertTrue( newdate.getMonth() == 12 )
    self.assertTrue( newdate.getDay() == 30 )
    self.assertTrue( newdate.getHour() == 12 )
    self.assertTrue( newdate.getMinute() == 15 )
    self.assertTrue( newdate.getSecond() == 45 )
    self.assertTrue( newdate.getSignOffset() == 1 )
    self.assertTrue( newdate.getHoursOffset() == 2 )
    self.assertTrue( newdate.getMinutesOffset() == 0 )
    date1 = libsbml.Date(2008,11,2,16,42,40,1,2,0)
    history.addModifiedDate(date1)
    _dummyList = [ date1 ]; _dummyList[:] = []; del _dummyList
    self.assertTrue( history.getNumModifiedDates() == 2 )
    self.assertTrue( history.isSetModifiedDate() == True )
    newdate1 = history.getModifiedDate(1)
    self.assertTrue( newdate1.getYear() == 2008 )
    self.assertTrue( newdate1.getMonth() == 11 )
    self.assertTrue( newdate1.getDay() == 2 )
    self.assertTrue( newdate1.getHour() == 16 )
    self.assertTrue( newdate1.getMinute() == 42 )
    self.assertTrue( newdate1.getSecond() == 40 )
    self.assertTrue( newdate1.getSignOffset() == 1 )
    self.assertTrue( newdate1.getHoursOffset() == 2 )
    self.assertTrue( newdate1.getMinutesOffset() == 0 )
    _dummyList = [ history ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ModelHistory_create(self):
    history = libsbml.ModelHistory()
    self.assertTrue( history != None )
    self.assertTrue( history.getListCreators() != None )
    self.assertTrue( history.getCreatedDate() == None )
    self.assertTrue( history.getModifiedDate() == None )
    _dummyList = [ history ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ModelHistory_setCreatedDate(self):
    history = libsbml.ModelHistory()
    self.assertTrue( history != None )
    self.assertTrue( history.isSetCreatedDate() == False )
    date = libsbml.Date(2005,12,30,12,15,45,1,2,0)
    history.setCreatedDate(date)
    self.assertTrue( history.isSetCreatedDate() == True )
    _dummyList = [ date ]; _dummyList[:] = []; del _dummyList
    newdate = history.getCreatedDate()
    self.assertTrue( newdate.getYear() == 2005 )
    self.assertTrue( newdate.getMonth() == 12 )
    self.assertTrue( newdate.getDay() == 30 )
    self.assertTrue( newdate.getHour() == 12 )
    self.assertTrue( newdate.getMinute() == 15 )
    self.assertTrue( newdate.getSecond() == 45 )
    self.assertTrue( newdate.getSignOffset() == 1 )
    self.assertTrue( newdate.getHoursOffset() == 2 )
    self.assertTrue( newdate.getMinutesOffset() == 0 )
    _dummyList = [ history ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ModelHistory_setModifiedDate(self):
    history = libsbml.ModelHistory()
    self.assertTrue( history != None )
    self.assertTrue( history.isSetModifiedDate() == False )
    date = libsbml.Date(2005,12,30,12,15,45,1,2,0)
    history.setModifiedDate(date)
    _dummyList = [ date ]; _dummyList[:] = []; del _dummyList
    self.assertTrue( history.isSetModifiedDate() == True )
    newdate = history.getModifiedDate()
    self.assertTrue( newdate.getYear() == 2005 )
    self.assertTrue( newdate.getMonth() == 12 )
    self.assertTrue( newdate.getDay() == 30 )
    self.assertTrue( newdate.getHour() == 12 )
    self.assertTrue( newdate.getMinute() == 15 )
    self.assertTrue( newdate.getSecond() == 45 )
    self.assertTrue( newdate.getSignOffset() == 1 )
    self.assertTrue( newdate.getHoursOffset() == 2 )
    self.assertTrue( newdate.getMinutesOffset() == 0 )
    _dummyList = [ history ]; _dummyList[:] = []; del _dummyList
    pass  

def suite():
  suite = unittest.TestSuite()
  suite.addTest(unittest.TestLoader.loadTestsFromTestCase(TestModelHistory))

  return suite

if __name__ == "__main__":
  if unittest.TextTestRunner(verbosity=1).run(suite()).wasSuccessful() :
    sys.exit(0)
  else:
    sys.exit(1)
