# Jalview Projects

Jalview projects are zipped archives consisting of structured documents and an assortment of data files. As of Jalview 2.11.4, each document is an XML file that describes a Jalview dataset and one or more alignments and views on that dataset. Projects are created and imported via the jalview.project.Jalview2XML class, which handles the marshalling and unmarshalling of jalview's live data model as a set of POJO classes autogenerated from the schemas/jalview.xsd XML schema (and those it refers to). 

You probably came here looking for information about how to update the Jalview project for new types of data. Here's the quick how-to:

1. Download jaxb-ri-2.3.x from https://repo1.maven.org/maven2/com/sun/xml/bind/jaxb-ri/2.3.9/jaxb-ri-2.3.9.zip
2. Unzip it somewhere and check that you can execute jaxb-ri/bin/xjc.sh from a terminal
3. Change to your jalview project's working directory and execute the following to regenerate the POJOs:

```$PATHTOJAXBRI/bin/xjc.sh -d src -p jalview.xml.binding.jalview schemas/jalview.xsd```

If all goes well, you should see new and updated files under src/jalview/xml/binding/jalview

4. Make sure everything compiles and tests correctly. 
   * Please make sure that any new additions to Jalview2XML are covered by tests - both checking that new data is written correctly to projects, and that they are read correctly from projects. 

5. Remember to add to git all the new classes generated by jax-b: 
```git add src/jalview/xml/binding/jalview/*```   

