// Code generated by smithy-go-codegen DO NOT EDIT.

package rekognition

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// This operation applies only to Amazon Rekognition Custom Labels.
//
// Lists the entries (images) within a dataset. An entry is a JSON Line that
// contains the information for a single image, including the image location,
// assigned labels, and object location bounding boxes. For more information, see [Creating a manifest file].
//
// JSON Lines in the response include information about non-terminal errors found
// in the dataset. Non terminal errors are reported in errors lists within each
// JSON Line. The same information is reported in the training and testing
// validation result manifests that Amazon Rekognition Custom Labels creates during
// model training.
//
// You can filter the response in variety of ways, such as choosing which labels
// to return and returning JSON Lines created after a specific date.
//
// This operation requires permissions to perform the
// rekognition:ListDatasetEntries action.
//
// [Creating a manifest file]: https://docs.aws.amazon.com/rekognition/latest/customlabels-dg/md-manifest-files.html
func (c *Client) ListDatasetEntries(ctx context.Context, params *ListDatasetEntriesInput, optFns ...func(*Options)) (*ListDatasetEntriesOutput, error) {
	if params == nil {
		params = &ListDatasetEntriesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListDatasetEntries", params, optFns, c.addOperationListDatasetEntriesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListDatasetEntriesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListDatasetEntriesInput struct {

	//  The Amazon Resource Name (ARN) for the dataset that you want to use.
	//
	// This member is required.
	DatasetArn *string

	// Specifies a label filter for the response. The response includes an entry only
	// if one or more of the labels in ContainsLabels exist in the entry.
	ContainsLabels []string

	// Specifies an error filter for the response. Specify True to only include
	// entries that have errors.
	HasErrors *bool

	//  Specify true to get only the JSON Lines where the image is labeled. Specify
	// false to get only the JSON Lines where the image isn't labeled. If you don't
	// specify Labeled , ListDatasetEntries returns JSON Lines for labeled and
	// unlabeled images.
	Labeled *bool

	// The maximum number of results to return per paginated call. The largest value
	// you can specify is 100. If you specify a value greater than 100, a
	// ValidationException error occurs. The default value is 100.
	MaxResults *int32

	// If the previous response was incomplete (because there is more results to
	// retrieve), Amazon Rekognition Custom Labels returns a pagination token in the
	// response. You can use this pagination token to retrieve the next set of results.
	NextToken *string

	// If specified, ListDatasetEntries only returns JSON Lines where the value of
	// SourceRefContains is part of the source-ref field. The source-ref field
	// contains the Amazon S3 location of the image. You can use SouceRefContains for
	// tasks such as getting the JSON Line for a single image, or gettting JSON Lines
	// for all images within a specific folder.
	SourceRefContains *string

	noSmithyDocumentSerde
}

type ListDatasetEntriesOutput struct {

	//  A list of entries (images) in the dataset.
	DatasetEntries []string

	// If the previous response was incomplete (because there is more results to
	// retrieve), Amazon Rekognition Custom Labels returns a pagination token in the
	// response. You can use this pagination token to retrieve the next set of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListDatasetEntriesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListDatasetEntries{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListDatasetEntries{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListDatasetEntries"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListDatasetEntriesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListDatasetEntries(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListDatasetEntriesAPIClient is a client that implements the ListDatasetEntries
// operation.
type ListDatasetEntriesAPIClient interface {
	ListDatasetEntries(context.Context, *ListDatasetEntriesInput, ...func(*Options)) (*ListDatasetEntriesOutput, error)
}

var _ ListDatasetEntriesAPIClient = (*Client)(nil)

// ListDatasetEntriesPaginatorOptions is the paginator options for
// ListDatasetEntries
type ListDatasetEntriesPaginatorOptions struct {
	// The maximum number of results to return per paginated call. The largest value
	// you can specify is 100. If you specify a value greater than 100, a
	// ValidationException error occurs. The default value is 100.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListDatasetEntriesPaginator is a paginator for ListDatasetEntries
type ListDatasetEntriesPaginator struct {
	options   ListDatasetEntriesPaginatorOptions
	client    ListDatasetEntriesAPIClient
	params    *ListDatasetEntriesInput
	nextToken *string
	firstPage bool
}

// NewListDatasetEntriesPaginator returns a new ListDatasetEntriesPaginator
func NewListDatasetEntriesPaginator(client ListDatasetEntriesAPIClient, params *ListDatasetEntriesInput, optFns ...func(*ListDatasetEntriesPaginatorOptions)) *ListDatasetEntriesPaginator {
	if params == nil {
		params = &ListDatasetEntriesInput{}
	}

	options := ListDatasetEntriesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListDatasetEntriesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListDatasetEntriesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListDatasetEntries page.
func (p *ListDatasetEntriesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListDatasetEntriesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListDatasetEntries(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListDatasetEntries(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListDatasetEntries",
	}
}
