// Code generated by smithy-go-codegen DO NOT EDIT.

package glacier

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	glaciercust "github.com/aws/aws-sdk-go-v2/service/glacier/internal/customizations"
	"github.com/aws/aws-sdk-go-v2/service/glacier/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// This operation initiates the vault locking process by doing the following:
//
//   - Installing a vault lock policy on the specified vault.
//
//   - Setting the lock state of vault lock to InProgress .
//
//   - Returning a lock ID, which is used to complete the vault locking process.
//
// You can set one vault lock policy for each vault and this policy can be up to
// 20 KB in size. For more information about vault lock policies, see [Amazon Glacier Access Control with Vault Lock Policies].
//
// You must complete the vault locking process within 24 hours after the vault
// lock enters the InProgress state. After the 24 hour window ends, the lock ID
// expires, the vault automatically exits the InProgress state, and the vault lock
// policy is removed from the vault. You call CompleteVaultLockto complete the vault locking
// process by setting the state of the vault lock to Locked .
//
// After a vault lock is in the Locked state, you cannot initiate a new vault lock
// for the vault.
//
// You can abort the vault locking process by calling AbortVaultLock. You can get the state of
// the vault lock by calling GetVaultLock. For more information about the vault locking
// process, [Amazon Glacier Vault Lock].
//
// If this operation is called when the vault lock is in the InProgress state, the
// operation returns an AccessDeniedException error. When the vault lock is in the
// InProgress state you must call AbortVaultLock before you can initiate a new vault lock
// policy.
//
// [Amazon Glacier Vault Lock]: https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock.html
// [Amazon Glacier Access Control with Vault Lock Policies]: https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock-policy.html
func (c *Client) InitiateVaultLock(ctx context.Context, params *InitiateVaultLockInput, optFns ...func(*Options)) (*InitiateVaultLockOutput, error) {
	if params == nil {
		params = &InitiateVaultLockInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "InitiateVaultLock", params, optFns, c.addOperationInitiateVaultLockMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*InitiateVaultLockOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// The input values for InitiateVaultLock .
type InitiateVaultLockInput struct {

	// The AccountId value is the AWS account ID. This value must match the AWS
	// account ID associated with the credentials used to sign the request. You can
	// either specify an AWS account ID or optionally a single ' - ' (hyphen), in which
	// case Amazon Glacier uses the AWS account ID associated with the credentials used
	// to sign the request. If you specify your account ID, do not include any hyphens
	// ('-') in the ID.
	//
	// This member is required.
	AccountId *string

	// The name of the vault.
	//
	// This member is required.
	VaultName *string

	// The vault lock policy as a JSON string, which uses "\" as an escape character.
	Policy *types.VaultLockPolicy

	noSmithyDocumentSerde
}

// Contains the Amazon S3 Glacier response to your request.
type InitiateVaultLockOutput struct {

	// The lock ID, which is used to complete the vault locking process.
	LockId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationInitiateVaultLockMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpInitiateVaultLock{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpInitiateVaultLock{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "InitiateVaultLock"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpInitiateVaultLockValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opInitiateVaultLock(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = glaciercust.AddTreeHashMiddleware(stack); err != nil {
		return err
	}
	if err = glaciercust.AddGlacierAPIVersionMiddleware(stack, ServiceAPIVersion); err != nil {
		return err
	}
	if err = glaciercust.AddDefaultAccountIDMiddleware(stack, setDefaultAccountID); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opInitiateVaultLock(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "InitiateVaultLock",
	}
}
