// Code generated by smithy-go-codegen DO NOT EDIT.

package rds

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/rds/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a tenant database in a DB instance that uses the multi-tenant
// configuration. Only RDS for Oracle container database (CDB) instances are
// supported.
func (c *Client) CreateTenantDatabase(ctx context.Context, params *CreateTenantDatabaseInput, optFns ...func(*Options)) (*CreateTenantDatabaseOutput, error) {
	if params == nil {
		params = &CreateTenantDatabaseInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateTenantDatabase", params, optFns, c.addOperationCreateTenantDatabaseMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateTenantDatabaseOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateTenantDatabaseInput struct {

	// The user-supplied DB instance identifier. RDS creates your tenant database in
	// this DB instance. This parameter isn't case-sensitive.
	//
	// This member is required.
	DBInstanceIdentifier *string

	// The password for the master user in your tenant database.
	//
	// Constraints:
	//
	//   - Must be 8 to 30 characters.
	//
	//   - Can include any printable ASCII character except forward slash ( / ), double
	//   quote ( " ), at symbol ( @ ), ampersand ( & ), or single quote ( ' ).
	//
	// This member is required.
	MasterUserPassword *string

	// The name for the master user account in your tenant database. RDS creates this
	// user account in the tenant database and grants privileges to the master user.
	// This parameter is case-sensitive.
	//
	// Constraints:
	//
	//   - Must be 1 to 16 letters, numbers, or underscores.
	//
	//   - First character must be a letter.
	//
	//   - Can't be a reserved word for the chosen database engine.
	//
	// This member is required.
	MasterUsername *string

	// The user-supplied name of the tenant database that you want to create in your
	// DB instance. This parameter has the same constraints as DBName in
	// CreateDBInstance .
	//
	// This member is required.
	TenantDBName *string

	// The character set for your tenant database. If you don't specify a value, the
	// character set name defaults to AL32UTF8 .
	CharacterSetName *string

	// The NCHAR value for the tenant database.
	NcharCharacterSetName *string

	// A list of tags. For more information, see [Tagging Amazon RDS Resources] in the Amazon RDS User Guide.
	//
	// [Tagging Amazon RDS Resources]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreateTenantDatabaseOutput struct {

	// A tenant database in the DB instance. This data type is an element in the
	// response to the DescribeTenantDatabases action.
	TenantDatabase *types.TenantDatabase

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateTenantDatabaseMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpCreateTenantDatabase{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpCreateTenantDatabase{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateTenantDatabase"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateTenantDatabaseValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateTenantDatabase(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateTenantDatabase(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateTenantDatabase",
	}
}
