//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armwebpubsub

import "time"

// ClientBeginCreateOrUpdateOptions contains the optional parameters for the Client.BeginCreateOrUpdate method.
type ClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClientBeginDeleteOptions contains the optional parameters for the Client.BeginDelete method.
type ClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClientBeginRegenerateKeyOptions contains the optional parameters for the Client.BeginRegenerateKey method.
type ClientBeginRegenerateKeyOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClientBeginRestartOptions contains the optional parameters for the Client.BeginRestart method.
type ClientBeginRestartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClientBeginUpdateOptions contains the optional parameters for the Client.BeginUpdate method.
type ClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClientCheckNameAvailabilityOptions contains the optional parameters for the Client.CheckNameAvailability method.
type ClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// ClientGetOptions contains the optional parameters for the Client.Get method.
type ClientGetOptions struct {
	// placeholder for future optional parameters
}

// ClientListByResourceGroupOptions contains the optional parameters for the Client.ListByResourceGroup method.
type ClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ClientListBySubscriptionOptions contains the optional parameters for the Client.ListBySubscription method.
type ClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// ClientListKeysOptions contains the optional parameters for the Client.ListKeys method.
type ClientListKeysOptions struct {
	// placeholder for future optional parameters
}

// ClientListSKUsOptions contains the optional parameters for the Client.ListSKUs method.
type ClientListSKUsOptions struct {
	// placeholder for future optional parameters
}

// CustomCertificate - A custom certificate.
type CustomCertificate struct {
	// REQUIRED; Custom certificate properties.
	Properties *CustomCertificateProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource - e.g. "Microsoft.SignalRService/SignalR"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CustomCertificateList - Custom certificates list.
type CustomCertificateList struct {
	// The URL the client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`

	// List of custom certificates of this resource.
	Value []*CustomCertificate `json:"value,omitempty"`
}

// CustomCertificateProperties - Custom certificate properties.
type CustomCertificateProperties struct {
	// REQUIRED; Base uri of the KeyVault that stores certificate.
	KeyVaultBaseURI *string `json:"keyVaultBaseUri,omitempty"`

	// REQUIRED; Certificate secret name.
	KeyVaultSecretName *string `json:"keyVaultSecretName,omitempty"`

	// Certificate secret version.
	KeyVaultSecretVersion *string `json:"keyVaultSecretVersion,omitempty"`

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// CustomCertificatesClientBeginCreateOrUpdateOptions contains the optional parameters for the CustomCertificatesClient.BeginCreateOrUpdate
// method.
type CustomCertificatesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CustomCertificatesClientDeleteOptions contains the optional parameters for the CustomCertificatesClient.Delete method.
type CustomCertificatesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// CustomCertificatesClientGetOptions contains the optional parameters for the CustomCertificatesClient.Get method.
type CustomCertificatesClientGetOptions struct {
	// placeholder for future optional parameters
}

// CustomCertificatesClientListOptions contains the optional parameters for the CustomCertificatesClient.List method.
type CustomCertificatesClientListOptions struct {
	// placeholder for future optional parameters
}

// CustomDomain - A custom domain
type CustomDomain struct {
	// REQUIRED; Properties of a custom domain.
	Properties *CustomDomainProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource - e.g. "Microsoft.SignalRService/SignalR"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CustomDomainList - Custom domains list
type CustomDomainList struct {
	// The URL the client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`

	// List of custom domains that bind to this resource.
	Value []*CustomDomain `json:"value,omitempty"`
}

// CustomDomainProperties - Properties of a custom domain.
type CustomDomainProperties struct {
	// REQUIRED; Reference to a resource.
	CustomCertificate *ResourceReference `json:"customCertificate,omitempty"`

	// REQUIRED; The custom domain name.
	DomainName *string `json:"domainName,omitempty"`

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// CustomDomainsClientBeginCreateOrUpdateOptions contains the optional parameters for the CustomDomainsClient.BeginCreateOrUpdate
// method.
type CustomDomainsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CustomDomainsClientBeginDeleteOptions contains the optional parameters for the CustomDomainsClient.BeginDelete method.
type CustomDomainsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CustomDomainsClientGetOptions contains the optional parameters for the CustomDomainsClient.Get method.
type CustomDomainsClientGetOptions struct {
	// placeholder for future optional parameters
}

// CustomDomainsClientListOptions contains the optional parameters for the CustomDomainsClient.List method.
type CustomDomainsClientListOptions struct {
	// placeholder for future optional parameters
}

// Dimension - Specifications of the Dimension of metrics.
type Dimension struct {
	// Localized friendly display name of the dimension.
	DisplayName *string `json:"displayName,omitempty"`

	// Name of the dimension as it appears in MDM.
	InternalName *string `json:"internalName,omitempty"`

	// The public facing name of the dimension.
	Name *string `json:"name,omitempty"`

	// A Boolean flag indicating whether this dimension should be included for the shoebox export scenario.
	ToBeExportedForShoebox *bool `json:"toBeExportedForShoebox,omitempty"`
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorDetail `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// EventHandler - Properties of event handler.
type EventHandler struct {
	// REQUIRED; Gets or sets the EventHandler URL template. You can use a predefined parameter {hub} and {event} inside the template,
	// the value of the EventHandler URL is dynamically calculated when the client
	// request comes in. For example, UrlTemplate can be http://example.com/api/{hub}/{event}. The host part can't contains parameters.
	URLTemplate *string `json:"urlTemplate,omitempty"`

	// Upstream auth settings. If not set, no auth is used for upstream messages.
	Auth *UpstreamAuthSettings `json:"auth,omitempty"`

	// Gets or sets the list of system events.
	SystemEvents []*string `json:"systemEvents,omitempty"`

	// Gets or sets the matching pattern for event names. There are 3 kinds of patterns supported: 1. "*", it matches any event
	// name 2. Combine multiple events with ",", for example "event1,event2", it
	// matches event "event1" and "event2" 3. A single event name, for example, "event1", it matches "event1"
	UserEventPattern *string `json:"userEventPattern,omitempty"`
}

// EventHubEndpoint - An Event Hub endpoint. The managed identity of Web PubSub service must be enabled, and the identity
// should have the "Azure Event Hubs Data sender" role to access Event Hub.
type EventHubEndpoint struct {
	// REQUIRED; The name of the Event Hub.
	EventHubName *string `json:"eventHubName,omitempty"`

	// REQUIRED; The fully qualified namespace name of the Event Hub resource. For example, "example.servicebus.windows.net".
	FullyQualifiedNamespace *string `json:"fullyQualifiedNamespace,omitempty"`

	// REQUIRED
	Type *EventListenerEndpointDiscriminator `json:"type,omitempty"`
}

// GetEventListenerEndpoint implements the EventListenerEndpointClassification interface for type EventHubEndpoint.
func (e *EventHubEndpoint) GetEventListenerEndpoint() *EventListenerEndpoint {
	return &EventListenerEndpoint{
		Type: e.Type,
	}
}

// EventListener - A setting defines which kinds of events should be sent to which endpoint.
type EventListener struct {
	// REQUIRED; An endpoint specifying where Web PubSub should send events to.
	Endpoint EventListenerEndpointClassification `json:"endpoint,omitempty"`

	// REQUIRED; A base class for event filter which determines whether an event should be sent to an event listener.
	Filter EventListenerFilterClassification `json:"filter,omitempty"`
}

// EventListenerEndpointClassification provides polymorphic access to related types.
// Call the interface's GetEventListenerEndpoint() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *EventHubEndpoint, *EventListenerEndpoint
type EventListenerEndpointClassification interface {
	// GetEventListenerEndpoint returns the EventListenerEndpoint content of the underlying type.
	GetEventListenerEndpoint() *EventListenerEndpoint
}

// EventListenerEndpoint - An endpoint specifying where Web PubSub should send events to.
type EventListenerEndpoint struct {
	// REQUIRED
	Type *EventListenerEndpointDiscriminator `json:"type,omitempty"`
}

// GetEventListenerEndpoint implements the EventListenerEndpointClassification interface for type EventListenerEndpoint.
func (e *EventListenerEndpoint) GetEventListenerEndpoint() *EventListenerEndpoint { return e }

// EventListenerFilterClassification provides polymorphic access to related types.
// Call the interface's GetEventListenerFilter() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *EventListenerFilter, *EventNameFilter
type EventListenerFilterClassification interface {
	// GetEventListenerFilter returns the EventListenerFilter content of the underlying type.
	GetEventListenerFilter() *EventListenerFilter
}

// EventListenerFilter - A base class for event filter which determines whether an event should be sent to an event listener.
type EventListenerFilter struct {
	// REQUIRED
	Type *EventListenerFilterDiscriminator `json:"type,omitempty"`
}

// GetEventListenerFilter implements the EventListenerFilterClassification interface for type EventListenerFilter.
func (e *EventListenerFilter) GetEventListenerFilter() *EventListenerFilter { return e }

// EventNameFilter - Filter events by their name.
type EventNameFilter struct {
	// REQUIRED
	Type *EventListenerFilterDiscriminator `json:"type,omitempty"`

	// Gets or sets a list of system events. Supported events: "connected" and "disconnected". Blocking event "connect" is not
	// supported because it requires a response.
	SystemEvents []*string `json:"systemEvents,omitempty"`

	// Gets or sets a matching pattern for event names. There are 3 kinds of patterns supported: 1. "*", it matches any event
	// name 2. Combine multiple events with ",", for example "event1,event2", it matches
	// events "event1" and "event2" 3. A single event name, for example, "event1", it matches "event1"
	UserEventPattern *string `json:"userEventPattern,omitempty"`
}

// GetEventListenerFilter implements the EventListenerFilterClassification interface for type EventNameFilter.
func (e *EventNameFilter) GetEventListenerFilter() *EventListenerFilter {
	return &EventListenerFilter{
		Type: e.Type,
	}
}

// Hub - A hub setting
type Hub struct {
	// REQUIRED; Properties of a hub.
	Properties *HubProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource - e.g. "Microsoft.SignalRService/SignalR"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// HubList - Hub setting list
type HubList struct {
	// List of hub settings to this resource.
	Value []*Hub `json:"value,omitempty"`

	// READ-ONLY; The URL the client should use to fetch the next page (per server side paging). It's null for now, added for
	// future use.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// HubProperties - Properties of a hub.
type HubProperties struct {
	// The settings for configuring if anonymous connections are allowed for this hub: "allow" or "deny". Default to "deny".
	AnonymousConnectPolicy *string `json:"anonymousConnectPolicy,omitempty"`

	// Event handler of a hub.
	EventHandlers []*EventHandler `json:"eventHandlers,omitempty"`

	// Event listener settings for forwarding your client events to listeners. Event listener is transparent to Web PubSub clients,
	// and it doesn't return any result to clients nor interrupt the lifetime of
	// clients. One event can be sent to multiple listeners, as long as it matches the filters in those listeners. The order of
	// the array elements doesn't matter. Maximum count of event listeners among all
	// hubs is 10.
	EventListeners []*EventListener `json:"eventListeners,omitempty"`
}

// HubsClientBeginCreateOrUpdateOptions contains the optional parameters for the HubsClient.BeginCreateOrUpdate method.
type HubsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// HubsClientBeginDeleteOptions contains the optional parameters for the HubsClient.BeginDelete method.
type HubsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// HubsClientGetOptions contains the optional parameters for the HubsClient.Get method.
type HubsClientGetOptions struct {
	// placeholder for future optional parameters
}

// HubsClientListOptions contains the optional parameters for the HubsClient.List method.
type HubsClientListOptions struct {
	// placeholder for future optional parameters
}

// Keys - A class represents the access keys of the resource.
type Keys struct {
	// Connection string constructed via the primaryKey
	PrimaryConnectionString *string `json:"primaryConnectionString,omitempty"`

	// The primary access key.
	PrimaryKey *string `json:"primaryKey,omitempty"`

	// Connection string constructed via the secondaryKey
	SecondaryConnectionString *string `json:"secondaryConnectionString,omitempty"`

	// The secondary access key.
	SecondaryKey *string `json:"secondaryKey,omitempty"`
}

// LiveTraceCategory - Live trace category configuration of a Microsoft.SignalRService resource.
type LiveTraceCategory struct {
	// Indicates whether or the live trace category is enabled. Available values: true, false. Case insensitive.
	Enabled *string `json:"enabled,omitempty"`

	// Gets or sets the live trace category's name. Available values: ConnectivityLogs, MessagingLogs. Case insensitive.
	Name *string `json:"name,omitempty"`
}

// LiveTraceConfiguration - Live trace configuration of a Microsoft.SignalRService resource.
type LiveTraceConfiguration struct {
	// Gets or sets the list of category configurations.
	Categories []*LiveTraceCategory `json:"categories,omitempty"`

	// Indicates whether or not enable live trace. When it's set to true, live trace client can connect to the service. Otherwise,
	// live trace client can't connect to the service, so that you are unable to
	// receive any log, no matter what you configure in "categories". Available values: true, false. Case insensitive.
	Enabled *string `json:"enabled,omitempty"`
}

// LogSpecification - Specifications of the Logs for Azure Monitoring.
type LogSpecification struct {
	// Localized friendly display name of the log.
	DisplayName *string `json:"displayName,omitempty"`

	// Name of the log.
	Name *string `json:"name,omitempty"`
}

// ManagedIdentity - A class represent managed identities used for request and response
type ManagedIdentity struct {
	// Represents the identity type: systemAssigned, userAssigned, None
	Type *ManagedIdentityType `json:"type,omitempty"`

	// Get or set the user assigned identities
	UserAssignedIdentities map[string]*UserAssignedIdentityProperty `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; Get the principal id for the system assigned identity. Only be used in response.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; Get the tenant id for the system assigned identity. Only be used in response
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// ManagedIdentitySettings - Managed identity settings for upstream.
type ManagedIdentitySettings struct {
	// The Resource indicating the App ID URI of the target resource. It also appears in the aud (audience) claim of the issued
	// token.
	Resource *string `json:"resource,omitempty"`
}

// MetricSpecification - Specifications of the Metrics for Azure Monitoring.
type MetricSpecification struct {
	// Only provide one value for this field. Valid values: Average, Minimum, Maximum, Total, Count.
	AggregationType *string `json:"aggregationType,omitempty"`

	// The name of the metric category that the metric belongs to. A metric can only belong to a single category.
	Category *string `json:"category,omitempty"`

	// The dimensions of the metrics.
	Dimensions []*Dimension `json:"dimensions,omitempty"`

	// Localized friendly description of the metric.
	DisplayDescription *string `json:"displayDescription,omitempty"`

	// Localized friendly display name of the metric.
	DisplayName *string `json:"displayName,omitempty"`

	// Optional. If set to true, then zero will be returned for time duration where no metric is emitted/published. Ex. a metric
	// that returns the number of times a particular error code was emitted. The
	// error code may not appear often, instead of the RP publishing 0, Shoebox can auto fill in 0s for time periods where nothing
	// was emitted.
	FillGapWithZero *string `json:"fillGapWithZero,omitempty"`

	// Name of the metric.
	Name *string `json:"name,omitempty"`

	// The unit that makes sense for the metric.
	Unit *string `json:"unit,omitempty"`
}

// NameAvailability - Result of the request to check name availability. It contains a flag and possible reason of failure.
type NameAvailability struct {
	// The message of the operation.
	Message *string `json:"message,omitempty"`

	// Indicates whether the name is available or not.
	NameAvailable *bool `json:"nameAvailable,omitempty"`

	// The reason of the availability. Required if name is not available.
	Reason *string `json:"reason,omitempty"`
}

// NameAvailabilityParameters - Data POST-ed to the nameAvailability action
type NameAvailabilityParameters struct {
	// REQUIRED; The resource name to validate. e.g."my-resource-name"
	Name *string `json:"name,omitempty"`

	// REQUIRED; The resource type. Can be "Microsoft.SignalRService/SignalR" or "Microsoft.SignalRService/webPubSub"
	Type *string `json:"type,omitempty"`
}

// NetworkACL - Network ACL
type NetworkACL struct {
	// Allowed request types. The value can be one or more of: ClientConnection, ServerConnection, RESTAPI.
	Allow []*WebPubSubRequestType `json:"allow,omitempty"`

	// Denied request types. The value can be one or more of: ClientConnection, ServerConnection, RESTAPI.
	Deny []*WebPubSubRequestType `json:"deny,omitempty"`
}

// NetworkACLs - Network ACLs for the resource
type NetworkACLs struct {
	// Azure Networking ACL Action.
	DefaultAction *ACLAction `json:"defaultAction,omitempty"`

	// ACLs for requests from private endpoints
	PrivateEndpoints []*PrivateEndpointACL `json:"privateEndpoints,omitempty"`

	// Network ACL
	PublicNetwork *NetworkACL `json:"publicNetwork,omitempty"`
}

// Operation - REST API operation supported by resource provider.
type Operation struct {
	// The object that describes a operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// If the operation is a data action. (for data plane rbac)
	IsDataAction *bool `json:"isDataAction,omitempty"`

	// Name of the operation with format: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`

	// Optional. The intended executor of the operation; governs the display of the operation in the RBAC UX and the audit logs
	// UX.
	Origin *string `json:"origin,omitempty"`

	// Extra Operation properties.
	Properties *OperationProperties `json:"properties,omitempty"`
}

// OperationDisplay - The object that describes a operation.
type OperationDisplay struct {
	// The localized friendly description for the operation
	Description *string `json:"description,omitempty"`

	// The localized friendly name for the operation.
	Operation *string `json:"operation,omitempty"`

	// Friendly name of the resource provider
	Provider *string `json:"provider,omitempty"`

	// Resource type on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
}

// OperationList - Result of the request to list REST API operations. It contains a list of operations.
type OperationList struct {
	// The URL the client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`

	// List of operations supported by the resource provider.
	Value []*Operation `json:"value,omitempty"`
}

// OperationProperties - Extra Operation properties.
type OperationProperties struct {
	// An object that describes a specification.
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpoint - Private endpoint
type PrivateEndpoint struct {
	// Full qualified Id of the private endpoint
	ID *string `json:"id,omitempty"`
}

// PrivateEndpointACL - ACL for a private endpoint
type PrivateEndpointACL struct {
	// REQUIRED; Name of the private endpoint connection
	Name *string `json:"name,omitempty"`

	// Allowed request types. The value can be one or more of: ClientConnection, ServerConnection, RESTAPI.
	Allow []*WebPubSubRequestType `json:"allow,omitempty"`

	// Denied request types. The value can be one or more of: ClientConnection, ServerConnection, RESTAPI.
	Deny []*WebPubSubRequestType `json:"deny,omitempty"`
}

// PrivateEndpointConnection - A private endpoint connection to an azure resource
type PrivateEndpointConnection struct {
	// Private endpoint connection properties
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource - e.g. "Microsoft.SignalRService/SignalR"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionList - A list of private endpoint connections
type PrivateEndpointConnectionList struct {
	// Request URL that can be used to query next page of private endpoint connections. Returned when the total number of requested
	// private endpoint connections exceed maximum page size.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of the private endpoint connections
	Value []*PrivateEndpointConnection `json:"value,omitempty"`
}

// PrivateEndpointConnectionProperties - Private endpoint connection properties
type PrivateEndpointConnectionProperties struct {
	// Private endpoint
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`

	// Connection state of the private endpoint connection
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`

	// READ-ONLY; Group IDs
	GroupIDs []*string `json:"groupIds,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionsClientBeginDeleteOptions contains the optional parameters for the PrivateEndpointConnectionsClient.BeginDelete
// method.
type PrivateEndpointConnectionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsClientGetOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Get
// method.
type PrivateEndpointConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientListOptions contains the optional parameters for the PrivateEndpointConnectionsClient.List
// method.
type PrivateEndpointConnectionsClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientUpdateOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Update
// method.
type PrivateEndpointConnectionsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResource - Private link resource
type PrivateLinkResource struct {
	// Private link resource properties
	Properties *PrivateLinkResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource - e.g. "Microsoft.SignalRService/SignalR"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkResourceList - Contains a list of PrivateLinkResource and a possible link to query more results
type PrivateLinkResourceList struct {
	// The URL the client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`

	// List of PrivateLinkResource
	Value []*PrivateLinkResource `json:"value,omitempty"`
}

// PrivateLinkResourceProperties - Private link resource properties
type PrivateLinkResourceProperties struct {
	// Group Id of the private link resource
	GroupID *string `json:"groupId,omitempty"`

	// Required members of the private link resource
	RequiredMembers []*string `json:"requiredMembers,omitempty"`

	// Required private DNS zone names
	RequiredZoneNames []*string `json:"requiredZoneNames,omitempty"`

	// The list of resources that are onboarded to private link service
	ShareablePrivateLinkResourceTypes []*ShareablePrivateLinkResourceType `json:"shareablePrivateLinkResourceTypes,omitempty"`
}

// PrivateLinkResourcesClientListOptions contains the optional parameters for the PrivateLinkResourcesClient.List method.
type PrivateLinkResourcesClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServiceConnectionState - Connection state of the private endpoint connection
type PrivateLinkServiceConnectionState struct {
	// A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string `json:"actionsRequired,omitempty"`

	// The reason for approval/rejection of the connection.
	Description *string `json:"description,omitempty"`

	// Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
	Status *PrivateLinkServiceConnectionStatus `json:"status,omitempty"`
}

// Properties - A class that describes the properties of the resource
type Properties struct {
	// DisableLocalAuth Enable or disable aad auth When set as true, connection with AuthType=aad won't work.
	DisableAADAuth *bool `json:"disableAadAuth,omitempty"`

	// DisableLocalAuth Enable or disable local auth with AccessKey When set as true, connection with AccessKey=xxx won't work.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`

	// Live trace configuration of a Microsoft.SignalRService resource.
	LiveTraceConfiguration *LiveTraceConfiguration `json:"liveTraceConfiguration,omitempty"`

	// Network ACLs for the resource
	NetworkACLs *NetworkACLs `json:"networkACLs,omitempty"`

	// Enable or disable public network access. Default to "Enabled". When it's Enabled, network ACLs still apply. When it's Disabled,
	// public network access is always disabled no matter what you set in
	// network ACLs.
	PublicNetworkAccess *string `json:"publicNetworkAccess,omitempty"`

	// Resource log configuration of a Microsoft.SignalRService resource.
	ResourceLogConfiguration *ResourceLogConfiguration `json:"resourceLogConfiguration,omitempty"`

	// TLS settings for the resource
	TLS *TLSSettings `json:"tls,omitempty"`

	// READ-ONLY; The publicly accessible IP of the resource.
	ExternalIP *string `json:"externalIP,omitempty" azure:"ro"`

	// READ-ONLY; FQDN of the service instance.
	HostName *string `json:"hostName,omitempty" azure:"ro"`

	// READ-ONLY; Deprecated.
	HostNamePrefix *string `json:"hostNamePrefix,omitempty" azure:"ro"`

	// READ-ONLY; Private endpoint connections to the resource.
	PrivateEndpointConnections []*PrivateEndpointConnection `json:"privateEndpointConnections,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The publicly accessible port of the resource which is designed for browser/client side usage.
	PublicPort *int32 `json:"publicPort,omitempty" azure:"ro"`

	// READ-ONLY; The publicly accessible port of the resource which is designed for customer server side usage.
	ServerPort *int32 `json:"serverPort,omitempty" azure:"ro"`

	// READ-ONLY; The list of shared private link resources.
	SharedPrivateLinkResources []*SharedPrivateLinkResource `json:"sharedPrivateLinkResources,omitempty" azure:"ro"`

	// READ-ONLY; Version of the resource. Probably you need the same or higher version of client SDKs.
	Version *string `json:"version,omitempty" azure:"ro"`
}

// ProxyResource - The resource model definition for a ARM proxy resource. It will have everything other than required location
// and tags
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource - e.g. "Microsoft.SignalRService/SignalR"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RegenerateKeyParameters - Parameters describes the request to regenerate access keys
type RegenerateKeyParameters struct {
	// The type of access key.
	KeyType *KeyType `json:"keyType,omitempty"`
}

// Resource - The core properties of ARM resources.
type Resource struct {
	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource - e.g. "Microsoft.SignalRService/SignalR"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceInfo - A class represent a resource.
type ResourceInfo struct {
	// A class represent managed identities used for request and response
	Identity *ManagedIdentity `json:"identity,omitempty"`

	// The GEO location of the resource. e.g. West US | East US | North Central US | South Central US.
	Location *string `json:"location,omitempty"`

	// A class that describes the properties of the resource
	Properties *Properties `json:"properties,omitempty"`

	// The billing information of the resource.
	SKU *ResourceSKU `json:"sku,omitempty"`

	// Tags of the service which is a list of key value pairs that describe the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource - e.g. "Microsoft.SignalRService/SignalR"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceInfoList - Object that includes an array of resources and a possible link for next set.
type ResourceInfoList struct {
	// The URL the client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`

	// List of the resources
	Value []*ResourceInfo `json:"value,omitempty"`
}

// ResourceLogCategory - Resource log category configuration of a Microsoft.SignalRService resource.
type ResourceLogCategory struct {
	// Indicates whether or the resource log category is enabled. Available values: true, false. Case insensitive.
	Enabled *string `json:"enabled,omitempty"`

	// Gets or sets the resource log category's name. Available values: ConnectivityLogs, MessagingLogs. Case insensitive.
	Name *string `json:"name,omitempty"`
}

// ResourceLogConfiguration - Resource log configuration of a Microsoft.SignalRService resource.
type ResourceLogConfiguration struct {
	// Gets or sets the list of category configurations.
	Categories []*ResourceLogCategory `json:"categories,omitempty"`
}

// ResourceReference - Reference to a resource.
type ResourceReference struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`
}

// ResourceSKU - The billing information of the resource.
type ResourceSKU struct {
	// REQUIRED; The name of the SKU. Required.
	// Allowed values: StandardS1, FreeF1, Premium_P1
	Name *string `json:"name,omitempty"`

	// Optional, integer. The unit count of the resource. 1 by default.
	// If present, following values are allowed: Free: 1; Standard: 1,2,3,4,5,6,7,8,9,10,20,30,40,50,60,70,80,90,100; Premium:
	// 1,2,3,4,5,6,7,8,9,10,20,30,40,50,60,70,80,90,100;
	Capacity *int32 `json:"capacity,omitempty"`

	// Optional tier of this particular SKU. 'Standard' or 'Free'.
	// Basic is deprecated, use Standard instead.
	Tier *WebPubSubSKUTier `json:"tier,omitempty"`

	// READ-ONLY; Not used. Retained for future use.
	Family *string `json:"family,omitempty" azure:"ro"`

	// READ-ONLY; Not used. Retained for future use.
	Size *string `json:"size,omitempty" azure:"ro"`
}

// SKU - Describes an available sku."
type SKU struct {
	// READ-ONLY; Describes scaling information of a sku.
	Capacity *SKUCapacity `json:"capacity,omitempty" azure:"ro"`

	// READ-ONLY; The resource type that this object applies to
	ResourceType *string `json:"resourceType,omitempty" azure:"ro"`

	// READ-ONLY; The billing information of the resource.
	SKU *ResourceSKU `json:"sku,omitempty" azure:"ro"`
}

// SKUCapacity - Describes scaling information of a sku.
type SKUCapacity struct {
	// READ-ONLY; Allows capacity value list.
	AllowedValues []*int32 `json:"allowedValues,omitempty" azure:"ro"`

	// READ-ONLY; The default capacity.
	Default *int32 `json:"default,omitempty" azure:"ro"`

	// READ-ONLY; The highest permitted capacity for this resource
	Maximum *int32 `json:"maximum,omitempty" azure:"ro"`

	// READ-ONLY; The lowest permitted capacity for this resource
	Minimum *int32 `json:"minimum,omitempty" azure:"ro"`

	// READ-ONLY; The scale type applicable to the sku.
	ScaleType *ScaleType `json:"scaleType,omitempty" azure:"ro"`
}

// SKUList - The list skus operation response
type SKUList struct {
	// READ-ONLY; The URL the client should use to fetch the next page (per server side paging). It's null for now, added for
	// future use.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of skus available for the resource.
	Value []*SKU `json:"value,omitempty" azure:"ro"`
}

// ServiceSpecification - An object that describes a specification.
type ServiceSpecification struct {
	// Specifications of the Logs for Azure Monitoring.
	LogSpecifications []*LogSpecification `json:"logSpecifications,omitempty"`

	// Specifications of the Metrics for Azure Monitoring.
	MetricSpecifications []*MetricSpecification `json:"metricSpecifications,omitempty"`
}

// ShareablePrivateLinkResourceProperties - Describes the properties of a resource type that has been onboarded to private
// link service
type ShareablePrivateLinkResourceProperties struct {
	// The description of the resource type that has been onboarded to private link service
	Description *string `json:"description,omitempty"`

	// The resource provider group id for the resource that has been onboarded to private link service
	GroupID *string `json:"groupId,omitempty"`

	// The resource provider type for the resource that has been onboarded to private link service
	Type *string `json:"type,omitempty"`
}

// ShareablePrivateLinkResourceType - Describes a resource type that has been onboarded to private link service
type ShareablePrivateLinkResourceType struct {
	// The name of the resource type that has been onboarded to private link service
	Name *string `json:"name,omitempty"`

	// Describes the properties of a resource type that has been onboarded to private link service
	Properties *ShareablePrivateLinkResourceProperties `json:"properties,omitempty"`
}

// SharedPrivateLinkResource - Describes a Shared Private Link Resource
type SharedPrivateLinkResource struct {
	// Describes the properties of an existing Shared Private Link Resource
	Properties *SharedPrivateLinkResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource - e.g. "Microsoft.SignalRService/SignalR"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SharedPrivateLinkResourceList - A list of shared private link resources
type SharedPrivateLinkResourceList struct {
	// Request URL that can be used to query next page of private endpoint connections. Returned when the total number of requested
	// private endpoint connections exceed maximum page size.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of the shared private link resources
	Value []*SharedPrivateLinkResource `json:"value,omitempty"`
}

// SharedPrivateLinkResourceProperties - Describes the properties of an existing Shared Private Link Resource
type SharedPrivateLinkResourceProperties struct {
	// REQUIRED; The group id from the provider of resource the shared private link resource is for
	GroupID *string `json:"groupId,omitempty"`

	// REQUIRED; The resource id of the resource the shared private link resource is for
	PrivateLinkResourceID *string `json:"privateLinkResourceId,omitempty"`

	// The request message for requesting approval of the shared private link resource
	RequestMessage *string `json:"requestMessage,omitempty"`

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Status of the shared private link resource
	Status *SharedPrivateLinkResourceStatus `json:"status,omitempty" azure:"ro"`
}

// SharedPrivateLinkResourcesClientBeginCreateOrUpdateOptions contains the optional parameters for the SharedPrivateLinkResourcesClient.BeginCreateOrUpdate
// method.
type SharedPrivateLinkResourcesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SharedPrivateLinkResourcesClientBeginDeleteOptions contains the optional parameters for the SharedPrivateLinkResourcesClient.BeginDelete
// method.
type SharedPrivateLinkResourcesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SharedPrivateLinkResourcesClientGetOptions contains the optional parameters for the SharedPrivateLinkResourcesClient.Get
// method.
type SharedPrivateLinkResourcesClientGetOptions struct {
	// placeholder for future optional parameters
}

// SharedPrivateLinkResourcesClientListOptions contains the optional parameters for the SharedPrivateLinkResourcesClient.List
// method.
type SharedPrivateLinkResourcesClientListOptions struct {
	// placeholder for future optional parameters
}

// SignalRServiceUsage - Object that describes a specific usage of the resources.
type SignalRServiceUsage struct {
	// Current value for the usage quota.
	CurrentValue *int64 `json:"currentValue,omitempty"`

	// Fully qualified ARM resource id
	ID *string `json:"id,omitempty"`

	// The maximum permitted value for the usage quota. If there is no limit, this value will be -1.
	Limit *int64 `json:"limit,omitempty"`

	// Localizable String object containing the name and a localized value.
	Name *SignalRServiceUsageName `json:"name,omitempty"`

	// Representing the units of the usage quota. Possible values are: Count, Bytes, Seconds, Percent, CountPerSecond, BytesPerSecond.
	Unit *string `json:"unit,omitempty"`
}

// SignalRServiceUsageList - Object that includes an array of the resource usages and a possible link for next set.
type SignalRServiceUsageList struct {
	// The URL the client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`

	// List of the resource usages
	Value []*SignalRServiceUsage `json:"value,omitempty"`
}

// SignalRServiceUsageName - Localizable String object containing the name and a localized value.
type SignalRServiceUsageName struct {
	// Localized name of the usage.
	LocalizedValue *string `json:"localizedValue,omitempty"`

	// The identifier of the usage.
	Value *string `json:"value,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TLSSettings - TLS settings for the resource
type TLSSettings struct {
	// Request client certificate during TLS handshake if enabled
	ClientCertEnabled *bool `json:"clientCertEnabled,omitempty"`
}

// TrackedResource - The resource model definition for a ARM tracked top level resource.
type TrackedResource struct {
	// The GEO location of the resource. e.g. West US | East US | North Central US | South Central US.
	Location *string `json:"location,omitempty"`

	// Tags of the service which is a list of key value pairs that describe the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource - e.g. "Microsoft.SignalRService/SignalR"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// UpstreamAuthSettings - Upstream auth settings. If not set, no auth is used for upstream messages.
type UpstreamAuthSettings struct {
	// Managed identity settings for upstream.
	ManagedIdentity *ManagedIdentitySettings `json:"managedIdentity,omitempty"`

	// Upstream auth type enum.
	Type *UpstreamAuthType `json:"type,omitempty"`
}

// UsagesClientListOptions contains the optional parameters for the UsagesClient.List method.
type UsagesClientListOptions struct {
	// placeholder for future optional parameters
}

// UserAssignedIdentityProperty - Properties of user assigned identity.
type UserAssignedIdentityProperty struct {
	// READ-ONLY; Get the client id for the user assigned identity
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; Get the principal id for the user assigned identity
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`
}
