#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.


from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return _("selects the first clipboard")

    def run(self):
        if self.env["runtime"]["MemoryManager"].is_index_list_empty(
            "clipboardHistory"
        ):
            self.env["runtime"]["OutputManager"].present_text(
                _("clipboard empty"), interrupt=True
            )
            return
        self.env["runtime"]["MemoryManager"].set_first_index(
            "clipboardHistory"
        )
        clipboard = self.env["runtime"][
            "MemoryManager"
        ].get_index_list_element("clipboardHistory")
        self.env["runtime"]["OutputManager"].present_text(
            clipboard, interrupt=True
        )

    def set_callback(self, callback):
        pass
