if(CRC32C_PREFER_STATIC_LIB)
    set(CRC32C_ORIG_CMAKE_FIND_LIBRARY_SUFFIXES ${CMAKE_FIND_LIBRARY_SUFFIXES})
    if(WIN32)
        set(CMAKE_FIND_LIBRARY_SUFFIXES .a .lib ${CMAKE_FIND_LIBRARY_SUFFIXES})
    else()
        set(CMAKE_FIND_LIBRARY_SUFFIXES .a ${CMAKE_FIND_LIBRARY_SUFFIXES})
    endif()
endif()

find_path(CRC32C_INCLUDE_DIR
    NAMES crc32c/crc32c.h)
find_library(CRC32C_LIBRARY
    NAMES crc32c)

set(CRC32C_INCLUDE_DIRS ${CRC32C_INCLUDE_DIR})
set(CRC32C_LIBRARIES ${CRC32C_LIBRARY})

include(FindPackageHandleStandardArgs)

find_package_handle_standard_args(CRC32C
    REQUIRED_VARS
        CRC32C_INCLUDE_DIR
        CRC32C_LIBRARY)

mark_as_advanced(CRC32C_INCLUDE_DIR CRC32C_LIBRARY)

if(CRC32C_PREFER_STATIC_LIB)
    set(CMAKE_FIND_LIBRARY_SUFFIXES ${CRC32C_ORIG_CMAKE_FIND_LIBRARY_SUFFIXES})
    unset(CRC32C_ORIG_CMAKE_FIND_LIBRARY_SUFFIXES)
endif()
