# Generated by Django 4.2.14 on 2024-08-02 16:02

import datetime
from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import mini_buildd.config
import mini_buildd.models
import mini_buildd.util


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('mini_buildd', '0033_migrate_distribution_lintian'),
    ]

    operations = [
        migrations.AlterField(
            model_name='aptkey',
            name='key',
            field=mini_buildd.models.UnixTextField(blank=True, default='', help_text='<pre>Actual (ASCII-armored) GnuPG public key (leave ``key_id`` above blank)</pre>'),
        ),
        migrations.AlterField(
            model_name='aptkey',
            name='key_created',
            field=models.CharField(blank=True, default='', editable=False, max_length=254),
        ),
        migrations.AlterField(
            model_name='aptkey',
            name='key_expires',
            field=models.CharField(blank=True, default='', editable=False, max_length=254),
        ),
        migrations.AlterField(
            model_name='aptkey',
            name='key_fingerprint',
            field=models.CharField(blank=True, default='', editable=False, max_length=254),
        ),
        migrations.AlterField(
            model_name='aptkey',
            name='key_id',
            field=models.CharField(blank=True, default='', help_text='<pre>Key id to retrieve the actual key per key server (leave ``key`` below blank)</pre>', max_length=100, validators=[django.core.validators.MinLengthValidator(8, message='The key id, if given, must be at least 8 bytes long')]),
        ),
        migrations.AlterField(
            model_name='aptkey',
            name='key_long_id',
            field=models.CharField(blank=True, default='', editable=False, max_length=254),
        ),
        migrations.AlterField(
            model_name='aptkey',
            name='key_name',
            field=models.CharField(blank=True, default='', editable=False, max_length=254),
        ),
        migrations.AlterField(
            model_name='architectureoption',
            name='build_architecture_all',
            field=models.BooleanField(default=False, help_text='<pre>Use to build arch-all packages</pre>'),
        ),
        migrations.AlterField(
            model_name='architectureoption',
            name='optional',
            field=models.BooleanField(default=False, help_text='<pre>Don&#x27;t care if the architecture can&#x27;t be build</pre>'),
        ),
        migrations.AlterField(
            model_name='archive',
            name='url',
            field=models.URLField(default='http://ftp.debian.org/debian/', help_text='<pre>The URL of an APT archive (there must be a &#x27;dists/&#x27; infrastructure below)\n\nUse the &#x27;directory&#x27; notation with exactly one trailing slash (like &#x27;http://example.org/path/&#x27;).</pre>', max_length=512, primary_key=True, serialize=False, validators=[mini_buildd.models.RegexValidator('^.*[^/]+/$', message="Must have exactly one trailing slash (like 'http://example.org/path/')")]),
        ),
        migrations.AlterField(
            model_name='chroot',
            name='architecture',
            field=models.ForeignKey(help_text='<pre>Chroot&#x27;s architecture\n\nUsing the same arch as the host system will always work, other architectures may work if supported. An &#x27;amd64&#x27; host, for example, will also allow for architecture &#x27;i386&#x27;.\n</pre>', on_delete=django.db.models.deletion.CASCADE, to='mini_buildd.architecture'),
        ),
        migrations.AlterField(
            model_name='chroot',
            name='debootstrap_command',
            field=models.CharField(default='/usr/sbin/debootstrap', help_text='<pre>bootstrap command\n\nChange only if you need an alternate debootstrap command.\n\nFor example, ``/usr/sbin/mini-buildd-debootstrap-uname-2.6`` may be used as workaround for urold (``&lt;= lenny``) distributions.</pre>', max_length=255),
        ),
        migrations.AlterField(
            model_name='chroot',
            name='debootstrap_extra_options',
            field=models.CharField(blank=True, default='', help_text='<pre>Additional debootstrap options\n\nFor example, ``--include=foo,bar`` may be used to have these packages pre-installed in build chroots.\n</pre>', max_length=255),
        ),
        migrations.AlterField(
            model_name='chroot',
            name='personality',
            field=models.CharField(blank=True, default='', editable=False, help_text='<pre>Schroot &#x27;personality&#x27; value (see &#x27;schroot&#x27;)\n\nFor 32bit chroots running on a 64bit host, this must be &#x27;linux32&#x27;.</pre>', max_length=50),
        ),
        migrations.AlterField(
            model_name='chroot',
            name='personality_override',
            field=models.CharField(blank=True, default='', help_text='<pre>Leave empty unless you want to override the automated way (via\nan internal mapping). Please report manual overrides so it can\ngo to the default mapping.\n</pre>', max_length=50),
        ),
        migrations.AlterField(
            model_name='chroot',
            name='source',
            field=models.ForeignKey(help_text='<pre>Base source to create the chroot from; its codename must be &#x27;debootstrapable&#x27;\n\nExamples: Debian &#x27;squeeze&#x27;, Debian &#x27;wheezy&#x27;, Ubuntu &#x27;hardy&#x27;.</pre>', on_delete=django.db.models.deletion.CASCADE, to='mini_buildd.source'),
        ),
        migrations.AlterField(
            model_name='daemon',
            name='allow_emails_to',
            field=models.CharField(default=mini_buildd.config.default_allow_emails_to, help_text='<pre>Regex to allow sending emails to automatically computed addresses\n\nCurrently the &#x27;Changed-By&#x27; or &#x27;Maintainer&#x27; addresses from the changelog when this feature is enabled for the resp. repository.\n\nUse &#x27;.*&#x27; to allow all -- it&#x27;s however recommended to put this to s.th. like &#x27;.*@myemail.domain&#x27;, to avoid original package maintainers to be accidentally spammed.\n</pre>', max_length=254),
        ),
        migrations.AlterField(
            model_name='daemon',
            name='custom_archive_origin',
            field=models.CharField(blank=True, default='', help_text='<pre>Custom APT &#x27;Origin&#x27; field for repository indices</pre>', max_length=255),
        ),
        migrations.AlterField(
            model_name='daemon',
            name='email_address',
            field=mini_buildd.models.DaemonEmailField(default=mini_buildd.config.default_email_address, help_text='<pre>mini-buildd instance&#x27;s email address\n\nWill be used in:\n\n* &#x27;Name-Email&#x27; part of the GnuPG key.\n* Sender for notification email.\n</pre>', max_length=255),
        ),
        migrations.AlterField(
            model_name='daemon',
            name='event_queue_size',
            field=models.IntegerField(default=500, help_text='<pre>[Daemon must be restarted to activate this setting.]\n\nMax number of items that can be stored in the events queue</pre>'),
        ),
        migrations.AlterField(
            model_name='daemon',
            name='expire_builds_after',
            field=models.DurationField(default=datetime.timedelta(days=5), help_text='<pre>How long to keep builds and associated files\n\nFormat hint: &lt;DAYS&gt; &lt;HOURS&gt;:&lt;MINUTES&gt;:&lt;SECONDS&gt;</pre>'),
        ),
        migrations.AlterField(
            model_name='daemon',
            name='expire_events_after',
            field=models.DurationField(default=datetime.timedelta(days=336), help_text='<pre>How long to keep events and associated files (like buildlogs)\n\nFormat hint: &lt;DAYS&gt; &lt;HOURS&gt;:&lt;MINUTES&gt;:&lt;SECONDS&gt;</pre>'),
        ),
        migrations.AlterField(
            model_name='daemon',
            name='ftpd_bind',
            field=models.CharField(default='tcp:port=8067', help_text='<pre>[Daemon must be restarted to activate this setting.]\n\nFTP Server Endpoint: Twisted-style Network Server Endpoint\n\nSee: https://twistedmatrix.com/documents/current/core/howto/endpoints.html#servers\n\nNotation Examples::\n\n  &#x27;tcp6:port=8066&#x27;                                     : Unencrypted, bind on all interfaces.\n  &#x27;ssl:port=8066:privateKey=KEY_PATH:certKey=CERT_PATH&#x27;: Encrypted, bind on all interfaces.\n  &#x27;tcp6:interface=localhost:port=8066&#x27;                 : Unencrypted, bind on localhost only.</pre>', max_length=200, validators=[mini_buildd.models.ServerEndpointValidator()]),
        ),
        migrations.AlterField(
            model_name='daemon',
            name='ftpd_options',
            field=models.CharField(blank=True, default='', help_text='<pre>[Daemon must be restarted to activate this setting.]\n\nftpd handler options (see ``https://pyftpdlib.readthedocs.io/en/latest/api.html#control-connection``).\n\nFormat is ``name0=value0;name1=value1...``.\n\nSupported options: ``passive_ports``\n\nDivergent string values:\n\n``passive_ports=&lt;min_port&gt;-&lt;max_port&gt;``\n</pre>', max_length=255, validators=[mini_buildd.models.FtpdOptionsValidator()]),
        ),
        migrations.AlterField(
            model_name='daemon',
            name='gnupg_keyserver',
            field=models.CharField(default='keyserver.ubuntu.com', help_text='<pre>GnuPG keyserver to use (as fill-in helper)</pre>', max_length=200),
        ),
        migrations.AlterField(
            model_name='daemon',
            name='gnupg_template',
            field=mini_buildd.models.UnixTextField(default='Key-Type: RSA\nKey-Length: 4096\nExpire-Date: 0', help_text='<pre>Template as accepted by &#x27;gpg --batch --gen-key&#x27; (see &#x27;man gpg&#x27;)\n\nYou should not give &#x27;Name-Real&#x27; and &#x27;Name-Email&#x27;, as these are automatically added.\n\nPrepare/Remove actions will generate/remove the GnuPG key.</pre>'),
        ),
        migrations.AlterField(
            model_name='daemon',
            name='identity',
            field=models.CharField(default=mini_buildd.config.default_identity, help_text='<pre>mini-buildd&#x27;s instance identity\n\nWill be used to identify this mini-buildd instance in various places:\n\n* &#x27;Name-Real&#x27; part of the GnuPG key.\n* name of the automated keyring packages.\n* the &#x27;Origin&#x27; tag of repository indices (but this may also be overridden via &#x27;custom_archive_origin&#x27; option below).\n* to identify remotes.\n</pre>', max_length=50, validators=[mini_buildd.models.RegexValidator(regex='^[a-zA-Z0-9\\-]+$')]),
        ),
        migrations.AlterField(
            model_name='daemon',
            name='max_parallel_builds',
            field=models.IntegerField(default=mini_buildd.util.get_cpus, help_text='<pre>[Daemon must be restarted to activate this setting.]\n\nMaximum number of parallel builds</pre>'),
        ),
        migrations.AlterField(
            model_name='daemon',
            name='notify',
            field=models.ManyToManyField(blank=True, help_text='<pre>Addresses that get all notification emails unconditionally</pre>', to='mini_buildd.emailaddress'),
        ),
        migrations.AlterField(
            model_name='dirchroot',
            name='union_type',
            field=models.IntegerField(choices=[(0, 'aufs'), (1, 'overlayfs'), (2, 'unionfs'), (3, 'overlay')], default=3, help_text='<pre>See &#x27;man 5 schroot.conf&#x27;\n</pre>'),
        ),
        migrations.AlterField(
            model_name='distribution',
            name='add_depends',
            field=models.CharField(blank=True, help_text='<pre>Add extra (package) dependencies</pre>', max_length=255),
        ),
        migrations.AlterField(
            model_name='distribution',
            name='autopkgtest_mode',
            field=models.IntegerField(choices=[(0, 'DISABLED'), (1, 'IGNORE'), (2, 'ERRFAIL'), (3, 'WARNFAIL')], default=0, help_text='<pre>Mode to control if a check should prevent package installation (for non-experimental suites).\n\n&#x27;DISABLED&#x27; (Don&#x27;t run check), &#x27;IGNORE&#x27; (Run check but ignore results), &#x27;ERRFAIL&#x27; (Run check and fail on errors), &#x27;WARNFAIL&#x27; (Run check and fail on warnings)</pre>'),
        ),
        migrations.AlterField(
            model_name='distribution',
            name='chroot_setup_script',
            field=mini_buildd.models.UnixTextField(blank=True, default='', help_text='<pre>Custom script that will be run via sbuild&#x27;s ``--chroot-setup-command``\n\nBe sure to provide a proper shebang like ``#!/bin/sh -e``.\n\nNote that some predefined script blocks to choose from are available (see &#x27;sbuild_setup_blocks&#x27;), which might suite your needs already.\n\nExample:\n---\n#!/bin/sh -e\n\necho &quot;I: Foo bar...&quot;\n---\n</pre>', validators=[mini_buildd.models.ShebangValidator()]),
        ),
        migrations.AlterField(
            model_name='distribution',
            name='deb_build_options',
            field=models.CharField(blank=True, help_text='<pre>Set extra build options\n\nValues to add to environment variable ``DEB_BUILD_OPTIONS`` used when building packages. See\n\n* ``https://www.debian.org/doc/debian-policy/ch-source.html#debian-rules-and-deb-build-options`` and\n* ``https://lists.debian.org/debian-devel/2015/12/msg00262.html&#x27;&gt;Debian dbgsym announcement``\n\nfor valid options. Value may be overridden by the resp. user upload option.\n\nOption ``noddebs`` is useful for Ubuntu distributions that for\nsome reason create their automated debug packages with file appendix\n&#x27;ddeb&#x27;, as (see ``https://bugs.debian.org/cgi-bin/bugreport.cgi?bug=730572``) reprepo fails on them.\n\nExample: Never build automatic debug packages (Ubuntu bionic, cosmic):\n\nnoddebs</pre>', max_length=255),
        ),
        migrations.AlterField(
            model_name='distribution',
            name='deb_build_profiles',
            field=models.CharField(blank=True, help_text='<pre>Set extra build profiles\n\nContents of DEB_BUILD_PROFILES environment for building (see ``https://wiki.debian.org/BuildProfileSpec``).\nValue may be overridden by the resp. user upload option.</pre>', max_length=255),
        ),
        migrations.AlterField(
            model_name='distribution',
            name='internal_apt_priority',
            field=models.IntegerField(default=1, help_text='<pre>Priority for internal APT sources in builds\n\nThe default is 1, which means you will only build against newer packages in our own repositories in case it&#x27;s really needed by the package&#x27;s build dependencies.This is the recommended behaviour, producing sparse dependencies.\n\nHowever, some packages with incorrect build dependencies might break anyway, while they would work fine when just build against the newest version available.\n\nYou may still solve this on a per-package basis, using the resp. upload option via changelog. However, in case you don&#x27;t care about sparse dependencies in this distribution in general, you can pimp the internal priority up here.\n\nExamples: 1=sparse dependencies, 500=always build against newer internal packages</pre>'),
        ),
        migrations.AlterField(
            model_name='distribution',
            name='lintian_extra_options',
            field=models.CharField(default='--info --suppress-tags bad-distribution-in-changes-file,bogus-mail-host,bogus-mail-host-in-debian-changelog', help_text='<pre>Lintian options to always use\n\nUseful examples (with hints in what lintian versions they are applicable):\n\n * &#x27;--info&#x27; (all): Show versatile explanations in buildlogs.\n * &#x27;--suppress-tags &lt;tag&gt;&#x27; (&gt;= 2.3.0, &gt;= Debian 6 squeeze): Suppress false-positive/too noisy tags.\n   * &#x27;bad-distribution-in-changes-file&#x27; (all): Lintian does not know mini-buildd-style distributions.\n   * &#x27;bogus-mail-host[-in-debian-changelog]&#x27; (&gt;= 2.104.0, &gt;= Debian 11 bullseye, &gt;= Ubuntu 21.10 impish): Not really mandatory for mini-buildd -- but lintian deems them errors, making lintian always fail.\n</pre>', max_length=512),
        ),
        migrations.AlterField(
            model_name='distribution',
            name='lintian_mode',
            field=models.IntegerField(choices=[(0, 'DISABLED'), (1, 'IGNORE'), (2, 'ERRFAIL'), (3, 'WARNFAIL')], default=2, help_text='<pre>Mode to control if a check should prevent package installation (for non-experimental suites).\n\n&#x27;DISABLED&#x27; (Don&#x27;t run check), &#x27;IGNORE&#x27; (Run check but ignore results), &#x27;ERRFAIL&#x27; (Run check and fail on errors), &#x27;WARNFAIL&#x27; (Run check and fail on warnings)</pre>'),
        ),
        migrations.AlterField(
            model_name='distribution',
            name='lintian_warnfail_options',
            field=models.CharField(default='--fail-on error,warning', help_text='<pre>Lintian options to use for &#x27;WARNFAIL&#x27; mode\n\nHumbly up-to-date variants of lintian all work with the default (&#x27;--fail-on error,warning&#x27;).\n\nYou may set exception here for some older releases if need be.\n\nFYI, lintian &#x27;warnfail&#x27; option history:\n * Debian (stretch)  2.5.50: Deprecates &#x27;--fail-on-warnings&#x27;.\n * Debian (bullseye) 2.16.0: Drops support for &#x27;--fail-on-warnings&#x27; (NO WAY TO DO &#x27;WARNFAIL&#x27;).\n * Debian (bullseye) 2.77.0: Introduces &#x27;--fail-on&#x27;.\n * Ubuntu (focal)    2.62.0: Release that does not have either (NO WAY TO DO &#x27;WARNFAIL&#x27;).\n * Ubuntu (groovy)   2.89.0: 1st release &gt;= 2.77.\nConclusion:\n * Debian &gt;=bullseye needs &#x27;--fail-on error,warning&#x27;, below needs &#x27;--fail-on-warnings&#x27;.\n * Ubuntu &gt;=groovy needs &#x27;--fail-on error,warning&#x27;, below needs &#x27;--fail-on-warnings&#x27;.\n * Ubuntu focal needs &#x27;&#x27; (just can&#x27;t do &#x27;WARNFAIL&#x27;).\n</pre>', max_length=512),
        ),
        migrations.AlterField(
            model_name='distribution',
            name='piuparts_mode',
            field=models.IntegerField(choices=[(0, 'DISABLED'), (1, 'IGNORE'), (2, 'ERRFAIL'), (3, 'WARNFAIL')], default=0, help_text='<pre>EXPERIMENTAL: Mode to control if a check should prevent package installation (for non-experimental suites).\n\n&#x27;DISABLED&#x27; (Don&#x27;t run check), &#x27;IGNORE&#x27; (Run check but ignore results), &#x27;ERRFAIL&#x27; (Run check and fail on errors), &#x27;WARNFAIL&#x27; (Run check and fail on warnings)\n\nEXPERIMENTAL: All modes but &#x27;Run check and ignore errors&#x27; are currently ignored, and even that might not be called correctly.\n</pre>'),
        ),
        migrations.AlterField(
            model_name='distribution',
            name='sbuild_config_blocks',
            field=models.CharField(blank=True, help_text='<pre>Ordered sbuild config blocks (space-separated)\n\nDefault if not given: set-default-path ccache\n\nAvailable blocks:\n\nset-default-path: [default] Explicitly set $path (to sbuild&#x27;s default value), so later config blocks may add to it\nccache          : [default] Update $path and $$build environment to support ccache</pre>', max_length=255, validators=[mini_buildd.models.SbuildConfigBlocksValidator()]),
        ),
        migrations.AlterField(
            model_name='distribution',
            name='sbuild_setup_blocks',
            field=models.CharField(blank=True, help_text='<pre>Ordered sbuild setup blocks (space-separated)\n\nDefault if not given: apt-setup apt-update ccache eatmydata\n\nAvailable blocks:\n\napt-setup                : [default] Sets up APT for buildrequest (APT keys, optional https, sources and preferences)\napt-update               : [default] Update APT\nccache                   : [default] Installs ccache (together with the &#x27;ccache&#x27; config block, this enables ccache for builds on the same instance)\neatmydata                : [default] Install eatmydata and activate via LD_PRELOAD when possible (may improve speed)\nshow-sbuildrc            : [extra] Print generated &#x27;.sbuildrc&#x27; (informational only)\napt-key-binary           : [extra] Convert APT keys to binary (needed for Debian &lt;= jessie, Ubuntu &lt;= yakketti) -- place between ``apt-setup`` and ``apt-update``\napt-key-add              : [extra] Add APT keys via deprecated ``apt-key add`` (needed for Debian &lt;= squeeze) -- place between ``apt-setup`` and ``apt-update``\napt-no-check-valid-until : [extra] Set APT option &quot;Acquire::Check-Valid-Until false&quot; (needed when Release files are expired) -- place before ``apt-setup``\napt-allow-unauthenticated: [extra] Set APT option &quot;APT::Get::AllowUnauthenticated true&quot; (needed when APT keys are expired) -- place before ``apt-setup``\napt-force-yes            : [extra] Set APT option &quot;APT::Get::Force-Yes true&quot; (compat(urold)) -- place before ``apt-setup``\napt-no-cache             : [extra] Set APT option &quot;Acquire::http::No-Cache true&quot; (compat(urold)) -- place before ``apt-setup``\napt-no-pipelining        : [extra] Set APT option &quot;Acquire::http::Pipeline-Depth 0&quot; (compat(urold)) -- place before ``apt-setup``\napt-clear                : [extra] Try to clear any redundant APT data in ``/var/`` (experimental: can make APT work again if stuck)\nbash-devices             : [extra] Fixup /dev/fd|stdin|stdout|stderr. Needed for *building* bash only. See https://bugs.debian.org/cgi-bin/bugreport.cgi?bug=327477 (compat(bash &lt; 3.0-17 (2005))\nschroot-shm              : [extra] Fixup /dev/shm mount. See https://bugs.debian.org/cgi-bin/bugreport.cgi?bug=728096 (compat(schroot &lt; 1.6.10-3))\nsun-java6-license        : [extra] Accept sun-java6 licence (debconf) so we can build-depend on it (sun-java is no longer part of Debian since 2011)</pre>', max_length=255, validators=[mini_buildd.models.SbuildSetupBlocksValidator()]),
        ),
        migrations.AlterField(
            model_name='distribution',
            name='sbuildrc_snippet',
            field=mini_buildd.models.UnixTextField(blank=True, default='', help_text='<pre>Custom perl snippet to be added to ``.sbuildrc`` for each build\n\nNote that some predefined config blocks to choose from are available (see &#x27;sbuild_config_blocks&#x27;), which might suite your needs already.\n\nYou may use these placeholders:\n\n* ``%LIBDIR%``: Per-chroot persistent dir; may be used for data that should persist between builds (caches, ...).\n\nExample:\n---\n$build_environment = { &#x27;MY_FOO_BAR&#x27; =&gt; &#x27;%LIBDIR%/my-foo-bar&#x27; };\n---\n</pre>'),
        ),
        migrations.AlterField(
            model_name='layout',
            name='default_version',
            field=models.CharField(default='~%IDENTITY%%CODEVERSION%+1', help_text='<pre>Version string to append to the original version for automated ports\n\nYou may use these placeholders:\n* %IDENTITY%: Repository identity (see &#x27;Repository&#x27;)\n* %CODEVERSION%: Numerical base distribution version (see &#x27;Source&#x27;)</pre>', max_length=100),
        ),
        migrations.AlterField(
            model_name='layout',
            name='experimental_default_version',
            field=models.CharField(default='~%IDENTITY%%CODEVERSION%+0', help_text='<pre>Like &#x27;default version&#x27;, but for suites flagged &#x27;experimental&#x27;</pre>', max_length=30),
        ),
        migrations.AlterField(
            model_name='layout',
            name='experimental_mandatory_version_regex',
            field=models.CharField(default='~%IDENTITY%%CODEVERSION%\\+0', help_text='<pre>Like &#x27;mandatory version&#x27;, but for suites flagged &#x27;experimental&#x27;</pre>', max_length=100),
        ),
        migrations.AlterField(
            model_name='layout',
            name='mandatory_version_regex',
            field=models.CharField(default='~%IDENTITY%%CODEVERSION%\\+[1-9]', help_text='<pre>Mandatory version regex (you may use the same placeholders as for &#x27;default version&#x27;)</pre>', max_length=100),
        ),
        migrations.AlterField(
            model_name='layout',
            name='meta_distributions',
            field=models.JSONField(blank=True, default=dict, help_text='<pre>Support METAs alone as distribution identifier\n\nMeta distribution identifiers should be unique across all repositories; usually, a layout with meta distributions should only be used by at most one repository.\n\nExample:\n\n{&#x27;unstable&#x27;: &#x27;sid-unstable&#x27;, &#x27;experimental&#x27;=&#x27;sid-experimental&#x27;}\n\n(See standard layout &#x27;Debian Developer&#x27;): allows upload/testing of packages (to unstable,experimental,..) aimed for Debian.</pre>'),
        ),
        migrations.AlterField(
            model_name='looplvmchroot',
            name='loop_size',
            field=models.IntegerField(default=100, help_text='<pre>Loop device file size in GB</pre>'),
        ),
        migrations.AlterField(
            model_name='lvmchroot',
            name='snapshot_size',
            field=models.IntegerField(default=4, help_text='<pre>Snapshot device file size in GB</pre>'),
        ),
        migrations.AlterField(
            model_name='lvmchroot',
            name='volume_group',
            field=models.CharField(default='auto', help_text='<pre>Give a pre-existing LVM volume group name. Just leave it on &#x27;auto&#x27; for loop lvm chroots.</pre>', max_length=80),
        ),
        migrations.AlterField(
            model_name='prioritysource',
            name='priority',
            field=models.IntegerField(default=1, help_text='<pre>A APT pin priority value (see &#x27;man apt_preferences&#x27;; examples: 1=not automatic, 1001=downgrade)</pre>'),
        ),
        migrations.AlterField(
            model_name='remote',
            name='http',
            field=models.CharField(default='tcp:host=YOUR_REMOTE_HOST:port=8066', help_text='<pre>HTTP Remote Endpoint: Twisted-style Network Client Endpoint\n\nSee: https://twistedmatrix.com/documents/current/core/howto/endpoints.html#clients\n\nNotation Examples::\n\n  &#x27;tcp:host=localhost:port=8066&#x27;: Connect to localhost, unencrypted.\n  &#x27;tls:host=localhost:port=8066&#x27;: Connect to localhost, encrypted.\n  &#x27;http://localhost:8066&#x27;       : Extra URL-style syntax (prefer twisted-style in saved configs, though).\n  &#x27;localhost:8066&#x27;              : Compatibility host:port syntax (don&#x27;t use -- might eventually go away).</pre>', max_length=255, primary_key=True, serialize=False),
        ),
        migrations.AlterField(
            model_name='remote',
            name='key',
            field=mini_buildd.models.UnixTextField(blank=True, default='', help_text='<pre>Actual (ASCII-armored) GnuPG public key (leave ``key_id`` above blank)</pre>'),
        ),
        migrations.AlterField(
            model_name='remote',
            name='key_created',
            field=models.CharField(blank=True, default='', editable=False, max_length=254),
        ),
        migrations.AlterField(
            model_name='remote',
            name='key_expires',
            field=models.CharField(blank=True, default='', editable=False, max_length=254),
        ),
        migrations.AlterField(
            model_name='remote',
            name='key_fingerprint',
            field=models.CharField(blank=True, default='', editable=False, max_length=254),
        ),
        migrations.AlterField(
            model_name='remote',
            name='key_id',
            field=models.CharField(blank=True, default='', help_text='<pre>Key id to retrieve the actual key per key server (leave ``key`` below blank)</pre>', max_length=100, validators=[django.core.validators.MinLengthValidator(8, message='The key id, if given, must be at least 8 bytes long')]),
        ),
        migrations.AlterField(
            model_name='remote',
            name='key_long_id',
            field=models.CharField(blank=True, default='', editable=False, max_length=254),
        ),
        migrations.AlterField(
            model_name='remote',
            name='key_name',
            field=models.CharField(blank=True, default='', editable=False, max_length=254),
        ),
        migrations.AlterField(
            model_name='remote',
            name='wake_command',
            field=models.CharField(blank=True, default='', help_text='<pre>Command to wake this remote (for example ``/usr/bin/wakeonlan -i DEST_IP MAC``)</pre>', max_length=255),
        ),
        migrations.AlterField(
            model_name='repository',
            name='allow_unauthenticated_uploads',
            field=models.BooleanField(default=False, help_text='<pre>Allow unauthenticated user uploads</pre>'),
        ),
        migrations.AlterField(
            model_name='repository',
            name='extra_uploader_keyrings',
            field=mini_buildd.models.UnixTextField(blank=True, help_text='<pre>Extra keyrings, line by line, to be allowed as uploaders (in addition to configured django users)\n\nExample:\n---\n# Allow Debian maintainers (must install the &#x27;debian-keyring&#x27; package)\n/usr/share/keyrings/debian-keyring.gpg\n# Allow from some local keyring file\n/etc/my-schlingels.gpg\n---</pre>'),
        ),
        migrations.AlterField(
            model_name='repository',
            name='identity',
            field=models.CharField(default='test', help_text='<pre>The id of the reprepro repository, placed in &#x27;repositories/&lt;ID&gt;&#x27;\n\nIt can also be used in &#x27;version enforcement string&#x27; (true for the default layout) -- in this context, it plays the same role as the well-known &#x27;bpo&#x27; version string from Debian backports.</pre>', max_length=50, primary_key=True, serialize=False, validators=[mini_buildd.models.RegexValidator(regex='^[a-z0-9]+$')]),
        ),
        migrations.AlterField(
            model_name='repository',
            name='notify',
            field=models.ManyToManyField(blank=True, help_text='<pre>Addresses that get all notification emails unconditionally</pre>', to='mini_buildd.emailaddress'),
        ),
        migrations.AlterField(
            model_name='repository',
            name='notify_changed_by',
            field=models.BooleanField(default=False, help_text='<pre>Notify the address in the &#x27;Changed-By&#x27; field of the uploaded changes file</pre>'),
        ),
        migrations.AlterField(
            model_name='repository',
            name='notify_maintainer',
            field=models.BooleanField(default=False, help_text='<pre>Notify the address in the &#x27;Maintainer&#x27; field of the uploaded changes file</pre>'),
        ),
        migrations.AlterField(
            model_name='repository',
            name='reprepro_morguedir',
            field=models.BooleanField(default=False, help_text='<pre>Move files deleted from repo pool to &#x27;morguedir&#x27; (see reprepro)</pre>'),
        ),
        migrations.AlterField(
            model_name='source',
            name='apt_keys',
            field=models.ManyToManyField(blank=True, help_text='<pre>At least one APT key this source&#x27;s &#x27;Release&#x27; file is signed with\n\nHint: If you leave this empty and run &#x27;check&#x27; on it, you will get a message listing all signer keys.</pre>', to='mini_buildd.aptkey'),
        ),
        migrations.AlterField(
            model_name='source',
            name='architectures',
            field=models.ManyToManyField(blank=True, editable=False, to='mini_buildd.architecture'),
        ),
        migrations.AlterField(
            model_name='source',
            name='archives',
            field=models.ManyToManyField(blank=True, editable=False, to='mini_buildd.archive'),
        ),
        migrations.AlterField(
            model_name='source',
            name='check_valid_until',
            field=models.BooleanField(default=True, help_text='<pre>Fail if outdated (via ``Valid-Until`` field)\n\nSome sources have a ``Valid-Until`` field that is no longer updated. Disable this if you really still want to use it anyway.\n\nWhen disabled, this will 1st ignore mini-buildd&#x27;s own &#x27;Valid-Until check&#x27; and 2nd, create APT lines for this source with the ``[check-valid-until=no]`` option.\n\nNote: For ``jessie`` or older (where this APT line option does not work), ``apt-no-check-valid-until`` sbuild setup block is still needed.</pre>'),
        ),
        migrations.AlterField(
            model_name='source',
            name='codename',
            field=models.CharField(default='sid', help_text='<pre>The name of the directory below ``dists/`` in archives this source refers to (this is also the 3rd part of an APT line)\n\nAlso the exact string of the ``Codename`` field of the resp, Release file (unless overwritten in ``extra_identifiers``).</pre>', max_length=60),
        ),
        migrations.AlterField(
            model_name='source',
            name='codeversion',
            field=models.CharField(blank=True, default='', editable=False, max_length=50),
        ),
        migrations.AlterField(
            model_name='source',
            name='codeversion_override',
            field=models.CharField(blank=True, default='', help_text='<pre>Permanently override with a static ``codeversion`` value\n\nLeave blank to make ``codeversion`` be guessed every time the source is checked.\n\nThe ``codeversion`` (like &#x27;12&#x27; for ``Debian bookworm``) is relevant for base sources only, to be used for version restrictions.</pre>', max_length=50),
        ),
        migrations.AlterField(
            model_name='source',
            name='components',
            field=models.ManyToManyField(blank=True, editable=False, to='mini_buildd.component'),
        ),
        migrations.AlterField(
            model_name='source',
            name='extra_identifiers',
            field=models.JSONField(blank=True, default=dict, help_text='<pre>Extra release file identifiers (JSON dict)\n\nSome sources need additional fields (same as in a Release file) to further specify this source. These are also later used to pin the source via APT.\n\nMost likely candidates are ``Codename``, ``Suite``, ``Archive``, ``Version`` or ``Label``.\n\nFor some sources, ``Codename`` (as we use it above) does not match resp. value as given in the Release file.\nWhen ``Codename`` is overridden in this manner, be sure to also add one further flag to identify the source -- else apt pinning later would likely not be unambiguous.\nReal world examples that need this extra handling are ``Debian Security`` (``buster`` or older), ``Ubuntu Security and Backports``:\n\n{&#x27;Codename&#x27;: &#x27;stretch&#x27;, &#x27;Label&#x27;: &#x27;Debian-Security&#x27;}\n{&#x27;Codename&#x27;: &#x27;bionic&#x27;, &#x27;Suite&#x27;: &#x27;bionic-backports&#x27;}</pre>', validators=[mini_buildd.models.ForbiddenKeysValidator(['Origin'])]),
        ),
        migrations.AlterField(
            model_name='source',
            name='origin',
            field=models.CharField(default='Debian', help_text='<pre>The exact string of the &#x27;Origin&#x27; field of the resp. Release file</pre>', max_length=60),
        ),
        migrations.AlterField(
            model_name='source',
            name='remove_from_component',
            field=models.CharField(blank=True, default='', help_text='<pre>Prefix to be removed from component\n\nSome (actually, we only know of ``Debian Security``) sources have weird ``Components`` that need to be fixed to work with mini-buildd.\n\nFor example, ``Debian Security`` needs ``updates/``.</pre>', max_length=100),
        ),
        migrations.AlterField(
            model_name='suite',
            name='name',
            field=models.CharField(help_text='<pre>A suite name (usually s.th. like &#x27;experimental&#x27;, &#x27;unstable&#x27;, &#x27;testing&#x27; or &#x27;stable&#x27;)</pre>', max_length=100, validators=[mini_buildd.models.RegexValidator(regex='^[a-z]+$')]),
        ),
        migrations.AlterField(
            model_name='suiteoption',
            name='build_keyring_package',
            field=models.BooleanField(default=False, help_text='<pre>Build keyring package for this suite (i.e., when the resp. Repository action is called)</pre>'),
        ),
        migrations.AlterField(
            model_name='suiteoption',
            name='but_automatic_upgrades',
            field=models.BooleanField(default=True, help_text='<pre>Include &#x27;ButAutomaticUpgrades&#x27; in the Release file</pre>'),
        ),
        migrations.AlterField(
            model_name='suiteoption',
            name='experimental',
            field=models.BooleanField(default=False, help_text='<pre>Whether this suite is flagged experimental\n\nExperimental suites must be uploadable and must not migrate.\nAlso, the packager treats failing extra QA checks (like lintian) as non-lethal, and will install anyway.</pre>'),
        ),
        migrations.AlterField(
            model_name='suiteoption',
            name='migrates_to',
            field=models.ForeignKey(blank=True, help_text='<pre>Give another suite where packages may migrate to (you may need to save this &#x27;blank&#x27; first before you see choices here)</pre>', null=True, on_delete=django.db.models.deletion.CASCADE, to='mini_buildd.suiteoption'),
        ),
        migrations.AlterField(
            model_name='suiteoption',
            name='not_automatic',
            field=models.BooleanField(default=True, help_text='<pre>Include &#x27;NotAutomatic&#x27; in the Release file</pre>'),
        ),
        migrations.AlterField(
            model_name='suiteoption',
            name='rollback',
            field=models.IntegerField(default=0, help_text='<pre>Keep this number of old versions in this suite</pre>'),
        ),
        migrations.AlterField(
            model_name='suiteoption',
            name='uploadable',
            field=models.BooleanField(default=True, help_text='<pre>Whether this suite should accept user uploads</pre>'),
        ),
        migrations.AlterField(
            model_name='uploader',
            name='key',
            field=mini_buildd.models.UnixTextField(blank=True, default='', help_text='<pre>Actual (ASCII-armored) GnuPG public key (leave ``key_id`` above blank)</pre>'),
        ),
        migrations.AlterField(
            model_name='uploader',
            name='key_created',
            field=models.CharField(blank=True, default='', editable=False, max_length=254),
        ),
        migrations.AlterField(
            model_name='uploader',
            name='key_expires',
            field=models.CharField(blank=True, default='', editable=False, max_length=254),
        ),
        migrations.AlterField(
            model_name='uploader',
            name='key_fingerprint',
            field=models.CharField(blank=True, default='', editable=False, max_length=254),
        ),
        migrations.AlterField(
            model_name='uploader',
            name='key_id',
            field=models.CharField(blank=True, default='', help_text='<pre>Key id to retrieve the actual key per key server (leave ``key`` below blank)</pre>', max_length=100, validators=[django.core.validators.MinLengthValidator(8, message='The key id, if given, must be at least 8 bytes long')]),
        ),
        migrations.AlterField(
            model_name='uploader',
            name='key_long_id',
            field=models.CharField(blank=True, default='', editable=False, max_length=254),
        ),
        migrations.AlterField(
            model_name='uploader',
            name='key_name',
            field=models.CharField(blank=True, default='', editable=False, max_length=254),
        ),
        migrations.AlterField(
            model_name='uploader',
            name='user',
            field=models.OneToOneField(editable=False, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
    ]
