/* SPDX-FileCopyrightText: 2003 - Paolo Maggi <paolo.maggi@polito.it>
 * SPDX-FileCopyrightText: 2023 - Sébastien Wilmet <swilmet@gnome.org>
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#pragma once

#if !defined (GTK_SOURCE_H_INSIDE) && !defined (GTK_SOURCE_COMPILATION)
#error "Only <gtksourceview/gtksource.h> can be included directly."
#endif

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define GTK_SOURCE_TYPE_STYLE (gtk_source_style_get_type ())

typedef struct _GtkSourceStyle GtkSourceStyle;

/**
 * GtkSourceStyle:
 * @foreground_color: Equivalent to #GtkTextTag:foreground-rgba.
 * @background_color: Equivalent to #GtkTextTag:background-rgba.
 * @underline_color: Equivalent to #GtkTextTag:underline-rgba.
 * @scale: Equivalent to #GtkTextTag:scale.
 * @underline: Equivalent to #GtkTextTag:underline.
 * @italic: For #GtkTextTag:style.
 * @bold: For #GtkTextTag:weight.
 * @strikethrough: Equivalent to #GtkTextTag:strikethrough.
 * @use_foreground_color: Whether @foreground_color can be taken into account.
 * @use_background_color: Whether @background_color can be taken into account.
 * @use_underline_color: Whether @underline_color can be taken into account.
 * @use_scale: Whether @scale can be taken into account.
 * @use_underline: Whether @underline can be taken into account.
 * @use_italic: Whether @italic can be taken into account.
 * @use_bold: Whether @bold can be taken into account.
 * @use_strikethrough: Whether @strikethrough can be taken into account.
 *
 * Before using the value of a certain field, check the boolean value of the
 * corresponding "`use_`" field.
 *
 * Since: 299.2
 */
struct _GtkSourceStyle
{
	/*< private >*/
	grefcount ref_count;

	/*< public >*/
	GdkRGBA foreground_color;
	GdkRGBA background_color;
	GdkRGBA underline_color;
	gdouble scale;
	PangoUnderline underline;
	guint italic : 1;
	guint bold : 1;
	guint strikethrough : 1;

	guint use_foreground_color : 1;
	guint use_background_color : 1;
	guint use_underline_color : 1;
	guint use_scale : 1;
	guint use_underline : 1;
	guint use_italic : 1;
	guint use_bold : 1;
	guint use_strikethrough : 1;
};

G_MODULE_EXPORT
GType			gtk_source_style_get_type	(void) G_GNUC_CONST;

G_MODULE_EXPORT
GtkSourceStyle *	gtk_source_style_new		(void);

G_MODULE_EXPORT
GtkSourceStyle *	gtk_source_style_ref		(GtkSourceStyle *style);

G_MODULE_EXPORT
void			gtk_source_style_unref		(GtkSourceStyle *style);

G_MODULE_EXPORT
void			gtk_source_style_apply		(GtkSourceStyle *style,
							 GtkTextTag     *tag);

G_END_DECLS
