/* Autogenerated: ECCKiila https://gitlab.com/nisec/ecckiila */
/*-
 * MIT License
 * 
 * Copyright (c) 2020 Luis Rivera-Zamarripa, Jesús-Javier Chi-Domínguez, Billy Bob Brumley
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
#if defined(__SIZEOF_INT128__) && !defined(PEDANTIC)

#include <stdint.h>
#include <string.h>
#define LIMB_BITS 64
#define LIMB_CNT 4
/* Field elements */
typedef uint64_t fe_t[LIMB_CNT];
typedef uint64_t limb_t;

#ifdef OPENSSL_NO_ASM
#define FIAT_ID_GOSTR3410_2001_CRYPTOPRO_B_PARAMSET_NO_ASM
#endif

#define fe_copy(d, s) memcpy(d, s, sizeof(fe_t))
#define fe_set_zero(d) memset(d, 0, sizeof(fe_t))

/* Projective points */
typedef struct {
    fe_t X;
    fe_t Y;
    fe_t Z;
} pt_prj_t;

/* Affine points */
typedef struct {
    fe_t X;
    fe_t Y;
} pt_aff_t;

/* BEGIN verbatim fiat code https://github.com/mit-plv/fiat-crypto */
/*-
 * MIT License
 *
 * Copyright (c) 2020 the fiat-crypto authors (see the AUTHORS file)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

/* Autogenerated: word_by_word_montgomery --static --use-value-barrier id_GostR3410_2001_CryptoPro_B_ParamSet 64 '2^255 + 3225' */
/* curve description: id_GostR3410_2001_CryptoPro_B_ParamSet */
/* machine_wordsize = 64 (from "64") */
/* requested operations: (all) */
/* m = 0x8000000000000000000000000000000000000000000000000000000000000c99 (from "2^255 + 3225") */
/*                                                                    */
/* NOTE: In addition to the bounds specified above each function, all */
/*   functions synthesized for this Montgomery arithmetic require the */
/*   input to be strictly less than the prime modulus (m), and also   */
/*   require the input to be in the unique saturated representation.  */
/*   All functions also ensure that these two properties are true of  */
/*   return values.                                                   */
/*  */
/* Computed values: */
/* eval z = z[0] + (z[1] << 64) + (z[2] << 128) + (z[3] << 192) */
/* bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) + (z[28] << 224) + (z[29] << 232) + (z[30] << 240) + (z[31] << 248) */

#include <stdint.h>
typedef unsigned char fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1;
typedef signed char fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_int1;
typedef signed __int128 fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_int128;
typedef unsigned __int128 fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint128;

#if (-1 & 3) != 3
#error "This code only works on a two's complement system"
#endif

#if !defined(FIAT_ID_GOSTR3410_2001_CRYPTOPRO_B_PARAMSET_NO_ASM) && \
    (defined(__GNUC__) || defined(__clang__))
static __inline__ uint64_t
fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_value_barrier_u64(uint64_t a) {
    __asm__("" : "+r"(a) : /* no inputs */);
    return a;
}
#else
#define fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_value_barrier_u64(x) (x)
#endif

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64 is an addition with carry.
 * Postconditions:
 *   out1 = (arg1 + arg2 + arg3) mod 2^64
 *   out2 = ⌊(arg1 + arg2 + arg3) / 2^64⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffffffffffff]
 *   arg3: [0x0 ~> 0xffffffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffffffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(
    uint64_t *out1, fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 *out2,
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 arg1, uint64_t arg2,
    uint64_t arg3) {
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint128 x1;
    uint64_t x2;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x3;
    x1 = ((arg1 + (fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint128)arg2) +
          arg3);
    x2 = (uint64_t)(x1 & UINT64_C(0xffffffffffffffff));
    x3 = (fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1)(x1 >> 64);
    *out1 = x2;
    *out2 = x3;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u64 is a subtraction with borrow.
 * Postconditions:
 *   out1 = (-arg1 + arg2 + -arg3) mod 2^64
 *   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^64⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffffffffffff]
 *   arg3: [0x0 ~> 0xffffffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffffffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u64(
    uint64_t *out1, fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 *out2,
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 arg1, uint64_t arg2,
    uint64_t arg3) {
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_int128 x1;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_int1 x2;
    uint64_t x3;
    x1 = ((arg2 - (fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_int128)arg1) -
          arg3);
    x2 = (fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_int1)(x1 >> 64);
    x3 = (uint64_t)(x1 & UINT64_C(0xffffffffffffffff));
    *out1 = x3;
    *out2 = (fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1)(0x0 - x2);
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64 is a multiplication, returning the full double-width result.
 * Postconditions:
 *   out1 = (arg1 * arg2) mod 2^64
 *   out2 = ⌊arg1 * arg2 / 2^64⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0xffffffffffffffff]
 *   arg2: [0x0 ~> 0xffffffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffffffffffff]
 *   out2: [0x0 ~> 0xffffffffffffffff]
 */
static void fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(
    uint64_t *out1, uint64_t *out2, uint64_t arg1, uint64_t arg2) {
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint128 x1;
    uint64_t x2;
    uint64_t x3;
    x1 = ((fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint128)arg1 * arg2);
    x2 = (uint64_t)(x1 & UINT64_C(0xffffffffffffffff));
    x3 = (uint64_t)(x1 >> 64);
    *out1 = x2;
    *out2 = x3;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u64 is a single-word conditional move.
 * Postconditions:
 *   out1 = (if arg1 = 0 then arg2 else arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffffffffffff]
 *   arg3: [0x0 ~> 0xffffffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffffffffffff]
 */
static void fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u64(
    uint64_t *out1, fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 arg1,
    uint64_t arg2, uint64_t arg3) {
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x1;
    uint64_t x2;
    uint64_t x3;
    x1 = (!(!arg1));
    x2 = ((fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_int1)(0x0 - x1) &
          UINT64_C(0xffffffffffffffff));
    x3 =
        ((fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_value_barrier_u64(x2) &
          arg3) |
         (fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_value_barrier_u64((~x2)) &
          arg2));
    *out1 = x3;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul multiplies two field elements in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 *   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(
    uint64_t out1[4], const uint64_t arg1[4], const uint64_t arg2[4]) {
    uint64_t x1;
    uint64_t x2;
    uint64_t x3;
    uint64_t x4;
    uint64_t x5;
    uint64_t x6;
    uint64_t x7;
    uint64_t x8;
    uint64_t x9;
    uint64_t x10;
    uint64_t x11;
    uint64_t x12;
    uint64_t x13;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x14;
    uint64_t x15;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x16;
    uint64_t x17;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x18;
    uint64_t x19;
    uint64_t x20;
    uint64_t x21;
    uint64_t x22;
    uint64_t x23;
    uint64_t x24;
    uint64_t x25;
    uint64_t x26;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x27;
    uint64_t x28;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x29;
    uint64_t x30;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x31;
    uint64_t x32;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x33;
    uint64_t x34;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x35;
    uint64_t x36;
    uint64_t x37;
    uint64_t x38;
    uint64_t x39;
    uint64_t x40;
    uint64_t x41;
    uint64_t x42;
    uint64_t x43;
    uint64_t x44;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x45;
    uint64_t x46;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x47;
    uint64_t x48;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x49;
    uint64_t x50;
    uint64_t x51;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x52;
    uint64_t x53;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x54;
    uint64_t x55;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x56;
    uint64_t x57;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x58;
    uint64_t x59;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x60;
    uint64_t x61;
    uint64_t x62;
    uint64_t x63;
    uint64_t x64;
    uint64_t x65;
    uint64_t x66;
    uint64_t x67;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x68;
    uint64_t x69;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x70;
    uint64_t x71;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x72;
    uint64_t x73;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x74;
    uint64_t x75;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x76;
    uint64_t x77;
    uint64_t x78;
    uint64_t x79;
    uint64_t x80;
    uint64_t x81;
    uint64_t x82;
    uint64_t x83;
    uint64_t x84;
    uint64_t x85;
    uint64_t x86;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x87;
    uint64_t x88;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x89;
    uint64_t x90;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x91;
    uint64_t x92;
    uint64_t x93;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x94;
    uint64_t x95;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x96;
    uint64_t x97;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x98;
    uint64_t x99;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x100;
    uint64_t x101;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x102;
    uint64_t x103;
    uint64_t x104;
    uint64_t x105;
    uint64_t x106;
    uint64_t x107;
    uint64_t x108;
    uint64_t x109;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x110;
    uint64_t x111;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x112;
    uint64_t x113;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x114;
    uint64_t x115;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x116;
    uint64_t x117;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x118;
    uint64_t x119;
    uint64_t x120;
    uint64_t x121;
    uint64_t x122;
    uint64_t x123;
    uint64_t x124;
    uint64_t x125;
    uint64_t x126;
    uint64_t x127;
    uint64_t x128;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x129;
    uint64_t x130;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x131;
    uint64_t x132;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x133;
    uint64_t x134;
    uint64_t x135;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x136;
    uint64_t x137;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x138;
    uint64_t x139;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x140;
    uint64_t x141;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x142;
    uint64_t x143;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x144;
    uint64_t x145;
    uint64_t x146;
    uint64_t x147;
    uint64_t x148;
    uint64_t x149;
    uint64_t x150;
    uint64_t x151;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x152;
    uint64_t x153;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x154;
    uint64_t x155;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x156;
    uint64_t x157;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x158;
    uint64_t x159;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x160;
    uint64_t x161;
    uint64_t x162;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x163;
    uint64_t x164;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x165;
    uint64_t x166;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x167;
    uint64_t x168;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x169;
    uint64_t x170;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x171;
    uint64_t x172;
    uint64_t x173;
    uint64_t x174;
    uint64_t x175;
    x1 = (arg1[1]);
    x2 = (arg1[2]);
    x3 = (arg1[3]);
    x4 = (arg1[0]);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x5, &x6, x4,
                                                         (arg2[3]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x7, &x8, x4,
                                                         (arg2[2]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x9, &x10, x4,
                                                         (arg2[1]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x11, &x12, x4,
                                                         (arg2[0]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x13, &x14, 0x0,
                                                              x12, x9);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x15, &x16, x14,
                                                              x10, x7);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x17, &x18, x16,
                                                              x8, x5);
    x19 = (x18 + x6);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(
        &x20, &x21, x11, UINT64_C(0xbd667ab8a3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(
        &x22, &x23, x20, UINT64_C(0x8000000000000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x24, &x25, x20,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x26, &x27, 0x0,
                                                              x11, x24);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x28, &x29, x27,
                                                              x13, x25);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x30, &x31, x29,
                                                              x15, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x32, &x33, x31,
                                                              x17, x22);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x34, &x35, x33,
                                                              x19, x23);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x36, &x37, x1,
                                                         (arg2[3]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x38, &x39, x1,
                                                         (arg2[2]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x40, &x41, x1,
                                                         (arg2[1]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x42, &x43, x1,
                                                         (arg2[0]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x44, &x45, 0x0,
                                                              x43, x40);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x46, &x47, x45,
                                                              x41, x38);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x48, &x49, x47,
                                                              x39, x36);
    x50 = (x49 + x37);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x51, &x52, 0x0,
                                                              x28, x42);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x53, &x54, x52,
                                                              x30, x44);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x55, &x56, x54,
                                                              x32, x46);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x57, &x58, x56,
                                                              x34, x48);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x59, &x60, x58,
                                                              x35, x50);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(
        &x61, &x62, x51, UINT64_C(0xbd667ab8a3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(
        &x63, &x64, x61, UINT64_C(0x8000000000000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x65, &x66, x61,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x67, &x68, 0x0,
                                                              x51, x65);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x69, &x70, x68,
                                                              x53, x66);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x71, &x72, x70,
                                                              x55, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x73, &x74, x72,
                                                              x57, x63);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x75, &x76, x74,
                                                              x59, x64);
    x77 = ((uint64_t)x76 + x60);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x78, &x79, x2,
                                                         (arg2[3]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x80, &x81, x2,
                                                         (arg2[2]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x82, &x83, x2,
                                                         (arg2[1]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x84, &x85, x2,
                                                         (arg2[0]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x86, &x87, 0x0,
                                                              x85, x82);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x88, &x89, x87,
                                                              x83, x80);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x90, &x91, x89,
                                                              x81, x78);
    x92 = (x91 + x79);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x93, &x94, 0x0,
                                                              x69, x84);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x95, &x96, x94,
                                                              x71, x86);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x97, &x98, x96,
                                                              x73, x88);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x99, &x100, x98,
                                                              x75, x90);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x101, &x102,
                                                              x100, x77, x92);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(
        &x103, &x104, x93, UINT64_C(0xbd667ab8a3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(
        &x105, &x106, x103, UINT64_C(0x8000000000000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x107, &x108, x103,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x109, &x110, 0x0,
                                                              x93, x107);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x111, &x112,
                                                              x110, x95, x108);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x113, &x114,
                                                              x112, x97, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x115, &x116,
                                                              x114, x99, x105);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x117, &x118,
                                                              x116, x101, x106);
    x119 = ((uint64_t)x118 + x102);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x120, &x121, x3,
                                                         (arg2[3]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x122, &x123, x3,
                                                         (arg2[2]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x124, &x125, x3,
                                                         (arg2[1]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x126, &x127, x3,
                                                         (arg2[0]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x128, &x129, 0x0,
                                                              x127, x124);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x130, &x131,
                                                              x129, x125, x122);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x132, &x133,
                                                              x131, x123, x120);
    x134 = (x133 + x121);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x135, &x136, 0x0,
                                                              x111, x126);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x137, &x138,
                                                              x136, x113, x128);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x139, &x140,
                                                              x138, x115, x130);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x141, &x142,
                                                              x140, x117, x132);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x143, &x144,
                                                              x142, x119, x134);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(
        &x145, &x146, x135, UINT64_C(0xbd667ab8a3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(
        &x147, &x148, x145, UINT64_C(0x8000000000000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x149, &x150, x145,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x151, &x152, 0x0,
                                                              x135, x149);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x153, &x154,
                                                              x152, x137, x150);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x155, &x156,
                                                              x154, x139, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x157, &x158,
                                                              x156, x141, x147);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x159, &x160,
                                                              x158, x143, x148);
    x161 = ((uint64_t)x160 + x144);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u64(
        &x162, &x163, 0x0, x153, UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u64(&x164, &x165,
                                                               x163, x155, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u64(&x166, &x167,
                                                               x165, x157, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u64(
        &x168, &x169, x167, x159, UINT64_C(0x8000000000000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u64(&x170, &x171,
                                                               x169, x161, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u64(&x172, x171, x162,
                                                            x153);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u64(&x173, x171, x164,
                                                            x155);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u64(&x174, x171, x166,
                                                            x157);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u64(&x175, x171, x168,
                                                            x159);
    out1[0] = x172;
    out1[1] = x173;
    out1[2] = x174;
    out1[3] = x175;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_square squares a field element in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg1)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_square(
    uint64_t out1[4], const uint64_t arg1[4]) {
    uint64_t x1;
    uint64_t x2;
    uint64_t x3;
    uint64_t x4;
    uint64_t x5;
    uint64_t x6;
    uint64_t x7;
    uint64_t x8;
    uint64_t x9;
    uint64_t x10;
    uint64_t x11;
    uint64_t x12;
    uint64_t x13;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x14;
    uint64_t x15;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x16;
    uint64_t x17;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x18;
    uint64_t x19;
    uint64_t x20;
    uint64_t x21;
    uint64_t x22;
    uint64_t x23;
    uint64_t x24;
    uint64_t x25;
    uint64_t x26;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x27;
    uint64_t x28;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x29;
    uint64_t x30;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x31;
    uint64_t x32;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x33;
    uint64_t x34;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x35;
    uint64_t x36;
    uint64_t x37;
    uint64_t x38;
    uint64_t x39;
    uint64_t x40;
    uint64_t x41;
    uint64_t x42;
    uint64_t x43;
    uint64_t x44;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x45;
    uint64_t x46;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x47;
    uint64_t x48;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x49;
    uint64_t x50;
    uint64_t x51;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x52;
    uint64_t x53;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x54;
    uint64_t x55;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x56;
    uint64_t x57;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x58;
    uint64_t x59;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x60;
    uint64_t x61;
    uint64_t x62;
    uint64_t x63;
    uint64_t x64;
    uint64_t x65;
    uint64_t x66;
    uint64_t x67;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x68;
    uint64_t x69;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x70;
    uint64_t x71;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x72;
    uint64_t x73;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x74;
    uint64_t x75;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x76;
    uint64_t x77;
    uint64_t x78;
    uint64_t x79;
    uint64_t x80;
    uint64_t x81;
    uint64_t x82;
    uint64_t x83;
    uint64_t x84;
    uint64_t x85;
    uint64_t x86;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x87;
    uint64_t x88;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x89;
    uint64_t x90;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x91;
    uint64_t x92;
    uint64_t x93;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x94;
    uint64_t x95;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x96;
    uint64_t x97;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x98;
    uint64_t x99;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x100;
    uint64_t x101;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x102;
    uint64_t x103;
    uint64_t x104;
    uint64_t x105;
    uint64_t x106;
    uint64_t x107;
    uint64_t x108;
    uint64_t x109;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x110;
    uint64_t x111;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x112;
    uint64_t x113;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x114;
    uint64_t x115;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x116;
    uint64_t x117;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x118;
    uint64_t x119;
    uint64_t x120;
    uint64_t x121;
    uint64_t x122;
    uint64_t x123;
    uint64_t x124;
    uint64_t x125;
    uint64_t x126;
    uint64_t x127;
    uint64_t x128;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x129;
    uint64_t x130;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x131;
    uint64_t x132;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x133;
    uint64_t x134;
    uint64_t x135;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x136;
    uint64_t x137;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x138;
    uint64_t x139;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x140;
    uint64_t x141;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x142;
    uint64_t x143;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x144;
    uint64_t x145;
    uint64_t x146;
    uint64_t x147;
    uint64_t x148;
    uint64_t x149;
    uint64_t x150;
    uint64_t x151;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x152;
    uint64_t x153;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x154;
    uint64_t x155;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x156;
    uint64_t x157;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x158;
    uint64_t x159;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x160;
    uint64_t x161;
    uint64_t x162;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x163;
    uint64_t x164;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x165;
    uint64_t x166;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x167;
    uint64_t x168;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x169;
    uint64_t x170;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x171;
    uint64_t x172;
    uint64_t x173;
    uint64_t x174;
    uint64_t x175;
    x1 = (arg1[1]);
    x2 = (arg1[2]);
    x3 = (arg1[3]);
    x4 = (arg1[0]);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x5, &x6, x4,
                                                         (arg1[3]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x7, &x8, x4,
                                                         (arg1[2]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x9, &x10, x4,
                                                         (arg1[1]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x11, &x12, x4,
                                                         (arg1[0]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x13, &x14, 0x0,
                                                              x12, x9);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x15, &x16, x14,
                                                              x10, x7);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x17, &x18, x16,
                                                              x8, x5);
    x19 = (x18 + x6);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(
        &x20, &x21, x11, UINT64_C(0xbd667ab8a3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(
        &x22, &x23, x20, UINT64_C(0x8000000000000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x24, &x25, x20,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x26, &x27, 0x0,
                                                              x11, x24);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x28, &x29, x27,
                                                              x13, x25);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x30, &x31, x29,
                                                              x15, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x32, &x33, x31,
                                                              x17, x22);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x34, &x35, x33,
                                                              x19, x23);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x36, &x37, x1,
                                                         (arg1[3]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x38, &x39, x1,
                                                         (arg1[2]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x40, &x41, x1,
                                                         (arg1[1]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x42, &x43, x1,
                                                         (arg1[0]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x44, &x45, 0x0,
                                                              x43, x40);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x46, &x47, x45,
                                                              x41, x38);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x48, &x49, x47,
                                                              x39, x36);
    x50 = (x49 + x37);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x51, &x52, 0x0,
                                                              x28, x42);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x53, &x54, x52,
                                                              x30, x44);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x55, &x56, x54,
                                                              x32, x46);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x57, &x58, x56,
                                                              x34, x48);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x59, &x60, x58,
                                                              x35, x50);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(
        &x61, &x62, x51, UINT64_C(0xbd667ab8a3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(
        &x63, &x64, x61, UINT64_C(0x8000000000000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x65, &x66, x61,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x67, &x68, 0x0,
                                                              x51, x65);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x69, &x70, x68,
                                                              x53, x66);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x71, &x72, x70,
                                                              x55, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x73, &x74, x72,
                                                              x57, x63);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x75, &x76, x74,
                                                              x59, x64);
    x77 = ((uint64_t)x76 + x60);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x78, &x79, x2,
                                                         (arg1[3]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x80, &x81, x2,
                                                         (arg1[2]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x82, &x83, x2,
                                                         (arg1[1]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x84, &x85, x2,
                                                         (arg1[0]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x86, &x87, 0x0,
                                                              x85, x82);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x88, &x89, x87,
                                                              x83, x80);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x90, &x91, x89,
                                                              x81, x78);
    x92 = (x91 + x79);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x93, &x94, 0x0,
                                                              x69, x84);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x95, &x96, x94,
                                                              x71, x86);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x97, &x98, x96,
                                                              x73, x88);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x99, &x100, x98,
                                                              x75, x90);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x101, &x102,
                                                              x100, x77, x92);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(
        &x103, &x104, x93, UINT64_C(0xbd667ab8a3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(
        &x105, &x106, x103, UINT64_C(0x8000000000000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x107, &x108, x103,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x109, &x110, 0x0,
                                                              x93, x107);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x111, &x112,
                                                              x110, x95, x108);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x113, &x114,
                                                              x112, x97, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x115, &x116,
                                                              x114, x99, x105);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x117, &x118,
                                                              x116, x101, x106);
    x119 = ((uint64_t)x118 + x102);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x120, &x121, x3,
                                                         (arg1[3]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x122, &x123, x3,
                                                         (arg1[2]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x124, &x125, x3,
                                                         (arg1[1]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x126, &x127, x3,
                                                         (arg1[0]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x128, &x129, 0x0,
                                                              x127, x124);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x130, &x131,
                                                              x129, x125, x122);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x132, &x133,
                                                              x131, x123, x120);
    x134 = (x133 + x121);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x135, &x136, 0x0,
                                                              x111, x126);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x137, &x138,
                                                              x136, x113, x128);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x139, &x140,
                                                              x138, x115, x130);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x141, &x142,
                                                              x140, x117, x132);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x143, &x144,
                                                              x142, x119, x134);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(
        &x145, &x146, x135, UINT64_C(0xbd667ab8a3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(
        &x147, &x148, x145, UINT64_C(0x8000000000000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x149, &x150, x145,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x151, &x152, 0x0,
                                                              x135, x149);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x153, &x154,
                                                              x152, x137, x150);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x155, &x156,
                                                              x154, x139, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x157, &x158,
                                                              x156, x141, x147);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x159, &x160,
                                                              x158, x143, x148);
    x161 = ((uint64_t)x160 + x144);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u64(
        &x162, &x163, 0x0, x153, UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u64(&x164, &x165,
                                                               x163, x155, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u64(&x166, &x167,
                                                               x165, x157, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u64(
        &x168, &x169, x167, x159, UINT64_C(0x8000000000000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u64(&x170, &x171,
                                                               x169, x161, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u64(&x172, x171, x162,
                                                            x153);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u64(&x173, x171, x164,
                                                            x155);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u64(&x174, x171, x166,
                                                            x157);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u64(&x175, x171, x168,
                                                            x159);
    out1[0] = x172;
    out1[1] = x173;
    out1[2] = x174;
    out1[3] = x175;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add adds two field elements in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 *   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(
    uint64_t out1[4], const uint64_t arg1[4], const uint64_t arg2[4]) {
    uint64_t x1;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x2;
    uint64_t x3;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x4;
    uint64_t x5;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x6;
    uint64_t x7;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x8;
    uint64_t x9;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x10;
    uint64_t x11;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x12;
    uint64_t x13;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x14;
    uint64_t x15;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x16;
    uint64_t x17;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x18;
    uint64_t x19;
    uint64_t x20;
    uint64_t x21;
    uint64_t x22;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(
        &x1, &x2, 0x0, (arg1[0]), (arg2[0]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(
        &x3, &x4, x2, (arg1[1]), (arg2[1]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(
        &x5, &x6, x4, (arg1[2]), (arg2[2]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(
        &x7, &x8, x6, (arg1[3]), (arg2[3]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u64(
        &x9, &x10, 0x0, x1, UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u64(&x11, &x12, x10,
                                                               x3, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u64(&x13, &x14, x12,
                                                               x5, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u64(
        &x15, &x16, x14, x7, UINT64_C(0x8000000000000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u64(&x17, &x18, x16,
                                                               x8, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u64(&x19, x18, x9, x1);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u64(&x20, x18, x11, x3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u64(&x21, x18, x13, x5);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u64(&x22, x18, x15, x7);
    out1[0] = x19;
    out1[1] = x20;
    out1[2] = x21;
    out1[3] = x22;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub subtracts two field elements in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) - eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 *   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(
    uint64_t out1[4], const uint64_t arg1[4], const uint64_t arg2[4]) {
    uint64_t x1;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x2;
    uint64_t x3;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x4;
    uint64_t x5;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x6;
    uint64_t x7;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x8;
    uint64_t x9;
    uint64_t x10;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x11;
    uint64_t x12;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x13;
    uint64_t x14;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x15;
    uint64_t x16;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x17;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u64(
        &x1, &x2, 0x0, (arg1[0]), (arg2[0]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u64(
        &x3, &x4, x2, (arg1[1]), (arg2[1]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u64(
        &x5, &x6, x4, (arg1[2]), (arg2[2]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u64(
        &x7, &x8, x6, (arg1[3]), (arg2[3]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u64(
        &x9, x8, 0x0, UINT64_C(0xffffffffffffffff));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(
        &x10, &x11, 0x0, x1, (x9 & UINT16_C(0xc99)));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x12, &x13, x11,
                                                              x3, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x14, &x15, x13,
                                                              x5, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(
        &x16, &x17, x15, x7, (x9 & UINT64_C(0x8000000000000000)));
    out1[0] = x10;
    out1[1] = x12;
    out1[2] = x14;
    out1[3] = x16;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_opp negates a field element in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = -eval (from_montgomery arg1) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_opp(
    uint64_t out1[4], const uint64_t arg1[4]) {
    uint64_t x1;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x2;
    uint64_t x3;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x4;
    uint64_t x5;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x6;
    uint64_t x7;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x8;
    uint64_t x9;
    uint64_t x10;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x11;
    uint64_t x12;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x13;
    uint64_t x14;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x15;
    uint64_t x16;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x17;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u64(&x1, &x2, 0x0,
                                                               0x0, (arg1[0]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u64(&x3, &x4, x2,
                                                               0x0, (arg1[1]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u64(&x5, &x6, x4,
                                                               0x0, (arg1[2]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u64(&x7, &x8, x6,
                                                               0x0, (arg1[3]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u64(
        &x9, x8, 0x0, UINT64_C(0xffffffffffffffff));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(
        &x10, &x11, 0x0, x1, (x9 & UINT16_C(0xc99)));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x12, &x13, x11,
                                                              x3, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x14, &x15, x13,
                                                              x5, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(
        &x16, &x17, x15, x7, (x9 & UINT64_C(0x8000000000000000)));
    out1[0] = x10;
    out1[1] = x12;
    out1[2] = x14;
    out1[3] = x16;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_from_montgomery translates a field element out of the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval out1 mod m = (eval arg1 * ((2^64)⁻¹ mod m)^4) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_from_montgomery(
    uint64_t out1[4], const uint64_t arg1[4]) {
    uint64_t x1;
    uint64_t x2;
    uint64_t x3;
    uint64_t x4;
    uint64_t x5;
    uint64_t x6;
    uint64_t x7;
    uint64_t x8;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x9;
    uint64_t x10;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x11;
    uint64_t x12;
    uint64_t x13;
    uint64_t x14;
    uint64_t x15;
    uint64_t x16;
    uint64_t x17;
    uint64_t x18;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x19;
    uint64_t x20;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x21;
    uint64_t x22;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x23;
    uint64_t x24;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x25;
    uint64_t x26;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x27;
    uint64_t x28;
    uint64_t x29;
    uint64_t x30;
    uint64_t x31;
    uint64_t x32;
    uint64_t x33;
    uint64_t x34;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x35;
    uint64_t x36;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x37;
    uint64_t x38;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x39;
    uint64_t x40;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x41;
    uint64_t x42;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x43;
    uint64_t x44;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x45;
    uint64_t x46;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x47;
    uint64_t x48;
    uint64_t x49;
    uint64_t x50;
    uint64_t x51;
    uint64_t x52;
    uint64_t x53;
    uint64_t x54;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x55;
    uint64_t x56;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x57;
    uint64_t x58;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x59;
    uint64_t x60;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x61;
    uint64_t x62;
    uint64_t x63;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x64;
    uint64_t x65;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x66;
    uint64_t x67;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x68;
    uint64_t x69;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x70;
    uint64_t x71;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x72;
    uint64_t x73;
    uint64_t x74;
    uint64_t x75;
    uint64_t x76;
    x1 = (arg1[0]);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(
        &x2, &x3, x1, UINT64_C(0xbd667ab8a3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(
        &x4, &x5, x2, UINT64_C(0x8000000000000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x6, &x7, x2,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x8, &x9, 0x0, x1,
                                                              x6);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(
        &x10, &x11, 0x0, (x9 + x7), (arg1[1]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(
        &x12, &x13, x10, UINT64_C(0xbd667ab8a3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(
        &x14, &x15, x12, UINT64_C(0x8000000000000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x16, &x17, x12,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x18, &x19, 0x0,
                                                              x5, x14);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x20, &x21, 0x0,
                                                              x10, x16);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(
        &x22, &x23, 0x0, (((uint64_t)x21 + x11) + x17), (arg1[2]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x24, &x25, x23,
                                                              x4, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x26, &x27, x25,
                                                              x18, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(
        &x28, &x29, x22, UINT64_C(0xbd667ab8a3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(
        &x30, &x31, x28, UINT64_C(0x8000000000000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x32, &x33, x28,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x34, &x35, 0x0,
                                                              x22, x32);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x36, &x37, x35,
                                                              x24, x33);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x38, &x39, x37,
                                                              x26, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(
        &x40, &x41, x39, (x27 + (x19 + x15)), x30);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x42, &x43, 0x0,
                                                              x36, (arg1[3]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x44, &x45, x43,
                                                              x38, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x46, &x47, x45,
                                                              x40, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(
        &x48, &x49, x42, UINT64_C(0xbd667ab8a3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(
        &x50, &x51, x48, UINT64_C(0x8000000000000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x52, &x53, x48,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x54, &x55, 0x0,
                                                              x42, x52);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x56, &x57, x55,
                                                              x44, x53);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x58, &x59, x57,
                                                              x46, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(
        &x60, &x61, x59, (x47 + (x41 + x31)), x50);
    x62 = (x61 + x51);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u64(
        &x63, &x64, 0x0, x56, UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u64(&x65, &x66, x64,
                                                               x58, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u64(&x67, &x68, x66,
                                                               x60, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u64(
        &x69, &x70, x68, x62, UINT64_C(0x8000000000000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u64(&x71, &x72, x70,
                                                               0x0, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u64(&x73, x72, x63,
                                                            x56);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u64(&x74, x72, x65,
                                                            x58);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u64(&x75, x72, x67,
                                                            x60);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u64(&x76, x72, x69,
                                                            x62);
    out1[0] = x73;
    out1[1] = x74;
    out1[2] = x75;
    out1[3] = x76;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_to_montgomery translates a field element into the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = eval arg1 mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_to_montgomery(
    uint64_t out1[4], const uint64_t arg1[4]) {
    uint64_t x1;
    uint64_t x2;
    uint64_t x3;
    uint64_t x4;
    uint64_t x5;
    uint64_t x6;
    uint64_t x7;
    uint64_t x8;
    uint64_t x9;
    uint64_t x10;
    uint64_t x11;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x12;
    uint64_t x13;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x14;
    uint64_t x15;
    uint64_t x16;
    uint64_t x17;
    uint64_t x18;
    uint64_t x19;
    uint64_t x20;
    uint64_t x21;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x22;
    uint64_t x23;
    uint64_t x24;
    uint64_t x25;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x26;
    uint64_t x27;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x28;
    uint64_t x29;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x30;
    uint64_t x31;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x32;
    uint64_t x33;
    uint64_t x34;
    uint64_t x35;
    uint64_t x36;
    uint64_t x37;
    uint64_t x38;
    uint64_t x39;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x40;
    uint64_t x41;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x42;
    uint64_t x43;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x44;
    uint64_t x45;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x46;
    uint64_t x47;
    uint64_t x48;
    uint64_t x49;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x50;
    uint64_t x51;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x52;
    uint64_t x53;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x54;
    uint64_t x55;
    uint64_t x56;
    uint64_t x57;
    uint64_t x58;
    uint64_t x59;
    uint64_t x60;
    uint64_t x61;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x62;
    uint64_t x63;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x64;
    uint64_t x65;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x66;
    uint64_t x67;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x68;
    uint64_t x69;
    uint64_t x70;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x71;
    uint64_t x72;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x73;
    uint64_t x74;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x75;
    uint64_t x76;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x77;
    uint64_t x78;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x79;
    uint64_t x80;
    uint64_t x81;
    uint64_t x82;
    uint64_t x83;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x1, &x2, (arg1[0]),
                                                         UINT32_C(0x27acdc4));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(
        &x3, &x4, x1, UINT64_C(0xbd667ab8a3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(
        &x5, &x6, x3, UINT64_C(0x8000000000000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x7, &x8, x3,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x9, &x10, (arg1[1]),
                                                         UINT32_C(0x27acdc4));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x11, &x12, 0x0,
                                                              x1, x7);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(
        &x13, &x14, 0x0, ((x12 + x2) + x8), x9);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(
        &x15, &x16, x13, UINT64_C(0xbd667ab8a3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(
        &x17, &x18, x15, UINT64_C(0x8000000000000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x19, &x20, x15,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x21, &x22, 0x0,
                                                              x6, x17);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x23, &x24, (arg1[2]),
                                                         UINT32_C(0x27acdc4));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x25, &x26, 0x0,
                                                              x13, x19);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(
        &x27, &x28, 0x0, ((x26 + (x14 + x10)) + x20), x23);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x29, &x30, x28,
                                                              x5, x24);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x31, &x32, x30,
                                                              x21, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(
        &x33, &x34, x27, UINT64_C(0xbd667ab8a3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(
        &x35, &x36, x33, UINT64_C(0x8000000000000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x37, &x38, x33,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x39, &x40, 0x0,
                                                              x27, x37);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x41, &x42, x40,
                                                              x29, x38);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x43, &x44, x42,
                                                              x31, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(
        &x45, &x46, x44, (x32 + (x22 + x18)), x35);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x47, &x48, (arg1[3]),
                                                         UINT32_C(0x27acdc4));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x49, &x50, 0x0,
                                                              x41, x47);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x51, &x52, x50,
                                                              x43, x48);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x53, &x54, x52,
                                                              x45, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(
        &x55, &x56, x49, UINT64_C(0xbd667ab8a3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(
        &x57, &x58, x55, UINT64_C(0x8000000000000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u64(&x59, &x60, x55,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x61, &x62, 0x0,
                                                              x49, x59);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x63, &x64, x62,
                                                              x51, x60);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(&x65, &x66, x64,
                                                              x53, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u64(
        &x67, &x68, x66, (x54 + (x46 + x36)), x57);
    x69 = (x68 + x58);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u64(
        &x70, &x71, 0x0, x63, UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u64(&x72, &x73, x71,
                                                               x65, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u64(&x74, &x75, x73,
                                                               x67, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u64(
        &x76, &x77, x75, x69, UINT64_C(0x8000000000000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u64(&x78, &x79, x77,
                                                               0x0, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u64(&x80, x79, x70,
                                                            x63);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u64(&x81, x79, x72,
                                                            x65);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u64(&x82, x79, x74,
                                                            x67);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u64(&x83, x79, x76,
                                                            x69);
    out1[0] = x80;
    out1[1] = x81;
    out1[2] = x82;
    out1[3] = x83;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_nonzero outputs a single non-zero word if the input is non-zero and zero otherwise.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   out1 = 0 ↔ eval (from_montgomery arg1) mod m = 0
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffffffffffff]
 */
static void fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_nonzero(
    uint64_t *out1, const uint64_t arg1[4]) {
    uint64_t x1;
    x1 = ((arg1[0]) | ((arg1[1]) | ((arg1[2]) | (arg1[3]))));
    *out1 = x1;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_selectznz is a multi-limb conditional select.
 * Postconditions:
 *   eval out1 = (if arg1 = 0 then eval arg2 else eval arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 *   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_selectznz(
    uint64_t out1[4], fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 arg1,
    const uint64_t arg2[4], const uint64_t arg3[4]) {
    uint64_t x1;
    uint64_t x2;
    uint64_t x3;
    uint64_t x4;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u64(
        &x1, arg1, (arg2[0]), (arg3[0]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u64(
        &x2, arg1, (arg2[1]), (arg3[1]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u64(
        &x3, arg1, (arg2[2]), (arg3[2]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u64(
        &x4, arg1, (arg2[3]), (arg3[3]));
    out1[0] = x1;
    out1[1] = x2;
    out1[2] = x3;
    out1[3] = x4;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_to_bytes serializes a field element NOT in the Montgomery domain to bytes in little-endian order.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..31]
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
 */
static void fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_to_bytes(
    uint8_t out1[32], const uint64_t arg1[4]) {
    uint64_t x1;
    uint64_t x2;
    uint64_t x3;
    uint64_t x4;
    uint8_t x5;
    uint64_t x6;
    uint8_t x7;
    uint64_t x8;
    uint8_t x9;
    uint64_t x10;
    uint8_t x11;
    uint64_t x12;
    uint8_t x13;
    uint64_t x14;
    uint8_t x15;
    uint64_t x16;
    uint8_t x17;
    uint8_t x18;
    uint8_t x19;
    uint64_t x20;
    uint8_t x21;
    uint64_t x22;
    uint8_t x23;
    uint64_t x24;
    uint8_t x25;
    uint64_t x26;
    uint8_t x27;
    uint64_t x28;
    uint8_t x29;
    uint64_t x30;
    uint8_t x31;
    uint8_t x32;
    uint8_t x33;
    uint64_t x34;
    uint8_t x35;
    uint64_t x36;
    uint8_t x37;
    uint64_t x38;
    uint8_t x39;
    uint64_t x40;
    uint8_t x41;
    uint64_t x42;
    uint8_t x43;
    uint64_t x44;
    uint8_t x45;
    uint8_t x46;
    uint8_t x47;
    uint64_t x48;
    uint8_t x49;
    uint64_t x50;
    uint8_t x51;
    uint64_t x52;
    uint8_t x53;
    uint64_t x54;
    uint8_t x55;
    uint64_t x56;
    uint8_t x57;
    uint64_t x58;
    uint8_t x59;
    uint8_t x60;
    x1 = (arg1[3]);
    x2 = (arg1[2]);
    x3 = (arg1[1]);
    x4 = (arg1[0]);
    x5 = (uint8_t)(x4 & UINT8_C(0xff));
    x6 = (x4 >> 8);
    x7 = (uint8_t)(x6 & UINT8_C(0xff));
    x8 = (x6 >> 8);
    x9 = (uint8_t)(x8 & UINT8_C(0xff));
    x10 = (x8 >> 8);
    x11 = (uint8_t)(x10 & UINT8_C(0xff));
    x12 = (x10 >> 8);
    x13 = (uint8_t)(x12 & UINT8_C(0xff));
    x14 = (x12 >> 8);
    x15 = (uint8_t)(x14 & UINT8_C(0xff));
    x16 = (x14 >> 8);
    x17 = (uint8_t)(x16 & UINT8_C(0xff));
    x18 = (uint8_t)(x16 >> 8);
    x19 = (uint8_t)(x3 & UINT8_C(0xff));
    x20 = (x3 >> 8);
    x21 = (uint8_t)(x20 & UINT8_C(0xff));
    x22 = (x20 >> 8);
    x23 = (uint8_t)(x22 & UINT8_C(0xff));
    x24 = (x22 >> 8);
    x25 = (uint8_t)(x24 & UINT8_C(0xff));
    x26 = (x24 >> 8);
    x27 = (uint8_t)(x26 & UINT8_C(0xff));
    x28 = (x26 >> 8);
    x29 = (uint8_t)(x28 & UINT8_C(0xff));
    x30 = (x28 >> 8);
    x31 = (uint8_t)(x30 & UINT8_C(0xff));
    x32 = (uint8_t)(x30 >> 8);
    x33 = (uint8_t)(x2 & UINT8_C(0xff));
    x34 = (x2 >> 8);
    x35 = (uint8_t)(x34 & UINT8_C(0xff));
    x36 = (x34 >> 8);
    x37 = (uint8_t)(x36 & UINT8_C(0xff));
    x38 = (x36 >> 8);
    x39 = (uint8_t)(x38 & UINT8_C(0xff));
    x40 = (x38 >> 8);
    x41 = (uint8_t)(x40 & UINT8_C(0xff));
    x42 = (x40 >> 8);
    x43 = (uint8_t)(x42 & UINT8_C(0xff));
    x44 = (x42 >> 8);
    x45 = (uint8_t)(x44 & UINT8_C(0xff));
    x46 = (uint8_t)(x44 >> 8);
    x47 = (uint8_t)(x1 & UINT8_C(0xff));
    x48 = (x1 >> 8);
    x49 = (uint8_t)(x48 & UINT8_C(0xff));
    x50 = (x48 >> 8);
    x51 = (uint8_t)(x50 & UINT8_C(0xff));
    x52 = (x50 >> 8);
    x53 = (uint8_t)(x52 & UINT8_C(0xff));
    x54 = (x52 >> 8);
    x55 = (uint8_t)(x54 & UINT8_C(0xff));
    x56 = (x54 >> 8);
    x57 = (uint8_t)(x56 & UINT8_C(0xff));
    x58 = (x56 >> 8);
    x59 = (uint8_t)(x58 & UINT8_C(0xff));
    x60 = (uint8_t)(x58 >> 8);
    out1[0] = x5;
    out1[1] = x7;
    out1[2] = x9;
    out1[3] = x11;
    out1[4] = x13;
    out1[5] = x15;
    out1[6] = x17;
    out1[7] = x18;
    out1[8] = x19;
    out1[9] = x21;
    out1[10] = x23;
    out1[11] = x25;
    out1[12] = x27;
    out1[13] = x29;
    out1[14] = x31;
    out1[15] = x32;
    out1[16] = x33;
    out1[17] = x35;
    out1[18] = x37;
    out1[19] = x39;
    out1[20] = x41;
    out1[21] = x43;
    out1[22] = x45;
    out1[23] = x46;
    out1[24] = x47;
    out1[25] = x49;
    out1[26] = x51;
    out1[27] = x53;
    out1[28] = x55;
    out1[29] = x57;
    out1[30] = x59;
    out1[31] = x60;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_from_bytes deserializes a field element NOT in the Montgomery domain from bytes in little-endian order.
 * Preconditions:
 *   0 ≤ bytes_eval arg1 < m
 * Postconditions:
 *   eval out1 mod m = bytes_eval arg1 mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_from_bytes(
    uint64_t out1[4], const uint8_t arg1[32]) {
    uint64_t x1;
    uint64_t x2;
    uint64_t x3;
    uint64_t x4;
    uint64_t x5;
    uint64_t x6;
    uint64_t x7;
    uint8_t x8;
    uint64_t x9;
    uint64_t x10;
    uint64_t x11;
    uint64_t x12;
    uint64_t x13;
    uint64_t x14;
    uint64_t x15;
    uint8_t x16;
    uint64_t x17;
    uint64_t x18;
    uint64_t x19;
    uint64_t x20;
    uint64_t x21;
    uint64_t x22;
    uint64_t x23;
    uint8_t x24;
    uint64_t x25;
    uint64_t x26;
    uint64_t x27;
    uint64_t x28;
    uint64_t x29;
    uint64_t x30;
    uint64_t x31;
    uint8_t x32;
    uint64_t x33;
    uint64_t x34;
    uint64_t x35;
    uint64_t x36;
    uint64_t x37;
    uint64_t x38;
    uint64_t x39;
    uint64_t x40;
    uint64_t x41;
    uint64_t x42;
    uint64_t x43;
    uint64_t x44;
    uint64_t x45;
    uint64_t x46;
    uint64_t x47;
    uint64_t x48;
    uint64_t x49;
    uint64_t x50;
    uint64_t x51;
    uint64_t x52;
    uint64_t x53;
    uint64_t x54;
    uint64_t x55;
    uint64_t x56;
    uint64_t x57;
    uint64_t x58;
    uint64_t x59;
    uint64_t x60;
    x1 = ((uint64_t)(arg1[31]) << 56);
    x2 = ((uint64_t)(arg1[30]) << 48);
    x3 = ((uint64_t)(arg1[29]) << 40);
    x4 = ((uint64_t)(arg1[28]) << 32);
    x5 = ((uint64_t)(arg1[27]) << 24);
    x6 = ((uint64_t)(arg1[26]) << 16);
    x7 = ((uint64_t)(arg1[25]) << 8);
    x8 = (arg1[24]);
    x9 = ((uint64_t)(arg1[23]) << 56);
    x10 = ((uint64_t)(arg1[22]) << 48);
    x11 = ((uint64_t)(arg1[21]) << 40);
    x12 = ((uint64_t)(arg1[20]) << 32);
    x13 = ((uint64_t)(arg1[19]) << 24);
    x14 = ((uint64_t)(arg1[18]) << 16);
    x15 = ((uint64_t)(arg1[17]) << 8);
    x16 = (arg1[16]);
    x17 = ((uint64_t)(arg1[15]) << 56);
    x18 = ((uint64_t)(arg1[14]) << 48);
    x19 = ((uint64_t)(arg1[13]) << 40);
    x20 = ((uint64_t)(arg1[12]) << 32);
    x21 = ((uint64_t)(arg1[11]) << 24);
    x22 = ((uint64_t)(arg1[10]) << 16);
    x23 = ((uint64_t)(arg1[9]) << 8);
    x24 = (arg1[8]);
    x25 = ((uint64_t)(arg1[7]) << 56);
    x26 = ((uint64_t)(arg1[6]) << 48);
    x27 = ((uint64_t)(arg1[5]) << 40);
    x28 = ((uint64_t)(arg1[4]) << 32);
    x29 = ((uint64_t)(arg1[3]) << 24);
    x30 = ((uint64_t)(arg1[2]) << 16);
    x31 = ((uint64_t)(arg1[1]) << 8);
    x32 = (arg1[0]);
    x33 = (x31 + (uint64_t)x32);
    x34 = (x30 + x33);
    x35 = (x29 + x34);
    x36 = (x28 + x35);
    x37 = (x27 + x36);
    x38 = (x26 + x37);
    x39 = (x25 + x38);
    x40 = (x23 + (uint64_t)x24);
    x41 = (x22 + x40);
    x42 = (x21 + x41);
    x43 = (x20 + x42);
    x44 = (x19 + x43);
    x45 = (x18 + x44);
    x46 = (x17 + x45);
    x47 = (x15 + (uint64_t)x16);
    x48 = (x14 + x47);
    x49 = (x13 + x48);
    x50 = (x12 + x49);
    x51 = (x11 + x50);
    x52 = (x10 + x51);
    x53 = (x9 + x52);
    x54 = (x7 + (uint64_t)x8);
    x55 = (x6 + x54);
    x56 = (x5 + x55);
    x57 = (x4 + x56);
    x58 = (x3 + x57);
    x59 = (x2 + x58);
    x60 = (x1 + x59);
    out1[0] = x39;
    out1[1] = x46;
    out1[2] = x53;
    out1[3] = x60;
}

/* END verbatim fiat code */

/*-
 * Finite field inversion via FLT.
 * NB: this is not a real Fiat function, just named that way for consistency.
 * Autogenerated: ecp/id_GostR3410_2001_CryptoPro_B_ParamSet/fe_inv.op3
 * sliding window w=5
 */
static void fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_inv(fe_t output,
                                                            const fe_t t1) {
    int i;
    /* temporary variables */
    fe_t acc, t23, t25;

    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_square(acc, t1);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t25, t1, acc);
    for (i = 0; i < 9; i++)
        fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t25, t25, acc);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t23, t25, acc);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t25, t23, acc);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_square(acc, t1);
    for (i = 0; i < 247; i++)
        fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(acc, acc, t25);
    for (i = 0; i < 7; i++)
        fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(output, acc, t23);
}

/* curve coefficient constants */

static const limb_t const_one[4] = {
    UINT64_C(0xFFFFFFFFFFFFF367), UINT64_C(0xFFFFFFFFFFFFFFFF),
    UINT64_C(0xFFFFFFFFFFFFFFFF), UINT64_C(0x7FFFFFFFFFFFFFFF)};

static const limb_t const_b[4] = {
    UINT64_C(0x8DCC455AA9C5A084), UINT64_C(0x91AB42DF6CF438A8),
    UINT64_C(0x8F8AA907EEAC7D11), UINT64_C(0x3CE5D221F6285375)};

/* LUT for scalar multiplication by comb interleaving */
static const pt_aff_t lut_cmb[27][16] = {
    {
        {{UINT64_C(0xFFFFFFFFFFFFF367), UINT64_C(0xFFFFFFFFFFFFFFFF),
          UINT64_C(0xFFFFFFFFFFFFFFFF), UINT64_C(0x7FFFFFFFFFFFFFFF)},
         {UINT64_C(0xDDDC64B3570C7410), UINT64_C(0xA7B0992513172887),
          UINT64_C(0x0C4E5C4C4B6382DB), UINT64_C(0x2763DB0F124768DE)}},
        {{UINT64_C(0xCD3E57B68457D15D), UINT64_C(0xEB688F7FBEA56E83),
          UINT64_C(0x235A123C6A13C5CE), UINT64_C(0x0CD7EB9D50F57A6D)},
         {UINT64_C(0xC0124E91544C1965), UINT64_C(0x4D9C172962AFA35E),
          UINT64_C(0x0F92F2C30037C554), UINT64_C(0x1D8998680A3F2665)}},
        {{UINT64_C(0x9DE4B21355F43EFF), UINT64_C(0x2E110A425C9E63F5),
          UINT64_C(0x9350A9C31CE5A6DF), UINT64_C(0x377CBF0BA332315E)},
         {UINT64_C(0x2805DD4820F0D1B5), UINT64_C(0x3B1975660F9723E5),
          UINT64_C(0xA1CCA78C84B79937), UINT64_C(0x4F87BB1B94D5E03D)}},
        {{UINT64_C(0xE428FBFB5652C96F), UINT64_C(0x2E9A14D2D261BDD1),
          UINT64_C(0x082D82967453B76A), UINT64_C(0x61EA580E7AC87B02)},
         {UINT64_C(0xA0F8C2BACF368FDB), UINT64_C(0xDF093380D73B2A28),
          UINT64_C(0xFA0928B2EA8FE5D2), UINT64_C(0x77A674925F86D38A)}},
        {{UINT64_C(0xDFFAB41027670451), UINT64_C(0xEBC3D0171200AD3A),
          UINT64_C(0xF68324F325F4F6C4), UINT64_C(0x4A24CD5F7D0EAFD0)},
         {UINT64_C(0xF8FBD489D3F6BD1C), UINT64_C(0x0F6B56D567B473DE),
          UINT64_C(0x6FB063DECACF0D6B), UINT64_C(0x27F2E7E996DC574B)}},
        {{UINT64_C(0xA6A1064593937228), UINT64_C(0xAB7550B4A9165BBB),
          UINT64_C(0xD682D4F1CB0EDBE8), UINT64_C(0x2261FCEC40E5AD8D)},
         {UINT64_C(0x9F2119C6CCBD4E18), UINT64_C(0x2FD094E9AAB09697),
          UINT64_C(0x00331713E700929E), UINT64_C(0x6C5F2EFE54338FE1)}},
        {{UINT64_C(0xD631401742FFF78A), UINT64_C(0x38F23A912087E055),
          UINT64_C(0xE30E809C10EF1CAC), UINT64_C(0x3BCB0A542432FF74)},
         {UINT64_C(0x2B4B5B97B31509E6), UINT64_C(0x117FE9D73E54AF47),
          UINT64_C(0xE513C0BE52F63ACA), UINT64_C(0x41ED8ADAB1C80A6B)}},
        {{UINT64_C(0x61A31837E0A79FCD), UINT64_C(0x8F742B5751D3DE38),
          UINT64_C(0x10635FCD41354B55), UINT64_C(0x61F30C61946510BE)},
         {UINT64_C(0x9183D6776C416DAC), UINT64_C(0x391B7B42345431CB),
          UINT64_C(0xE3D6F0847C254A8D), UINT64_C(0x777E1F6219D320D8)}},
        {{UINT64_C(0x090E633FF05BD85D), UINT64_C(0x546C41A0240392ED),
          UINT64_C(0x6BBCF15D9F4139CA), UINT64_C(0x73F5B6577FFDA5DA)},
         {UINT64_C(0xBC04E353E0622A57), UINT64_C(0xCBD8F01E6E6414F4),
          UINT64_C(0x53377C0B8C3C0CC5), UINT64_C(0x6D302331E0A14548)}},
        {{UINT64_C(0x235487F83D6D456E), UINT64_C(0xBD92203DB3FDCDCF),
          UINT64_C(0x15B13D60CFFDA977), UINT64_C(0x22DCB48731A1C4B5)},
         {UINT64_C(0xA367FB4EC76ED9A2), UINT64_C(0x1E4F7956C0C86AF4),
          UINT64_C(0x6F087C495B012AD7), UINT64_C(0x33437E4A4949B444)}},
        {{UINT64_C(0x261B44FEB7CDDB38), UINT64_C(0xDCE2FE47419216AD),
          UINT64_C(0xA4CE17FF9428657B), UINT64_C(0x7CE64F48F8329049)},
         {UINT64_C(0x4CE742117289C114), UINT64_C(0x0E6224098C212A23),
          UINT64_C(0xCF75BF452096719D), UINT64_C(0x6F5535817BDC1600)}},
        {{UINT64_C(0xE776AA0CB941CBC9), UINT64_C(0x16D670E0951AAED3),
          UINT64_C(0x79C019DF4B1EC097), UINT64_C(0x635A66BB12266D30)},
         {UINT64_C(0x030D843E023AAFD2), UINT64_C(0x10FB61576466108F),
          UINT64_C(0x93774BEC08D568D5), UINT64_C(0x29D2796204C1EE73)}},
        {{UINT64_C(0x6F0F4C2EE00BBC21), UINT64_C(0x9EB34C58A30AB92F),
          UINT64_C(0x2153D901AE34908B), UINT64_C(0x136A7E1F4EDC188F)},
         {UINT64_C(0xF709BF5D8BC45EE4), UINT64_C(0xEA6984E44FAD9A54),
          UINT64_C(0xFC8E6F8AAF5140EB), UINT64_C(0x25EBF0DE87756E47)}},
        {{UINT64_C(0x5C2A97265B1D4B9F), UINT64_C(0xBE235DFD68E93FC7),
          UINT64_C(0x7766BDB9471A4EA0), UINT64_C(0x476D17CCD9909CD9)},
         {UINT64_C(0x4960E5B47B398BC4), UINT64_C(0x909D0F170F58F328),
          UINT64_C(0x1ABF7E02230EF508), UINT64_C(0x6DE6B3E1D29239C9)}},
        {{UINT64_C(0xCCF0AA2885A6DBE3), UINT64_C(0xA5E4B325823C606C),
          UINT64_C(0xADE98B2A15505FC6), UINT64_C(0x4D4E770302E20C3B)},
         {UINT64_C(0x241964174730DF64), UINT64_C(0x3DD47817A914A59D),
          UINT64_C(0x4D7A317EC4FDFD97), UINT64_C(0x3767E545BE12AA72)}},
        {{UINT64_C(0xA0C2A028165C7BF4), UINT64_C(0xCD4DA6EA36A0B483),
          UINT64_C(0x1E1E63323AF53195), UINT64_C(0x7A025E238D77188F)},
         {UINT64_C(0xB3CF03B908D2CEF2), UINT64_C(0x8FEE9BB825A0AFA6),
          UINT64_C(0x855340E088111895), UINT64_C(0x32E3EF014FB8F8A3)}},
    },
    {
        {{UINT64_C(0x33EBE39DEBF87807), UINT64_C(0xB048F96CDBDEFF76),
          UINT64_C(0xA0496C3C342A3087), UINT64_C(0x7623E19250953679)},
         {UINT64_C(0x12F767114B932390), UINT64_C(0xF80851EAACECE2F7),
          UINT64_C(0xE447465BE5B280EA), UINT64_C(0x0412ADE811115958)}},
        {{UINT64_C(0x982F1AC8B5EB0DC2), UINT64_C(0x8464E052BBBCC880),
          UINT64_C(0xC927B59601335D53), UINT64_C(0x4B0C6F5A4DA4D80B)},
         {UINT64_C(0x101E1878E04783AF), UINT64_C(0x50458FFC41D8A690),
          UINT64_C(0x11499D881B77DFBF), UINT64_C(0x46DC7D221F77A937)}},
        {{UINT64_C(0xE9AD22CE620E52C0), UINT64_C(0x0990D6AA4140F356),
          UINT64_C(0x0F6B2EF70CBBEEE5), UINT64_C(0x2C67DC80EAD414C6)},
         {UINT64_C(0xE17182BC23D4CD20), UINT64_C(0xFC8FE3CBC13DDEA9),
          UINT64_C(0xD1E4A7B83BABC06D), UINT64_C(0x52EA05CC71C06DB7)}},
        {{UINT64_C(0xF8ABB7700D022B5B), UINT64_C(0x362B8059199DC689),
          UINT64_C(0x5D887A4D26BBDEC8), UINT64_C(0x7835F183F7FC2A01)},
         {UINT64_C(0xEEDE12F5DE99DF34), UINT64_C(0xBE952638A3082301),
          UINT64_C(0x829FDF804C35A162), UINT64_C(0x205A2252C2B9645E)}},
        {{UINT64_C(0xDE284DA91356E14C), UINT64_C(0xE40CEFE0C37415FE),
          UINT64_C(0x62BE93E947F6016E), UINT64_C(0x2DD989045DBFE2F6)},
         {UINT64_C(0x195B0E982EBC70F9), UINT64_C(0x7E52840DF01F4D43),
          UINT64_C(0x1AFB1FDF4B1F6AB4), UINT64_C(0x050AABB820B3E491)}},
        {{UINT64_C(0xC59E1EDBC645DAD4), UINT64_C(0x5AF6B2DC565A286D),
          UINT64_C(0xC399A48A13076366), UINT64_C(0x19F4881F4AC0E5B9)},
         {UINT64_C(0xC07D02A1CD5AC339), UINT64_C(0x18FBD088ED628A55),
          UINT64_C(0x2D33C6F4FFA4788E), UINT64_C(0x52E9AE42CCB832E7)}},
        {{UINT64_C(0xA47091AE4E5E934E), UINT64_C(0x2542CE1391CED3C6),
          UINT64_C(0xDDE01FD58FC47857), UINT64_C(0x6BA6E5694304EAA9)},
         {UINT64_C(0x2FF0278BE24091A9), UINT64_C(0xB895F0AB782BBCE0),
          UINT64_C(0xA80CCC97AB8B8828), UINT64_C(0x6A54B96168A7D8FE)}},
        {{UINT64_C(0x15E1F5ADBAC4581A), UINT64_C(0x91620EF0D4BAA751),
          UINT64_C(0x4E65731FC7273C4D), UINT64_C(0x14B166CB7EEE33B5)},
         {UINT64_C(0x7B0EFFA53CD06080), UINT64_C(0x4491156A8CF95FF9),
          UINT64_C(0xC8C64C39E2258574), UINT64_C(0x3D48DA9D13315CE9)}},
        {{UINT64_C(0x97A098A399866CE5), UINT64_C(0xF4CCDB40023A1167),
          UINT64_C(0x4BB32981F8094782), UINT64_C(0x7342CC98C7D5FD13)},
         {UINT64_C(0x3C1C5B1878B99D4E), UINT64_C(0x1277668FF4762AC9),
          UINT64_C(0x612431D76AE50E4F), UINT64_C(0x36C174E036F9071C)}},
        {{UINT64_C(0x39194E879327BA7F), UINT64_C(0xC4D251FF7237FA1A),
          UINT64_C(0x55ED3CD42BA5EB8D), UINT64_C(0x0263AF07BA590188)},
         {UINT64_C(0xB4853127EFA82CF3), UINT64_C(0x2CC2D2202B8E761D),
          UINT64_C(0x4582B81E2722B490), UINT64_C(0x1DA7680A610AA621)}},
        {{UINT64_C(0x06A669EE30D297D4), UINT64_C(0xC336B048E133D393),
          UINT64_C(0xB733A2C493B7B41B), UINT64_C(0x427CC233C7A8E721)},
         {UINT64_C(0x727C14F12867BB00), UINT64_C(0x756F4C7AA736035E),
          UINT64_C(0xB72A3EDE26327A22), UINT64_C(0x4AEDE2BB77F73F28)}},
        {{UINT64_C(0xC8A3612FA7282ED0), UINT64_C(0xE4AD8B40B0150579),
          UINT64_C(0xAB1DE11D0C3FEE4B), UINT64_C(0x613AAD4833B31F23)},
         {UINT64_C(0xE74AB8565C91BD21), UINT64_C(0x499177357953D695),
          UINT64_C(0x3831EB601A53D74F), UINT64_C(0x245977A054DEB1A6)}},
        {{UINT64_C(0x15972E4DFFFC1468), UINT64_C(0xA758D9CB141DC24C),
          UINT64_C(0x5E76FCDFED8694C5), UINT64_C(0x5F9DAF35069B7A5E)},
         {UINT64_C(0xFE50FCE4501B5415), UINT64_C(0x6442CF6758CFDE50),
          UINT64_C(0xA89C6DB438E5F4D0), UINT64_C(0x21F012DBF5D4FEFC)}},
        {{UINT64_C(0x2A1170AD98CB9A81), UINT64_C(0x934BD9D5036C5E45),
          UINT64_C(0x27DF152ECA5095B1), UINT64_C(0x682698DBCCEEE508)},
         {UINT64_C(0x1F4FE3A2B973FB5F), UINT64_C(0xD33CBEBE792C7D4D),
          UINT64_C(0x99D37961E7B33A8F), UINT64_C(0x46B8993B7B6D015D)}},
        {{UINT64_C(0x93A3809B6FBAC8F7), UINT64_C(0x84861BF097C55DC4),
          UINT64_C(0xA6F89EEA15BB65E3), UINT64_C(0x66AE1C5DA6E531D1)},
         {UINT64_C(0x643A14FCFD83DAEA), UINT64_C(0xA7A46D0DC585947B),
          UINT64_C(0xFA20CF074FBA1274), UINT64_C(0x5999ED7B93578A7D)}},
        {{UINT64_C(0x36C8B6ED78E7C6CE), UINT64_C(0x6D400CA55E325F44),
          UINT64_C(0xC6AE09B320B7AA5C), UINT64_C(0x1AF261C189EABC17)},
         {UINT64_C(0x64D6FFBBB9E778E4), UINT64_C(0x1C9E223E7FC64BEB),
          UINT64_C(0x4D68B5205D75E6C0), UINT64_C(0x5A72B1D976677A06)}},
    },
    {
        {{UINT64_C(0x62DB66406F08BB17), UINT64_C(0xC34F29DFAE75BB73),
          UINT64_C(0xD501293D7DBD4851), UINT64_C(0x5EAA94CAAD1F604B)},
         {UINT64_C(0x39CFE9D1094408A8), UINT64_C(0xC0F6544CE8A476F2),
          UINT64_C(0x9F6308B6A42D7607), UINT64_C(0x17F82949D727018F)}},
        {{UINT64_C(0xC44453CD9C4C4BD2), UINT64_C(0xA895E247EBD0B947),
          UINT64_C(0x0AEB7AFCAEBC27F4), UINT64_C(0x2472FD08F04ABFAC)},
         {UINT64_C(0x319EC67D73E6E994), UINT64_C(0xD6533E4C798C5FC0),
          UINT64_C(0xF4C3B24D3FB9AA89), UINT64_C(0x3EC580820A3B376B)}},
        {{UINT64_C(0x79732D6F144ACF7A), UINT64_C(0xFDD630C3911342DD),
          UINT64_C(0xC577C4B34A630649), UINT64_C(0x14956A17BBA999D6)},
         {UINT64_C(0x523D3CC8A435A559), UINT64_C(0x488DC690ACDA8861),
          UINT64_C(0x4CF70928F051C69A), UINT64_C(0x2D98D573955394CB)}},
        {{UINT64_C(0xEDB7BA2A23A4B840), UINT64_C(0x725EC496F6C2D93B),
          UINT64_C(0x0C94818B8833BB3F), UINT64_C(0x51281A31B142B12A)},
         {UINT64_C(0x2A8A5706659EDA83), UINT64_C(0x3098F7507F9D6877),
          UINT64_C(0x87AD0FDF2171F69F), UINT64_C(0x6B7067C31A6F2F28)}},
        {{UINT64_C(0x3B52107412B1E36F), UINT64_C(0x727A2432F81E4733),
          UINT64_C(0xB75A2F3553F2CBBD), UINT64_C(0x46DE933854960EB0)},
         {UINT64_C(0xAC5344F8E561D908), UINT64_C(0x4BD40ECB12C67430),
          UINT64_C(0x1698FD62EF499F97), UINT64_C(0x29EBD7AE6AE9FBD1)}},
        {{UINT64_C(0x9DEC249B1EC8110D), UINT64_C(0x2D19053AFD2F5C39),
          UINT64_C(0xB1189807E01522DF), UINT64_C(0x24A04C16C1424C77)},
         {UINT64_C(0xA4FC7C7D24F72226), UINT64_C(0x763405FBA8322501),
          UINT64_C(0xC5443C9A18F015E0), UINT64_C(0x6DEDA19BC55D6CEA)}},
        {{UINT64_C(0x4EF309769EAE2FF9), UINT64_C(0x2549B7F25741B21B),
          UINT64_C(0x859ACD103BC23F01), UINT64_C(0x05C0358FBF5FB0D7)},
         {UINT64_C(0x85E53AA8FB6AB34C), UINT64_C(0x8DAAAA698FD2FD20),
          UINT64_C(0xBE6D4D3416096FC9), UINT64_C(0x27572C88F8B8B831)}},
        {{UINT64_C(0xADB98DC547D56A25), UINT64_C(0x0CC764328B8E1DC6),
          UINT64_C(0x032C738EBE48C4A1), UINT64_C(0x31372DAD94FC9CF0)},
         {UINT64_C(0x8E646A0C78A7DCB2), UINT64_C(0xA32F3E9C6ECD9885),
          UINT64_C(0x280BB4AD6A3AD963), UINT64_C(0x7DEE1BC4817D4327)}},
        {{UINT64_C(0x1AE6A27BF8A7C1E1), UINT64_C(0x558C652FCBC527C7),
          UINT64_C(0x4084B56EA65056F6), UINT64_C(0x3FD454596D4C838B)},
         {UINT64_C(0xF5C15AFD56DE792A), UINT64_C(0xF656FAA488959282),
          UINT64_C(0x7F0D8EF41C07D63F), UINT64_C(0x44EFFF7DCD841ACC)}},
        {{UINT64_C(0xAC28F2A68D3695D8), UINT64_C(0x94959EB83F91E781),
          UINT64_C(0x7693FFF7FEDD6E1F), UINT64_C(0x2512E6E1A9A699EF)},
         {UINT64_C(0x823400EB7955FAB7), UINT64_C(0xCF109EF994924C08),
          UINT64_C(0x12E087793A709F32), UINT64_C(0x187D04139CC6484C)}},
        {{UINT64_C(0xD3932AFBEBDE477F), UINT64_C(0x9D5A542244538D8A),
          UINT64_C(0x40B0B159166A87AF), UINT64_C(0x31294B3D41D5E078)},
         {UINT64_C(0x6C49C853E8C48222), UINT64_C(0x8FBE6620DCD0D611),
          UINT64_C(0x9DDC7EE2F611007B), UINT64_C(0x12289A60E6652172)}},
        {{UINT64_C(0x8B85475BDACF80F7), UINT64_C(0xADBAB3539B5CAEF2),
          UINT64_C(0x7C4090A38D2A7707), UINT64_C(0x271FA4F1DAB97830)},
         {UINT64_C(0x141B725253173E04), UINT64_C(0x4B483D6406D0B127),
          UINT64_C(0x8FD15BCF063A7AF8), UINT64_C(0x59B19EAFE580F34C)}},
        {{UINT64_C(0xA7EEA8C49C0D79B6), UINT64_C(0x766FA113B9185109),
          UINT64_C(0xB42D74F34642CC64), UINT64_C(0x51D0127BBB817476)},
         {UINT64_C(0x6DA097F58AB71448), UINT64_C(0x145872E5F95AD0C7),
          UINT64_C(0xB7E934F3F1759436), UINT64_C(0x4EA883F93160ED1F)}},
        {{UINT64_C(0x30DC39B70CEABAE1), UINT64_C(0x49EC5EE8A606D766),
          UINT64_C(0x230E276297FC46AF), UINT64_C(0x079A531F5BE79B8D)},
         {UINT64_C(0x48253BC2EF08C93F), UINT64_C(0x2D32AF02F124D043),
          UINT64_C(0x85796D0DAF34D231), UINT64_C(0x06A6205C15F8CECD)}},
        {{UINT64_C(0x1FA77AFD47B00D1A), UINT64_C(0x429717B0E48CE97A),
          UINT64_C(0x38FEF11D57433697), UINT64_C(0x3E91BED67D426687)},
         {UINT64_C(0x95919BF72AB4BFE9), UINT64_C(0x7A3F33FC97096B3A),
          UINT64_C(0x0E0BBAC33DD8C82E), UINT64_C(0x2CE9EFCBF8EDB675)}},
        {{UINT64_C(0x2D44E99843D8B81D), UINT64_C(0x8ABFF4196D68A95C),
          UINT64_C(0x639000A03B2A18DD), UINT64_C(0x7CD15413871E3ED3)},
         {UINT64_C(0xC059855B148F0378), UINT64_C(0x50147459616B62BF),
          UINT64_C(0x53B699AF4D461110), UINT64_C(0x6A0D0EC7EC29E48D)}},
    },
    {
        {{UINT64_C(0x5173322115797F35), UINT64_C(0x2F2982144BBE6644),
          UINT64_C(0x7BC8FEC64A5EF621), UINT64_C(0x3D2BE7857F472F05)},
         {UINT64_C(0xA1C3A1C92765C427), UINT64_C(0xBACF08FE24155ACF),
          UINT64_C(0xA9CC1A179D229948), UINT64_C(0x1918C97F27039FD8)}},
        {{UINT64_C(0x2CF393387843FF7B), UINT64_C(0x5FCBDE65258997F2),
          UINT64_C(0x3980BF90165A98A3), UINT64_C(0x2E80607DBF9458E5)},
         {UINT64_C(0x5F646EB67019165C), UINT64_C(0xFA091FBEDDE34205),
          UINT64_C(0x695348B669267AE3), UINT64_C(0x385B0B6AABC22051)}},
        {{UINT64_C(0x3CAE0756B537F78C), UINT64_C(0x3012A9588BE30367),
          UINT64_C(0x32D26C06981A22C3), UINT64_C(0x7D091FAB2950E833)},
         {UINT64_C(0xD8E1B638797ACAAF), UINT64_C(0xE7021C8549F2EA10),
          UINT64_C(0xCA382BC117A7AF3B), UINT64_C(0x08A5A81DBB809976)}},
        {{UINT64_C(0x00F499FD4287BB97), UINT64_C(0xFB6791CADAA9DAF2),
          UINT64_C(0x9A19E4F3057B2B98), UINT64_C(0x6968D2FFC53C0223)},
         {UINT64_C(0xDC741EF5CE88509C), UINT64_C(0x38AE355D306A0570),
          UINT64_C(0xFECF6589C23AF46B), UINT64_C(0x6C0E6ED16AD48836)}},
        {{UINT64_C(0x22B68698E363495D), UINT64_C(0x120005D039AF2BE3),
          UINT64_C(0xE37B19650BF4BA69), UINT64_C(0x3B416E9326E64AE7)},
         {UINT64_C(0xFAED5088DEAC5C59), UINT64_C(0x67436ACCEB2518A5),
          UINT64_C(0x636B52F891FA788D), UINT64_C(0x10B2A57A655153D1)}},
        {{UINT64_C(0xB18060A7833A984C), UINT64_C(0x7EF8374674833BAD),
          UINT64_C(0xCBFAF742C5B3BC88), UINT64_C(0x7981DC36A1A7F135)},
         {UINT64_C(0xE70CCAFA5D076280), UINT64_C(0xEBA80EB707009D85),
          UINT64_C(0x7D99D24C73778DE2), UINT64_C(0x1EFEE1BBA7262D50)}},
        {{UINT64_C(0xBC47F4A26A7CAB32), UINT64_C(0x53F290A7DD6E48A3),
          UINT64_C(0x82257A1B92F35F9E), UINT64_C(0x73D17B318BB0AAB0)},
         {UINT64_C(0xBBD4522AC2DFFE96), UINT64_C(0x9C37DAA1E6EB0501),
          UINT64_C(0xF4D4D568453DB6BE), UINT64_C(0x2868CBF5642AD2E4)}},
        {{UINT64_C(0x40A988E6ABE30C59), UINT64_C(0x5ADED92993057DEC),
          UINT64_C(0x18FD7E04DACD37B0), UINT64_C(0x6E3FB81E8228ACA5)},
         {UINT64_C(0xFF3EEFE64104B0C9), UINT64_C(0xD7DD05E731CA120A),
          UINT64_C(0xAFD3CF1CD01C1CF8), UINT64_C(0x4D0CD264831BC4E9)}},
        {{UINT64_C(0x2641B32182CAC14A), UINT64_C(0x34EB149570990E6C),
          UINT64_C(0x3E5AF58FA1C74CA6), UINT64_C(0x11B50821616B7A2D)},
         {UINT64_C(0x891636E3C4FA9719), UINT64_C(0xAEE84C27107DD719),
          UINT64_C(0xA2B0D83EC1872E75), UINT64_C(0x7DD62CBC7383069E)}},
        {{UINT64_C(0xEBA4A024C81B7E15), UINT64_C(0x1CC37E0804516070),
          UINT64_C(0xEF1F0401F90CE59D), UINT64_C(0x3B4259D5E062E133)},
         {UINT64_C(0x87A1DBFACF2CA1DD), UINT64_C(0xCFBFB15F61FD1AFB),
          UINT64_C(0xFBFD9899ECF4C7BA), UINT64_C(0x57C84CEE2725FA50)}},
        {{UINT64_C(0x8B0B7414EFA6E3D0), UINT64_C(0xD9725C5EB3D04224),
          UINT64_C(0x670E6C508A91371E), UINT64_C(0x4D1304679B25BD3B)},
         {UINT64_C(0x18D77D155CF18D4F), UINT64_C(0xEF80DC411CA09677),
          UINT64_C(0x6F3A961BB9A05CF9), UINT64_C(0x0BB8A5187C1433A4)}},
        {{UINT64_C(0xAC0CF52AB33FCF05), UINT64_C(0xAD03692F1CDC7782),
          UINT64_C(0xB345BAE6AA02B77E), UINT64_C(0x05096694456FCFA9)},
         {UINT64_C(0xA898444825D4CF32), UINT64_C(0xD76393E315184188),
          UINT64_C(0x7D4A8C0CEA069BED), UINT64_C(0x4D22268D11E18347)}},
        {{UINT64_C(0xC2A0BB753CB3C0F1), UINT64_C(0x61F4EC4C8EBA58C6),
          UINT64_C(0x5D3F0D44DFC4A903), UINT64_C(0x0B6CE81BF9B6F79A)},
         {UINT64_C(0xF694A44A94E49623), UINT64_C(0xCFCBB7E11BDF75E0),
          UINT64_C(0x20CEE1BDE0337E13), UINT64_C(0x694EA40BDFF02E18)}},
        {{UINT64_C(0xC21BE0FA78D1DC2E), UINT64_C(0x08B4D9A5ED0E49E0),
          UINT64_C(0x676731AB827F0B4C), UINT64_C(0x674ECC79EBAB5894)},
         {UINT64_C(0xB29BD0D439ABB148), UINT64_C(0x8207A8F82378A63A),
          UINT64_C(0xE36A549D1E4C29C2), UINT64_C(0x380D48DE3F1C255B)}},
        {{UINT64_C(0x6AB6F887E5F2C87E), UINT64_C(0xE92C7345A01AEC86),
          UINT64_C(0x697F45208660C26F), UINT64_C(0x4F2488E09B58015B)},
         {UINT64_C(0xB2410B3EBB41900C), UINT64_C(0x31267500BE1A8A39),
          UINT64_C(0xA7C9997CB9140554), UINT64_C(0x335B18061CD41524)}},
        {{UINT64_C(0xB836FD9F14873270), UINT64_C(0x1AE0F512E3243EC5),
          UINT64_C(0xA743E30483B9AB74), UINT64_C(0x1569C30D3A5758C7)},
         {UINT64_C(0x003CEF9A9E8F9E52), UINT64_C(0x557AFB4A8C22119E),
          UINT64_C(0x66F2487EF223A966), UINT64_C(0x7FA00273A519378F)}},
    },
    {
        {{UINT64_C(0x812C024F7B08C1C4), UINT64_C(0xC6017986ADBA8AD9),
          UINT64_C(0x59C7B16C0601BD82), UINT64_C(0x41B6A45C0CFA5622)},
         {UINT64_C(0x353A67D583C1E3E8), UINT64_C(0x9A83438EC65F5059),
          UINT64_C(0x9995037786EEA346), UINT64_C(0x74E2F4BD330D2570)}},
        {{UINT64_C(0xDB8E53C1B4A8BDA8), UINT64_C(0xA850047E2C003C77),
          UINT64_C(0xFFD48A731B018831), UINT64_C(0x24F96CB68B325062)},
         {UINT64_C(0x3779CA4DCD2B821B), UINT64_C(0xC2AFBF6EC3159CE7),
          UINT64_C(0x8A580B1A10F18DE9), UINT64_C(0x37043D0D8CF75334)}},
        {{UINT64_C(0x0451DCDAECCCF2E8), UINT64_C(0xCF7A3AD9752A134F),
          UINT64_C(0xD5754596FBDAE56C), UINT64_C(0x15237D73F4CDCF6A)},
         {UINT64_C(0x1DF5912CECA37967), UINT64_C(0x60934339336CD97E),
          UINT64_C(0xA4E523FE434DDC01), UINT64_C(0x24E81DC679DBE24C)}},
        {{UINT64_C(0x28F0D73BC83B2B7C), UINT64_C(0x45BE220F7B5DE1AA),
          UINT64_C(0x1B785230B136A877), UINT64_C(0x5A94122AAEFF115B)},
         {UINT64_C(0xEF895F0C8E598998), UINT64_C(0xCEE32B3EF4C622C3),
          UINT64_C(0x2D080B1DB256CFD0), UINT64_C(0x672686D621075E15)}},
        {{UINT64_C(0xE85FB5759F9F26FE), UINT64_C(0x1DE57B8393A7966E),
          UINT64_C(0xA9948DE8DD8CB696), UINT64_C(0x226C95A6758E685D)},
         {UINT64_C(0x38B0753B3729C663), UINT64_C(0xD46CA4D9410E4884),
          UINT64_C(0x1D6FA5F977516FA4), UINT64_C(0x09A0FDB8696CFAFC)}},
        {{UINT64_C(0xD1DAD8E9CC7F6FD8), UINT64_C(0x7BB9F606022195A2),
          UINT64_C(0x1B997396223A9346), UINT64_C(0x6ACD6F7C88DCFB04)},
         {UINT64_C(0x9029E5EB3AC52F65), UINT64_C(0xED1D7A0F935A39DE),
          UINT64_C(0xF1D58C3A538D8914), UINT64_C(0x19153569B36B8342)}},
        {{UINT64_C(0xFF600354E2502156), UINT64_C(0xE386A20F733DA5EC),
          UINT64_C(0xD6FBCBBB9D24D11D), UINT64_C(0x0B57498C0B06C843)},
         {UINT64_C(0x98F1FFF87A834667), UINT64_C(0x4AEB8788C7DF05F5),
          UINT64_C(0x8CFA3B01C2681DA4), UINT64_C(0x1AECC0E82FA2FAEA)}},
        {{UINT64_C(0x3827886594C5CBC5), UINT64_C(0x9ADA7CAB041A755A),
          UINT64_C(0xB38F762A8D891640), UINT64_C(0x28F6FBB200AD88F0)},
         {UINT64_C(0x3F9629E33709CD6D), UINT64_C(0xD2435A554912F483),
          UINT64_C(0x305BEA64DFF5AB69), UINT64_C(0x4D29041A663BB0D9)}},
        {{UINT64_C(0xDC4BC9D4E2FD9338), UINT64_C(0x5389390DBA7938FC),
          UINT64_C(0xC42B812DF329B218), UINT64_C(0x5E809B5EFA9F1956)},
         {UINT64_C(0xE2A89BAA523D74C3), UINT64_C(0x97CD9FFB78CBA7B5),
          UINT64_C(0x25F953015B07BCD2), UINT64_C(0x4042C7052064BB3A)}},
        {{UINT64_C(0xD8B6ADA428D53BF9), UINT64_C(0x5E922CA5A4210F2D),
          UINT64_C(0x9501F46AF05A1629), UINT64_C(0x28094E54C6CD71CD)},
         {UINT64_C(0x8D5484D5811285AD), UINT64_C(0xFB2168F41593EE86),
          UINT64_C(0x693D3B32AC54A41D), UINT64_C(0x3DAFEC0728A5425C)}},
        {{UINT64_C(0x0E4CF0D0D12837A8), UINT64_C(0x19FA2CC9CF5273BB),
          UINT64_C(0x56346BAE116A20C4), UINT64_C(0x4F3597FE0E436A36)},
         {UINT64_C(0x459D3FFBE8EB1B85), UINT64_C(0x7C7186725AE04130),
          UINT64_C(0xA37C258660302740), UINT64_C(0x2871AF37913072D8)}},
        {{UINT64_C(0xD77249B78590319D), UINT64_C(0x73F7A684EB06B813),
          UINT64_C(0x4C9DC5B971D1D580), UINT64_C(0x7C91A9F55A50A95B)},
         {UINT64_C(0x4F8F2E890475F161), UINT64_C(0xF34EC1DD538B7F94),
          UINT64_C(0xB8FF6C65D46F2575), UINT64_C(0x79A2CE2C64433C80)}},
        {{UINT64_C(0x38448A531AEB7039), UINT64_C(0xF5EC03F7417189EC),
          UINT64_C(0xFA095CA1EB92FF2B), UINT64_C(0x4612F720E4FCAEDB)},
         {UINT64_C(0xC945E966F30AAE0E), UINT64_C(0xF61CFE85340A7A1D),
          UINT64_C(0xA2560BC6E42D7920), UINT64_C(0x07D7B321A692E9C7)}},
        {{UINT64_C(0xB9C26307592C60C5), UINT64_C(0xCECBC6C30F59D966),
          UINT64_C(0x8BA31FD65459D89E), UINT64_C(0x1A4AF6B147C7FAE8)},
         {UINT64_C(0x66487766B431D720), UINT64_C(0x5D5973095108B845),
          UINT64_C(0xA3B94FD7CA8E6E0D), UINT64_C(0x639519E355C6A48D)}},
        {{UINT64_C(0xAD3EE167052DC195), UINT64_C(0x4DF2BFC70947816B),
          UINT64_C(0x5D463469ABADBB3C), UINT64_C(0x6F7AA885C33D4F96)},
         {UINT64_C(0x3DD27536FE06133C), UINT64_C(0x27A557B22796E7ED),
          UINT64_C(0x1117CCB73D314A4F), UINT64_C(0x6F0C0AE023968946)}},
        {{UINT64_C(0x0A3D4DAEE2110C00), UINT64_C(0x0389D3A54C633A23),
          UINT64_C(0xE167BDFA83AEC172), UINT64_C(0x067070CEFB38E8F1)},
         {UINT64_C(0x411373674DF220C5), UINT64_C(0xB255E5D359C39F05),
          UINT64_C(0xE437984E043C75B3), UINT64_C(0x01DCD7716A22994A)}},
    },
    {
        {{UINT64_C(0xD2880DF24C6FDDCF), UINT64_C(0x76A28FF28A00D80F),
          UINT64_C(0x257CB1F80792F82C), UINT64_C(0x07938ABC605703EA)},
         {UINT64_C(0xD99F0AC95F61B0FE), UINT64_C(0x440DC63C8EC15433),
          UINT64_C(0xD9BDDFF186AB5DDB), UINT64_C(0x3B8875DC744755EA)}},
        {{UINT64_C(0x01D904404938C9FB), UINT64_C(0x900657FD8DB6A890),
          UINT64_C(0xDCC5068AF60A173A), UINT64_C(0x5F3EB242857C7B2A)},
         {UINT64_C(0x634240BDA4F0EB9E), UINT64_C(0xACDDA6C444E85C70),
          UINT64_C(0x753F02AB0AABE4C5), UINT64_C(0x33D89D21C1D034E1)}},
        {{UINT64_C(0x4596B52D1279B25B), UINT64_C(0x494669D9A48014AE),
          UINT64_C(0x9A26B6FC4FD22150), UINT64_C(0x394DE0BBF07D5A3F)},
         {UINT64_C(0x12DFE5A6634C1733), UINT64_C(0x33EC21D21EBC5177),
          UINT64_C(0x454B4930527514CC), UINT64_C(0x7F23BD0F41405532)}},
        {{UINT64_C(0xB2879E7FBAC9DD30), UINT64_C(0x259BB1CB06CE7672),
          UINT64_C(0x201DB42EBB97BE10), UINT64_C(0x112D60792EA35A8E)},
         {UINT64_C(0x7CC756D46B3B9933), UINT64_C(0x4BD24810781CE4DD),
          UINT64_C(0x53CB4E388733247E), UINT64_C(0x47BD6A309DA66787)}},
        {{UINT64_C(0x8A700953BA600C8E), UINT64_C(0xD466F11DCF388C0D),
          UINT64_C(0xD485F341E4A17A8E), UINT64_C(0x63278918234FC16D)},
         {UINT64_C(0xF4DDA875BB82046D), UINT64_C(0xD61E4E582945470A),
          UINT64_C(0xCDB6C5BD6D0F8976), UINT64_C(0x44CD9E4D10A004A2)}},
        {{UINT64_C(0x595CD94249C4AA6E), UINT64_C(0xE5A901363DE400C8),
          UINT64_C(0x4BCED3BD9DD12D9E), UINT64_C(0x3700CF9278E3D5E4)},
         {UINT64_C(0xECFFF49875A32D1A), UINT64_C(0xC28DDE373C4A54B2),
          UINT64_C(0x8DC22352993CAE6D), UINT64_C(0x46CB540852ED7019)}},
        {{UINT64_C(0x71FFAED0EA94E7BF), UINT64_C(0xC0817D2CD5AE6185),
          UINT64_C(0x7B72B8B95CF23687), UINT64_C(0x61DDE59960A450E1)},
         {UINT64_C(0x17CF0B10D13870E6), UINT64_C(0x7D08E1FB5F2930BB),
          UINT64_C(0x8D0F4F5583807C14), UINT64_C(0x61EBFC1A6E6DB701)}},
        {{UINT64_C(0x247A3F650FCAFE68), UINT64_C(0x575480357AC2A25E),
          UINT64_C(0xB7466CA53CD0FE06), UINT64_C(0x7B0D8B36BCC31AB3)},
         {UINT64_C(0x2FAAF49CA6D4358C), UINT64_C(0xD9E5E2FE3E9B4E31),
          UINT64_C(0xA6A859A0F6086336), UINT64_C(0x0C2A442AA9C19F84)}},
        {{UINT64_C(0x66FEA8413BC0AD7D), UINT64_C(0xCD3A546C32C9158E),
          UINT64_C(0xACD2EE7F8FE1DF7F), UINT64_C(0x10F58C0AEBE9621E)},
         {UINT64_C(0x80047C54478B667D), UINT64_C(0x9EAE5FAA89870DCE),
          UINT64_C(0xC05BEB330520A005), UINT64_C(0x2CFBC921352AC891)}},
        {{UINT64_C(0x6842E6B8632F6D73), UINT64_C(0x6F2B57242B9FFAEA),
          UINT64_C(0x7ACCC9829341D2FA), UINT64_C(0x6DAD9A1188809B65)},
         {UINT64_C(0x3411850CB6CC2240), UINT64_C(0x8547BCAFB64937E1),
          UINT64_C(0x49AEDD5F6978F636), UINT64_C(0x38F5975285A53D2A)}},
        {{UINT64_C(0x5C38EB49F5F5A2D0), UINT64_C(0xE028121BE3BF779C),
          UINT64_C(0x649997C8A783D5E3), UINT64_C(0x04DE984A2C06CC0F)},
         {UINT64_C(0x52C834B0A49D6239), UINT64_C(0x070A1B09628413AC),
          UINT64_C(0x2FBE0CA5A8624A1E), UINT64_C(0x687D93C3268D930A)}},
        {{UINT64_C(0xC7CD6805314C47A4), UINT64_C(0x8BD0C630CE7A9A6D),
          UINT64_C(0xCDB2DAD534F727BA), UINT64_C(0x7814C41425DB0189)},
         {UINT64_C(0xD7F9C5DC7DD9CAEE), UINT64_C(0xDA6EACC8798690E4),
          UINT64_C(0x705794E36B675E01), UINT64_C(0x4A31D71475C5EC38)}},
        {{UINT64_C(0xC162A3EA0519D5F2), UINT64_C(0x92146A782958FABF),
          UINT64_C(0x1E63CBE46CB31EB0), UINT64_C(0x77CE5AADFBC5AD0F)},
         {UINT64_C(0x3631E47032605DC6), UINT64_C(0xC7D1C72F43413DD3),
          UINT64_C(0x171A37940DF6B7C9), UINT64_C(0x6D7117432B5A08BC)}},
        {{UINT64_C(0xDDC8057D509EF0F2), UINT64_C(0x05C0B92B6CABB486),
          UINT64_C(0xD49692B64244D919), UINT64_C(0x4E181744D297F56E)},
         {UINT64_C(0x902F6E73F8CBB897), UINT64_C(0xC3B21FE156D01382),
          UINT64_C(0xA858ABE146890F6D), UINT64_C(0x46B5E2C9506858AF)}},
        {{UINT64_C(0x30441281F4DEDE56), UINT64_C(0x13F06FBBA195AEDE),
          UINT64_C(0xAD5F575B2FDD3BFF), UINT64_C(0x680F656D32ACB590)},
         {UINT64_C(0xFB60A8E1E3FAABA7), UINT64_C(0xC8FBC1E489A14827),
          UINT64_C(0x5835453FA8616136), UINT64_C(0x02826A47E6F4926F)}},
        {{UINT64_C(0xAF4319A174F32180), UINT64_C(0x4C9FDD166C2C1712),
          UINT64_C(0x59CA4FD4AC7E14A7), UINT64_C(0x07AA6E2FABBD4EA4)},
         {UINT64_C(0xB4BD441CFE9F121F), UINT64_C(0xDEBB4356CDA452C5),
          UINT64_C(0xC29F1CFA51C9F451), UINT64_C(0x7E1EEF4C83F598D8)}},
    },
    {
        {{UINT64_C(0xFC41A3215014135F), UINT64_C(0xBE95F9BA3EEADF3F),
          UINT64_C(0x054B12123203A540), UINT64_C(0x6DD2FD173721C745)},
         {UINT64_C(0xF86B85785A682B59), UINT64_C(0x872AA481BE801F7D),
          UINT64_C(0x64C1600C14F865F2), UINT64_C(0x4BDD47AA25365449)}},
        {{UINT64_C(0xC96A964CF3A3469F), UINT64_C(0x273C5C859F7DA0E3),
          UINT64_C(0x88EDC4AC4C1A9DCD), UINT64_C(0x77623444B48E4CAA)},
         {UINT64_C(0x7AF34A9C31581FF7), UINT64_C(0x23328C37BB57F7CC),
          UINT64_C(0xE920D8E98B7C86AB), UINT64_C(0x1C7A7A409DE6D64C)}},
        {{UINT64_C(0x0BCDCD2279B9451C), UINT64_C(0x2920B43558F5241B),
          UINT64_C(0xC24DF7159B33EF3D), UINT64_C(0x15252C5BF2600224)},
         {UINT64_C(0xF9C8D8A69A9160B6), UINT64_C(0x3186F2F9A6B9A6B8),
          UINT64_C(0xC37267DCA377E98A), UINT64_C(0x71319A0A37957189)}},
        {{UINT64_C(0x48E5033F6BAF6AE5), UINT64_C(0x72379B2EA460FCE9),
          UINT64_C(0xFC753D47F3D2FA46), UINT64_C(0x3B67685AED9EDF72)},
         {UINT64_C(0x1608E304F712500F), UINT64_C(0xDFA358A49EE1B42A),
          UINT64_C(0xE7A4B37634B8345C), UINT64_C(0x7D0E0BF306753C17)}},
        {{UINT64_C(0xA88526A68FA62042), UINT64_C(0xD6F32BB5393006BD),
          UINT64_C(0x14804978A5DD5045), UINT64_C(0x34C02662BF0C5E13)},
         {UINT64_C(0xF9BEEBF9376E3E3D), UINT64_C(0xFD7740415923DC61),
          UINT64_C(0xFE77BDFAF9735CF5), UINT64_C(0x2E476E224077CFCC)}},
        {{UINT64_C(0xAB8E52EB9BA457EF), UINT64_C(0x95F6C5FE0ABED212),
          UINT64_C(0x7204B1A6386620FF), UINT64_C(0x463B7474DD180719)},
         {UINT64_C(0x7F7D27AAF991D8EE), UINT64_C(0xA7EB10858F67722D),
          UINT64_C(0x78D7095BE331480A), UINT64_C(0x1DCC8C1266A1C8FA)}},
        {{UINT64_C(0xD4C39C183E6A04C1), UINT64_C(0x73DB1C4DB598ABEE),
          UINT64_C(0x381F9780DF4A7D42), UINT64_C(0x3C19A23152F860CD)},
         {UINT64_C(0x7EC899343EF00740), UINT64_C(0x50867788F37FE0D5),
          UINT64_C(0x502D870B43E84D4A), UINT64_C(0x5F8A84138F744749)}},
        {{UINT64_C(0x1C41AAADFAECCFE4), UINT64_C(0xC324F3B921461F41),
          UINT64_C(0x165ABA3F4E90C0AB), UINT64_C(0x2F96CED55F88E7D3)},
         {UINT64_C(0x8CA366FCC0E52768), UINT64_C(0x6CCA017CA55249A7),
          UINT64_C(0x41ED002F0F7EBCA2), UINT64_C(0x0C33B371A2BAF655)}},
        {{UINT64_C(0x3B94CD9C62B928CE), UINT64_C(0x5BC43A6A39729345),
          UINT64_C(0x044D0C0FC47D223C), UINT64_C(0x3B64B38DB0493367)},
         {UINT64_C(0x82AFB645EB74A6C2), UINT64_C(0x0CB01E22D876D71C),
          UINT64_C(0xCE2A7DCC29C6BCD0), UINT64_C(0x4753DE1CDFD644EC)}},
        {{UINT64_C(0xE69FC90362188792), UINT64_C(0xD91DB9BC4914328B),
          UINT64_C(0x44953F4D3B68F8D0), UINT64_C(0x2950435D0654B283)},
         {UINT64_C(0xE599A4AEBE88F609), UINT64_C(0xF801CD9090F5D10E),
          UINT64_C(0x0AB78DB1D4F1D3D9), UINT64_C(0x3ED9666AC0F71ECB)}},
        {{UINT64_C(0x6046A505E1E73E59), UINT64_C(0x8723A3ECF3B5C2E0),
          UINT64_C(0x4BD95BF6E22C1555), UINT64_C(0x50DC33DB6DA421E9)},
         {UINT64_C(0xCFB51E95F1B01327), UINT64_C(0xE7013F2A199A8765),
          UINT64_C(0xF486FEA777504B0B), UINT64_C(0x2AF0F7E9F9BA61C6)}},
        {{UINT64_C(0x9DBA1A02BE00B841), UINT64_C(0x488BA4558BED5F08),
          UINT64_C(0xF6814A6467F1040E), UINT64_C(0x23AC4762DC252336)},
         {UINT64_C(0x25040F02F0ED0577), UINT64_C(0x65209B22C6FFAE9C),
          UINT64_C(0xCC441A8C485AA0AC), UINT64_C(0x10DFACB659D63A8A)}},
        {{UINT64_C(0xBF4A0569C7D86B28), UINT64_C(0x5CDA94C4DBDA9DA4),
          UINT64_C(0x2235C4CE69058335), UINT64_C(0x68FA5E7CD30C89E2)},
         {UINT64_C(0xBB286D3959097B5B), UINT64_C(0x87DA80BB9A20BA7E),
          UINT64_C(0x85EF865E56F47E54), UINT64_C(0x5BB8786774ABFA5B)}},
        {{UINT64_C(0x5DB14FABDE2FA36E), UINT64_C(0x84E3B54677775F09),
          UINT64_C(0xDA734523DA951D99), UINT64_C(0x04A890973975026E)},
         {UINT64_C(0xB5753599C0D12BE1), UINT64_C(0x05670CE9FB864D61),
          UINT64_C(0xB7153502305BF3CF), UINT64_C(0x7A9BB3572E60AF62)}},
        {{UINT64_C(0xF43CDA07C7566DA5), UINT64_C(0x7FC4C7FC53FA4196),
          UINT64_C(0x1E20E0ED88DCC9F3), UINT64_C(0x7317C7E5FEE23DDA)},
         {UINT64_C(0x0305E13F43017070), UINT64_C(0x5568410C6B1CA7C0),
          UINT64_C(0x0E5D55BA104BA029), UINT64_C(0x118B284E90FD49F8)}},
        {{UINT64_C(0xCA0F7B5B8F3C6D8A), UINT64_C(0xAF72DEE0AF7ECBF6),
          UINT64_C(0x21C86D85BB0EC4F1), UINT64_C(0x0303BC47F0525D17)},
         {UINT64_C(0x6ADCAB9F896FFCC0), UINT64_C(0x65764C4524E970CA),
          UINT64_C(0x0000F14C1C3CA718), UINT64_C(0x01CF1DDBD0292587)}},
    },
    {
        {{UINT64_C(0xEC4FABCC86111EBA), UINT64_C(0x599C20B6BBBB793F),
          UINT64_C(0xF74AE7475657668F), UINT64_C(0x24AF29B277BAE892)},
         {UINT64_C(0x47D6876BCFAC9D5E), UINT64_C(0xCACF9F5024369E14),
          UINT64_C(0x8A231D746F9CAFEF), UINT64_C(0x57645A4EB69AAE58)}},
        {{UINT64_C(0x440A3B15489900F6), UINT64_C(0x4B642FD3961AC3C2),
          UINT64_C(0x3D668599C265B973), UINT64_C(0x5FA0E65D1139CE78)},
         {UINT64_C(0x3FF15AF41FAA710E), UINT64_C(0xE45D35CEA9422FC0),
          UINT64_C(0x56904C06BD7BB349), UINT64_C(0x40C5BEE0E529989D)}},
        {{UINT64_C(0x8FA4686170B20298), UINT64_C(0xEC6295384838A136),
          UINT64_C(0x23ADE0F6137F66D6), UINT64_C(0x1A92E05C8EA53E76)},
         {UINT64_C(0x51728E279D51EB7A), UINT64_C(0xA6B0B758C4352E35),
          UINT64_C(0x84C5933137A11B35), UINT64_C(0x3933EFC1F66B75C7)}},
        {{UINT64_C(0x7FB68D6266916D0A), UINT64_C(0x3325D42EF28A9B14),
          UINT64_C(0x75E83A658592B544), UINT64_C(0x524D1CE02718628F)},
         {UINT64_C(0x88A110EA3C584D76), UINT64_C(0x6B034AC44AC09AAC),
          UINT64_C(0x0648863584FD3A36), UINT64_C(0x516F0EB087D944E1)}},
        {{UINT64_C(0xE2016DA0DF11D0BB), UINT64_C(0xB34EB471B01F6540),
          UINT64_C(0x13E3D330165CBB24), UINT64_C(0x3E755D117CF7F676)},
         {UINT64_C(0xD70CF4F84FEA9A69), UINT64_C(0x98F59E0AD18F4337),
          UINT64_C(0x7CCE7CE6826344BA), UINT64_C(0x30D129D7F4004BBE)}},
        {{UINT64_C(0x016EF317BA9CB975), UINT64_C(0x8EEBED19E4B3AB4D),
          UINT64_C(0x8C597DF0170A2570), UINT64_C(0x451538D85BE6DE70)},
         {UINT64_C(0x6C711DAC7A64792F), UINT64_C(0x8F1896EB217EC8FB),
          UINT64_C(0x82E9C20B7FE18DED), UINT64_C(0x6CEBF4A7B0C5F622)}},
        {{UINT64_C(0xD9403EB549CCC64F), UINT64_C(0x807EBD5628B8A3FD),
          UINT64_C(0xF08BB6590F291E12), UINT64_C(0x020D13E39C3F4432)},
         {UINT64_C(0xDA247896752BB92E), UINT64_C(0x9954179486EAFA7A),
          UINT64_C(0x213E94BA274E36AD), UINT64_C(0x4CC0F1FB61A71333)}},
        {{UINT64_C(0x19CC11BD06478801), UINT64_C(0x1251562A6D18216A),
          UINT64_C(0x7A5F06BBCDD307FC), UINT64_C(0x4285F6ABFAA9CA2A)},
         {UINT64_C(0x5A92283181258996), UINT64_C(0x8F7CF8EE27B8B018),
          UINT64_C(0xF030BEF37F81A62D), UINT64_C(0x417ACBC1CD4FD4E7)}},
        {{UINT64_C(0xCFB0EA58EC64412F), UINT64_C(0x9547B64A6091E621),
          UINT64_C(0x5EA49C7EFD0C9815), UINT64_C(0x6789055AE78B355C)},
         {UINT64_C(0x8D743E9877E9A73A), UINT64_C(0xB032EA6A2EA3FA49),
          UINT64_C(0x52EA3801CEAAA33A), UINT64_C(0x73B3BB8DF2C3E22B)}},
        {{UINT64_C(0xAA2A12917DB9E301), UINT64_C(0x7F29770FA1293DD7),
          UINT64_C(0x3135BB2159683DEC), UINT64_C(0x070F8DF77785B505)},
         {UINT64_C(0x8F2158EA37F53677), UINT64_C(0x96CC7B9DABE1AF1C),
          UINT64_C(0x7F9779156D6477D6), UINT64_C(0x55DB3922DF370EAF)}},
        {{UINT64_C(0x3028C03AA9DAC7AE), UINT64_C(0x16F7DF0DBAE06BE0),
          UINT64_C(0x09548398410D57D9), UINT64_C(0x5E9C7F431510D51F)},
         {UINT64_C(0x033B9BE2D07717B3), UINT64_C(0x0D5D8116EF08AB91),
          UINT64_C(0xD5A172B1EEEFE88F), UINT64_C(0x72B1D29F0996294E)}},
        {{UINT64_C(0x9E2B79FBE4D0965C), UINT64_C(0x01F403EEF49D8B8E),
          UINT64_C(0xBD4D2D48CEB12D6A), UINT64_C(0x4D04DD9A11FB24FB)},
         {UINT64_C(0x7E613EC5E5C8D24C), UINT64_C(0x568BEFE8B918E543),
          UINT64_C(0xD6456D1EE966DF28), UINT64_C(0x2DDEAD63BAFC71E2)}},
        {{UINT64_C(0x1D794F92448D72E9), UINT64_C(0x3978052EE7E62BF2),
          UINT64_C(0xF6C7A72EE2B92538), UINT64_C(0x43879A886EF321F0)},
         {UINT64_C(0x2A82314034F6FFBC), UINT64_C(0x26F84E5135F4C485),
          UINT64_C(0xDEE65540028BFA7E), UINT64_C(0x56216E9D5F033058)}},
        {{UINT64_C(0x31CA5470CBC772EE), UINT64_C(0xD3621E11811BB5D0),
          UINT64_C(0x501C4C4770863D71), UINT64_C(0x0564518ED28D6BDD)},
         {UINT64_C(0x60E3B89BD35B64B9), UINT64_C(0xB4F2599A6621A688),
          UINT64_C(0x1A8C45083B5E116D), UINT64_C(0x633EF5CCFABF3125)}},
        {{UINT64_C(0x0DB1D2515D4FF62A), UINT64_C(0x6CBD00EB4B17D658),
          UINT64_C(0x2FA38212FA1DB737), UINT64_C(0x07B18CB893A7FA03)},
         {UINT64_C(0x531E47EF548E5F82), UINT64_C(0xAE7B94FD8276963C),
          UINT64_C(0x8055D82A6181A13A), UINT64_C(0x5725B51223B6E361)}},
        {{UINT64_C(0xD84C70416D8B1FFE), UINT64_C(0xF68ACA0B5D994200),
          UINT64_C(0x32BF99446BB908E2), UINT64_C(0x1240A3E61AD88DB1)},
         {UINT64_C(0xB0BE96AAA92B6472), UINT64_C(0xEF88A155A1B7726C),
          UINT64_C(0x000FD9ED9349F496), UINT64_C(0x377DCBAD454A05D9)}},
    },
    {
        {{UINT64_C(0xD0A092CDC04111D2), UINT64_C(0x5C43A94C338F06D6),
          UINT64_C(0x697B4C2625E964F3), UINT64_C(0x2CD5A0597572CCFD)},
         {UINT64_C(0xA09FC4D4B5B523E4), UINT64_C(0x7D8141E84E1E9042),
          UINT64_C(0x2462512BD637409E), UINT64_C(0x503F032F7CB2CE75)}},
        {{UINT64_C(0xC56F38E3BCBF1450), UINT64_C(0x09F4FC77CF2E5594),
          UINT64_C(0xF449C3E60FCB653A), UINT64_C(0x6A1FE75264A53C65)},
         {UINT64_C(0xFF366FED7C039488), UINT64_C(0x23F58BA58C99A6CB),
          UINT64_C(0x4B5546C68D67F6D6), UINT64_C(0x03405C85178B1668)}},
        {{UINT64_C(0x969F1B33C0C86696), UINT64_C(0x9346D06C13746468),
          UINT64_C(0x68AED3C8AE0C6D62), UINT64_C(0x7B3D536174FE63D5)},
         {UINT64_C(0xFEE8416BC4F4B65D), UINT64_C(0xC79BF488554C6D0A),
          UINT64_C(0x191D5D27DC402BB0), UINT64_C(0x31B00167E087EB9F)}},
        {{UINT64_C(0xD5FE0979E05D281F), UINT64_C(0x8373AB503485446B),
          UINT64_C(0xCE5258BA9223681F), UINT64_C(0x5F82843EA37BF244)},
         {UINT64_C(0x94ED780BCFC16536), UINT64_C(0x6A9739B3BD477733),
          UINT64_C(0x137D68F2A04A4195), UINT64_C(0x3A0F27E80032BFCE)}},
        {{UINT64_C(0x7EADE421358382F9), UINT64_C(0x490B9CA692E3D912),
          UINT64_C(0x040CE73EF1AFBC2A), UINT64_C(0x5745D47311AE91BA)},
         {UINT64_C(0x625BED61CE303B77), UINT64_C(0x85B2A1EB85B03A1D),
          UINT64_C(0x764F62E43D7C02E0), UINT64_C(0x22C2D16FA7AF6DDE)}},
        {{UINT64_C(0x5B985DE6D19377BE), UINT64_C(0x0AF85A06D8E43A10),
          UINT64_C(0x1465E5040519F4C6), UINT64_C(0x5DA01665E3E20BA3)},
         {UINT64_C(0xCD9B8E9B675D9E2A), UINT64_C(0x4C77E1AD6448A2CD),
          UINT64_C(0xD6094BAD1E5D4465), UINT64_C(0x4C352951C50DB788)}},
        {{UINT64_C(0x42581152EE5AB903), UINT64_C(0xDAD2DBC963311418),
          UINT64_C(0xBCA4F70BB885E56A), UINT64_C(0x1F5DD363B94E0876)},
         {UINT64_C(0xF9AD5D043FFF479E), UINT64_C(0xEF1176E5FE06AD2B),
          UINT64_C(0x46ACB00A216F77AF), UINT64_C(0x709CF4EB857C4F78)}},
        {{UINT64_C(0x70CD666ED0D2FF1C), UINT64_C(0x4BAD4A6AE7EFE4AD),
          UINT64_C(0xB43F6C2D0FA72024), UINT64_C(0x0D78F8E2E90C0617)},
         {UINT64_C(0x543B9662F80DCAA7), UINT64_C(0xB02FB3BCF28ADFAF),
          UINT64_C(0x26C17651C51C54C3), UINT64_C(0x0815F6373D648D88)}},
        {{UINT64_C(0xAC4F43C1AEA98FA6), UINT64_C(0x2D223416AC4398C6),
          UINT64_C(0x48B2EEADDA5C5070), UINT64_C(0x632B65F1BE666F70)},
         {UINT64_C(0x971D3BC0952021BE), UINT64_C(0x9FDCB7E023B2C578),
          UINT64_C(0x476D47153CC21796), UINT64_C(0x4015565F95832A94)}},
        {{UINT64_C(0x8913AFAC13CA725C), UINT64_C(0xA56DC461DC18F0D9),
          UINT64_C(0xAC3AC72010F3AAFE), UINT64_C(0x5D75567EC628D69C)},
         {UINT64_C(0xC11BE9DCEEEA4BF7), UINT64_C(0xAD97FBCA1C193BD5),
          UINT64_C(0xD1EC5BCEC58123E8), UINT64_C(0x0F6DF9309C73D4E5)}},
        {{UINT64_C(0xE80A0ADAFD759FFD), UINT64_C(0xE52DF94B239CAFC0),
          UINT64_C(0x59640161FE7A43E9), UINT64_C(0x7A96995CDB1A38F0)},
         {UINT64_C(0xA46A15037CD5011B), UINT64_C(0x75CFB637AC0E9689),
          UINT64_C(0x27B740CA97AAD2BA), UINT64_C(0x64A0748BEAD2F776)}},
        {{UINT64_C(0xB67E5BB50625B3B1), UINT64_C(0x2FE19FFBC66D2832),
          UINT64_C(0x47815666F70C07CF), UINT64_C(0x5A1AA24AA43E52AB)},
         {UINT64_C(0x04EE11F84CAC0E66), UINT64_C(0x51E515833A3A4836),
          UINT64_C(0x46755F49B44F6DEC), UINT64_C(0x6388408BC1E9B282)}},
        {{UINT64_C(0xD47AA9A69DE7A6A7), UINT64_C(0xEC94AD9B189BC9D2),
          UINT64_C(0xFA89099D8EC0E950), UINT64_C(0x1B9FC2069F64D27F)},
         {UINT64_C(0x765724840B729DE1), UINT64_C(0xFE9E8E714BE22EB8),
          UINT64_C(0x910F0456F9DB5942), UINT64_C(0x4D018459C617D82B)}},
        {{UINT64_C(0xB082B58AF5516C6F), UINT64_C(0xFFBA0E73567A8CF5),
          UINT64_C(0x08FF64CE8A6DD4A0), UINT64_C(0x6CF3C89C69A9F66A)},
         {UINT64_C(0x356782BA62FEB0A7), UINT64_C(0x1A18720D3E2907F9),
          UINT64_C(0xF840FFA30BBD9D92), UINT64_C(0x41D9EECA20926421)}},
        {{UINT64_C(0xCF2E8AACB6B08321), UINT64_C(0xC76FBE12010D91C0),
          UINT64_C(0x5492475068E35E02), UINT64_C(0x74DBA2E19AEE00F8)},
         {UINT64_C(0x94C70D6DC5504E82), UINT64_C(0x0BDF415FEA1770F7),
          UINT64_C(0xDA45B7003CA6DB0A), UINT64_C(0x473C6A04E133A980)}},
        {{UINT64_C(0xD1FF6C1E1E188071), UINT64_C(0x621A7D3CEA3F16F8),
          UINT64_C(0x604673076A160F47), UINT64_C(0x37CA7D3D32DC84EE)},
         {UINT64_C(0x54F5F7F667DDFDB5), UINT64_C(0x3A8482F9921BA04B),
          UINT64_C(0x842F49501A28E238), UINT64_C(0x3A4DC9177214FAFD)}},
    },
    {
        {{UINT64_C(0xEDD8360CEEA25E82), UINT64_C(0x3DB6D933FB7B7ED0),
          UINT64_C(0x882F3C0BABF15199), UINT64_C(0x228664A2516E349D)},
         {UINT64_C(0x96E6DCF7E88173DF), UINT64_C(0x382C8D3BD7EC0BC3),
          UINT64_C(0xFBFF6D216FA5FA58), UINT64_C(0x780039802F41C959)}},
        {{UINT64_C(0x713BA43B9D9ACF9C), UINT64_C(0xF59A252D94876559),
          UINT64_C(0x8B310954437B8ED5), UINT64_C(0x76A83790E474E98E)},
         {UINT64_C(0x84C1386AF6040B05), UINT64_C(0x69FA9F43BF3D8189),
          UINT64_C(0x5584164CA98D4866), UINT64_C(0x6C89CE1D3B9045D0)}},
        {{UINT64_C(0xD6EF7540B522FB28), UINT64_C(0xDB561B56BB28D745),
          UINT64_C(0xC9F7543EEFA58B87), UINT64_C(0x5F02A23BE9062979)},
         {UINT64_C(0xFD3C0C196809D624), UINT64_C(0x94481554A92EB229),
          UINT64_C(0x72D8EC53F5147EFB), UINT64_C(0x143026610D1BA626)}},
        {{UINT64_C(0x0B35BD5989020800), UINT64_C(0x3C6F1527430D7DEB),
          UINT64_C(0x9BEB3C8E2FFFA0E0), UINT64_C(0x7E181B78AFD09A19)},
         {UINT64_C(0xE82FD9573B2F0B49), UINT64_C(0x4C9461B10BC0F9DA),
          UINT64_C(0x87D78C412B1C8B85), UINT64_C(0x775BED20C1F5BDA1)}},
        {{UINT64_C(0x883AE89B16350593), UINT64_C(0x85D429CB0C19FEC8),
          UINT64_C(0x5938BDEC5742C36D), UINT64_C(0x2DDBC7EBDA8A21B7)},
         {UINT64_C(0xA249BDE407A2E700), UINT64_C(0x42A3897CE8BD6215),
          UINT64_C(0x87F30BA7732FF181), UINT64_C(0x5385D7091B912C57)}},
        {{UINT64_C(0x2B5C555B288041F5), UINT64_C(0xD3D900401F425866),
          UINT64_C(0x37E40CD202E0FA71), UINT64_C(0x08B37F263A386038)},
         {UINT64_C(0x165BD7FB5DE1ED78), UINT64_C(0x22949E810829ECC9),
          UINT64_C(0xBB8705CCBCE3D01F), UINT64_C(0x7961BE851D233CDF)}},
        {{UINT64_C(0x5D3DBC6B7659B477), UINT64_C(0xFD86577950EF08EB),
          UINT64_C(0x502729E8F34EA1A5), UINT64_C(0x1548526ED2B64602)},
         {UINT64_C(0xB13632FDB91D2675), UINT64_C(0x09A42003F7B37397),
          UINT64_C(0x37D18F37CCFC4532), UINT64_C(0x3FAEF63B73C7082C)}},
        {{UINT64_C(0x3365445FE666DB6D), UINT64_C(0x9051FFF5339A0076),
          UINT64_C(0x6167FB769BD6D01D), UINT64_C(0x09737137CA087B41)},
         {UINT64_C(0xCA2193AEB3270BA7), UINT64_C(0xEF0744C28F2217B3),
          UINT64_C(0x3E030D58F0DD10D8), UINT64_C(0x667246DBCCB4F2F9)}},
        {{UINT64_C(0x31F3030E3773EC8C), UINT64_C(0xAF2B31235AD56010),
          UINT64_C(0xFC118587B37E9062), UINT64_C(0x52840C2C9C2D5406)},
         {UINT64_C(0xA96D3DFF6670ACBB), UINT64_C(0xF469982F772EC6D3),
          UINT64_C(0x5BE20628A9DF4C88), UINT64_C(0x59D01479673633BC)}},
        {{UINT64_C(0xC9223750AFB5083B), UINT64_C(0xF1EB451E191C2160),
          UINT64_C(0x0D913794A38EC005), UINT64_C(0x31062E9E83FD1D18)},
         {UINT64_C(0x070538F55F4816AD), UINT64_C(0x90D4855D925F5DA1),
          UINT64_C(0xC0BBA87B22F455B6), UINT64_C(0x517B5F80F48D2AE5)}},
        {{UINT64_C(0x0D8B670A3F4FA7CA), UINT64_C(0xE29C88493D114EB2),
          UINT64_C(0x1823780D916A187E), UINT64_C(0x6961C48365EE66A0)},
         {UINT64_C(0x2F6FB20A62FDC12C), UINT64_C(0x51414E5F0CFDDE0C),
          UINT64_C(0x16BD56A7DCA39073), UINT64_C(0x0CFE6DAF648FFD43)}},
        {{UINT64_C(0x3789F4CAAEBA9241), UINT64_C(0xE8056BC6107777C6),
          UINT64_C(0x6EE564C33CB20826), UINT64_C(0x5DF3634745448C69)},
         {UINT64_C(0xFD0FA84BB22CE624), UINT64_C(0x2AA19672AC753D50),
          UINT64_C(0x29A1464F677CC0D0), UINT64_C(0x7C2237B13CEF5493)}},
        {{UINT64_C(0x87C2587C24255918), UINT64_C(0x9AA89A0B90B35A37),
          UINT64_C(0x9932EB7810E7CAEF), UINT64_C(0x49278F16CDE31568)},
         {UINT64_C(0xA4D33C6141188ED9), UINT64_C(0xC587BDE005AC3A1D),
          UINT64_C(0x2A5C5ACC7248B5E0), UINT64_C(0x60026A1D8510D2CB)}},
        {{UINT64_C(0xE57CB0C96BAF603C), UINT64_C(0x527F28A6AB770AF0),
          UINT64_C(0x2850D8E6016F2BC1), UINT64_C(0x0EC2A46C936DC2EC)},
         {UINT64_C(0xA0BC5306D4F23FC2), UINT64_C(0x6DBEDA2653A0130F),
          UINT64_C(0xB1D52F87EE3314B7), UINT64_C(0x17168B126C234CF5)}},
        {{UINT64_C(0x8B8BC181DADF17D5), UINT64_C(0x31EC3CADFAFFA918),
          UINT64_C(0x4611A482274E4658), UINT64_C(0x5A9E365273D35EAD)},
         {UINT64_C(0xBA68825BF4028FC7), UINT64_C(0x142859D562E203F5),
          UINT64_C(0xCE516AC41C817A9E), UINT64_C(0x4201468257223F8D)}},
        {{UINT64_C(0x51FBFB2EB4B66798), UINT64_C(0x3A3F15910EA9C4EF),
          UINT64_C(0x3FD3D026E8814805), UINT64_C(0x3CA531E4B0C8DFD0)},
         {UINT64_C(0x69A6B3F8E585A960), UINT64_C(0x1627CC77BD3F567D),
          UINT64_C(0x6F4EF4305DB9CFD0), UINT64_C(0x05B567078D02278A)}},
    },
    {
        {{UINT64_C(0x6663F2F310B96338), UINT64_C(0x69373D1FCE8CA31C),
          UINT64_C(0x3D31C5CFD67AEC10), UINT64_C(0x2FAF554516F2547E)},
         {UINT64_C(0xF6E397D51EA2EA64), UINT64_C(0x2281A0DFEEAEBE7A),
          UINT64_C(0x72E53254FA2527EC), UINT64_C(0x660D059A76432155)}},
        {{UINT64_C(0xD3CA8B132C66D937), UINT64_C(0xC6F34B08CD2DF849),
          UINT64_C(0x9AF2C9E3A23A9F73), UINT64_C(0x24D44BD9702388E9)},
         {UINT64_C(0x8DA4D6A4D1B3DA10), UINT64_C(0xB9FAFBF440B93B10),
          UINT64_C(0xBBE51BB3EFCFD2A3), UINT64_C(0x68BE03951844581D)}},
        {{UINT64_C(0xDECABD8C0EA1FAE1), UINT64_C(0xA7499225FDFED7C2),
          UINT64_C(0x08489E35FB468B83), UINT64_C(0x5B68934443D95F9C)},
         {UINT64_C(0x9FC8364A9D2F522E), UINT64_C(0x114DB31A3A5D27A4),
          UINT64_C(0xC6A35992E33A9EC8), UINT64_C(0x6FE9EC3BDC9ACAF6)}},
        {{UINT64_C(0x98AE2D66DEAFC64C), UINT64_C(0x95AAC8EFABE706B7),
          UINT64_C(0xB15A6604223DFA3B), UINT64_C(0x77DBC24AE24B43CB)},
         {UINT64_C(0x65D6F8718542FA2A), UINT64_C(0x1093B2735D326A1A),
          UINT64_C(0xBA82D607F137AFEF), UINT64_C(0x502B32E3B9DEA6A7)}},
        {{UINT64_C(0x88906BD6885CA6CE), UINT64_C(0x136ADF9A1D36BFEE),
          UINT64_C(0xF844088C09AA61E3), UINT64_C(0x4E508EA351BAC299)},
         {UINT64_C(0x251ACD26EB821936), UINT64_C(0xDF6AD7D543D90E10),
          UINT64_C(0xEBCD7046DE7F14B9), UINT64_C(0x1DB258B1AB503259)}},
        {{UINT64_C(0x348E301890AD5D55), UINT64_C(0x0EF6BE737067806A),
          UINT64_C(0x072C113441627FCC), UINT64_C(0x48EE7606E904F823)},
         {UINT64_C(0xEE6AB582D9FD5EF3), UINT64_C(0x57765D0317AB50BC),
          UINT64_C(0x1CCFB407FB7DEC68), UINT64_C(0x2E1771C7141DF51D)}},
        {{UINT64_C(0xCBDD6235A013284B), UINT64_C(0x4D93FD8720D07125),
          UINT64_C(0xB3D055B3D485418E), UINT64_C(0x4EFB8763C67ADD2D)},
         {UINT64_C(0xEC3693821B2DF427), UINT64_C(0x2500979164D0DDF4),
          UINT64_C(0x9BD42FFC163056C8), UINT64_C(0x605277925B88BEBA)}},
        {{UINT64_C(0x6D5D6A869D82DADF), UINT64_C(0xC3BA9A167C24A1CA),
          UINT64_C(0x838167EC2E6981CC), UINT64_C(0x7FB5D8577E1E4237)},
         {UINT64_C(0x83B2C2FC86A40BC7), UINT64_C(0x679D2DFC6F9AC4FB),
          UINT64_C(0x0B3714CDE45455EF), UINT64_C(0x1C8D833D394A7797)}},
        {{UINT64_C(0x1FBF89614E641C9D), UINT64_C(0x3330DAB0D951DFC8),
          UINT64_C(0x9D4EBA4D051D96DB), UINT64_C(0x27C6DBF023066924)},
         {UINT64_C(0xB950C648DA5D1D79), UINT64_C(0x544D46BA5E9CD783),
          UINT64_C(0xFA77226FE69BA3EF), UINT64_C(0x0A93D219E4DA8423)}},
        {{UINT64_C(0x7C377CC65BDCA76B), UINT64_C(0x7DF505D7DC58D194),
          UINT64_C(0x18A24C0B13E389E1), UINT64_C(0x5E0782DD6C3972FD)},
         {UINT64_C(0x97AD477E6680FCE1), UINT64_C(0x6B07BF223CBAB792),
          UINT64_C(0xB8DF3C73DC68C9E2), UINT64_C(0x33AB5A4CC04B2749)}},
        {{UINT64_C(0xD151C7627E79B5A7), UINT64_C(0xA4356B79C82C7B8A),
          UINT64_C(0x931DDDE896E0A2E2), UINT64_C(0x40378EB252C54FDC)},
         {UINT64_C(0xA6BBD5E340C24003), UINT64_C(0xB4F3246E65C34FEA),
          UINT64_C(0x780B21ED9C767A23), UINT64_C(0x5F1E95FE52BD7E83)}},
        {{UINT64_C(0x4F3453DFCF39F9C4), UINT64_C(0xA3E1CFD1B8CC2CA6),
          UINT64_C(0xE49BC49C4B898859), UINT64_C(0x4FFD7BD66C0BF055)},
         {UINT64_C(0x7DE7604CD139AD1B), UINT64_C(0x6973F5EB2A3CE8FE),
          UINT64_C(0xAC66FF97F9501ECC), UINT64_C(0x3D96F1E2A97D46CD)}},
        {{UINT64_C(0x70D5A0D06106EB96), UINT64_C(0x938E038F398C1FD9),
          UINT64_C(0xE66B70071F3A1AA9), UINT64_C(0x42BDB264F5BD9308)},
         {UINT64_C(0x4B3FD7545AF84957), UINT64_C(0x9E3E17FA4E27DC6B),
          UINT64_C(0x384FCACD51D8560B), UINT64_C(0x42F00D11F8068C09)}},
        {{UINT64_C(0x794C1E6A7D5897D5), UINT64_C(0x4901097FDF72DCA0),
          UINT64_C(0xDED5B1920B01E4C4), UINT64_C(0x364FF58226DD41E9)},
         {UINT64_C(0xA3F92DCC32FCA925), UINT64_C(0x8A1FB329207AA09A),
          UINT64_C(0xA9274BD3F512AE3A), UINT64_C(0x161C82BCC47B9007)}},
        {{UINT64_C(0x482ECE3B7AE1175F), UINT64_C(0x97CAC7E8BDD5DC6C),
          UINT64_C(0x562253099FDA910D), UINT64_C(0x52A9893B9FC206B9)},
         {UINT64_C(0xAD9F2A9205BB5ACA), UINT64_C(0xB9EEFB5BA3B65716),
          UINT64_C(0xE7BC173B8DB5A8D4), UINT64_C(0x6715EC64399DAE9E)}},
        {{UINT64_C(0x780796D15E41AC75), UINT64_C(0x3E165C784FB3A0B4),
          UINT64_C(0x198599BA237103E9), UINT64_C(0x2C04C3F5FA7ED86B)},
         {UINT64_C(0x29547DA8AC9356F0), UINT64_C(0xCB345AB479EADA37),
          UINT64_C(0x1D15D377A295BF2D), UINT64_C(0x10292C9D2FDC8131)}},
    },
    {
        {{UINT64_C(0xADF3B54740E1DC7E), UINT64_C(0x420CE2DD1C345D14),
          UINT64_C(0xC08E3CBE21DC5C2D), UINT64_C(0x79FDC0006F8FCE80)},
         {UINT64_C(0x23EBDF7FCB105CE7), UINT64_C(0x793FC99D7C6794A8),
          UINT64_C(0x4CA3FB21293E3575), UINT64_C(0x7FB2ACB97BF73CC8)}},
        {{UINT64_C(0x67DB6C900FC8FCD4), UINT64_C(0x22A3DF5F7EE3B705),
          UINT64_C(0xD50EBF8BC7B2EDFF), UINT64_C(0x0C70104599522FB7)},
         {UINT64_C(0x1420CF02AD4F9044), UINT64_C(0xD78DBA23E5B59451),
          UINT64_C(0xDFDC1C7F6AEFD853), UINT64_C(0x560DEE94DEA1DAAB)}},
        {{UINT64_C(0x0F2355132167A78B), UINT64_C(0xCF4637029F441927),
          UINT64_C(0xD0AE2723A3D1505C), UINT64_C(0x3149D858CD9FBFF4)},
         {UINT64_C(0x2A73913AF79240FA), UINT64_C(0xC904A575252A958B),
          UINT64_C(0x10D1819078473D97), UINT64_C(0x42CE7A38203BC8C4)}},
        {{UINT64_C(0x1D2AD4F2FA59BB8B), UINT64_C(0x8234964C79F137DD),
          UINT64_C(0x00B63A305D02679E), UINT64_C(0x506C45BE5DD7543D)},
         {UINT64_C(0x4378F900776BF80C), UINT64_C(0x179558B2B312F2BB),
          UINT64_C(0x5B15368CEA37C183), UINT64_C(0x7593B19FB198E42D)}},
        {{UINT64_C(0xED723535DEFA1F48), UINT64_C(0x0DAFC48B87F96EE5),
          UINT64_C(0x0AEFA3BA91B1B52C), UINT64_C(0x56BA1B33A1ADBEA4)},
         {UINT64_C(0x8A0B617030A6C905), UINT64_C(0xC5BA3518B272D12E),
          UINT64_C(0x782100CF4B6643A9), UINT64_C(0x12DEE80385C5BD2B)}},
        {{UINT64_C(0xDD07D2D578FCADD6), UINT64_C(0x8CB8E8A83B25C523),
          UINT64_C(0x25063508530919CF), UINT64_C(0x45D3DD541E24F7A1)},
         {UINT64_C(0x296AE89349DDAF96), UINT64_C(0x7EF3CDE0ACE559F5),
          UINT64_C(0x9CDF22E40D36F87B), UINT64_C(0x196847654AC9A845)}},
        {{UINT64_C(0x3955B5ABC597B7AE), UINT64_C(0x59F3BA053AB49731),
          UINT64_C(0xBCA5B117F525C6C8), UINT64_C(0x4969C13432050B8D)},
         {UINT64_C(0x353183D9970E8E49), UINT64_C(0x3D005213E95300CF),
          UINT64_C(0x595F9C8E09022378), UINT64_C(0x70FA8B471A445C28)}},
        {{UINT64_C(0xECC88EE3BADB79EA), UINT64_C(0x5BDAF68CFBD8464E),
          UINT64_C(0x24AF6A4CB4280334), UINT64_C(0x17A5DE8B398E5BBE)},
         {UINT64_C(0x300B6DEB92999E18), UINT64_C(0xA076691867DEFC2F),
          UINT64_C(0x4E904450B19F87FF), UINT64_C(0x3010AD94C2871056)}},
        {{UINT64_C(0x72E747A1461EFCC3), UINT64_C(0x329EDF18562F923E),
          UINT64_C(0x65E021D4D081A4E7), UINT64_C(0x4B2DBFFFB727B6F4)},
         {UINT64_C(0x5A597A809C8505AC), UINT64_C(0x13486480562B82D2),
          UINT64_C(0x477FD480CC8234C3), UINT64_C(0x6045ABA404800C00)}},
        {{UINT64_C(0x3E0874399C541035), UINT64_C(0x389AA76C6D9D8B6A),
          UINT64_C(0x68FE5E8336A21299), UINT64_C(0x67AC313D402A32CF)},
         {UINT64_C(0x996131D225501A53), UINT64_C(0x5C1B89DEA77A85F4),
          UINT64_C(0xA9822C84ED6702AD), UINT64_C(0x50F014A456609EA0)}},
        {{UINT64_C(0xF0F8B4E6E5A8E91E), UINT64_C(0x734CFF081A2FFEFD),
          UINT64_C(0x9724EE0B27BCB163), UINT64_C(0x6AF3808B30B8EF68)},
         {UINT64_C(0xE5B3829F126E88FC), UINT64_C(0x0F441EE34EE5FD4B),
          UINT64_C(0x534D2F8CBFEC4D34), UINT64_C(0x3E1F16DE076E6737)}},
        {{UINT64_C(0x4DB53E8A4ED36E6A), UINT64_C(0x49A9EFE94352B22F),
          UINT64_C(0x7829605C39CF005C), UINT64_C(0x190A8E16D85DB959)},
         {UINT64_C(0x699810699B073AB3), UINT64_C(0x8C264B878C141AA1),
          UINT64_C(0x7F614282603ED47C), UINT64_C(0x21FD2E7A9F9B0940)}},
        {{UINT64_C(0xC5CA10A01EC6BB3D), UINT64_C(0x9403E3F527A9B02B),
          UINT64_C(0x9D3D186DFB43F790), UINT64_C(0x7855276E67DC0C00)},
         {UINT64_C(0x053DBB2AFFFFB14C), UINT64_C(0x2674666343ACC0A6),
          UINT64_C(0x1EE7A9467FFC1C68), UINT64_C(0x14BFAF0156DBB0DE)}},
        {{UINT64_C(0x11C89A47849EA674), UINT64_C(0x194FAAF094A540E6),
          UINT64_C(0xE61163F86050E4C0), UINT64_C(0x6939A166B1A07B76)},
         {UINT64_C(0x8166CA8E2EF18325), UINT64_C(0x96112E6530C042E2),
          UINT64_C(0xA805CAE05A394C25), UINT64_C(0x45A0DE010392E6BB)}},
        {{UINT64_C(0xB89CEE96B4FAAA56), UINT64_C(0x7A7DC8AE529736DE),
          UINT64_C(0x9158AA49A727FCF7), UINT64_C(0x621B8B311896B9DA)},
         {UINT64_C(0x875930D603BEC74B), UINT64_C(0x1056DB45A7A50309),
          UINT64_C(0xEE713E04B5657B0E), UINT64_C(0x2D68155E6FCAD967)}},
        {{UINT64_C(0x3BB1E9E365B1E2B3), UINT64_C(0x2A61567088425BAB),
          UINT64_C(0x22F4F32F62F1BA4A), UINT64_C(0x7B5EC25088A59642)},
         {UINT64_C(0x7B5BA12A42D30049), UINT64_C(0x4E6AC05586995BE6),
          UINT64_C(0x04431A0445EC87AC), UINT64_C(0x28974ED7ED94823D)}},
    },
    {
        {{UINT64_C(0x5925805712BB5555), UINT64_C(0x03141CD8BB7608EE),
          UINT64_C(0x84EBDC49EF77714B), UINT64_C(0x6A45FC3AB5DC1A5F)},
         {UINT64_C(0x1F6DC2052FBEEC76), UINT64_C(0x17EB733BA920C554),
          UINT64_C(0xDB022C217A28ACDF), UINT64_C(0x6AF16156A9B62BF1)}},
        {{UINT64_C(0x9379D6A880B472CC), UINT64_C(0x6CB08CB07BD92F27),
          UINT64_C(0x19B3C353147E6E12), UINT64_C(0x3C26CB2F26827839)},
         {UINT64_C(0x98AAC9A70CC571E4), UINT64_C(0x075D05F2C3C8FC04),
          UINT64_C(0x718B55A0D79621AC), UINT64_C(0x149FEECF5B94B41B)}},
        {{UINT64_C(0x6A150A64783F9C81), UINT64_C(0x5950C2DF0FB18827),
          UINT64_C(0xF5D75504F15E3A89), UINT64_C(0x5F92F2F7FCB4406B)},
         {UINT64_C(0x665F31E76123E858), UINT64_C(0x4E568EA9A95184A3),
          UINT64_C(0x851EEADC505FF0AD), UINT64_C(0x62AD5BA6542C3EF8)}},
        {{UINT64_C(0x1103859DC55C23FD), UINT64_C(0x06AB0BD6695E4E9B),
          UINT64_C(0x2CD00D76DD734990), UINT64_C(0x5D59C693B06460E4)},
         {UINT64_C(0x3BA8F2F01F9C76DA), UINT64_C(0x08E4A7EC960F5C0E),
          UINT64_C(0x79C82AD9E4AAB060), UINT64_C(0x093D322C0DF95C43)}},
        {{UINT64_C(0x88AF12580C627547), UINT64_C(0x81E5F197889A5E12),
          UINT64_C(0x99E0E1917CBD84FD), UINT64_C(0x3024BCE8DB0B9711)},
         {UINT64_C(0x04075C80DB93B1A2), UINT64_C(0x12F30AF8628B0E63),
          UINT64_C(0xA3514F26EB25A4ED), UINT64_C(0x3D42E4897BCD0873)}},
        {{UINT64_C(0x0F1C16C6754B236F), UINT64_C(0x717CE487594F5D3D),
          UINT64_C(0x7679C7DAAFAD77B1), UINT64_C(0x51AFD0146F3E724C)},
         {UINT64_C(0xAFC9745C3AF6938F), UINT64_C(0xCA12BFA9C4E61CB4),
          UINT64_C(0x943B56969425CCA7), UINT64_C(0x5BD3E65EB6E48A69)}},
        {{UINT64_C(0x2D23CF78DEAE74B1), UINT64_C(0xA686767E043BF2F1),
          UINT64_C(0x3AFED34DE464ADE9), UINT64_C(0x1E4620735A6AE80B)},
         {UINT64_C(0xA86AA408737F7B66), UINT64_C(0xD67A0B49EAB3B6CE),
          UINT64_C(0x6FF3CA4F275355F3), UINT64_C(0x6F385576688F99AB)}},
        {{UINT64_C(0xC9B63343FD2F9A72), UINT64_C(0xBD0A126DAC267E8A),
          UINT64_C(0x818BD5D85D2839B5), UINT64_C(0x1BBAB4CE0BF5AFCE)},
         {UINT64_C(0x2827B24A4D8B67DE), UINT64_C(0x841F6BD3C34E6642),
          UINT64_C(0xE9F5C1C25E4A34D4), UINT64_C(0x4E98795CFDA4177C)}},
        {{UINT64_C(0x3C9FF1C20763AB04), UINT64_C(0x4FC1BE619832FCFD),
          UINT64_C(0x5FA50C388BD0363A), UINT64_C(0x14C9BB2FF26206BE)},
         {UINT64_C(0xAD1A96EB1D31880C), UINT64_C(0xF0A37BC465DFCF8A),
          UINT64_C(0x389627293D048FE4), UINT64_C(0x017125C06480B254)}},
        {{UINT64_C(0x01E819F598D4BAC6), UINT64_C(0xD3686E0436B99D30),
          UINT64_C(0x0C2876FB200A4A9D), UINT64_C(0x45D50C2FE65782D5)},
         {UINT64_C(0xB8316ECE865B7A21), UINT64_C(0xA3ADB90FCC875503),
          UINT64_C(0xD72E864E98468FB4), UINT64_C(0x13BB23FDDED21F40)}},
        {{UINT64_C(0x653C3C15C6B96368), UINT64_C(0x9A42FC2C2B9C381F),
          UINT64_C(0xF06B41B969534D92), UINT64_C(0x46F7292E3FB7BED2)},
         {UINT64_C(0x14A2C42097D1875E), UINT64_C(0x45DFA824D3B2DF55),
          UINT64_C(0x59CB7E593F2BA72D), UINT64_C(0x2EEC65C9D7D96C98)}},
        {{UINT64_C(0x907CD4C849650405), UINT64_C(0xFC29320A37E05E06),
          UINT64_C(0x99B4C1DF09E29619), UINT64_C(0x74E69BF834DE993F)},
         {UINT64_C(0x62C0F296509D9797), UINT64_C(0x2E6BD4E65F1EF554),
          UINT64_C(0xE30506410D0B71B8), UINT64_C(0x29DA0C9D235DDE6C)}},
        {{UINT64_C(0x3CFBCA4B689398C1), UINT64_C(0x11E5880440C9DF13),
          UINT64_C(0x3923A39BBCDF2489), UINT64_C(0x3805CCC7387C8089)},
         {UINT64_C(0xC1B4EB4870319AFA), UINT64_C(0x0A6A5FA4CA089604),
          UINT64_C(0x16ABDE5473139A20), UINT64_C(0x7C0055E094BD61B5)}},
        {{UINT64_C(0xA5AB5CEFCB05A02A), UINT64_C(0xC0B4E1B40BFE903B),
          UINT64_C(0xBA528329EAC9E7E8), UINT64_C(0x0266C5A70A2456B6)},
         {UINT64_C(0x507E9A415E216EEC), UINT64_C(0xFCC06B0AD0F1E440),
          UINT64_C(0x6FAEFC8EE5C7B26F), UINT64_C(0x4744CF2EB02F85C1)}},
        {{UINT64_C(0xF5E2B8121C291BFC), UINT64_C(0xC18E791D2CDCBF7A),
          UINT64_C(0xC386B96246554345), UINT64_C(0x373E00FB067518CD)},
         {UINT64_C(0xC9BA9DF9E950051B), UINT64_C(0x182CB132DD6133EE),
          UINT64_C(0xD6D7F81570A3C71C), UINT64_C(0x44C5AEBC7FAFE307)}},
        {{UINT64_C(0x6C7CE359A9D16080), UINT64_C(0xA874386D1E8B643E),
          UINT64_C(0xA064812907F48E10), UINT64_C(0x2A40220193E4D619)},
         {UINT64_C(0x8B429545BD383EA6), UINT64_C(0xC096D593F2880536),
          UINT64_C(0xB4057D6C20E299B9), UINT64_C(0x303962CE38A825FA)}},
    },
    {
        {{UINT64_C(0x9E426EBF1E1D70D0), UINT64_C(0x6AEA4DDCB83529CA),
          UINT64_C(0xF3ECD4627CC9A07C), UINT64_C(0x7F255C86C364772E)},
         {UINT64_C(0x0DF212CF5613BEF0), UINT64_C(0x771F02A91309F9D0),
          UINT64_C(0xE97BEE39805FE1F5), UINT64_C(0x54A43430D93522B9)}},
        {{UINT64_C(0xC01553BDCDE4EBBE), UINT64_C(0xB1928DDCA02E56C1),
          UINT64_C(0xB91004BA94A1A417), UINT64_C(0x44F74BE656CB9C88)},
         {UINT64_C(0x6A7E3E9B921B62E5), UINT64_C(0xF2BF553B5FBF13C4),
          UINT64_C(0x51CB776D86D55641), UINT64_C(0x71826BC56425A3AD)}},
        {{UINT64_C(0xD6D49F90C6D70EF9), UINT64_C(0x5BD0DA6929EBA0DD),
          UINT64_C(0x0BBA7571803233EF), UINT64_C(0x0EB0959E679A17D5)},
         {UINT64_C(0x97818DC2B8A3D6EC), UINT64_C(0x09497FB0C687EAA2),
          UINT64_C(0x2E2707EAA65FA4C0), UINT64_C(0x6A74D4C67542F472)}},
        {{UINT64_C(0x0D1930061EE0BC40), UINT64_C(0x7D7BEE196DC98BA8),
          UINT64_C(0x1AD37C98447C38D2), UINT64_C(0x3E163AE1B6B4550A)},
         {UINT64_C(0x734E36C95BC93243), UINT64_C(0x54E217FD986C35A8),
          UINT64_C(0xF0576FF09E3285E3), UINT64_C(0x65C950C8186EE7EB)}},
        {{UINT64_C(0x1AB12C042012D277), UINT64_C(0x97CAB84B83872384),
          UINT64_C(0x479C9CF51C66FCFD), UINT64_C(0x70ABC8B4F276933E)},
         {UINT64_C(0xE6B15BF7BA4D14F0), UINT64_C(0xF4060ED322E2F5D5),
          UINT64_C(0xA53F3CA0CDC5462C), UINT64_C(0x593219D4C6FC3854)}},
        {{UINT64_C(0x9DE6993472B6F8A1), UINT64_C(0xECABAEEE19E16B3F),
          UINT64_C(0x0B537CA5EDA68D7B), UINT64_C(0x744628BDD3CE55B7)},
         {UINT64_C(0x3A5B2D8E98A95308), UINT64_C(0x74D0CEF16758C6C8),
          UINT64_C(0x7538198ADA204834), UINT64_C(0x1E166AAAA644E880)}},
        {{UINT64_C(0xE76EE7124674ACF0), UINT64_C(0x40A6F6DEDF9DFB4C),
          UINT64_C(0x91B0034C40C65721), UINT64_C(0x54FE8B8BF8E0F5E5)},
         {UINT64_C(0x6322CA0F75891895), UINT64_C(0x3D1C821E7D20C522),
          UINT64_C(0x1691407F08043786), UINT64_C(0x02C3083814847D58)}},
        {{UINT64_C(0x57DEF069B8F0C372), UINT64_C(0x50375DC30D5ABF2C),
          UINT64_C(0x2290381475EDFBC9), UINT64_C(0x56E39BD7AE37695A)},
         {UINT64_C(0xAB74B187463D13F2), UINT64_C(0xC50CB8A23CDE8886),
          UINT64_C(0x1EFBD1CFB35F7D59), UINT64_C(0x1296C4821057AE42)}},
        {{UINT64_C(0xA350B57BC347E3FB), UINT64_C(0x4312EB75ADF65129),
          UINT64_C(0xD9A7E2F47F9A6C9E), UINT64_C(0x5493AF7B9BFDCB4D)},
         {UINT64_C(0x90A443DD9AC0E58E), UINT64_C(0x9777D58AC6F3BEEF),
          UINT64_C(0x12F00913965EC900), UINT64_C(0x2F6C5B59480126DA)}},
        {{UINT64_C(0x70B907FCBAD8C051), UINT64_C(0x54492D6AD3B4F608),
          UINT64_C(0xE3B46F1B2E096D9F), UINT64_C(0x522AD6D1747D472A)},
         {UINT64_C(0x8FCD161602DAB5E5), UINT64_C(0xD3BA292F357B1C85),
          UINT64_C(0xA6DB50CD2704F072), UINT64_C(0x63488DDF8341AA73)}},
        {{UINT64_C(0x99100A3D0FE2AAAB), UINT64_C(0x7D30C4E98EA44560),
          UINT64_C(0xBA458C672B4C776D), UINT64_C(0x2EC11420BBA4D85E)},
         {UINT64_C(0xB1D9FBA27A7AEC55), UINT64_C(0x432AB2AA7665AAE5),
          UINT64_C(0xD2755948F3BC7043), UINT64_C(0x2FC331BB82510EAD)}},
        {{UINT64_C(0xAAF11CF946253DB1), UINT64_C(0xEB025AEDB0DF307C),
          UINT64_C(0xCB7C22A57A82ADEE), UINT64_C(0x7316C3909C5FA97B)},
         {UINT64_C(0x91620554F518067C), UINT64_C(0x20A438AE3C96A804),
          UINT64_C(0xC4F9DCDF5B0C090C), UINT64_C(0x77C512DB6E5C1B45)}},
        {{UINT64_C(0xC981E682FDD09EDE), UINT64_C(0xC3EB36B7BBB3F57D),
          UINT64_C(0xA07369C6D12BF450), UINT64_C(0x16627566CE017845)},
         {UINT64_C(0xFD8DEC909494AF62), UINT64_C(0x7E79309653FD4B22),
          UINT64_C(0x21B8E665C8AAEAE9), UINT64_C(0x526FA31818BC33C0)}},
        {{UINT64_C(0xF55D32BF853A2647), UINT64_C(0xD873ED6CCDAEE8FE),
          UINT64_C(0xA3579E2B80E52622), UINT64_C(0x03871ABA33D16FE8)},
         {UINT64_C(0x714804AC69925EDF), UINT64_C(0x0340755FF2B964FF),
          UINT64_C(0x93830F98DA0D1A07), UINT64_C(0x2CAB201EF7FB1E16)}},
        {{UINT64_C(0x26DE3A3A22A8AF77), UINT64_C(0x0E77C3DCB45BA630),
          UINT64_C(0x34F00017FC86E7D1), UINT64_C(0x796ABE2F1B62F7F2)},
         {UINT64_C(0x9FA092771663B5B1), UINT64_C(0xFFFDC93F9B2FB9AC),
          UINT64_C(0x03AECD1A6B340D75), UINT64_C(0x5D55A168314DCCEA)}},
        {{UINT64_C(0x678AEF02747DBD0C), UINT64_C(0xF0D47C1CD47A6C09),
          UINT64_C(0x6C2AC72F3FDD1681), UINT64_C(0x750E70646D789D3A)},
         {UINT64_C(0x3F970AFEAEBEDD58), UINT64_C(0x6BBA7956E3540951),
          UINT64_C(0x7CC461B23E71F6AF), UINT64_C(0x7E51E548C45FED28)}},
    },
    {
        {{UINT64_C(0x4A598EFB2CE2CBE5), UINT64_C(0x774CDE0A89C9A51B),
          UINT64_C(0x2D003680CA907F34), UINT64_C(0x62C32DCA9D3C7D97)},
         {UINT64_C(0x37B3A90FB3054D17), UINT64_C(0x1423574C67E58A5A),
          UINT64_C(0xF1D3BB1A4859FA49), UINT64_C(0x25F0AF1C3F5AFA63)}},
        {{UINT64_C(0xD3BF7F621FE53AC9), UINT64_C(0xCE2B67C3CBCE6164),
          UINT64_C(0xE081C57695341024), UINT64_C(0x32B0EF5D9A70ECAB)},
         {UINT64_C(0x3EC93C853BE1E5CE), UINT64_C(0xE25F54EDA0CB7DCD),
          UINT64_C(0x9D6B57D7517965B2), UINT64_C(0x159F7AB0129B0B27)}},
        {{UINT64_C(0xAEF88E95EEFB67F3), UINT64_C(0xEAEB2889E0316AB2),
          UINT64_C(0x1491881FC2CB6753), UINT64_C(0x67DCDF28702789D0)},
         {UINT64_C(0x8282E0A711C0F3FD), UINT64_C(0x9CDCFDB801BA273D),
          UINT64_C(0x6BF1E04326279B95), UINT64_C(0x0D42AAC685852777)}},
        {{UINT64_C(0xC4CE393E608981AB), UINT64_C(0x210E20F852141CB0),
          UINT64_C(0x22C2586D6B9234B5), UINT64_C(0x52F1B3664366750E)},
         {UINT64_C(0xE38ED0D9760AFA55), UINT64_C(0xA43FF25AB5D61A08),
          UINT64_C(0x0BE3A406B5E21691), UINT64_C(0x37B47A28FD4E17B0)}},
        {{UINT64_C(0xC46DC6D44C2C65C2), UINT64_C(0x2A0B452CC54BE778),
          UINT64_C(0xAF113693F727070E), UINT64_C(0x7B229CD8C68D13A3)},
         {UINT64_C(0x0F63097E02D43E4B), UINT64_C(0x912F8D3355627FD8),
          UINT64_C(0x1EBF39612A0DD9AE), UINT64_C(0x7FD33FDEF0294B2D)}},
        {{UINT64_C(0xC72411F5D0CC6D9F), UINT64_C(0x66E04C909B92FF84),
          UINT64_C(0x0678B4F8E1C033B6), UINT64_C(0x5A99F270E49A972A)},
         {UINT64_C(0x3743BCD8D265A4DF), UINT64_C(0x7BD6DDF4CE0404C3),
          UINT64_C(0x4043767F131750A5), UINT64_C(0x4A7D89839DD65652)}},
        {{UINT64_C(0x535BC78412B7822D), UINT64_C(0xDD32DD67F1F9B703),
          UINT64_C(0xFFDBF0EB2EAA2A1C), UINT64_C(0x497C09FAF64E9822)},
         {UINT64_C(0x18E717E932EE2A36), UINT64_C(0xF01CC4F5583949B1),
          UINT64_C(0x222EE9740A168755), UINT64_C(0x0CD14CD500C81EC9)}},
        {{UINT64_C(0x7AE0BD1114C79CDC), UINT64_C(0x67323D1A6DC08C80),
          UINT64_C(0x2FD1ABC70EF32432), UINT64_C(0x65923246B0E08EBF)},
         {UINT64_C(0x0A9FD3D7C0754ECE), UINT64_C(0xE76B26245F8644FA),
          UINT64_C(0xF1F0BEBA0F8BB385), UINT64_C(0x73251F03FC96778F)}},
        {{UINT64_C(0x197150DED08795A9), UINT64_C(0xAD6935AEFBB8B9CF),
          UINT64_C(0x721186823B2B9EFB), UINT64_C(0x265B288DBC2B7240)},
         {UINT64_C(0x7BF2EB362F78C431), UINT64_C(0xF03B83CAF2A6E469),
          UINT64_C(0x211592564740E74B), UINT64_C(0x35BE57350490F0B9)}},
        {{UINT64_C(0x207F33B2806C1CAE), UINT64_C(0x04249127DAC5ADE0),
          UINT64_C(0xC4CCF33E1CC59DE7), UINT64_C(0x2A17B520272BD6D7)},
         {UINT64_C(0xC36F6B3CB48F6585), UINT64_C(0xD32A73790861ACF5),
          UINT64_C(0x28A12ECB2C3291C6), UINT64_C(0x0E945F95F02A88D0)}},
        {{UINT64_C(0x4836EC01D3B3117B), UINT64_C(0x4C197454A4C2FD72),
          UINT64_C(0x96FCED51F9897721), UINT64_C(0x142028585828C97D)},
         {UINT64_C(0xCA7ACED8774755B9), UINT64_C(0x460FF58297252559),
          UINT64_C(0xAAE457765796DD63), UINT64_C(0x711C916E346DDBF5)}},
        {{UINT64_C(0xA60E2E7B5E203692), UINT64_C(0xCFC72FEAF3BF2A45),
          UINT64_C(0x78729D2872AC0436), UINT64_C(0x3E16DD8B29ABF199)},
         {UINT64_C(0xB1705AA615A41F3D), UINT64_C(0x8C7512FE308AB87C),
          UINT64_C(0xA27411C503995381), UINT64_C(0x3142403CA780CED3)}},
        {{UINT64_C(0xE4473E94F1718C7F), UINT64_C(0x601BC194A3CAB6CB),
          UINT64_C(0x8F3540F8581D491D), UINT64_C(0x456A9B7C43C15321)},
         {UINT64_C(0x6F335A2D593BB7ED), UINT64_C(0xB6D5A23F7D791514),
          UINT64_C(0x976D2F8379235EAD), UINT64_C(0x7D02EA0F44775C97)}},
        {{UINT64_C(0x322DBC8CE5EC268E), UINT64_C(0x1F2F6050BE14BF5C),
          UINT64_C(0x58AC6397EACF6A50), UINT64_C(0x4167CBD5A5401081)},
         {UINT64_C(0x8E6F06A1EE5B4BF5), UINT64_C(0x1A6073D56B2F790F),
          UINT64_C(0x1C09FF3D4F901250), UINT64_C(0x286AF8D7E6B40DF4)}},
        {{UINT64_C(0xF74C805706BD53FF), UINT64_C(0x4FCE7281E5788F0D),
          UINT64_C(0xD6A867AC3D015E6B), UINT64_C(0x04AEC38D6E185A42)},
         {UINT64_C(0x8DC12B74083D65CB), UINT64_C(0xDB1AA8AC82966668),
          UINT64_C(0xBD2233BF28AF1B90), UINT64_C(0x544569A7172CCA11)}},
        {{UINT64_C(0x9C56FCA8149BD0BD), UINT64_C(0x2B4EC788A05F8E44),
          UINT64_C(0x1569CF6D92478943), UINT64_C(0x67E373E857380986)},
         {UINT64_C(0xF5CC8232ED3C14DB), UINT64_C(0xE3D184B0F52EAF83),
          UINT64_C(0x195D41370BC64038), UINT64_C(0x77994388778C3C20)}},
    },
    {
        {{UINT64_C(0x3DAA0C47A0CC77AA), UINT64_C(0xB9794E747C69CDF0),
          UINT64_C(0x3610E50B4549F5D4), UINT64_C(0x262CA564B8A112CA)},
         {UINT64_C(0xD5EC795E554E8714), UINT64_C(0x73EE5502717EBEF3),
          UINT64_C(0xE36E8A1A1947A478), UINT64_C(0x3FBE43A342ADC59D)}},
        {{UINT64_C(0x4DE78909021FBCBE), UINT64_C(0xA76A5EE20BBBB324),
          UINT64_C(0x5B86519ACD67810B), UINT64_C(0x4CCA44A23710A4EE)},
         {UINT64_C(0xD79A121DCD1F8BEC), UINT64_C(0x2E12A772DC9CA10E),
          UINT64_C(0xE301CA3B8C9E9640), UINT64_C(0x4B25FE18B731A957)}},
        {{UINT64_C(0xA05DA2CDF4AD7264), UINT64_C(0x31336489076977A5),
          UINT64_C(0xC1D269BEF2E576A8), UINT64_C(0x1E877ADC7532203F)},
         {UINT64_C(0x9C9961BC8B92972C), UINT64_C(0x7BA072726A14D810),
          UINT64_C(0xE51095A906913136), UINT64_C(0x4674896930E0EA8C)}},
        {{UINT64_C(0xDB8EF3463C73BA49), UINT64_C(0xBF2213123720570D),
          UINT64_C(0xC07B3639605DB0D6), UINT64_C(0x44FCEFA6300336A3)},
         {UINT64_C(0x121FAC5C2D234592), UINT64_C(0x901DEE8844E367D7),
          UINT64_C(0x5B5F3DD61CAA6A3A), UINT64_C(0x72E474ECAC2F6E64)}},
        {{UINT64_C(0x15690BEEF55BE61C), UINT64_C(0xE42B945EDF2678A2),
          UINT64_C(0x60A5C8AA3B7B1776), UINT64_C(0x16103FBCEB9AB938)},
         {UINT64_C(0x79722A1E87AD06AB), UINT64_C(0xD7B509F6D6B632A2),
          UINT64_C(0x8C4E8B2E3B69EB40), UINT64_C(0x6A50958314DB2225)}},
        {{UINT64_C(0x169F35D893B78659), UINT64_C(0x989B04D28EFF83AD),
          UINT64_C(0x72CF7338A6AE4806), UINT64_C(0x6E156C84F4AAA524)},
         {UINT64_C(0x33A608EDA1ED5CB2), UINT64_C(0xCE274A64C3D28716),
          UINT64_C(0xFCF1B17045F0435F), UINT64_C(0x101D1BDB1653D6F6)}},
        {{UINT64_C(0x45BC931D2E5A67D9), UINT64_C(0xAFF02C11697DA479),
          UINT64_C(0x7C7972A32EA3E6E1), UINT64_C(0x71A17D505E97BB90)},
         {UINT64_C(0x962E84F219AD4C5E), UINT64_C(0xBB8C9FC7692020BE),
          UINT64_C(0xA78FDF2CE7B36665), UINT64_C(0x7AC84ED426F92E33)}},
        {{UINT64_C(0xBD85A9EEC3C9E5C1), UINT64_C(0x72030BAA6ED2FD6A),
          UINT64_C(0xB67185AB39CFFB89), UINT64_C(0x3E2E51A4833BF770)},
         {UINT64_C(0x248FA3485E27D5BB), UINT64_C(0xF8D435962E6D3DCF),
          UINT64_C(0x07F5B93C0C8DAF81), UINT64_C(0x6A7FFA1DAD2FC97D)}},
        {{UINT64_C(0xFF308FAEFAEA33F1), UINT64_C(0x5F29DFFB3CC4C7CF),
          UINT64_C(0xB9AD4527ECC5A2B9), UINT64_C(0x08B95AF6048D4B38)},
         {UINT64_C(0x56BC43A8DEC152BB), UINT64_C(0xD1147B9A3849D869),
          UINT64_C(0xFE5020C2D02AF3B7), UINT64_C(0x54C02B44B918496E)}},
        {{UINT64_C(0x1611ECFD0B27468D), UINT64_C(0x4AFCE3290513A562),
          UINT64_C(0x982782FD2FE74EED), UINT64_C(0x66AC58BF17ADD2EA)},
         {UINT64_C(0x8277BC2D613581D4), UINT64_C(0x0BF5BF0C988D1498),
          UINT64_C(0x8A37134D55C984CB), UINT64_C(0x409A79CC92211390)}},
        {{UINT64_C(0x8C0081AE816F0462), UINT64_C(0xB431DC245A68BFC2),
          UINT64_C(0x25C769C65F78C8A1), UINT64_C(0x3BE0458DB382AF14)},
         {UINT64_C(0x10583083A171ADF2), UINT64_C(0xBA5D532537F7C39F),
          UINT64_C(0x76B03B945EAC7585), UINT64_C(0x76159AAC9C2DF2C6)}},
        {{UINT64_C(0x886C73BA918E0332), UINT64_C(0xF6FEC62AD24B5B52),
          UINT64_C(0xB98759B436B4D23A), UINT64_C(0x5EC5B3FE5480ACF3)},
         {UINT64_C(0x30FF297D6DD175BF), UINT64_C(0x501DE74475F2B9C3),
          UINT64_C(0xDEBE47CAF19230C5), UINT64_C(0x7401F20932BBBB62)}},
        {{UINT64_C(0x80712E4722496D1E), UINT64_C(0x36A0EF37DA80AF1D),
          UINT64_C(0xAF6CA51C940E5E9F), UINT64_C(0x74E17B6F722D9D22)},
         {UINT64_C(0xCB70B878B8B3AE1B), UINT64_C(0xBF8B9A0B07DF974C),
          UINT64_C(0x89FCC996F68A4BF4), UINT64_C(0x46F581E86EB0FB2E)}},
        {{UINT64_C(0xBCE0BD6C67137153), UINT64_C(0xAD3E92B375F64B78),
          UINT64_C(0x6454CD1DFD047DD9), UINT64_C(0x181C93EB612AE472)},
         {UINT64_C(0xE575307E23A529C3), UINT64_C(0xB9C43A0B59C09EB5),
          UINT64_C(0xFD233A68AA805840), UINT64_C(0x067C442EA122FFB9)}},
        {{UINT64_C(0xE1F3F76F2CD6762E), UINT64_C(0xFB68650F9764B53A),
          UINT64_C(0x4E90AC72F1224580), UINT64_C(0x2BF68F01127EED48)},
         {UINT64_C(0xE6B4B40994D389A0), UINT64_C(0xD7BC8108D44593D6),
          UINT64_C(0xDCF0399148A86677), UINT64_C(0x4A52D961CEBCE3C7)}},
        {{UINT64_C(0x55734AB5BAA873EA), UINT64_C(0x506DE4CF7871F323),
          UINT64_C(0x7C3F8B00578612C0), UINT64_C(0x730D4B8A9243C9E8)},
         {UINT64_C(0xA3290689D385F6BD), UINT64_C(0xAF688C6A913596F5),
          UINT64_C(0x0A2D89B5B646BE23), UINT64_C(0x31891165F63A6029)}},
    },
    {
        {{UINT64_C(0x331F9E57579583C0), UINT64_C(0xE92ABADF69C65DA2),
          UINT64_C(0xC796FBECA5B8B057), UINT64_C(0x52E6F9C9312D1E89)},
         {UINT64_C(0x0318B1DFDA68DFD3), UINT64_C(0x8BAA2EB3A1CAC4F1),
          UINT64_C(0x0CDC89A2BEE7D6E1), UINT64_C(0x6102DE7A22AB50F4)}},
        {{UINT64_C(0x02003D83E20C707A), UINT64_C(0xD819249C28289D89),
          UINT64_C(0x3FBC00B172053FF8), UINT64_C(0x0249C43CDF40D261)},
         {UINT64_C(0x8794EEACD8F064AF), UINT64_C(0xE2359E70DC9F0631),
          UINT64_C(0xD1603647ADA310D0), UINT64_C(0x6A9E3785EDC888EC)}},
        {{UINT64_C(0xF332B384EC41908E), UINT64_C(0xF3274472BDE4760B),
          UINT64_C(0x96185E89140D0EF4), UINT64_C(0x5646208990E698E7)},
         {UINT64_C(0x841A31C5F2E64396), UINT64_C(0x8F494CA503C4118F),
          UINT64_C(0x0C98A4C31A188305), UINT64_C(0x1C4B5F6298AAB1AB)}},
        {{UINT64_C(0xDDEEEBF85D0D8381), UINT64_C(0xD1616F4889044363),
          UINT64_C(0x2EE41D4721616A13), UINT64_C(0x2DCE61104BC769FC)},
         {UINT64_C(0xE3707A0116C1C468), UINT64_C(0x3B674187969AF612),
          UINT64_C(0xB64BD4D71E0671CC), UINT64_C(0x7EF01DBAB98C297C)}},
        {{UINT64_C(0x91DCBF99815381AC), UINT64_C(0x8D711F5838B67B97),
          UINT64_C(0x9C11F5959C6E322C), UINT64_C(0x4A688D0BE31A782F)},
         {UINT64_C(0x1297D9F3DCE93F5B), UINT64_C(0xA79561947C1DC62A),
          UINT64_C(0x340F217A5F718F63), UINT64_C(0x71F84529FCC0EF6A)}},
        {{UINT64_C(0x0D968E503DD00963), UINT64_C(0x5E696D79D7FF66C3),
          UINT64_C(0xAA52D60D499A9BE2), UINT64_C(0x72482C45CDC289DE)},
         {UINT64_C(0xC84968F57FFAAD3A), UINT64_C(0xEE91304CF7CD5BED),
          UINT64_C(0x684936760A7CC7C0), UINT64_C(0x3411AFA780023968)}},
        {{UINT64_C(0xA0AEBC706E3294C0), UINT64_C(0x93263942DC385E50),
          UINT64_C(0x7B90C0028467FB06), UINT64_C(0x29477CA438CFD0FF)},
         {UINT64_C(0xADC04D8192A748D5), UINT64_C(0xAE4F309D76CF3AE5),
          UINT64_C(0xBDA34BF04BB2C2FF), UINT64_C(0x65138897368536E4)}},
        {{UINT64_C(0x9CB8F7D66FE6D4D6), UINT64_C(0x6C2FFBF5AF246792),
          UINT64_C(0xD5A4F34981524707), UINT64_C(0x3AFE45CE36766D5E)},
         {UINT64_C(0x41991B49513BA267), UINT64_C(0x06EF1EEA6C18AA5E),
          UINT64_C(0x0A51763588EA2099), UINT64_C(0x32D2B5E2D245B88B)}},
        {{UINT64_C(0xAE38CDD53F517C5B), UINT64_C(0x1C94FDC5D878FEEE),
          UINT64_C(0xABF7A41DBEFCE107), UINT64_C(0x33BF3FE9D408DFE8)},
         {UINT64_C(0x4F2E6FF0947CB8C4), UINT64_C(0x3A8E86ABF998C5A0),
          UINT64_C(0x3ADC6ABAE359209F), UINT64_C(0x37A2DE1BD9A50051)}},
        {{UINT64_C(0x424F4E34E718F6B9), UINT64_C(0x50B1A03B75C58EB6),
          UINT64_C(0xB949531491390E27), UINT64_C(0x4AE0CC3A880E78D8)},
         {UINT64_C(0x10331AFAF1E4413C), UINT64_C(0xE7A3E554DDFCD2F0),
          UINT64_C(0x44F6DE850EBF484B), UINT64_C(0x6A762A7E895D0F54)}},
        {{UINT64_C(0x8E606B0A8D0558F6), UINT64_C(0xAADA76045C4DD930),
          UINT64_C(0x5B2FC7ADEF4ACAD0), UINT64_C(0x0D969AD087F5B6E2)},
         {UINT64_C(0xF9A182B25974E67B), UINT64_C(0xCD8232E723B4009A),
          UINT64_C(0x3D8F5DDD285BCC3F), UINT64_C(0x114AC56FEEE1B9BF)}},
        {{UINT64_C(0xD3EA1B56AA45085A), UINT64_C(0x5DE7BB70D314CEDF),
          UINT64_C(0x8A74384C7BCCDCFD), UINT64_C(0x64B80F8A8E0E0367)},
         {UINT64_C(0xA9EA432B48884ED1), UINT64_C(0x51957A8F8C0BA810),
          UINT64_C(0x9E88340039E810E3), UINT64_C(0x0A73ED5A28B2051C)}},
        {{UINT64_C(0x655212A313C30826), UINT64_C(0xAE53668EB73E8660),
          UINT64_C(0x6C33B649FF108CCE), UINT64_C(0x39E0B11821D49681)},
         {UINT64_C(0xFE4D215270525312), UINT64_C(0x2EDCE32BFFD18749),
          UINT64_C(0xFED19B1CB04D3FB8), UINT64_C(0x4DFE216B2B225A9D)}},
        {{UINT64_C(0x583E8A6C4C70F8A8), UINT64_C(0xC8206231954A9AE1),
          UINT64_C(0x9360B592B76517B1), UINT64_C(0x362C5C5CEED10CCA)},
         {UINT64_C(0x3DBA95953D607921), UINT64_C(0x0188A5D65A6ECC40),
          UINT64_C(0x0EAB43C16CFF4ADE), UINT64_C(0x1F3673AEDE3347E0)}},
        {{UINT64_C(0x7300C4B3796593EE), UINT64_C(0x607E7E76D8D926C3),
          UINT64_C(0x1762CE2677F9FD06), UINT64_C(0x0D0478B3CEA891EB)},
         {UINT64_C(0xB11297912618B09E), UINT64_C(0x5F9D290D33F928C9),
          UINT64_C(0xE3192631E6178DB0), UINT64_C(0x21260AC808576D3F)}},
        {{UINT64_C(0x899DAF2A76968E1C), UINT64_C(0x0519DEA9F9C2B3E7),
          UINT64_C(0x5FDADC3893D0BD4E), UINT64_C(0x0467BFF743B4D98F)},
         {UINT64_C(0x651C316C6F3936C9), UINT64_C(0xE757689AAF27DF8B),
          UINT64_C(0x3AB037EAA0FA9188), UINT64_C(0x2F8B039BD927B60A)}},
    },
    {
        {{UINT64_C(0x72211BF5DE876A70), UINT64_C(0xA836163173D121CE),
          UINT64_C(0x2385272123D419E4), UINT64_C(0x3F56D47EDBD03345)},
         {UINT64_C(0xFB0E91A5D6F05BAC), UINT64_C(0xA0E02BF6AC9D0F46),
          UINT64_C(0x5ED9EA2C97F1812F), UINT64_C(0x172F564FEBD5DB5A)}},
        {{UINT64_C(0xC790E91281F11E58), UINT64_C(0x14A1763099A5DFF7),
          UINT64_C(0xF6F30F2F1627516D), UINT64_C(0x522CAD8FEFCF43B7)},
         {UINT64_C(0xFFADD45E6EA01128), UINT64_C(0x5D23234CD61D1964),
          UINT64_C(0xE9212C852802DF86), UINT64_C(0x0A3D237B92AA8DA3)}},
        {{UINT64_C(0x2CED05F4E50ED356), UINT64_C(0x1CBC7FB1BFFEEF3A),
          UINT64_C(0x885991B1BE19F0F0), UINT64_C(0x6DED0794DE44A492)},
         {UINT64_C(0x9967E83444CBECFC), UINT64_C(0xB0674A8D6A792ED1),
          UINT64_C(0x360E2DE4B7DDD557), UINT64_C(0x26852A7470E95D26)}},
        {{UINT64_C(0x8CBC15203A6E2116), UINT64_C(0xF09327DFBF285BBE),
          UINT64_C(0x8C7D9AD54A54D3C5), UINT64_C(0x778F54E66BD2768F)},
         {UINT64_C(0x09B489F88FF3DBC0), UINT64_C(0x0A0FA7FBD2871932),
          UINT64_C(0xABB9DC38E0A8CEC4), UINT64_C(0x2EE092D821E37A50)}},
        {{UINT64_C(0xBB9256E7AF6D88D8), UINT64_C(0x3CDCB1CB0A218927),
          UINT64_C(0x8E5B744AF216D6E6), UINT64_C(0x6F0617F2BC885AFD)},
         {UINT64_C(0xFBA9CDA7268397D5), UINT64_C(0xC61547165D4C75D8),
          UINT64_C(0x9ED8D17B43FB2CD2), UINT64_C(0x4D0CE3FBBE45BC5C)}},
        {{UINT64_C(0x4259BB02A38472F5), UINT64_C(0xFAFAAE0315107D0E),
          UINT64_C(0x2B8E450ECF0CF2B6), UINT64_C(0x788674C3ED887C3A)},
         {UINT64_C(0x1F3EBD594B3D2EAC), UINT64_C(0x82CB568475E41B55),
          UINT64_C(0x005AB76BC02BE49A), UINT64_C(0x6F13ADD2F5F90FEE)}},
        {{UINT64_C(0x0116374A7AFA7161), UINT64_C(0x8A1AE4482DB7F824),
          UINT64_C(0xD3C0DA12DB656A22), UINT64_C(0x7B095B95B989204D)},
         {UINT64_C(0x24C35202EF8F21CA), UINT64_C(0x91088DA72DA5A5A1),
          UINT64_C(0xAAF1944BE3F97D68), UINT64_C(0x245D28487C884134)}},
        {{UINT64_C(0xD80C65D668F5C702), UINT64_C(0xE2FE245F021A2974),
          UINT64_C(0xFB8520E03A11899C), UINT64_C(0x4806D1FA2BE6BF88)},
         {UINT64_C(0xF6F8C11A20ED235F), UINT64_C(0x52AC14247F0D651E),
          UINT64_C(0x44C3C89FDB9CF6D6), UINT64_C(0x6762516DB2E2E41F)}},
        {{UINT64_C(0x2743D874FDE91600), UINT64_C(0x60975FD5CDF00100),
          UINT64_C(0x78ACC8642D2954F4), UINT64_C(0x46B9E60256373454)},
         {UINT64_C(0x7586A9706F0FB867), UINT64_C(0x888E3677242DF35A),
          UINT64_C(0x5A639E79F1460F62), UINT64_C(0x1256517E55297DBC)}},
        {{UINT64_C(0x3F78339B7B9294C3), UINT64_C(0x5BA765D1BCE77012),
          UINT64_C(0xA88E0CD8512E39E2), UINT64_C(0x2D63E14BF6BA6A6A)},
         {UINT64_C(0xF849A163EA29071B), UINT64_C(0xF32519B74C0A2E22),
          UINT64_C(0xEA5D1315561C35F5), UINT64_C(0x7041F515D9267DCA)}},
        {{UINT64_C(0xE01E839F1FE56E6B), UINT64_C(0x3E473D8C4A93CE88),
          UINT64_C(0xC4846ECF89AAFDAE), UINT64_C(0x4111D97A07D946EA)},
         {UINT64_C(0xC20881F651A45F02), UINT64_C(0x14C2AC95B9CD841A),
          UINT64_C(0x2FBE8329F2CBD929), UINT64_C(0x1E8B7469C812608B)}},
        {{UINT64_C(0xB36A5D03007F0A5D), UINT64_C(0xA7E7A1A85DCF7AF4),
          UINT64_C(0x7227F4C5BEB12AFB), UINT64_C(0x462277924D276783)},
         {UINT64_C(0x9EA64D4C48403B93), UINT64_C(0x58EA31BC0B333ED5),
          UINT64_C(0x2D6DD219C5C93119), UINT64_C(0x385023A745069280)}},
        {{UINT64_C(0x8AB9B9EAF60C46AF), UINT64_C(0xFA1D3F08E8B827C2),
          UINT64_C(0x78C6BFBC1BAD41DB), UINT64_C(0x527A0BED23BE0C1E)},
         {UINT64_C(0x66212FD26ACCE641), UINT64_C(0x86125B0DEE6F78E7),
          UINT64_C(0xA2A0271858552A8C), UINT64_C(0x594F2B777E9605C5)}},
        {{UINT64_C(0x3FB1F6CF88A27989), UINT64_C(0xBC4962F7D96268B8),
          UINT64_C(0xBD8761E9B95E2A36), UINT64_C(0x64AB934A046DEC63)},
         {UINT64_C(0xC64D1C592E53CF1A), UINT64_C(0xC9865A9B578C5E8C),
          UINT64_C(0x5ECA62327A0359DE), UINT64_C(0x127DD136FB4685E5)}},
        {{UINT64_C(0xB0F7B0711AE320C9), UINT64_C(0x09BF89BB52525203),
          UINT64_C(0x97B20027709C5692), UINT64_C(0x16A62485EDBF6175)},
         {UINT64_C(0x32C18836394C50F9), UINT64_C(0x7D99468FD3B98C19),
          UINT64_C(0x8EBE50962E8D2729), UINT64_C(0x4E75B3CCE655F093)}},
        {{UINT64_C(0xCBEFD1A29EAE827E), UINT64_C(0xDE2D1234FBF4630D),
          UINT64_C(0x1B3ADCF896086CDA), UINT64_C(0x43D3960E2EA6CBA7)},
         {UINT64_C(0x18321D1D1CB5A0F7), UINT64_C(0xDC94C6F947BEABB4),
          UINT64_C(0xFBACC6D575AF6AB7), UINT64_C(0x0EE5D35789B98E86)}},
    },
    {
        {{UINT64_C(0x3F01B4AA062E0994), UINT64_C(0x994B28B05C952259),
          UINT64_C(0x2678F8B80CDEEC70), UINT64_C(0x4D06AF84212436F3)},
         {UINT64_C(0xE9DF52FD1CF27A98), UINT64_C(0xD56B9FD10B7718F7),
          UINT64_C(0x728BE624D9AEDA0D), UINT64_C(0x098710881A646888)}},
        {{UINT64_C(0xB1BC922D9B586B13), UINT64_C(0x6C084C543CA3B1BA),
          UINT64_C(0x54D196C7CF322698), UINT64_C(0x06EC3A5585D527E1)},
         {UINT64_C(0x069187102A57CAA1), UINT64_C(0x6AEAC07D65FD0F6B),
          UINT64_C(0xB66A34D70F512F84), UINT64_C(0x3860C002A44E6452)}},
        {{UINT64_C(0x17263B260881608A), UINT64_C(0x78D556AA56C18A7A),
          UINT64_C(0xA0826A1CAC3A47AB), UINT64_C(0x61686A58B6933FF5)},
         {UINT64_C(0xEA9D8771DBCF2C4F), UINT64_C(0x1C66EB026AB00426),
          UINT64_C(0xF8DAED2B401C466A), UINT64_C(0x1ED0A99ADAAE8040)}},
        {{UINT64_C(0x31EFFC4B7208E58A), UINT64_C(0x28868456B4E4319E),
          UINT64_C(0x1059C249D46AC4DA), UINT64_C(0x3589D2122279B362)},
         {UINT64_C(0xB28B8FAD45552E92), UINT64_C(0xC9E32541C3AB8098),
          UINT64_C(0x82604904F14B35A1), UINT64_C(0x1E64A89FDB68C214)}},
        {{UINT64_C(0xDF0E223DAB6947AF), UINT64_C(0xE74EF1D6771670D0),
          UINT64_C(0x70A9AD21F429F03B), UINT64_C(0x7CB1FA1F1385B8DC)},
         {UINT64_C(0x25ABC0A769053D24), UINT64_C(0x207FE30A6369D02E),
          UINT64_C(0x57B76E3CC6E4EC2C), UINT64_C(0x2E03D2E3B927CAB2)}},
        {{UINT64_C(0xEFA377FF622D57AE), UINT64_C(0x41532F56A885951A),
          UINT64_C(0x5ED89AA7CC69B9A8), UINT64_C(0x60BFF2EC295F5E84)},
         {UINT64_C(0x411D65C31E5C3041), UINT64_C(0xDB533F8B4B7772F8),
          UINT64_C(0x72CADEB63BDD4AEA), UINT64_C(0x0EC79DF27C49E454)}},
        {{UINT64_C(0x0C39332C81D0B84B), UINT64_C(0xA76A9A3A95FF472B),
          UINT64_C(0xD12FEB9931DB2BA6), UINT64_C(0x4AAB92223683E53A)},
         {UINT64_C(0x56CB18AF24FC6271), UINT64_C(0x671581D62544C72D),
          UINT64_C(0xCD136492FBD6F4D1), UINT64_C(0x6C2023183579EE09)}},
        {{UINT64_C(0xEDC5AF02C103C348), UINT64_C(0xDA32344E155A103D),
          UINT64_C(0xFF3A7679B0D1377E), UINT64_C(0x1609197268F02750)},
         {UINT64_C(0xD4C6360DD9E9C143), UINT64_C(0xE0ABA0EF968EE990),
          UINT64_C(0x5781687897E4C9AE), UINT64_C(0x5A4D167B9D63E32D)}},
        {{UINT64_C(0xB04BA52550E25802), UINT64_C(0x011DA36E66912F15),
          UINT64_C(0x08D8B68019E0A182), UINT64_C(0x66AA4AE82E462B0F)},
         {UINT64_C(0x3227C3A6E0B9D283), UINT64_C(0x9BF8C4D0F2B2B096),
          UINT64_C(0x1E51416CBA809EB7), UINT64_C(0x68411B752A67D346)}},
        {{UINT64_C(0xE55B134837A67F3B), UINT64_C(0x5E32D73C96484391),
          UINT64_C(0xC3F804D56256B91E), UINT64_C(0x67F17A4703B0783B)},
         {UINT64_C(0x2010EFEBDD2334AD), UINT64_C(0xBD9965B5B10FF052),
          UINT64_C(0x519CDA6DF58ACA52), UINT64_C(0x045BEEBE2FD3D394)}},
        {{UINT64_C(0x81722E2CEA271BCD), UINT64_C(0x393C082E0A4F1342),
          UINT64_C(0x573F7CD553B345CE), UINT64_C(0x7AD71FE23D7B4292)},
         {UINT64_C(0xDA406D0ADA8BECB8), UINT64_C(0x14FD41CA82FE66BC),
          UINT64_C(0x80A410620A91DFFC), UINT64_C(0x33E38E10F4F0CDEB)}},
        {{UINT64_C(0x0234BF382529532C), UINT64_C(0x9F5D6342A76CAE3B),
          UINT64_C(0xC9944CB3B3C50442), UINT64_C(0x51752DF08ABFAF17)},
         {UINT64_C(0x2BFA58C4A37B13FB), UINT64_C(0x19F80FDEDDB14951),
          UINT64_C(0xDC7026AA7DCB927B), UINT64_C(0x57907272AAB9FCBA)}},
        {{UINT64_C(0xCE38712DF3C046C2), UINT64_C(0x21D1FDB047B29D0E),
          UINT64_C(0x7F746E0ECD96D414), UINT64_C(0x72F07B52636CFEA4)},
         {UINT64_C(0x0D8FE94FECE6382D), UINT64_C(0x9BFB4CBA24229CA4),
          UINT64_C(0xFAE55B77E54388B0), UINT64_C(0x074EBC32A188299F)}},
        {{UINT64_C(0x8AF2EBCDE21DCCA2), UINT64_C(0x9916A6B6377487F2),
          UINT64_C(0x607DC19AD8051D40), UINT64_C(0x7DFD53F4419DDE12)},
         {UINT64_C(0xD17D0D619AD07924), UINT64_C(0x14F7CE0F173E266B),
          UINT64_C(0x687FB8530281C9EB), UINT64_C(0x6B35CC1A3361B273)}},
        {{UINT64_C(0x7CD6369E16E02DE3), UINT64_C(0x118EE0B11F35DFBC),
          UINT64_C(0x7D8C8DBD98B3EE60), UINT64_C(0x039806FC8D29EA17)},
         {UINT64_C(0x3C473872EC2C2597), UINT64_C(0x81294AF45E4EF521),
          UINT64_C(0x5ED048DBC22A9D7C), UINT64_C(0x3879E95B0A08C4D4)}},
        {{UINT64_C(0x0206E47F96A864FE), UINT64_C(0xC94F137AA55D0631),
          UINT64_C(0x9C1B3D298E8408F8), UINT64_C(0x150A4046B9193A5E)},
         {UINT64_C(0x4E8F9345CB1ADF21), UINT64_C(0x6ED14D8A7BD5E1F9),
          UINT64_C(0x7082532960809F68), UINT64_C(0x0D2F1C3BFA85A06C)}},
    },
    {
        {{UINT64_C(0x3C5ABE75B5C810C3), UINT64_C(0xEA2C3EF9E28F1E26),
          UINT64_C(0xEEB1C5688BF68280), UINT64_C(0x5A165CEB7AE69110)},
         {UINT64_C(0xE36C646044550DF1), UINT64_C(0x6FB4B108DB909258),
          UINT64_C(0xBFA1427717D4D8C5), UINT64_C(0x744CAF23927976D8)}},
        {{UINT64_C(0xCBE70DF947EA55C7), UINT64_C(0x8F8119AE535457AE),
          UINT64_C(0x1E3C69EC7DAFD732), UINT64_C(0x1A2E162D39D409A2)},
         {UINT64_C(0xBD7576A15F81C227), UINT64_C(0xA040AF9EC86AC2C3),
          UINT64_C(0x5690C059C10FC749), UINT64_C(0x20B26E8849CFAEC6)}},
        {{UINT64_C(0x87AEBD1EE3EF781E), UINT64_C(0xBC794A621609A1F0),
          UINT64_C(0x96D8314226E7F61B), UINT64_C(0x5198577FFC51D17D)},
         {UINT64_C(0xBFB5FAE28E6D0124), UINT64_C(0x91A7172BFFD5BD72),
          UINT64_C(0x474B015402832847), UINT64_C(0x4BAF0B4C59827FEB)}},
        {{UINT64_C(0x5EADAA8EBA090294), UINT64_C(0x51401BC911A6E9FA),
          UINT64_C(0x78F117581D2594CD), UINT64_C(0x1811AD3082D203C2)},
         {UINT64_C(0x554CC39A53FD07CC), UINT64_C(0x055FC983C7A05601),
          UINT64_C(0xB3B34E95D5A80B4B), UINT64_C(0x72B4CF941819BC16)}},
        {{UINT64_C(0x0750E4F0514FAFD0), UINT64_C(0x297D27E6AD61C7B1),
          UINT64_C(0x701D743FA2D5D410), UINT64_C(0x535DD97BC83B55C9)},
         {UINT64_C(0x2EE96DDE1CB11BB0), UINT64_C(0xECEA32EA0914450F),
          UINT64_C(0x4FB812364CDBDA6A), UINT64_C(0x5B75B6B2233C8063)}},
        {{UINT64_C(0xF0A934A6D69D6C6A), UINT64_C(0x313E89773CC80AC9),
          UINT64_C(0x74692B171E428B71), UINT64_C(0x0474FEFCE1BE662D)},
         {UINT64_C(0xAA2FF6DBAFFBF61B), UINT64_C(0xCE1594E1776983AF),
          UINT64_C(0xF00C665B4D5A2596), UINT64_C(0x30DD24497D414B9A)}},
        {{UINT64_C(0xEF862DA2ACC44AB3), UINT64_C(0xBAD6857F6EE7A44A),
          UINT64_C(0x57674BF9D2F9027E), UINT64_C(0x4D771CC32ABF816E)},
         {UINT64_C(0x27BEFC18AC0F1348), UINT64_C(0xD83112EF5E4F1202),
          UINT64_C(0x3571BDE38E9AAAE5), UINT64_C(0x07284830C1379B13)}},
        {{UINT64_C(0xA4C2F36F72A8890C), UINT64_C(0x22DF0E815824B392),
          UINT64_C(0x50FAD77F5E720240), UINT64_C(0x1D152A6903278F96)},
         {UINT64_C(0x25A3E92EA7D80F17), UINT64_C(0xBBF85B327EF32666),
          UINT64_C(0xBBB5568727222E52), UINT64_C(0x756D22A67582FE42)}},
        {{UINT64_C(0x0AE7493A9BC9EAED), UINT64_C(0x9185F53F0DDBB275),
          UINT64_C(0x1585D068C3DFDBA7), UINT64_C(0x543208A1562E2455)},
         {UINT64_C(0x4C417D81CBCF9535), UINT64_C(0xD2DC38D3E35DD6ED),
          UINT64_C(0x9DF1E014346F03A4), UINT64_C(0x65736E3FF0E772A6)}},
        {{UINT64_C(0x58684A7BCFB7FF06), UINT64_C(0x72CC4AFEC58E6316),
          UINT64_C(0x2CA9BF30A8BB508A), UINT64_C(0x61576519E2044C8C)},
         {UINT64_C(0xE78FAD3D8FF6D2B5), UINT64_C(0x6E5B839FA934C7B2),
          UINT64_C(0xC1F3D367FAFA9F9B), UINT64_C(0x637CC398F8B2AFA4)}},
        {{UINT64_C(0xD6FC1806FE2B2639), UINT64_C(0x1DB199B49E98A7F2),
          UINT64_C(0x0508763DC794F900), UINT64_C(0x363F1F7D3232E5AC)},
         {UINT64_C(0xDCF2AD74BBDBB351), UINT64_C(0x91F2EAF15A506BC6),
          UINT64_C(0xBDE8459EB850088B), UINT64_C(0x52DF883B3E1135AF)}},
        {{UINT64_C(0x12FD053AF93779DC), UINT64_C(0x3E3D87289E319E46),
          UINT64_C(0x4D631005E5E360AE), UINT64_C(0x4A8B5683B1B29A30)},
         {UINT64_C(0x305E5E53A8CA45EF), UINT64_C(0x59EACB45C2914843),
          UINT64_C(0x83677B7A1988ECEA), UINT64_C(0x63D9CD36D6FD53E8)}},
        {{UINT64_C(0xDF2DACF2B77EB45F), UINT64_C(0x3C1303E355BBA70E),
          UINT64_C(0x5AB8EB424526A06C), UINT64_C(0x4D4FD2167FE06BBC)},
         {UINT64_C(0x98C5ADCFE1486ABC), UINT64_C(0x9A503BFF07F86F3A),
          UINT64_C(0x7CEBAECB56282E44), UINT64_C(0x4FB090371F230DA0)}},
        {{UINT64_C(0xD1A3738427210752), UINT64_C(0xD10794D602CF1C74),
          UINT64_C(0x48A2095A820CC08C), UINT64_C(0x6DCDDE2EE3284B9D)},
         {UINT64_C(0xB8C7203E5D40510D), UINT64_C(0x957E89825385E3A7),
          UINT64_C(0xD220BE2FE27D7C13), UINT64_C(0x2D104AC57B471B5B)}},
        {{UINT64_C(0x3B31D52BBA0AFA8D), UINT64_C(0xFA9639F5DCC85F88),
          UINT64_C(0x150146378861DDD7), UINT64_C(0x31C222DB7B5443B0)},
         {UINT64_C(0xE2618546C3CDD689), UINT64_C(0x7F3FB754D528A130),
          UINT64_C(0xA0915810AC5FAF99), UINT64_C(0x3863B890E9899CE5)}},
        {{UINT64_C(0xBDD42CA3579C4353), UINT64_C(0xAD30567D4D65CB5B),
          UINT64_C(0x0E343F216D91810B), UINT64_C(0x65E0092D42E19816)},
         {UINT64_C(0x76154DCCF84E8C8E), UINT64_C(0xBA147CA80BA4AE59),
          UINT64_C(0xCA8085E756A1A71E), UINT64_C(0x1D90B4B01A158536)}},
    },
    {
        {{UINT64_C(0x5C4B7438F8B6C26A), UINT64_C(0x0C17A41B645BBE80),
          UINT64_C(0xA386062D40CF3D85), UINT64_C(0x563E42D2E78F776D)},
         {UINT64_C(0x4BB8E3561F07459B), UINT64_C(0xF01A24B775D222CD),
          UINT64_C(0xBE3D032B24CF3F61), UINT64_C(0x759B01670AD5F3A3)}},
        {{UINT64_C(0x2F5AEBD17D201AAB), UINT64_C(0x7B14CBEEC0AE02AD),
          UINT64_C(0xB9B54430EDC6388B), UINT64_C(0x69E713FBB622E01F)},
         {UINT64_C(0x4630EE8EC5361565), UINT64_C(0x6705961E5C8FB479),
          UINT64_C(0x125CC97E07C2AA45), UINT64_C(0x4BC459F425AE3B12)}},
        {{UINT64_C(0xEF02549628CF94E4), UINT64_C(0x04CFAB259DB24DE6),
          UINT64_C(0x52B8C734C62254EF), UINT64_C(0x0F2FE922568AB164)},
         {UINT64_C(0x48551A05E3F39B40), UINT64_C(0x4A36865F31A7C7F6),
          UINT64_C(0x4486512C840441AE), UINT64_C(0x559C6CAF8C7C4B4D)}},
        {{UINT64_C(0xFCC0D1DA0F103030), UINT64_C(0x7A9F1D5539CD584E),
          UINT64_C(0x3EFB9B94681D0D37), UINT64_C(0x3AE97CCD4D842332)},
         {UINT64_C(0x85A8ECE13C03676B), UINT64_C(0x030F87753AD435A1),
          UINT64_C(0xF6019B4D7F2D73B5), UINT64_C(0x6B77E31A2F14F911)}},
        {{UINT64_C(0x65C8161B9186C671), UINT64_C(0x412C3CC7CDFF2F8C),
          UINT64_C(0xBFFC17192C2FEA33), UINT64_C(0x75DCF68BC3675845)},
         {UINT64_C(0x0476AFBF3B23D576), UINT64_C(0xB20CAEE219315F79),
          UINT64_C(0x1BC2A8590885471A), UINT64_C(0x410FF6CFC328279C)}},
        {{UINT64_C(0x327394D960569D94), UINT64_C(0xFF2AEB6A6EA39D95),
          UINT64_C(0x1BED71E8EA0CA3AE), UINT64_C(0x1000A81E21072A94)},
         {UINT64_C(0x368EA22973C02416), UINT64_C(0xDF5B2A420A4941BC),
          UINT64_C(0x4FFDC7B8D0D40B3A), UINT64_C(0x7B2C73F148ABAB4E)}},
        {{UINT64_C(0x90FE34E481EE1072), UINT64_C(0xAE7A2FF4310E13D8),
          UINT64_C(0x6213D3B1CAB3927C), UINT64_C(0x44936FBD7DC7E9EF)},
         {UINT64_C(0x3B898EF323A1BDBE), UINT64_C(0x3FA6C6A054CC7B1D),
          UINT64_C(0x41BCC3B5C6AC54F2), UINT64_C(0x1AB5D168DC10AE39)}},
        {{UINT64_C(0x1AED113CFEAF67A6), UINT64_C(0x04E3C7A1342AC459),
          UINT64_C(0x65A392787A99DFBC), UINT64_C(0x03ECBC6B642329FF)},
         {UINT64_C(0x799F4EC5A6A4421A), UINT64_C(0x44522C26BEE18B3C),
          UINT64_C(0x1C7BFF151975C4BB), UINT64_C(0x0FAA03BEE6A27857)}},
        {{UINT64_C(0x173AB9E00743FF7B), UINT64_C(0xB11187AE2CFC95AE),
          UINT64_C(0xCA81BB2E9C112049), UINT64_C(0x6B811DB6C03555D5)},
         {UINT64_C(0x76C1FC144FE32256), UINT64_C(0xDA8C5A96D0E47C4E),
          UINT64_C(0xB645D41329FDB01C), UINT64_C(0x78898447AC39502A)}},
        {{UINT64_C(0x4285FF329BF44B35), UINT64_C(0x207F9029E3358C7F),
          UINT64_C(0x0FE8F03263BAF4CE), UINT64_C(0x698A0398FF15E1F7)},
         {UINT64_C(0x548748437E572DF6), UINT64_C(0x746835199F43C07B),
          UINT64_C(0x47BAB49E0A433D6A), UINT64_C(0x09ED8740FAB5C858)}},
        {{UINT64_C(0x8AA5E5C91F6CA820), UINT64_C(0xAD290A94D3C25BEC),
          UINT64_C(0xDC4C67BF3BA255F0), UINT64_C(0x0D7EF7D91DEDD8A9)},
         {UINT64_C(0x0831A26F5EEFD1C3), UINT64_C(0x78CA66F504483E0C),
          UINT64_C(0x9D5A56122FAAC15A), UINT64_C(0x43B0C7E75D6FACDB)}},
        {{UINT64_C(0x34BA537C4503899D), UINT64_C(0x9DEBC8F52AF8ED3B),
          UINT64_C(0x396995E984F416E6), UINT64_C(0x77F10FEDC7BCE392)},
         {UINT64_C(0x065CCB721F8AF262), UINT64_C(0xE220ED60D2F00FC4),
          UINT64_C(0x41A5FB065EE25B46), UINT64_C(0x22505574DD9070B1)}},
        {{UINT64_C(0x571FF15144BFC5C0), UINT64_C(0xBE2558B83138363C),
          UINT64_C(0xB2211ABD605E356C), UINT64_C(0x0B6435DA176C5F53)},
         {UINT64_C(0xF18C917C8DCF484E), UINT64_C(0x45D4120CCD93D65F),
          UINT64_C(0xEBB0BF9C190AE7F8), UINT64_C(0x3D403DE28D8C8D5A)}},
        {{UINT64_C(0xCDE760B4BE656644), UINT64_C(0x99DC5E6D2D21DBC5),
          UINT64_C(0x644FCAF3B6232D08), UINT64_C(0x52955488859341E3)},
         {UINT64_C(0x3AB4580D25763919), UINT64_C(0x82AB0C534EF66999),
          UINT64_C(0xBD395C740180663E), UINT64_C(0x07974F1AB4756474)}},
        {{UINT64_C(0x8C15CFE731588EA6), UINT64_C(0x9629060EF36C882D),
          UINT64_C(0xDF8E8E9E862B080D), UINT64_C(0x0BD36B48D7A0C5BE)},
         {UINT64_C(0xEBD0C6C976DA047B), UINT64_C(0x4F0F08ABBB94FD5A),
          UINT64_C(0x33D41A4E74910D9F), UINT64_C(0x3D6F8D0BA9583754)}},
        {{UINT64_C(0xEC4C896E4E4FC72E), UINT64_C(0xB111210C002ECE31),
          UINT64_C(0x7204D9372AF11E21), UINT64_C(0x59B9C1EC5D0509E9)},
         {UINT64_C(0xBC97644CF9D5BBC0), UINT64_C(0x25B123AF31B4E869),
          UINT64_C(0x091D7AEC5A6CAAB0), UINT64_C(0x340B9E80ECC911C4)}},
    },
    {
        {{UINT64_C(0xE8036B20EC208406), UINT64_C(0xAF46A05A214CEB5A),
          UINT64_C(0x8672084A46CC8379), UINT64_C(0x7DE0A42F04BA7885)},
         {UINT64_C(0xB772BEDCC9D3F32A), UINT64_C(0x7DAE3680534B1520),
          UINT64_C(0x04CD6203EC7120CC), UINT64_C(0x032F88E3B4E99780)}},
        {{UINT64_C(0xB34BDA5CE4A0897E), UINT64_C(0xF7748B26379B2480),
          UINT64_C(0xF47F6646B2D97522), UINT64_C(0x66AD8DE1F9641DB9)},
         {UINT64_C(0x0F8EB919D1BF09C0), UINT64_C(0x7853BB4EB95DC052),
          UINT64_C(0xBE7EE13D62B1FD4A), UINT64_C(0x2FF7EDC5DC7CE53E)}},
        {{UINT64_C(0xE1009AA0EE81DF35), UINT64_C(0x14972F0261D0798B),
          UINT64_C(0x5A6831A0F1EA1A6A), UINT64_C(0x1DBABA3D0CAB301A)},
         {UINT64_C(0x421270E2157D5213), UINT64_C(0xA37BEA956407B790),
          UINT64_C(0xEAD56B1F103A6073), UINT64_C(0x27534624BAD909F1)}},
        {{UINT64_C(0xC92D2209C2621EF1), UINT64_C(0x450710C31D3AD3F3),
          UINT64_C(0x8CFB8D6C19E481AD), UINT64_C(0x35CACDAEE6DB01BD)},
         {UINT64_C(0x2DA4A1D87CDD5B01), UINT64_C(0x3E40C7510F55BA11),
          UINT64_C(0xA91D9EE7B15C162D), UINT64_C(0x13AD3BE511DBA157)}},
        {{UINT64_C(0xAE417DB0E72F64F5), UINT64_C(0x40822279F13352BA),
          UINT64_C(0xEC43AFD91F2B75B9), UINT64_C(0x14D4BB2BC9CF2972)},
         {UINT64_C(0x4A55718A0761B2F1), UINT64_C(0xDAFBF756D81A9307),
          UINT64_C(0x2DCDFC1C5D3E5A07), UINT64_C(0x696E42ED2EBBDF28)}},
        {{UINT64_C(0xF473939968705410), UINT64_C(0xFD581005AF5FFC88),
          UINT64_C(0x5490A69490A9F517), UINT64_C(0x4A5C8C2E8CF8327E)},
         {UINT64_C(0xC203CD35F7D83DA6), UINT64_C(0xECAA6B907282368D),
          UINT64_C(0x365BB5712AF7EC42), UINT64_C(0x112E7ACDD4099316)}},
        {{UINT64_C(0x9ABDE0603AE3C25C), UINT64_C(0xE4C03DADEB9925B2),
          UINT64_C(0x3C28DCB19E03388B), UINT64_C(0x2337A7CF52B63C06)},
         {UINT64_C(0x74DC0F134E1AF2EA), UINT64_C(0xA010E4E3CD0D59AA),
          UINT64_C(0x6E4DB7BA9FA14C96), UINT64_C(0x5B2C3862557F7CDE)}},
        {{UINT64_C(0xC826E567C8C79CA9), UINT64_C(0xE7D110CAE851BE0C),
          UINT64_C(0xFFD57057A3606499), UINT64_C(0x2E9DBC40C6482504)},
         {UINT64_C(0xC9F0C3C2F784D9AF), UINT64_C(0xDD982A05B755172E),
          UINT64_C(0x6BC6C19DA023997F), UINT64_C(0x4AC177BEE34493C6)}},
        {{UINT64_C(0x21C3E0874FA4F134), UINT64_C(0x66E10C3486F9722F),
          UINT64_C(0xD2927B017398579A), UINT64_C(0x7135B6380352C3D3)},
         {UINT64_C(0x2DA620073BB5EE11), UINT64_C(0x8B64F13C3A946236),
          UINT64_C(0x3A83C85430EAE6DF), UINT64_C(0x31114E2A0EB6F749)}},
        {{UINT64_C(0x2C7B52E735BFC72B), UINT64_C(0x6DD29EBD2B0D4C2C),
          UINT64_C(0xE90D39886C92E82D), UINT64_C(0x0A9249013864D94D)},
         {UINT64_C(0x630508249BEE9E78), UINT64_C(0x7929FD62003DD5CF),
          UINT64_C(0xD04F832CE57507D1), UINT64_C(0x61078BDC37D2C32E)}},
        {{UINT64_C(0xB118AFDD2E75264A), UINT64_C(0x3AB692EAEFD65114),
          UINT64_C(0x58D2CE248B0A2128), UINT64_C(0x4316E6C282ED6D5F)},
         {UINT64_C(0x97766FFF46345BE4), UINT64_C(0xD7FF30140A7451AA),
          UINT64_C(0x078A423FAACE2E37), UINT64_C(0x7F1F90C2A6A78919)}},
        {{UINT64_C(0x988FCCB08E9E3D4D), UINT64_C(0xBD003FC0B95C9731),
          UINT64_C(0x74E40076B0A84E58), UINT64_C(0x5FD1DBE61DF7FDD0)},
         {UINT64_C(0xD2C700C74E6CE2FA), UINT64_C(0xA6E042E2903C5AE7),
          UINT64_C(0x561CC25F3C73822E), UINT64_C(0x651A79392A6A0C0C)}},
        {{UINT64_C(0x103E9EC688CD7642), UINT64_C(0x65ED52183C3C86CE),
          UINT64_C(0x16BAB00282785C8B), UINT64_C(0x0B5C18BBF34723C5)},
         {UINT64_C(0x528B0546E724D144), UINT64_C(0x5E582A6B780EEF9E),
          UINT64_C(0xC08283B8122F17AD), UINT64_C(0x0300EDCD1C22F32D)}},
        {{UINT64_C(0x03AC716A38DCFD39), UINT64_C(0xCD88474C94F12C74),
          UINT64_C(0xB5E8641EE9042CA8), UINT64_C(0x1D5746CC40D10558)},
         {UINT64_C(0x7869F45ECB4BB408), UINT64_C(0x28FB091D569489C3),
          UINT64_C(0xEA371EEC50A46306), UINT64_C(0x2802579675AA224C)}},
        {{UINT64_C(0x4EAFA44EF7A5923A), UINT64_C(0xD2427C306B69FD8B),
          UINT64_C(0x4C4E884A393D83F9), UINT64_C(0x2D34890A6236AB65)},
         {UINT64_C(0x80038D4035CC97F5), UINT64_C(0x4FE43C8497897472),
          UINT64_C(0xE5F56243BEF161AF), UINT64_C(0x3E1BDD6F9372E631)}},
        {{UINT64_C(0x06A2B2875732669F), UINT64_C(0x92D00397CDF4D2C0),
          UINT64_C(0xCD9A25F0454A57F5), UINT64_C(0x23ADB7242F0CDB0B)},
         {UINT64_C(0x504DA603FF0F8CB0), UINT64_C(0x14EF9D30D3E24181),
          UINT64_C(0xB1B1328E47FC1E66), UINT64_C(0x319B2A846C60354D)}},
    },
    {
        {{UINT64_C(0xBBF5542EF1D56038), UINT64_C(0xEDE3E637DD71CFC3),
          UINT64_C(0xFAA81D212E9F6C8B), UINT64_C(0x4DD2D44B69FBD060)},
         {UINT64_C(0x71FB623314366A20), UINT64_C(0x155E486F9575451D),
          UINT64_C(0x001106F0EC7807D9), UINT64_C(0x1C80E5ABC617034C)}},
        {{UINT64_C(0xD3E478DB8619F5F4), UINT64_C(0x1DF5C367F68170C2),
          UINT64_C(0xEAB095243430DE1D), UINT64_C(0x48F09361C3CD4C24)},
         {UINT64_C(0xE49DEA4B60644FED), UINT64_C(0x47170F1C758C3679),
          UINT64_C(0x4CC1E6E8B0382A84), UINT64_C(0x2DBDB9DA10A4465E)}},
        {{UINT64_C(0x67BAA79AC8400A4C), UINT64_C(0xFA30675301D28ECE),
          UINT64_C(0x29DB5B1C6F33289C), UINT64_C(0x4475757326A8FCB4)},
         {UINT64_C(0x59616219E1B0A795), UINT64_C(0x3032D939C5B32FA0),
          UINT64_C(0x3010C9177C3CEA2C), UINT64_C(0x5CF83EF19892BDF4)}},
        {{UINT64_C(0x55DE11413C7E83E6), UINT64_C(0x9D03929C74EA0366),
          UINT64_C(0x5CA60C5083BAF3FE), UINT64_C(0x3D9BCA587F70E905)},
         {UINT64_C(0xDB79DF5AFCC5AB59), UINT64_C(0x03CFCF0653F68D30),
          UINT64_C(0xBE101A784FCFA5F1), UINT64_C(0x115D7078B49E493C)}},
        {{UINT64_C(0xF14023AA76A0CCBD), UINT64_C(0x4287F0BC086F2E50),
          UINT64_C(0xC5EAA559F79A37E7), UINT64_C(0x5D527C0904E4F2A2)},
         {UINT64_C(0xEC91461651DAA504), UINT64_C(0x250D90C6EEF1DC95),
          UINT64_C(0x1B0AA868A50330B2), UINT64_C(0x7B45A78354189BBE)}},
        {{UINT64_C(0x0D602E05F019D6FF), UINT64_C(0x563E3893DD1800BA),
          UINT64_C(0x7146727EF3C7F7E5), UINT64_C(0x59641D984B026635)},
         {UINT64_C(0x50BCF90FE91DDBB8), UINT64_C(0x5D43E78E7F8397A6),
          UINT64_C(0x8734A261EB15896E), UINT64_C(0x4AD1E8649FF6B361)}},
        {{UINT64_C(0x1A9B601F320322F1), UINT64_C(0x606D40B391F611C4),
          UINT64_C(0xB984958BA19C918F), UINT64_C(0x67BFB045776F834E)},
         {UINT64_C(0xC59E556968DD85F0), UINT64_C(0xB5642834D4067875),
          UINT64_C(0x247E7D65CB138DF3), UINT64_C(0x73640A035CB9281D)}},
        {{UINT64_C(0xC7C34CCC88639889), UINT64_C(0xD9E44E07A785C707),
          UINT64_C(0x1BE68EFE32F83073), UINT64_C(0x249902DAAE5317CE)},
         {UINT64_C(0xF1F0B86A76CA92FF), UINT64_C(0xA7F502CFC01CB06B),
          UINT64_C(0x0A8B4766595AA185), UINT64_C(0x614135AAB792DE49)}},
        {{UINT64_C(0x5392CAA7564F2BC8), UINT64_C(0x1CDDA684CC894FCD),
          UINT64_C(0x10AC2378A4EBF82F), UINT64_C(0x6211EA465051BFF9)},
         {UINT64_C(0xE53B017430E8E210), UINT64_C(0x2374FEC302C0E381),
          UINT64_C(0xF8B1506B4DA07224), UINT64_C(0x4E451E0154DA7A08)}},
        {{UINT64_C(0xA8404D9C241FC7FB), UINT64_C(0x1D6DBF6EC4406332),
          UINT64_C(0xFE14231930162118), UINT64_C(0x69DE75CCA7EF5EF5)},
         {UINT64_C(0x008D4D09856E26A5), UINT64_C(0x2BC64B65C588ECF6),
          UINT64_C(0x7A523D0BAA01EE19), UINT64_C(0x213EF390932F0B95)}},
        {{UINT64_C(0xA42FE5131CD716FA), UINT64_C(0xFB13B3C60E8001B6),
          UINT64_C(0xBFDC7998D8F530CB), UINT64_C(0x04F9C05BF1C61761)},
         {UINT64_C(0xFB57396FAFED9D64), UINT64_C(0x28CCEE3A421AC123),
          UINT64_C(0x32590C9BF6C21ACC), UINT64_C(0x503B97CBBCA75AE3)}},
        {{UINT64_C(0x745208BC366946ED), UINT64_C(0xA75D88E94C906596),
          UINT64_C(0x03A30C7EEE043530), UINT64_C(0x5C67C151D11BF4D5)},
         {UINT64_C(0x04F75DFAE7AE4BB3), UINT64_C(0xA08136067F8D7404),
          UINT64_C(0x8B9F921019D68F64), UINT64_C(0x5AB6797106F73B55)}},
        {{UINT64_C(0x08064C4AB0687095), UINT64_C(0x27E30DDDB0106DF4),
          UINT64_C(0x31D29C708482524A), UINT64_C(0x65DD5896D86FDACD)},
         {UINT64_C(0x081C013DC647197E), UINT64_C(0x51C10B9ED7A53A45),
          UINT64_C(0xACB9A4DE0DD7FC53), UINT64_C(0x639997A2F646220B)}},
        {{UINT64_C(0x97CCF8251FB93B43), UINT64_C(0xB7D7713DE488D786),
          UINT64_C(0x4F7595663E4DBB33), UINT64_C(0x13B5D8A1E0F09964)},
         {UINT64_C(0xFFDDAD74316CDD97), UINT64_C(0x67C5578252C92EE9),
          UINT64_C(0x03B50F940AC5D6FD), UINT64_C(0x56C5C0091484DF88)}},
        {{UINT64_C(0xDCE199E31778D303), UINT64_C(0x53A2A4C60F1DD4EC),
          UINT64_C(0x7CC5EE9E370A7B99), UINT64_C(0x4403202B2598744E)},
         {UINT64_C(0xCCFAA978228247B6), UINT64_C(0xF50D14BD4A1D0E27),
          UINT64_C(0x6669506180723ABC), UINT64_C(0x750CCB6A742C0015)}},
        {{UINT64_C(0x7B04693681A109F1), UINT64_C(0x6414D9A3D4C1AFE5),
          UINT64_C(0x35070548DD14AC1F), UINT64_C(0x27172F39DEC0D3F0)},
         {UINT64_C(0x4EE0A7BFF2E273F0), UINT64_C(0x028C7813EC82B8E6),
          UINT64_C(0x907BF09F2081EAE2), UINT64_C(0x72E4C3D3414D6421)}},
    },
    {
        {{UINT64_C(0x2064097EA073711C), UINT64_C(0x980D830A5A65EC25),
          UINT64_C(0x7906A87CF0877567), UINT64_C(0x3E5EAE10F1980A3A)},
         {UINT64_C(0x5F51023A9272CE32), UINT64_C(0x71D69E68A437C974),
          UINT64_C(0x32006EA1D0B579FF), UINT64_C(0x191935FFA436E129)}},
        {{UINT64_C(0xE5FE290991C1474C), UINT64_C(0x7350B9FA1F0B10F5),
          UINT64_C(0x2006F41D6B4AB128), UINT64_C(0x4EBDA6CFCD95FA42)},
         {UINT64_C(0x450289385DA9A7F4), UINT64_C(0xD8129DE457FB462B),
          UINT64_C(0x4F2BF2C9E592EF90), UINT64_C(0x14A1A16BD6751DCC)}},
        {{UINT64_C(0x7460BB84DE0CD47A), UINT64_C(0x261F24D6468CBA3D),
          UINT64_C(0x229D31811E3C2D8A), UINT64_C(0x4AE520C91D19E059)},
         {UINT64_C(0x5AC3AEE7DF8DC66E), UINT64_C(0xCB417060299697EE),
          UINT64_C(0x227C1497CE97514F), UINT64_C(0x2589B8032E991FDE)}},
        {{UINT64_C(0x7FE9D585A97A5D03), UINT64_C(0x7333A1EF10D58157),
          UINT64_C(0x54C1CCD2C94C3DF6), UINT64_C(0x25C1B25228073B4E)},
         {UINT64_C(0xEEB29AF90635AD79), UINT64_C(0x880019C19AA38848),
          UINT64_C(0x1A85994230A9A497), UINT64_C(0x57EDCC2D92B25ABA)}},
        {{UINT64_C(0xA98DAE7D65E19DE6), UINT64_C(0x8007DD1746AD8696),
          UINT64_C(0x61F2E2CFA7F3BBAD), UINT64_C(0x1EFCD38754193858)},
         {UINT64_C(0xFB54FD6011666ECF), UINT64_C(0xD97EA5DF36E7D371),
          UINT64_C(0x944CA1703B9371FF), UINT64_C(0x32A52CAC05DE7FB0)}},
        {{UINT64_C(0xB960FFF619ED8B5E), UINT64_C(0xFD6B4C3E660354BB),
          UINT64_C(0xF8ECAADA1C9E95F0), UINT64_C(0x687A6D29A8E08CC7)},
         {UINT64_C(0xD38B7670C6A83D12), UINT64_C(0x1646064C1265BF30),
          UINT64_C(0x7DE19FFE2464892D), UINT64_C(0x05B57E081BDBB729)}},
        {{UINT64_C(0xF3586B04FFB7A98A), UINT64_C(0xF1850CDCCB072826),
          UINT64_C(0xFA3E66A4CF53BFB0), UINT64_C(0x7C78E56706E07221)},
         {UINT64_C(0x21E6F2453B4E72AE), UINT64_C(0x10A0D78BC6A3DBE8),
          UINT64_C(0xB9FC6D77D618DDAB), UINT64_C(0x33092D1376951DE5)}},
        {{UINT64_C(0xCAA1BF9D5A0257CB), UINT64_C(0x1044E224866C505F),
          UINT64_C(0x9B51410781482E7D), UINT64_C(0x538CB86788940BFB)},
         {UINT64_C(0xACE68B78AC21DCC1), UINT64_C(0x57942F3C1609BF8C),
          UINT64_C(0x30A47F3266E48C7A), UINT64_C(0x170D301DB0DA341F)}},
        {{UINT64_C(0x19643EB218ED9863), UINT64_C(0xBBE55BCCD9104F33),
          UINT64_C(0x77008B6CA15B283C), UINT64_C(0x2A6E0B41873A6A02)},
         {UINT64_C(0x517410DF3CB9A225), UINT64_C(0x20D76E38F538730A),
          UINT64_C(0x76C9CAD69F8724F0), UINT64_C(0x588BA1066BE9A035)}},
        {{UINT64_C(0xA059DBECF842F66C), UINT64_C(0x59CA186DB3ED0481),
          UINT64_C(0xA5B2ABCBD454490F), UINT64_C(0x4A0F600402624902)},
         {UINT64_C(0x45AF7B514D2F605F), UINT64_C(0x57E8FE0FC368030F),
          UINT64_C(0x23B745570C0727AE), UINT64_C(0x7E91EC772B603EC4)}},
        {{UINT64_C(0xEDD284CFFD582BE8), UINT64_C(0x3077CB2381093CDA),
          UINT64_C(0xB1934840FDEA4FCE), UINT64_C(0x00F9B9D1D7F01C9A)},
         {UINT64_C(0xA55E5C5B0A1C707B), UINT64_C(0x05CD73CB2F8618A5),
          UINT64_C(0x7327CECB512EEA05), UINT64_C(0x5130A0998BF2A4D5)}},
        {{UINT64_C(0x34D18880FA7A1C7B), UINT64_C(0x5E0D6C53FD4E043F),
          UINT64_C(0xB4DD80101B4442AE), UINT64_C(0x59D9183E78ED7563)},
         {UINT64_C(0x624DDAFCF1FAE158), UINT64_C(0xC08C36535C4C1E92),
          UINT64_C(0x452FD71FCE3E42EF), UINT64_C(0x175B490820B902EC)}},
        {{UINT64_C(0x5F0FDF2418F4CE34), UINT64_C(0xA64A30119B7E61B8),
          UINT64_C(0x8109ACD5663362E2), UINT64_C(0x4D02F82497F3DF44)},
         {UINT64_C(0x2CE27CCE3A4F916A), UINT64_C(0x4A4E6CBB3B85B146),
          UINT64_C(0xFE7A6199DB8C9E5E), UINT64_C(0x53F5D620D94B8D23)}},
        {{UINT64_C(0x37FEBEC3E77610A9), UINT64_C(0xE82D8EAC92245CB0),
          UINT64_C(0x3FD2CEEAF79A31BC), UINT64_C(0x277ACF32B446850C)},
         {UINT64_C(0xD89FF4C7CE1A2786), UINT64_C(0x441781E5FFD3A23C),
          UINT64_C(0x7876EFC507E85496), UINT64_C(0x0F306C7BE6F41B30)}},
        {{UINT64_C(0x3BF2BFD15AB1B92B), UINT64_C(0xDCC3F5A6F373FCF2),
          UINT64_C(0x27CFC4A6DA53C229), UINT64_C(0x5885737C508E677F)},
         {UINT64_C(0x1275D0F17B829F24), UINT64_C(0xBD3C0B024991B75B),
          UINT64_C(0x3F82ACDFE581C569), UINT64_C(0x123294353F28904E)}},
        {{UINT64_C(0xCF7BDCCC99C3A09B), UINT64_C(0x191911075F7D601A),
          UINT64_C(0xA82F746039FBAA22), UINT64_C(0x3105A6FCD75B5786)},
         {UINT64_C(0x9673DAC4932F69A6), UINT64_C(0xF5664B25B57D6EE6),
          UINT64_C(0x1EDAC1120A3CDD3E), UINT64_C(0x3CF84F8C42778563)}},
    },
    {
        {{UINT64_C(0xE36FD1B765DE3040), UINT64_C(0x240EADEA8AA0D3FE),
          UINT64_C(0x769714317F77F804), UINT64_C(0x6FCC933E591E9694)},
         {UINT64_C(0x3218D92B18F48742), UINT64_C(0x215F13E95E1B4001),
          UINT64_C(0xCDF333CD7A8D69B9), UINT64_C(0x14F159B1D2FD134F)}},
        {{UINT64_C(0x2D1228D607A50C16), UINT64_C(0x0DFD80F629AE42FD),
          UINT64_C(0x6C18B122BB8F3512), UINT64_C(0x0FE61243303F3DCA)},
         {UINT64_C(0x43A29F4DDA50709B), UINT64_C(0x3FF58C084B92BF7B),
          UINT64_C(0x62DC6B41DFCEF797), UINT64_C(0x43F9525AC7B83F32)}},
        {{UINT64_C(0x17EBBC9A15F08F5B), UINT64_C(0xBCD3B6408BB3E932),
          UINT64_C(0xD46FBB9F510BBD36), UINT64_C(0x389ABBA8CF65442B)},
         {UINT64_C(0x3A3DAFE4B575545C), UINT64_C(0x6AB985ECE1D0994D),
          UINT64_C(0xCC2A697B69E1DB27), UINT64_C(0x0D483E18271581DC)}},
        {{UINT64_C(0x380D4095C046D968), UINT64_C(0x5303975555D3318B),
          UINT64_C(0x57FA762991CE6FFC), UINT64_C(0x0A0F2885A4ADB641)},
         {UINT64_C(0x8B99AF1B6E5C2909), UINT64_C(0xBDFE7FFDB8794175),
          UINT64_C(0x2CFB948A795ED786), UINT64_C(0x11FE74650FD0DF66)}},
        {{UINT64_C(0xFC2CC2BD22E152E2), UINT64_C(0xCF6AB96BE30BCEB3),
          UINT64_C(0xAE89C041BC89B689), UINT64_C(0x6813430CE7523AB6)},
         {UINT64_C(0x3F49E72840A4FA33), UINT64_C(0x025DE1B7857CB0C9),
          UINT64_C(0x6D71465A11EA5EA5), UINT64_C(0x6651F7B946C8D7CB)}},
        {{UINT64_C(0xD05F1DCE5268098F), UINT64_C(0x891DBB680DC75030),
          UINT64_C(0xD939E428EA916291), UINT64_C(0x5F8EECCCEA37D060)},
         {UINT64_C(0x885F1EA88DC5D544), UINT64_C(0xFD3B3D1757E7448F),
          UINT64_C(0x5FC791A879531DE0), UINT64_C(0x780C1AAF42E66DAA)}},
        {{UINT64_C(0x19697778397BB28F), UINT64_C(0x5EC31D44AAA9069D),
          UINT64_C(0xDC2DFEAA3CA24A6F), UINT64_C(0x3F66CFCA80BED770)},
         {UINT64_C(0x2B6B82151A102662), UINT64_C(0x44B4D7A4C5D34CEB),
          UINT64_C(0x17E0FDE688AFECF2), UINT64_C(0x0DEFA14BCFF8D214)}},
        {{UINT64_C(0x14035AA48365CA84), UINT64_C(0x309CEEF0197CE2B7),
          UINT64_C(0x21305426ED39AF37), UINT64_C(0x10D01D11D2EA583A)},
         {UINT64_C(0x3F2E97499FA5C766), UINT64_C(0x98357584D70549D4),
          UINT64_C(0x8FF80803D279946D), UINT64_C(0x53DBC43399DF1253)}},
        {{UINT64_C(0x1D0D9EFA5329F12F), UINT64_C(0xBC9F74CFBE1F007F),
          UINT64_C(0xD7F2AA9A18EE4DBC), UINT64_C(0x634BF4CF3A792753)},
         {UINT64_C(0xD5DC72AD2FA6255A), UINT64_C(0xEE69EA43F3BC00C5),
          UINT64_C(0xEA930F61D8147A1A), UINT64_C(0x25E1368DF4E9AD37)}},
        {{UINT64_C(0x9422AAF7B7C955EC), UINT64_C(0x7C7107616A74D634),
          UINT64_C(0x4ED89932305EE420), UINT64_C(0x07E422122E937289)},
         {UINT64_C(0x7EBB231328566C88), UINT64_C(0xC7ED9C7AC27ED656),
          UINT64_C(0xF77F3873BF14FB3B), UINT64_C(0x447AA1E5EB957520)}},
        {{UINT64_C(0x3E3CEC7EB5C5E016), UINT64_C(0xB33DDFF7BDE44D26),
          UINT64_C(0x2056E9C766E820DD), UINT64_C(0x21A9E5D4F8196FE2)},
         {UINT64_C(0x86CB0A1788040C97), UINT64_C(0x18AD8AE7FF515D49),
          UINT64_C(0xCB8A564A226A400A), UINT64_C(0x6DB489798B72A0D2)}},
        {{UINT64_C(0x4365074B6324DED2), UINT64_C(0x9EFB5CC6AEDAF0F8),
          UINT64_C(0xCF952C3CC0792B14), UINT64_C(0x70B82AB997ED965E)},
         {UINT64_C(0x931B98863ACEBCE7), UINT64_C(0xDA85049118C2425A),
          UINT64_C(0xD88E1E27E499F7FB), UINT64_C(0x61D3F246960981DE)}},
        {{UINT64_C(0x1D8EA2278393EB0A), UINT64_C(0x9DCC23D27863FB53),
          UINT64_C(0x961B2337D5EBD297), UINT64_C(0x0A96F8B25BFED1E9)},
         {UINT64_C(0x39EA1803FE7DD2B7), UINT64_C(0x7E4817BBE5F7772A),
          UINT64_C(0x3668C5FFD44A41EF), UINT64_C(0x78227653E11F8E11)}},
        {{UINT64_C(0x272D6933D024880B), UINT64_C(0x733C029FF236FD8A),
          UINT64_C(0xBA5C20BD604868F0), UINT64_C(0x33F211AE321175C2)},
         {UINT64_C(0xE40010FB9FD79FE3), UINT64_C(0x9C6EA1DCA685A59F),
          UINT64_C(0x79963FFC8EB9889D), UINT64_C(0x15434E7D5F67108D)}},
        {{UINT64_C(0x42C14BBFD68B670F), UINT64_C(0x2021AC9D23F1AA69),
          UINT64_C(0xBF4C6D74AEA04636), UINT64_C(0x1E4D2F8EBD1FB11D)},
         {UINT64_C(0x4B0CF0E337911AA6), UINT64_C(0x7542D9282C484507),
          UINT64_C(0x68836751889542DC), UINT64_C(0x05F229F7FE2282A0)}},
        {{UINT64_C(0xAF269E8B409B2067), UINT64_C(0x6C749952A860F075),
          UINT64_C(0xCB7492DA5DF7C7F6), UINT64_C(0x2B010A7FE8E591E1)},
         {UINT64_C(0xF744657704D9E871), UINT64_C(0xC2E0A2A35E68408E),
          UINT64_C(0xD512E9A6D0F0BAAD), UINT64_C(0x3E2F73E1C6BE34A3)}},
    },
    {
        {{UINT64_C(0x6C466C8E2EC65BB4), UINT64_C(0x912FFAE5B1FC8F92),
          UINT64_C(0x7587BE5DB50A522D), UINT64_C(0x15939FF7649847CF)},
         {UINT64_C(0x69E81D63F464794E), UINT64_C(0x7BB6EEE36D3F858E),
          UINT64_C(0x24FE5C0110813BBB), UINT64_C(0x0C491F976D80756C)}},
        {{UINT64_C(0xBAD1C256A5FF3510), UINT64_C(0xF06F38A299C1B7B2),
          UINT64_C(0xF7C0F164049312D6), UINT64_C(0x073C53745749B3E4)},
         {UINT64_C(0xD676148055211A81), UINT64_C(0xF34CB5DBDFA98F45),
          UINT64_C(0xAF59FA47B4AA4967), UINT64_C(0x116935B98214BE48)}},
        {{UINT64_C(0x1D86FA009FE10E46), UINT64_C(0x73B8099C0B5B8494),
          UINT64_C(0x9A6EA98DA1102BE7), UINT64_C(0x3DE1948B5514CA21)},
         {UINT64_C(0x5D18ED69D0AAAA53), UINT64_C(0x17BF7DFF3C952B98),
          UINT64_C(0xC60143FE7DDBD937), UINT64_C(0x214F2F556F2F10C4)}},
        {{UINT64_C(0xB2F2869502F047D0), UINT64_C(0x80952DFE923F52BF),
          UINT64_C(0x56F3306BA5017C3E), UINT64_C(0x5DD62F07052DADFB)},
         {UINT64_C(0xDD11592DD5274F90), UINT64_C(0x40632FF3E471965B),
          UINT64_C(0xAD1939A87E618430), UINT64_C(0x5DD9CAD233F19556)}},
        {{UINT64_C(0x7B0AA88CC1094747), UINT64_C(0xCFA6B95DF6753A0C),
          UINT64_C(0xE81AFADA2A252A4D), UINT64_C(0x364CAB7CD3770570)},
         {UINT64_C(0xE99D8252B4610A19), UINT64_C(0xB22B2FEC55ED9AD3),
          UINT64_C(0x328ACBDDBEBE7FED), UINT64_C(0x1D379D61FBEDFE84)}},
        {{UINT64_C(0xD9EFFFFA5EDF8C9C), UINT64_C(0x9BAA71810CE548EC),
          UINT64_C(0xEB458AEB5FA8FEEB), UINT64_C(0x18C5E6910904D841)},
         {UINT64_C(0xFCEFAE288F33D2E5), UINT64_C(0xB3CF853E6FAFDA18),
          UINT64_C(0x05DE94BA427D6218), UINT64_C(0x021D8AED3731D3E9)}},
        {{UINT64_C(0x06C8C318E92719DA), UINT64_C(0x1F7CDE121A65DFDB),
          UINT64_C(0x9B4D531E4B672A2D), UINT64_C(0x3E39CC63115FAF11)},
         {UINT64_C(0xC9C3F3390037AF60), UINT64_C(0xC1C6758702B43D27),
          UINT64_C(0x46B77CDDC42DF26B), UINT64_C(0x7235F2B0EBFA97A7)}},
        {{UINT64_C(0xAF7FFC9AE898094E), UINT64_C(0x8D18AB93146A27E3),
          UINT64_C(0x1376B7978AEC0416), UINT64_C(0x746A1B1C8D91C25E)},
         {UINT64_C(0x16DCCCC10EBDE2E3), UINT64_C(0xFE4ABD418CE7D61E),
          UINT64_C(0xB9830395E25F1551), UINT64_C(0x543493D7B885A943)}},
        {{UINT64_C(0x52C659E624EBCFC0), UINT64_C(0x72E3CA91D38367A4),
          UINT64_C(0xA3086AAC4D168F4F), UINT64_C(0x656ACFEE5D64207B)},
         {UINT64_C(0xBE697CBABA196A9E), UINT64_C(0x6A737ACC97DFFEC2),
          UINT64_C(0x393E266154F04DBD), UINT64_C(0x4FFF7C244B0E92BD)}},
        {{UINT64_C(0xC709CC59828EC659), UINT64_C(0xB275AC8CCBDEACB3),
          UINT64_C(0xA8D08921F7922523), UINT64_C(0x68B92F96400A6459)},
         {UINT64_C(0x45803EC2DFBECB97), UINT64_C(0x49464E057515D696),
          UINT64_C(0xF39CA9618F03E969), UINT64_C(0x605065A11CD7C79F)}},
        {{UINT64_C(0xB91C03DC97F1A97A), UINT64_C(0x2F6D50BB201FFB53),
          UINT64_C(0x39D67D4046241856), UINT64_C(0x0A2C025674D04805)},
         {UINT64_C(0xD289B94C28374A6D), UINT64_C(0x1176C73A10EDD6FC),
          UINT64_C(0x890E9C3956AE631E), UINT64_C(0x30451CF16027F549)}},
        {{UINT64_C(0x0CB33FDCDF8F4DDB), UINT64_C(0xD9C540DE87FF6E63),
          UINT64_C(0xD844573255A1D8E4), UINT64_C(0x1497403D8AC403A6)},
         {UINT64_C(0xA2591C406A4BAAC6), UINT64_C(0xF493CF1F48DD3E5D),
          UINT64_C(0x7B9AE39FB69AF047), UINT64_C(0x293123C03782B110)}},
        {{UINT64_C(0x14921836B7A36B62), UINT64_C(0x5AC824304CA3AA39),
          UINT64_C(0x01303AA652F601CA), UINT64_C(0x7EE1E6C72B43BB72)},
         {UINT64_C(0x7F82B37B64D44957), UINT64_C(0x840D0654DA4A6FEC),
          UINT64_C(0xFC806FA10290F75D), UINT64_C(0x3027FE4A4C62F0E8)}},
        {{UINT64_C(0x34E68AB5CD0D3AC0), UINT64_C(0xE6B0B8C1E9BC85BD),
          UINT64_C(0xE00F505299533831), UINT64_C(0x11327DA7CDC83750)},
         {UINT64_C(0x6D991DF04656A428), UINT64_C(0x6A7BE34986228F26),
          UINT64_C(0x6BF85E3D3019CDC5), UINT64_C(0x42200D2F576913A4)}},
        {{UINT64_C(0x420D9259707B940F), UINT64_C(0x1BB1FFE13C5E39BB),
          UINT64_C(0x83D6BA36E40D018E), UINT64_C(0x139BD842044EC576)},
         {UINT64_C(0x3C79F8D2C6DE63E8), UINT64_C(0x49150B1D96F1FB0B),
          UINT64_C(0x666160531358A13B), UINT64_C(0x187CA3CFD5DDFD9F)}},
        {{UINT64_C(0x0675370F8D5AEE84), UINT64_C(0x30AA7D65DC269114),
          UINT64_C(0x295F7FE85AFC6DC1), UINT64_C(0x4945202955674339)},
         {UINT64_C(0x7EB1926BA6F209EC), UINT64_C(0x5232B9D1DC72C3E3),
          UINT64_C(0xCD788D79AB52141B), UINT64_C(0x3EB561BEFDD9611F)}},
    },
    {
        {{UINT64_C(0x09DB342CE22241AD), UINT64_C(0x2EAB852F2A566653),
          UINT64_C(0x970843EDCA6E59F3), UINT64_C(0x6490013EA18C2D89)},
         {UINT64_C(0x52293350C7A691CC), UINT64_C(0x6544B49DB2079F14),
          UINT64_C(0xC49C559852DCF090), UINT64_C(0x4069B6FC8817A2C7)}},
        {{UINT64_C(0x0E4A4B0CC86B40F4), UINT64_C(0x2B5350E151F6F853),
          UINT64_C(0xDE26FDE21033BEC4), UINT64_C(0x4DE9D2E7C0E9B971)},
         {UINT64_C(0x716605FDD315AD57), UINT64_C(0x5627D732392B101A),
          UINT64_C(0x628EDFC681A9F40A), UINT64_C(0x4BD2A96C5AB9C99D)}},
        {{UINT64_C(0x2C8DF2A1BFBD288A), UINT64_C(0x260C4F1EF4CF7C09),
          UINT64_C(0x88A2618690E796CB), UINT64_C(0x105ACC3A323E0702)},
         {UINT64_C(0xA8ADA467667664CF), UINT64_C(0x41144C1B3B518622),
          UINT64_C(0x4A532B87D8B99FE1), UINT64_C(0x4A51C2892289C308)}},
        {{UINT64_C(0x201DDA611D6F6880), UINT64_C(0x47A964D462029898),
          UINT64_C(0xE44E2EEE426C8CA5), UINT64_C(0x02A5182109625DBA)},
         {UINT64_C(0x170C626EB45B3DFB), UINT64_C(0xFC7F1F715C8343A9),
          UINT64_C(0xE6CF246FE549F040), UINT64_C(0x4ACF60AE2F903ACE)}},
        {{UINT64_C(0x9171535281C807EC), UINT64_C(0x72AC60C347174A58),
          UINT64_C(0xAD62D06FA0F12F61), UINT64_C(0x325C2792AA899C0D)},
         {UINT64_C(0x53A1E3929D8BA267), UINT64_C(0x5DC088A5CDACCB05),
          UINT64_C(0x5BB9127F5025CB69), UINT64_C(0x25D2B42E69214616)}},
        {{UINT64_C(0x4DE5D58ADDB55121), UINT64_C(0x688AA2F584DE0677),
          UINT64_C(0xF7925A3963AA25E0), UINT64_C(0x4FB42FC785D4DEA5)},
         {UINT64_C(0x957B933B8F134390), UINT64_C(0xB360DD2C4B9BF8C2),
          UINT64_C(0x45E6767FFFFF96CD), UINT64_C(0x26D0A6A91E01D5C3)}},
        {{UINT64_C(0xC7FC57145A0A98EA), UINT64_C(0xDBB06F30E7535AF6),
          UINT64_C(0x555B22E3DF4ACD0D), UINT64_C(0x3A011AAF2EFD2FBE)},
         {UINT64_C(0x341C7733E9166B20), UINT64_C(0x84619E8EFB19590A),
          UINT64_C(0x8EF989FD10574C96), UINT64_C(0x61ACFAAE0F55F9A2)}},
        {{UINT64_C(0x8C8A33F26DEAB094), UINT64_C(0x4A8E5D9F96022EBC),
          UINT64_C(0xA10DF82C7DDA92E8), UINT64_C(0x33A19462D1CF3815)},
         {UINT64_C(0xE3FF8E43A489D67F), UINT64_C(0xD4B6136F225064AA),
          UINT64_C(0xE1721D2A92F5E662), UINT64_C(0x4C4F03D7A90A33C6)}},
        {{UINT64_C(0x70885B35A3463B4A), UINT64_C(0x974BC40EDF9D0194),
          UINT64_C(0x1AF71E18273957F4), UINT64_C(0x58EF684B9900CB0D)},
         {UINT64_C(0xB09970C820A49A4A), UINT64_C(0x3F28403F42067458),
          UINT64_C(0x153FF2C4BD7D1AD5), UINT64_C(0x7912CC2EE97A90F7)}},
        {{UINT64_C(0xF653DF598F034D9F), UINT64_C(0xCA1671771C409CCF),
          UINT64_C(0x21F47005175F3583), UINT64_C(0x13B8A94BFAAFB66F)},
         {UINT64_C(0x64534EE396052C8D), UINT64_C(0x09304DD18D674024),
          UINT64_C(0xEB468AC30D7A7E2A), UINT64_C(0x40347256CD62052C)}},
        {{UINT64_C(0x0F089165FFF11C0E), UINT64_C(0x383562C98D69A45C),
          UINT64_C(0x7AB3EF9D3125FE61), UINT64_C(0x32C042BCE0735F3A)},
         {UINT64_C(0x420077C84E268D91), UINT64_C(0x7FB4208244695B4F),
          UINT64_C(0xFA83216F448A133E), UINT64_C(0x1C66060793062EB3)}},
        {{UINT64_C(0xA0FCBACAEF9E04DE), UINT64_C(0xAEF9EECB5B86F69A),
          UINT64_C(0x73D2E95FC39D4C99), UINT64_C(0x098C74F7923A5BA8)},
         {UINT64_C(0x5B8C95C84F68DECF), UINT64_C(0xCFF2E10158976551),
          UINT64_C(0x5032AE48BE5CAF91), UINT64_C(0x5CCB9008E09BC8AE)}},
        {{UINT64_C(0x41A38F203714D3BF), UINT64_C(0x2413653317366520),
          UINT64_C(0xF12F314CFAE17B01), UINT64_C(0x4AA0C969FC9AD43B)},
         {UINT64_C(0xD8AB5F728BBAC026), UINT64_C(0x35128269526992DC),
          UINT64_C(0xA2EF6E44D19880AA), UINT64_C(0x28BB3623DBF47628)}},
        {{UINT64_C(0x294742BA3BA25C35), UINT64_C(0x39D3BC9B061555B7),
          UINT64_C(0x944E3ABCDE6EA1A0), UINT64_C(0x4FDC641557EBD394)},
         {UINT64_C(0xB615C1DAE981E649), UINT64_C(0xAF7EDB348BE3C95F),
          UINT64_C(0x38573AE871F7221F), UINT64_C(0x1B30FF04668CF414)}},
        {{UINT64_C(0x48EFF6A2A57A9A4E), UINT64_C(0x04BA2F7374A59C19),
          UINT64_C(0x5FDE389D6779C5DA), UINT64_C(0x258E2B246612F160)},
         {UINT64_C(0xCE8D7A0B6D116D41), UINT64_C(0xAF660436EE2706C8),
          UINT64_C(0xFFAD6FE9F81D6398), UINT64_C(0x4FE5EC5414BA128A)}},
        {{UINT64_C(0x7D5E8299BD4B886C), UINT64_C(0x5403A46EDB0DB148),
          UINT64_C(0x32F49FC076A808D7), UINT64_C(0x6D483FD7D3B9A641)},
         {UINT64_C(0x731DF1223952C70F), UINT64_C(0xB5CABAC1CB5E6081),
          UINT64_C(0x12FA297D7AFA8F59), UINT64_C(0x3272360A6AC91952)}},
    }};

/*-
 * Q := 2P, both projective, Q and P same pointers OK
 * Autogenerated: op3/dbl_proj.op3
 * https://eprint.iacr.org/2015/1060 Alg 6
 * ASSERT: a = -3
 */
static void point_double(pt_prj_t *Q, const pt_prj_t *P) {
    /* temporary variables */
    fe_t t0, t1, t2, t3, t4;
    /* constants */
    const limb_t *b = const_b;
    /* set pointers for legacy curve arith */
    const limb_t *X = P->X;
    const limb_t *Y = P->Y;
    const limb_t *Z = P->Z;
    limb_t *X3 = Q->X;
    limb_t *Y3 = Q->Y;
    limb_t *Z3 = Q->Z;

    /* the curve arith formula */
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_square(t0, X);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_square(t1, Y);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_square(t2, Z);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t3, X, Y);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t3, t3, t3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t4, Y, Z);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(Z3, X, Z);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(Z3, Z3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(Y3, b, t2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(Y3, Y3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(X3, Y3, Y3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(Y3, X3, Y3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(X3, t1, Y3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(Y3, t1, Y3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(Y3, X3, Y3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(X3, X3, t3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t3, t2, t2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t2, t2, t3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(Z3, b, Z3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(Z3, Z3, t2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(Z3, Z3, t0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t3, Z3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(Z3, Z3, t3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t3, t0, t0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t0, t3, t0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(t0, t0, t2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t0, t0, Z3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(Y3, Y3, t0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t0, t4, t4);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(Z3, t0, Z3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(X3, X3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(Z3, t0, t1);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(Z3, Z3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(Z3, Z3, Z3);
}

/*-
 * R := Q + P where R and Q are projective, P affine.
 * R and Q same pointers OK
 * R and P same pointers not OK
 * Autogenerated: op3/add_mixed.op3
 * https://eprint.iacr.org/2015/1060 Alg 5
 * ASSERT: a = -3
 */
static void point_add_mixed(pt_prj_t *R, const pt_prj_t *Q, const pt_aff_t *P) {
    /* temporary variables */
    fe_t t0, t1, t2, t3, t4;
    /* constants */
    const limb_t *b = const_b;
    /* set pointers for legacy curve arith */
    const limb_t *X1 = Q->X;
    const limb_t *Y1 = Q->Y;
    const limb_t *Z1 = Q->Z;
    const limb_t *X2 = P->X;
    const limb_t *Y2 = P->Y;
    fe_t X3;
    fe_t Y3;
    fe_t Z3;
    limb_t nz;

    /* check P for affine inf */
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_nonzero(&nz, P->Y);

    /* the curve arith formula */
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t0, X1, X2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t1, Y1, Y2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t3, X2, Y2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t4, X1, Y1);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t3, t3, t4);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t4, t0, t1);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(t3, t3, t4);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t4, Y2, Z1);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t4, t4, Y1);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(Y3, X2, Z1);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(Y3, Y3, X1);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(Z3, b, Z1);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(X3, Y3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(Z3, X3, X3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(X3, X3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(Z3, t1, X3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(X3, t1, X3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(Y3, b, Y3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t1, Z1, Z1);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t2, t1, Z1);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(Y3, Y3, t2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(Y3, Y3, t0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t1, Y3, Y3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(Y3, t1, Y3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t1, t0, t0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t0, t1, t0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(t0, t0, t2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t1, t4, Y3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t2, t0, Y3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(Y3, X3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(Y3, Y3, t2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(X3, t3, X3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(X3, X3, t1);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(Z3, t4, Z3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t1, t3, t0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(Z3, Z3, t1);

    /* if P is inf, throw all that away and take Q */
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_selectznz(R->X, nz, Q->X, X3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_selectznz(R->Y, nz, Q->Y, Y3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_selectznz(R->Z, nz, Q->Z, Z3);
}

/*-
 * R := Q + P all projective.
 * R and Q same pointers OK
 * R and P same pointers not OK
 * Autogenerated: op3/add_proj.op3
 * https://eprint.iacr.org/2015/1060 Alg 4
 * ASSERT: a = -3
 */
static void point_add_proj(pt_prj_t *R, const pt_prj_t *Q, const pt_prj_t *P) {
    /* temporary variables */
    fe_t t0, t1, t2, t3, t4, t5;
    /* constants */
    const limb_t *b = const_b;
    /* set pointers for legacy curve arith */
    const limb_t *X1 = Q->X;
    const limb_t *Y1 = Q->Y;
    const limb_t *Z1 = Q->Z;
    const limb_t *X2 = P->X;
    const limb_t *Y2 = P->Y;
    const limb_t *Z2 = P->Z;
    limb_t *X3 = R->X;
    limb_t *Y3 = R->Y;
    limb_t *Z3 = R->Z;

    /* the curve arith formula */
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t0, X1, X2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t1, Y1, Y2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t2, Z1, Z2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t3, X1, Y1);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t4, X2, Y2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t3, t3, t4);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t4, t0, t1);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(t3, t3, t4);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t4, Y1, Z1);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t5, Y2, Z2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t4, t4, t5);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t5, t1, t2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(t4, t4, t5);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(X3, X1, Z1);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(Y3, X2, Z2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(X3, X3, Y3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(Y3, t0, t2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(Y3, X3, Y3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(Z3, b, t2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(X3, Y3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(Z3, X3, X3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(X3, X3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(Z3, t1, X3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(X3, t1, X3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(Y3, b, Y3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t1, t2, t2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t2, t1, t2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(Y3, Y3, t2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(Y3, Y3, t0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t1, Y3, Y3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(Y3, t1, Y3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t1, t0, t0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t0, t1, t0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(t0, t0, t2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t1, t4, Y3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t2, t0, Y3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(Y3, X3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(Y3, Y3, t2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(X3, t3, X3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(X3, X3, t1);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(Z3, t4, Z3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t1, t3, t0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(Z3, Z3, t1);
}

/* constants */
#define RADIX 5
#define DRADIX (1 << RADIX)
#define DRADIX_WNAF ((DRADIX) << 1)

/*-
 * precomp for wnaf scalar multiplication:
 * precomp[0] = 1P
 * precomp[1] = 3P
 * precomp[2] = 5P
 * precomp[3] = 7P
 * precomp[4] = 9P
 * ...
 */
static void precomp_wnaf(pt_prj_t precomp[DRADIX / 2], const pt_aff_t *P) {
    int i;

    fe_copy(precomp[0].X, P->X);
    fe_copy(precomp[0].Y, P->Y);
    fe_copy(precomp[0].Z, const_one);
    point_double(&precomp[DRADIX / 2 - 1], &precomp[0]);

    for (i = 1; i < DRADIX / 2; i++)
        point_add_proj(&precomp[i], &precomp[DRADIX / 2 - 1], &precomp[i - 1]);
}

/* fetch a scalar bit */
static int scalar_get_bit(const unsigned char in[32], int idx) {
    int widx, rshift;

    widx = idx >> 3;
    rshift = idx & 0x7;

    if (idx < 0 || widx >= 32) return 0;

    return (in[widx] >> rshift) & 0x1;
}

/*-
 * Compute "regular" wnaf representation of a scalar.
 * See "Exponent Recoding and Regular Exponentiation Algorithms",
 * Tunstall et al., AfricaCrypt 2009, Alg 6.
 * It forces an odd scalar and outputs digits in
 * {\pm 1, \pm 3, \pm 5, \pm 7, \pm 9, ...}
 * i.e. signed odd digits with _no zeroes_ -- that makes it "regular".
 */
static void scalar_rwnaf(int8_t out[52], const unsigned char in[32]) {
    int i;
    int8_t window, d;

    window = (in[0] & (DRADIX_WNAF - 1)) | 1;
    for (i = 0; i < 51; i++) {
        d = (window & (DRADIX_WNAF - 1)) - DRADIX;
        out[i] = d;
        window = (window - d) >> RADIX;
        window += scalar_get_bit(in, (i + 1) * RADIX + 1) << 1;
        window += scalar_get_bit(in, (i + 1) * RADIX + 2) << 2;
        window += scalar_get_bit(in, (i + 1) * RADIX + 3) << 3;
        window += scalar_get_bit(in, (i + 1) * RADIX + 4) << 4;
        window += scalar_get_bit(in, (i + 1) * RADIX + 5) << 5;
    }
    out[i] = window;
}

/*-
 * Compute "textbook" wnaf representation of a scalar.
 * NB: not constant time
 */
static void scalar_wnaf(int8_t out[257], const unsigned char in[32]) {
    int i;
    int8_t window, d;

    window = in[0] & (DRADIX_WNAF - 1);
    for (i = 0; i < 257; i++) {
        d = 0;
        if ((window & 1) && ((d = window & (DRADIX_WNAF - 1)) & DRADIX))
            d -= DRADIX_WNAF;
        out[i] = d;
        window = (window - d) >> 1;
        window += scalar_get_bit(in, i + 1 + RADIX) << RADIX;
    }
}

/*-
 * Simultaneous scalar multiplication: interleaved "textbook" wnaf.
 * NB: not constant time
 */
static void var_smul_wnaf_two(pt_aff_t *out, const unsigned char a[32],
                              const unsigned char b[32], const pt_aff_t *P) {
    int i, d, is_neg, is_inf = 1, flipped = 0;
    int8_t anaf[257] = {0};
    int8_t bnaf[257] = {0};
    pt_prj_t Q = {0};
    pt_prj_t precomp[DRADIX / 2];

    precomp_wnaf(precomp, P);
    scalar_wnaf(anaf, a);
    scalar_wnaf(bnaf, b);

    for (i = 256; i >= 0; i--) {
        if (!is_inf) point_double(&Q, &Q);
        if ((d = bnaf[i])) {
            if ((is_neg = d < 0) != flipped) {
                fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_opp(Q.Y, Q.Y);
                flipped ^= 1;
            }
            d = (is_neg) ? (-d - 1) >> 1 : (d - 1) >> 1;
            if (is_inf) {
                /* initialize accumulator */
                fe_copy(Q.X, &precomp[d].X);
                fe_copy(Q.Y, &precomp[d].Y);
                fe_copy(Q.Z, &precomp[d].Z);
                is_inf = 0;
            } else
                point_add_proj(&Q, &Q, &precomp[d]);
        }
        if ((d = anaf[i])) {
            if ((is_neg = d < 0) != flipped) {
                fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_opp(Q.Y, Q.Y);
                flipped ^= 1;
            }
            d = (is_neg) ? (-d - 1) >> 1 : (d - 1) >> 1;
            if (is_inf) {
                /* initialize accumulator */
                fe_copy(Q.X, &lut_cmb[0][d].X);
                fe_copy(Q.Y, &lut_cmb[0][d].Y);
                fe_copy(Q.Z, const_one);
                is_inf = 0;
            } else
                point_add_mixed(&Q, &Q, &lut_cmb[0][d]);
        }
    }

    if (is_inf) {
        /* initialize accumulator to inf: all-zero scalars */
        fe_set_zero(Q.X);
        fe_copy(Q.Y, const_one);
        fe_set_zero(Q.Z);
    }

    if (flipped) {
        /* correct sign */
        fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_opp(Q.Y, Q.Y);
    }

    /* convert to affine -- NB depends on coordinate system */
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_inv(Q.Z, Q.Z);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(out->X, Q.X, Q.Z);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(out->Y, Q.Y, Q.Z);
}

/*-
 * Variable point scalar multiplication with "regular" wnaf.
 */
static void var_smul_rwnaf(pt_aff_t *out, const unsigned char scalar[32],
                           const pt_aff_t *P) {
    int i, j, d, diff, is_neg;
    int8_t rnaf[52] = {0};
    pt_prj_t Q = {0}, lut = {0};
    pt_prj_t precomp[DRADIX / 2];

    precomp_wnaf(precomp, P);
    scalar_rwnaf(rnaf, scalar);

#if defined(_MSC_VER)
    /* result still unsigned: yes we know */
#pragma warning(push)
#pragma warning(disable : 4146)
#endif

    /* initialize accumulator to high digit */
    d = (rnaf[51] - 1) >> 1;
    for (j = 0; j < DRADIX / 2; j++) {
        diff = (1 - (-(d ^ j) >> (8 * sizeof(int) - 1))) & 1;
        fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_selectznz(Q.X, diff, Q.X,
                                                              precomp[j].X);
        fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_selectznz(Q.Y, diff, Q.Y,
                                                              precomp[j].Y);
        fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_selectznz(Q.Z, diff, Q.Z,
                                                              precomp[j].Z);
    }

    for (i = 50; i >= 0; i--) {
        for (j = 0; j < RADIX; j++) point_double(&Q, &Q);
        d = rnaf[i];
        /* is_neg = (d < 0) ? 1 : 0 */
        is_neg = (d >> (8 * sizeof(int) - 1)) & 1;
        /* d = abs(d) */
        d = (d ^ -is_neg) + is_neg;
        d = (d - 1) >> 1;
        for (j = 0; j < DRADIX / 2; j++) {
            diff = (1 - (-(d ^ j) >> (8 * sizeof(int) - 1))) & 1;
            fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_selectznz(
                lut.X, diff, lut.X, precomp[j].X);
            fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_selectznz(
                lut.Y, diff, lut.Y, precomp[j].Y);
            fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_selectznz(
                lut.Z, diff, lut.Z, precomp[j].Z);
        }
        /* negate lut point if digit is negative */
        fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_opp(out->Y, lut.Y);
        fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_selectznz(lut.Y, is_neg,
                                                              lut.Y, out->Y);
        point_add_proj(&Q, &Q, &lut);
    }

#if defined(_MSC_VER)
#pragma warning(pop)
#endif

    /* conditionally subtract P if the scalar was even */
    fe_copy(lut.X, precomp[0].X);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_opp(lut.Y, precomp[0].Y);
    fe_copy(lut.Z, precomp[0].Z);
    point_add_proj(&lut, &lut, &Q);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_selectznz(Q.X, scalar[0] & 1,
                                                          lut.X, Q.X);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_selectznz(Q.Y, scalar[0] & 1,
                                                          lut.Y, Q.Y);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_selectznz(Q.Z, scalar[0] & 1,
                                                          lut.Z, Q.Z);

    /* convert to affine -- NB depends on coordinate system */
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_inv(Q.Z, Q.Z);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(out->X, Q.X, Q.Z);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(out->Y, Q.Y, Q.Z);
}

/*-
 * Fixed scalar multiplication: comb with interleaving.
 */
static void fixed_smul_cmb(pt_aff_t *out, const unsigned char scalar[32]) {
    int i, j, k, d, diff, is_neg = 0;
    int8_t rnaf[52] = {0};
    pt_prj_t Q = {0}, R = {0};
    pt_aff_t lut = {0};

    scalar_rwnaf(rnaf, scalar);

    /* initalize accumulator to inf */
    fe_set_zero(Q.X);
    fe_copy(Q.Y, const_one);
    fe_set_zero(Q.Z);

#if defined(_MSC_VER)
    /* result still unsigned: yes we know */
#pragma warning(push)
#pragma warning(disable : 4146)
#endif

    for (i = 1; i >= 0; i--) {
        for (j = 0; i != 1 && j < RADIX; j++) point_double(&Q, &Q);
        for (j = 0; j < 27; j++) {
            if (j * 2 + i > 51) continue;
            d = rnaf[j * 2 + i];
            /* is_neg = (d < 0) ? 1 : 0 */
            is_neg = (d >> (8 * sizeof(int) - 1)) & 1;
            /* d = abs(d) */
            d = (d ^ -is_neg) + is_neg;
            d = (d - 1) >> 1;
            for (k = 0; k < DRADIX / 2; k++) {
                diff = (1 - (-(d ^ k) >> (8 * sizeof(int) - 1))) & 1;
                fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_selectznz(
                    lut.X, diff, lut.X, lut_cmb[j][k].X);
                fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_selectznz(
                    lut.Y, diff, lut.Y, lut_cmb[j][k].Y);
            }
            /* negate lut point if digit is negative */
            fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_opp(out->Y, lut.Y);
            fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_selectznz(
                lut.Y, is_neg, lut.Y, out->Y);
            point_add_mixed(&Q, &Q, &lut);
        }
    }

#if defined(_MSC_VER)
#pragma warning(pop)
#endif

    /* conditionally subtract P if the scalar was even */
    fe_copy(lut.X, lut_cmb[0][0].X);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_opp(lut.Y, lut_cmb[0][0].Y);
    point_add_mixed(&R, &Q, &lut);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_selectznz(Q.X, scalar[0] & 1,
                                                          R.X, Q.X);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_selectznz(Q.Y, scalar[0] & 1,
                                                          R.Y, Q.Y);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_selectznz(Q.Z, scalar[0] & 1,
                                                          R.Z, Q.Z);

    /* convert to affine -- NB depends on coordinate system */
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_inv(Q.Z, Q.Z);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(out->X, Q.X, Q.Z);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(out->Y, Q.Y, Q.Z);
}

/*-
 * Wrapper: simultaneous scalar mutiplication.
 * outx, outy := a * G + b * P
 * where P = (inx, iny).
 * Everything is LE byte ordering.
 */
static void point_mul_two(unsigned char outx[32], unsigned char outy[32],
                          const unsigned char a[32], const unsigned char b[32],
                          const unsigned char inx[32],
                          const unsigned char iny[32]) {
    pt_aff_t P;

    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_from_bytes(P.X, inx);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_from_bytes(P.Y, iny);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_to_montgomery(P.X, P.X);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_to_montgomery(P.Y, P.Y);
    /* simultaneous scalar multiplication */
    var_smul_wnaf_two(&P, a, b, &P);

    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_from_montgomery(P.X, P.X);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_from_montgomery(P.Y, P.Y);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_to_bytes(outx, P.X);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_to_bytes(outy, P.Y);
}

/*-
 * Wrapper: fixed scalar mutiplication.
 * outx, outy := scalar * G
 * Everything is LE byte ordering.
 */
static void point_mul_g(unsigned char outx[32], unsigned char outy[32],
                        const unsigned char scalar[32]) {
    pt_aff_t P;

    /* fixed scmul function */
    fixed_smul_cmb(&P, scalar);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_from_montgomery(P.X, P.X);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_from_montgomery(P.Y, P.Y);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_to_bytes(outx, P.X);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_to_bytes(outy, P.Y);
}

/*-
 * Wrapper: variable point scalar mutiplication.
 * outx, outy := scalar * P
 * where P = (inx, iny).
 * Everything is LE byte ordering.
 */
static void point_mul(unsigned char outx[32], unsigned char outy[32],
                      const unsigned char scalar[32],
                      const unsigned char inx[32],
                      const unsigned char iny[32]) {
    pt_aff_t P;

    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_from_bytes(P.X, inx);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_from_bytes(P.Y, iny);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_to_montgomery(P.X, P.X);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_to_montgomery(P.Y, P.Y);
    /* var scmul function */
    var_smul_rwnaf(&P, scalar, &P);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_from_montgomery(P.X, P.X);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_from_montgomery(P.Y, P.Y);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_to_bytes(outx, P.X);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_to_bytes(outy, P.Y);
}


#include <openssl/ec.h>

/* the zero field element */
static const unsigned char const_zb[32] = {0};

/*-
 * An OpenSSL wrapper for simultaneous scalar multiplication.
 * r := n * G + m * q
 */
    int
    point_mul_two_id_GostR3410_2001_CryptoPro_B_ParamSet(
        const EC_GROUP *group, EC_POINT *r, const BIGNUM *n, const EC_POINT *q,
        const BIGNUM *m, BN_CTX *ctx) {
    int ret = 0;
    unsigned char b_x[32];
    unsigned char b_y[32];
    unsigned char b_n[32];
    unsigned char b_m[32];
    BIGNUM *x = NULL, *y = NULL;

    BN_CTX_start(ctx);
    x = BN_CTX_get(ctx);
    if ((y = BN_CTX_get(ctx)) == NULL
        /* pull out coords as bytes */
        || !EC_POINT_get_affine_coordinates(group, q, x, y, ctx) ||
        BN_bn2lebinpad(x, b_x, 32) != 32 || BN_bn2lebinpad(y, b_y, 32) != 32 ||
        BN_bn2lebinpad(n, b_n, 32) != 32 || BN_bn2lebinpad(m, b_m, 32) != 32)
        goto err;
    /* do the simultaneous scalar multiplication */
    point_mul_two(b_x, b_y, b_n, b_m, b_x, b_y);
    /* check for infinity */
    if (CRYPTO_memcmp(const_zb, b_x, 32) == 0 &&
        CRYPTO_memcmp(const_zb, b_y, 32) == 0) {
        if (!EC_POINT_set_to_infinity(group, r)) goto err;
    } else {
        /* otherwise, pack the bytes into the result */
        if (BN_lebin2bn(b_x, 32, x) == NULL ||
            BN_lebin2bn(b_y, 32, y) == NULL ||
            !EC_POINT_set_affine_coordinates(group, r, x, y, ctx))
            goto err;
    }
    ret = 1;
err:
    BN_CTX_end(ctx);
    return ret;
}

/*-
 * An OpenSSL wrapper for variable point scalar multiplication.
 * r := m * q
 */
    int
    point_mul_id_GostR3410_2001_CryptoPro_B_ParamSet(const EC_GROUP *group,
                                                     EC_POINT *r,
                                                     const EC_POINT *q,
                                                     const BIGNUM *m,
                                                     BN_CTX *ctx) {
    int ret = 0;
    unsigned char b_x[32];
    unsigned char b_y[32];
    unsigned char b_m[32];
    BIGNUM *x = NULL, *y = NULL;

    BN_CTX_start(ctx);
    x = BN_CTX_get(ctx);
    if ((y = BN_CTX_get(ctx)) == NULL
        /* pull out coords as bytes */
        || !EC_POINT_get_affine_coordinates(group, q, x, y, ctx) ||
        BN_bn2lebinpad(x, b_x, 32) != 32 || BN_bn2lebinpad(y, b_y, 32) != 32 ||
        BN_bn2lebinpad(m, b_m, 32) != 32)
        goto err;
    /* do the variable scalar multiplication */
    point_mul(b_x, b_y, b_m, b_x, b_y);
    /* check for infinity */
    if (CRYPTO_memcmp(const_zb, b_x, 32) == 0 &&
        CRYPTO_memcmp(const_zb, b_y, 32) == 0) {
        if (!EC_POINT_set_to_infinity(group, r)) goto err;
    } else {
        /* otherwise, pack the bytes into the result */
        if (BN_lebin2bn(b_x, 32, x) == NULL ||
            BN_lebin2bn(b_y, 32, y) == NULL ||
            !EC_POINT_set_affine_coordinates(group, r, x, y, ctx))
            goto err;
    }
    ret = 1;
err:
    BN_CTX_end(ctx);
    return ret;
}

/*-
 * An OpenSSL wrapper for fixed scalar multiplication.
 * r := n * G
 */
    int
    point_mul_g_id_GostR3410_2001_CryptoPro_B_ParamSet(const EC_GROUP *group,
                                                       EC_POINT *r,
                                                       const BIGNUM *n,
                                                       BN_CTX *ctx) {
    int ret = 0;
    unsigned char b_x[32];
    unsigned char b_y[32];
    unsigned char b_n[32];
    BIGNUM *x = NULL, *y = NULL;

    BN_CTX_start(ctx);
    x = BN_CTX_get(ctx);
    if ((y = BN_CTX_get(ctx)) == NULL || BN_bn2lebinpad(n, b_n, 32) != 32)
        goto err;
    /* do the fixed scalar multiplication */
    point_mul_g(b_x, b_y, b_n);
    /* check for infinity */
    if (CRYPTO_memcmp(const_zb, b_x, 32) == 0 &&
        CRYPTO_memcmp(const_zb, b_y, 32) == 0) {
        if (!EC_POINT_set_to_infinity(group, r)) goto err;
    } else {
        /* otherwise, pack the bytes into the result */
        if (BN_lebin2bn(b_x, 32, x) == NULL ||
            BN_lebin2bn(b_y, 32, y) == NULL ||
            !EC_POINT_set_affine_coordinates(group, r, x, y, ctx))
            goto err;
    }
    ret = 1;
err:
    BN_CTX_end(ctx);
    return ret;
}



#else /* __SIZEOF_INT128__ */

#include <stdint.h>
#include <string.h>
#define LIMB_BITS 32
#define LIMB_CNT 8
/* Field elements */
typedef uint32_t fe_t[LIMB_CNT];
typedef uint32_t limb_t;

#ifdef OPENSSL_NO_ASM
#define FIAT_ID_GOSTR3410_2001_CRYPTOPRO_B_PARAMSET_NO_ASM
#endif

#define fe_copy(d, s) memcpy(d, s, sizeof(fe_t))
#define fe_set_zero(d) memset(d, 0, sizeof(fe_t))

/* Projective points */
typedef struct {
    fe_t X;
    fe_t Y;
    fe_t Z;
} pt_prj_t;

/* Affine points */
typedef struct {
    fe_t X;
    fe_t Y;
} pt_aff_t;

/* BEGIN verbatim fiat code https://github.com/mit-plv/fiat-crypto */
/*-
 * MIT License
 *
 * Copyright (c) 2020 the fiat-crypto authors (see the AUTHORS file)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

/* Autogenerated: word_by_word_montgomery --static --use-value-barrier id_GostR3410_2001_CryptoPro_B_ParamSet 32 '2^255 + 3225' */
/* curve description: id_GostR3410_2001_CryptoPro_B_ParamSet */
/* machine_wordsize = 32 (from "32") */
/* requested operations: (all) */
/* m = 0x8000000000000000000000000000000000000000000000000000000000000c99 (from "2^255 + 3225") */
/*                                                                    */
/* NOTE: In addition to the bounds specified above each function, all */
/*   functions synthesized for this Montgomery arithmetic require the */
/*   input to be strictly less than the prime modulus (m), and also   */
/*   require the input to be in the unique saturated representation.  */
/*   All functions also ensure that these two properties are true of  */
/*   return values.                                                   */
/*  */
/* Computed values: */
/* eval z = z[0] + (z[1] << 32) + (z[2] << 64) + (z[3] << 96) + (z[4] << 128) + (z[5] << 160) + (z[6] << 192) + (z[7] << 224) */
/* bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) + (z[28] << 224) + (z[29] << 232) + (z[30] << 240) + (z[31] << 248) */

#include <stdint.h>
typedef unsigned char fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1;
typedef signed char fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_int1;

#if (-1 & 3) != 3
#error "This code only works on a two's complement system"
#endif

#if !defined(FIAT_ID_GOSTR3410_2001_CRYPTOPRO_B_PARAMSET_NO_ASM) && \
    (defined(__GNUC__) || defined(__clang__))
static __inline__ uint32_t
fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_value_barrier_u32(uint32_t a) {
    __asm__("" : "+r"(a) : /* no inputs */);
    return a;
}
#else
#define fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_value_barrier_u32(x) (x)
#endif

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32 is an addition with carry.
 * Postconditions:
 *   out1 = (arg1 + arg2 + arg3) mod 2^32
 *   out2 = ⌊(arg1 + arg2 + arg3) / 2^32⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffff]
 *   arg3: [0x0 ~> 0xffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(
    uint32_t *out1, fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 *out2,
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 arg1, uint32_t arg2,
    uint32_t arg3) {
    uint64_t x1;
    uint32_t x2;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x3;
    x1 = ((arg1 + (uint64_t)arg2) + arg3);
    x2 = (uint32_t)(x1 & UINT32_C(0xffffffff));
    x3 = (fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1)(x1 >> 32);
    *out1 = x2;
    *out2 = x3;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32 is a subtraction with borrow.
 * Postconditions:
 *   out1 = (-arg1 + arg2 + -arg3) mod 2^32
 *   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^32⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffff]
 *   arg3: [0x0 ~> 0xffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(
    uint32_t *out1, fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 *out2,
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 arg1, uint32_t arg2,
    uint32_t arg3) {
    int64_t x1;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_int1 x2;
    uint32_t x3;
    x1 = ((arg2 - (int64_t)arg1) - arg3);
    x2 = (fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_int1)(x1 >> 32);
    x3 = (uint32_t)(x1 & UINT32_C(0xffffffff));
    *out1 = x3;
    *out2 = (fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1)(0x0 - x2);
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32 is a multiplication, returning the full double-width result.
 * Postconditions:
 *   out1 = (arg1 * arg2) mod 2^32
 *   out2 = ⌊arg1 * arg2 / 2^32⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0xffffffff]
 *   arg2: [0x0 ~> 0xffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 *   out2: [0x0 ~> 0xffffffff]
 */
static void fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(
    uint32_t *out1, uint32_t *out2, uint32_t arg1, uint32_t arg2) {
    uint64_t x1;
    uint32_t x2;
    uint32_t x3;
    x1 = ((uint64_t)arg1 * arg2);
    x2 = (uint32_t)(x1 & UINT32_C(0xffffffff));
    x3 = (uint32_t)(x1 >> 32);
    *out1 = x2;
    *out2 = x3;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32 is a single-word conditional move.
 * Postconditions:
 *   out1 = (if arg1 = 0 then arg2 else arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffff]
 *   arg3: [0x0 ~> 0xffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 */
static void fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(
    uint32_t *out1, fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 arg1,
    uint32_t arg2, uint32_t arg3) {
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x1;
    uint32_t x2;
    uint32_t x3;
    x1 = (!(!arg1));
    x2 = ((fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_int1)(0x0 - x1) &
          UINT32_C(0xffffffff));
    x3 =
        ((fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_value_barrier_u32(x2) &
          arg3) |
         (fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_value_barrier_u32((~x2)) &
          arg2));
    *out1 = x3;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul multiplies two field elements in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(
    uint32_t out1[8], const uint32_t arg1[8], const uint32_t arg2[8]) {
    uint32_t x1;
    uint32_t x2;
    uint32_t x3;
    uint32_t x4;
    uint32_t x5;
    uint32_t x6;
    uint32_t x7;
    uint32_t x8;
    uint32_t x9;
    uint32_t x10;
    uint32_t x11;
    uint32_t x12;
    uint32_t x13;
    uint32_t x14;
    uint32_t x15;
    uint32_t x16;
    uint32_t x17;
    uint32_t x18;
    uint32_t x19;
    uint32_t x20;
    uint32_t x21;
    uint32_t x22;
    uint32_t x23;
    uint32_t x24;
    uint32_t x25;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x26;
    uint32_t x27;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x28;
    uint32_t x29;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x30;
    uint32_t x31;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x32;
    uint32_t x33;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x34;
    uint32_t x35;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x36;
    uint32_t x37;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x38;
    uint32_t x39;
    uint32_t x40;
    uint32_t x41;
    uint32_t x42;
    uint32_t x43;
    uint32_t x44;
    uint32_t x45;
    uint32_t x46;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x47;
    uint32_t x48;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x49;
    uint32_t x50;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x51;
    uint32_t x52;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x53;
    uint32_t x54;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x55;
    uint32_t x56;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x57;
    uint32_t x58;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x59;
    uint32_t x60;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x61;
    uint32_t x62;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x63;
    uint32_t x64;
    uint32_t x65;
    uint32_t x66;
    uint32_t x67;
    uint32_t x68;
    uint32_t x69;
    uint32_t x70;
    uint32_t x71;
    uint32_t x72;
    uint32_t x73;
    uint32_t x74;
    uint32_t x75;
    uint32_t x76;
    uint32_t x77;
    uint32_t x78;
    uint32_t x79;
    uint32_t x80;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x81;
    uint32_t x82;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x83;
    uint32_t x84;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x85;
    uint32_t x86;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x87;
    uint32_t x88;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x89;
    uint32_t x90;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x91;
    uint32_t x92;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x93;
    uint32_t x94;
    uint32_t x95;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x96;
    uint32_t x97;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x98;
    uint32_t x99;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x100;
    uint32_t x101;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x102;
    uint32_t x103;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x104;
    uint32_t x105;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x106;
    uint32_t x107;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x108;
    uint32_t x109;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x110;
    uint32_t x111;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x112;
    uint32_t x113;
    uint32_t x114;
    uint32_t x115;
    uint32_t x116;
    uint32_t x117;
    uint32_t x118;
    uint32_t x119;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x120;
    uint32_t x121;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x122;
    uint32_t x123;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x124;
    uint32_t x125;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x126;
    uint32_t x127;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x128;
    uint32_t x129;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x130;
    uint32_t x131;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x132;
    uint32_t x133;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x134;
    uint32_t x135;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x136;
    uint32_t x137;
    uint32_t x138;
    uint32_t x139;
    uint32_t x140;
    uint32_t x141;
    uint32_t x142;
    uint32_t x143;
    uint32_t x144;
    uint32_t x145;
    uint32_t x146;
    uint32_t x147;
    uint32_t x148;
    uint32_t x149;
    uint32_t x150;
    uint32_t x151;
    uint32_t x152;
    uint32_t x153;
    uint32_t x154;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x155;
    uint32_t x156;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x157;
    uint32_t x158;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x159;
    uint32_t x160;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x161;
    uint32_t x162;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x163;
    uint32_t x164;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x165;
    uint32_t x166;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x167;
    uint32_t x168;
    uint32_t x169;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x170;
    uint32_t x171;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x172;
    uint32_t x173;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x174;
    uint32_t x175;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x176;
    uint32_t x177;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x178;
    uint32_t x179;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x180;
    uint32_t x181;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x182;
    uint32_t x183;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x184;
    uint32_t x185;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x186;
    uint32_t x187;
    uint32_t x188;
    uint32_t x189;
    uint32_t x190;
    uint32_t x191;
    uint32_t x192;
    uint32_t x193;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x194;
    uint32_t x195;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x196;
    uint32_t x197;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x198;
    uint32_t x199;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x200;
    uint32_t x201;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x202;
    uint32_t x203;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x204;
    uint32_t x205;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x206;
    uint32_t x207;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x208;
    uint32_t x209;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x210;
    uint32_t x211;
    uint32_t x212;
    uint32_t x213;
    uint32_t x214;
    uint32_t x215;
    uint32_t x216;
    uint32_t x217;
    uint32_t x218;
    uint32_t x219;
    uint32_t x220;
    uint32_t x221;
    uint32_t x222;
    uint32_t x223;
    uint32_t x224;
    uint32_t x225;
    uint32_t x226;
    uint32_t x227;
    uint32_t x228;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x229;
    uint32_t x230;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x231;
    uint32_t x232;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x233;
    uint32_t x234;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x235;
    uint32_t x236;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x237;
    uint32_t x238;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x239;
    uint32_t x240;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x241;
    uint32_t x242;
    uint32_t x243;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x244;
    uint32_t x245;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x246;
    uint32_t x247;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x248;
    uint32_t x249;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x250;
    uint32_t x251;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x252;
    uint32_t x253;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x254;
    uint32_t x255;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x256;
    uint32_t x257;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x258;
    uint32_t x259;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x260;
    uint32_t x261;
    uint32_t x262;
    uint32_t x263;
    uint32_t x264;
    uint32_t x265;
    uint32_t x266;
    uint32_t x267;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x268;
    uint32_t x269;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x270;
    uint32_t x271;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x272;
    uint32_t x273;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x274;
    uint32_t x275;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x276;
    uint32_t x277;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x278;
    uint32_t x279;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x280;
    uint32_t x281;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x282;
    uint32_t x283;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x284;
    uint32_t x285;
    uint32_t x286;
    uint32_t x287;
    uint32_t x288;
    uint32_t x289;
    uint32_t x290;
    uint32_t x291;
    uint32_t x292;
    uint32_t x293;
    uint32_t x294;
    uint32_t x295;
    uint32_t x296;
    uint32_t x297;
    uint32_t x298;
    uint32_t x299;
    uint32_t x300;
    uint32_t x301;
    uint32_t x302;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x303;
    uint32_t x304;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x305;
    uint32_t x306;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x307;
    uint32_t x308;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x309;
    uint32_t x310;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x311;
    uint32_t x312;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x313;
    uint32_t x314;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x315;
    uint32_t x316;
    uint32_t x317;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x318;
    uint32_t x319;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x320;
    uint32_t x321;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x322;
    uint32_t x323;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x324;
    uint32_t x325;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x326;
    uint32_t x327;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x328;
    uint32_t x329;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x330;
    uint32_t x331;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x332;
    uint32_t x333;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x334;
    uint32_t x335;
    uint32_t x336;
    uint32_t x337;
    uint32_t x338;
    uint32_t x339;
    uint32_t x340;
    uint32_t x341;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x342;
    uint32_t x343;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x344;
    uint32_t x345;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x346;
    uint32_t x347;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x348;
    uint32_t x349;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x350;
    uint32_t x351;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x352;
    uint32_t x353;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x354;
    uint32_t x355;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x356;
    uint32_t x357;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x358;
    uint32_t x359;
    uint32_t x360;
    uint32_t x361;
    uint32_t x362;
    uint32_t x363;
    uint32_t x364;
    uint32_t x365;
    uint32_t x366;
    uint32_t x367;
    uint32_t x368;
    uint32_t x369;
    uint32_t x370;
    uint32_t x371;
    uint32_t x372;
    uint32_t x373;
    uint32_t x374;
    uint32_t x375;
    uint32_t x376;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x377;
    uint32_t x378;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x379;
    uint32_t x380;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x381;
    uint32_t x382;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x383;
    uint32_t x384;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x385;
    uint32_t x386;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x387;
    uint32_t x388;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x389;
    uint32_t x390;
    uint32_t x391;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x392;
    uint32_t x393;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x394;
    uint32_t x395;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x396;
    uint32_t x397;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x398;
    uint32_t x399;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x400;
    uint32_t x401;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x402;
    uint32_t x403;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x404;
    uint32_t x405;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x406;
    uint32_t x407;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x408;
    uint32_t x409;
    uint32_t x410;
    uint32_t x411;
    uint32_t x412;
    uint32_t x413;
    uint32_t x414;
    uint32_t x415;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x416;
    uint32_t x417;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x418;
    uint32_t x419;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x420;
    uint32_t x421;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x422;
    uint32_t x423;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x424;
    uint32_t x425;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x426;
    uint32_t x427;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x428;
    uint32_t x429;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x430;
    uint32_t x431;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x432;
    uint32_t x433;
    uint32_t x434;
    uint32_t x435;
    uint32_t x436;
    uint32_t x437;
    uint32_t x438;
    uint32_t x439;
    uint32_t x440;
    uint32_t x441;
    uint32_t x442;
    uint32_t x443;
    uint32_t x444;
    uint32_t x445;
    uint32_t x446;
    uint32_t x447;
    uint32_t x448;
    uint32_t x449;
    uint32_t x450;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x451;
    uint32_t x452;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x453;
    uint32_t x454;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x455;
    uint32_t x456;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x457;
    uint32_t x458;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x459;
    uint32_t x460;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x461;
    uint32_t x462;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x463;
    uint32_t x464;
    uint32_t x465;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x466;
    uint32_t x467;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x468;
    uint32_t x469;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x470;
    uint32_t x471;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x472;
    uint32_t x473;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x474;
    uint32_t x475;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x476;
    uint32_t x477;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x478;
    uint32_t x479;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x480;
    uint32_t x481;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x482;
    uint32_t x483;
    uint32_t x484;
    uint32_t x485;
    uint32_t x486;
    uint32_t x487;
    uint32_t x488;
    uint32_t x489;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x490;
    uint32_t x491;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x492;
    uint32_t x493;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x494;
    uint32_t x495;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x496;
    uint32_t x497;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x498;
    uint32_t x499;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x500;
    uint32_t x501;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x502;
    uint32_t x503;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x504;
    uint32_t x505;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x506;
    uint32_t x507;
    uint32_t x508;
    uint32_t x509;
    uint32_t x510;
    uint32_t x511;
    uint32_t x512;
    uint32_t x513;
    uint32_t x514;
    uint32_t x515;
    uint32_t x516;
    uint32_t x517;
    uint32_t x518;
    uint32_t x519;
    uint32_t x520;
    uint32_t x521;
    uint32_t x522;
    uint32_t x523;
    uint32_t x524;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x525;
    uint32_t x526;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x527;
    uint32_t x528;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x529;
    uint32_t x530;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x531;
    uint32_t x532;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x533;
    uint32_t x534;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x535;
    uint32_t x536;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x537;
    uint32_t x538;
    uint32_t x539;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x540;
    uint32_t x541;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x542;
    uint32_t x543;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x544;
    uint32_t x545;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x546;
    uint32_t x547;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x548;
    uint32_t x549;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x550;
    uint32_t x551;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x552;
    uint32_t x553;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x554;
    uint32_t x555;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x556;
    uint32_t x557;
    uint32_t x558;
    uint32_t x559;
    uint32_t x560;
    uint32_t x561;
    uint32_t x562;
    uint32_t x563;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x564;
    uint32_t x565;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x566;
    uint32_t x567;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x568;
    uint32_t x569;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x570;
    uint32_t x571;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x572;
    uint32_t x573;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x574;
    uint32_t x575;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x576;
    uint32_t x577;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x578;
    uint32_t x579;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x580;
    uint32_t x581;
    uint32_t x582;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x583;
    uint32_t x584;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x585;
    uint32_t x586;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x587;
    uint32_t x588;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x589;
    uint32_t x590;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x591;
    uint32_t x592;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x593;
    uint32_t x594;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x595;
    uint32_t x596;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x597;
    uint32_t x598;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x599;
    uint32_t x600;
    uint32_t x601;
    uint32_t x602;
    uint32_t x603;
    uint32_t x604;
    uint32_t x605;
    uint32_t x606;
    uint32_t x607;
    x1 = (arg1[1]);
    x2 = (arg1[2]);
    x3 = (arg1[3]);
    x4 = (arg1[4]);
    x5 = (arg1[5]);
    x6 = (arg1[6]);
    x7 = (arg1[7]);
    x8 = (arg1[0]);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x9, &x10, x8,
                                                         (arg2[7]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x11, &x12, x8,
                                                         (arg2[6]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x13, &x14, x8,
                                                         (arg2[5]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x15, &x16, x8,
                                                         (arg2[4]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x17, &x18, x8,
                                                         (arg2[3]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x19, &x20, x8,
                                                         (arg2[2]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x21, &x22, x8,
                                                         (arg2[1]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x23, &x24, x8,
                                                         (arg2[0]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x25, &x26, 0x0,
                                                              x24, x21);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x27, &x28, x26,
                                                              x22, x19);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x29, &x30, x28,
                                                              x20, x17);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x31, &x32, x30,
                                                              x18, x15);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x33, &x34, x32,
                                                              x16, x13);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x35, &x36, x34,
                                                              x14, x11);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x37, &x38, x36,
                                                              x12, x9);
    x39 = (x38 + x10);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x40, &x41, x23,
                                                         UINT32_C(0xa3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x42, &x43, x40,
                                                         UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x44, &x45, x40,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x46, &x47, 0x0,
                                                              x23, x44);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x48, &x49, x47,
                                                              x25, x45);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x50, &x51, x49,
                                                              x27, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x52, &x53, x51,
                                                              x29, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x54, &x55, x53,
                                                              x31, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x56, &x57, x55,
                                                              x33, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x58, &x59, x57,
                                                              x35, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x60, &x61, x59,
                                                              x37, x42);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x62, &x63, x61,
                                                              x39, x43);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x64, &x65, x1,
                                                         (arg2[7]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x66, &x67, x1,
                                                         (arg2[6]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x68, &x69, x1,
                                                         (arg2[5]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x70, &x71, x1,
                                                         (arg2[4]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x72, &x73, x1,
                                                         (arg2[3]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x74, &x75, x1,
                                                         (arg2[2]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x76, &x77, x1,
                                                         (arg2[1]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x78, &x79, x1,
                                                         (arg2[0]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x80, &x81, 0x0,
                                                              x79, x76);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x82, &x83, x81,
                                                              x77, x74);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x84, &x85, x83,
                                                              x75, x72);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x86, &x87, x85,
                                                              x73, x70);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x88, &x89, x87,
                                                              x71, x68);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x90, &x91, x89,
                                                              x69, x66);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x92, &x93, x91,
                                                              x67, x64);
    x94 = (x93 + x65);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x95, &x96, 0x0,
                                                              x48, x78);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x97, &x98, x96,
                                                              x50, x80);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x99, &x100, x98,
                                                              x52, x82);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x101, &x102,
                                                              x100, x54, x84);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x103, &x104,
                                                              x102, x56, x86);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x105, &x106,
                                                              x104, x58, x88);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x107, &x108,
                                                              x106, x60, x90);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x109, &x110,
                                                              x108, x62, x92);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x111, &x112,
                                                              x110, x63, x94);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x113, &x114, x95,
                                                         UINT32_C(0xa3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x115, &x116, x113,
                                                         UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x117, &x118, x113,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x119, &x120, 0x0,
                                                              x95, x117);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x121, &x122,
                                                              x120, x97, x118);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x123, &x124,
                                                              x122, x99, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x125, &x126,
                                                              x124, x101, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x127, &x128,
                                                              x126, x103, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x129, &x130,
                                                              x128, x105, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x131, &x132,
                                                              x130, x107, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x133, &x134,
                                                              x132, x109, x115);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x135, &x136,
                                                              x134, x111, x116);
    x137 = ((uint32_t)x136 + x112);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x138, &x139, x2,
                                                         (arg2[7]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x140, &x141, x2,
                                                         (arg2[6]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x142, &x143, x2,
                                                         (arg2[5]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x144, &x145, x2,
                                                         (arg2[4]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x146, &x147, x2,
                                                         (arg2[3]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x148, &x149, x2,
                                                         (arg2[2]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x150, &x151, x2,
                                                         (arg2[1]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x152, &x153, x2,
                                                         (arg2[0]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x154, &x155, 0x0,
                                                              x153, x150);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x156, &x157,
                                                              x155, x151, x148);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x158, &x159,
                                                              x157, x149, x146);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x160, &x161,
                                                              x159, x147, x144);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x162, &x163,
                                                              x161, x145, x142);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x164, &x165,
                                                              x163, x143, x140);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x166, &x167,
                                                              x165, x141, x138);
    x168 = (x167 + x139);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x169, &x170, 0x0,
                                                              x121, x152);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x171, &x172,
                                                              x170, x123, x154);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x173, &x174,
                                                              x172, x125, x156);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x175, &x176,
                                                              x174, x127, x158);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x177, &x178,
                                                              x176, x129, x160);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x179, &x180,
                                                              x178, x131, x162);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x181, &x182,
                                                              x180, x133, x164);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x183, &x184,
                                                              x182, x135, x166);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x185, &x186,
                                                              x184, x137, x168);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x187, &x188, x169,
                                                         UINT32_C(0xa3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x189, &x190, x187,
                                                         UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x191, &x192, x187,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x193, &x194, 0x0,
                                                              x169, x191);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x195, &x196,
                                                              x194, x171, x192);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x197, &x198,
                                                              x196, x173, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x199, &x200,
                                                              x198, x175, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x201, &x202,
                                                              x200, x177, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x203, &x204,
                                                              x202, x179, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x205, &x206,
                                                              x204, x181, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x207, &x208,
                                                              x206, x183, x189);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x209, &x210,
                                                              x208, x185, x190);
    x211 = ((uint32_t)x210 + x186);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x212, &x213, x3,
                                                         (arg2[7]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x214, &x215, x3,
                                                         (arg2[6]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x216, &x217, x3,
                                                         (arg2[5]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x218, &x219, x3,
                                                         (arg2[4]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x220, &x221, x3,
                                                         (arg2[3]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x222, &x223, x3,
                                                         (arg2[2]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x224, &x225, x3,
                                                         (arg2[1]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x226, &x227, x3,
                                                         (arg2[0]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x228, &x229, 0x0,
                                                              x227, x224);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x230, &x231,
                                                              x229, x225, x222);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x232, &x233,
                                                              x231, x223, x220);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x234, &x235,
                                                              x233, x221, x218);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x236, &x237,
                                                              x235, x219, x216);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x238, &x239,
                                                              x237, x217, x214);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x240, &x241,
                                                              x239, x215, x212);
    x242 = (x241 + x213);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x243, &x244, 0x0,
                                                              x195, x226);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x245, &x246,
                                                              x244, x197, x228);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x247, &x248,
                                                              x246, x199, x230);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x249, &x250,
                                                              x248, x201, x232);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x251, &x252,
                                                              x250, x203, x234);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x253, &x254,
                                                              x252, x205, x236);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x255, &x256,
                                                              x254, x207, x238);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x257, &x258,
                                                              x256, x209, x240);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x259, &x260,
                                                              x258, x211, x242);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x261, &x262, x243,
                                                         UINT32_C(0xa3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x263, &x264, x261,
                                                         UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x265, &x266, x261,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x267, &x268, 0x0,
                                                              x243, x265);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x269, &x270,
                                                              x268, x245, x266);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x271, &x272,
                                                              x270, x247, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x273, &x274,
                                                              x272, x249, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x275, &x276,
                                                              x274, x251, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x277, &x278,
                                                              x276, x253, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x279, &x280,
                                                              x278, x255, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x281, &x282,
                                                              x280, x257, x263);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x283, &x284,
                                                              x282, x259, x264);
    x285 = ((uint32_t)x284 + x260);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x286, &x287, x4,
                                                         (arg2[7]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x288, &x289, x4,
                                                         (arg2[6]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x290, &x291, x4,
                                                         (arg2[5]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x292, &x293, x4,
                                                         (arg2[4]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x294, &x295, x4,
                                                         (arg2[3]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x296, &x297, x4,
                                                         (arg2[2]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x298, &x299, x4,
                                                         (arg2[1]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x300, &x301, x4,
                                                         (arg2[0]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x302, &x303, 0x0,
                                                              x301, x298);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x304, &x305,
                                                              x303, x299, x296);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x306, &x307,
                                                              x305, x297, x294);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x308, &x309,
                                                              x307, x295, x292);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x310, &x311,
                                                              x309, x293, x290);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x312, &x313,
                                                              x311, x291, x288);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x314, &x315,
                                                              x313, x289, x286);
    x316 = (x315 + x287);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x317, &x318, 0x0,
                                                              x269, x300);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x319, &x320,
                                                              x318, x271, x302);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x321, &x322,
                                                              x320, x273, x304);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x323, &x324,
                                                              x322, x275, x306);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x325, &x326,
                                                              x324, x277, x308);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x327, &x328,
                                                              x326, x279, x310);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x329, &x330,
                                                              x328, x281, x312);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x331, &x332,
                                                              x330, x283, x314);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x333, &x334,
                                                              x332, x285, x316);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x335, &x336, x317,
                                                         UINT32_C(0xa3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x337, &x338, x335,
                                                         UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x339, &x340, x335,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x341, &x342, 0x0,
                                                              x317, x339);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x343, &x344,
                                                              x342, x319, x340);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x345, &x346,
                                                              x344, x321, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x347, &x348,
                                                              x346, x323, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x349, &x350,
                                                              x348, x325, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x351, &x352,
                                                              x350, x327, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x353, &x354,
                                                              x352, x329, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x355, &x356,
                                                              x354, x331, x337);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x357, &x358,
                                                              x356, x333, x338);
    x359 = ((uint32_t)x358 + x334);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x360, &x361, x5,
                                                         (arg2[7]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x362, &x363, x5,
                                                         (arg2[6]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x364, &x365, x5,
                                                         (arg2[5]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x366, &x367, x5,
                                                         (arg2[4]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x368, &x369, x5,
                                                         (arg2[3]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x370, &x371, x5,
                                                         (arg2[2]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x372, &x373, x5,
                                                         (arg2[1]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x374, &x375, x5,
                                                         (arg2[0]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x376, &x377, 0x0,
                                                              x375, x372);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x378, &x379,
                                                              x377, x373, x370);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x380, &x381,
                                                              x379, x371, x368);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x382, &x383,
                                                              x381, x369, x366);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x384, &x385,
                                                              x383, x367, x364);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x386, &x387,
                                                              x385, x365, x362);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x388, &x389,
                                                              x387, x363, x360);
    x390 = (x389 + x361);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x391, &x392, 0x0,
                                                              x343, x374);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x393, &x394,
                                                              x392, x345, x376);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x395, &x396,
                                                              x394, x347, x378);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x397, &x398,
                                                              x396, x349, x380);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x399, &x400,
                                                              x398, x351, x382);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x401, &x402,
                                                              x400, x353, x384);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x403, &x404,
                                                              x402, x355, x386);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x405, &x406,
                                                              x404, x357, x388);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x407, &x408,
                                                              x406, x359, x390);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x409, &x410, x391,
                                                         UINT32_C(0xa3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x411, &x412, x409,
                                                         UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x413, &x414, x409,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x415, &x416, 0x0,
                                                              x391, x413);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x417, &x418,
                                                              x416, x393, x414);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x419, &x420,
                                                              x418, x395, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x421, &x422,
                                                              x420, x397, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x423, &x424,
                                                              x422, x399, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x425, &x426,
                                                              x424, x401, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x427, &x428,
                                                              x426, x403, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x429, &x430,
                                                              x428, x405, x411);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x431, &x432,
                                                              x430, x407, x412);
    x433 = ((uint32_t)x432 + x408);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x434, &x435, x6,
                                                         (arg2[7]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x436, &x437, x6,
                                                         (arg2[6]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x438, &x439, x6,
                                                         (arg2[5]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x440, &x441, x6,
                                                         (arg2[4]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x442, &x443, x6,
                                                         (arg2[3]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x444, &x445, x6,
                                                         (arg2[2]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x446, &x447, x6,
                                                         (arg2[1]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x448, &x449, x6,
                                                         (arg2[0]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x450, &x451, 0x0,
                                                              x449, x446);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x452, &x453,
                                                              x451, x447, x444);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x454, &x455,
                                                              x453, x445, x442);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x456, &x457,
                                                              x455, x443, x440);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x458, &x459,
                                                              x457, x441, x438);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x460, &x461,
                                                              x459, x439, x436);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x462, &x463,
                                                              x461, x437, x434);
    x464 = (x463 + x435);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x465, &x466, 0x0,
                                                              x417, x448);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x467, &x468,
                                                              x466, x419, x450);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x469, &x470,
                                                              x468, x421, x452);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x471, &x472,
                                                              x470, x423, x454);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x473, &x474,
                                                              x472, x425, x456);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x475, &x476,
                                                              x474, x427, x458);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x477, &x478,
                                                              x476, x429, x460);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x479, &x480,
                                                              x478, x431, x462);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x481, &x482,
                                                              x480, x433, x464);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x483, &x484, x465,
                                                         UINT32_C(0xa3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x485, &x486, x483,
                                                         UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x487, &x488, x483,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x489, &x490, 0x0,
                                                              x465, x487);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x491, &x492,
                                                              x490, x467, x488);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x493, &x494,
                                                              x492, x469, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x495, &x496,
                                                              x494, x471, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x497, &x498,
                                                              x496, x473, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x499, &x500,
                                                              x498, x475, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x501, &x502,
                                                              x500, x477, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x503, &x504,
                                                              x502, x479, x485);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x505, &x506,
                                                              x504, x481, x486);
    x507 = ((uint32_t)x506 + x482);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x508, &x509, x7,
                                                         (arg2[7]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x510, &x511, x7,
                                                         (arg2[6]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x512, &x513, x7,
                                                         (arg2[5]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x514, &x515, x7,
                                                         (arg2[4]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x516, &x517, x7,
                                                         (arg2[3]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x518, &x519, x7,
                                                         (arg2[2]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x520, &x521, x7,
                                                         (arg2[1]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x522, &x523, x7,
                                                         (arg2[0]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x524, &x525, 0x0,
                                                              x523, x520);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x526, &x527,
                                                              x525, x521, x518);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x528, &x529,
                                                              x527, x519, x516);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x530, &x531,
                                                              x529, x517, x514);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x532, &x533,
                                                              x531, x515, x512);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x534, &x535,
                                                              x533, x513, x510);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x536, &x537,
                                                              x535, x511, x508);
    x538 = (x537 + x509);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x539, &x540, 0x0,
                                                              x491, x522);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x541, &x542,
                                                              x540, x493, x524);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x543, &x544,
                                                              x542, x495, x526);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x545, &x546,
                                                              x544, x497, x528);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x547, &x548,
                                                              x546, x499, x530);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x549, &x550,
                                                              x548, x501, x532);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x551, &x552,
                                                              x550, x503, x534);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x553, &x554,
                                                              x552, x505, x536);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x555, &x556,
                                                              x554, x507, x538);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x557, &x558, x539,
                                                         UINT32_C(0xa3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x559, &x560, x557,
                                                         UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x561, &x562, x557,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x563, &x564, 0x0,
                                                              x539, x561);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x565, &x566,
                                                              x564, x541, x562);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x567, &x568,
                                                              x566, x543, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x569, &x570,
                                                              x568, x545, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x571, &x572,
                                                              x570, x547, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x573, &x574,
                                                              x572, x549, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x575, &x576,
                                                              x574, x551, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x577, &x578,
                                                              x576, x553, x559);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x579, &x580,
                                                              x578, x555, x560);
    x581 = ((uint32_t)x580 + x556);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(
        &x582, &x583, 0x0, x565, UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(&x584, &x585,
                                                               x583, x567, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(&x586, &x587,
                                                               x585, x569, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(&x588, &x589,
                                                               x587, x571, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(&x590, &x591,
                                                               x589, x573, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(&x592, &x593,
                                                               x591, x575, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(&x594, &x595,
                                                               x593, x577, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(
        &x596, &x597, x595, x579, UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(&x598, &x599,
                                                               x597, x581, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(&x600, x599, x582,
                                                            x565);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(&x601, x599, x584,
                                                            x567);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(&x602, x599, x586,
                                                            x569);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(&x603, x599, x588,
                                                            x571);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(&x604, x599, x590,
                                                            x573);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(&x605, x599, x592,
                                                            x575);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(&x606, x599, x594,
                                                            x577);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(&x607, x599, x596,
                                                            x579);
    out1[0] = x600;
    out1[1] = x601;
    out1[2] = x602;
    out1[3] = x603;
    out1[4] = x604;
    out1[5] = x605;
    out1[6] = x606;
    out1[7] = x607;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_square squares a field element in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg1)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_square(
    uint32_t out1[8], const uint32_t arg1[8]) {
    uint32_t x1;
    uint32_t x2;
    uint32_t x3;
    uint32_t x4;
    uint32_t x5;
    uint32_t x6;
    uint32_t x7;
    uint32_t x8;
    uint32_t x9;
    uint32_t x10;
    uint32_t x11;
    uint32_t x12;
    uint32_t x13;
    uint32_t x14;
    uint32_t x15;
    uint32_t x16;
    uint32_t x17;
    uint32_t x18;
    uint32_t x19;
    uint32_t x20;
    uint32_t x21;
    uint32_t x22;
    uint32_t x23;
    uint32_t x24;
    uint32_t x25;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x26;
    uint32_t x27;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x28;
    uint32_t x29;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x30;
    uint32_t x31;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x32;
    uint32_t x33;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x34;
    uint32_t x35;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x36;
    uint32_t x37;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x38;
    uint32_t x39;
    uint32_t x40;
    uint32_t x41;
    uint32_t x42;
    uint32_t x43;
    uint32_t x44;
    uint32_t x45;
    uint32_t x46;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x47;
    uint32_t x48;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x49;
    uint32_t x50;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x51;
    uint32_t x52;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x53;
    uint32_t x54;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x55;
    uint32_t x56;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x57;
    uint32_t x58;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x59;
    uint32_t x60;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x61;
    uint32_t x62;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x63;
    uint32_t x64;
    uint32_t x65;
    uint32_t x66;
    uint32_t x67;
    uint32_t x68;
    uint32_t x69;
    uint32_t x70;
    uint32_t x71;
    uint32_t x72;
    uint32_t x73;
    uint32_t x74;
    uint32_t x75;
    uint32_t x76;
    uint32_t x77;
    uint32_t x78;
    uint32_t x79;
    uint32_t x80;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x81;
    uint32_t x82;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x83;
    uint32_t x84;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x85;
    uint32_t x86;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x87;
    uint32_t x88;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x89;
    uint32_t x90;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x91;
    uint32_t x92;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x93;
    uint32_t x94;
    uint32_t x95;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x96;
    uint32_t x97;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x98;
    uint32_t x99;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x100;
    uint32_t x101;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x102;
    uint32_t x103;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x104;
    uint32_t x105;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x106;
    uint32_t x107;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x108;
    uint32_t x109;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x110;
    uint32_t x111;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x112;
    uint32_t x113;
    uint32_t x114;
    uint32_t x115;
    uint32_t x116;
    uint32_t x117;
    uint32_t x118;
    uint32_t x119;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x120;
    uint32_t x121;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x122;
    uint32_t x123;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x124;
    uint32_t x125;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x126;
    uint32_t x127;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x128;
    uint32_t x129;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x130;
    uint32_t x131;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x132;
    uint32_t x133;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x134;
    uint32_t x135;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x136;
    uint32_t x137;
    uint32_t x138;
    uint32_t x139;
    uint32_t x140;
    uint32_t x141;
    uint32_t x142;
    uint32_t x143;
    uint32_t x144;
    uint32_t x145;
    uint32_t x146;
    uint32_t x147;
    uint32_t x148;
    uint32_t x149;
    uint32_t x150;
    uint32_t x151;
    uint32_t x152;
    uint32_t x153;
    uint32_t x154;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x155;
    uint32_t x156;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x157;
    uint32_t x158;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x159;
    uint32_t x160;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x161;
    uint32_t x162;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x163;
    uint32_t x164;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x165;
    uint32_t x166;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x167;
    uint32_t x168;
    uint32_t x169;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x170;
    uint32_t x171;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x172;
    uint32_t x173;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x174;
    uint32_t x175;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x176;
    uint32_t x177;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x178;
    uint32_t x179;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x180;
    uint32_t x181;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x182;
    uint32_t x183;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x184;
    uint32_t x185;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x186;
    uint32_t x187;
    uint32_t x188;
    uint32_t x189;
    uint32_t x190;
    uint32_t x191;
    uint32_t x192;
    uint32_t x193;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x194;
    uint32_t x195;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x196;
    uint32_t x197;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x198;
    uint32_t x199;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x200;
    uint32_t x201;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x202;
    uint32_t x203;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x204;
    uint32_t x205;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x206;
    uint32_t x207;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x208;
    uint32_t x209;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x210;
    uint32_t x211;
    uint32_t x212;
    uint32_t x213;
    uint32_t x214;
    uint32_t x215;
    uint32_t x216;
    uint32_t x217;
    uint32_t x218;
    uint32_t x219;
    uint32_t x220;
    uint32_t x221;
    uint32_t x222;
    uint32_t x223;
    uint32_t x224;
    uint32_t x225;
    uint32_t x226;
    uint32_t x227;
    uint32_t x228;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x229;
    uint32_t x230;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x231;
    uint32_t x232;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x233;
    uint32_t x234;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x235;
    uint32_t x236;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x237;
    uint32_t x238;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x239;
    uint32_t x240;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x241;
    uint32_t x242;
    uint32_t x243;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x244;
    uint32_t x245;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x246;
    uint32_t x247;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x248;
    uint32_t x249;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x250;
    uint32_t x251;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x252;
    uint32_t x253;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x254;
    uint32_t x255;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x256;
    uint32_t x257;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x258;
    uint32_t x259;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x260;
    uint32_t x261;
    uint32_t x262;
    uint32_t x263;
    uint32_t x264;
    uint32_t x265;
    uint32_t x266;
    uint32_t x267;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x268;
    uint32_t x269;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x270;
    uint32_t x271;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x272;
    uint32_t x273;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x274;
    uint32_t x275;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x276;
    uint32_t x277;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x278;
    uint32_t x279;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x280;
    uint32_t x281;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x282;
    uint32_t x283;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x284;
    uint32_t x285;
    uint32_t x286;
    uint32_t x287;
    uint32_t x288;
    uint32_t x289;
    uint32_t x290;
    uint32_t x291;
    uint32_t x292;
    uint32_t x293;
    uint32_t x294;
    uint32_t x295;
    uint32_t x296;
    uint32_t x297;
    uint32_t x298;
    uint32_t x299;
    uint32_t x300;
    uint32_t x301;
    uint32_t x302;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x303;
    uint32_t x304;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x305;
    uint32_t x306;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x307;
    uint32_t x308;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x309;
    uint32_t x310;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x311;
    uint32_t x312;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x313;
    uint32_t x314;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x315;
    uint32_t x316;
    uint32_t x317;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x318;
    uint32_t x319;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x320;
    uint32_t x321;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x322;
    uint32_t x323;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x324;
    uint32_t x325;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x326;
    uint32_t x327;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x328;
    uint32_t x329;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x330;
    uint32_t x331;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x332;
    uint32_t x333;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x334;
    uint32_t x335;
    uint32_t x336;
    uint32_t x337;
    uint32_t x338;
    uint32_t x339;
    uint32_t x340;
    uint32_t x341;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x342;
    uint32_t x343;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x344;
    uint32_t x345;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x346;
    uint32_t x347;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x348;
    uint32_t x349;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x350;
    uint32_t x351;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x352;
    uint32_t x353;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x354;
    uint32_t x355;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x356;
    uint32_t x357;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x358;
    uint32_t x359;
    uint32_t x360;
    uint32_t x361;
    uint32_t x362;
    uint32_t x363;
    uint32_t x364;
    uint32_t x365;
    uint32_t x366;
    uint32_t x367;
    uint32_t x368;
    uint32_t x369;
    uint32_t x370;
    uint32_t x371;
    uint32_t x372;
    uint32_t x373;
    uint32_t x374;
    uint32_t x375;
    uint32_t x376;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x377;
    uint32_t x378;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x379;
    uint32_t x380;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x381;
    uint32_t x382;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x383;
    uint32_t x384;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x385;
    uint32_t x386;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x387;
    uint32_t x388;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x389;
    uint32_t x390;
    uint32_t x391;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x392;
    uint32_t x393;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x394;
    uint32_t x395;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x396;
    uint32_t x397;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x398;
    uint32_t x399;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x400;
    uint32_t x401;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x402;
    uint32_t x403;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x404;
    uint32_t x405;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x406;
    uint32_t x407;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x408;
    uint32_t x409;
    uint32_t x410;
    uint32_t x411;
    uint32_t x412;
    uint32_t x413;
    uint32_t x414;
    uint32_t x415;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x416;
    uint32_t x417;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x418;
    uint32_t x419;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x420;
    uint32_t x421;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x422;
    uint32_t x423;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x424;
    uint32_t x425;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x426;
    uint32_t x427;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x428;
    uint32_t x429;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x430;
    uint32_t x431;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x432;
    uint32_t x433;
    uint32_t x434;
    uint32_t x435;
    uint32_t x436;
    uint32_t x437;
    uint32_t x438;
    uint32_t x439;
    uint32_t x440;
    uint32_t x441;
    uint32_t x442;
    uint32_t x443;
    uint32_t x444;
    uint32_t x445;
    uint32_t x446;
    uint32_t x447;
    uint32_t x448;
    uint32_t x449;
    uint32_t x450;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x451;
    uint32_t x452;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x453;
    uint32_t x454;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x455;
    uint32_t x456;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x457;
    uint32_t x458;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x459;
    uint32_t x460;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x461;
    uint32_t x462;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x463;
    uint32_t x464;
    uint32_t x465;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x466;
    uint32_t x467;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x468;
    uint32_t x469;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x470;
    uint32_t x471;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x472;
    uint32_t x473;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x474;
    uint32_t x475;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x476;
    uint32_t x477;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x478;
    uint32_t x479;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x480;
    uint32_t x481;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x482;
    uint32_t x483;
    uint32_t x484;
    uint32_t x485;
    uint32_t x486;
    uint32_t x487;
    uint32_t x488;
    uint32_t x489;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x490;
    uint32_t x491;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x492;
    uint32_t x493;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x494;
    uint32_t x495;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x496;
    uint32_t x497;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x498;
    uint32_t x499;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x500;
    uint32_t x501;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x502;
    uint32_t x503;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x504;
    uint32_t x505;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x506;
    uint32_t x507;
    uint32_t x508;
    uint32_t x509;
    uint32_t x510;
    uint32_t x511;
    uint32_t x512;
    uint32_t x513;
    uint32_t x514;
    uint32_t x515;
    uint32_t x516;
    uint32_t x517;
    uint32_t x518;
    uint32_t x519;
    uint32_t x520;
    uint32_t x521;
    uint32_t x522;
    uint32_t x523;
    uint32_t x524;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x525;
    uint32_t x526;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x527;
    uint32_t x528;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x529;
    uint32_t x530;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x531;
    uint32_t x532;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x533;
    uint32_t x534;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x535;
    uint32_t x536;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x537;
    uint32_t x538;
    uint32_t x539;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x540;
    uint32_t x541;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x542;
    uint32_t x543;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x544;
    uint32_t x545;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x546;
    uint32_t x547;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x548;
    uint32_t x549;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x550;
    uint32_t x551;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x552;
    uint32_t x553;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x554;
    uint32_t x555;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x556;
    uint32_t x557;
    uint32_t x558;
    uint32_t x559;
    uint32_t x560;
    uint32_t x561;
    uint32_t x562;
    uint32_t x563;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x564;
    uint32_t x565;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x566;
    uint32_t x567;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x568;
    uint32_t x569;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x570;
    uint32_t x571;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x572;
    uint32_t x573;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x574;
    uint32_t x575;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x576;
    uint32_t x577;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x578;
    uint32_t x579;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x580;
    uint32_t x581;
    uint32_t x582;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x583;
    uint32_t x584;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x585;
    uint32_t x586;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x587;
    uint32_t x588;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x589;
    uint32_t x590;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x591;
    uint32_t x592;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x593;
    uint32_t x594;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x595;
    uint32_t x596;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x597;
    uint32_t x598;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x599;
    uint32_t x600;
    uint32_t x601;
    uint32_t x602;
    uint32_t x603;
    uint32_t x604;
    uint32_t x605;
    uint32_t x606;
    uint32_t x607;
    x1 = (arg1[1]);
    x2 = (arg1[2]);
    x3 = (arg1[3]);
    x4 = (arg1[4]);
    x5 = (arg1[5]);
    x6 = (arg1[6]);
    x7 = (arg1[7]);
    x8 = (arg1[0]);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x9, &x10, x8,
                                                         (arg1[7]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x11, &x12, x8,
                                                         (arg1[6]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x13, &x14, x8,
                                                         (arg1[5]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x15, &x16, x8,
                                                         (arg1[4]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x17, &x18, x8,
                                                         (arg1[3]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x19, &x20, x8,
                                                         (arg1[2]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x21, &x22, x8,
                                                         (arg1[1]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x23, &x24, x8,
                                                         (arg1[0]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x25, &x26, 0x0,
                                                              x24, x21);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x27, &x28, x26,
                                                              x22, x19);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x29, &x30, x28,
                                                              x20, x17);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x31, &x32, x30,
                                                              x18, x15);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x33, &x34, x32,
                                                              x16, x13);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x35, &x36, x34,
                                                              x14, x11);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x37, &x38, x36,
                                                              x12, x9);
    x39 = (x38 + x10);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x40, &x41, x23,
                                                         UINT32_C(0xa3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x42, &x43, x40,
                                                         UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x44, &x45, x40,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x46, &x47, 0x0,
                                                              x23, x44);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x48, &x49, x47,
                                                              x25, x45);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x50, &x51, x49,
                                                              x27, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x52, &x53, x51,
                                                              x29, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x54, &x55, x53,
                                                              x31, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x56, &x57, x55,
                                                              x33, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x58, &x59, x57,
                                                              x35, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x60, &x61, x59,
                                                              x37, x42);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x62, &x63, x61,
                                                              x39, x43);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x64, &x65, x1,
                                                         (arg1[7]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x66, &x67, x1,
                                                         (arg1[6]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x68, &x69, x1,
                                                         (arg1[5]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x70, &x71, x1,
                                                         (arg1[4]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x72, &x73, x1,
                                                         (arg1[3]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x74, &x75, x1,
                                                         (arg1[2]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x76, &x77, x1,
                                                         (arg1[1]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x78, &x79, x1,
                                                         (arg1[0]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x80, &x81, 0x0,
                                                              x79, x76);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x82, &x83, x81,
                                                              x77, x74);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x84, &x85, x83,
                                                              x75, x72);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x86, &x87, x85,
                                                              x73, x70);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x88, &x89, x87,
                                                              x71, x68);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x90, &x91, x89,
                                                              x69, x66);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x92, &x93, x91,
                                                              x67, x64);
    x94 = (x93 + x65);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x95, &x96, 0x0,
                                                              x48, x78);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x97, &x98, x96,
                                                              x50, x80);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x99, &x100, x98,
                                                              x52, x82);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x101, &x102,
                                                              x100, x54, x84);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x103, &x104,
                                                              x102, x56, x86);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x105, &x106,
                                                              x104, x58, x88);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x107, &x108,
                                                              x106, x60, x90);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x109, &x110,
                                                              x108, x62, x92);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x111, &x112,
                                                              x110, x63, x94);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x113, &x114, x95,
                                                         UINT32_C(0xa3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x115, &x116, x113,
                                                         UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x117, &x118, x113,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x119, &x120, 0x0,
                                                              x95, x117);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x121, &x122,
                                                              x120, x97, x118);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x123, &x124,
                                                              x122, x99, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x125, &x126,
                                                              x124, x101, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x127, &x128,
                                                              x126, x103, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x129, &x130,
                                                              x128, x105, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x131, &x132,
                                                              x130, x107, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x133, &x134,
                                                              x132, x109, x115);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x135, &x136,
                                                              x134, x111, x116);
    x137 = ((uint32_t)x136 + x112);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x138, &x139, x2,
                                                         (arg1[7]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x140, &x141, x2,
                                                         (arg1[6]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x142, &x143, x2,
                                                         (arg1[5]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x144, &x145, x2,
                                                         (arg1[4]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x146, &x147, x2,
                                                         (arg1[3]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x148, &x149, x2,
                                                         (arg1[2]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x150, &x151, x2,
                                                         (arg1[1]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x152, &x153, x2,
                                                         (arg1[0]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x154, &x155, 0x0,
                                                              x153, x150);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x156, &x157,
                                                              x155, x151, x148);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x158, &x159,
                                                              x157, x149, x146);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x160, &x161,
                                                              x159, x147, x144);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x162, &x163,
                                                              x161, x145, x142);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x164, &x165,
                                                              x163, x143, x140);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x166, &x167,
                                                              x165, x141, x138);
    x168 = (x167 + x139);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x169, &x170, 0x0,
                                                              x121, x152);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x171, &x172,
                                                              x170, x123, x154);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x173, &x174,
                                                              x172, x125, x156);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x175, &x176,
                                                              x174, x127, x158);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x177, &x178,
                                                              x176, x129, x160);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x179, &x180,
                                                              x178, x131, x162);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x181, &x182,
                                                              x180, x133, x164);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x183, &x184,
                                                              x182, x135, x166);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x185, &x186,
                                                              x184, x137, x168);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x187, &x188, x169,
                                                         UINT32_C(0xa3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x189, &x190, x187,
                                                         UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x191, &x192, x187,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x193, &x194, 0x0,
                                                              x169, x191);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x195, &x196,
                                                              x194, x171, x192);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x197, &x198,
                                                              x196, x173, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x199, &x200,
                                                              x198, x175, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x201, &x202,
                                                              x200, x177, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x203, &x204,
                                                              x202, x179, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x205, &x206,
                                                              x204, x181, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x207, &x208,
                                                              x206, x183, x189);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x209, &x210,
                                                              x208, x185, x190);
    x211 = ((uint32_t)x210 + x186);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x212, &x213, x3,
                                                         (arg1[7]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x214, &x215, x3,
                                                         (arg1[6]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x216, &x217, x3,
                                                         (arg1[5]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x218, &x219, x3,
                                                         (arg1[4]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x220, &x221, x3,
                                                         (arg1[3]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x222, &x223, x3,
                                                         (arg1[2]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x224, &x225, x3,
                                                         (arg1[1]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x226, &x227, x3,
                                                         (arg1[0]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x228, &x229, 0x0,
                                                              x227, x224);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x230, &x231,
                                                              x229, x225, x222);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x232, &x233,
                                                              x231, x223, x220);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x234, &x235,
                                                              x233, x221, x218);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x236, &x237,
                                                              x235, x219, x216);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x238, &x239,
                                                              x237, x217, x214);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x240, &x241,
                                                              x239, x215, x212);
    x242 = (x241 + x213);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x243, &x244, 0x0,
                                                              x195, x226);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x245, &x246,
                                                              x244, x197, x228);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x247, &x248,
                                                              x246, x199, x230);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x249, &x250,
                                                              x248, x201, x232);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x251, &x252,
                                                              x250, x203, x234);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x253, &x254,
                                                              x252, x205, x236);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x255, &x256,
                                                              x254, x207, x238);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x257, &x258,
                                                              x256, x209, x240);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x259, &x260,
                                                              x258, x211, x242);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x261, &x262, x243,
                                                         UINT32_C(0xa3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x263, &x264, x261,
                                                         UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x265, &x266, x261,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x267, &x268, 0x0,
                                                              x243, x265);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x269, &x270,
                                                              x268, x245, x266);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x271, &x272,
                                                              x270, x247, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x273, &x274,
                                                              x272, x249, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x275, &x276,
                                                              x274, x251, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x277, &x278,
                                                              x276, x253, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x279, &x280,
                                                              x278, x255, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x281, &x282,
                                                              x280, x257, x263);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x283, &x284,
                                                              x282, x259, x264);
    x285 = ((uint32_t)x284 + x260);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x286, &x287, x4,
                                                         (arg1[7]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x288, &x289, x4,
                                                         (arg1[6]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x290, &x291, x4,
                                                         (arg1[5]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x292, &x293, x4,
                                                         (arg1[4]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x294, &x295, x4,
                                                         (arg1[3]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x296, &x297, x4,
                                                         (arg1[2]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x298, &x299, x4,
                                                         (arg1[1]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x300, &x301, x4,
                                                         (arg1[0]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x302, &x303, 0x0,
                                                              x301, x298);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x304, &x305,
                                                              x303, x299, x296);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x306, &x307,
                                                              x305, x297, x294);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x308, &x309,
                                                              x307, x295, x292);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x310, &x311,
                                                              x309, x293, x290);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x312, &x313,
                                                              x311, x291, x288);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x314, &x315,
                                                              x313, x289, x286);
    x316 = (x315 + x287);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x317, &x318, 0x0,
                                                              x269, x300);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x319, &x320,
                                                              x318, x271, x302);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x321, &x322,
                                                              x320, x273, x304);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x323, &x324,
                                                              x322, x275, x306);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x325, &x326,
                                                              x324, x277, x308);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x327, &x328,
                                                              x326, x279, x310);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x329, &x330,
                                                              x328, x281, x312);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x331, &x332,
                                                              x330, x283, x314);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x333, &x334,
                                                              x332, x285, x316);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x335, &x336, x317,
                                                         UINT32_C(0xa3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x337, &x338, x335,
                                                         UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x339, &x340, x335,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x341, &x342, 0x0,
                                                              x317, x339);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x343, &x344,
                                                              x342, x319, x340);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x345, &x346,
                                                              x344, x321, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x347, &x348,
                                                              x346, x323, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x349, &x350,
                                                              x348, x325, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x351, &x352,
                                                              x350, x327, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x353, &x354,
                                                              x352, x329, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x355, &x356,
                                                              x354, x331, x337);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x357, &x358,
                                                              x356, x333, x338);
    x359 = ((uint32_t)x358 + x334);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x360, &x361, x5,
                                                         (arg1[7]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x362, &x363, x5,
                                                         (arg1[6]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x364, &x365, x5,
                                                         (arg1[5]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x366, &x367, x5,
                                                         (arg1[4]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x368, &x369, x5,
                                                         (arg1[3]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x370, &x371, x5,
                                                         (arg1[2]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x372, &x373, x5,
                                                         (arg1[1]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x374, &x375, x5,
                                                         (arg1[0]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x376, &x377, 0x0,
                                                              x375, x372);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x378, &x379,
                                                              x377, x373, x370);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x380, &x381,
                                                              x379, x371, x368);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x382, &x383,
                                                              x381, x369, x366);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x384, &x385,
                                                              x383, x367, x364);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x386, &x387,
                                                              x385, x365, x362);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x388, &x389,
                                                              x387, x363, x360);
    x390 = (x389 + x361);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x391, &x392, 0x0,
                                                              x343, x374);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x393, &x394,
                                                              x392, x345, x376);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x395, &x396,
                                                              x394, x347, x378);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x397, &x398,
                                                              x396, x349, x380);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x399, &x400,
                                                              x398, x351, x382);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x401, &x402,
                                                              x400, x353, x384);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x403, &x404,
                                                              x402, x355, x386);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x405, &x406,
                                                              x404, x357, x388);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x407, &x408,
                                                              x406, x359, x390);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x409, &x410, x391,
                                                         UINT32_C(0xa3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x411, &x412, x409,
                                                         UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x413, &x414, x409,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x415, &x416, 0x0,
                                                              x391, x413);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x417, &x418,
                                                              x416, x393, x414);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x419, &x420,
                                                              x418, x395, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x421, &x422,
                                                              x420, x397, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x423, &x424,
                                                              x422, x399, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x425, &x426,
                                                              x424, x401, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x427, &x428,
                                                              x426, x403, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x429, &x430,
                                                              x428, x405, x411);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x431, &x432,
                                                              x430, x407, x412);
    x433 = ((uint32_t)x432 + x408);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x434, &x435, x6,
                                                         (arg1[7]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x436, &x437, x6,
                                                         (arg1[6]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x438, &x439, x6,
                                                         (arg1[5]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x440, &x441, x6,
                                                         (arg1[4]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x442, &x443, x6,
                                                         (arg1[3]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x444, &x445, x6,
                                                         (arg1[2]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x446, &x447, x6,
                                                         (arg1[1]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x448, &x449, x6,
                                                         (arg1[0]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x450, &x451, 0x0,
                                                              x449, x446);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x452, &x453,
                                                              x451, x447, x444);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x454, &x455,
                                                              x453, x445, x442);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x456, &x457,
                                                              x455, x443, x440);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x458, &x459,
                                                              x457, x441, x438);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x460, &x461,
                                                              x459, x439, x436);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x462, &x463,
                                                              x461, x437, x434);
    x464 = (x463 + x435);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x465, &x466, 0x0,
                                                              x417, x448);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x467, &x468,
                                                              x466, x419, x450);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x469, &x470,
                                                              x468, x421, x452);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x471, &x472,
                                                              x470, x423, x454);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x473, &x474,
                                                              x472, x425, x456);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x475, &x476,
                                                              x474, x427, x458);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x477, &x478,
                                                              x476, x429, x460);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x479, &x480,
                                                              x478, x431, x462);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x481, &x482,
                                                              x480, x433, x464);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x483, &x484, x465,
                                                         UINT32_C(0xa3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x485, &x486, x483,
                                                         UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x487, &x488, x483,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x489, &x490, 0x0,
                                                              x465, x487);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x491, &x492,
                                                              x490, x467, x488);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x493, &x494,
                                                              x492, x469, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x495, &x496,
                                                              x494, x471, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x497, &x498,
                                                              x496, x473, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x499, &x500,
                                                              x498, x475, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x501, &x502,
                                                              x500, x477, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x503, &x504,
                                                              x502, x479, x485);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x505, &x506,
                                                              x504, x481, x486);
    x507 = ((uint32_t)x506 + x482);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x508, &x509, x7,
                                                         (arg1[7]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x510, &x511, x7,
                                                         (arg1[6]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x512, &x513, x7,
                                                         (arg1[5]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x514, &x515, x7,
                                                         (arg1[4]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x516, &x517, x7,
                                                         (arg1[3]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x518, &x519, x7,
                                                         (arg1[2]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x520, &x521, x7,
                                                         (arg1[1]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x522, &x523, x7,
                                                         (arg1[0]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x524, &x525, 0x0,
                                                              x523, x520);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x526, &x527,
                                                              x525, x521, x518);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x528, &x529,
                                                              x527, x519, x516);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x530, &x531,
                                                              x529, x517, x514);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x532, &x533,
                                                              x531, x515, x512);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x534, &x535,
                                                              x533, x513, x510);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x536, &x537,
                                                              x535, x511, x508);
    x538 = (x537 + x509);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x539, &x540, 0x0,
                                                              x491, x522);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x541, &x542,
                                                              x540, x493, x524);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x543, &x544,
                                                              x542, x495, x526);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x545, &x546,
                                                              x544, x497, x528);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x547, &x548,
                                                              x546, x499, x530);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x549, &x550,
                                                              x548, x501, x532);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x551, &x552,
                                                              x550, x503, x534);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x553, &x554,
                                                              x552, x505, x536);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x555, &x556,
                                                              x554, x507, x538);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x557, &x558, x539,
                                                         UINT32_C(0xa3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x559, &x560, x557,
                                                         UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x561, &x562, x557,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x563, &x564, 0x0,
                                                              x539, x561);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x565, &x566,
                                                              x564, x541, x562);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x567, &x568,
                                                              x566, x543, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x569, &x570,
                                                              x568, x545, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x571, &x572,
                                                              x570, x547, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x573, &x574,
                                                              x572, x549, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x575, &x576,
                                                              x574, x551, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x577, &x578,
                                                              x576, x553, x559);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x579, &x580,
                                                              x578, x555, x560);
    x581 = ((uint32_t)x580 + x556);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(
        &x582, &x583, 0x0, x565, UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(&x584, &x585,
                                                               x583, x567, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(&x586, &x587,
                                                               x585, x569, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(&x588, &x589,
                                                               x587, x571, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(&x590, &x591,
                                                               x589, x573, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(&x592, &x593,
                                                               x591, x575, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(&x594, &x595,
                                                               x593, x577, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(
        &x596, &x597, x595, x579, UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(&x598, &x599,
                                                               x597, x581, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(&x600, x599, x582,
                                                            x565);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(&x601, x599, x584,
                                                            x567);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(&x602, x599, x586,
                                                            x569);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(&x603, x599, x588,
                                                            x571);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(&x604, x599, x590,
                                                            x573);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(&x605, x599, x592,
                                                            x575);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(&x606, x599, x594,
                                                            x577);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(&x607, x599, x596,
                                                            x579);
    out1[0] = x600;
    out1[1] = x601;
    out1[2] = x602;
    out1[3] = x603;
    out1[4] = x604;
    out1[5] = x605;
    out1[6] = x606;
    out1[7] = x607;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add adds two field elements in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(
    uint32_t out1[8], const uint32_t arg1[8], const uint32_t arg2[8]) {
    uint32_t x1;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x2;
    uint32_t x3;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x4;
    uint32_t x5;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x6;
    uint32_t x7;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x8;
    uint32_t x9;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x10;
    uint32_t x11;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x12;
    uint32_t x13;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x14;
    uint32_t x15;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x16;
    uint32_t x17;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x18;
    uint32_t x19;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x20;
    uint32_t x21;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x22;
    uint32_t x23;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x24;
    uint32_t x25;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x26;
    uint32_t x27;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x28;
    uint32_t x29;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x30;
    uint32_t x31;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x32;
    uint32_t x33;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x34;
    uint32_t x35;
    uint32_t x36;
    uint32_t x37;
    uint32_t x38;
    uint32_t x39;
    uint32_t x40;
    uint32_t x41;
    uint32_t x42;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(
        &x1, &x2, 0x0, (arg1[0]), (arg2[0]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(
        &x3, &x4, x2, (arg1[1]), (arg2[1]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(
        &x5, &x6, x4, (arg1[2]), (arg2[2]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(
        &x7, &x8, x6, (arg1[3]), (arg2[3]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(
        &x9, &x10, x8, (arg1[4]), (arg2[4]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(
        &x11, &x12, x10, (arg1[5]), (arg2[5]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(
        &x13, &x14, x12, (arg1[6]), (arg2[6]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(
        &x15, &x16, x14, (arg1[7]), (arg2[7]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(
        &x17, &x18, 0x0, x1, UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(&x19, &x20, x18,
                                                               x3, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(&x21, &x22, x20,
                                                               x5, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(&x23, &x24, x22,
                                                               x7, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(&x25, &x26, x24,
                                                               x9, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(&x27, &x28, x26,
                                                               x11, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(&x29, &x30, x28,
                                                               x13, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(
        &x31, &x32, x30, x15, UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(&x33, &x34, x32,
                                                               x16, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(&x35, x34, x17, x1);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(&x36, x34, x19, x3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(&x37, x34, x21, x5);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(&x38, x34, x23, x7);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(&x39, x34, x25, x9);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(&x40, x34, x27,
                                                            x11);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(&x41, x34, x29,
                                                            x13);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(&x42, x34, x31,
                                                            x15);
    out1[0] = x35;
    out1[1] = x36;
    out1[2] = x37;
    out1[3] = x38;
    out1[4] = x39;
    out1[5] = x40;
    out1[6] = x41;
    out1[7] = x42;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub subtracts two field elements in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) - eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(
    uint32_t out1[8], const uint32_t arg1[8], const uint32_t arg2[8]) {
    uint32_t x1;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x2;
    uint32_t x3;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x4;
    uint32_t x5;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x6;
    uint32_t x7;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x8;
    uint32_t x9;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x10;
    uint32_t x11;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x12;
    uint32_t x13;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x14;
    uint32_t x15;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x16;
    uint32_t x17;
    uint32_t x18;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x19;
    uint32_t x20;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x21;
    uint32_t x22;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x23;
    uint32_t x24;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x25;
    uint32_t x26;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x27;
    uint32_t x28;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x29;
    uint32_t x30;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x31;
    uint32_t x32;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x33;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(
        &x1, &x2, 0x0, (arg1[0]), (arg2[0]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(
        &x3, &x4, x2, (arg1[1]), (arg2[1]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(
        &x5, &x6, x4, (arg1[2]), (arg2[2]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(
        &x7, &x8, x6, (arg1[3]), (arg2[3]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(
        &x9, &x10, x8, (arg1[4]), (arg2[4]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(
        &x11, &x12, x10, (arg1[5]), (arg2[5]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(
        &x13, &x14, x12, (arg1[6]), (arg2[6]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(
        &x15, &x16, x14, (arg1[7]), (arg2[7]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(
        &x17, x16, 0x0, UINT32_C(0xffffffff));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(
        &x18, &x19, 0x0, x1, (x17 & UINT16_C(0xc99)));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x20, &x21, x19,
                                                              x3, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x22, &x23, x21,
                                                              x5, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x24, &x25, x23,
                                                              x7, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x26, &x27, x25,
                                                              x9, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x28, &x29, x27,
                                                              x11, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x30, &x31, x29,
                                                              x13, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(
        &x32, &x33, x31, x15, (x17 & UINT32_C(0x80000000)));
    out1[0] = x18;
    out1[1] = x20;
    out1[2] = x22;
    out1[3] = x24;
    out1[4] = x26;
    out1[5] = x28;
    out1[6] = x30;
    out1[7] = x32;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_opp negates a field element in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = -eval (from_montgomery arg1) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_opp(
    uint32_t out1[8], const uint32_t arg1[8]) {
    uint32_t x1;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x2;
    uint32_t x3;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x4;
    uint32_t x5;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x6;
    uint32_t x7;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x8;
    uint32_t x9;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x10;
    uint32_t x11;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x12;
    uint32_t x13;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x14;
    uint32_t x15;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x16;
    uint32_t x17;
    uint32_t x18;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x19;
    uint32_t x20;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x21;
    uint32_t x22;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x23;
    uint32_t x24;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x25;
    uint32_t x26;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x27;
    uint32_t x28;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x29;
    uint32_t x30;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x31;
    uint32_t x32;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x33;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(&x1, &x2, 0x0,
                                                               0x0, (arg1[0]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(&x3, &x4, x2,
                                                               0x0, (arg1[1]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(&x5, &x6, x4,
                                                               0x0, (arg1[2]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(&x7, &x8, x6,
                                                               0x0, (arg1[3]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(&x9, &x10, x8,
                                                               0x0, (arg1[4]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(&x11, &x12, x10,
                                                               0x0, (arg1[5]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(&x13, &x14, x12,
                                                               0x0, (arg1[6]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(&x15, &x16, x14,
                                                               0x0, (arg1[7]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(
        &x17, x16, 0x0, UINT32_C(0xffffffff));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(
        &x18, &x19, 0x0, x1, (x17 & UINT16_C(0xc99)));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x20, &x21, x19,
                                                              x3, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x22, &x23, x21,
                                                              x5, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x24, &x25, x23,
                                                              x7, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x26, &x27, x25,
                                                              x9, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x28, &x29, x27,
                                                              x11, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x30, &x31, x29,
                                                              x13, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(
        &x32, &x33, x31, x15, (x17 & UINT32_C(0x80000000)));
    out1[0] = x18;
    out1[1] = x20;
    out1[2] = x22;
    out1[3] = x24;
    out1[4] = x26;
    out1[5] = x28;
    out1[6] = x30;
    out1[7] = x32;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_from_montgomery translates a field element out of the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval out1 mod m = (eval arg1 * ((2^32)⁻¹ mod m)^8) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_from_montgomery(
    uint32_t out1[8], const uint32_t arg1[8]) {
    uint32_t x1;
    uint32_t x2;
    uint32_t x3;
    uint32_t x4;
    uint32_t x5;
    uint32_t x6;
    uint32_t x7;
    uint32_t x8;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x9;
    uint32_t x10;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x11;
    uint32_t x12;
    uint32_t x13;
    uint32_t x14;
    uint32_t x15;
    uint32_t x16;
    uint32_t x17;
    uint32_t x18;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x19;
    uint32_t x20;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x21;
    uint32_t x22;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x23;
    uint32_t x24;
    uint32_t x25;
    uint32_t x26;
    uint32_t x27;
    uint32_t x28;
    uint32_t x29;
    uint32_t x30;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x31;
    uint32_t x32;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x33;
    uint32_t x34;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x35;
    uint32_t x36;
    uint32_t x37;
    uint32_t x38;
    uint32_t x39;
    uint32_t x40;
    uint32_t x41;
    uint32_t x42;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x43;
    uint32_t x44;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x45;
    uint32_t x46;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x47;
    uint32_t x48;
    uint32_t x49;
    uint32_t x50;
    uint32_t x51;
    uint32_t x52;
    uint32_t x53;
    uint32_t x54;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x55;
    uint32_t x56;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x57;
    uint32_t x58;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x59;
    uint32_t x60;
    uint32_t x61;
    uint32_t x62;
    uint32_t x63;
    uint32_t x64;
    uint32_t x65;
    uint32_t x66;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x67;
    uint32_t x68;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x69;
    uint32_t x70;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x71;
    uint32_t x72;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x73;
    uint32_t x74;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x75;
    uint32_t x76;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x77;
    uint32_t x78;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x79;
    uint32_t x80;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x81;
    uint32_t x82;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x83;
    uint32_t x84;
    uint32_t x85;
    uint32_t x86;
    uint32_t x87;
    uint32_t x88;
    uint32_t x89;
    uint32_t x90;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x91;
    uint32_t x92;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x93;
    uint32_t x94;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x95;
    uint32_t x96;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x97;
    uint32_t x98;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x99;
    uint32_t x100;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x101;
    uint32_t x102;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x103;
    uint32_t x104;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x105;
    uint32_t x106;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x107;
    uint32_t x108;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x109;
    uint32_t x110;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x111;
    uint32_t x112;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x113;
    uint32_t x114;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x115;
    uint32_t x116;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x117;
    uint32_t x118;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x119;
    uint32_t x120;
    uint32_t x121;
    uint32_t x122;
    uint32_t x123;
    uint32_t x124;
    uint32_t x125;
    uint32_t x126;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x127;
    uint32_t x128;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x129;
    uint32_t x130;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x131;
    uint32_t x132;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x133;
    uint32_t x134;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x135;
    uint32_t x136;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x137;
    uint32_t x138;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x139;
    uint32_t x140;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x141;
    uint32_t x142;
    uint32_t x143;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x144;
    uint32_t x145;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x146;
    uint32_t x147;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x148;
    uint32_t x149;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x150;
    uint32_t x151;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x152;
    uint32_t x153;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x154;
    uint32_t x155;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x156;
    uint32_t x157;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x158;
    uint32_t x159;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x160;
    uint32_t x161;
    uint32_t x162;
    uint32_t x163;
    uint32_t x164;
    uint32_t x165;
    uint32_t x166;
    uint32_t x167;
    uint32_t x168;
    x1 = (arg1[0]);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x2, &x3, x1,
                                                         UINT32_C(0xa3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x4, &x5, x2,
                                                         UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x6, &x7, x2,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x8, &x9, 0x0, x1,
                                                              x6);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(
        &x10, &x11, 0x0, (x9 + x7), (arg1[1]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x12, &x13, x10,
                                                         UINT32_C(0xa3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x14, &x15, x12,
                                                         UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x16, &x17, x12,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x18, &x19, 0x0,
                                                              x5, x14);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x20, &x21, 0x0,
                                                              x10, x16);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(
        &x22, &x23, 0x0, (((uint32_t)x21 + x11) + x17), (arg1[2]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x24, &x25, x22,
                                                         UINT32_C(0xa3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x26, &x27, x24,
                                                         UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x28, &x29, x24,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x30, &x31, 0x0,
                                                              (x19 + x15), x26);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x32, &x33, 0x0,
                                                              x22, x28);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(
        &x34, &x35, 0x0, (((uint32_t)x33 + x23) + x29), (arg1[3]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x36, &x37, x34,
                                                         UINT32_C(0xa3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x38, &x39, x36,
                                                         UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x40, &x41, x36,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x42, &x43, 0x0,
                                                              (x31 + x27), x38);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x44, &x45, 0x0,
                                                              x34, x40);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(
        &x46, &x47, 0x0, (((uint32_t)x45 + x35) + x41), (arg1[4]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x48, &x49, x46,
                                                         UINT32_C(0xa3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x50, &x51, x48,
                                                         UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x52, &x53, x48,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x54, &x55, 0x0,
                                                              (x43 + x39), x50);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x56, &x57, 0x0,
                                                              x46, x52);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(
        &x58, &x59, 0x0, (((uint32_t)x57 + x47) + x53), (arg1[5]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x60, &x61, x58,
                                                         UINT32_C(0xa3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x62, &x63, x60,
                                                         UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x64, &x65, x60,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x66, &x67, 0x0,
                                                              (x55 + x51), x62);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x68, &x69, 0x0,
                                                              x58, x64);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(
        &x70, &x71, 0x0, (((uint32_t)x69 + x59) + x65), (arg1[6]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x72, &x73, x71,
                                                              x4, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x74, &x75, x73,
                                                              x18, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x76, &x77, x75,
                                                              x30, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x78, &x79, x77,
                                                              x42, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x80, &x81, x79,
                                                              x54, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x82, &x83, x81,
                                                              x66, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x84, &x85, x70,
                                                         UINT32_C(0xa3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x86, &x87, x84,
                                                         UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x88, &x89, x84,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x90, &x91, 0x0,
                                                              x70, x88);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x92, &x93, x91,
                                                              x72, x89);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x94, &x95, x93,
                                                              x74, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x96, &x97, x95,
                                                              x76, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x98, &x99, x97,
                                                              x78, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x100, &x101, x99,
                                                              x80, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x102, &x103,
                                                              x101, x82, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(
        &x104, &x105, x103, (x83 + (x67 + x63)), x86);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x106, &x107, 0x0,
                                                              x92, (arg1[7]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x108, &x109,
                                                              x107, x94, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x110, &x111,
                                                              x109, x96, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x112, &x113,
                                                              x111, x98, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x114, &x115,
                                                              x113, x100, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x116, &x117,
                                                              x115, x102, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x118, &x119,
                                                              x117, x104, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x120, &x121, x106,
                                                         UINT32_C(0xa3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x122, &x123, x120,
                                                         UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x124, &x125, x120,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x126, &x127, 0x0,
                                                              x106, x124);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x128, &x129,
                                                              x127, x108, x125);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x130, &x131,
                                                              x129, x110, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x132, &x133,
                                                              x131, x112, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x134, &x135,
                                                              x133, x114, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x136, &x137,
                                                              x135, x116, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x138, &x139,
                                                              x137, x118, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(
        &x140, &x141, x139, (x119 + (x105 + x87)), x122);
    x142 = (x141 + x123);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(
        &x143, &x144, 0x0, x128, UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(&x145, &x146,
                                                               x144, x130, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(&x147, &x148,
                                                               x146, x132, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(&x149, &x150,
                                                               x148, x134, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(&x151, &x152,
                                                               x150, x136, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(&x153, &x154,
                                                               x152, x138, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(&x155, &x156,
                                                               x154, x140, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(
        &x157, &x158, x156, x142, UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(&x159, &x160,
                                                               x158, 0x0, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(&x161, x160, x143,
                                                            x128);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(&x162, x160, x145,
                                                            x130);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(&x163, x160, x147,
                                                            x132);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(&x164, x160, x149,
                                                            x134);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(&x165, x160, x151,
                                                            x136);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(&x166, x160, x153,
                                                            x138);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(&x167, x160, x155,
                                                            x140);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(&x168, x160, x157,
                                                            x142);
    out1[0] = x161;
    out1[1] = x162;
    out1[2] = x163;
    out1[3] = x164;
    out1[4] = x165;
    out1[5] = x166;
    out1[6] = x167;
    out1[7] = x168;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_to_montgomery translates a field element into the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = eval arg1 mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_to_montgomery(
    uint32_t out1[8], const uint32_t arg1[8]) {
    uint32_t x1;
    uint32_t x2;
    uint32_t x3;
    uint32_t x4;
    uint32_t x5;
    uint32_t x6;
    uint32_t x7;
    uint32_t x8;
    uint32_t x9;
    uint32_t x10;
    uint32_t x11;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x12;
    uint32_t x13;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x14;
    uint32_t x15;
    uint32_t x16;
    uint32_t x17;
    uint32_t x18;
    uint32_t x19;
    uint32_t x20;
    uint32_t x21;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x22;
    uint32_t x23;
    uint32_t x24;
    uint32_t x25;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x26;
    uint32_t x27;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x28;
    uint32_t x29;
    uint32_t x30;
    uint32_t x31;
    uint32_t x32;
    uint32_t x33;
    uint32_t x34;
    uint32_t x35;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x36;
    uint32_t x37;
    uint32_t x38;
    uint32_t x39;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x40;
    uint32_t x41;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x42;
    uint32_t x43;
    uint32_t x44;
    uint32_t x45;
    uint32_t x46;
    uint32_t x47;
    uint32_t x48;
    uint32_t x49;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x50;
    uint32_t x51;
    uint32_t x52;
    uint32_t x53;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x54;
    uint32_t x55;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x56;
    uint32_t x57;
    uint32_t x58;
    uint32_t x59;
    uint32_t x60;
    uint32_t x61;
    uint32_t x62;
    uint32_t x63;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x64;
    uint32_t x65;
    uint32_t x66;
    uint32_t x67;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x68;
    uint32_t x69;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x70;
    uint32_t x71;
    uint32_t x72;
    uint32_t x73;
    uint32_t x74;
    uint32_t x75;
    uint32_t x76;
    uint32_t x77;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x78;
    uint32_t x79;
    uint32_t x80;
    uint32_t x81;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x82;
    uint32_t x83;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x84;
    uint32_t x85;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x86;
    uint32_t x87;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x88;
    uint32_t x89;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x90;
    uint32_t x91;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x92;
    uint32_t x93;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x94;
    uint32_t x95;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x96;
    uint32_t x97;
    uint32_t x98;
    uint32_t x99;
    uint32_t x100;
    uint32_t x101;
    uint32_t x102;
    uint32_t x103;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x104;
    uint32_t x105;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x106;
    uint32_t x107;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x108;
    uint32_t x109;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x110;
    uint32_t x111;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x112;
    uint32_t x113;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x114;
    uint32_t x115;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x116;
    uint32_t x117;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x118;
    uint32_t x119;
    uint32_t x120;
    uint32_t x121;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x122;
    uint32_t x123;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x124;
    uint32_t x125;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x126;
    uint32_t x127;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x128;
    uint32_t x129;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x130;
    uint32_t x131;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x132;
    uint32_t x133;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x134;
    uint32_t x135;
    uint32_t x136;
    uint32_t x137;
    uint32_t x138;
    uint32_t x139;
    uint32_t x140;
    uint32_t x141;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x142;
    uint32_t x143;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x144;
    uint32_t x145;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x146;
    uint32_t x147;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x148;
    uint32_t x149;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x150;
    uint32_t x151;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x152;
    uint32_t x153;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x154;
    uint32_t x155;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x156;
    uint32_t x157;
    uint32_t x158;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x159;
    uint32_t x160;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x161;
    uint32_t x162;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x163;
    uint32_t x164;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x165;
    uint32_t x166;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x167;
    uint32_t x168;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x169;
    uint32_t x170;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x171;
    uint32_t x172;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x173;
    uint32_t x174;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 x175;
    uint32_t x176;
    uint32_t x177;
    uint32_t x178;
    uint32_t x179;
    uint32_t x180;
    uint32_t x181;
    uint32_t x182;
    uint32_t x183;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x1, &x2, (arg1[0]),
                                                         UINT32_C(0x27acdc4));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x3, &x4, x1,
                                                         UINT32_C(0xa3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x5, &x6, x3,
                                                         UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x7, &x8, x3,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x9, &x10, (arg1[1]),
                                                         UINT32_C(0x27acdc4));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x11, &x12, 0x0,
                                                              x1, x7);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(
        &x13, &x14, 0x0, ((x12 + x2) + x8), x9);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x15, &x16, x13,
                                                         UINT32_C(0xa3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x17, &x18, x15,
                                                         UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x19, &x20, x15,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x21, &x22, 0x0,
                                                              x6, x17);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x23, &x24, (arg1[2]),
                                                         UINT32_C(0x27acdc4));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x25, &x26, 0x0,
                                                              x13, x19);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(
        &x27, &x28, 0x0, ((x26 + (x14 + x10)) + x20), x23);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x29, &x30, x27,
                                                         UINT32_C(0xa3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x31, &x32, x29,
                                                         UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x33, &x34, x29,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x35, &x36, 0x0,
                                                              (x22 + x18), x31);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x37, &x38, (arg1[3]),
                                                         UINT32_C(0x27acdc4));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x39, &x40, 0x0,
                                                              x27, x33);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(
        &x41, &x42, 0x0, ((x40 + (x28 + x24)) + x34), x37);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x43, &x44, x41,
                                                         UINT32_C(0xa3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x45, &x46, x43,
                                                         UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x47, &x48, x43,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x49, &x50, 0x0,
                                                              (x36 + x32), x45);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x51, &x52, (arg1[4]),
                                                         UINT32_C(0x27acdc4));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x53, &x54, 0x0,
                                                              x41, x47);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(
        &x55, &x56, 0x0, ((x54 + (x42 + x38)) + x48), x51);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x57, &x58, x55,
                                                         UINT32_C(0xa3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x59, &x60, x57,
                                                         UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x61, &x62, x57,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x63, &x64, 0x0,
                                                              (x50 + x46), x59);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x65, &x66, (arg1[5]),
                                                         UINT32_C(0x27acdc4));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x67, &x68, 0x0,
                                                              x55, x61);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(
        &x69, &x70, 0x0, ((x68 + (x56 + x52)) + x62), x65);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x71, &x72, x69,
                                                         UINT32_C(0xa3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x73, &x74, x71,
                                                         UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x75, &x76, x71,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x77, &x78, 0x0,
                                                              (x64 + x60), x73);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x79, &x80, (arg1[6]),
                                                         UINT32_C(0x27acdc4));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x81, &x82, 0x0,
                                                              x69, x75);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(
        &x83, &x84, 0x0, ((x82 + (x70 + x66)) + x76), x79);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x85, &x86, x84,
                                                              x5, x80);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x87, &x88, x86,
                                                              x21, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x89, &x90, x88,
                                                              x35, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x91, &x92, x90,
                                                              x49, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x93, &x94, x92,
                                                              x63, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x95, &x96, x94,
                                                              x77, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x97, &x98, x83,
                                                         UINT32_C(0xa3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x99, &x100, x97,
                                                         UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x101, &x102, x97,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x103, &x104, 0x0,
                                                              x83, x101);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x105, &x106,
                                                              x104, x85, x102);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x107, &x108,
                                                              x106, x87, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x109, &x110,
                                                              x108, x89, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x111, &x112,
                                                              x110, x91, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x113, &x114,
                                                              x112, x93, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x115, &x116,
                                                              x114, x95, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(
        &x117, &x118, x116, (x96 + (x78 + x74)), x99);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(
        &x119, &x120, (arg1[7]), UINT32_C(0x27acdc4));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x121, &x122, 0x0,
                                                              x105, x119);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x123, &x124,
                                                              x122, x107, x120);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x125, &x126,
                                                              x124, x109, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x127, &x128,
                                                              x126, x111, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x129, &x130,
                                                              x128, x113, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x131, &x132,
                                                              x130, x115, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x133, &x134,
                                                              x132, x117, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x135, &x136, x121,
                                                         UINT32_C(0xa3347857));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x137, &x138, x135,
                                                         UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mulx_u32(&x139, &x140, x135,
                                                         UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x141, &x142, 0x0,
                                                              x121, x139);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x143, &x144,
                                                              x142, x123, x140);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x145, &x146,
                                                              x144, x125, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x147, &x148,
                                                              x146, x127, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x149, &x150,
                                                              x148, x129, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x151, &x152,
                                                              x150, x131, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(&x153, &x154,
                                                              x152, x133, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_addcarryx_u32(
        &x155, &x156, x154, (x134 + (x118 + x100)), x137);
    x157 = (x156 + x138);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(
        &x158, &x159, 0x0, x143, UINT16_C(0xc99));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(&x160, &x161,
                                                               x159, x145, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(&x162, &x163,
                                                               x161, x147, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(&x164, &x165,
                                                               x163, x149, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(&x166, &x167,
                                                               x165, x151, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(&x168, &x169,
                                                               x167, x153, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(&x170, &x171,
                                                               x169, x155, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(
        &x172, &x173, x171, x157, UINT32_C(0x80000000));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_subborrowx_u32(&x174, &x175,
                                                               x173, 0x0, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(&x176, x175, x158,
                                                            x143);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(&x177, x175, x160,
                                                            x145);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(&x178, x175, x162,
                                                            x147);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(&x179, x175, x164,
                                                            x149);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(&x180, x175, x166,
                                                            x151);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(&x181, x175, x168,
                                                            x153);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(&x182, x175, x170,
                                                            x155);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(&x183, x175, x172,
                                                            x157);
    out1[0] = x176;
    out1[1] = x177;
    out1[2] = x178;
    out1[3] = x179;
    out1[4] = x180;
    out1[5] = x181;
    out1[6] = x182;
    out1[7] = x183;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_nonzero outputs a single non-zero word if the input is non-zero and zero otherwise.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   out1 = 0 ↔ eval (from_montgomery arg1) mod m = 0
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 */
static void fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_nonzero(
    uint32_t *out1, const uint32_t arg1[8]) {
    uint32_t x1;
    x1 =
        ((arg1[0]) |
         ((arg1[1]) |
          ((arg1[2]) |
           ((arg1[3]) | ((arg1[4]) | ((arg1[5]) | ((arg1[6]) | (arg1[7]))))))));
    *out1 = x1;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_selectznz is a multi-limb conditional select.
 * Postconditions:
 *   eval out1 = (if arg1 = 0 then eval arg2 else eval arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   arg3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_selectznz(
    uint32_t out1[8], fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_uint1 arg1,
    const uint32_t arg2[8], const uint32_t arg3[8]) {
    uint32_t x1;
    uint32_t x2;
    uint32_t x3;
    uint32_t x4;
    uint32_t x5;
    uint32_t x6;
    uint32_t x7;
    uint32_t x8;
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(
        &x1, arg1, (arg2[0]), (arg3[0]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(
        &x2, arg1, (arg2[1]), (arg3[1]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(
        &x3, arg1, (arg2[2]), (arg3[2]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(
        &x4, arg1, (arg2[3]), (arg3[3]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(
        &x5, arg1, (arg2[4]), (arg3[4]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(
        &x6, arg1, (arg2[5]), (arg3[5]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(
        &x7, arg1, (arg2[6]), (arg3[6]));
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_cmovznz_u32(
        &x8, arg1, (arg2[7]), (arg3[7]));
    out1[0] = x1;
    out1[1] = x2;
    out1[2] = x3;
    out1[3] = x4;
    out1[4] = x5;
    out1[5] = x6;
    out1[6] = x7;
    out1[7] = x8;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_to_bytes serializes a field element NOT in the Montgomery domain to bytes in little-endian order.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..31]
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
 */
static void fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_to_bytes(
    uint8_t out1[32], const uint32_t arg1[8]) {
    uint32_t x1;
    uint32_t x2;
    uint32_t x3;
    uint32_t x4;
    uint32_t x5;
    uint32_t x6;
    uint32_t x7;
    uint32_t x8;
    uint8_t x9;
    uint32_t x10;
    uint8_t x11;
    uint32_t x12;
    uint8_t x13;
    uint8_t x14;
    uint8_t x15;
    uint32_t x16;
    uint8_t x17;
    uint32_t x18;
    uint8_t x19;
    uint8_t x20;
    uint8_t x21;
    uint32_t x22;
    uint8_t x23;
    uint32_t x24;
    uint8_t x25;
    uint8_t x26;
    uint8_t x27;
    uint32_t x28;
    uint8_t x29;
    uint32_t x30;
    uint8_t x31;
    uint8_t x32;
    uint8_t x33;
    uint32_t x34;
    uint8_t x35;
    uint32_t x36;
    uint8_t x37;
    uint8_t x38;
    uint8_t x39;
    uint32_t x40;
    uint8_t x41;
    uint32_t x42;
    uint8_t x43;
    uint8_t x44;
    uint8_t x45;
    uint32_t x46;
    uint8_t x47;
    uint32_t x48;
    uint8_t x49;
    uint8_t x50;
    uint8_t x51;
    uint32_t x52;
    uint8_t x53;
    uint32_t x54;
    uint8_t x55;
    uint8_t x56;
    x1 = (arg1[7]);
    x2 = (arg1[6]);
    x3 = (arg1[5]);
    x4 = (arg1[4]);
    x5 = (arg1[3]);
    x6 = (arg1[2]);
    x7 = (arg1[1]);
    x8 = (arg1[0]);
    x9 = (uint8_t)(x8 & UINT8_C(0xff));
    x10 = (x8 >> 8);
    x11 = (uint8_t)(x10 & UINT8_C(0xff));
    x12 = (x10 >> 8);
    x13 = (uint8_t)(x12 & UINT8_C(0xff));
    x14 = (uint8_t)(x12 >> 8);
    x15 = (uint8_t)(x7 & UINT8_C(0xff));
    x16 = (x7 >> 8);
    x17 = (uint8_t)(x16 & UINT8_C(0xff));
    x18 = (x16 >> 8);
    x19 = (uint8_t)(x18 & UINT8_C(0xff));
    x20 = (uint8_t)(x18 >> 8);
    x21 = (uint8_t)(x6 & UINT8_C(0xff));
    x22 = (x6 >> 8);
    x23 = (uint8_t)(x22 & UINT8_C(0xff));
    x24 = (x22 >> 8);
    x25 = (uint8_t)(x24 & UINT8_C(0xff));
    x26 = (uint8_t)(x24 >> 8);
    x27 = (uint8_t)(x5 & UINT8_C(0xff));
    x28 = (x5 >> 8);
    x29 = (uint8_t)(x28 & UINT8_C(0xff));
    x30 = (x28 >> 8);
    x31 = (uint8_t)(x30 & UINT8_C(0xff));
    x32 = (uint8_t)(x30 >> 8);
    x33 = (uint8_t)(x4 & UINT8_C(0xff));
    x34 = (x4 >> 8);
    x35 = (uint8_t)(x34 & UINT8_C(0xff));
    x36 = (x34 >> 8);
    x37 = (uint8_t)(x36 & UINT8_C(0xff));
    x38 = (uint8_t)(x36 >> 8);
    x39 = (uint8_t)(x3 & UINT8_C(0xff));
    x40 = (x3 >> 8);
    x41 = (uint8_t)(x40 & UINT8_C(0xff));
    x42 = (x40 >> 8);
    x43 = (uint8_t)(x42 & UINT8_C(0xff));
    x44 = (uint8_t)(x42 >> 8);
    x45 = (uint8_t)(x2 & UINT8_C(0xff));
    x46 = (x2 >> 8);
    x47 = (uint8_t)(x46 & UINT8_C(0xff));
    x48 = (x46 >> 8);
    x49 = (uint8_t)(x48 & UINT8_C(0xff));
    x50 = (uint8_t)(x48 >> 8);
    x51 = (uint8_t)(x1 & UINT8_C(0xff));
    x52 = (x1 >> 8);
    x53 = (uint8_t)(x52 & UINT8_C(0xff));
    x54 = (x52 >> 8);
    x55 = (uint8_t)(x54 & UINT8_C(0xff));
    x56 = (uint8_t)(x54 >> 8);
    out1[0] = x9;
    out1[1] = x11;
    out1[2] = x13;
    out1[3] = x14;
    out1[4] = x15;
    out1[5] = x17;
    out1[6] = x19;
    out1[7] = x20;
    out1[8] = x21;
    out1[9] = x23;
    out1[10] = x25;
    out1[11] = x26;
    out1[12] = x27;
    out1[13] = x29;
    out1[14] = x31;
    out1[15] = x32;
    out1[16] = x33;
    out1[17] = x35;
    out1[18] = x37;
    out1[19] = x38;
    out1[20] = x39;
    out1[21] = x41;
    out1[22] = x43;
    out1[23] = x44;
    out1[24] = x45;
    out1[25] = x47;
    out1[26] = x49;
    out1[27] = x50;
    out1[28] = x51;
    out1[29] = x53;
    out1[30] = x55;
    out1[31] = x56;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_from_bytes deserializes a field element NOT in the Montgomery domain from bytes in little-endian order.
 * Preconditions:
 *   0 ≤ bytes_eval arg1 < m
 * Postconditions:
 *   eval out1 mod m = bytes_eval arg1 mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_from_bytes(
    uint32_t out1[8], const uint8_t arg1[32]) {
    uint32_t x1;
    uint32_t x2;
    uint32_t x3;
    uint8_t x4;
    uint32_t x5;
    uint32_t x6;
    uint32_t x7;
    uint8_t x8;
    uint32_t x9;
    uint32_t x10;
    uint32_t x11;
    uint8_t x12;
    uint32_t x13;
    uint32_t x14;
    uint32_t x15;
    uint8_t x16;
    uint32_t x17;
    uint32_t x18;
    uint32_t x19;
    uint8_t x20;
    uint32_t x21;
    uint32_t x22;
    uint32_t x23;
    uint8_t x24;
    uint32_t x25;
    uint32_t x26;
    uint32_t x27;
    uint8_t x28;
    uint32_t x29;
    uint32_t x30;
    uint32_t x31;
    uint8_t x32;
    uint32_t x33;
    uint32_t x34;
    uint32_t x35;
    uint32_t x36;
    uint32_t x37;
    uint32_t x38;
    uint32_t x39;
    uint32_t x40;
    uint32_t x41;
    uint32_t x42;
    uint32_t x43;
    uint32_t x44;
    uint32_t x45;
    uint32_t x46;
    uint32_t x47;
    uint32_t x48;
    uint32_t x49;
    uint32_t x50;
    uint32_t x51;
    uint32_t x52;
    uint32_t x53;
    uint32_t x54;
    uint32_t x55;
    uint32_t x56;
    x1 = ((uint32_t)(arg1[31]) << 24);
    x2 = ((uint32_t)(arg1[30]) << 16);
    x3 = ((uint32_t)(arg1[29]) << 8);
    x4 = (arg1[28]);
    x5 = ((uint32_t)(arg1[27]) << 24);
    x6 = ((uint32_t)(arg1[26]) << 16);
    x7 = ((uint32_t)(arg1[25]) << 8);
    x8 = (arg1[24]);
    x9 = ((uint32_t)(arg1[23]) << 24);
    x10 = ((uint32_t)(arg1[22]) << 16);
    x11 = ((uint32_t)(arg1[21]) << 8);
    x12 = (arg1[20]);
    x13 = ((uint32_t)(arg1[19]) << 24);
    x14 = ((uint32_t)(arg1[18]) << 16);
    x15 = ((uint32_t)(arg1[17]) << 8);
    x16 = (arg1[16]);
    x17 = ((uint32_t)(arg1[15]) << 24);
    x18 = ((uint32_t)(arg1[14]) << 16);
    x19 = ((uint32_t)(arg1[13]) << 8);
    x20 = (arg1[12]);
    x21 = ((uint32_t)(arg1[11]) << 24);
    x22 = ((uint32_t)(arg1[10]) << 16);
    x23 = ((uint32_t)(arg1[9]) << 8);
    x24 = (arg1[8]);
    x25 = ((uint32_t)(arg1[7]) << 24);
    x26 = ((uint32_t)(arg1[6]) << 16);
    x27 = ((uint32_t)(arg1[5]) << 8);
    x28 = (arg1[4]);
    x29 = ((uint32_t)(arg1[3]) << 24);
    x30 = ((uint32_t)(arg1[2]) << 16);
    x31 = ((uint32_t)(arg1[1]) << 8);
    x32 = (arg1[0]);
    x33 = (x31 + (uint32_t)x32);
    x34 = (x30 + x33);
    x35 = (x29 + x34);
    x36 = (x27 + (uint32_t)x28);
    x37 = (x26 + x36);
    x38 = (x25 + x37);
    x39 = (x23 + (uint32_t)x24);
    x40 = (x22 + x39);
    x41 = (x21 + x40);
    x42 = (x19 + (uint32_t)x20);
    x43 = (x18 + x42);
    x44 = (x17 + x43);
    x45 = (x15 + (uint32_t)x16);
    x46 = (x14 + x45);
    x47 = (x13 + x46);
    x48 = (x11 + (uint32_t)x12);
    x49 = (x10 + x48);
    x50 = (x9 + x49);
    x51 = (x7 + (uint32_t)x8);
    x52 = (x6 + x51);
    x53 = (x5 + x52);
    x54 = (x3 + (uint32_t)x4);
    x55 = (x2 + x54);
    x56 = (x1 + x55);
    out1[0] = x35;
    out1[1] = x38;
    out1[2] = x41;
    out1[3] = x44;
    out1[4] = x47;
    out1[5] = x50;
    out1[6] = x53;
    out1[7] = x56;
}

/* END verbatim fiat code */

/*-
 * Finite field inversion via FLT.
 * NB: this is not a real Fiat function, just named that way for consistency.
 * Autogenerated: ecp/id_GostR3410_2001_CryptoPro_B_ParamSet/fe_inv.op3
 * sliding window w=5
 */
static void fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_inv(fe_t output,
                                                            const fe_t t1) {
    int i;
    /* temporary variables */
    fe_t acc, t23, t25;

    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_square(acc, t1);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t25, t1, acc);
    for (i = 0; i < 9; i++)
        fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t25, t25, acc);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t23, t25, acc);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t25, t23, acc);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_square(acc, t1);
    for (i = 0; i < 247; i++)
        fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(acc, acc, t25);
    for (i = 0; i < 7; i++)
        fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(output, acc, t23);
}

/* curve coefficient constants */

static const limb_t const_one[8] = {UINT32_C(0xFFFFF367), UINT32_C(0xFFFFFFFF),
                                    UINT32_C(0xFFFFFFFF), UINT32_C(0xFFFFFFFF),
                                    UINT32_C(0xFFFFFFFF), UINT32_C(0xFFFFFFFF),
                                    UINT32_C(0xFFFFFFFF), UINT32_C(0x7FFFFFFF)};

static const limb_t const_b[8] = {UINT32_C(0xA9C5A084), UINT32_C(0x8DCC455A),
                                  UINT32_C(0x6CF438A8), UINT32_C(0x91AB42DF),
                                  UINT32_C(0xEEAC7D11), UINT32_C(0x8F8AA907),
                                  UINT32_C(0xF6285375), UINT32_C(0x3CE5D221)};

/* LUT for scalar multiplication by comb interleaving */
static const pt_aff_t lut_cmb[27][16] = {
    {
        {{UINT32_C(0xFFFFF367), UINT32_C(0xFFFFFFFF), UINT32_C(0xFFFFFFFF),
          UINT32_C(0xFFFFFFFF), UINT32_C(0xFFFFFFFF), UINT32_C(0xFFFFFFFF),
          UINT32_C(0xFFFFFFFF), UINT32_C(0x7FFFFFFF)},
         {UINT32_C(0x570C7410), UINT32_C(0xDDDC64B3), UINT32_C(0x13172887),
          UINT32_C(0xA7B09925), UINT32_C(0x4B6382DB), UINT32_C(0x0C4E5C4C),
          UINT32_C(0x124768DE), UINT32_C(0x2763DB0F)}},
        {{UINT32_C(0x8457D15D), UINT32_C(0xCD3E57B6), UINT32_C(0xBEA56E83),
          UINT32_C(0xEB688F7F), UINT32_C(0x6A13C5CE), UINT32_C(0x235A123C),
          UINT32_C(0x50F57A6D), UINT32_C(0x0CD7EB9D)},
         {UINT32_C(0x544C1965), UINT32_C(0xC0124E91), UINT32_C(0x62AFA35E),
          UINT32_C(0x4D9C1729), UINT32_C(0x0037C554), UINT32_C(0x0F92F2C3),
          UINT32_C(0x0A3F2665), UINT32_C(0x1D899868)}},
        {{UINT32_C(0x55F43EFF), UINT32_C(0x9DE4B213), UINT32_C(0x5C9E63F5),
          UINT32_C(0x2E110A42), UINT32_C(0x1CE5A6DF), UINT32_C(0x9350A9C3),
          UINT32_C(0xA332315E), UINT32_C(0x377CBF0B)},
         {UINT32_C(0x20F0D1B5), UINT32_C(0x2805DD48), UINT32_C(0x0F9723E5),
          UINT32_C(0x3B197566), UINT32_C(0x84B79937), UINT32_C(0xA1CCA78C),
          UINT32_C(0x94D5E03D), UINT32_C(0x4F87BB1B)}},
        {{UINT32_C(0x5652C96F), UINT32_C(0xE428FBFB), UINT32_C(0xD261BDD1),
          UINT32_C(0x2E9A14D2), UINT32_C(0x7453B76A), UINT32_C(0x082D8296),
          UINT32_C(0x7AC87B02), UINT32_C(0x61EA580E)},
         {UINT32_C(0xCF368FDB), UINT32_C(0xA0F8C2BA), UINT32_C(0xD73B2A28),
          UINT32_C(0xDF093380), UINT32_C(0xEA8FE5D2), UINT32_C(0xFA0928B2),
          UINT32_C(0x5F86D38A), UINT32_C(0x77A67492)}},
        {{UINT32_C(0x27670451), UINT32_C(0xDFFAB410), UINT32_C(0x1200AD3A),
          UINT32_C(0xEBC3D017), UINT32_C(0x25F4F6C4), UINT32_C(0xF68324F3),
          UINT32_C(0x7D0EAFD0), UINT32_C(0x4A24CD5F)},
         {UINT32_C(0xD3F6BD1C), UINT32_C(0xF8FBD489), UINT32_C(0x67B473DE),
          UINT32_C(0x0F6B56D5), UINT32_C(0xCACF0D6B), UINT32_C(0x6FB063DE),
          UINT32_C(0x96DC574B), UINT32_C(0x27F2E7E9)}},
        {{UINT32_C(0x93937228), UINT32_C(0xA6A10645), UINT32_C(0xA9165BBB),
          UINT32_C(0xAB7550B4), UINT32_C(0xCB0EDBE8), UINT32_C(0xD682D4F1),
          UINT32_C(0x40E5AD8D), UINT32_C(0x2261FCEC)},
         {UINT32_C(0xCCBD4E18), UINT32_C(0x9F2119C6), UINT32_C(0xAAB09697),
          UINT32_C(0x2FD094E9), UINT32_C(0xE700929E), UINT32_C(0x00331713),
          UINT32_C(0x54338FE1), UINT32_C(0x6C5F2EFE)}},
        {{UINT32_C(0x42FFF78A), UINT32_C(0xD6314017), UINT32_C(0x2087E055),
          UINT32_C(0x38F23A91), UINT32_C(0x10EF1CAC), UINT32_C(0xE30E809C),
          UINT32_C(0x2432FF74), UINT32_C(0x3BCB0A54)},
         {UINT32_C(0xB31509E6), UINT32_C(0x2B4B5B97), UINT32_C(0x3E54AF47),
          UINT32_C(0x117FE9D7), UINT32_C(0x52F63ACA), UINT32_C(0xE513C0BE),
          UINT32_C(0xB1C80A6B), UINT32_C(0x41ED8ADA)}},
        {{UINT32_C(0xE0A79FCD), UINT32_C(0x61A31837), UINT32_C(0x51D3DE38),
          UINT32_C(0x8F742B57), UINT32_C(0x41354B55), UINT32_C(0x10635FCD),
          UINT32_C(0x946510BE), UINT32_C(0x61F30C61)},
         {UINT32_C(0x6C416DAC), UINT32_C(0x9183D677), UINT32_C(0x345431CB),
          UINT32_C(0x391B7B42), UINT32_C(0x7C254A8D), UINT32_C(0xE3D6F084),
          UINT32_C(0x19D320D8), UINT32_C(0x777E1F62)}},
        {{UINT32_C(0xF05BD85D), UINT32_C(0x090E633F), UINT32_C(0x240392ED),
          UINT32_C(0x546C41A0), UINT32_C(0x9F4139CA), UINT32_C(0x6BBCF15D),
          UINT32_C(0x7FFDA5DA), UINT32_C(0x73F5B657)},
         {UINT32_C(0xE0622A57), UINT32_C(0xBC04E353), UINT32_C(0x6E6414F4),
          UINT32_C(0xCBD8F01E), UINT32_C(0x8C3C0CC5), UINT32_C(0x53377C0B),
          UINT32_C(0xE0A14548), UINT32_C(0x6D302331)}},
        {{UINT32_C(0x3D6D456E), UINT32_C(0x235487F8), UINT32_C(0xB3FDCDCF),
          UINT32_C(0xBD92203D), UINT32_C(0xCFFDA977), UINT32_C(0x15B13D60),
          UINT32_C(0x31A1C4B5), UINT32_C(0x22DCB487)},
         {UINT32_C(0xC76ED9A2), UINT32_C(0xA367FB4E), UINT32_C(0xC0C86AF4),
          UINT32_C(0x1E4F7956), UINT32_C(0x5B012AD7), UINT32_C(0x6F087C49),
          UINT32_C(0x4949B444), UINT32_C(0x33437E4A)}},
        {{UINT32_C(0xB7CDDB38), UINT32_C(0x261B44FE), UINT32_C(0x419216AD),
          UINT32_C(0xDCE2FE47), UINT32_C(0x9428657B), UINT32_C(0xA4CE17FF),
          UINT32_C(0xF8329049), UINT32_C(0x7CE64F48)},
         {UINT32_C(0x7289C114), UINT32_C(0x4CE74211), UINT32_C(0x8C212A23),
          UINT32_C(0x0E622409), UINT32_C(0x2096719D), UINT32_C(0xCF75BF45),
          UINT32_C(0x7BDC1600), UINT32_C(0x6F553581)}},
        {{UINT32_C(0xB941CBC9), UINT32_C(0xE776AA0C), UINT32_C(0x951AAED3),
          UINT32_C(0x16D670E0), UINT32_C(0x4B1EC097), UINT32_C(0x79C019DF),
          UINT32_C(0x12266D30), UINT32_C(0x635A66BB)},
         {UINT32_C(0x023AAFD2), UINT32_C(0x030D843E), UINT32_C(0x6466108F),
          UINT32_C(0x10FB6157), UINT32_C(0x08D568D5), UINT32_C(0x93774BEC),
          UINT32_C(0x04C1EE73), UINT32_C(0x29D27962)}},
        {{UINT32_C(0xE00BBC21), UINT32_C(0x6F0F4C2E), UINT32_C(0xA30AB92F),
          UINT32_C(0x9EB34C58), UINT32_C(0xAE34908B), UINT32_C(0x2153D901),
          UINT32_C(0x4EDC188F), UINT32_C(0x136A7E1F)},
         {UINT32_C(0x8BC45EE4), UINT32_C(0xF709BF5D), UINT32_C(0x4FAD9A54),
          UINT32_C(0xEA6984E4), UINT32_C(0xAF5140EB), UINT32_C(0xFC8E6F8A),
          UINT32_C(0x87756E47), UINT32_C(0x25EBF0DE)}},
        {{UINT32_C(0x5B1D4B9F), UINT32_C(0x5C2A9726), UINT32_C(0x68E93FC7),
          UINT32_C(0xBE235DFD), UINT32_C(0x471A4EA0), UINT32_C(0x7766BDB9),
          UINT32_C(0xD9909CD9), UINT32_C(0x476D17CC)},
         {UINT32_C(0x7B398BC4), UINT32_C(0x4960E5B4), UINT32_C(0x0F58F328),
          UINT32_C(0x909D0F17), UINT32_C(0x230EF508), UINT32_C(0x1ABF7E02),
          UINT32_C(0xD29239C9), UINT32_C(0x6DE6B3E1)}},
        {{UINT32_C(0x85A6DBE3), UINT32_C(0xCCF0AA28), UINT32_C(0x823C606C),
          UINT32_C(0xA5E4B325), UINT32_C(0x15505FC6), UINT32_C(0xADE98B2A),
          UINT32_C(0x02E20C3B), UINT32_C(0x4D4E7703)},
         {UINT32_C(0x4730DF64), UINT32_C(0x24196417), UINT32_C(0xA914A59D),
          UINT32_C(0x3DD47817), UINT32_C(0xC4FDFD97), UINT32_C(0x4D7A317E),
          UINT32_C(0xBE12AA72), UINT32_C(0x3767E545)}},
        {{UINT32_C(0x165C7BF4), UINT32_C(0xA0C2A028), UINT32_C(0x36A0B483),
          UINT32_C(0xCD4DA6EA), UINT32_C(0x3AF53195), UINT32_C(0x1E1E6332),
          UINT32_C(0x8D77188F), UINT32_C(0x7A025E23)},
         {UINT32_C(0x08D2CEF2), UINT32_C(0xB3CF03B9), UINT32_C(0x25A0AFA6),
          UINT32_C(0x8FEE9BB8), UINT32_C(0x88111895), UINT32_C(0x855340E0),
          UINT32_C(0x4FB8F8A3), UINT32_C(0x32E3EF01)}},
    },
    {
        {{UINT32_C(0xEBF87807), UINT32_C(0x33EBE39D), UINT32_C(0xDBDEFF76),
          UINT32_C(0xB048F96C), UINT32_C(0x342A3087), UINT32_C(0xA0496C3C),
          UINT32_C(0x50953679), UINT32_C(0x7623E192)},
         {UINT32_C(0x4B932390), UINT32_C(0x12F76711), UINT32_C(0xACECE2F7),
          UINT32_C(0xF80851EA), UINT32_C(0xE5B280EA), UINT32_C(0xE447465B),
          UINT32_C(0x11115958), UINT32_C(0x0412ADE8)}},
        {{UINT32_C(0xB5EB0DC2), UINT32_C(0x982F1AC8), UINT32_C(0xBBBCC880),
          UINT32_C(0x8464E052), UINT32_C(0x01335D53), UINT32_C(0xC927B596),
          UINT32_C(0x4DA4D80B), UINT32_C(0x4B0C6F5A)},
         {UINT32_C(0xE04783AF), UINT32_C(0x101E1878), UINT32_C(0x41D8A690),
          UINT32_C(0x50458FFC), UINT32_C(0x1B77DFBF), UINT32_C(0x11499D88),
          UINT32_C(0x1F77A937), UINT32_C(0x46DC7D22)}},
        {{UINT32_C(0x620E52C0), UINT32_C(0xE9AD22CE), UINT32_C(0x4140F356),
          UINT32_C(0x0990D6AA), UINT32_C(0x0CBBEEE5), UINT32_C(0x0F6B2EF7),
          UINT32_C(0xEAD414C6), UINT32_C(0x2C67DC80)},
         {UINT32_C(0x23D4CD20), UINT32_C(0xE17182BC), UINT32_C(0xC13DDEA9),
          UINT32_C(0xFC8FE3CB), UINT32_C(0x3BABC06D), UINT32_C(0xD1E4A7B8),
          UINT32_C(0x71C06DB7), UINT32_C(0x52EA05CC)}},
        {{UINT32_C(0x0D022B5B), UINT32_C(0xF8ABB770), UINT32_C(0x199DC689),
          UINT32_C(0x362B8059), UINT32_C(0x26BBDEC8), UINT32_C(0x5D887A4D),
          UINT32_C(0xF7FC2A01), UINT32_C(0x7835F183)},
         {UINT32_C(0xDE99DF34), UINT32_C(0xEEDE12F5), UINT32_C(0xA3082301),
          UINT32_C(0xBE952638), UINT32_C(0x4C35A162), UINT32_C(0x829FDF80),
          UINT32_C(0xC2B9645E), UINT32_C(0x205A2252)}},
        {{UINT32_C(0x1356E14C), UINT32_C(0xDE284DA9), UINT32_C(0xC37415FE),
          UINT32_C(0xE40CEFE0), UINT32_C(0x47F6016E), UINT32_C(0x62BE93E9),
          UINT32_C(0x5DBFE2F6), UINT32_C(0x2DD98904)},
         {UINT32_C(0x2EBC70F9), UINT32_C(0x195B0E98), UINT32_C(0xF01F4D43),
          UINT32_C(0x7E52840D), UINT32_C(0x4B1F6AB4), UINT32_C(0x1AFB1FDF),
          UINT32_C(0x20B3E491), UINT32_C(0x050AABB8)}},
        {{UINT32_C(0xC645DAD4), UINT32_C(0xC59E1EDB), UINT32_C(0x565A286D),
          UINT32_C(0x5AF6B2DC), UINT32_C(0x13076366), UINT32_C(0xC399A48A),
          UINT32_C(0x4AC0E5B9), UINT32_C(0x19F4881F)},
         {UINT32_C(0xCD5AC339), UINT32_C(0xC07D02A1), UINT32_C(0xED628A55),
          UINT32_C(0x18FBD088), UINT32_C(0xFFA4788E), UINT32_C(0x2D33C6F4),
          UINT32_C(0xCCB832E7), UINT32_C(0x52E9AE42)}},
        {{UINT32_C(0x4E5E934E), UINT32_C(0xA47091AE), UINT32_C(0x91CED3C6),
          UINT32_C(0x2542CE13), UINT32_C(0x8FC47857), UINT32_C(0xDDE01FD5),
          UINT32_C(0x4304EAA9), UINT32_C(0x6BA6E569)},
         {UINT32_C(0xE24091A9), UINT32_C(0x2FF0278B), UINT32_C(0x782BBCE0),
          UINT32_C(0xB895F0AB), UINT32_C(0xAB8B8828), UINT32_C(0xA80CCC97),
          UINT32_C(0x68A7D8FE), UINT32_C(0x6A54B961)}},
        {{UINT32_C(0xBAC4581A), UINT32_C(0x15E1F5AD), UINT32_C(0xD4BAA751),
          UINT32_C(0x91620EF0), UINT32_C(0xC7273C4D), UINT32_C(0x4E65731F),
          UINT32_C(0x7EEE33B5), UINT32_C(0x14B166CB)},
         {UINT32_C(0x3CD06080), UINT32_C(0x7B0EFFA5), UINT32_C(0x8CF95FF9),
          UINT32_C(0x4491156A), UINT32_C(0xE2258574), UINT32_C(0xC8C64C39),
          UINT32_C(0x13315CE9), UINT32_C(0x3D48DA9D)}},
        {{UINT32_C(0x99866CE5), UINT32_C(0x97A098A3), UINT32_C(0x023A1167),
          UINT32_C(0xF4CCDB40), UINT32_C(0xF8094782), UINT32_C(0x4BB32981),
          UINT32_C(0xC7D5FD13), UINT32_C(0x7342CC98)},
         {UINT32_C(0x78B99D4E), UINT32_C(0x3C1C5B18), UINT32_C(0xF4762AC9),
          UINT32_C(0x1277668F), UINT32_C(0x6AE50E4F), UINT32_C(0x612431D7),
          UINT32_C(0x36F9071C), UINT32_C(0x36C174E0)}},
        {{UINT32_C(0x9327BA7F), UINT32_C(0x39194E87), UINT32_C(0x7237FA1A),
          UINT32_C(0xC4D251FF), UINT32_C(0x2BA5EB8D), UINT32_C(0x55ED3CD4),
          UINT32_C(0xBA590188), UINT32_C(0x0263AF07)},
         {UINT32_C(0xEFA82CF3), UINT32_C(0xB4853127), UINT32_C(0x2B8E761D),
          UINT32_C(0x2CC2D220), UINT32_C(0x2722B490), UINT32_C(0x4582B81E),
          UINT32_C(0x610AA621), UINT32_C(0x1DA7680A)}},
        {{UINT32_C(0x30D297D4), UINT32_C(0x06A669EE), UINT32_C(0xE133D393),
          UINT32_C(0xC336B048), UINT32_C(0x93B7B41B), UINT32_C(0xB733A2C4),
          UINT32_C(0xC7A8E721), UINT32_C(0x427CC233)},
         {UINT32_C(0x2867BB00), UINT32_C(0x727C14F1), UINT32_C(0xA736035E),
          UINT32_C(0x756F4C7A), UINT32_C(0x26327A22), UINT32_C(0xB72A3EDE),
          UINT32_C(0x77F73F28), UINT32_C(0x4AEDE2BB)}},
        {{UINT32_C(0xA7282ED0), UINT32_C(0xC8A3612F), UINT32_C(0xB0150579),
          UINT32_C(0xE4AD8B40), UINT32_C(0x0C3FEE4B), UINT32_C(0xAB1DE11D),
          UINT32_C(0x33B31F23), UINT32_C(0x613AAD48)},
         {UINT32_C(0x5C91BD21), UINT32_C(0xE74AB856), UINT32_C(0x7953D695),
          UINT32_C(0x49917735), UINT32_C(0x1A53D74F), UINT32_C(0x3831EB60),
          UINT32_C(0x54DEB1A6), UINT32_C(0x245977A0)}},
        {{UINT32_C(0xFFFC1468), UINT32_C(0x15972E4D), UINT32_C(0x141DC24C),
          UINT32_C(0xA758D9CB), UINT32_C(0xED8694C5), UINT32_C(0x5E76FCDF),
          UINT32_C(0x069B7A5E), UINT32_C(0x5F9DAF35)},
         {UINT32_C(0x501B5415), UINT32_C(0xFE50FCE4), UINT32_C(0x58CFDE50),
          UINT32_C(0x6442CF67), UINT32_C(0x38E5F4D0), UINT32_C(0xA89C6DB4),
          UINT32_C(0xF5D4FEFC), UINT32_C(0x21F012DB)}},
        {{UINT32_C(0x98CB9A81), UINT32_C(0x2A1170AD), UINT32_C(0x036C5E45),
          UINT32_C(0x934BD9D5), UINT32_C(0xCA5095B1), UINT32_C(0x27DF152E),
          UINT32_C(0xCCEEE508), UINT32_C(0x682698DB)},
         {UINT32_C(0xB973FB5F), UINT32_C(0x1F4FE3A2), UINT32_C(0x792C7D4D),
          UINT32_C(0xD33CBEBE), UINT32_C(0xE7B33A8F), UINT32_C(0x99D37961),
          UINT32_C(0x7B6D015D), UINT32_C(0x46B8993B)}},
        {{UINT32_C(0x6FBAC8F7), UINT32_C(0x93A3809B), UINT32_C(0x97C55DC4),
          UINT32_C(0x84861BF0), UINT32_C(0x15BB65E3), UINT32_C(0xA6F89EEA),
          UINT32_C(0xA6E531D1), UINT32_C(0x66AE1C5D)},
         {UINT32_C(0xFD83DAEA), UINT32_C(0x643A14FC), UINT32_C(0xC585947B),
          UINT32_C(0xA7A46D0D), UINT32_C(0x4FBA1274), UINT32_C(0xFA20CF07),
          UINT32_C(0x93578A7D), UINT32_C(0x5999ED7B)}},
        {{UINT32_C(0x78E7C6CE), UINT32_C(0x36C8B6ED), UINT32_C(0x5E325F44),
          UINT32_C(0x6D400CA5), UINT32_C(0x20B7AA5C), UINT32_C(0xC6AE09B3),
          UINT32_C(0x89EABC17), UINT32_C(0x1AF261C1)},
         {UINT32_C(0xB9E778E4), UINT32_C(0x64D6FFBB), UINT32_C(0x7FC64BEB),
          UINT32_C(0x1C9E223E), UINT32_C(0x5D75E6C0), UINT32_C(0x4D68B520),
          UINT32_C(0x76677A06), UINT32_C(0x5A72B1D9)}},
    },
    {
        {{UINT32_C(0x6F08BB17), UINT32_C(0x62DB6640), UINT32_C(0xAE75BB73),
          UINT32_C(0xC34F29DF), UINT32_C(0x7DBD4851), UINT32_C(0xD501293D),
          UINT32_C(0xAD1F604B), UINT32_C(0x5EAA94CA)},
         {UINT32_C(0x094408A8), UINT32_C(0x39CFE9D1), UINT32_C(0xE8A476F2),
          UINT32_C(0xC0F6544C), UINT32_C(0xA42D7607), UINT32_C(0x9F6308B6),
          UINT32_C(0xD727018F), UINT32_C(0x17F82949)}},
        {{UINT32_C(0x9C4C4BD2), UINT32_C(0xC44453CD), UINT32_C(0xEBD0B947),
          UINT32_C(0xA895E247), UINT32_C(0xAEBC27F4), UINT32_C(0x0AEB7AFC),
          UINT32_C(0xF04ABFAC), UINT32_C(0x2472FD08)},
         {UINT32_C(0x73E6E994), UINT32_C(0x319EC67D), UINT32_C(0x798C5FC0),
          UINT32_C(0xD6533E4C), UINT32_C(0x3FB9AA89), UINT32_C(0xF4C3B24D),
          UINT32_C(0x0A3B376B), UINT32_C(0x3EC58082)}},
        {{UINT32_C(0x144ACF7A), UINT32_C(0x79732D6F), UINT32_C(0x911342DD),
          UINT32_C(0xFDD630C3), UINT32_C(0x4A630649), UINT32_C(0xC577C4B3),
          UINT32_C(0xBBA999D6), UINT32_C(0x14956A17)},
         {UINT32_C(0xA435A559), UINT32_C(0x523D3CC8), UINT32_C(0xACDA8861),
          UINT32_C(0x488DC690), UINT32_C(0xF051C69A), UINT32_C(0x4CF70928),
          UINT32_C(0x955394CB), UINT32_C(0x2D98D573)}},
        {{UINT32_C(0x23A4B840), UINT32_C(0xEDB7BA2A), UINT32_C(0xF6C2D93B),
          UINT32_C(0x725EC496), UINT32_C(0x8833BB3F), UINT32_C(0x0C94818B),
          UINT32_C(0xB142B12A), UINT32_C(0x51281A31)},
         {UINT32_C(0x659EDA83), UINT32_C(0x2A8A5706), UINT32_C(0x7F9D6877),
          UINT32_C(0x3098F750), UINT32_C(0x2171F69F), UINT32_C(0x87AD0FDF),
          UINT32_C(0x1A6F2F28), UINT32_C(0x6B7067C3)}},
        {{UINT32_C(0x12B1E36F), UINT32_C(0x3B521074), UINT32_C(0xF81E4733),
          UINT32_C(0x727A2432), UINT32_C(0x53F2CBBD), UINT32_C(0xB75A2F35),
          UINT32_C(0x54960EB0), UINT32_C(0x46DE9338)},
         {UINT32_C(0xE561D908), UINT32_C(0xAC5344F8), UINT32_C(0x12C67430),
          UINT32_C(0x4BD40ECB), UINT32_C(0xEF499F97), UINT32_C(0x1698FD62),
          UINT32_C(0x6AE9FBD1), UINT32_C(0x29EBD7AE)}},
        {{UINT32_C(0x1EC8110D), UINT32_C(0x9DEC249B), UINT32_C(0xFD2F5C39),
          UINT32_C(0x2D19053A), UINT32_C(0xE01522DF), UINT32_C(0xB1189807),
          UINT32_C(0xC1424C77), UINT32_C(0x24A04C16)},
         {UINT32_C(0x24F72226), UINT32_C(0xA4FC7C7D), UINT32_C(0xA8322501),
          UINT32_C(0x763405FB), UINT32_C(0x18F015E0), UINT32_C(0xC5443C9A),
          UINT32_C(0xC55D6CEA), UINT32_C(0x6DEDA19B)}},
        {{UINT32_C(0x9EAE2FF9), UINT32_C(0x4EF30976), UINT32_C(0x5741B21B),
          UINT32_C(0x2549B7F2), UINT32_C(0x3BC23F01), UINT32_C(0x859ACD10),
          UINT32_C(0xBF5FB0D7), UINT32_C(0x05C0358F)},
         {UINT32_C(0xFB6AB34C), UINT32_C(0x85E53AA8), UINT32_C(0x8FD2FD20),
          UINT32_C(0x8DAAAA69), UINT32_C(0x16096FC9), UINT32_C(0xBE6D4D34),
          UINT32_C(0xF8B8B831), UINT32_C(0x27572C88)}},
        {{UINT32_C(0x47D56A25), UINT32_C(0xADB98DC5), UINT32_C(0x8B8E1DC6),
          UINT32_C(0x0CC76432), UINT32_C(0xBE48C4A1), UINT32_C(0x032C738E),
          UINT32_C(0x94FC9CF0), UINT32_C(0x31372DAD)},
         {UINT32_C(0x78A7DCB2), UINT32_C(0x8E646A0C), UINT32_C(0x6ECD9885),
          UINT32_C(0xA32F3E9C), UINT32_C(0x6A3AD963), UINT32_C(0x280BB4AD),
          UINT32_C(0x817D4327), UINT32_C(0x7DEE1BC4)}},
        {{UINT32_C(0xF8A7C1E1), UINT32_C(0x1AE6A27B), UINT32_C(0xCBC527C7),
          UINT32_C(0x558C652F), UINT32_C(0xA65056F6), UINT32_C(0x4084B56E),
          UINT32_C(0x6D4C838B), UINT32_C(0x3FD45459)},
         {UINT32_C(0x56DE792A), UINT32_C(0xF5C15AFD), UINT32_C(0x88959282),
          UINT32_C(0xF656FAA4), UINT32_C(0x1C07D63F), UINT32_C(0x7F0D8EF4),
          UINT32_C(0xCD841ACC), UINT32_C(0x44EFFF7D)}},
        {{UINT32_C(0x8D3695D8), UINT32_C(0xAC28F2A6), UINT32_C(0x3F91E781),
          UINT32_C(0x94959EB8), UINT32_C(0xFEDD6E1F), UINT32_C(0x7693FFF7),
          UINT32_C(0xA9A699EF), UINT32_C(0x2512E6E1)},
         {UINT32_C(0x7955FAB7), UINT32_C(0x823400EB), UINT32_C(0x94924C08),
          UINT32_C(0xCF109EF9), UINT32_C(0x3A709F32), UINT32_C(0x12E08779),
          UINT32_C(0x9CC6484C), UINT32_C(0x187D0413)}},
        {{UINT32_C(0xEBDE477F), UINT32_C(0xD3932AFB), UINT32_C(0x44538D8A),
          UINT32_C(0x9D5A5422), UINT32_C(0x166A87AF), UINT32_C(0x40B0B159),
          UINT32_C(0x41D5E078), UINT32_C(0x31294B3D)},
         {UINT32_C(0xE8C48222), UINT32_C(0x6C49C853), UINT32_C(0xDCD0D611),
          UINT32_C(0x8FBE6620), UINT32_C(0xF611007B), UINT32_C(0x9DDC7EE2),
          UINT32_C(0xE6652172), UINT32_C(0x12289A60)}},
        {{UINT32_C(0xDACF80F7), UINT32_C(0x8B85475B), UINT32_C(0x9B5CAEF2),
          UINT32_C(0xADBAB353), UINT32_C(0x8D2A7707), UINT32_C(0x7C4090A3),
          UINT32_C(0xDAB97830), UINT32_C(0x271FA4F1)},
         {UINT32_C(0x53173E04), UINT32_C(0x141B7252), UINT32_C(0x06D0B127),
          UINT32_C(0x4B483D64), UINT32_C(0x063A7AF8), UINT32_C(0x8FD15BCF),
          UINT32_C(0xE580F34C), UINT32_C(0x59B19EAF)}},
        {{UINT32_C(0x9C0D79B6), UINT32_C(0xA7EEA8C4), UINT32_C(0xB9185109),
          UINT32_C(0x766FA113), UINT32_C(0x4642CC64), UINT32_C(0xB42D74F3),
          UINT32_C(0xBB817476), UINT32_C(0x51D0127B)},
         {UINT32_C(0x8AB71448), UINT32_C(0x6DA097F5), UINT32_C(0xF95AD0C7),
          UINT32_C(0x145872E5), UINT32_C(0xF1759436), UINT32_C(0xB7E934F3),
          UINT32_C(0x3160ED1F), UINT32_C(0x4EA883F9)}},
        {{UINT32_C(0x0CEABAE1), UINT32_C(0x30DC39B7), UINT32_C(0xA606D766),
          UINT32_C(0x49EC5EE8), UINT32_C(0x97FC46AF), UINT32_C(0x230E2762),
          UINT32_C(0x5BE79B8D), UINT32_C(0x079A531F)},
         {UINT32_C(0xEF08C93F), UINT32_C(0x48253BC2), UINT32_C(0xF124D043),
          UINT32_C(0x2D32AF02), UINT32_C(0xAF34D231), UINT32_C(0x85796D0D),
          UINT32_C(0x15F8CECD), UINT32_C(0x06A6205C)}},
        {{UINT32_C(0x47B00D1A), UINT32_C(0x1FA77AFD), UINT32_C(0xE48CE97A),
          UINT32_C(0x429717B0), UINT32_C(0x57433697), UINT32_C(0x38FEF11D),
          UINT32_C(0x7D426687), UINT32_C(0x3E91BED6)},
         {UINT32_C(0x2AB4BFE9), UINT32_C(0x95919BF7), UINT32_C(0x97096B3A),
          UINT32_C(0x7A3F33FC), UINT32_C(0x3DD8C82E), UINT32_C(0x0E0BBAC3),
          UINT32_C(0xF8EDB675), UINT32_C(0x2CE9EFCB)}},
        {{UINT32_C(0x43D8B81D), UINT32_C(0x2D44E998), UINT32_C(0x6D68A95C),
          UINT32_C(0x8ABFF419), UINT32_C(0x3B2A18DD), UINT32_C(0x639000A0),
          UINT32_C(0x871E3ED3), UINT32_C(0x7CD15413)},
         {UINT32_C(0x148F0378), UINT32_C(0xC059855B), UINT32_C(0x616B62BF),
          UINT32_C(0x50147459), UINT32_C(0x4D461110), UINT32_C(0x53B699AF),
          UINT32_C(0xEC29E48D), UINT32_C(0x6A0D0EC7)}},
    },
    {
        {{UINT32_C(0x15797F35), UINT32_C(0x51733221), UINT32_C(0x4BBE6644),
          UINT32_C(0x2F298214), UINT32_C(0x4A5EF621), UINT32_C(0x7BC8FEC6),
          UINT32_C(0x7F472F05), UINT32_C(0x3D2BE785)},
         {UINT32_C(0x2765C427), UINT32_C(0xA1C3A1C9), UINT32_C(0x24155ACF),
          UINT32_C(0xBACF08FE), UINT32_C(0x9D229948), UINT32_C(0xA9CC1A17),
          UINT32_C(0x27039FD8), UINT32_C(0x1918C97F)}},
        {{UINT32_C(0x7843FF7B), UINT32_C(0x2CF39338), UINT32_C(0x258997F2),
          UINT32_C(0x5FCBDE65), UINT32_C(0x165A98A3), UINT32_C(0x3980BF90),
          UINT32_C(0xBF9458E5), UINT32_C(0x2E80607D)},
         {UINT32_C(0x7019165C), UINT32_C(0x5F646EB6), UINT32_C(0xDDE34205),
          UINT32_C(0xFA091FBE), UINT32_C(0x69267AE3), UINT32_C(0x695348B6),
          UINT32_C(0xABC22051), UINT32_C(0x385B0B6A)}},
        {{UINT32_C(0xB537F78C), UINT32_C(0x3CAE0756), UINT32_C(0x8BE30367),
          UINT32_C(0x3012A958), UINT32_C(0x981A22C3), UINT32_C(0x32D26C06),
          UINT32_C(0x2950E833), UINT32_C(0x7D091FAB)},
         {UINT32_C(0x797ACAAF), UINT32_C(0xD8E1B638), UINT32_C(0x49F2EA10),
          UINT32_C(0xE7021C85), UINT32_C(0x17A7AF3B), UINT32_C(0xCA382BC1),
          UINT32_C(0xBB809976), UINT32_C(0x08A5A81D)}},
        {{UINT32_C(0x4287BB97), UINT32_C(0x00F499FD), UINT32_C(0xDAA9DAF2),
          UINT32_C(0xFB6791CA), UINT32_C(0x057B2B98), UINT32_C(0x9A19E4F3),
          UINT32_C(0xC53C0223), UINT32_C(0x6968D2FF)},
         {UINT32_C(0xCE88509C), UINT32_C(0xDC741EF5), UINT32_C(0x306A0570),
          UINT32_C(0x38AE355D), UINT32_C(0xC23AF46B), UINT32_C(0xFECF6589),
          UINT32_C(0x6AD48836), UINT32_C(0x6C0E6ED1)}},
        {{UINT32_C(0xE363495D), UINT32_C(0x22B68698), UINT32_C(0x39AF2BE3),
          UINT32_C(0x120005D0), UINT32_C(0x0BF4BA69), UINT32_C(0xE37B1965),
          UINT32_C(0x26E64AE7), UINT32_C(0x3B416E93)},
         {UINT32_C(0xDEAC5C59), UINT32_C(0xFAED5088), UINT32_C(0xEB2518A5),
          UINT32_C(0x67436ACC), UINT32_C(0x91FA788D), UINT32_C(0x636B52F8),
          UINT32_C(0x655153D1), UINT32_C(0x10B2A57A)}},
        {{UINT32_C(0x833A984C), UINT32_C(0xB18060A7), UINT32_C(0x74833BAD),
          UINT32_C(0x7EF83746), UINT32_C(0xC5B3BC88), UINT32_C(0xCBFAF742),
          UINT32_C(0xA1A7F135), UINT32_C(0x7981DC36)},
         {UINT32_C(0x5D076280), UINT32_C(0xE70CCAFA), UINT32_C(0x07009D85),
          UINT32_C(0xEBA80EB7), UINT32_C(0x73778DE2), UINT32_C(0x7D99D24C),
          UINT32_C(0xA7262D50), UINT32_C(0x1EFEE1BB)}},
        {{UINT32_C(0x6A7CAB32), UINT32_C(0xBC47F4A2), UINT32_C(0xDD6E48A3),
          UINT32_C(0x53F290A7), UINT32_C(0x92F35F9E), UINT32_C(0x82257A1B),
          UINT32_C(0x8BB0AAB0), UINT32_C(0x73D17B31)},
         {UINT32_C(0xC2DFFE96), UINT32_C(0xBBD4522A), UINT32_C(0xE6EB0501),
          UINT32_C(0x9C37DAA1), UINT32_C(0x453DB6BE), UINT32_C(0xF4D4D568),
          UINT32_C(0x642AD2E4), UINT32_C(0x2868CBF5)}},
        {{UINT32_C(0xABE30C59), UINT32_C(0x40A988E6), UINT32_C(0x93057DEC),
          UINT32_C(0x5ADED929), UINT32_C(0xDACD37B0), UINT32_C(0x18FD7E04),
          UINT32_C(0x8228ACA5), UINT32_C(0x6E3FB81E)},
         {UINT32_C(0x4104B0C9), UINT32_C(0xFF3EEFE6), UINT32_C(0x31CA120A),
          UINT32_C(0xD7DD05E7), UINT32_C(0xD01C1CF8), UINT32_C(0xAFD3CF1C),
          UINT32_C(0x831BC4E9), UINT32_C(0x4D0CD264)}},
        {{UINT32_C(0x82CAC14A), UINT32_C(0x2641B321), UINT32_C(0x70990E6C),
          UINT32_C(0x34EB1495), UINT32_C(0xA1C74CA6), UINT32_C(0x3E5AF58F),
          UINT32_C(0x616B7A2D), UINT32_C(0x11B50821)},
         {UINT32_C(0xC4FA9719), UINT32_C(0x891636E3), UINT32_C(0x107DD719),
          UINT32_C(0xAEE84C27), UINT32_C(0xC1872E75), UINT32_C(0xA2B0D83E),
          UINT32_C(0x7383069E), UINT32_C(0x7DD62CBC)}},
        {{UINT32_C(0xC81B7E15), UINT32_C(0xEBA4A024), UINT32_C(0x04516070),
          UINT32_C(0x1CC37E08), UINT32_C(0xF90CE59D), UINT32_C(0xEF1F0401),
          UINT32_C(0xE062E133), UINT32_C(0x3B4259D5)},
         {UINT32_C(0xCF2CA1DD), UINT32_C(0x87A1DBFA), UINT32_C(0x61FD1AFB),
          UINT32_C(0xCFBFB15F), UINT32_C(0xECF4C7BA), UINT32_C(0xFBFD9899),
          UINT32_C(0x2725FA50), UINT32_C(0x57C84CEE)}},
        {{UINT32_C(0xEFA6E3D0), UINT32_C(0x8B0B7414), UINT32_C(0xB3D04224),
          UINT32_C(0xD9725C5E), UINT32_C(0x8A91371E), UINT32_C(0x670E6C50),
          UINT32_C(0x9B25BD3B), UINT32_C(0x4D130467)},
         {UINT32_C(0x5CF18D4F), UINT32_C(0x18D77D15), UINT32_C(0x1CA09677),
          UINT32_C(0xEF80DC41), UINT32_C(0xB9A05CF9), UINT32_C(0x6F3A961B),
          UINT32_C(0x7C1433A4), UINT32_C(0x0BB8A518)}},
        {{UINT32_C(0xB33FCF05), UINT32_C(0xAC0CF52A), UINT32_C(0x1CDC7782),
          UINT32_C(0xAD03692F), UINT32_C(0xAA02B77E), UINT32_C(0xB345BAE6),
          UINT32_C(0x456FCFA9), UINT32_C(0x05096694)},
         {UINT32_C(0x25D4CF32), UINT32_C(0xA8984448), UINT32_C(0x15184188),
          UINT32_C(0xD76393E3), UINT32_C(0xEA069BED), UINT32_C(0x7D4A8C0C),
          UINT32_C(0x11E18347), UINT32_C(0x4D22268D)}},
        {{UINT32_C(0x3CB3C0F1), UINT32_C(0xC2A0BB75), UINT32_C(0x8EBA58C6),
          UINT32_C(0x61F4EC4C), UINT32_C(0xDFC4A903), UINT32_C(0x5D3F0D44),
          UINT32_C(0xF9B6F79A), UINT32_C(0x0B6CE81B)},
         {UINT32_C(0x94E49623), UINT32_C(0xF694A44A), UINT32_C(0x1BDF75E0),
          UINT32_C(0xCFCBB7E1), UINT32_C(0xE0337E13), UINT32_C(0x20CEE1BD),
          UINT32_C(0xDFF02E18), UINT32_C(0x694EA40B)}},
        {{UINT32_C(0x78D1DC2E), UINT32_C(0xC21BE0FA), UINT32_C(0xED0E49E0),
          UINT32_C(0x08B4D9A5), UINT32_C(0x827F0B4C), UINT32_C(0x676731AB),
          UINT32_C(0xEBAB5894), UINT32_C(0x674ECC79)},
         {UINT32_C(0x39ABB148), UINT32_C(0xB29BD0D4), UINT32_C(0x2378A63A),
          UINT32_C(0x8207A8F8), UINT32_C(0x1E4C29C2), UINT32_C(0xE36A549D),
          UINT32_C(0x3F1C255B), UINT32_C(0x380D48DE)}},
        {{UINT32_C(0xE5F2C87E), UINT32_C(0x6AB6F887), UINT32_C(0xA01AEC86),
          UINT32_C(0xE92C7345), UINT32_C(0x8660C26F), UINT32_C(0x697F4520),
          UINT32_C(0x9B58015B), UINT32_C(0x4F2488E0)},
         {UINT32_C(0xBB41900C), UINT32_C(0xB2410B3E), UINT32_C(0xBE1A8A39),
          UINT32_C(0x31267500), UINT32_C(0xB9140554), UINT32_C(0xA7C9997C),
          UINT32_C(0x1CD41524), UINT32_C(0x335B1806)}},
        {{UINT32_C(0x14873270), UINT32_C(0xB836FD9F), UINT32_C(0xE3243EC5),
          UINT32_C(0x1AE0F512), UINT32_C(0x83B9AB74), UINT32_C(0xA743E304),
          UINT32_C(0x3A5758C7), UINT32_C(0x1569C30D)},
         {UINT32_C(0x9E8F9E52), UINT32_C(0x003CEF9A), UINT32_C(0x8C22119E),
          UINT32_C(0x557AFB4A), UINT32_C(0xF223A966), UINT32_C(0x66F2487E),
          UINT32_C(0xA519378F), UINT32_C(0x7FA00273)}},
    },
    {
        {{UINT32_C(0x7B08C1C4), UINT32_C(0x812C024F), UINT32_C(0xADBA8AD9),
          UINT32_C(0xC6017986), UINT32_C(0x0601BD82), UINT32_C(0x59C7B16C),
          UINT32_C(0x0CFA5622), UINT32_C(0x41B6A45C)},
         {UINT32_C(0x83C1E3E8), UINT32_C(0x353A67D5), UINT32_C(0xC65F5059),
          UINT32_C(0x9A83438E), UINT32_C(0x86EEA346), UINT32_C(0x99950377),
          UINT32_C(0x330D2570), UINT32_C(0x74E2F4BD)}},
        {{UINT32_C(0xB4A8BDA8), UINT32_C(0xDB8E53C1), UINT32_C(0x2C003C77),
          UINT32_C(0xA850047E), UINT32_C(0x1B018831), UINT32_C(0xFFD48A73),
          UINT32_C(0x8B325062), UINT32_C(0x24F96CB6)},
         {UINT32_C(0xCD2B821B), UINT32_C(0x3779CA4D), UINT32_C(0xC3159CE7),
          UINT32_C(0xC2AFBF6E), UINT32_C(0x10F18DE9), UINT32_C(0x8A580B1A),
          UINT32_C(0x8CF75334), UINT32_C(0x37043D0D)}},
        {{UINT32_C(0xECCCF2E8), UINT32_C(0x0451DCDA), UINT32_C(0x752A134F),
          UINT32_C(0xCF7A3AD9), UINT32_C(0xFBDAE56C), UINT32_C(0xD5754596),
          UINT32_C(0xF4CDCF6A), UINT32_C(0x15237D73)},
         {UINT32_C(0xECA37967), UINT32_C(0x1DF5912C), UINT32_C(0x336CD97E),
          UINT32_C(0x60934339), UINT32_C(0x434DDC01), UINT32_C(0xA4E523FE),
          UINT32_C(0x79DBE24C), UINT32_C(0x24E81DC6)}},
        {{UINT32_C(0xC83B2B7C), UINT32_C(0x28F0D73B), UINT32_C(0x7B5DE1AA),
          UINT32_C(0x45BE220F), UINT32_C(0xB136A877), UINT32_C(0x1B785230),
          UINT32_C(0xAEFF115B), UINT32_C(0x5A94122A)},
         {UINT32_C(0x8E598998), UINT32_C(0xEF895F0C), UINT32_C(0xF4C622C3),
          UINT32_C(0xCEE32B3E), UINT32_C(0xB256CFD0), UINT32_C(0x2D080B1D),
          UINT32_C(0x21075E15), UINT32_C(0x672686D6)}},
        {{UINT32_C(0x9F9F26FE), UINT32_C(0xE85FB575), UINT32_C(0x93A7966E),
          UINT32_C(0x1DE57B83), UINT32_C(0xDD8CB696), UINT32_C(0xA9948DE8),
          UINT32_C(0x758E685D), UINT32_C(0x226C95A6)},
         {UINT32_C(0x3729C663), UINT32_C(0x38B0753B), UINT32_C(0x410E4884),
          UINT32_C(0xD46CA4D9), UINT32_C(0x77516FA4), UINT32_C(0x1D6FA5F9),
          UINT32_C(0x696CFAFC), UINT32_C(0x09A0FDB8)}},
        {{UINT32_C(0xCC7F6FD8), UINT32_C(0xD1DAD8E9), UINT32_C(0x022195A2),
          UINT32_C(0x7BB9F606), UINT32_C(0x223A9346), UINT32_C(0x1B997396),
          UINT32_C(0x88DCFB04), UINT32_C(0x6ACD6F7C)},
         {UINT32_C(0x3AC52F65), UINT32_C(0x9029E5EB), UINT32_C(0x935A39DE),
          UINT32_C(0xED1D7A0F), UINT32_C(0x538D8914), UINT32_C(0xF1D58C3A),
          UINT32_C(0xB36B8342), UINT32_C(0x19153569)}},
        {{UINT32_C(0xE2502156), UINT32_C(0xFF600354), UINT32_C(0x733DA5EC),
          UINT32_C(0xE386A20F), UINT32_C(0x9D24D11D), UINT32_C(0xD6FBCBBB),
          UINT32_C(0x0B06C843), UINT32_C(0x0B57498C)},
         {UINT32_C(0x7A834667), UINT32_C(0x98F1FFF8), UINT32_C(0xC7DF05F5),
          UINT32_C(0x4AEB8788), UINT32_C(0xC2681DA4), UINT32_C(0x8CFA3B01),
          UINT32_C(0x2FA2FAEA), UINT32_C(0x1AECC0E8)}},
        {{UINT32_C(0x94C5CBC5), UINT32_C(0x38278865), UINT32_C(0x041A755A),
          UINT32_C(0x9ADA7CAB), UINT32_C(0x8D891640), UINT32_C(0xB38F762A),
          UINT32_C(0x00AD88F0), UINT32_C(0x28F6FBB2)},
         {UINT32_C(0x3709CD6D), UINT32_C(0x3F9629E3), UINT32_C(0x4912F483),
          UINT32_C(0xD2435A55), UINT32_C(0xDFF5AB69), UINT32_C(0x305BEA64),
          UINT32_C(0x663BB0D9), UINT32_C(0x4D29041A)}},
        {{UINT32_C(0xE2FD9338), UINT32_C(0xDC4BC9D4), UINT32_C(0xBA7938FC),
          UINT32_C(0x5389390D), UINT32_C(0xF329B218), UINT32_C(0xC42B812D),
          UINT32_C(0xFA9F1956), UINT32_C(0x5E809B5E)},
         {UINT32_C(0x523D74C3), UINT32_C(0xE2A89BAA), UINT32_C(0x78CBA7B5),
          UINT32_C(0x97CD9FFB), UINT32_C(0x5B07BCD2), UINT32_C(0x25F95301),
          UINT32_C(0x2064BB3A), UINT32_C(0x4042C705)}},
        {{UINT32_C(0x28D53BF9), UINT32_C(0xD8B6ADA4), UINT32_C(0xA4210F2D),
          UINT32_C(0x5E922CA5), UINT32_C(0xF05A1629), UINT32_C(0x9501F46A),
          UINT32_C(0xC6CD71CD), UINT32_C(0x28094E54)},
         {UINT32_C(0x811285AD), UINT32_C(0x8D5484D5), UINT32_C(0x1593EE86),
          UINT32_C(0xFB2168F4), UINT32_C(0xAC54A41D), UINT32_C(0x693D3B32),
          UINT32_C(0x28A5425C), UINT32_C(0x3DAFEC07)}},
        {{UINT32_C(0xD12837A8), UINT32_C(0x0E4CF0D0), UINT32_C(0xCF5273BB),
          UINT32_C(0x19FA2CC9), UINT32_C(0x116A20C4), UINT32_C(0x56346BAE),
          UINT32_C(0x0E436A36), UINT32_C(0x4F3597FE)},
         {UINT32_C(0xE8EB1B85), UINT32_C(0x459D3FFB), UINT32_C(0x5AE04130),
          UINT32_C(0x7C718672), UINT32_C(0x60302740), UINT32_C(0xA37C2586),
          UINT32_C(0x913072D8), UINT32_C(0x2871AF37)}},
        {{UINT32_C(0x8590319D), UINT32_C(0xD77249B7), UINT32_C(0xEB06B813),
          UINT32_C(0x73F7A684), UINT32_C(0x71D1D580), UINT32_C(0x4C9DC5B9),
          UINT32_C(0x5A50A95B), UINT32_C(0x7C91A9F5)},
         {UINT32_C(0x0475F161), UINT32_C(0x4F8F2E89), UINT32_C(0x538B7F94),
          UINT32_C(0xF34EC1DD), UINT32_C(0xD46F2575), UINT32_C(0xB8FF6C65),
          UINT32_C(0x64433C80), UINT32_C(0x79A2CE2C)}},
        {{UINT32_C(0x1AEB7039), UINT32_C(0x38448A53), UINT32_C(0x417189EC),
          UINT32_C(0xF5EC03F7), UINT32_C(0xEB92FF2B), UINT32_C(0xFA095CA1),
          UINT32_C(0xE4FCAEDB), UINT32_C(0x4612F720)},
         {UINT32_C(0xF30AAE0E), UINT32_C(0xC945E966), UINT32_C(0x340A7A1D),
          UINT32_C(0xF61CFE85), UINT32_C(0xE42D7920), UINT32_C(0xA2560BC6),
          UINT32_C(0xA692E9C7), UINT32_C(0x07D7B321)}},
        {{UINT32_C(0x592C60C5), UINT32_C(0xB9C26307), UINT32_C(0x0F59D966),
          UINT32_C(0xCECBC6C3), UINT32_C(0x5459D89E), UINT32_C(0x8BA31FD6),
          UINT32_C(0x47C7FAE8), UINT32_C(0x1A4AF6B1)},
         {UINT32_C(0xB431D720), UINT32_C(0x66487766), UINT32_C(0x5108B845),
          UINT32_C(0x5D597309), UINT32_C(0xCA8E6E0D), UINT32_C(0xA3B94FD7),
          UINT32_C(0x55C6A48D), UINT32_C(0x639519E3)}},
        {{UINT32_C(0x052DC195), UINT32_C(0xAD3EE167), UINT32_C(0x0947816B),
          UINT32_C(0x4DF2BFC7), UINT32_C(0xABADBB3C), UINT32_C(0x5D463469),
          UINT32_C(0xC33D4F96), UINT32_C(0x6F7AA885)},
         {UINT32_C(0xFE06133C), UINT32_C(0x3DD27536), UINT32_C(0x2796E7ED),
          UINT32_C(0x27A557B2), UINT32_C(0x3D314A4F), UINT32_C(0x1117CCB7),
          UINT32_C(0x23968946), UINT32_C(0x6F0C0AE0)}},
        {{UINT32_C(0xE2110C00), UINT32_C(0x0A3D4DAE), UINT32_C(0x4C633A23),
          UINT32_C(0x0389D3A5), UINT32_C(0x83AEC172), UINT32_C(0xE167BDFA),
          UINT32_C(0xFB38E8F1), UINT32_C(0x067070CE)},
         {UINT32_C(0x4DF220C5), UINT32_C(0x41137367), UINT32_C(0x59C39F05),
          UINT32_C(0xB255E5D3), UINT32_C(0x043C75B3), UINT32_C(0xE437984E),
          UINT32_C(0x6A22994A), UINT32_C(0x01DCD771)}},
    },
    {
        {{UINT32_C(0x4C6FDDCF), UINT32_C(0xD2880DF2), UINT32_C(0x8A00D80F),
          UINT32_C(0x76A28FF2), UINT32_C(0x0792F82C), UINT32_C(0x257CB1F8),
          UINT32_C(0x605703EA), UINT32_C(0x07938ABC)},
         {UINT32_C(0x5F61B0FE), UINT32_C(0xD99F0AC9), UINT32_C(0x8EC15433),
          UINT32_C(0x440DC63C), UINT32_C(0x86AB5DDB), UINT32_C(0xD9BDDFF1),
          UINT32_C(0x744755EA), UINT32_C(0x3B8875DC)}},
        {{UINT32_C(0x4938C9FB), UINT32_C(0x01D90440), UINT32_C(0x8DB6A890),
          UINT32_C(0x900657FD), UINT32_C(0xF60A173A), UINT32_C(0xDCC5068A),
          UINT32_C(0x857C7B2A), UINT32_C(0x5F3EB242)},
         {UINT32_C(0xA4F0EB9E), UINT32_C(0x634240BD), UINT32_C(0x44E85C70),
          UINT32_C(0xACDDA6C4), UINT32_C(0x0AABE4C5), UINT32_C(0x753F02AB),
          UINT32_C(0xC1D034E1), UINT32_C(0x33D89D21)}},
        {{UINT32_C(0x1279B25B), UINT32_C(0x4596B52D), UINT32_C(0xA48014AE),
          UINT32_C(0x494669D9), UINT32_C(0x4FD22150), UINT32_C(0x9A26B6FC),
          UINT32_C(0xF07D5A3F), UINT32_C(0x394DE0BB)},
         {UINT32_C(0x634C1733), UINT32_C(0x12DFE5A6), UINT32_C(0x1EBC5177),
          UINT32_C(0x33EC21D2), UINT32_C(0x527514CC), UINT32_C(0x454B4930),
          UINT32_C(0x41405532), UINT32_C(0x7F23BD0F)}},
        {{UINT32_C(0xBAC9DD30), UINT32_C(0xB2879E7F), UINT32_C(0x06CE7672),
          UINT32_C(0x259BB1CB), UINT32_C(0xBB97BE10), UINT32_C(0x201DB42E),
          UINT32_C(0x2EA35A8E), UINT32_C(0x112D6079)},
         {UINT32_C(0x6B3B9933), UINT32_C(0x7CC756D4), UINT32_C(0x781CE4DD),
          UINT32_C(0x4BD24810), UINT32_C(0x8733247E), UINT32_C(0x53CB4E38),
          UINT32_C(0x9DA66787), UINT32_C(0x47BD6A30)}},
        {{UINT32_C(0xBA600C8E), UINT32_C(0x8A700953), UINT32_C(0xCF388C0D),
          UINT32_C(0xD466F11D), UINT32_C(0xE4A17A8E), UINT32_C(0xD485F341),
          UINT32_C(0x234FC16D), UINT32_C(0x63278918)},
         {UINT32_C(0xBB82046D), UINT32_C(0xF4DDA875), UINT32_C(0x2945470A),
          UINT32_C(0xD61E4E58), UINT32_C(0x6D0F8976), UINT32_C(0xCDB6C5BD),
          UINT32_C(0x10A004A2), UINT32_C(0x44CD9E4D)}},
        {{UINT32_C(0x49C4AA6E), UINT32_C(0x595CD942), UINT32_C(0x3DE400C8),
          UINT32_C(0xE5A90136), UINT32_C(0x9DD12D9E), UINT32_C(0x4BCED3BD),
          UINT32_C(0x78E3D5E4), UINT32_C(0x3700CF92)},
         {UINT32_C(0x75A32D1A), UINT32_C(0xECFFF498), UINT32_C(0x3C4A54B2),
          UINT32_C(0xC28DDE37), UINT32_C(0x993CAE6D), UINT32_C(0x8DC22352),
          UINT32_C(0x52ED7019), UINT32_C(0x46CB5408)}},
        {{UINT32_C(0xEA94E7BF), UINT32_C(0x71FFAED0), UINT32_C(0xD5AE6185),
          UINT32_C(0xC0817D2C), UINT32_C(0x5CF23687), UINT32_C(0x7B72B8B9),
          UINT32_C(0x60A450E1), UINT32_C(0x61DDE599)},
         {UINT32_C(0xD13870E6), UINT32_C(0x17CF0B10), UINT32_C(0x5F2930BB),
          UINT32_C(0x7D08E1FB), UINT32_C(0x83807C14), UINT32_C(0x8D0F4F55),
          UINT32_C(0x6E6DB701), UINT32_C(0x61EBFC1A)}},
        {{UINT32_C(0x0FCAFE68), UINT32_C(0x247A3F65), UINT32_C(0x7AC2A25E),
          UINT32_C(0x57548035), UINT32_C(0x3CD0FE06), UINT32_C(0xB7466CA5),
          UINT32_C(0xBCC31AB3), UINT32_C(0x7B0D8B36)},
         {UINT32_C(0xA6D4358C), UINT32_C(0x2FAAF49C), UINT32_C(0x3E9B4E31),
          UINT32_C(0xD9E5E2FE), UINT32_C(0xF6086336), UINT32_C(0xA6A859A0),
          UINT32_C(0xA9C19F84), UINT32_C(0x0C2A442A)}},
        {{UINT32_C(0x3BC0AD7D), UINT32_C(0x66FEA841), UINT32_C(0x32C9158E),
          UINT32_C(0xCD3A546C), UINT32_C(0x8FE1DF7F), UINT32_C(0xACD2EE7F),
          UINT32_C(0xEBE9621E), UINT32_C(0x10F58C0A)},
         {UINT32_C(0x478B667D), UINT32_C(0x80047C54), UINT32_C(0x89870DCE),
          UINT32_C(0x9EAE5FAA), UINT32_C(0x0520A005), UINT32_C(0xC05BEB33),
          UINT32_C(0x352AC891), UINT32_C(0x2CFBC921)}},
        {{UINT32_C(0x632F6D73), UINT32_C(0x6842E6B8), UINT32_C(0x2B9FFAEA),
          UINT32_C(0x6F2B5724), UINT32_C(0x9341D2FA), UINT32_C(0x7ACCC982),
          UINT32_C(0x88809B65), UINT32_C(0x6DAD9A11)},
         {UINT32_C(0xB6CC2240), UINT32_C(0x3411850C), UINT32_C(0xB64937E1),
          UINT32_C(0x8547BCAF), UINT32_C(0x6978F636), UINT32_C(0x49AEDD5F),
          UINT32_C(0x85A53D2A), UINT32_C(0x38F59752)}},
        {{UINT32_C(0xF5F5A2D0), UINT32_C(0x5C38EB49), UINT32_C(0xE3BF779C),
          UINT32_C(0xE028121B), UINT32_C(0xA783D5E3), UINT32_C(0x649997C8),
          UINT32_C(0x2C06CC0F), UINT32_C(0x04DE984A)},
         {UINT32_C(0xA49D6239), UINT32_C(0x52C834B0), UINT32_C(0x628413AC),
          UINT32_C(0x070A1B09), UINT32_C(0xA8624A1E), UINT32_C(0x2FBE0CA5),
          UINT32_C(0x268D930A), UINT32_C(0x687D93C3)}},
        {{UINT32_C(0x314C47A4), UINT32_C(0xC7CD6805), UINT32_C(0xCE7A9A6D),
          UINT32_C(0x8BD0C630), UINT32_C(0x34F727BA), UINT32_C(0xCDB2DAD5),
          UINT32_C(0x25DB0189), UINT32_C(0x7814C414)},
         {UINT32_C(0x7DD9CAEE), UINT32_C(0xD7F9C5DC), UINT32_C(0x798690E4),
          UINT32_C(0xDA6EACC8), UINT32_C(0x6B675E01), UINT32_C(0x705794E3),
          UINT32_C(0x75C5EC38), UINT32_C(0x4A31D714)}},
        {{UINT32_C(0x0519D5F2), UINT32_C(0xC162A3EA), UINT32_C(0x2958FABF),
          UINT32_C(0x92146A78), UINT32_C(0x6CB31EB0), UINT32_C(0x1E63CBE4),
          UINT32_C(0xFBC5AD0F), UINT32_C(0x77CE5AAD)},
         {UINT32_C(0x32605DC6), UINT32_C(0x3631E470), UINT32_C(0x43413DD3),
          UINT32_C(0xC7D1C72F), UINT32_C(0x0DF6B7C9), UINT32_C(0x171A3794),
          UINT32_C(0x2B5A08BC), UINT32_C(0x6D711743)}},
        {{UINT32_C(0x509EF0F2), UINT32_C(0xDDC8057D), UINT32_C(0x6CABB486),
          UINT32_C(0x05C0B92B), UINT32_C(0x4244D919), UINT32_C(0xD49692B6),
          UINT32_C(0xD297F56E), UINT32_C(0x4E181744)},
         {UINT32_C(0xF8CBB897), UINT32_C(0x902F6E73), UINT32_C(0x56D01382),
          UINT32_C(0xC3B21FE1), UINT32_C(0x46890F6D), UINT32_C(0xA858ABE1),
          UINT32_C(0x506858AF), UINT32_C(0x46B5E2C9)}},
        {{UINT32_C(0xF4DEDE56), UINT32_C(0x30441281), UINT32_C(0xA195AEDE),
          UINT32_C(0x13F06FBB), UINT32_C(0x2FDD3BFF), UINT32_C(0xAD5F575B),
          UINT32_C(0x32ACB590), UINT32_C(0x680F656D)},
         {UINT32_C(0xE3FAABA7), UINT32_C(0xFB60A8E1), UINT32_C(0x89A14827),
          UINT32_C(0xC8FBC1E4), UINT32_C(0xA8616136), UINT32_C(0x5835453F),
          UINT32_C(0xE6F4926F), UINT32_C(0x02826A47)}},
        {{UINT32_C(0x74F32180), UINT32_C(0xAF4319A1), UINT32_C(0x6C2C1712),
          UINT32_C(0x4C9FDD16), UINT32_C(0xAC7E14A7), UINT32_C(0x59CA4FD4),
          UINT32_C(0xABBD4EA4), UINT32_C(0x07AA6E2F)},
         {UINT32_C(0xFE9F121F), UINT32_C(0xB4BD441C), UINT32_C(0xCDA452C5),
          UINT32_C(0xDEBB4356), UINT32_C(0x51C9F451), UINT32_C(0xC29F1CFA),
          UINT32_C(0x83F598D8), UINT32_C(0x7E1EEF4C)}},
    },
    {
        {{UINT32_C(0x5014135F), UINT32_C(0xFC41A321), UINT32_C(0x3EEADF3F),
          UINT32_C(0xBE95F9BA), UINT32_C(0x3203A540), UINT32_C(0x054B1212),
          UINT32_C(0x3721C745), UINT32_C(0x6DD2FD17)},
         {UINT32_C(0x5A682B59), UINT32_C(0xF86B8578), UINT32_C(0xBE801F7D),
          UINT32_C(0x872AA481), UINT32_C(0x14F865F2), UINT32_C(0x64C1600C),
          UINT32_C(0x25365449), UINT32_C(0x4BDD47AA)}},
        {{UINT32_C(0xF3A3469F), UINT32_C(0xC96A964C), UINT32_C(0x9F7DA0E3),
          UINT32_C(0x273C5C85), UINT32_C(0x4C1A9DCD), UINT32_C(0x88EDC4AC),
          UINT32_C(0xB48E4CAA), UINT32_C(0x77623444)},
         {UINT32_C(0x31581FF7), UINT32_C(0x7AF34A9C), UINT32_C(0xBB57F7CC),
          UINT32_C(0x23328C37), UINT32_C(0x8B7C86AB), UINT32_C(0xE920D8E9),
          UINT32_C(0x9DE6D64C), UINT32_C(0x1C7A7A40)}},
        {{UINT32_C(0x79B9451C), UINT32_C(0x0BCDCD22), UINT32_C(0x58F5241B),
          UINT32_C(0x2920B435), UINT32_C(0x9B33EF3D), UINT32_C(0xC24DF715),
          UINT32_C(0xF2600224), UINT32_C(0x15252C5B)},
         {UINT32_C(0x9A9160B6), UINT32_C(0xF9C8D8A6), UINT32_C(0xA6B9A6B8),
          UINT32_C(0x3186F2F9), UINT32_C(0xA377E98A), UINT32_C(0xC37267DC),
          UINT32_C(0x37957189), UINT32_C(0x71319A0A)}},
        {{UINT32_C(0x6BAF6AE5), UINT32_C(0x48E5033F), UINT32_C(0xA460FCE9),
          UINT32_C(0x72379B2E), UINT32_C(0xF3D2FA46), UINT32_C(0xFC753D47),
          UINT32_C(0xED9EDF72), UINT32_C(0x3B67685A)},
         {UINT32_C(0xF712500F), UINT32_C(0x1608E304), UINT32_C(0x9EE1B42A),
          UINT32_C(0xDFA358A4), UINT32_C(0x34B8345C), UINT32_C(0xE7A4B376),
          UINT32_C(0x06753C17), UINT32_C(0x7D0E0BF3)}},
        {{UINT32_C(0x8FA62042), UINT32_C(0xA88526A6), UINT32_C(0x393006BD),
          UINT32_C(0xD6F32BB5), UINT32_C(0xA5DD5045), UINT32_C(0x14804978),
          UINT32_C(0xBF0C5E13), UINT32_C(0x34C02662)},
         {UINT32_C(0x376E3E3D), UINT32_C(0xF9BEEBF9), UINT32_C(0x5923DC61),
          UINT32_C(0xFD774041), UINT32_C(0xF9735CF5), UINT32_C(0xFE77BDFA),
          UINT32_C(0x4077CFCC), UINT32_C(0x2E476E22)}},
        {{UINT32_C(0x9BA457EF), UINT32_C(0xAB8E52EB), UINT32_C(0x0ABED212),
          UINT32_C(0x95F6C5FE), UINT32_C(0x386620FF), UINT32_C(0x7204B1A6),
          UINT32_C(0xDD180719), UINT32_C(0x463B7474)},
         {UINT32_C(0xF991D8EE), UINT32_C(0x7F7D27AA), UINT32_C(0x8F67722D),
          UINT32_C(0xA7EB1085), UINT32_C(0xE331480A), UINT32_C(0x78D7095B),
          UINT32_C(0x66A1C8FA), UINT32_C(0x1DCC8C12)}},
        {{UINT32_C(0x3E6A04C1), UINT32_C(0xD4C39C18), UINT32_C(0xB598ABEE),
          UINT32_C(0x73DB1C4D), UINT32_C(0xDF4A7D42), UINT32_C(0x381F9780),
          UINT32_C(0x52F860CD), UINT32_C(0x3C19A231)},
         {UINT32_C(0x3EF00740), UINT32_C(0x7EC89934), UINT32_C(0xF37FE0D5),
          UINT32_C(0x50867788), UINT32_C(0x43E84D4A), UINT32_C(0x502D870B),
          UINT32_C(0x8F744749), UINT32_C(0x5F8A8413)}},
        {{UINT32_C(0xFAECCFE4), UINT32_C(0x1C41AAAD), UINT32_C(0x21461F41),
          UINT32_C(0xC324F3B9), UINT32_C(0x4E90C0AB), UINT32_C(0x165ABA3F),
          UINT32_C(0x5F88E7D3), UINT32_C(0x2F96CED5)},
         {UINT32_C(0xC0E52768), UINT32_C(0x8CA366FC), UINT32_C(0xA55249A7),
          UINT32_C(0x6CCA017C), UINT32_C(0x0F7EBCA2), UINT32_C(0x41ED002F),
          UINT32_C(0xA2BAF655), UINT32_C(0x0C33B371)}},
        {{UINT32_C(0x62B928CE), UINT32_C(0x3B94CD9C), UINT32_C(0x39729345),
          UINT32_C(0x5BC43A6A), UINT32_C(0xC47D223C), UINT32_C(0x044D0C0F),
          UINT32_C(0xB0493367), UINT32_C(0x3B64B38D)},
         {UINT32_C(0xEB74A6C2), UINT32_C(0x82AFB645), UINT32_C(0xD876D71C),
          UINT32_C(0x0CB01E22), UINT32_C(0x29C6BCD0), UINT32_C(0xCE2A7DCC),
          UINT32_C(0xDFD644EC), UINT32_C(0x4753DE1C)}},
        {{UINT32_C(0x62188792), UINT32_C(0xE69FC903), UINT32_C(0x4914328B),
          UINT32_C(0xD91DB9BC), UINT32_C(0x3B68F8D0), UINT32_C(0x44953F4D),
          UINT32_C(0x0654B283), UINT32_C(0x2950435D)},
         {UINT32_C(0xBE88F609), UINT32_C(0xE599A4AE), UINT32_C(0x90F5D10E),
          UINT32_C(0xF801CD90), UINT32_C(0xD4F1D3D9), UINT32_C(0x0AB78DB1),
          UINT32_C(0xC0F71ECB), UINT32_C(0x3ED9666A)}},
        {{UINT32_C(0xE1E73E59), UINT32_C(0x6046A505), UINT32_C(0xF3B5C2E0),
          UINT32_C(0x8723A3EC), UINT32_C(0xE22C1555), UINT32_C(0x4BD95BF6),
          UINT32_C(0x6DA421E9), UINT32_C(0x50DC33DB)},
         {UINT32_C(0xF1B01327), UINT32_C(0xCFB51E95), UINT32_C(0x199A8765),
          UINT32_C(0xE7013F2A), UINT32_C(0x77504B0B), UINT32_C(0xF486FEA7),
          UINT32_C(0xF9BA61C6), UINT32_C(0x2AF0F7E9)}},
        {{UINT32_C(0xBE00B841), UINT32_C(0x9DBA1A02), UINT32_C(0x8BED5F08),
          UINT32_C(0x488BA455), UINT32_C(0x67F1040E), UINT32_C(0xF6814A64),
          UINT32_C(0xDC252336), UINT32_C(0x23AC4762)},
         {UINT32_C(0xF0ED0577), UINT32_C(0x25040F02), UINT32_C(0xC6FFAE9C),
          UINT32_C(0x65209B22), UINT32_C(0x485AA0AC), UINT32_C(0xCC441A8C),
          UINT32_C(0x59D63A8A), UINT32_C(0x10DFACB6)}},
        {{UINT32_C(0xC7D86B28), UINT32_C(0xBF4A0569), UINT32_C(0xDBDA9DA4),
          UINT32_C(0x5CDA94C4), UINT32_C(0x69058335), UINT32_C(0x2235C4CE),
          UINT32_C(0xD30C89E2), UINT32_C(0x68FA5E7C)},
         {UINT32_C(0x59097B5B), UINT32_C(0xBB286D39), UINT32_C(0x9A20BA7E),
          UINT32_C(0x87DA80BB), UINT32_C(0x56F47E54), UINT32_C(0x85EF865E),
          UINT32_C(0x74ABFA5B), UINT32_C(0x5BB87867)}},
        {{UINT32_C(0xDE2FA36E), UINT32_C(0x5DB14FAB), UINT32_C(0x77775F09),
          UINT32_C(0x84E3B546), UINT32_C(0xDA951D99), UINT32_C(0xDA734523),
          UINT32_C(0x3975026E), UINT32_C(0x04A89097)},
         {UINT32_C(0xC0D12BE1), UINT32_C(0xB5753599), UINT32_C(0xFB864D61),
          UINT32_C(0x05670CE9), UINT32_C(0x305BF3CF), UINT32_C(0xB7153502),
          UINT32_C(0x2E60AF62), UINT32_C(0x7A9BB357)}},
        {{UINT32_C(0xC7566DA5), UINT32_C(0xF43CDA07), UINT32_C(0x53FA4196),
          UINT32_C(0x7FC4C7FC), UINT32_C(0x88DCC9F3), UINT32_C(0x1E20E0ED),
          UINT32_C(0xFEE23DDA), UINT32_C(0x7317C7E5)},
         {UINT32_C(0x43017070), UINT32_C(0x0305E13F), UINT32_C(0x6B1CA7C0),
          UINT32_C(0x5568410C), UINT32_C(0x104BA029), UINT32_C(0x0E5D55BA),
          UINT32_C(0x90FD49F8), UINT32_C(0x118B284E)}},
        {{UINT32_C(0x8F3C6D8A), UINT32_C(0xCA0F7B5B), UINT32_C(0xAF7ECBF6),
          UINT32_C(0xAF72DEE0), UINT32_C(0xBB0EC4F1), UINT32_C(0x21C86D85),
          UINT32_C(0xF0525D17), UINT32_C(0x0303BC47)},
         {UINT32_C(0x896FFCC0), UINT32_C(0x6ADCAB9F), UINT32_C(0x24E970CA),
          UINT32_C(0x65764C45), UINT32_C(0x1C3CA718), UINT32_C(0x0000F14C),
          UINT32_C(0xD0292587), UINT32_C(0x01CF1DDB)}},
    },
    {
        {{UINT32_C(0x86111EBA), UINT32_C(0xEC4FABCC), UINT32_C(0xBBBB793F),
          UINT32_C(0x599C20B6), UINT32_C(0x5657668F), UINT32_C(0xF74AE747),
          UINT32_C(0x77BAE892), UINT32_C(0x24AF29B2)},
         {UINT32_C(0xCFAC9D5E), UINT32_C(0x47D6876B), UINT32_C(0x24369E14),
          UINT32_C(0xCACF9F50), UINT32_C(0x6F9CAFEF), UINT32_C(0x8A231D74),
          UINT32_C(0xB69AAE58), UINT32_C(0x57645A4E)}},
        {{UINT32_C(0x489900F6), UINT32_C(0x440A3B15), UINT32_C(0x961AC3C2),
          UINT32_C(0x4B642FD3), UINT32_C(0xC265B973), UINT32_C(0x3D668599),
          UINT32_C(0x1139CE78), UINT32_C(0x5FA0E65D)},
         {UINT32_C(0x1FAA710E), UINT32_C(0x3FF15AF4), UINT32_C(0xA9422FC0),
          UINT32_C(0xE45D35CE), UINT32_C(0xBD7BB349), UINT32_C(0x56904C06),
          UINT32_C(0xE529989D), UINT32_C(0x40C5BEE0)}},
        {{UINT32_C(0x70B20298), UINT32_C(0x8FA46861), UINT32_C(0x4838A136),
          UINT32_C(0xEC629538), UINT32_C(0x137F66D6), UINT32_C(0x23ADE0F6),
          UINT32_C(0x8EA53E76), UINT32_C(0x1A92E05C)},
         {UINT32_C(0x9D51EB7A), UINT32_C(0x51728E27), UINT32_C(0xC4352E35),
          UINT32_C(0xA6B0B758), UINT32_C(0x37A11B35), UINT32_C(0x84C59331),
          UINT32_C(0xF66B75C7), UINT32_C(0x3933EFC1)}},
        {{UINT32_C(0x66916D0A), UINT32_C(0x7FB68D62), UINT32_C(0xF28A9B14),
          UINT32_C(0x3325D42E), UINT32_C(0x8592B544), UINT32_C(0x75E83A65),
          UINT32_C(0x2718628F), UINT32_C(0x524D1CE0)},
         {UINT32_C(0x3C584D76), UINT32_C(0x88A110EA), UINT32_C(0x4AC09AAC),
          UINT32_C(0x6B034AC4), UINT32_C(0x84FD3A36), UINT32_C(0x06488635),
          UINT32_C(0x87D944E1), UINT32_C(0x516F0EB0)}},
        {{UINT32_C(0xDF11D0BB), UINT32_C(0xE2016DA0), UINT32_C(0xB01F6540),
          UINT32_C(0xB34EB471), UINT32_C(0x165CBB24), UINT32_C(0x13E3D330),
          UINT32_C(0x7CF7F676), UINT32_C(0x3E755D11)},
         {UINT32_C(0x4FEA9A69), UINT32_C(0xD70CF4F8), UINT32_C(0xD18F4337),
          UINT32_C(0x98F59E0A), UINT32_C(0x826344BA), UINT32_C(0x7CCE7CE6),
          UINT32_C(0xF4004BBE), UINT32_C(0x30D129D7)}},
        {{UINT32_C(0xBA9CB975), UINT32_C(0x016EF317), UINT32_C(0xE4B3AB4D),
          UINT32_C(0x8EEBED19), UINT32_C(0x170A2570), UINT32_C(0x8C597DF0),
          UINT32_C(0x5BE6DE70), UINT32_C(0x451538D8)},
         {UINT32_C(0x7A64792F), UINT32_C(0x6C711DAC), UINT32_C(0x217EC8FB),
          UINT32_C(0x8F1896EB), UINT32_C(0x7FE18DED), UINT32_C(0x82E9C20B),
          UINT32_C(0xB0C5F622), UINT32_C(0x6CEBF4A7)}},
        {{UINT32_C(0x49CCC64F), UINT32_C(0xD9403EB5), UINT32_C(0x28B8A3FD),
          UINT32_C(0x807EBD56), UINT32_C(0x0F291E12), UINT32_C(0xF08BB659),
          UINT32_C(0x9C3F4432), UINT32_C(0x020D13E3)},
         {UINT32_C(0x752BB92E), UINT32_C(0xDA247896), UINT32_C(0x86EAFA7A),
          UINT32_C(0x99541794), UINT32_C(0x274E36AD), UINT32_C(0x213E94BA),
          UINT32_C(0x61A71333), UINT32_C(0x4CC0F1FB)}},
        {{UINT32_C(0x06478801), UINT32_C(0x19CC11BD), UINT32_C(0x6D18216A),
          UINT32_C(0x1251562A), UINT32_C(0xCDD307FC), UINT32_C(0x7A5F06BB),
          UINT32_C(0xFAA9CA2A), UINT32_C(0x4285F6AB)},
         {UINT32_C(0x81258996), UINT32_C(0x5A922831), UINT32_C(0x27B8B018),
          UINT32_C(0x8F7CF8EE), UINT32_C(0x7F81A62D), UINT32_C(0xF030BEF3),
          UINT32_C(0xCD4FD4E7), UINT32_C(0x417ACBC1)}},
        {{UINT32_C(0xEC64412F), UINT32_C(0xCFB0EA58), UINT32_C(0x6091E621),
          UINT32_C(0x9547B64A), UINT32_C(0xFD0C9815), UINT32_C(0x5EA49C7E),
          UINT32_C(0xE78B355C), UINT32_C(0x6789055A)},
         {UINT32_C(0x77E9A73A), UINT32_C(0x8D743E98), UINT32_C(0x2EA3FA49),
          UINT32_C(0xB032EA6A), UINT32_C(0xCEAAA33A), UINT32_C(0x52EA3801),
          UINT32_C(0xF2C3E22B), UINT32_C(0x73B3BB8D)}},
        {{UINT32_C(0x7DB9E301), UINT32_C(0xAA2A1291), UINT32_C(0xA1293DD7),
          UINT32_C(0x7F29770F), UINT32_C(0x59683DEC), UINT32_C(0x3135BB21),
          UINT32_C(0x7785B505), UINT32_C(0x070F8DF7)},
         {UINT32_C(0x37F53677), UINT32_C(0x8F2158EA), UINT32_C(0xABE1AF1C),
          UINT32_C(0x96CC7B9D), UINT32_C(0x6D6477D6), UINT32_C(0x7F977915),
          UINT32_C(0xDF370EAF), UINT32_C(0x55DB3922)}},
        {{UINT32_C(0xA9DAC7AE), UINT32_C(0x3028C03A), UINT32_C(0xBAE06BE0),
          UINT32_C(0x16F7DF0D), UINT32_C(0x410D57D9), UINT32_C(0x09548398),
          UINT32_C(0x1510D51F), UINT32_C(0x5E9C7F43)},
         {UINT32_C(0xD07717B3), UINT32_C(0x033B9BE2), UINT32_C(0xEF08AB91),
          UINT32_C(0x0D5D8116), UINT32_C(0xEEEFE88F), UINT32_C(0xD5A172B1),
          UINT32_C(0x0996294E), UINT32_C(0x72B1D29F)}},
        {{UINT32_C(0xE4D0965C), UINT32_C(0x9E2B79FB), UINT32_C(0xF49D8B8E),
          UINT32_C(0x01F403EE), UINT32_C(0xCEB12D6A), UINT32_C(0xBD4D2D48),
          UINT32_C(0x11FB24FB), UINT32_C(0x4D04DD9A)},
         {UINT32_C(0xE5C8D24C), UINT32_C(0x7E613EC5), UINT32_C(0xB918E543),
          UINT32_C(0x568BEFE8), UINT32_C(0xE966DF28), UINT32_C(0xD6456D1E),
          UINT32_C(0xBAFC71E2), UINT32_C(0x2DDEAD63)}},
        {{UINT32_C(0x448D72E9), UINT32_C(0x1D794F92), UINT32_C(0xE7E62BF2),
          UINT32_C(0x3978052E), UINT32_C(0xE2B92538), UINT32_C(0xF6C7A72E),
          UINT32_C(0x6EF321F0), UINT32_C(0x43879A88)},
         {UINT32_C(0x34F6FFBC), UINT32_C(0x2A823140), UINT32_C(0x35F4C485),
          UINT32_C(0x26F84E51), UINT32_C(0x028BFA7E), UINT32_C(0xDEE65540),
          UINT32_C(0x5F033058), UINT32_C(0x56216E9D)}},
        {{UINT32_C(0xCBC772EE), UINT32_C(0x31CA5470), UINT32_C(0x811BB5D0),
          UINT32_C(0xD3621E11), UINT32_C(0x70863D71), UINT32_C(0x501C4C47),
          UINT32_C(0xD28D6BDD), UINT32_C(0x0564518E)},
         {UINT32_C(0xD35B64B9), UINT32_C(0x60E3B89B), UINT32_C(0x6621A688),
          UINT32_C(0xB4F2599A), UINT32_C(0x3B5E116D), UINT32_C(0x1A8C4508),
          UINT32_C(0xFABF3125), UINT32_C(0x633EF5CC)}},
        {{UINT32_C(0x5D4FF62A), UINT32_C(0x0DB1D251), UINT32_C(0x4B17D658),
          UINT32_C(0x6CBD00EB), UINT32_C(0xFA1DB737), UINT32_C(0x2FA38212),
          UINT32_C(0x93A7FA03), UINT32_C(0x07B18CB8)},
         {UINT32_C(0x548E5F82), UINT32_C(0x531E47EF), UINT32_C(0x8276963C),
          UINT32_C(0xAE7B94FD), UINT32_C(0x6181A13A), UINT32_C(0x8055D82A),
          UINT32_C(0x23B6E361), UINT32_C(0x5725B512)}},
        {{UINT32_C(0x6D8B1FFE), UINT32_C(0xD84C7041), UINT32_C(0x5D994200),
          UINT32_C(0xF68ACA0B), UINT32_C(0x6BB908E2), UINT32_C(0x32BF9944),
          UINT32_C(0x1AD88DB1), UINT32_C(0x1240A3E6)},
         {UINT32_C(0xA92B6472), UINT32_C(0xB0BE96AA), UINT32_C(0xA1B7726C),
          UINT32_C(0xEF88A155), UINT32_C(0x9349F496), UINT32_C(0x000FD9ED),
          UINT32_C(0x454A05D9), UINT32_C(0x377DCBAD)}},
    },
    {
        {{UINT32_C(0xC04111D2), UINT32_C(0xD0A092CD), UINT32_C(0x338F06D6),
          UINT32_C(0x5C43A94C), UINT32_C(0x25E964F3), UINT32_C(0x697B4C26),
          UINT32_C(0x7572CCFD), UINT32_C(0x2CD5A059)},
         {UINT32_C(0xB5B523E4), UINT32_C(0xA09FC4D4), UINT32_C(0x4E1E9042),
          UINT32_C(0x7D8141E8), UINT32_C(0xD637409E), UINT32_C(0x2462512B),
          UINT32_C(0x7CB2CE75), UINT32_C(0x503F032F)}},
        {{UINT32_C(0xBCBF1450), UINT32_C(0xC56F38E3), UINT32_C(0xCF2E5594),
          UINT32_C(0x09F4FC77), UINT32_C(0x0FCB653A), UINT32_C(0xF449C3E6),
          UINT32_C(0x64A53C65), UINT32_C(0x6A1FE752)},
         {UINT32_C(0x7C039488), UINT32_C(0xFF366FED), UINT32_C(0x8C99A6CB),
          UINT32_C(0x23F58BA5), UINT32_C(0x8D67F6D6), UINT32_C(0x4B5546C6),
          UINT32_C(0x178B1668), UINT32_C(0x03405C85)}},
        {{UINT32_C(0xC0C86696), UINT32_C(0x969F1B33), UINT32_C(0x13746468),
          UINT32_C(0x9346D06C), UINT32_C(0xAE0C6D62), UINT32_C(0x68AED3C8),
          UINT32_C(0x74FE63D5), UINT32_C(0x7B3D5361)},
         {UINT32_C(0xC4F4B65D), UINT32_C(0xFEE8416B), UINT32_C(0x554C6D0A),
          UINT32_C(0xC79BF488), UINT32_C(0xDC402BB0), UINT32_C(0x191D5D27),
          UINT32_C(0xE087EB9F), UINT32_C(0x31B00167)}},
        {{UINT32_C(0xE05D281F), UINT32_C(0xD5FE0979), UINT32_C(0x3485446B),
          UINT32_C(0x8373AB50), UINT32_C(0x9223681F), UINT32_C(0xCE5258BA),
          UINT32_C(0xA37BF244), UINT32_C(0x5F82843E)},
         {UINT32_C(0xCFC16536), UINT32_C(0x94ED780B), UINT32_C(0xBD477733),
          UINT32_C(0x6A9739B3), UINT32_C(0xA04A4195), UINT32_C(0x137D68F2),
          UINT32_C(0x0032BFCE), UINT32_C(0x3A0F27E8)}},
        {{UINT32_C(0x358382F9), UINT32_C(0x7EADE421), UINT32_C(0x92E3D912),
          UINT32_C(0x490B9CA6), UINT32_C(0xF1AFBC2A), UINT32_C(0x040CE73E),
          UINT32_C(0x11AE91BA), UINT32_C(0x5745D473)},
         {UINT32_C(0xCE303B77), UINT32_C(0x625BED61), UINT32_C(0x85B03A1D),
          UINT32_C(0x85B2A1EB), UINT32_C(0x3D7C02E0), UINT32_C(0x764F62E4),
          UINT32_C(0xA7AF6DDE), UINT32_C(0x22C2D16F)}},
        {{UINT32_C(0xD19377BE), UINT32_C(0x5B985DE6), UINT32_C(0xD8E43A10),
          UINT32_C(0x0AF85A06), UINT32_C(0x0519F4C6), UINT32_C(0x1465E504),
          UINT32_C(0xE3E20BA3), UINT32_C(0x5DA01665)},
         {UINT32_C(0x675D9E2A), UINT32_C(0xCD9B8E9B), UINT32_C(0x6448A2CD),
          UINT32_C(0x4C77E1AD), UINT32_C(0x1E5D4465), UINT32_C(0xD6094BAD),
          UINT32_C(0xC50DB788), UINT32_C(0x4C352951)}},
        {{UINT32_C(0xEE5AB903), UINT32_C(0x42581152), UINT32_C(0x63311418),
          UINT32_C(0xDAD2DBC9), UINT32_C(0xB885E56A), UINT32_C(0xBCA4F70B),
          UINT32_C(0xB94E0876), UINT32_C(0x1F5DD363)},
         {UINT32_C(0x3FFF479E), UINT32_C(0xF9AD5D04), UINT32_C(0xFE06AD2B),
          UINT32_C(0xEF1176E5), UINT32_C(0x216F77AF), UINT32_C(0x46ACB00A),
          UINT32_C(0x857C4F78), UINT32_C(0x709CF4EB)}},
        {{UINT32_C(0xD0D2FF1C), UINT32_C(0x70CD666E), UINT32_C(0xE7EFE4AD),
          UINT32_C(0x4BAD4A6A), UINT32_C(0x0FA72024), UINT32_C(0xB43F6C2D),
          UINT32_C(0xE90C0617), UINT32_C(0x0D78F8E2)},
         {UINT32_C(0xF80DCAA7), UINT32_C(0x543B9662), UINT32_C(0xF28ADFAF),
          UINT32_C(0xB02FB3BC), UINT32_C(0xC51C54C3), UINT32_C(0x26C17651),
          UINT32_C(0x3D648D88), UINT32_C(0x0815F637)}},
        {{UINT32_C(0xAEA98FA6), UINT32_C(0xAC4F43C1), UINT32_C(0xAC4398C6),
          UINT32_C(0x2D223416), UINT32_C(0xDA5C5070), UINT32_C(0x48B2EEAD),
          UINT32_C(0xBE666F70), UINT32_C(0x632B65F1)},
         {UINT32_C(0x952021BE), UINT32_C(0x971D3BC0), UINT32_C(0x23B2C578),
          UINT32_C(0x9FDCB7E0), UINT32_C(0x3CC21796), UINT32_C(0x476D4715),
          UINT32_C(0x95832A94), UINT32_C(0x4015565F)}},
        {{UINT32_C(0x13CA725C), UINT32_C(0x8913AFAC), UINT32_C(0xDC18F0D9),
          UINT32_C(0xA56DC461), UINT32_C(0x10F3AAFE), UINT32_C(0xAC3AC720),
          UINT32_C(0xC628D69C), UINT32_C(0x5D75567E)},
         {UINT32_C(0xEEEA4BF7), UINT32_C(0xC11BE9DC), UINT32_C(0x1C193BD5),
          UINT32_C(0xAD97FBCA), UINT32_C(0xC58123E8), UINT32_C(0xD1EC5BCE),
          UINT32_C(0x9C73D4E5), UINT32_C(0x0F6DF930)}},
        {{UINT32_C(0xFD759FFD), UINT32_C(0xE80A0ADA), UINT32_C(0x239CAFC0),
          UINT32_C(0xE52DF94B), UINT32_C(0xFE7A43E9), UINT32_C(0x59640161),
          UINT32_C(0xDB1A38F0), UINT32_C(0x7A96995C)},
         {UINT32_C(0x7CD5011B), UINT32_C(0xA46A1503), UINT32_C(0xAC0E9689),
          UINT32_C(0x75CFB637), UINT32_C(0x97AAD2BA), UINT32_C(0x27B740CA),
          UINT32_C(0xEAD2F776), UINT32_C(0x64A0748B)}},
        {{UINT32_C(0x0625B3B1), UINT32_C(0xB67E5BB5), UINT32_C(0xC66D2832),
          UINT32_C(0x2FE19FFB), UINT32_C(0xF70C07CF), UINT32_C(0x47815666),
          UINT32_C(0xA43E52AB), UINT32_C(0x5A1AA24A)},
         {UINT32_C(0x4CAC0E66), UINT32_C(0x04EE11F8), UINT32_C(0x3A3A4836),
          UINT32_C(0x51E51583), UINT32_C(0xB44F6DEC), UINT32_C(0x46755F49),
          UINT32_C(0xC1E9B282), UINT32_C(0x6388408B)}},
        {{UINT32_C(0x9DE7A6A7), UINT32_C(0xD47AA9A6), UINT32_C(0x189BC9D2),
          UINT32_C(0xEC94AD9B), UINT32_C(0x8EC0E950), UINT32_C(0xFA89099D),
          UINT32_C(0x9F64D27F), UINT32_C(0x1B9FC206)},
         {UINT32_C(0x0B729DE1), UINT32_C(0x76572484), UINT32_C(0x4BE22EB8),
          UINT32_C(0xFE9E8E71), UINT32_C(0xF9DB5942), UINT32_C(0x910F0456),
          UINT32_C(0xC617D82B), UINT32_C(0x4D018459)}},
        {{UINT32_C(0xF5516C6F), UINT32_C(0xB082B58A), UINT32_C(0x567A8CF5),
          UINT32_C(0xFFBA0E73), UINT32_C(0x8A6DD4A0), UINT32_C(0x08FF64CE),
          UINT32_C(0x69A9F66A), UINT32_C(0x6CF3C89C)},
         {UINT32_C(0x62FEB0A7), UINT32_C(0x356782BA), UINT32_C(0x3E2907F9),
          UINT32_C(0x1A18720D), UINT32_C(0x0BBD9D92), UINT32_C(0xF840FFA3),
          UINT32_C(0x20926421), UINT32_C(0x41D9EECA)}},
        {{UINT32_C(0xB6B08321), UINT32_C(0xCF2E8AAC), UINT32_C(0x010D91C0),
          UINT32_C(0xC76FBE12), UINT32_C(0x68E35E02), UINT32_C(0x54924750),
          UINT32_C(0x9AEE00F8), UINT32_C(0x74DBA2E1)},
         {UINT32_C(0xC5504E82), UINT32_C(0x94C70D6D), UINT32_C(0xEA1770F7),
          UINT32_C(0x0BDF415F), UINT32_C(0x3CA6DB0A), UINT32_C(0xDA45B700),
          UINT32_C(0xE133A980), UINT32_C(0x473C6A04)}},
        {{UINT32_C(0x1E188071), UINT32_C(0xD1FF6C1E), UINT32_C(0xEA3F16F8),
          UINT32_C(0x621A7D3C), UINT32_C(0x6A160F47), UINT32_C(0x60467307),
          UINT32_C(0x32DC84EE), UINT32_C(0x37CA7D3D)},
         {UINT32_C(0x67DDFDB5), UINT32_C(0x54F5F7F6), UINT32_C(0x921BA04B),
          UINT32_C(0x3A8482F9), UINT32_C(0x1A28E238), UINT32_C(0x842F4950),
          UINT32_C(0x7214FAFD), UINT32_C(0x3A4DC917)}},
    },
    {
        {{UINT32_C(0xEEA25E82), UINT32_C(0xEDD8360C), UINT32_C(0xFB7B7ED0),
          UINT32_C(0x3DB6D933), UINT32_C(0xABF15199), UINT32_C(0x882F3C0B),
          UINT32_C(0x516E349D), UINT32_C(0x228664A2)},
         {UINT32_C(0xE88173DF), UINT32_C(0x96E6DCF7), UINT32_C(0xD7EC0BC3),
          UINT32_C(0x382C8D3B), UINT32_C(0x6FA5FA58), UINT32_C(0xFBFF6D21),
          UINT32_C(0x2F41C959), UINT32_C(0x78003980)}},
        {{UINT32_C(0x9D9ACF9C), UINT32_C(0x713BA43B), UINT32_C(0x94876559),
          UINT32_C(0xF59A252D), UINT32_C(0x437B8ED5), UINT32_C(0x8B310954),
          UINT32_C(0xE474E98E), UINT32_C(0x76A83790)},
         {UINT32_C(0xF6040B05), UINT32_C(0x84C1386A), UINT32_C(0xBF3D8189),
          UINT32_C(0x69FA9F43), UINT32_C(0xA98D4866), UINT32_C(0x5584164C),
          UINT32_C(0x3B9045D0), UINT32_C(0x6C89CE1D)}},
        {{UINT32_C(0xB522FB28), UINT32_C(0xD6EF7540), UINT32_C(0xBB28D745),
          UINT32_C(0xDB561B56), UINT32_C(0xEFA58B87), UINT32_C(0xC9F7543E),
          UINT32_C(0xE9062979), UINT32_C(0x5F02A23B)},
         {UINT32_C(0x6809D624), UINT32_C(0xFD3C0C19), UINT32_C(0xA92EB229),
          UINT32_C(0x94481554), UINT32_C(0xF5147EFB), UINT32_C(0x72D8EC53),
          UINT32_C(0x0D1BA626), UINT32_C(0x14302661)}},
        {{UINT32_C(0x89020800), UINT32_C(0x0B35BD59), UINT32_C(0x430D7DEB),
          UINT32_C(0x3C6F1527), UINT32_C(0x2FFFA0E0), UINT32_C(0x9BEB3C8E),
          UINT32_C(0xAFD09A19), UINT32_C(0x7E181B78)},
         {UINT32_C(0x3B2F0B49), UINT32_C(0xE82FD957), UINT32_C(0x0BC0F9DA),
          UINT32_C(0x4C9461B1), UINT32_C(0x2B1C8B85), UINT32_C(0x87D78C41),
          UINT32_C(0xC1F5BDA1), UINT32_C(0x775BED20)}},
        {{UINT32_C(0x16350593), UINT32_C(0x883AE89B), UINT32_C(0x0C19FEC8),
          UINT32_C(0x85D429CB), UINT32_C(0x5742C36D), UINT32_C(0x5938BDEC),
          UINT32_C(0xDA8A21B7), UINT32_C(0x2DDBC7EB)},
         {UINT32_C(0x07A2E700), UINT32_C(0xA249BDE4), UINT32_C(0xE8BD6215),
          UINT32_C(0x42A3897C), UINT32_C(0x732FF181), UINT32_C(0x87F30BA7),
          UINT32_C(0x1B912C57), UINT32_C(0x5385D709)}},
        {{UINT32_C(0x288041F5), UINT32_C(0x2B5C555B), UINT32_C(0x1F425866),
          UINT32_C(0xD3D90040), UINT32_C(0x02E0FA71), UINT32_C(0x37E40CD2),
          UINT32_C(0x3A386038), UINT32_C(0x08B37F26)},
         {UINT32_C(0x5DE1ED78), UINT32_C(0x165BD7FB), UINT32_C(0x0829ECC9),
          UINT32_C(0x22949E81), UINT32_C(0xBCE3D01F), UINT32_C(0xBB8705CC),
          UINT32_C(0x1D233CDF), UINT32_C(0x7961BE85)}},
        {{UINT32_C(0x7659B477), UINT32_C(0x5D3DBC6B), UINT32_C(0x50EF08EB),
          UINT32_C(0xFD865779), UINT32_C(0xF34EA1A5), UINT32_C(0x502729E8),
          UINT32_C(0xD2B64602), UINT32_C(0x1548526E)},
         {UINT32_C(0xB91D2675), UINT32_C(0xB13632FD), UINT32_C(0xF7B37397),
          UINT32_C(0x09A42003), UINT32_C(0xCCFC4532), UINT32_C(0x37D18F37),
          UINT32_C(0x73C7082C), UINT32_C(0x3FAEF63B)}},
        {{UINT32_C(0xE666DB6D), UINT32_C(0x3365445F), UINT32_C(0x339A0076),
          UINT32_C(0x9051FFF5), UINT32_C(0x9BD6D01D), UINT32_C(0x6167FB76),
          UINT32_C(0xCA087B41), UINT32_C(0x09737137)},
         {UINT32_C(0xB3270BA7), UINT32_C(0xCA2193AE), UINT32_C(0x8F2217B3),
          UINT32_C(0xEF0744C2), UINT32_C(0xF0DD10D8), UINT32_C(0x3E030D58),
          UINT32_C(0xCCB4F2F9), UINT32_C(0x667246DB)}},
        {{UINT32_C(0x3773EC8C), UINT32_C(0x31F3030E), UINT32_C(0x5AD56010),
          UINT32_C(0xAF2B3123), UINT32_C(0xB37E9062), UINT32_C(0xFC118587),
          UINT32_C(0x9C2D5406), UINT32_C(0x52840C2C)},
         {UINT32_C(0x6670ACBB), UINT32_C(0xA96D3DFF), UINT32_C(0x772EC6D3),
          UINT32_C(0xF469982F), UINT32_C(0xA9DF4C88), UINT32_C(0x5BE20628),
          UINT32_C(0x673633BC), UINT32_C(0x59D01479)}},
        {{UINT32_C(0xAFB5083B), UINT32_C(0xC9223750), UINT32_C(0x191C2160),
          UINT32_C(0xF1EB451E), UINT32_C(0xA38EC005), UINT32_C(0x0D913794),
          UINT32_C(0x83FD1D18), UINT32_C(0x31062E9E)},
         {UINT32_C(0x5F4816AD), UINT32_C(0x070538F5), UINT32_C(0x925F5DA1),
          UINT32_C(0x90D4855D), UINT32_C(0x22F455B6), UINT32_C(0xC0BBA87B),
          UINT32_C(0xF48D2AE5), UINT32_C(0x517B5F80)}},
        {{UINT32_C(0x3F4FA7CA), UINT32_C(0x0D8B670A), UINT32_C(0x3D114EB2),
          UINT32_C(0xE29C8849), UINT32_C(0x916A187E), UINT32_C(0x1823780D),
          UINT32_C(0x65EE66A0), UINT32_C(0x6961C483)},
         {UINT32_C(0x62FDC12C), UINT32_C(0x2F6FB20A), UINT32_C(0x0CFDDE0C),
          UINT32_C(0x51414E5F), UINT32_C(0xDCA39073), UINT32_C(0x16BD56A7),
          UINT32_C(0x648FFD43), UINT32_C(0x0CFE6DAF)}},
        {{UINT32_C(0xAEBA9241), UINT32_C(0x3789F4CA), UINT32_C(0x107777C6),
          UINT32_C(0xE8056BC6), UINT32_C(0x3CB20826), UINT32_C(0x6EE564C3),
          UINT32_C(0x45448C69), UINT32_C(0x5DF36347)},
         {UINT32_C(0xB22CE624), UINT32_C(0xFD0FA84B), UINT32_C(0xAC753D50),
          UINT32_C(0x2AA19672), UINT32_C(0x677CC0D0), UINT32_C(0x29A1464F),
          UINT32_C(0x3CEF5493), UINT32_C(0x7C2237B1)}},
        {{UINT32_C(0x24255918), UINT32_C(0x87C2587C), UINT32_C(0x90B35A37),
          UINT32_C(0x9AA89A0B), UINT32_C(0x10E7CAEF), UINT32_C(0x9932EB78),
          UINT32_C(0xCDE31568), UINT32_C(0x49278F16)},
         {UINT32_C(0x41188ED9), UINT32_C(0xA4D33C61), UINT32_C(0x05AC3A1D),
          UINT32_C(0xC587BDE0), UINT32_C(0x7248B5E0), UINT32_C(0x2A5C5ACC),
          UINT32_C(0x8510D2CB), UINT32_C(0x60026A1D)}},
        {{UINT32_C(0x6BAF603C), UINT32_C(0xE57CB0C9), UINT32_C(0xAB770AF0),
          UINT32_C(0x527F28A6), UINT32_C(0x016F2BC1), UINT32_C(0x2850D8E6),
          UINT32_C(0x936DC2EC), UINT32_C(0x0EC2A46C)},
         {UINT32_C(0xD4F23FC2), UINT32_C(0xA0BC5306), UINT32_C(0x53A0130F),
          UINT32_C(0x6DBEDA26), UINT32_C(0xEE3314B7), UINT32_C(0xB1D52F87),
          UINT32_C(0x6C234CF5), UINT32_C(0x17168B12)}},
        {{UINT32_C(0xDADF17D5), UINT32_C(0x8B8BC181), UINT32_C(0xFAFFA918),
          UINT32_C(0x31EC3CAD), UINT32_C(0x274E4658), UINT32_C(0x4611A482),
          UINT32_C(0x73D35EAD), UINT32_C(0x5A9E3652)},
         {UINT32_C(0xF4028FC7), UINT32_C(0xBA68825B), UINT32_C(0x62E203F5),
          UINT32_C(0x142859D5), UINT32_C(0x1C817A9E), UINT32_C(0xCE516AC4),
          UINT32_C(0x57223F8D), UINT32_C(0x42014682)}},
        {{UINT32_C(0xB4B66798), UINT32_C(0x51FBFB2E), UINT32_C(0x0EA9C4EF),
          UINT32_C(0x3A3F1591), UINT32_C(0xE8814805), UINT32_C(0x3FD3D026),
          UINT32_C(0xB0C8DFD0), UINT32_C(0x3CA531E4)},
         {UINT32_C(0xE585A960), UINT32_C(0x69A6B3F8), UINT32_C(0xBD3F567D),
          UINT32_C(0x1627CC77), UINT32_C(0x5DB9CFD0), UINT32_C(0x6F4EF430),
          UINT32_C(0x8D02278A), UINT32_C(0x05B56707)}},
    },
    {
        {{UINT32_C(0x10B96338), UINT32_C(0x6663F2F3), UINT32_C(0xCE8CA31C),
          UINT32_C(0x69373D1F), UINT32_C(0xD67AEC10), UINT32_C(0x3D31C5CF),
          UINT32_C(0x16F2547E), UINT32_C(0x2FAF5545)},
         {UINT32_C(0x1EA2EA64), UINT32_C(0xF6E397D5), UINT32_C(0xEEAEBE7A),
          UINT32_C(0x2281A0DF), UINT32_C(0xFA2527EC), UINT32_C(0x72E53254),
          UINT32_C(0x76432155), UINT32_C(0x660D059A)}},
        {{UINT32_C(0x2C66D937), UINT32_C(0xD3CA8B13), UINT32_C(0xCD2DF849),
          UINT32_C(0xC6F34B08), UINT32_C(0xA23A9F73), UINT32_C(0x9AF2C9E3),
          UINT32_C(0x702388E9), UINT32_C(0x24D44BD9)},
         {UINT32_C(0xD1B3DA10), UINT32_C(0x8DA4D6A4), UINT32_C(0x40B93B10),
          UINT32_C(0xB9FAFBF4), UINT32_C(0xEFCFD2A3), UINT32_C(0xBBE51BB3),
          UINT32_C(0x1844581D), UINT32_C(0x68BE0395)}},
        {{UINT32_C(0x0EA1FAE1), UINT32_C(0xDECABD8C), UINT32_C(0xFDFED7C2),
          UINT32_C(0xA7499225), UINT32_C(0xFB468B83), UINT32_C(0x08489E35),
          UINT32_C(0x43D95F9C), UINT32_C(0x5B689344)},
         {UINT32_C(0x9D2F522E), UINT32_C(0x9FC8364A), UINT32_C(0x3A5D27A4),
          UINT32_C(0x114DB31A), UINT32_C(0xE33A9EC8), UINT32_C(0xC6A35992),
          UINT32_C(0xDC9ACAF6), UINT32_C(0x6FE9EC3B)}},
        {{UINT32_C(0xDEAFC64C), UINT32_C(0x98AE2D66), UINT32_C(0xABE706B7),
          UINT32_C(0x95AAC8EF), UINT32_C(0x223DFA3B), UINT32_C(0xB15A6604),
          UINT32_C(0xE24B43CB), UINT32_C(0x77DBC24A)},
         {UINT32_C(0x8542FA2A), UINT32_C(0x65D6F871), UINT32_C(0x5D326A1A),
          UINT32_C(0x1093B273), UINT32_C(0xF137AFEF), UINT32_C(0xBA82D607),
          UINT32_C(0xB9DEA6A7), UINT32_C(0x502B32E3)}},
        {{UINT32_C(0x885CA6CE), UINT32_C(0x88906BD6), UINT32_C(0x1D36BFEE),
          UINT32_C(0x136ADF9A), UINT32_C(0x09AA61E3), UINT32_C(0xF844088C),
          UINT32_C(0x51BAC299), UINT32_C(0x4E508EA3)},
         {UINT32_C(0xEB821936), UINT32_C(0x251ACD26), UINT32_C(0x43D90E10),
          UINT32_C(0xDF6AD7D5), UINT32_C(0xDE7F14B9), UINT32_C(0xEBCD7046),
          UINT32_C(0xAB503259), UINT32_C(0x1DB258B1)}},
        {{UINT32_C(0x90AD5D55), UINT32_C(0x348E3018), UINT32_C(0x7067806A),
          UINT32_C(0x0EF6BE73), UINT32_C(0x41627FCC), UINT32_C(0x072C1134),
          UINT32_C(0xE904F823), UINT32_C(0x48EE7606)},
         {UINT32_C(0xD9FD5EF3), UINT32_C(0xEE6AB582), UINT32_C(0x17AB50BC),
          UINT32_C(0x57765D03), UINT32_C(0xFB7DEC68), UINT32_C(0x1CCFB407),
          UINT32_C(0x141DF51D), UINT32_C(0x2E1771C7)}},
        {{UINT32_C(0xA013284B), UINT32_C(0xCBDD6235), UINT32_C(0x20D07125),
          UINT32_C(0x4D93FD87), UINT32_C(0xD485418E), UINT32_C(0xB3D055B3),
          UINT32_C(0xC67ADD2D), UINT32_C(0x4EFB8763)},
         {UINT32_C(0x1B2DF427), UINT32_C(0xEC369382), UINT32_C(0x64D0DDF4),
          UINT32_C(0x25009791), UINT32_C(0x163056C8), UINT32_C(0x9BD42FFC),
          UINT32_C(0x5B88BEBA), UINT32_C(0x60527792)}},
        {{UINT32_C(0x9D82DADF), UINT32_C(0x6D5D6A86), UINT32_C(0x7C24A1CA),
          UINT32_C(0xC3BA9A16), UINT32_C(0x2E6981CC), UINT32_C(0x838167EC),
          UINT32_C(0x7E1E4237), UINT32_C(0x7FB5D857)},
         {UINT32_C(0x86A40BC7), UINT32_C(0x83B2C2FC), UINT32_C(0x6F9AC4FB),
          UINT32_C(0x679D2DFC), UINT32_C(0xE45455EF), UINT32_C(0x0B3714CD),
          UINT32_C(0x394A7797), UINT32_C(0x1C8D833D)}},
        {{UINT32_C(0x4E641C9D), UINT32_C(0x1FBF8961), UINT32_C(0xD951DFC8),
          UINT32_C(0x3330DAB0), UINT32_C(0x051D96DB), UINT32_C(0x9D4EBA4D),
          UINT32_C(0x23066924), UINT32_C(0x27C6DBF0)},
         {UINT32_C(0xDA5D1D79), UINT32_C(0xB950C648), UINT32_C(0x5E9CD783),
          UINT32_C(0x544D46BA), UINT32_C(0xE69BA3EF), UINT32_C(0xFA77226F),
          UINT32_C(0xE4DA8423), UINT32_C(0x0A93D219)}},
        {{UINT32_C(0x5BDCA76B), UINT32_C(0x7C377CC6), UINT32_C(0xDC58D194),
          UINT32_C(0x7DF505D7), UINT32_C(0x13E389E1), UINT32_C(0x18A24C0B),
          UINT32_C(0x6C3972FD), UINT32_C(0x5E0782DD)},
         {UINT32_C(0x6680FCE1), UINT32_C(0x97AD477E), UINT32_C(0x3CBAB792),
          UINT32_C(0x6B07BF22), UINT32_C(0xDC68C9E2), UINT32_C(0xB8DF3C73),
          UINT32_C(0xC04B2749), UINT32_C(0x33AB5A4C)}},
        {{UINT32_C(0x7E79B5A7), UINT32_C(0xD151C762), UINT32_C(0xC82C7B8A),
          UINT32_C(0xA4356B79), UINT32_C(0x96E0A2E2), UINT32_C(0x931DDDE8),
          UINT32_C(0x52C54FDC), UINT32_C(0x40378EB2)},
         {UINT32_C(0x40C24003), UINT32_C(0xA6BBD5E3), UINT32_C(0x65C34FEA),
          UINT32_C(0xB4F3246E), UINT32_C(0x9C767A23), UINT32_C(0x780B21ED),
          UINT32_C(0x52BD7E83), UINT32_C(0x5F1E95FE)}},
        {{UINT32_C(0xCF39F9C4), UINT32_C(0x4F3453DF), UINT32_C(0xB8CC2CA6),
          UINT32_C(0xA3E1CFD1), UINT32_C(0x4B898859), UINT32_C(0xE49BC49C),
          UINT32_C(0x6C0BF055), UINT32_C(0x4FFD7BD6)},
         {UINT32_C(0xD139AD1B), UINT32_C(0x7DE7604C), UINT32_C(0x2A3CE8FE),
          UINT32_C(0x6973F5EB), UINT32_C(0xF9501ECC), UINT32_C(0xAC66FF97),
          UINT32_C(0xA97D46CD), UINT32_C(0x3D96F1E2)}},
        {{UINT32_C(0x6106EB96), UINT32_C(0x70D5A0D0), UINT32_C(0x398C1FD9),
          UINT32_C(0x938E038F), UINT32_C(0x1F3A1AA9), UINT32_C(0xE66B7007),
          UINT32_C(0xF5BD9308), UINT32_C(0x42BDB264)},
         {UINT32_C(0x5AF84957), UINT32_C(0x4B3FD754), UINT32_C(0x4E27DC6B),
          UINT32_C(0x9E3E17FA), UINT32_C(0x51D8560B), UINT32_C(0x384FCACD),
          UINT32_C(0xF8068C09), UINT32_C(0x42F00D11)}},
        {{UINT32_C(0x7D5897D5), UINT32_C(0x794C1E6A), UINT32_C(0xDF72DCA0),
          UINT32_C(0x4901097F), UINT32_C(0x0B01E4C4), UINT32_C(0xDED5B192),
          UINT32_C(0x26DD41E9), UINT32_C(0x364FF582)},
         {UINT32_C(0x32FCA925), UINT32_C(0xA3F92DCC), UINT32_C(0x207AA09A),
          UINT32_C(0x8A1FB329), UINT32_C(0xF512AE3A), UINT32_C(0xA9274BD3),
          UINT32_C(0xC47B9007), UINT32_C(0x161C82BC)}},
        {{UINT32_C(0x7AE1175F), UINT32_C(0x482ECE3B), UINT32_C(0xBDD5DC6C),
          UINT32_C(0x97CAC7E8), UINT32_C(0x9FDA910D), UINT32_C(0x56225309),
          UINT32_C(0x9FC206B9), UINT32_C(0x52A9893B)},
         {UINT32_C(0x05BB5ACA), UINT32_C(0xAD9F2A92), UINT32_C(0xA3B65716),
          UINT32_C(0xB9EEFB5B), UINT32_C(0x8DB5A8D4), UINT32_C(0xE7BC173B),
          UINT32_C(0x399DAE9E), UINT32_C(0x6715EC64)}},
        {{UINT32_C(0x5E41AC75), UINT32_C(0x780796D1), UINT32_C(0x4FB3A0B4),
          UINT32_C(0x3E165C78), UINT32_C(0x237103E9), UINT32_C(0x198599BA),
          UINT32_C(0xFA7ED86B), UINT32_C(0x2C04C3F5)},
         {UINT32_C(0xAC9356F0), UINT32_C(0x29547DA8), UINT32_C(0x79EADA37),
          UINT32_C(0xCB345AB4), UINT32_C(0xA295BF2D), UINT32_C(0x1D15D377),
          UINT32_C(0x2FDC8131), UINT32_C(0x10292C9D)}},
    },
    {
        {{UINT32_C(0x40E1DC7E), UINT32_C(0xADF3B547), UINT32_C(0x1C345D14),
          UINT32_C(0x420CE2DD), UINT32_C(0x21DC5C2D), UINT32_C(0xC08E3CBE),
          UINT32_C(0x6F8FCE80), UINT32_C(0x79FDC000)},
         {UINT32_C(0xCB105CE7), UINT32_C(0x23EBDF7F), UINT32_C(0x7C6794A8),
          UINT32_C(0x793FC99D), UINT32_C(0x293E3575), UINT32_C(0x4CA3FB21),
          UINT32_C(0x7BF73CC8), UINT32_C(0x7FB2ACB9)}},
        {{UINT32_C(0x0FC8FCD4), UINT32_C(0x67DB6C90), UINT32_C(0x7EE3B705),
          UINT32_C(0x22A3DF5F), UINT32_C(0xC7B2EDFF), UINT32_C(0xD50EBF8B),
          UINT32_C(0x99522FB7), UINT32_C(0x0C701045)},
         {UINT32_C(0xAD4F9044), UINT32_C(0x1420CF02), UINT32_C(0xE5B59451),
          UINT32_C(0xD78DBA23), UINT32_C(0x6AEFD853), UINT32_C(0xDFDC1C7F),
          UINT32_C(0xDEA1DAAB), UINT32_C(0x560DEE94)}},
        {{UINT32_C(0x2167A78B), UINT32_C(0x0F235513), UINT32_C(0x9F441927),
          UINT32_C(0xCF463702), UINT32_C(0xA3D1505C), UINT32_C(0xD0AE2723),
          UINT32_C(0xCD9FBFF4), UINT32_C(0x3149D858)},
         {UINT32_C(0xF79240FA), UINT32_C(0x2A73913A), UINT32_C(0x252A958B),
          UINT32_C(0xC904A575), UINT32_C(0x78473D97), UINT32_C(0x10D18190),
          UINT32_C(0x203BC8C4), UINT32_C(0x42CE7A38)}},
        {{UINT32_C(0xFA59BB8B), UINT32_C(0x1D2AD4F2), UINT32_C(0x79F137DD),
          UINT32_C(0x8234964C), UINT32_C(0x5D02679E), UINT32_C(0x00B63A30),
          UINT32_C(0x5DD7543D), UINT32_C(0x506C45BE)},
         {UINT32_C(0x776BF80C), UINT32_C(0x4378F900), UINT32_C(0xB312F2BB),
          UINT32_C(0x179558B2), UINT32_C(0xEA37C183), UINT32_C(0x5B15368C),
          UINT32_C(0xB198E42D), UINT32_C(0x7593B19F)}},
        {{UINT32_C(0xDEFA1F48), UINT32_C(0xED723535), UINT32_C(0x87F96EE5),
          UINT32_C(0x0DAFC48B), UINT32_C(0x91B1B52C), UINT32_C(0x0AEFA3BA),
          UINT32_C(0xA1ADBEA4), UINT32_C(0x56BA1B33)},
         {UINT32_C(0x30A6C905), UINT32_C(0x8A0B6170), UINT32_C(0xB272D12E),
          UINT32_C(0xC5BA3518), UINT32_C(0x4B6643A9), UINT32_C(0x782100CF),
          UINT32_C(0x85C5BD2B), UINT32_C(0x12DEE803)}},
        {{UINT32_C(0x78FCADD6), UINT32_C(0xDD07D2D5), UINT32_C(0x3B25C523),
          UINT32_C(0x8CB8E8A8), UINT32_C(0x530919CF), UINT32_C(0x25063508),
          UINT32_C(0x1E24F7A1), UINT32_C(0x45D3DD54)},
         {UINT32_C(0x49DDAF96), UINT32_C(0x296AE893), UINT32_C(0xACE559F5),
          UINT32_C(0x7EF3CDE0), UINT32_C(0x0D36F87B), UINT32_C(0x9CDF22E4),
          UINT32_C(0x4AC9A845), UINT32_C(0x19684765)}},
        {{UINT32_C(0xC597B7AE), UINT32_C(0x3955B5AB), UINT32_C(0x3AB49731),
          UINT32_C(0x59F3BA05), UINT32_C(0xF525C6C8), UINT32_C(0xBCA5B117),
          UINT32_C(0x32050B8D), UINT32_C(0x4969C134)},
         {UINT32_C(0x970E8E49), UINT32_C(0x353183D9), UINT32_C(0xE95300CF),
          UINT32_C(0x3D005213), UINT32_C(0x09022378), UINT32_C(0x595F9C8E),
          UINT32_C(0x1A445C28), UINT32_C(0x70FA8B47)}},
        {{UINT32_C(0xBADB79EA), UINT32_C(0xECC88EE3), UINT32_C(0xFBD8464E),
          UINT32_C(0x5BDAF68C), UINT32_C(0xB4280334), UINT32_C(0x24AF6A4C),
          UINT32_C(0x398E5BBE), UINT32_C(0x17A5DE8B)},
         {UINT32_C(0x92999E18), UINT32_C(0x300B6DEB), UINT32_C(0x67DEFC2F),
          UINT32_C(0xA0766918), UINT32_C(0xB19F87FF), UINT32_C(0x4E904450),
          UINT32_C(0xC2871056), UINT32_C(0x3010AD94)}},
        {{UINT32_C(0x461EFCC3), UINT32_C(0x72E747A1), UINT32_C(0x562F923E),
          UINT32_C(0x329EDF18), UINT32_C(0xD081A4E7), UINT32_C(0x65E021D4),
          UINT32_C(0xB727B6F4), UINT32_C(0x4B2DBFFF)},
         {UINT32_C(0x9C8505AC), UINT32_C(0x5A597A80), UINT32_C(0x562B82D2),
          UINT32_C(0x13486480), UINT32_C(0xCC8234C3), UINT32_C(0x477FD480),
          UINT32_C(0x04800C00), UINT32_C(0x6045ABA4)}},
        {{UINT32_C(0x9C541035), UINT32_C(0x3E087439), UINT32_C(0x6D9D8B6A),
          UINT32_C(0x389AA76C), UINT32_C(0x36A21299), UINT32_C(0x68FE5E83),
          UINT32_C(0x402A32CF), UINT32_C(0x67AC313D)},
         {UINT32_C(0x25501A53), UINT32_C(0x996131D2), UINT32_C(0xA77A85F4),
          UINT32_C(0x5C1B89DE), UINT32_C(0xED6702AD), UINT32_C(0xA9822C84),
          UINT32_C(0x56609EA0), UINT32_C(0x50F014A4)}},
        {{UINT32_C(0xE5A8E91E), UINT32_C(0xF0F8B4E6), UINT32_C(0x1A2FFEFD),
          UINT32_C(0x734CFF08), UINT32_C(0x27BCB163), UINT32_C(0x9724EE0B),
          UINT32_C(0x30B8EF68), UINT32_C(0x6AF3808B)},
         {UINT32_C(0x126E88FC), UINT32_C(0xE5B3829F), UINT32_C(0x4EE5FD4B),
          UINT32_C(0x0F441EE3), UINT32_C(0xBFEC4D34), UINT32_C(0x534D2F8C),
          UINT32_C(0x076E6737), UINT32_C(0x3E1F16DE)}},
        {{UINT32_C(0x4ED36E6A), UINT32_C(0x4DB53E8A), UINT32_C(0x4352B22F),
          UINT32_C(0x49A9EFE9), UINT32_C(0x39CF005C), UINT32_C(0x7829605C),
          UINT32_C(0xD85DB959), UINT32_C(0x190A8E16)},
         {UINT32_C(0x9B073AB3), UINT32_C(0x69981069), UINT32_C(0x8C141AA1),
          UINT32_C(0x8C264B87), UINT32_C(0x603ED47C), UINT32_C(0x7F614282),
          UINT32_C(0x9F9B0940), UINT32_C(0x21FD2E7A)}},
        {{UINT32_C(0x1EC6BB3D), UINT32_C(0xC5CA10A0), UINT32_C(0x27A9B02B),
          UINT32_C(0x9403E3F5), UINT32_C(0xFB43F790), UINT32_C(0x9D3D186D),
          UINT32_C(0x67DC0C00), UINT32_C(0x7855276E)},
         {UINT32_C(0xFFFFB14C), UINT32_C(0x053DBB2A), UINT32_C(0x43ACC0A6),
          UINT32_C(0x26746663), UINT32_C(0x7FFC1C68), UINT32_C(0x1EE7A946),
          UINT32_C(0x56DBB0DE), UINT32_C(0x14BFAF01)}},
        {{UINT32_C(0x849EA674), UINT32_C(0x11C89A47), UINT32_C(0x94A540E6),
          UINT32_C(0x194FAAF0), UINT32_C(0x6050E4C0), UINT32_C(0xE61163F8),
          UINT32_C(0xB1A07B76), UINT32_C(0x6939A166)},
         {UINT32_C(0x2EF18325), UINT32_C(0x8166CA8E), UINT32_C(0x30C042E2),
          UINT32_C(0x96112E65), UINT32_C(0x5A394C25), UINT32_C(0xA805CAE0),
          UINT32_C(0x0392E6BB), UINT32_C(0x45A0DE01)}},
        {{UINT32_C(0xB4FAAA56), UINT32_C(0xB89CEE96), UINT32_C(0x529736DE),
          UINT32_C(0x7A7DC8AE), UINT32_C(0xA727FCF7), UINT32_C(0x9158AA49),
          UINT32_C(0x1896B9DA), UINT32_C(0x621B8B31)},
         {UINT32_C(0x03BEC74B), UINT32_C(0x875930D6), UINT32_C(0xA7A50309),
          UINT32_C(0x1056DB45), UINT32_C(0xB5657B0E), UINT32_C(0xEE713E04),
          UINT32_C(0x6FCAD967), UINT32_C(0x2D68155E)}},
        {{UINT32_C(0x65B1E2B3), UINT32_C(0x3BB1E9E3), UINT32_C(0x88425BAB),
          UINT32_C(0x2A615670), UINT32_C(0x62F1BA4A), UINT32_C(0x22F4F32F),
          UINT32_C(0x88A59642), UINT32_C(0x7B5EC250)},
         {UINT32_C(0x42D30049), UINT32_C(0x7B5BA12A), UINT32_C(0x86995BE6),
          UINT32_C(0x4E6AC055), UINT32_C(0x45EC87AC), UINT32_C(0x04431A04),
          UINT32_C(0xED94823D), UINT32_C(0x28974ED7)}},
    },
    {
        {{UINT32_C(0x12BB5555), UINT32_C(0x59258057), UINT32_C(0xBB7608EE),
          UINT32_C(0x03141CD8), UINT32_C(0xEF77714B), UINT32_C(0x84EBDC49),
          UINT32_C(0xB5DC1A5F), UINT32_C(0x6A45FC3A)},
         {UINT32_C(0x2FBEEC76), UINT32_C(0x1F6DC205), UINT32_C(0xA920C554),
          UINT32_C(0x17EB733B), UINT32_C(0x7A28ACDF), UINT32_C(0xDB022C21),
          UINT32_C(0xA9B62BF1), UINT32_C(0x6AF16156)}},
        {{UINT32_C(0x80B472CC), UINT32_C(0x9379D6A8), UINT32_C(0x7BD92F27),
          UINT32_C(0x6CB08CB0), UINT32_C(0x147E6E12), UINT32_C(0x19B3C353),
          UINT32_C(0x26827839), UINT32_C(0x3C26CB2F)},
         {UINT32_C(0x0CC571E4), UINT32_C(0x98AAC9A7), UINT32_C(0xC3C8FC04),
          UINT32_C(0x075D05F2), UINT32_C(0xD79621AC), UINT32_C(0x718B55A0),
          UINT32_C(0x5B94B41B), UINT32_C(0x149FEECF)}},
        {{UINT32_C(0x783F9C81), UINT32_C(0x6A150A64), UINT32_C(0x0FB18827),
          UINT32_C(0x5950C2DF), UINT32_C(0xF15E3A89), UINT32_C(0xF5D75504),
          UINT32_C(0xFCB4406B), UINT32_C(0x5F92F2F7)},
         {UINT32_C(0x6123E858), UINT32_C(0x665F31E7), UINT32_C(0xA95184A3),
          UINT32_C(0x4E568EA9), UINT32_C(0x505FF0AD), UINT32_C(0x851EEADC),
          UINT32_C(0x542C3EF8), UINT32_C(0x62AD5BA6)}},
        {{UINT32_C(0xC55C23FD), UINT32_C(0x1103859D), UINT32_C(0x695E4E9B),
          UINT32_C(0x06AB0BD6), UINT32_C(0xDD734990), UINT32_C(0x2CD00D76),
          UINT32_C(0xB06460E4), UINT32_C(0x5D59C693)},
         {UINT32_C(0x1F9C76DA), UINT32_C(0x3BA8F2F0), UINT32_C(0x960F5C0E),
          UINT32_C(0x08E4A7EC), UINT32_C(0xE4AAB060), UINT32_C(0x79C82AD9),
          UINT32_C(0x0DF95C43), UINT32_C(0x093D322C)}},
        {{UINT32_C(0x0C627547), UINT32_C(0x88AF1258), UINT32_C(0x889A5E12),
          UINT32_C(0x81E5F197), UINT32_C(0x7CBD84FD), UINT32_C(0x99E0E191),
          UINT32_C(0xDB0B9711), UINT32_C(0x3024BCE8)},
         {UINT32_C(0xDB93B1A2), UINT32_C(0x04075C80), UINT32_C(0x628B0E63),
          UINT32_C(0x12F30AF8), UINT32_C(0xEB25A4ED), UINT32_C(0xA3514F26),
          UINT32_C(0x7BCD0873), UINT32_C(0x3D42E489)}},
        {{UINT32_C(0x754B236F), UINT32_C(0x0F1C16C6), UINT32_C(0x594F5D3D),
          UINT32_C(0x717CE487), UINT32_C(0xAFAD77B1), UINT32_C(0x7679C7DA),
          UINT32_C(0x6F3E724C), UINT32_C(0x51AFD014)},
         {UINT32_C(0x3AF6938F), UINT32_C(0xAFC9745C), UINT32_C(0xC4E61CB4),
          UINT32_C(0xCA12BFA9), UINT32_C(0x9425CCA7), UINT32_C(0x943B5696),
          UINT32_C(0xB6E48A69), UINT32_C(0x5BD3E65E)}},
        {{UINT32_C(0xDEAE74B1), UINT32_C(0x2D23CF78), UINT32_C(0x043BF2F1),
          UINT32_C(0xA686767E), UINT32_C(0xE464ADE9), UINT32_C(0x3AFED34D),
          UINT32_C(0x5A6AE80B), UINT32_C(0x1E462073)},
         {UINT32_C(0x737F7B66), UINT32_C(0xA86AA408), UINT32_C(0xEAB3B6CE),
          UINT32_C(0xD67A0B49), UINT32_C(0x275355F3), UINT32_C(0x6FF3CA4F),
          UINT32_C(0x688F99AB), UINT32_C(0x6F385576)}},
        {{UINT32_C(0xFD2F9A72), UINT32_C(0xC9B63343), UINT32_C(0xAC267E8A),
          UINT32_C(0xBD0A126D), UINT32_C(0x5D2839B5), UINT32_C(0x818BD5D8),
          UINT32_C(0x0BF5AFCE), UINT32_C(0x1BBAB4CE)},
         {UINT32_C(0x4D8B67DE), UINT32_C(0x2827B24A), UINT32_C(0xC34E6642),
          UINT32_C(0x841F6BD3), UINT32_C(0x5E4A34D4), UINT32_C(0xE9F5C1C2),
          UINT32_C(0xFDA4177C), UINT32_C(0x4E98795C)}},
        {{UINT32_C(0x0763AB04), UINT32_C(0x3C9FF1C2), UINT32_C(0x9832FCFD),
          UINT32_C(0x4FC1BE61), UINT32_C(0x8BD0363A), UINT32_C(0x5FA50C38),
          UINT32_C(0xF26206BE), UINT32_C(0x14C9BB2F)},
         {UINT32_C(0x1D31880C), UINT32_C(0xAD1A96EB), UINT32_C(0x65DFCF8A),
          UINT32_C(0xF0A37BC4), UINT32_C(0x3D048FE4), UINT32_C(0x38962729),
          UINT32_C(0x6480B254), UINT32_C(0x017125C0)}},
        {{UINT32_C(0x98D4BAC6), UINT32_C(0x01E819F5), UINT32_C(0x36B99D30),
          UINT32_C(0xD3686E04), UINT32_C(0x200A4A9D), UINT32_C(0x0C2876FB),
          UINT32_C(0xE65782D5), UINT32_C(0x45D50C2F)},
         {UINT32_C(0x865B7A21), UINT32_C(0xB8316ECE), UINT32_C(0xCC875503),
          UINT32_C(0xA3ADB90F), UINT32_C(0x98468FB4), UINT32_C(0xD72E864E),
          UINT32_C(0xDED21F40), UINT32_C(0x13BB23FD)}},
        {{UINT32_C(0xC6B96368), UINT32_C(0x653C3C15), UINT32_C(0x2B9C381F),
          UINT32_C(0x9A42FC2C), UINT32_C(0x69534D92), UINT32_C(0xF06B41B9),
          UINT32_C(0x3FB7BED2), UINT32_C(0x46F7292E)},
         {UINT32_C(0x97D1875E), UINT32_C(0x14A2C420), UINT32_C(0xD3B2DF55),
          UINT32_C(0x45DFA824), UINT32_C(0x3F2BA72D), UINT32_C(0x59CB7E59),
          UINT32_C(0xD7D96C98), UINT32_C(0x2EEC65C9)}},
        {{UINT32_C(0x49650405), UINT32_C(0x907CD4C8), UINT32_C(0x37E05E06),
          UINT32_C(0xFC29320A), UINT32_C(0x09E29619), UINT32_C(0x99B4C1DF),
          UINT32_C(0x34DE993F), UINT32_C(0x74E69BF8)},
         {UINT32_C(0x509D9797), UINT32_C(0x62C0F296), UINT32_C(0x5F1EF554),
          UINT32_C(0x2E6BD4E6), UINT32_C(0x0D0B71B8), UINT32_C(0xE3050641),
          UINT32_C(0x235DDE6C), UINT32_C(0x29DA0C9D)}},
        {{UINT32_C(0x689398C1), UINT32_C(0x3CFBCA4B), UINT32_C(0x40C9DF13),
          UINT32_C(0x11E58804), UINT32_C(0xBCDF2489), UINT32_C(0x3923A39B),
          UINT32_C(0x387C8089), UINT32_C(0x3805CCC7)},
         {UINT32_C(0x70319AFA), UINT32_C(0xC1B4EB48), UINT32_C(0xCA089604),
          UINT32_C(0x0A6A5FA4), UINT32_C(0x73139A20), UINT32_C(0x16ABDE54),
          UINT32_C(0x94BD61B5), UINT32_C(0x7C0055E0)}},
        {{UINT32_C(0xCB05A02A), UINT32_C(0xA5AB5CEF), UINT32_C(0x0BFE903B),
          UINT32_C(0xC0B4E1B4), UINT32_C(0xEAC9E7E8), UINT32_C(0xBA528329),
          UINT32_C(0x0A2456B6), UINT32_C(0x0266C5A7)},
         {UINT32_C(0x5E216EEC), UINT32_C(0x507E9A41), UINT32_C(0xD0F1E440),
          UINT32_C(0xFCC06B0A), UINT32_C(0xE5C7B26F), UINT32_C(0x6FAEFC8E),
          UINT32_C(0xB02F85C1), UINT32_C(0x4744CF2E)}},
        {{UINT32_C(0x1C291BFC), UINT32_C(0xF5E2B812), UINT32_C(0x2CDCBF7A),
          UINT32_C(0xC18E791D), UINT32_C(0x46554345), UINT32_C(0xC386B962),
          UINT32_C(0x067518CD), UINT32_C(0x373E00FB)},
         {UINT32_C(0xE950051B), UINT32_C(0xC9BA9DF9), UINT32_C(0xDD6133EE),
          UINT32_C(0x182CB132), UINT32_C(0x70A3C71C), UINT32_C(0xD6D7F815),
          UINT32_C(0x7FAFE307), UINT32_C(0x44C5AEBC)}},
        {{UINT32_C(0xA9D16080), UINT32_C(0x6C7CE359), UINT32_C(0x1E8B643E),
          UINT32_C(0xA874386D), UINT32_C(0x07F48E10), UINT32_C(0xA0648129),
          UINT32_C(0x93E4D619), UINT32_C(0x2A402201)},
         {UINT32_C(0xBD383EA6), UINT32_C(0x8B429545), UINT32_C(0xF2880536),
          UINT32_C(0xC096D593), UINT32_C(0x20E299B9), UINT32_C(0xB4057D6C),
          UINT32_C(0x38A825FA), UINT32_C(0x303962CE)}},
    },
    {
        {{UINT32_C(0x1E1D70D0), UINT32_C(0x9E426EBF), UINT32_C(0xB83529CA),
          UINT32_C(0x6AEA4DDC), UINT32_C(0x7CC9A07C), UINT32_C(0xF3ECD462),
          UINT32_C(0xC364772E), UINT32_C(0x7F255C86)},
         {UINT32_C(0x5613BEF0), UINT32_C(0x0DF212CF), UINT32_C(0x1309F9D0),
          UINT32_C(0x771F02A9), UINT32_C(0x805FE1F5), UINT32_C(0xE97BEE39),
          UINT32_C(0xD93522B9), UINT32_C(0x54A43430)}},
        {{UINT32_C(0xCDE4EBBE), UINT32_C(0xC01553BD), UINT32_C(0xA02E56C1),
          UINT32_C(0xB1928DDC), UINT32_C(0x94A1A417), UINT32_C(0xB91004BA),
          UINT32_C(0x56CB9C88), UINT32_C(0x44F74BE6)},
         {UINT32_C(0x921B62E5), UINT32_C(0x6A7E3E9B), UINT32_C(0x5FBF13C4),
          UINT32_C(0xF2BF553B), UINT32_C(0x86D55641), UINT32_C(0x51CB776D),
          UINT32_C(0x6425A3AD), UINT32_C(0x71826BC5)}},
        {{UINT32_C(0xC6D70EF9), UINT32_C(0xD6D49F90), UINT32_C(0x29EBA0DD),
          UINT32_C(0x5BD0DA69), UINT32_C(0x803233EF), UINT32_C(0x0BBA7571),
          UINT32_C(0x679A17D5), UINT32_C(0x0EB0959E)},
         {UINT32_C(0xB8A3D6EC), UINT32_C(0x97818DC2), UINT32_C(0xC687EAA2),
          UINT32_C(0x09497FB0), UINT32_C(0xA65FA4C0), UINT32_C(0x2E2707EA),
          UINT32_C(0x7542F472), UINT32_C(0x6A74D4C6)}},
        {{UINT32_C(0x1EE0BC40), UINT32_C(0x0D193006), UINT32_C(0x6DC98BA8),
          UINT32_C(0x7D7BEE19), UINT32_C(0x447C38D2), UINT32_C(0x1AD37C98),
          UINT32_C(0xB6B4550A), UINT32_C(0x3E163AE1)},
         {UINT32_C(0x5BC93243), UINT32_C(0x734E36C9), UINT32_C(0x986C35A8),
          UINT32_C(0x54E217FD), UINT32_C(0x9E3285E3), UINT32_C(0xF0576FF0),
          UINT32_C(0x186EE7EB), UINT32_C(0x65C950C8)}},
        {{UINT32_C(0x2012D277), UINT32_C(0x1AB12C04), UINT32_C(0x83872384),
          UINT32_C(0x97CAB84B), UINT32_C(0x1C66FCFD), UINT32_C(0x479C9CF5),
          UINT32_C(0xF276933E), UINT32_C(0x70ABC8B4)},
         {UINT32_C(0xBA4D14F0), UINT32_C(0xE6B15BF7), UINT32_C(0x22E2F5D5),
          UINT32_C(0xF4060ED3), UINT32_C(0xCDC5462C), UINT32_C(0xA53F3CA0),
          UINT32_C(0xC6FC3854), UINT32_C(0x593219D4)}},
        {{UINT32_C(0x72B6F8A1), UINT32_C(0x9DE69934), UINT32_C(0x19E16B3F),
          UINT32_C(0xECABAEEE), UINT32_C(0xEDA68D7B), UINT32_C(0x0B537CA5),
          UINT32_C(0xD3CE55B7), UINT32_C(0x744628BD)},
         {UINT32_C(0x98A95308), UINT32_C(0x3A5B2D8E), UINT32_C(0x6758C6C8),
          UINT32_C(0x74D0CEF1), UINT32_C(0xDA204834), UINT32_C(0x7538198A),
          UINT32_C(0xA644E880), UINT32_C(0x1E166AAA)}},
        {{UINT32_C(0x4674ACF0), UINT32_C(0xE76EE712), UINT32_C(0xDF9DFB4C),
          UINT32_C(0x40A6F6DE), UINT32_C(0x40C65721), UINT32_C(0x91B0034C),
          UINT32_C(0xF8E0F5E5), UINT32_C(0x54FE8B8B)},
         {UINT32_C(0x75891895), UINT32_C(0x6322CA0F), UINT32_C(0x7D20C522),
          UINT32_C(0x3D1C821E), UINT32_C(0x08043786), UINT32_C(0x1691407F),
          UINT32_C(0x14847D58), UINT32_C(0x02C30838)}},
        {{UINT32_C(0xB8F0C372), UINT32_C(0x57DEF069), UINT32_C(0x0D5ABF2C),
          UINT32_C(0x50375DC3), UINT32_C(0x75EDFBC9), UINT32_C(0x22903814),
          UINT32_C(0xAE37695A), UINT32_C(0x56E39BD7)},
         {UINT32_C(0x463D13F2), UINT32_C(0xAB74B187), UINT32_C(0x3CDE8886),
          UINT32_C(0xC50CB8A2), UINT32_C(0xB35F7D59), UINT32_C(0x1EFBD1CF),
          UINT32_C(0x1057AE42), UINT32_C(0x1296C482)}},
        {{UINT32_C(0xC347E3FB), UINT32_C(0xA350B57B), UINT32_C(0xADF65129),
          UINT32_C(0x4312EB75), UINT32_C(0x7F9A6C9E), UINT32_C(0xD9A7E2F4),
          UINT32_C(0x9BFDCB4D), UINT32_C(0x5493AF7B)},
         {UINT32_C(0x9AC0E58E), UINT32_C(0x90A443DD), UINT32_C(0xC6F3BEEF),
          UINT32_C(0x9777D58A), UINT32_C(0x965EC900), UINT32_C(0x12F00913),
          UINT32_C(0x480126DA), UINT32_C(0x2F6C5B59)}},
        {{UINT32_C(0xBAD8C051), UINT32_C(0x70B907FC), UINT32_C(0xD3B4F608),
          UINT32_C(0x54492D6A), UINT32_C(0x2E096D9F), UINT32_C(0xE3B46F1B),
          UINT32_C(0x747D472A), UINT32_C(0x522AD6D1)},
         {UINT32_C(0x02DAB5E5), UINT32_C(0x8FCD1616), UINT32_C(0x357B1C85),
          UINT32_C(0xD3BA292F), UINT32_C(0x2704F072), UINT32_C(0xA6DB50CD),
          UINT32_C(0x8341AA73), UINT32_C(0x63488DDF)}},
        {{UINT32_C(0x0FE2AAAB), UINT32_C(0x99100A3D), UINT32_C(0x8EA44560),
          UINT32_C(0x7D30C4E9), UINT32_C(0x2B4C776D), UINT32_C(0xBA458C67),
          UINT32_C(0xBBA4D85E), UINT32_C(0x2EC11420)},
         {UINT32_C(0x7A7AEC55), UINT32_C(0xB1D9FBA2), UINT32_C(0x7665AAE5),
          UINT32_C(0x432AB2AA), UINT32_C(0xF3BC7043), UINT32_C(0xD2755948),
          UINT32_C(0x82510EAD), UINT32_C(0x2FC331BB)}},
        {{UINT32_C(0x46253DB1), UINT32_C(0xAAF11CF9), UINT32_C(0xB0DF307C),
          UINT32_C(0xEB025AED), UINT32_C(0x7A82ADEE), UINT32_C(0xCB7C22A5),
          UINT32_C(0x9C5FA97B), UINT32_C(0x7316C390)},
         {UINT32_C(0xF518067C), UINT32_C(0x91620554), UINT32_C(0x3C96A804),
          UINT32_C(0x20A438AE), UINT32_C(0x5B0C090C), UINT32_C(0xC4F9DCDF),
          UINT32_C(0x6E5C1B45), UINT32_C(0x77C512DB)}},
        {{UINT32_C(0xFDD09EDE), UINT32_C(0xC981E682), UINT32_C(0xBBB3F57D),
          UINT32_C(0xC3EB36B7), UINT32_C(0xD12BF450), UINT32_C(0xA07369C6),
          UINT32_C(0xCE017845), UINT32_C(0x16627566)},
         {UINT32_C(0x9494AF62), UINT32_C(0xFD8DEC90), UINT32_C(0x53FD4B22),
          UINT32_C(0x7E793096), UINT32_C(0xC8AAEAE9), UINT32_C(0x21B8E665),
          UINT32_C(0x18BC33C0), UINT32_C(0x526FA318)}},
        {{UINT32_C(0x853A2647), UINT32_C(0xF55D32BF), UINT32_C(0xCDAEE8FE),
          UINT32_C(0xD873ED6C), UINT32_C(0x80E52622), UINT32_C(0xA3579E2B),
          UINT32_C(0x33D16FE8), UINT32_C(0x03871ABA)},
         {UINT32_C(0x69925EDF), UINT32_C(0x714804AC), UINT32_C(0xF2B964FF),
          UINT32_C(0x0340755F), UINT32_C(0xDA0D1A07), UINT32_C(0x93830F98),
          UINT32_C(0xF7FB1E16), UINT32_C(0x2CAB201E)}},
        {{UINT32_C(0x22A8AF77), UINT32_C(0x26DE3A3A), UINT32_C(0xB45BA630),
          UINT32_C(0x0E77C3DC), UINT32_C(0xFC86E7D1), UINT32_C(0x34F00017),
          UINT32_C(0x1B62F7F2), UINT32_C(0x796ABE2F)},
         {UINT32_C(0x1663B5B1), UINT32_C(0x9FA09277), UINT32_C(0x9B2FB9AC),
          UINT32_C(0xFFFDC93F), UINT32_C(0x6B340D75), UINT32_C(0x03AECD1A),
          UINT32_C(0x314DCCEA), UINT32_C(0x5D55A168)}},
        {{UINT32_C(0x747DBD0C), UINT32_C(0x678AEF02), UINT32_C(0xD47A6C09),
          UINT32_C(0xF0D47C1C), UINT32_C(0x3FDD1681), UINT32_C(0x6C2AC72F),
          UINT32_C(0x6D789D3A), UINT32_C(0x750E7064)},
         {UINT32_C(0xAEBEDD58), UINT32_C(0x3F970AFE), UINT32_C(0xE3540951),
          UINT32_C(0x6BBA7956), UINT32_C(0x3E71F6AF), UINT32_C(0x7CC461B2),
          UINT32_C(0xC45FED28), UINT32_C(0x7E51E548)}},
    },
    {
        {{UINT32_C(0x2CE2CBE5), UINT32_C(0x4A598EFB), UINT32_C(0x89C9A51B),
          UINT32_C(0x774CDE0A), UINT32_C(0xCA907F34), UINT32_C(0x2D003680),
          UINT32_C(0x9D3C7D97), UINT32_C(0x62C32DCA)},
         {UINT32_C(0xB3054D17), UINT32_C(0x37B3A90F), UINT32_C(0x67E58A5A),
          UINT32_C(0x1423574C), UINT32_C(0x4859FA49), UINT32_C(0xF1D3BB1A),
          UINT32_C(0x3F5AFA63), UINT32_C(0x25F0AF1C)}},
        {{UINT32_C(0x1FE53AC9), UINT32_C(0xD3BF7F62), UINT32_C(0xCBCE6164),
          UINT32_C(0xCE2B67C3), UINT32_C(0x95341024), UINT32_C(0xE081C576),
          UINT32_C(0x9A70ECAB), UINT32_C(0x32B0EF5D)},
         {UINT32_C(0x3BE1E5CE), UINT32_C(0x3EC93C85), UINT32_C(0xA0CB7DCD),
          UINT32_C(0xE25F54ED), UINT32_C(0x517965B2), UINT32_C(0x9D6B57D7),
          UINT32_C(0x129B0B27), UINT32_C(0x159F7AB0)}},
        {{UINT32_C(0xEEFB67F3), UINT32_C(0xAEF88E95), UINT32_C(0xE0316AB2),
          UINT32_C(0xEAEB2889), UINT32_C(0xC2CB6753), UINT32_C(0x1491881F),
          UINT32_C(0x702789D0), UINT32_C(0x67DCDF28)},
         {UINT32_C(0x11C0F3FD), UINT32_C(0x8282E0A7), UINT32_C(0x01BA273D),
          UINT32_C(0x9CDCFDB8), UINT32_C(0x26279B95), UINT32_C(0x6BF1E043),
          UINT32_C(0x85852777), UINT32_C(0x0D42AAC6)}},
        {{UINT32_C(0x608981AB), UINT32_C(0xC4CE393E), UINT32_C(0x52141CB0),
          UINT32_C(0x210E20F8), UINT32_C(0x6B9234B5), UINT32_C(0x22C2586D),
          UINT32_C(0x4366750E), UINT32_C(0x52F1B366)},
         {UINT32_C(0x760AFA55), UINT32_C(0xE38ED0D9), UINT32_C(0xB5D61A08),
          UINT32_C(0xA43FF25A), UINT32_C(0xB5E21691), UINT32_C(0x0BE3A406),
          UINT32_C(0xFD4E17B0), UINT32_C(0x37B47A28)}},
        {{UINT32_C(0x4C2C65C2), UINT32_C(0xC46DC6D4), UINT32_C(0xC54BE778),
          UINT32_C(0x2A0B452C), UINT32_C(0xF727070E), UINT32_C(0xAF113693),
          UINT32_C(0xC68D13A3), UINT32_C(0x7B229CD8)},
         {UINT32_C(0x02D43E4B), UINT32_C(0x0F63097E), UINT32_C(0x55627FD8),
          UINT32_C(0x912F8D33), UINT32_C(0x2A0DD9AE), UINT32_C(0x1EBF3961),
          UINT32_C(0xF0294B2D), UINT32_C(0x7FD33FDE)}},
        {{UINT32_C(0xD0CC6D9F), UINT32_C(0xC72411F5), UINT32_C(0x9B92FF84),
          UINT32_C(0x66E04C90), UINT32_C(0xE1C033B6), UINT32_C(0x0678B4F8),
          UINT32_C(0xE49A972A), UINT32_C(0x5A99F270)},
         {UINT32_C(0xD265A4DF), UINT32_C(0x3743BCD8), UINT32_C(0xCE0404C3),
          UINT32_C(0x7BD6DDF4), UINT32_C(0x131750A5), UINT32_C(0x4043767F),
          UINT32_C(0x9DD65652), UINT32_C(0x4A7D8983)}},
        {{UINT32_C(0x12B7822D), UINT32_C(0x535BC784), UINT32_C(0xF1F9B703),
          UINT32_C(0xDD32DD67), UINT32_C(0x2EAA2A1C), UINT32_C(0xFFDBF0EB),
          UINT32_C(0xF64E9822), UINT32_C(0x497C09FA)},
         {UINT32_C(0x32EE2A36), UINT32_C(0x18E717E9), UINT32_C(0x583949B1),
          UINT32_C(0xF01CC4F5), UINT32_C(0x0A168755), UINT32_C(0x222EE974),
          UINT32_C(0x00C81EC9), UINT32_C(0x0CD14CD5)}},
        {{UINT32_C(0x14C79CDC), UINT32_C(0x7AE0BD11), UINT32_C(0x6DC08C80),
          UINT32_C(0x67323D1A), UINT32_C(0x0EF32432), UINT32_C(0x2FD1ABC7),
          UINT32_C(0xB0E08EBF), UINT32_C(0x65923246)},
         {UINT32_C(0xC0754ECE), UINT32_C(0x0A9FD3D7), UINT32_C(0x5F8644FA),
          UINT32_C(0xE76B2624), UINT32_C(0x0F8BB385), UINT32_C(0xF1F0BEBA),
          UINT32_C(0xFC96778F), UINT32_C(0x73251F03)}},
        {{UINT32_C(0xD08795A9), UINT32_C(0x197150DE), UINT32_C(0xFBB8B9CF),
          UINT32_C(0xAD6935AE), UINT32_C(0x3B2B9EFB), UINT32_C(0x72118682),
          UINT32_C(0xBC2B7240), UINT32_C(0x265B288D)},
         {UINT32_C(0x2F78C431), UINT32_C(0x7BF2EB36), UINT32_C(0xF2A6E469),
          UINT32_C(0xF03B83CA), UINT32_C(0x4740E74B), UINT32_C(0x21159256),
          UINT32_C(0x0490F0B9), UINT32_C(0x35BE5735)}},
        {{UINT32_C(0x806C1CAE), UINT32_C(0x207F33B2), UINT32_C(0xDAC5ADE0),
          UINT32_C(0x04249127), UINT32_C(0x1CC59DE7), UINT32_C(0xC4CCF33E),
          UINT32_C(0x272BD6D7), UINT32_C(0x2A17B520)},
         {UINT32_C(0xB48F6585), UINT32_C(0xC36F6B3C), UINT32_C(0x0861ACF5),
          UINT32_C(0xD32A7379), UINT32_C(0x2C3291C6), UINT32_C(0x28A12ECB),
          UINT32_C(0xF02A88D0), UINT32_C(0x0E945F95)}},
        {{UINT32_C(0xD3B3117B), UINT32_C(0x4836EC01), UINT32_C(0xA4C2FD72),
          UINT32_C(0x4C197454), UINT32_C(0xF9897721), UINT32_C(0x96FCED51),
          UINT32_C(0x5828C97D), UINT32_C(0x14202858)},
         {UINT32_C(0x774755B9), UINT32_C(0xCA7ACED8), UINT32_C(0x97252559),
          UINT32_C(0x460FF582), UINT32_C(0x5796DD63), UINT32_C(0xAAE45776),
          UINT32_C(0x346DDBF5), UINT32_C(0x711C916E)}},
        {{UINT32_C(0x5E203692), UINT32_C(0xA60E2E7B), UINT32_C(0xF3BF2A45),
          UINT32_C(0xCFC72FEA), UINT32_C(0x72AC0436), UINT32_C(0x78729D28),
          UINT32_C(0x29ABF199), UINT32_C(0x3E16DD8B)},
         {UINT32_C(0x15A41F3D), UINT32_C(0xB1705AA6), UINT32_C(0x308AB87C),
          UINT32_C(0x8C7512FE), UINT32_C(0x03995381), UINT32_C(0xA27411C5),
          UINT32_C(0xA780CED3), UINT32_C(0x3142403C)}},
        {{UINT32_C(0xF1718C7F), UINT32_C(0xE4473E94), UINT32_C(0xA3CAB6CB),
          UINT32_C(0x601BC194), UINT32_C(0x581D491D), UINT32_C(0x8F3540F8),
          UINT32_C(0x43C15321), UINT32_C(0x456A9B7C)},
         {UINT32_C(0x593BB7ED), UINT32_C(0x6F335A2D), UINT32_C(0x7D791514),
          UINT32_C(0xB6D5A23F), UINT32_C(0x79235EAD), UINT32_C(0x976D2F83),
          UINT32_C(0x44775C97), UINT32_C(0x7D02EA0F)}},
        {{UINT32_C(0xE5EC268E), UINT32_C(0x322DBC8C), UINT32_C(0xBE14BF5C),
          UINT32_C(0x1F2F6050), UINT32_C(0xEACF6A50), UINT32_C(0x58AC6397),
          UINT32_C(0xA5401081), UINT32_C(0x4167CBD5)},
         {UINT32_C(0xEE5B4BF5), UINT32_C(0x8E6F06A1), UINT32_C(0x6B2F790F),
          UINT32_C(0x1A6073D5), UINT32_C(0x4F901250), UINT32_C(0x1C09FF3D),
          UINT32_C(0xE6B40DF4), UINT32_C(0x286AF8D7)}},
        {{UINT32_C(0x06BD53FF), UINT32_C(0xF74C8057), UINT32_C(0xE5788F0D),
          UINT32_C(0x4FCE7281), UINT32_C(0x3D015E6B), UINT32_C(0xD6A867AC),
          UINT32_C(0x6E185A42), UINT32_C(0x04AEC38D)},
         {UINT32_C(0x083D65CB), UINT32_C(0x8DC12B74), UINT32_C(0x82966668),
          UINT32_C(0xDB1AA8AC), UINT32_C(0x28AF1B90), UINT32_C(0xBD2233BF),
          UINT32_C(0x172CCA11), UINT32_C(0x544569A7)}},
        {{UINT32_C(0x149BD0BD), UINT32_C(0x9C56FCA8), UINT32_C(0xA05F8E44),
          UINT32_C(0x2B4EC788), UINT32_C(0x92478943), UINT32_C(0x1569CF6D),
          UINT32_C(0x57380986), UINT32_C(0x67E373E8)},
         {UINT32_C(0xED3C14DB), UINT32_C(0xF5CC8232), UINT32_C(0xF52EAF83),
          UINT32_C(0xE3D184B0), UINT32_C(0x0BC64038), UINT32_C(0x195D4137),
          UINT32_C(0x778C3C20), UINT32_C(0x77994388)}},
    },
    {
        {{UINT32_C(0xA0CC77AA), UINT32_C(0x3DAA0C47), UINT32_C(0x7C69CDF0),
          UINT32_C(0xB9794E74), UINT32_C(0x4549F5D4), UINT32_C(0x3610E50B),
          UINT32_C(0xB8A112CA), UINT32_C(0x262CA564)},
         {UINT32_C(0x554E8714), UINT32_C(0xD5EC795E), UINT32_C(0x717EBEF3),
          UINT32_C(0x73EE5502), UINT32_C(0x1947A478), UINT32_C(0xE36E8A1A),
          UINT32_C(0x42ADC59D), UINT32_C(0x3FBE43A3)}},
        {{UINT32_C(0x021FBCBE), UINT32_C(0x4DE78909), UINT32_C(0x0BBBB324),
          UINT32_C(0xA76A5EE2), UINT32_C(0xCD67810B), UINT32_C(0x5B86519A),
          UINT32_C(0x3710A4EE), UINT32_C(0x4CCA44A2)},
         {UINT32_C(0xCD1F8BEC), UINT32_C(0xD79A121D), UINT32_C(0xDC9CA10E),
          UINT32_C(0x2E12A772), UINT32_C(0x8C9E9640), UINT32_C(0xE301CA3B),
          UINT32_C(0xB731A957), UINT32_C(0x4B25FE18)}},
        {{UINT32_C(0xF4AD7264), UINT32_C(0xA05DA2CD), UINT32_C(0x076977A5),
          UINT32_C(0x31336489), UINT32_C(0xF2E576A8), UINT32_C(0xC1D269BE),
          UINT32_C(0x7532203F), UINT32_C(0x1E877ADC)},
         {UINT32_C(0x8B92972C), UINT32_C(0x9C9961BC), UINT32_C(0x6A14D810),
          UINT32_C(0x7BA07272), UINT32_C(0x06913136), UINT32_C(0xE51095A9),
          UINT32_C(0x30E0EA8C), UINT32_C(0x46748969)}},
        {{UINT32_C(0x3C73BA49), UINT32_C(0xDB8EF346), UINT32_C(0x3720570D),
          UINT32_C(0xBF221312), UINT32_C(0x605DB0D6), UINT32_C(0xC07B3639),
          UINT32_C(0x300336A3), UINT32_C(0x44FCEFA6)},
         {UINT32_C(0x2D234592), UINT32_C(0x121FAC5C), UINT32_C(0x44E367D7),
          UINT32_C(0x901DEE88), UINT32_C(0x1CAA6A3A), UINT32_C(0x5B5F3DD6),
          UINT32_C(0xAC2F6E64), UINT32_C(0x72E474EC)}},
        {{UINT32_C(0xF55BE61C), UINT32_C(0x15690BEE), UINT32_C(0xDF2678A2),
          UINT32_C(0xE42B945E), UINT32_C(0x3B7B1776), UINT32_C(0x60A5C8AA),
          UINT32_C(0xEB9AB938), UINT32_C(0x16103FBC)},
         {UINT32_C(0x87AD06AB), UINT32_C(0x79722A1E), UINT32_C(0xD6B632A2),
          UINT32_C(0xD7B509F6), UINT32_C(0x3B69EB40), UINT32_C(0x8C4E8B2E),
          UINT32_C(0x14DB2225), UINT32_C(0x6A509583)}},
        {{UINT32_C(0x93B78659), UINT32_C(0x169F35D8), UINT32_C(0x8EFF83AD),
          UINT32_C(0x989B04D2), UINT32_C(0xA6AE4806), UINT32_C(0x72CF7338),
          UINT32_C(0xF4AAA524), UINT32_C(0x6E156C84)},
         {UINT32_C(0xA1ED5CB2), UINT32_C(0x33A608ED), UINT32_C(0xC3D28716),
          UINT32_C(0xCE274A64), UINT32_C(0x45F0435F), UINT32_C(0xFCF1B170),
          UINT32_C(0x1653D6F6), UINT32_C(0x101D1BDB)}},
        {{UINT32_C(0x2E5A67D9), UINT32_C(0x45BC931D), UINT32_C(0x697DA479),
          UINT32_C(0xAFF02C11), UINT32_C(0x2EA3E6E1), UINT32_C(0x7C7972A3),
          UINT32_C(0x5E97BB90), UINT32_C(0x71A17D50)},
         {UINT32_C(0x19AD4C5E), UINT32_C(0x962E84F2), UINT32_C(0x692020BE),
          UINT32_C(0xBB8C9FC7), UINT32_C(0xE7B36665), UINT32_C(0xA78FDF2C),
          UINT32_C(0x26F92E33), UINT32_C(0x7AC84ED4)}},
        {{UINT32_C(0xC3C9E5C1), UINT32_C(0xBD85A9EE), UINT32_C(0x6ED2FD6A),
          UINT32_C(0x72030BAA), UINT32_C(0x39CFFB89), UINT32_C(0xB67185AB),
          UINT32_C(0x833BF770), UINT32_C(0x3E2E51A4)},
         {UINT32_C(0x5E27D5BB), UINT32_C(0x248FA348), UINT32_C(0x2E6D3DCF),
          UINT32_C(0xF8D43596), UINT32_C(0x0C8DAF81), UINT32_C(0x07F5B93C),
          UINT32_C(0xAD2FC97D), UINT32_C(0x6A7FFA1D)}},
        {{UINT32_C(0xFAEA33F1), UINT32_C(0xFF308FAE), UINT32_C(0x3CC4C7CF),
          UINT32_C(0x5F29DFFB), UINT32_C(0xECC5A2B9), UINT32_C(0xB9AD4527),
          UINT32_C(0x048D4B38), UINT32_C(0x08B95AF6)},
         {UINT32_C(0xDEC152BB), UINT32_C(0x56BC43A8), UINT32_C(0x3849D869),
          UINT32_C(0xD1147B9A), UINT32_C(0xD02AF3B7), UINT32_C(0xFE5020C2),
          UINT32_C(0xB918496E), UINT32_C(0x54C02B44)}},
        {{UINT32_C(0x0B27468D), UINT32_C(0x1611ECFD), UINT32_C(0x0513A562),
          UINT32_C(0x4AFCE329), UINT32_C(0x2FE74EED), UINT32_C(0x982782FD),
          UINT32_C(0x17ADD2EA), UINT32_C(0x66AC58BF)},
         {UINT32_C(0x613581D4), UINT32_C(0x8277BC2D), UINT32_C(0x988D1498),
          UINT32_C(0x0BF5BF0C), UINT32_C(0x55C984CB), UINT32_C(0x8A37134D),
          UINT32_C(0x92211390), UINT32_C(0x409A79CC)}},
        {{UINT32_C(0x816F0462), UINT32_C(0x8C0081AE), UINT32_C(0x5A68BFC2),
          UINT32_C(0xB431DC24), UINT32_C(0x5F78C8A1), UINT32_C(0x25C769C6),
          UINT32_C(0xB382AF14), UINT32_C(0x3BE0458D)},
         {UINT32_C(0xA171ADF2), UINT32_C(0x10583083), UINT32_C(0x37F7C39F),
          UINT32_C(0xBA5D5325), UINT32_C(0x5EAC7585), UINT32_C(0x76B03B94),
          UINT32_C(0x9C2DF2C6), UINT32_C(0x76159AAC)}},
        {{UINT32_C(0x918E0332), UINT32_C(0x886C73BA), UINT32_C(0xD24B5B52),
          UINT32_C(0xF6FEC62A), UINT32_C(0x36B4D23A), UINT32_C(0xB98759B4),
          UINT32_C(0x5480ACF3), UINT32_C(0x5EC5B3FE)},
         {UINT32_C(0x6DD175BF), UINT32_C(0x30FF297D), UINT32_C(0x75F2B9C3),
          UINT32_C(0x501DE744), UINT32_C(0xF19230C5), UINT32_C(0xDEBE47CA),
          UINT32_C(0x32BBBB62), UINT32_C(0x7401F209)}},
        {{UINT32_C(0x22496D1E), UINT32_C(0x80712E47), UINT32_C(0xDA80AF1D),
          UINT32_C(0x36A0EF37), UINT32_C(0x940E5E9F), UINT32_C(0xAF6CA51C),
          UINT32_C(0x722D9D22), UINT32_C(0x74E17B6F)},
         {UINT32_C(0xB8B3AE1B), UINT32_C(0xCB70B878), UINT32_C(0x07DF974C),
          UINT32_C(0xBF8B9A0B), UINT32_C(0xF68A4BF4), UINT32_C(0x89FCC996),
          UINT32_C(0x6EB0FB2E), UINT32_C(0x46F581E8)}},
        {{UINT32_C(0x67137153), UINT32_C(0xBCE0BD6C), UINT32_C(0x75F64B78),
          UINT32_C(0xAD3E92B3), UINT32_C(0xFD047DD9), UINT32_C(0x6454CD1D),
          UINT32_C(0x612AE472), UINT32_C(0x181C93EB)},
         {UINT32_C(0x23A529C3), UINT32_C(0xE575307E), UINT32_C(0x59C09EB5),
          UINT32_C(0xB9C43A0B), UINT32_C(0xAA805840), UINT32_C(0xFD233A68),
          UINT32_C(0xA122FFB9), UINT32_C(0x067C442E)}},
        {{UINT32_C(0x2CD6762E), UINT32_C(0xE1F3F76F), UINT32_C(0x9764B53A),
          UINT32_C(0xFB68650F), UINT32_C(0xF1224580), UINT32_C(0x4E90AC72),
          UINT32_C(0x127EED48), UINT32_C(0x2BF68F01)},
         {UINT32_C(0x94D389A0), UINT32_C(0xE6B4B409), UINT32_C(0xD44593D6),
          UINT32_C(0xD7BC8108), UINT32_C(0x48A86677), UINT32_C(0xDCF03991),
          UINT32_C(0xCEBCE3C7), UINT32_C(0x4A52D961)}},
        {{UINT32_C(0xBAA873EA), UINT32_C(0x55734AB5), UINT32_C(0x7871F323),
          UINT32_C(0x506DE4CF), UINT32_C(0x578612C0), UINT32_C(0x7C3F8B00),
          UINT32_C(0x9243C9E8), UINT32_C(0x730D4B8A)},
         {UINT32_C(0xD385F6BD), UINT32_C(0xA3290689), UINT32_C(0x913596F5),
          UINT32_C(0xAF688C6A), UINT32_C(0xB646BE23), UINT32_C(0x0A2D89B5),
          UINT32_C(0xF63A6029), UINT32_C(0x31891165)}},
    },
    {
        {{UINT32_C(0x579583C0), UINT32_C(0x331F9E57), UINT32_C(0x69C65DA2),
          UINT32_C(0xE92ABADF), UINT32_C(0xA5B8B057), UINT32_C(0xC796FBEC),
          UINT32_C(0x312D1E89), UINT32_C(0x52E6F9C9)},
         {UINT32_C(0xDA68DFD3), UINT32_C(0x0318B1DF), UINT32_C(0xA1CAC4F1),
          UINT32_C(0x8BAA2EB3), UINT32_C(0xBEE7D6E1), UINT32_C(0x0CDC89A2),
          UINT32_C(0x22AB50F4), UINT32_C(0x6102DE7A)}},
        {{UINT32_C(0xE20C707A), UINT32_C(0x02003D83), UINT32_C(0x28289D89),
          UINT32_C(0xD819249C), UINT32_C(0x72053FF8), UINT32_C(0x3FBC00B1),
          UINT32_C(0xDF40D261), UINT32_C(0x0249C43C)},
         {UINT32_C(0xD8F064AF), UINT32_C(0x8794EEAC), UINT32_C(0xDC9F0631),
          UINT32_C(0xE2359E70), UINT32_C(0xADA310D0), UINT32_C(0xD1603647),
          UINT32_C(0xEDC888EC), UINT32_C(0x6A9E3785)}},
        {{UINT32_C(0xEC41908E), UINT32_C(0xF332B384), UINT32_C(0xBDE4760B),
          UINT32_C(0xF3274472), UINT32_C(0x140D0EF4), UINT32_C(0x96185E89),
          UINT32_C(0x90E698E7), UINT32_C(0x56462089)},
         {UINT32_C(0xF2E64396), UINT32_C(0x841A31C5), UINT32_C(0x03C4118F),
          UINT32_C(0x8F494CA5), UINT32_C(0x1A188305), UINT32_C(0x0C98A4C3),
          UINT32_C(0x98AAB1AB), UINT32_C(0x1C4B5F62)}},
        {{UINT32_C(0x5D0D8381), UINT32_C(0xDDEEEBF8), UINT32_C(0x89044363),
          UINT32_C(0xD1616F48), UINT32_C(0x21616A13), UINT32_C(0x2EE41D47),
          UINT32_C(0x4BC769FC), UINT32_C(0x2DCE6110)},
         {UINT32_C(0x16C1C468), UINT32_C(0xE3707A01), UINT32_C(0x969AF612),
          UINT32_C(0x3B674187), UINT32_C(0x1E0671CC), UINT32_C(0xB64BD4D7),
          UINT32_C(0xB98C297C), UINT32_C(0x7EF01DBA)}},
        {{UINT32_C(0x815381AC), UINT32_C(0x91DCBF99), UINT32_C(0x38B67B97),
          UINT32_C(0x8D711F58), UINT32_C(0x9C6E322C), UINT32_C(0x9C11F595),
          UINT32_C(0xE31A782F), UINT32_C(0x4A688D0B)},
         {UINT32_C(0xDCE93F5B), UINT32_C(0x1297D9F3), UINT32_C(0x7C1DC62A),
          UINT32_C(0xA7956194), UINT32_C(0x5F718F63), UINT32_C(0x340F217A),
          UINT32_C(0xFCC0EF6A), UINT32_C(0x71F84529)}},
        {{UINT32_C(0x3DD00963), UINT32_C(0x0D968E50), UINT32_C(0xD7FF66C3),
          UINT32_C(0x5E696D79), UINT32_C(0x499A9BE2), UINT32_C(0xAA52D60D),
          UINT32_C(0xCDC289DE), UINT32_C(0x72482C45)},
         {UINT32_C(0x7FFAAD3A), UINT32_C(0xC84968F5), UINT32_C(0xF7CD5BED),
          UINT32_C(0xEE91304C), UINT32_C(0x0A7CC7C0), UINT32_C(0x68493676),
          UINT32_C(0x80023968), UINT32_C(0x3411AFA7)}},
        {{UINT32_C(0x6E3294C0), UINT32_C(0xA0AEBC70), UINT32_C(0xDC385E50),
          UINT32_C(0x93263942), UINT32_C(0x8467FB06), UINT32_C(0x7B90C002),
          UINT32_C(0x38CFD0FF), UINT32_C(0x29477CA4)},
         {UINT32_C(0x92A748D5), UINT32_C(0xADC04D81), UINT32_C(0x76CF3AE5),
          UINT32_C(0xAE4F309D), UINT32_C(0x4BB2C2FF), UINT32_C(0xBDA34BF0),
          UINT32_C(0x368536E4), UINT32_C(0x65138897)}},
        {{UINT32_C(0x6FE6D4D6), UINT32_C(0x9CB8F7D6), UINT32_C(0xAF246792),
          UINT32_C(0x6C2FFBF5), UINT32_C(0x81524707), UINT32_C(0xD5A4F349),
          UINT32_C(0x36766D5E), UINT32_C(0x3AFE45CE)},
         {UINT32_C(0x513BA267), UINT32_C(0x41991B49), UINT32_C(0x6C18AA5E),
          UINT32_C(0x06EF1EEA), UINT32_C(0x88EA2099), UINT32_C(0x0A517635),
          UINT32_C(0xD245B88B), UINT32_C(0x32D2B5E2)}},
        {{UINT32_C(0x3F517C5B), UINT32_C(0xAE38CDD5), UINT32_C(0xD878FEEE),
          UINT32_C(0x1C94FDC5), UINT32_C(0xBEFCE107), UINT32_C(0xABF7A41D),
          UINT32_C(0xD408DFE8), UINT32_C(0x33BF3FE9)},
         {UINT32_C(0x947CB8C4), UINT32_C(0x4F2E6FF0), UINT32_C(0xF998C5A0),
          UINT32_C(0x3A8E86AB), UINT32_C(0xE359209F), UINT32_C(0x3ADC6ABA),
          UINT32_C(0xD9A50051), UINT32_C(0x37A2DE1B)}},
        {{UINT32_C(0xE718F6B9), UINT32_C(0x424F4E34), UINT32_C(0x75C58EB6),
          UINT32_C(0x50B1A03B), UINT32_C(0x91390E27), UINT32_C(0xB9495314),
          UINT32_C(0x880E78D8), UINT32_C(0x4AE0CC3A)},
         {UINT32_C(0xF1E4413C), UINT32_C(0x10331AFA), UINT32_C(0xDDFCD2F0),
          UINT32_C(0xE7A3E554), UINT32_C(0x0EBF484B), UINT32_C(0x44F6DE85),
          UINT32_C(0x895D0F54), UINT32_C(0x6A762A7E)}},
        {{UINT32_C(0x8D0558F6), UINT32_C(0x8E606B0A), UINT32_C(0x5C4DD930),
          UINT32_C(0xAADA7604), UINT32_C(0xEF4ACAD0), UINT32_C(0x5B2FC7AD),
          UINT32_C(0x87F5B6E2), UINT32_C(0x0D969AD0)},
         {UINT32_C(0x5974E67B), UINT32_C(0xF9A182B2), UINT32_C(0x23B4009A),
          UINT32_C(0xCD8232E7), UINT32_C(0x285BCC3F), UINT32_C(0x3D8F5DDD),
          UINT32_C(0xEEE1B9BF), UINT32_C(0x114AC56F)}},
        {{UINT32_C(0xAA45085A), UINT32_C(0xD3EA1B56), UINT32_C(0xD314CEDF),
          UINT32_C(0x5DE7BB70), UINT32_C(0x7BCCDCFD), UINT32_C(0x8A74384C),
          UINT32_C(0x8E0E0367), UINT32_C(0x64B80F8A)},
         {UINT32_C(0x48884ED1), UINT32_C(0xA9EA432B), UINT32_C(0x8C0BA810),
          UINT32_C(0x51957A8F), UINT32_C(0x39E810E3), UINT32_C(0x9E883400),
          UINT32_C(0x28B2051C), UINT32_C(0x0A73ED5A)}},
        {{UINT32_C(0x13C30826), UINT32_C(0x655212A3), UINT32_C(0xB73E8660),
          UINT32_C(0xAE53668E), UINT32_C(0xFF108CCE), UINT32_C(0x6C33B649),
          UINT32_C(0x21D49681), UINT32_C(0x39E0B118)},
         {UINT32_C(0x70525312), UINT32_C(0xFE4D2152), UINT32_C(0xFFD18749),
          UINT32_C(0x2EDCE32B), UINT32_C(0xB04D3FB8), UINT32_C(0xFED19B1C),
          UINT32_C(0x2B225A9D), UINT32_C(0x4DFE216B)}},
        {{UINT32_C(0x4C70F8A8), UINT32_C(0x583E8A6C), UINT32_C(0x954A9AE1),
          UINT32_C(0xC8206231), UINT32_C(0xB76517B1), UINT32_C(0x9360B592),
          UINT32_C(0xEED10CCA), UINT32_C(0x362C5C5C)},
         {UINT32_C(0x3D607921), UINT32_C(0x3DBA9595), UINT32_C(0x5A6ECC40),
          UINT32_C(0x0188A5D6), UINT32_C(0x6CFF4ADE), UINT32_C(0x0EAB43C1),
          UINT32_C(0xDE3347E0), UINT32_C(0x1F3673AE)}},
        {{UINT32_C(0x796593EE), UINT32_C(0x7300C4B3), UINT32_C(0xD8D926C3),
          UINT32_C(0x607E7E76), UINT32_C(0x77F9FD06), UINT32_C(0x1762CE26),
          UINT32_C(0xCEA891EB), UINT32_C(0x0D0478B3)},
         {UINT32_C(0x2618B09E), UINT32_C(0xB1129791), UINT32_C(0x33F928C9),
          UINT32_C(0x5F9D290D), UINT32_C(0xE6178DB0), UINT32_C(0xE3192631),
          UINT32_C(0x08576D3F), UINT32_C(0x21260AC8)}},
        {{UINT32_C(0x76968E1C), UINT32_C(0x899DAF2A), UINT32_C(0xF9C2B3E7),
          UINT32_C(0x0519DEA9), UINT32_C(0x93D0BD4E), UINT32_C(0x5FDADC38),
          UINT32_C(0x43B4D98F), UINT32_C(0x0467BFF7)},
         {UINT32_C(0x6F3936C9), UINT32_C(0x651C316C), UINT32_C(0xAF27DF8B),
          UINT32_C(0xE757689A), UINT32_C(0xA0FA9188), UINT32_C(0x3AB037EA),
          UINT32_C(0xD927B60A), UINT32_C(0x2F8B039B)}},
    },
    {
        {{UINT32_C(0xDE876A70), UINT32_C(0x72211BF5), UINT32_C(0x73D121CE),
          UINT32_C(0xA8361631), UINT32_C(0x23D419E4), UINT32_C(0x23852721),
          UINT32_C(0xDBD03345), UINT32_C(0x3F56D47E)},
         {UINT32_C(0xD6F05BAC), UINT32_C(0xFB0E91A5), UINT32_C(0xAC9D0F46),
          UINT32_C(0xA0E02BF6), UINT32_C(0x97F1812F), UINT32_C(0x5ED9EA2C),
          UINT32_C(0xEBD5DB5A), UINT32_C(0x172F564F)}},
        {{UINT32_C(0x81F11E58), UINT32_C(0xC790E912), UINT32_C(0x99A5DFF7),
          UINT32_C(0x14A17630), UINT32_C(0x1627516D), UINT32_C(0xF6F30F2F),
          UINT32_C(0xEFCF43B7), UINT32_C(0x522CAD8F)},
         {UINT32_C(0x6EA01128), UINT32_C(0xFFADD45E), UINT32_C(0xD61D1964),
          UINT32_C(0x5D23234C), UINT32_C(0x2802DF86), UINT32_C(0xE9212C85),
          UINT32_C(0x92AA8DA3), UINT32_C(0x0A3D237B)}},
        {{UINT32_C(0xE50ED356), UINT32_C(0x2CED05F4), UINT32_C(0xBFFEEF3A),
          UINT32_C(0x1CBC7FB1), UINT32_C(0xBE19F0F0), UINT32_C(0x885991B1),
          UINT32_C(0xDE44A492), UINT32_C(0x6DED0794)},
         {UINT32_C(0x44CBECFC), UINT32_C(0x9967E834), UINT32_C(0x6A792ED1),
          UINT32_C(0xB0674A8D), UINT32_C(0xB7DDD557), UINT32_C(0x360E2DE4),
          UINT32_C(0x70E95D26), UINT32_C(0x26852A74)}},
        {{UINT32_C(0x3A6E2116), UINT32_C(0x8CBC1520), UINT32_C(0xBF285BBE),
          UINT32_C(0xF09327DF), UINT32_C(0x4A54D3C5), UINT32_C(0x8C7D9AD5),
          UINT32_C(0x6BD2768F), UINT32_C(0x778F54E6)},
         {UINT32_C(0x8FF3DBC0), UINT32_C(0x09B489F8), UINT32_C(0xD2871932),
          UINT32_C(0x0A0FA7FB), UINT32_C(0xE0A8CEC4), UINT32_C(0xABB9DC38),
          UINT32_C(0x21E37A50), UINT32_C(0x2EE092D8)}},
        {{UINT32_C(0xAF6D88D8), UINT32_C(0xBB9256E7), UINT32_C(0x0A218927),
          UINT32_C(0x3CDCB1CB), UINT32_C(0xF216D6E6), UINT32_C(0x8E5B744A),
          UINT32_C(0xBC885AFD), UINT32_C(0x6F0617F2)},
         {UINT32_C(0x268397D5), UINT32_C(0xFBA9CDA7), UINT32_C(0x5D4C75D8),
          UINT32_C(0xC6154716), UINT32_C(0x43FB2CD2), UINT32_C(0x9ED8D17B),
          UINT32_C(0xBE45BC5C), UINT32_C(0x4D0CE3FB)}},
        {{UINT32_C(0xA38472F5), UINT32_C(0x4259BB02), UINT32_C(0x15107D0E),
          UINT32_C(0xFAFAAE03), UINT32_C(0xCF0CF2B6), UINT32_C(0x2B8E450E),
          UINT32_C(0xED887C3A), UINT32_C(0x788674C3)},
         {UINT32_C(0x4B3D2EAC), UINT32_C(0x1F3EBD59), UINT32_C(0x75E41B55),
          UINT32_C(0x82CB5684), UINT32_C(0xC02BE49A), UINT32_C(0x005AB76B),
          UINT32_C(0xF5F90FEE), UINT32_C(0x6F13ADD2)}},
        {{UINT32_C(0x7AFA7161), UINT32_C(0x0116374A), UINT32_C(0x2DB7F824),
          UINT32_C(0x8A1AE448), UINT32_C(0xDB656A22), UINT32_C(0xD3C0DA12),
          UINT32_C(0xB989204D), UINT32_C(0x7B095B95)},
         {UINT32_C(0xEF8F21CA), UINT32_C(0x24C35202), UINT32_C(0x2DA5A5A1),
          UINT32_C(0x91088DA7), UINT32_C(0xE3F97D68), UINT32_C(0xAAF1944B),
          UINT32_C(0x7C884134), UINT32_C(0x245D2848)}},
        {{UINT32_C(0x68F5C702), UINT32_C(0xD80C65D6), UINT32_C(0x021A2974),
          UINT32_C(0xE2FE245F), UINT32_C(0x3A11899C), UINT32_C(0xFB8520E0),
          UINT32_C(0x2BE6BF88), UINT32_C(0x4806D1FA)},
         {UINT32_C(0x20ED235F), UINT32_C(0xF6F8C11A), UINT32_C(0x7F0D651E),
          UINT32_C(0x52AC1424), UINT32_C(0xDB9CF6D6), UINT32_C(0x44C3C89F),
          UINT32_C(0xB2E2E41F), UINT32_C(0x6762516D)}},
        {{UINT32_C(0xFDE91600), UINT32_C(0x2743D874), UINT32_C(0xCDF00100),
          UINT32_C(0x60975FD5), UINT32_C(0x2D2954F4), UINT32_C(0x78ACC864),
          UINT32_C(0x56373454), UINT32_C(0x46B9E602)},
         {UINT32_C(0x6F0FB867), UINT32_C(0x7586A970), UINT32_C(0x242DF35A),
          UINT32_C(0x888E3677), UINT32_C(0xF1460F62), UINT32_C(0x5A639E79),
          UINT32_C(0x55297DBC), UINT32_C(0x1256517E)}},
        {{UINT32_C(0x7B9294C3), UINT32_C(0x3F78339B), UINT32_C(0xBCE77012),
          UINT32_C(0x5BA765D1), UINT32_C(0x512E39E2), UINT32_C(0xA88E0CD8),
          UINT32_C(0xF6BA6A6A), UINT32_C(0x2D63E14B)},
         {UINT32_C(0xEA29071B), UINT32_C(0xF849A163), UINT32_C(0x4C0A2E22),
          UINT32_C(0xF32519B7), UINT32_C(0x561C35F5), UINT32_C(0xEA5D1315),
          UINT32_C(0xD9267DCA), UINT32_C(0x7041F515)}},
        {{UINT32_C(0x1FE56E6B), UINT32_C(0xE01E839F), UINT32_C(0x4A93CE88),
          UINT32_C(0x3E473D8C), UINT32_C(0x89AAFDAE), UINT32_C(0xC4846ECF),
          UINT32_C(0x07D946EA), UINT32_C(0x4111D97A)},
         {UINT32_C(0x51A45F02), UINT32_C(0xC20881F6), UINT32_C(0xB9CD841A),
          UINT32_C(0x14C2AC95), UINT32_C(0xF2CBD929), UINT32_C(0x2FBE8329),
          UINT32_C(0xC812608B), UINT32_C(0x1E8B7469)}},
        {{UINT32_C(0x007F0A5D), UINT32_C(0xB36A5D03), UINT32_C(0x5DCF7AF4),
          UINT32_C(0xA7E7A1A8), UINT32_C(0xBEB12AFB), UINT32_C(0x7227F4C5),
          UINT32_C(0x4D276783), UINT32_C(0x46227792)},
         {UINT32_C(0x48403B93), UINT32_C(0x9EA64D4C), UINT32_C(0x0B333ED5),
          UINT32_C(0x58EA31BC), UINT32_C(0xC5C93119), UINT32_C(0x2D6DD219),
          UINT32_C(0x45069280), UINT32_C(0x385023A7)}},
        {{UINT32_C(0xF60C46AF), UINT32_C(0x8AB9B9EA), UINT32_C(0xE8B827C2),
          UINT32_C(0xFA1D3F08), UINT32_C(0x1BAD41DB), UINT32_C(0x78C6BFBC),
          UINT32_C(0x23BE0C1E), UINT32_C(0x527A0BED)},
         {UINT32_C(0x6ACCE641), UINT32_C(0x66212FD2), UINT32_C(0xEE6F78E7),
          UINT32_C(0x86125B0D), UINT32_C(0x58552A8C), UINT32_C(0xA2A02718),
          UINT32_C(0x7E9605C5), UINT32_C(0x594F2B77)}},
        {{UINT32_C(0x88A27989), UINT32_C(0x3FB1F6CF), UINT32_C(0xD96268B8),
          UINT32_C(0xBC4962F7), UINT32_C(0xB95E2A36), UINT32_C(0xBD8761E9),
          UINT32_C(0x046DEC63), UINT32_C(0x64AB934A)},
         {UINT32_C(0x2E53CF1A), UINT32_C(0xC64D1C59), UINT32_C(0x578C5E8C),
          UINT32_C(0xC9865A9B), UINT32_C(0x7A0359DE), UINT32_C(0x5ECA6232),
          UINT32_C(0xFB4685E5), UINT32_C(0x127DD136)}},
        {{UINT32_C(0x1AE320C9), UINT32_C(0xB0F7B071), UINT32_C(0x52525203),
          UINT32_C(0x09BF89BB), UINT32_C(0x709C5692), UINT32_C(0x97B20027),
          UINT32_C(0xEDBF6175), UINT32_C(0x16A62485)},
         {UINT32_C(0x394C50F9), UINT32_C(0x32C18836), UINT32_C(0xD3B98C19),
          UINT32_C(0x7D99468F), UINT32_C(0x2E8D2729), UINT32_C(0x8EBE5096),
          UINT32_C(0xE655F093), UINT32_C(0x4E75B3CC)}},
        {{UINT32_C(0x9EAE827E), UINT32_C(0xCBEFD1A2), UINT32_C(0xFBF4630D),
          UINT32_C(0xDE2D1234), UINT32_C(0x96086CDA), UINT32_C(0x1B3ADCF8),
          UINT32_C(0x2EA6CBA7), UINT32_C(0x43D3960E)},
         {UINT32_C(0x1CB5A0F7), UINT32_C(0x18321D1D), UINT32_C(0x47BEABB4),
          UINT32_C(0xDC94C6F9), UINT32_C(0x75AF6AB7), UINT32_C(0xFBACC6D5),
          UINT32_C(0x89B98E86), UINT32_C(0x0EE5D357)}},
    },
    {
        {{UINT32_C(0x062E0994), UINT32_C(0x3F01B4AA), UINT32_C(0x5C952259),
          UINT32_C(0x994B28B0), UINT32_C(0x0CDEEC70), UINT32_C(0x2678F8B8),
          UINT32_C(0x212436F3), UINT32_C(0x4D06AF84)},
         {UINT32_C(0x1CF27A98), UINT32_C(0xE9DF52FD), UINT32_C(0x0B7718F7),
          UINT32_C(0xD56B9FD1), UINT32_C(0xD9AEDA0D), UINT32_C(0x728BE624),
          UINT32_C(0x1A646888), UINT32_C(0x09871088)}},
        {{UINT32_C(0x9B586B13), UINT32_C(0xB1BC922D), UINT32_C(0x3CA3B1BA),
          UINT32_C(0x6C084C54), UINT32_C(0xCF322698), UINT32_C(0x54D196C7),
          UINT32_C(0x85D527E1), UINT32_C(0x06EC3A55)},
         {UINT32_C(0x2A57CAA1), UINT32_C(0x06918710), UINT32_C(0x65FD0F6B),
          UINT32_C(0x6AEAC07D), UINT32_C(0x0F512F84), UINT32_C(0xB66A34D7),
          UINT32_C(0xA44E6452), UINT32_C(0x3860C002)}},
        {{UINT32_C(0x0881608A), UINT32_C(0x17263B26), UINT32_C(0x56C18A7A),
          UINT32_C(0x78D556AA), UINT32_C(0xAC3A47AB), UINT32_C(0xA0826A1C),
          UINT32_C(0xB6933FF5), UINT32_C(0x61686A58)},
         {UINT32_C(0xDBCF2C4F), UINT32_C(0xEA9D8771), UINT32_C(0x6AB00426),
          UINT32_C(0x1C66EB02), UINT32_C(0x401C466A), UINT32_C(0xF8DAED2B),
          UINT32_C(0xDAAE8040), UINT32_C(0x1ED0A99A)}},
        {{UINT32_C(0x7208E58A), UINT32_C(0x31EFFC4B), UINT32_C(0xB4E4319E),
          UINT32_C(0x28868456), UINT32_C(0xD46AC4DA), UINT32_C(0x1059C249),
          UINT32_C(0x2279B362), UINT32_C(0x3589D212)},
         {UINT32_C(0x45552E92), UINT32_C(0xB28B8FAD), UINT32_C(0xC3AB8098),
          UINT32_C(0xC9E32541), UINT32_C(0xF14B35A1), UINT32_C(0x82604904),
          UINT32_C(0xDB68C214), UINT32_C(0x1E64A89F)}},
        {{UINT32_C(0xAB6947AF), UINT32_C(0xDF0E223D), UINT32_C(0x771670D0),
          UINT32_C(0xE74EF1D6), UINT32_C(0xF429F03B), UINT32_C(0x70A9AD21),
          UINT32_C(0x1385B8DC), UINT32_C(0x7CB1FA1F)},
         {UINT32_C(0x69053D24), UINT32_C(0x25ABC0A7), UINT32_C(0x6369D02E),
          UINT32_C(0x207FE30A), UINT32_C(0xC6E4EC2C), UINT32_C(0x57B76E3C),
          UINT32_C(0xB927CAB2), UINT32_C(0x2E03D2E3)}},
        {{UINT32_C(0x622D57AE), UINT32_C(0xEFA377FF), UINT32_C(0xA885951A),
          UINT32_C(0x41532F56), UINT32_C(0xCC69B9A8), UINT32_C(0x5ED89AA7),
          UINT32_C(0x295F5E84), UINT32_C(0x60BFF2EC)},
         {UINT32_C(0x1E5C3041), UINT32_C(0x411D65C3), UINT32_C(0x4B7772F8),
          UINT32_C(0xDB533F8B), UINT32_C(0x3BDD4AEA), UINT32_C(0x72CADEB6),
          UINT32_C(0x7C49E454), UINT32_C(0x0EC79DF2)}},
        {{UINT32_C(0x81D0B84B), UINT32_C(0x0C39332C), UINT32_C(0x95FF472B),
          UINT32_C(0xA76A9A3A), UINT32_C(0x31DB2BA6), UINT32_C(0xD12FEB99),
          UINT32_C(0x3683E53A), UINT32_C(0x4AAB9222)},
         {UINT32_C(0x24FC6271), UINT32_C(0x56CB18AF), UINT32_C(0x2544C72D),
          UINT32_C(0x671581D6), UINT32_C(0xFBD6F4D1), UINT32_C(0xCD136492),
          UINT32_C(0x3579EE09), UINT32_C(0x6C202318)}},
        {{UINT32_C(0xC103C348), UINT32_C(0xEDC5AF02), UINT32_C(0x155A103D),
          UINT32_C(0xDA32344E), UINT32_C(0xB0D1377E), UINT32_C(0xFF3A7679),
          UINT32_C(0x68F02750), UINT32_C(0x16091972)},
         {UINT32_C(0xD9E9C143), UINT32_C(0xD4C6360D), UINT32_C(0x968EE990),
          UINT32_C(0xE0ABA0EF), UINT32_C(0x97E4C9AE), UINT32_C(0x57816878),
          UINT32_C(0x9D63E32D), UINT32_C(0x5A4D167B)}},
        {{UINT32_C(0x50E25802), UINT32_C(0xB04BA525), UINT32_C(0x66912F15),
          UINT32_C(0x011DA36E), UINT32_C(0x19E0A182), UINT32_C(0x08D8B680),
          UINT32_C(0x2E462B0F), UINT32_C(0x66AA4AE8)},
         {UINT32_C(0xE0B9D283), UINT32_C(0x3227C3A6), UINT32_C(0xF2B2B096),
          UINT32_C(0x9BF8C4D0), UINT32_C(0xBA809EB7), UINT32_C(0x1E51416C),
          UINT32_C(0x2A67D346), UINT32_C(0x68411B75)}},
        {{UINT32_C(0x37A67F3B), UINT32_C(0xE55B1348), UINT32_C(0x96484391),
          UINT32_C(0x5E32D73C), UINT32_C(0x6256B91E), UINT32_C(0xC3F804D5),
          UINT32_C(0x03B0783B), UINT32_C(0x67F17A47)},
         {UINT32_C(0xDD2334AD), UINT32_C(0x2010EFEB), UINT32_C(0xB10FF052),
          UINT32_C(0xBD9965B5), UINT32_C(0xF58ACA52), UINT32_C(0x519CDA6D),
          UINT32_C(0x2FD3D394), UINT32_C(0x045BEEBE)}},
        {{UINT32_C(0xEA271BCD), UINT32_C(0x81722E2C), UINT32_C(0x0A4F1342),
          UINT32_C(0x393C082E), UINT32_C(0x53B345CE), UINT32_C(0x573F7CD5),
          UINT32_C(0x3D7B4292), UINT32_C(0x7AD71FE2)},
         {UINT32_C(0xDA8BECB8), UINT32_C(0xDA406D0A), UINT32_C(0x82FE66BC),
          UINT32_C(0x14FD41CA), UINT32_C(0x0A91DFFC), UINT32_C(0x80A41062),
          UINT32_C(0xF4F0CDEB), UINT32_C(0x33E38E10)}},
        {{UINT32_C(0x2529532C), UINT32_C(0x0234BF38), UINT32_C(0xA76CAE3B),
          UINT32_C(0x9F5D6342), UINT32_C(0xB3C50442), UINT32_C(0xC9944CB3),
          UINT32_C(0x8ABFAF17), UINT32_C(0x51752DF0)},
         {UINT32_C(0xA37B13FB), UINT32_C(0x2BFA58C4), UINT32_C(0xDDB14951),
          UINT32_C(0x19F80FDE), UINT32_C(0x7DCB927B), UINT32_C(0xDC7026AA),
          UINT32_C(0xAAB9FCBA), UINT32_C(0x57907272)}},
        {{UINT32_C(0xF3C046C2), UINT32_C(0xCE38712D), UINT32_C(0x47B29D0E),
          UINT32_C(0x21D1FDB0), UINT32_C(0xCD96D414), UINT32_C(0x7F746E0E),
          UINT32_C(0x636CFEA4), UINT32_C(0x72F07B52)},
         {UINT32_C(0xECE6382D), UINT32_C(0x0D8FE94F), UINT32_C(0x24229CA4),
          UINT32_C(0x9BFB4CBA), UINT32_C(0xE54388B0), UINT32_C(0xFAE55B77),
          UINT32_C(0xA188299F), UINT32_C(0x074EBC32)}},
        {{UINT32_C(0xE21DCCA2), UINT32_C(0x8AF2EBCD), UINT32_C(0x377487F2),
          UINT32_C(0x9916A6B6), UINT32_C(0xD8051D40), UINT32_C(0x607DC19A),
          UINT32_C(0x419DDE12), UINT32_C(0x7DFD53F4)},
         {UINT32_C(0x9AD07924), UINT32_C(0xD17D0D61), UINT32_C(0x173E266B),
          UINT32_C(0x14F7CE0F), UINT32_C(0x0281C9EB), UINT32_C(0x687FB853),
          UINT32_C(0x3361B273), UINT32_C(0x6B35CC1A)}},
        {{UINT32_C(0x16E02DE3), UINT32_C(0x7CD6369E), UINT32_C(0x1F35DFBC),
          UINT32_C(0x118EE0B1), UINT32_C(0x98B3EE60), UINT32_C(0x7D8C8DBD),
          UINT32_C(0x8D29EA17), UINT32_C(0x039806FC)},
         {UINT32_C(0xEC2C2597), UINT32_C(0x3C473872), UINT32_C(0x5E4EF521),
          UINT32_C(0x81294AF4), UINT32_C(0xC22A9D7C), UINT32_C(0x5ED048DB),
          UINT32_C(0x0A08C4D4), UINT32_C(0x3879E95B)}},
        {{UINT32_C(0x96A864FE), UINT32_C(0x0206E47F), UINT32_C(0xA55D0631),
          UINT32_C(0xC94F137A), UINT32_C(0x8E8408F8), UINT32_C(0x9C1B3D29),
          UINT32_C(0xB9193A5E), UINT32_C(0x150A4046)},
         {UINT32_C(0xCB1ADF21), UINT32_C(0x4E8F9345), UINT32_C(0x7BD5E1F9),
          UINT32_C(0x6ED14D8A), UINT32_C(0x60809F68), UINT32_C(0x70825329),
          UINT32_C(0xFA85A06C), UINT32_C(0x0D2F1C3B)}},
    },
    {
        {{UINT32_C(0xB5C810C3), UINT32_C(0x3C5ABE75), UINT32_C(0xE28F1E26),
          UINT32_C(0xEA2C3EF9), UINT32_C(0x8BF68280), UINT32_C(0xEEB1C568),
          UINT32_C(0x7AE69110), UINT32_C(0x5A165CEB)},
         {UINT32_C(0x44550DF1), UINT32_C(0xE36C6460), UINT32_C(0xDB909258),
          UINT32_C(0x6FB4B108), UINT32_C(0x17D4D8C5), UINT32_C(0xBFA14277),
          UINT32_C(0x927976D8), UINT32_C(0x744CAF23)}},
        {{UINT32_C(0x47EA55C7), UINT32_C(0xCBE70DF9), UINT32_C(0x535457AE),
          UINT32_C(0x8F8119AE), UINT32_C(0x7DAFD732), UINT32_C(0x1E3C69EC),
          UINT32_C(0x39D409A2), UINT32_C(0x1A2E162D)},
         {UINT32_C(0x5F81C227), UINT32_C(0xBD7576A1), UINT32_C(0xC86AC2C3),
          UINT32_C(0xA040AF9E), UINT32_C(0xC10FC749), UINT32_C(0x5690C059),
          UINT32_C(0x49CFAEC6), UINT32_C(0x20B26E88)}},
        {{UINT32_C(0xE3EF781E), UINT32_C(0x87AEBD1E), UINT32_C(0x1609A1F0),
          UINT32_C(0xBC794A62), UINT32_C(0x26E7F61B), UINT32_C(0x96D83142),
          UINT32_C(0xFC51D17D), UINT32_C(0x5198577F)},
         {UINT32_C(0x8E6D0124), UINT32_C(0xBFB5FAE2), UINT32_C(0xFFD5BD72),
          UINT32_C(0x91A7172B), UINT32_C(0x02832847), UINT32_C(0x474B0154),
          UINT32_C(0x59827FEB), UINT32_C(0x4BAF0B4C)}},
        {{UINT32_C(0xBA090294), UINT32_C(0x5EADAA8E), UINT32_C(0x11A6E9FA),
          UINT32_C(0x51401BC9), UINT32_C(0x1D2594CD), UINT32_C(0x78F11758),
          UINT32_C(0x82D203C2), UINT32_C(0x1811AD30)},
         {UINT32_C(0x53FD07CC), UINT32_C(0x554CC39A), UINT32_C(0xC7A05601),
          UINT32_C(0x055FC983), UINT32_C(0xD5A80B4B), UINT32_C(0xB3B34E95),
          UINT32_C(0x1819BC16), UINT32_C(0x72B4CF94)}},
        {{UINT32_C(0x514FAFD0), UINT32_C(0x0750E4F0), UINT32_C(0xAD61C7B1),
          UINT32_C(0x297D27E6), UINT32_C(0xA2D5D410), UINT32_C(0x701D743F),
          UINT32_C(0xC83B55C9), UINT32_C(0x535DD97B)},
         {UINT32_C(0x1CB11BB0), UINT32_C(0x2EE96DDE), UINT32_C(0x0914450F),
          UINT32_C(0xECEA32EA), UINT32_C(0x4CDBDA6A), UINT32_C(0x4FB81236),
          UINT32_C(0x233C8063), UINT32_C(0x5B75B6B2)}},
        {{UINT32_C(0xD69D6C6A), UINT32_C(0xF0A934A6), UINT32_C(0x3CC80AC9),
          UINT32_C(0x313E8977), UINT32_C(0x1E428B71), UINT32_C(0x74692B17),
          UINT32_C(0xE1BE662D), UINT32_C(0x0474FEFC)},
         {UINT32_C(0xAFFBF61B), UINT32_C(0xAA2FF6DB), UINT32_C(0x776983AF),
          UINT32_C(0xCE1594E1), UINT32_C(0x4D5A2596), UINT32_C(0xF00C665B),
          UINT32_C(0x7D414B9A), UINT32_C(0x30DD2449)}},
        {{UINT32_C(0xACC44AB3), UINT32_C(0xEF862DA2), UINT32_C(0x6EE7A44A),
          UINT32_C(0xBAD6857F), UINT32_C(0xD2F9027E), UINT32_C(0x57674BF9),
          UINT32_C(0x2ABF816E), UINT32_C(0x4D771CC3)},
         {UINT32_C(0xAC0F1348), UINT32_C(0x27BEFC18), UINT32_C(0x5E4F1202),
          UINT32_C(0xD83112EF), UINT32_C(0x8E9AAAE5), UINT32_C(0x3571BDE3),
          UINT32_C(0xC1379B13), UINT32_C(0x07284830)}},
        {{UINT32_C(0x72A8890C), UINT32_C(0xA4C2F36F), UINT32_C(0x5824B392),
          UINT32_C(0x22DF0E81), UINT32_C(0x5E720240), UINT32_C(0x50FAD77F),
          UINT32_C(0x03278F96), UINT32_C(0x1D152A69)},
         {UINT32_C(0xA7D80F17), UINT32_C(0x25A3E92E), UINT32_C(0x7EF32666),
          UINT32_C(0xBBF85B32), UINT32_C(0x27222E52), UINT32_C(0xBBB55687),
          UINT32_C(0x7582FE42), UINT32_C(0x756D22A6)}},
        {{UINT32_C(0x9BC9EAED), UINT32_C(0x0AE7493A), UINT32_C(0x0DDBB275),
          UINT32_C(0x9185F53F), UINT32_C(0xC3DFDBA7), UINT32_C(0x1585D068),
          UINT32_C(0x562E2455), UINT32_C(0x543208A1)},
         {UINT32_C(0xCBCF9535), UINT32_C(0x4C417D81), UINT32_C(0xE35DD6ED),
          UINT32_C(0xD2DC38D3), UINT32_C(0x346F03A4), UINT32_C(0x9DF1E014),
          UINT32_C(0xF0E772A6), UINT32_C(0x65736E3F)}},
        {{UINT32_C(0xCFB7FF06), UINT32_C(0x58684A7B), UINT32_C(0xC58E6316),
          UINT32_C(0x72CC4AFE), UINT32_C(0xA8BB508A), UINT32_C(0x2CA9BF30),
          UINT32_C(0xE2044C8C), UINT32_C(0x61576519)},
         {UINT32_C(0x8FF6D2B5), UINT32_C(0xE78FAD3D), UINT32_C(0xA934C7B2),
          UINT32_C(0x6E5B839F), UINT32_C(0xFAFA9F9B), UINT32_C(0xC1F3D367),
          UINT32_C(0xF8B2AFA4), UINT32_C(0x637CC398)}},
        {{UINT32_C(0xFE2B2639), UINT32_C(0xD6FC1806), UINT32_C(0x9E98A7F2),
          UINT32_C(0x1DB199B4), UINT32_C(0xC794F900), UINT32_C(0x0508763D),
          UINT32_C(0x3232E5AC), UINT32_C(0x363F1F7D)},
         {UINT32_C(0xBBDBB351), UINT32_C(0xDCF2AD74), UINT32_C(0x5A506BC6),
          UINT32_C(0x91F2EAF1), UINT32_C(0xB850088B), UINT32_C(0xBDE8459E),
          UINT32_C(0x3E1135AF), UINT32_C(0x52DF883B)}},
        {{UINT32_C(0xF93779DC), UINT32_C(0x12FD053A), UINT32_C(0x9E319E46),
          UINT32_C(0x3E3D8728), UINT32_C(0xE5E360AE), UINT32_C(0x4D631005),
          UINT32_C(0xB1B29A30), UINT32_C(0x4A8B5683)},
         {UINT32_C(0xA8CA45EF), UINT32_C(0x305E5E53), UINT32_C(0xC2914843),
          UINT32_C(0x59EACB45), UINT32_C(0x1988ECEA), UINT32_C(0x83677B7A),
          UINT32_C(0xD6FD53E8), UINT32_C(0x63D9CD36)}},
        {{UINT32_C(0xB77EB45F), UINT32_C(0xDF2DACF2), UINT32_C(0x55BBA70E),
          UINT32_C(0x3C1303E3), UINT32_C(0x4526A06C), UINT32_C(0x5AB8EB42),
          UINT32_C(0x7FE06BBC), UINT32_C(0x4D4FD216)},
         {UINT32_C(0xE1486ABC), UINT32_C(0x98C5ADCF), UINT32_C(0x07F86F3A),
          UINT32_C(0x9A503BFF), UINT32_C(0x56282E44), UINT32_C(0x7CEBAECB),
          UINT32_C(0x1F230DA0), UINT32_C(0x4FB09037)}},
        {{UINT32_C(0x27210752), UINT32_C(0xD1A37384), UINT32_C(0x02CF1C74),
          UINT32_C(0xD10794D6), UINT32_C(0x820CC08C), UINT32_C(0x48A2095A),
          UINT32_C(0xE3284B9D), UINT32_C(0x6DCDDE2E)},
         {UINT32_C(0x5D40510D), UINT32_C(0xB8C7203E), UINT32_C(0x5385E3A7),
          UINT32_C(0x957E8982), UINT32_C(0xE27D7C13), UINT32_C(0xD220BE2F),
          UINT32_C(0x7B471B5B), UINT32_C(0x2D104AC5)}},
        {{UINT32_C(0xBA0AFA8D), UINT32_C(0x3B31D52B), UINT32_C(0xDCC85F88),
          UINT32_C(0xFA9639F5), UINT32_C(0x8861DDD7), UINT32_C(0x15014637),
          UINT32_C(0x7B5443B0), UINT32_C(0x31C222DB)},
         {UINT32_C(0xC3CDD689), UINT32_C(0xE2618546), UINT32_C(0xD528A130),
          UINT32_C(0x7F3FB754), UINT32_C(0xAC5FAF99), UINT32_C(0xA0915810),
          UINT32_C(0xE9899CE5), UINT32_C(0x3863B890)}},
        {{UINT32_C(0x579C4353), UINT32_C(0xBDD42CA3), UINT32_C(0x4D65CB5B),
          UINT32_C(0xAD30567D), UINT32_C(0x6D91810B), UINT32_C(0x0E343F21),
          UINT32_C(0x42E19816), UINT32_C(0x65E0092D)},
         {UINT32_C(0xF84E8C8E), UINT32_C(0x76154DCC), UINT32_C(0x0BA4AE59),
          UINT32_C(0xBA147CA8), UINT32_C(0x56A1A71E), UINT32_C(0xCA8085E7),
          UINT32_C(0x1A158536), UINT32_C(0x1D90B4B0)}},
    },
    {
        {{UINT32_C(0xF8B6C26A), UINT32_C(0x5C4B7438), UINT32_C(0x645BBE80),
          UINT32_C(0x0C17A41B), UINT32_C(0x40CF3D85), UINT32_C(0xA386062D),
          UINT32_C(0xE78F776D), UINT32_C(0x563E42D2)},
         {UINT32_C(0x1F07459B), UINT32_C(0x4BB8E356), UINT32_C(0x75D222CD),
          UINT32_C(0xF01A24B7), UINT32_C(0x24CF3F61), UINT32_C(0xBE3D032B),
          UINT32_C(0x0AD5F3A3), UINT32_C(0x759B0167)}},
        {{UINT32_C(0x7D201AAB), UINT32_C(0x2F5AEBD1), UINT32_C(0xC0AE02AD),
          UINT32_C(0x7B14CBEE), UINT32_C(0xEDC6388B), UINT32_C(0xB9B54430),
          UINT32_C(0xB622E01F), UINT32_C(0x69E713FB)},
         {UINT32_C(0xC5361565), UINT32_C(0x4630EE8E), UINT32_C(0x5C8FB479),
          UINT32_C(0x6705961E), UINT32_C(0x07C2AA45), UINT32_C(0x125CC97E),
          UINT32_C(0x25AE3B12), UINT32_C(0x4BC459F4)}},
        {{UINT32_C(0x28CF94E4), UINT32_C(0xEF025496), UINT32_C(0x9DB24DE6),
          UINT32_C(0x04CFAB25), UINT32_C(0xC62254EF), UINT32_C(0x52B8C734),
          UINT32_C(0x568AB164), UINT32_C(0x0F2FE922)},
         {UINT32_C(0xE3F39B40), UINT32_C(0x48551A05), UINT32_C(0x31A7C7F6),
          UINT32_C(0x4A36865F), UINT32_C(0x840441AE), UINT32_C(0x4486512C),
          UINT32_C(0x8C7C4B4D), UINT32_C(0x559C6CAF)}},
        {{UINT32_C(0x0F103030), UINT32_C(0xFCC0D1DA), UINT32_C(0x39CD584E),
          UINT32_C(0x7A9F1D55), UINT32_C(0x681D0D37), UINT32_C(0x3EFB9B94),
          UINT32_C(0x4D842332), UINT32_C(0x3AE97CCD)},
         {UINT32_C(0x3C03676B), UINT32_C(0x85A8ECE1), UINT32_C(0x3AD435A1),
          UINT32_C(0x030F8775), UINT32_C(0x7F2D73B5), UINT32_C(0xF6019B4D),
          UINT32_C(0x2F14F911), UINT32_C(0x6B77E31A)}},
        {{UINT32_C(0x9186C671), UINT32_C(0x65C8161B), UINT32_C(0xCDFF2F8C),
          UINT32_C(0x412C3CC7), UINT32_C(0x2C2FEA33), UINT32_C(0xBFFC1719),
          UINT32_C(0xC3675845), UINT32_C(0x75DCF68B)},
         {UINT32_C(0x3B23D576), UINT32_C(0x0476AFBF), UINT32_C(0x19315F79),
          UINT32_C(0xB20CAEE2), UINT32_C(0x0885471A), UINT32_C(0x1BC2A859),
          UINT32_C(0xC328279C), UINT32_C(0x410FF6CF)}},
        {{UINT32_C(0x60569D94), UINT32_C(0x327394D9), UINT32_C(0x6EA39D95),
          UINT32_C(0xFF2AEB6A), UINT32_C(0xEA0CA3AE), UINT32_C(0x1BED71E8),
          UINT32_C(0x21072A94), UINT32_C(0x1000A81E)},
         {UINT32_C(0x73C02416), UINT32_C(0x368EA229), UINT32_C(0x0A4941BC),
          UINT32_C(0xDF5B2A42), UINT32_C(0xD0D40B3A), UINT32_C(0x4FFDC7B8),
          UINT32_C(0x48ABAB4E), UINT32_C(0x7B2C73F1)}},
        {{UINT32_C(0x81EE1072), UINT32_C(0x90FE34E4), UINT32_C(0x310E13D8),
          UINT32_C(0xAE7A2FF4), UINT32_C(0xCAB3927C), UINT32_C(0x6213D3B1),
          UINT32_C(0x7DC7E9EF), UINT32_C(0x44936FBD)},
         {UINT32_C(0x23A1BDBE), UINT32_C(0x3B898EF3), UINT32_C(0x54CC7B1D),
          UINT32_C(0x3FA6C6A0), UINT32_C(0xC6AC54F2), UINT32_C(0x41BCC3B5),
          UINT32_C(0xDC10AE39), UINT32_C(0x1AB5D168)}},
        {{UINT32_C(0xFEAF67A6), UINT32_C(0x1AED113C), UINT32_C(0x342AC459),
          UINT32_C(0x04E3C7A1), UINT32_C(0x7A99DFBC), UINT32_C(0x65A39278),
          UINT32_C(0x642329FF), UINT32_C(0x03ECBC6B)},
         {UINT32_C(0xA6A4421A), UINT32_C(0x799F4EC5), UINT32_C(0xBEE18B3C),
          UINT32_C(0x44522C26), UINT32_C(0x1975C4BB), UINT32_C(0x1C7BFF15),
          UINT32_C(0xE6A27857), UINT32_C(0x0FAA03BE)}},
        {{UINT32_C(0x0743FF7B), UINT32_C(0x173AB9E0), UINT32_C(0x2CFC95AE),
          UINT32_C(0xB11187AE), UINT32_C(0x9C112049), UINT32_C(0xCA81BB2E),
          UINT32_C(0xC03555D5), UINT32_C(0x6B811DB6)},
         {UINT32_C(0x4FE32256), UINT32_C(0x76C1FC14), UINT32_C(0xD0E47C4E),
          UINT32_C(0xDA8C5A96), UINT32_C(0x29FDB01C), UINT32_C(0xB645D413),
          UINT32_C(0xAC39502A), UINT32_C(0x78898447)}},
        {{UINT32_C(0x9BF44B35), UINT32_C(0x4285FF32), UINT32_C(0xE3358C7F),
          UINT32_C(0x207F9029), UINT32_C(0x63BAF4CE), UINT32_C(0x0FE8F032),
          UINT32_C(0xFF15E1F7), UINT32_C(0x698A0398)},
         {UINT32_C(0x7E572DF6), UINT32_C(0x54874843), UINT32_C(0x9F43C07B),
          UINT32_C(0x74683519), UINT32_C(0x0A433D6A), UINT32_C(0x47BAB49E),
          UINT32_C(0xFAB5C858), UINT32_C(0x09ED8740)}},
        {{UINT32_C(0x1F6CA820), UINT32_C(0x8AA5E5C9), UINT32_C(0xD3C25BEC),
          UINT32_C(0xAD290A94), UINT32_C(0x3BA255F0), UINT32_C(0xDC4C67BF),
          UINT32_C(0x1DEDD8A9), UINT32_C(0x0D7EF7D9)},
         {UINT32_C(0x5EEFD1C3), UINT32_C(0x0831A26F), UINT32_C(0x04483E0C),
          UINT32_C(0x78CA66F5), UINT32_C(0x2FAAC15A), UINT32_C(0x9D5A5612),
          UINT32_C(0x5D6FACDB), UINT32_C(0x43B0C7E7)}},
        {{UINT32_C(0x4503899D), UINT32_C(0x34BA537C), UINT32_C(0x2AF8ED3B),
          UINT32_C(0x9DEBC8F5), UINT32_C(0x84F416E6), UINT32_C(0x396995E9),
          UINT32_C(0xC7BCE392), UINT32_C(0x77F10FED)},
         {UINT32_C(0x1F8AF262), UINT32_C(0x065CCB72), UINT32_C(0xD2F00FC4),
          UINT32_C(0xE220ED60), UINT32_C(0x5EE25B46), UINT32_C(0x41A5FB06),
          UINT32_C(0xDD9070B1), UINT32_C(0x22505574)}},
        {{UINT32_C(0x44BFC5C0), UINT32_C(0x571FF151), UINT32_C(0x3138363C),
          UINT32_C(0xBE2558B8), UINT32_C(0x605E356C), UINT32_C(0xB2211ABD),
          UINT32_C(0x176C5F53), UINT32_C(0x0B6435DA)},
         {UINT32_C(0x8DCF484E), UINT32_C(0xF18C917C), UINT32_C(0xCD93D65F),
          UINT32_C(0x45D4120C), UINT32_C(0x190AE7F8), UINT32_C(0xEBB0BF9C),
          UINT32_C(0x8D8C8D5A), UINT32_C(0x3D403DE2)}},
        {{UINT32_C(0xBE656644), UINT32_C(0xCDE760B4), UINT32_C(0x2D21DBC5),
          UINT32_C(0x99DC5E6D), UINT32_C(0xB6232D08), UINT32_C(0x644FCAF3),
          UINT32_C(0x859341E3), UINT32_C(0x52955488)},
         {UINT32_C(0x25763919), UINT32_C(0x3AB4580D), UINT32_C(0x4EF66999),
          UINT32_C(0x82AB0C53), UINT32_C(0x0180663E), UINT32_C(0xBD395C74),
          UINT32_C(0xB4756474), UINT32_C(0x07974F1A)}},
        {{UINT32_C(0x31588EA6), UINT32_C(0x8C15CFE7), UINT32_C(0xF36C882D),
          UINT32_C(0x9629060E), UINT32_C(0x862B080D), UINT32_C(0xDF8E8E9E),
          UINT32_C(0xD7A0C5BE), UINT32_C(0x0BD36B48)},
         {UINT32_C(0x76DA047B), UINT32_C(0xEBD0C6C9), UINT32_C(0xBB94FD5A),
          UINT32_C(0x4F0F08AB), UINT32_C(0x74910D9F), UINT32_C(0x33D41A4E),
          UINT32_C(0xA9583754), UINT32_C(0x3D6F8D0B)}},
        {{UINT32_C(0x4E4FC72E), UINT32_C(0xEC4C896E), UINT32_C(0x002ECE31),
          UINT32_C(0xB111210C), UINT32_C(0x2AF11E21), UINT32_C(0x7204D937),
          UINT32_C(0x5D0509E9), UINT32_C(0x59B9C1EC)},
         {UINT32_C(0xF9D5BBC0), UINT32_C(0xBC97644C), UINT32_C(0x31B4E869),
          UINT32_C(0x25B123AF), UINT32_C(0x5A6CAAB0), UINT32_C(0x091D7AEC),
          UINT32_C(0xECC911C4), UINT32_C(0x340B9E80)}},
    },
    {
        {{UINT32_C(0xEC208406), UINT32_C(0xE8036B20), UINT32_C(0x214CEB5A),
          UINT32_C(0xAF46A05A), UINT32_C(0x46CC8379), UINT32_C(0x8672084A),
          UINT32_C(0x04BA7885), UINT32_C(0x7DE0A42F)},
         {UINT32_C(0xC9D3F32A), UINT32_C(0xB772BEDC), UINT32_C(0x534B1520),
          UINT32_C(0x7DAE3680), UINT32_C(0xEC7120CC), UINT32_C(0x04CD6203),
          UINT32_C(0xB4E99780), UINT32_C(0x032F88E3)}},
        {{UINT32_C(0xE4A0897E), UINT32_C(0xB34BDA5C), UINT32_C(0x379B2480),
          UINT32_C(0xF7748B26), UINT32_C(0xB2D97522), UINT32_C(0xF47F6646),
          UINT32_C(0xF9641DB9), UINT32_C(0x66AD8DE1)},
         {UINT32_C(0xD1BF09C0), UINT32_C(0x0F8EB919), UINT32_C(0xB95DC052),
          UINT32_C(0x7853BB4E), UINT32_C(0x62B1FD4A), UINT32_C(0xBE7EE13D),
          UINT32_C(0xDC7CE53E), UINT32_C(0x2FF7EDC5)}},
        {{UINT32_C(0xEE81DF35), UINT32_C(0xE1009AA0), UINT32_C(0x61D0798B),
          UINT32_C(0x14972F02), UINT32_C(0xF1EA1A6A), UINT32_C(0x5A6831A0),
          UINT32_C(0x0CAB301A), UINT32_C(0x1DBABA3D)},
         {UINT32_C(0x157D5213), UINT32_C(0x421270E2), UINT32_C(0x6407B790),
          UINT32_C(0xA37BEA95), UINT32_C(0x103A6073), UINT32_C(0xEAD56B1F),
          UINT32_C(0xBAD909F1), UINT32_C(0x27534624)}},
        {{UINT32_C(0xC2621EF1), UINT32_C(0xC92D2209), UINT32_C(0x1D3AD3F3),
          UINT32_C(0x450710C3), UINT32_C(0x19E481AD), UINT32_C(0x8CFB8D6C),
          UINT32_C(0xE6DB01BD), UINT32_C(0x35CACDAE)},
         {UINT32_C(0x7CDD5B01), UINT32_C(0x2DA4A1D8), UINT32_C(0x0F55BA11),
          UINT32_C(0x3E40C751), UINT32_C(0xB15C162D), UINT32_C(0xA91D9EE7),
          UINT32_C(0x11DBA157), UINT32_C(0x13AD3BE5)}},
        {{UINT32_C(0xE72F64F5), UINT32_C(0xAE417DB0), UINT32_C(0xF13352BA),
          UINT32_C(0x40822279), UINT32_C(0x1F2B75B9), UINT32_C(0xEC43AFD9),
          UINT32_C(0xC9CF2972), UINT32_C(0x14D4BB2B)},
         {UINT32_C(0x0761B2F1), UINT32_C(0x4A55718A), UINT32_C(0xD81A9307),
          UINT32_C(0xDAFBF756), UINT32_C(0x5D3E5A07), UINT32_C(0x2DCDFC1C),
          UINT32_C(0x2EBBDF28), UINT32_C(0x696E42ED)}},
        {{UINT32_C(0x68705410), UINT32_C(0xF4739399), UINT32_C(0xAF5FFC88),
          UINT32_C(0xFD581005), UINT32_C(0x90A9F517), UINT32_C(0x5490A694),
          UINT32_C(0x8CF8327E), UINT32_C(0x4A5C8C2E)},
         {UINT32_C(0xF7D83DA6), UINT32_C(0xC203CD35), UINT32_C(0x7282368D),
          UINT32_C(0xECAA6B90), UINT32_C(0x2AF7EC42), UINT32_C(0x365BB571),
          UINT32_C(0xD4099316), UINT32_C(0x112E7ACD)}},
        {{UINT32_C(0x3AE3C25C), UINT32_C(0x9ABDE060), UINT32_C(0xEB9925B2),
          UINT32_C(0xE4C03DAD), UINT32_C(0x9E03388B), UINT32_C(0x3C28DCB1),
          UINT32_C(0x52B63C06), UINT32_C(0x2337A7CF)},
         {UINT32_C(0x4E1AF2EA), UINT32_C(0x74DC0F13), UINT32_C(0xCD0D59AA),
          UINT32_C(0xA010E4E3), UINT32_C(0x9FA14C96), UINT32_C(0x6E4DB7BA),
          UINT32_C(0x557F7CDE), UINT32_C(0x5B2C3862)}},
        {{UINT32_C(0xC8C79CA9), UINT32_C(0xC826E567), UINT32_C(0xE851BE0C),
          UINT32_C(0xE7D110CA), UINT32_C(0xA3606499), UINT32_C(0xFFD57057),
          UINT32_C(0xC6482504), UINT32_C(0x2E9DBC40)},
         {UINT32_C(0xF784D9AF), UINT32_C(0xC9F0C3C2), UINT32_C(0xB755172E),
          UINT32_C(0xDD982A05), UINT32_C(0xA023997F), UINT32_C(0x6BC6C19D),
          UINT32_C(0xE34493C6), UINT32_C(0x4AC177BE)}},
        {{UINT32_C(0x4FA4F134), UINT32_C(0x21C3E087), UINT32_C(0x86F9722F),
          UINT32_C(0x66E10C34), UINT32_C(0x7398579A), UINT32_C(0xD2927B01),
          UINT32_C(0x0352C3D3), UINT32_C(0x7135B638)},
         {UINT32_C(0x3BB5EE11), UINT32_C(0x2DA62007), UINT32_C(0x3A946236),
          UINT32_C(0x8B64F13C), UINT32_C(0x30EAE6DF), UINT32_C(0x3A83C854),
          UINT32_C(0x0EB6F749), UINT32_C(0x31114E2A)}},
        {{UINT32_C(0x35BFC72B), UINT32_C(0x2C7B52E7), UINT32_C(0x2B0D4C2C),
          UINT32_C(0x6DD29EBD), UINT32_C(0x6C92E82D), UINT32_C(0xE90D3988),
          UINT32_C(0x3864D94D), UINT32_C(0x0A924901)},
         {UINT32_C(0x9BEE9E78), UINT32_C(0x63050824), UINT32_C(0x003DD5CF),
          UINT32_C(0x7929FD62), UINT32_C(0xE57507D1), UINT32_C(0xD04F832C),
          UINT32_C(0x37D2C32E), UINT32_C(0x61078BDC)}},
        {{UINT32_C(0x2E75264A), UINT32_C(0xB118AFDD), UINT32_C(0xEFD65114),
          UINT32_C(0x3AB692EA), UINT32_C(0x8B0A2128), UINT32_C(0x58D2CE24),
          UINT32_C(0x82ED6D5F), UINT32_C(0x4316E6C2)},
         {UINT32_C(0x46345BE4), UINT32_C(0x97766FFF), UINT32_C(0x0A7451AA),
          UINT32_C(0xD7FF3014), UINT32_C(0xAACE2E37), UINT32_C(0x078A423F),
          UINT32_C(0xA6A78919), UINT32_C(0x7F1F90C2)}},
        {{UINT32_C(0x8E9E3D4D), UINT32_C(0x988FCCB0), UINT32_C(0xB95C9731),
          UINT32_C(0xBD003FC0), UINT32_C(0xB0A84E58), UINT32_C(0x74E40076),
          UINT32_C(0x1DF7FDD0), UINT32_C(0x5FD1DBE6)},
         {UINT32_C(0x4E6CE2FA), UINT32_C(0xD2C700C7), UINT32_C(0x903C5AE7),
          UINT32_C(0xA6E042E2), UINT32_C(0x3C73822E), UINT32_C(0x561CC25F),
          UINT32_C(0x2A6A0C0C), UINT32_C(0x651A7939)}},
        {{UINT32_C(0x88CD7642), UINT32_C(0x103E9EC6), UINT32_C(0x3C3C86CE),
          UINT32_C(0x65ED5218), UINT32_C(0x82785C8B), UINT32_C(0x16BAB002),
          UINT32_C(0xF34723C5), UINT32_C(0x0B5C18BB)},
         {UINT32_C(0xE724D144), UINT32_C(0x528B0546), UINT32_C(0x780EEF9E),
          UINT32_C(0x5E582A6B), UINT32_C(0x122F17AD), UINT32_C(0xC08283B8),
          UINT32_C(0x1C22F32D), UINT32_C(0x0300EDCD)}},
        {{UINT32_C(0x38DCFD39), UINT32_C(0x03AC716A), UINT32_C(0x94F12C74),
          UINT32_C(0xCD88474C), UINT32_C(0xE9042CA8), UINT32_C(0xB5E8641E),
          UINT32_C(0x40D10558), UINT32_C(0x1D5746CC)},
         {UINT32_C(0xCB4BB408), UINT32_C(0x7869F45E), UINT32_C(0x569489C3),
          UINT32_C(0x28FB091D), UINT32_C(0x50A46306), UINT32_C(0xEA371EEC),
          UINT32_C(0x75AA224C), UINT32_C(0x28025796)}},
        {{UINT32_C(0xF7A5923A), UINT32_C(0x4EAFA44E), UINT32_C(0x6B69FD8B),
          UINT32_C(0xD2427C30), UINT32_C(0x393D83F9), UINT32_C(0x4C4E884A),
          UINT32_C(0x6236AB65), UINT32_C(0x2D34890A)},
         {UINT32_C(0x35CC97F5), UINT32_C(0x80038D40), UINT32_C(0x97897472),
          UINT32_C(0x4FE43C84), UINT32_C(0xBEF161AF), UINT32_C(0xE5F56243),
          UINT32_C(0x9372E631), UINT32_C(0x3E1BDD6F)}},
        {{UINT32_C(0x5732669F), UINT32_C(0x06A2B287), UINT32_C(0xCDF4D2C0),
          UINT32_C(0x92D00397), UINT32_C(0x454A57F5), UINT32_C(0xCD9A25F0),
          UINT32_C(0x2F0CDB0B), UINT32_C(0x23ADB724)},
         {UINT32_C(0xFF0F8CB0), UINT32_C(0x504DA603), UINT32_C(0xD3E24181),
          UINT32_C(0x14EF9D30), UINT32_C(0x47FC1E66), UINT32_C(0xB1B1328E),
          UINT32_C(0x6C60354D), UINT32_C(0x319B2A84)}},
    },
    {
        {{UINT32_C(0xF1D56038), UINT32_C(0xBBF5542E), UINT32_C(0xDD71CFC3),
          UINT32_C(0xEDE3E637), UINT32_C(0x2E9F6C8B), UINT32_C(0xFAA81D21),
          UINT32_C(0x69FBD060), UINT32_C(0x4DD2D44B)},
         {UINT32_C(0x14366A20), UINT32_C(0x71FB6233), UINT32_C(0x9575451D),
          UINT32_C(0x155E486F), UINT32_C(0xEC7807D9), UINT32_C(0x001106F0),
          UINT32_C(0xC617034C), UINT32_C(0x1C80E5AB)}},
        {{UINT32_C(0x8619F5F4), UINT32_C(0xD3E478DB), UINT32_C(0xF68170C2),
          UINT32_C(0x1DF5C367), UINT32_C(0x3430DE1D), UINT32_C(0xEAB09524),
          UINT32_C(0xC3CD4C24), UINT32_C(0x48F09361)},
         {UINT32_C(0x60644FED), UINT32_C(0xE49DEA4B), UINT32_C(0x758C3679),
          UINT32_C(0x47170F1C), UINT32_C(0xB0382A84), UINT32_C(0x4CC1E6E8),
          UINT32_C(0x10A4465E), UINT32_C(0x2DBDB9DA)}},
        {{UINT32_C(0xC8400A4C), UINT32_C(0x67BAA79A), UINT32_C(0x01D28ECE),
          UINT32_C(0xFA306753), UINT32_C(0x6F33289C), UINT32_C(0x29DB5B1C),
          UINT32_C(0x26A8FCB4), UINT32_C(0x44757573)},
         {UINT32_C(0xE1B0A795), UINT32_C(0x59616219), UINT32_C(0xC5B32FA0),
          UINT32_C(0x3032D939), UINT32_C(0x7C3CEA2C), UINT32_C(0x3010C917),
          UINT32_C(0x9892BDF4), UINT32_C(0x5CF83EF1)}},
        {{UINT32_C(0x3C7E83E6), UINT32_C(0x55DE1141), UINT32_C(0x74EA0366),
          UINT32_C(0x9D03929C), UINT32_C(0x83BAF3FE), UINT32_C(0x5CA60C50),
          UINT32_C(0x7F70E905), UINT32_C(0x3D9BCA58)},
         {UINT32_C(0xFCC5AB59), UINT32_C(0xDB79DF5A), UINT32_C(0x53F68D30),
          UINT32_C(0x03CFCF06), UINT32_C(0x4FCFA5F1), UINT32_C(0xBE101A78),
          UINT32_C(0xB49E493C), UINT32_C(0x115D7078)}},
        {{UINT32_C(0x76A0CCBD), UINT32_C(0xF14023AA), UINT32_C(0x086F2E50),
          UINT32_C(0x4287F0BC), UINT32_C(0xF79A37E7), UINT32_C(0xC5EAA559),
          UINT32_C(0x04E4F2A2), UINT32_C(0x5D527C09)},
         {UINT32_C(0x51DAA504), UINT32_C(0xEC914616), UINT32_C(0xEEF1DC95),
          UINT32_C(0x250D90C6), UINT32_C(0xA50330B2), UINT32_C(0x1B0AA868),
          UINT32_C(0x54189BBE), UINT32_C(0x7B45A783)}},
        {{UINT32_C(0xF019D6FF), UINT32_C(0x0D602E05), UINT32_C(0xDD1800BA),
          UINT32_C(0x563E3893), UINT32_C(0xF3C7F7E5), UINT32_C(0x7146727E),
          UINT32_C(0x4B026635), UINT32_C(0x59641D98)},
         {UINT32_C(0xE91DDBB8), UINT32_C(0x50BCF90F), UINT32_C(0x7F8397A6),
          UINT32_C(0x5D43E78E), UINT32_C(0xEB15896E), UINT32_C(0x8734A261),
          UINT32_C(0x9FF6B361), UINT32_C(0x4AD1E864)}},
        {{UINT32_C(0x320322F1), UINT32_C(0x1A9B601F), UINT32_C(0x91F611C4),
          UINT32_C(0x606D40B3), UINT32_C(0xA19C918F), UINT32_C(0xB984958B),
          UINT32_C(0x776F834E), UINT32_C(0x67BFB045)},
         {UINT32_C(0x68DD85F0), UINT32_C(0xC59E5569), UINT32_C(0xD4067875),
          UINT32_C(0xB5642834), UINT32_C(0xCB138DF3), UINT32_C(0x247E7D65),
          UINT32_C(0x5CB9281D), UINT32_C(0x73640A03)}},
        {{UINT32_C(0x88639889), UINT32_C(0xC7C34CCC), UINT32_C(0xA785C707),
          UINT32_C(0xD9E44E07), UINT32_C(0x32F83073), UINT32_C(0x1BE68EFE),
          UINT32_C(0xAE5317CE), UINT32_C(0x249902DA)},
         {UINT32_C(0x76CA92FF), UINT32_C(0xF1F0B86A), UINT32_C(0xC01CB06B),
          UINT32_C(0xA7F502CF), UINT32_C(0x595AA185), UINT32_C(0x0A8B4766),
          UINT32_C(0xB792DE49), UINT32_C(0x614135AA)}},
        {{UINT32_C(0x564F2BC8), UINT32_C(0x5392CAA7), UINT32_C(0xCC894FCD),
          UINT32_C(0x1CDDA684), UINT32_C(0xA4EBF82F), UINT32_C(0x10AC2378),
          UINT32_C(0x5051BFF9), UINT32_C(0x6211EA46)},
         {UINT32_C(0x30E8E210), UINT32_C(0xE53B0174), UINT32_C(0x02C0E381),
          UINT32_C(0x2374FEC3), UINT32_C(0x4DA07224), UINT32_C(0xF8B1506B),
          UINT32_C(0x54DA7A08), UINT32_C(0x4E451E01)}},
        {{UINT32_C(0x241FC7FB), UINT32_C(0xA8404D9C), UINT32_C(0xC4406332),
          UINT32_C(0x1D6DBF6E), UINT32_C(0x30162118), UINT32_C(0xFE142319),
          UINT32_C(0xA7EF5EF5), UINT32_C(0x69DE75CC)},
         {UINT32_C(0x856E26A5), UINT32_C(0x008D4D09), UINT32_C(0xC588ECF6),
          UINT32_C(0x2BC64B65), UINT32_C(0xAA01EE19), UINT32_C(0x7A523D0B),
          UINT32_C(0x932F0B95), UINT32_C(0x213EF390)}},
        {{UINT32_C(0x1CD716FA), UINT32_C(0xA42FE513), UINT32_C(0x0E8001B6),
          UINT32_C(0xFB13B3C6), UINT32_C(0xD8F530CB), UINT32_C(0xBFDC7998),
          UINT32_C(0xF1C61761), UINT32_C(0x04F9C05B)},
         {UINT32_C(0xAFED9D64), UINT32_C(0xFB57396F), UINT32_C(0x421AC123),
          UINT32_C(0x28CCEE3A), UINT32_C(0xF6C21ACC), UINT32_C(0x32590C9B),
          UINT32_C(0xBCA75AE3), UINT32_C(0x503B97CB)}},
        {{UINT32_C(0x366946ED), UINT32_C(0x745208BC), UINT32_C(0x4C906596),
          UINT32_C(0xA75D88E9), UINT32_C(0xEE043530), UINT32_C(0x03A30C7E),
          UINT32_C(0xD11BF4D5), UINT32_C(0x5C67C151)},
         {UINT32_C(0xE7AE4BB3), UINT32_C(0x04F75DFA), UINT32_C(0x7F8D7404),
          UINT32_C(0xA0813606), UINT32_C(0x19D68F64), UINT32_C(0x8B9F9210),
          UINT32_C(0x06F73B55), UINT32_C(0x5AB67971)}},
        {{UINT32_C(0xB0687095), UINT32_C(0x08064C4A), UINT32_C(0xB0106DF4),
          UINT32_C(0x27E30DDD), UINT32_C(0x8482524A), UINT32_C(0x31D29C70),
          UINT32_C(0xD86FDACD), UINT32_C(0x65DD5896)},
         {UINT32_C(0xC647197E), UINT32_C(0x081C013D), UINT32_C(0xD7A53A45),
          UINT32_C(0x51C10B9E), UINT32_C(0x0DD7FC53), UINT32_C(0xACB9A4DE),
          UINT32_C(0xF646220B), UINT32_C(0x639997A2)}},
        {{UINT32_C(0x1FB93B43), UINT32_C(0x97CCF825), UINT32_C(0xE488D786),
          UINT32_C(0xB7D7713D), UINT32_C(0x3E4DBB33), UINT32_C(0x4F759566),
          UINT32_C(0xE0F09964), UINT32_C(0x13B5D8A1)},
         {UINT32_C(0x316CDD97), UINT32_C(0xFFDDAD74), UINT32_C(0x52C92EE9),
          UINT32_C(0x67C55782), UINT32_C(0x0AC5D6FD), UINT32_C(0x03B50F94),
          UINT32_C(0x1484DF88), UINT32_C(0x56C5C009)}},
        {{UINT32_C(0x1778D303), UINT32_C(0xDCE199E3), UINT32_C(0x0F1DD4EC),
          UINT32_C(0x53A2A4C6), UINT32_C(0x370A7B99), UINT32_C(0x7CC5EE9E),
          UINT32_C(0x2598744E), UINT32_C(0x4403202B)},
         {UINT32_C(0x228247B6), UINT32_C(0xCCFAA978), UINT32_C(0x4A1D0E27),
          UINT32_C(0xF50D14BD), UINT32_C(0x80723ABC), UINT32_C(0x66695061),
          UINT32_C(0x742C0015), UINT32_C(0x750CCB6A)}},
        {{UINT32_C(0x81A109F1), UINT32_C(0x7B046936), UINT32_C(0xD4C1AFE5),
          UINT32_C(0x6414D9A3), UINT32_C(0xDD14AC1F), UINT32_C(0x35070548),
          UINT32_C(0xDEC0D3F0), UINT32_C(0x27172F39)},
         {UINT32_C(0xF2E273F0), UINT32_C(0x4EE0A7BF), UINT32_C(0xEC82B8E6),
          UINT32_C(0x028C7813), UINT32_C(0x2081EAE2), UINT32_C(0x907BF09F),
          UINT32_C(0x414D6421), UINT32_C(0x72E4C3D3)}},
    },
    {
        {{UINT32_C(0xA073711C), UINT32_C(0x2064097E), UINT32_C(0x5A65EC25),
          UINT32_C(0x980D830A), UINT32_C(0xF0877567), UINT32_C(0x7906A87C),
          UINT32_C(0xF1980A3A), UINT32_C(0x3E5EAE10)},
         {UINT32_C(0x9272CE32), UINT32_C(0x5F51023A), UINT32_C(0xA437C974),
          UINT32_C(0x71D69E68), UINT32_C(0xD0B579FF), UINT32_C(0x32006EA1),
          UINT32_C(0xA436E129), UINT32_C(0x191935FF)}},
        {{UINT32_C(0x91C1474C), UINT32_C(0xE5FE2909), UINT32_C(0x1F0B10F5),
          UINT32_C(0x7350B9FA), UINT32_C(0x6B4AB128), UINT32_C(0x2006F41D),
          UINT32_C(0xCD95FA42), UINT32_C(0x4EBDA6CF)},
         {UINT32_C(0x5DA9A7F4), UINT32_C(0x45028938), UINT32_C(0x57FB462B),
          UINT32_C(0xD8129DE4), UINT32_C(0xE592EF90), UINT32_C(0x4F2BF2C9),
          UINT32_C(0xD6751DCC), UINT32_C(0x14A1A16B)}},
        {{UINT32_C(0xDE0CD47A), UINT32_C(0x7460BB84), UINT32_C(0x468CBA3D),
          UINT32_C(0x261F24D6), UINT32_C(0x1E3C2D8A), UINT32_C(0x229D3181),
          UINT32_C(0x1D19E059), UINT32_C(0x4AE520C9)},
         {UINT32_C(0xDF8DC66E), UINT32_C(0x5AC3AEE7), UINT32_C(0x299697EE),
          UINT32_C(0xCB417060), UINT32_C(0xCE97514F), UINT32_C(0x227C1497),
          UINT32_C(0x2E991FDE), UINT32_C(0x2589B803)}},
        {{UINT32_C(0xA97A5D03), UINT32_C(0x7FE9D585), UINT32_C(0x10D58157),
          UINT32_C(0x7333A1EF), UINT32_C(0xC94C3DF6), UINT32_C(0x54C1CCD2),
          UINT32_C(0x28073B4E), UINT32_C(0x25C1B252)},
         {UINT32_C(0x0635AD79), UINT32_C(0xEEB29AF9), UINT32_C(0x9AA38848),
          UINT32_C(0x880019C1), UINT32_C(0x30A9A497), UINT32_C(0x1A859942),
          UINT32_C(0x92B25ABA), UINT32_C(0x57EDCC2D)}},
        {{UINT32_C(0x65E19DE6), UINT32_C(0xA98DAE7D), UINT32_C(0x46AD8696),
          UINT32_C(0x8007DD17), UINT32_C(0xA7F3BBAD), UINT32_C(0x61F2E2CF),
          UINT32_C(0x54193858), UINT32_C(0x1EFCD387)},
         {UINT32_C(0x11666ECF), UINT32_C(0xFB54FD60), UINT32_C(0x36E7D371),
          UINT32_C(0xD97EA5DF), UINT32_C(0x3B9371FF), UINT32_C(0x944CA170),
          UINT32_C(0x05DE7FB0), UINT32_C(0x32A52CAC)}},
        {{UINT32_C(0x19ED8B5E), UINT32_C(0xB960FFF6), UINT32_C(0x660354BB),
          UINT32_C(0xFD6B4C3E), UINT32_C(0x1C9E95F0), UINT32_C(0xF8ECAADA),
          UINT32_C(0xA8E08CC7), UINT32_C(0x687A6D29)},
         {UINT32_C(0xC6A83D12), UINT32_C(0xD38B7670), UINT32_C(0x1265BF30),
          UINT32_C(0x1646064C), UINT32_C(0x2464892D), UINT32_C(0x7DE19FFE),
          UINT32_C(0x1BDBB729), UINT32_C(0x05B57E08)}},
        {{UINT32_C(0xFFB7A98A), UINT32_C(0xF3586B04), UINT32_C(0xCB072826),
          UINT32_C(0xF1850CDC), UINT32_C(0xCF53BFB0), UINT32_C(0xFA3E66A4),
          UINT32_C(0x06E07221), UINT32_C(0x7C78E567)},
         {UINT32_C(0x3B4E72AE), UINT32_C(0x21E6F245), UINT32_C(0xC6A3DBE8),
          UINT32_C(0x10A0D78B), UINT32_C(0xD618DDAB), UINT32_C(0xB9FC6D77),
          UINT32_C(0x76951DE5), UINT32_C(0x33092D13)}},
        {{UINT32_C(0x5A0257CB), UINT32_C(0xCAA1BF9D), UINT32_C(0x866C505F),
          UINT32_C(0x1044E224), UINT32_C(0x81482E7D), UINT32_C(0x9B514107),
          UINT32_C(0x88940BFB), UINT32_C(0x538CB867)},
         {UINT32_C(0xAC21DCC1), UINT32_C(0xACE68B78), UINT32_C(0x1609BF8C),
          UINT32_C(0x57942F3C), UINT32_C(0x66E48C7A), UINT32_C(0x30A47F32),
          UINT32_C(0xB0DA341F), UINT32_C(0x170D301D)}},
        {{UINT32_C(0x18ED9863), UINT32_C(0x19643EB2), UINT32_C(0xD9104F33),
          UINT32_C(0xBBE55BCC), UINT32_C(0xA15B283C), UINT32_C(0x77008B6C),
          UINT32_C(0x873A6A02), UINT32_C(0x2A6E0B41)},
         {UINT32_C(0x3CB9A225), UINT32_C(0x517410DF), UINT32_C(0xF538730A),
          UINT32_C(0x20D76E38), UINT32_C(0x9F8724F0), UINT32_C(0x76C9CAD6),
          UINT32_C(0x6BE9A035), UINT32_C(0x588BA106)}},
        {{UINT32_C(0xF842F66C), UINT32_C(0xA059DBEC), UINT32_C(0xB3ED0481),
          UINT32_C(0x59CA186D), UINT32_C(0xD454490F), UINT32_C(0xA5B2ABCB),
          UINT32_C(0x02624902), UINT32_C(0x4A0F6004)},
         {UINT32_C(0x4D2F605F), UINT32_C(0x45AF7B51), UINT32_C(0xC368030F),
          UINT32_C(0x57E8FE0F), UINT32_C(0x0C0727AE), UINT32_C(0x23B74557),
          UINT32_C(0x2B603EC4), UINT32_C(0x7E91EC77)}},
        {{UINT32_C(0xFD582BE8), UINT32_C(0xEDD284CF), UINT32_C(0x81093CDA),
          UINT32_C(0x3077CB23), UINT32_C(0xFDEA4FCE), UINT32_C(0xB1934840),
          UINT32_C(0xD7F01C9A), UINT32_C(0x00F9B9D1)},
         {UINT32_C(0x0A1C707B), UINT32_C(0xA55E5C5B), UINT32_C(0x2F8618A5),
          UINT32_C(0x05CD73CB), UINT32_C(0x512EEA05), UINT32_C(0x7327CECB),
          UINT32_C(0x8BF2A4D5), UINT32_C(0x5130A099)}},
        {{UINT32_C(0xFA7A1C7B), UINT32_C(0x34D18880), UINT32_C(0xFD4E043F),
          UINT32_C(0x5E0D6C53), UINT32_C(0x1B4442AE), UINT32_C(0xB4DD8010),
          UINT32_C(0x78ED7563), UINT32_C(0x59D9183E)},
         {UINT32_C(0xF1FAE158), UINT32_C(0x624DDAFC), UINT32_C(0x5C4C1E92),
          UINT32_C(0xC08C3653), UINT32_C(0xCE3E42EF), UINT32_C(0x452FD71F),
          UINT32_C(0x20B902EC), UINT32_C(0x175B4908)}},
        {{UINT32_C(0x18F4CE34), UINT32_C(0x5F0FDF24), UINT32_C(0x9B7E61B8),
          UINT32_C(0xA64A3011), UINT32_C(0x663362E2), UINT32_C(0x8109ACD5),
          UINT32_C(0x97F3DF44), UINT32_C(0x4D02F824)},
         {UINT32_C(0x3A4F916A), UINT32_C(0x2CE27CCE), UINT32_C(0x3B85B146),
          UINT32_C(0x4A4E6CBB), UINT32_C(0xDB8C9E5E), UINT32_C(0xFE7A6199),
          UINT32_C(0xD94B8D23), UINT32_C(0x53F5D620)}},
        {{UINT32_C(0xE77610A9), UINT32_C(0x37FEBEC3), UINT32_C(0x92245CB0),
          UINT32_C(0xE82D8EAC), UINT32_C(0xF79A31BC), UINT32_C(0x3FD2CEEA),
          UINT32_C(0xB446850C), UINT32_C(0x277ACF32)},
         {UINT32_C(0xCE1A2786), UINT32_C(0xD89FF4C7), UINT32_C(0xFFD3A23C),
          UINT32_C(0x441781E5), UINT32_C(0x07E85496), UINT32_C(0x7876EFC5),
          UINT32_C(0xE6F41B30), UINT32_C(0x0F306C7B)}},
        {{UINT32_C(0x5AB1B92B), UINT32_C(0x3BF2BFD1), UINT32_C(0xF373FCF2),
          UINT32_C(0xDCC3F5A6), UINT32_C(0xDA53C229), UINT32_C(0x27CFC4A6),
          UINT32_C(0x508E677F), UINT32_C(0x5885737C)},
         {UINT32_C(0x7B829F24), UINT32_C(0x1275D0F1), UINT32_C(0x4991B75B),
          UINT32_C(0xBD3C0B02), UINT32_C(0xE581C569), UINT32_C(0x3F82ACDF),
          UINT32_C(0x3F28904E), UINT32_C(0x12329435)}},
        {{UINT32_C(0x99C3A09B), UINT32_C(0xCF7BDCCC), UINT32_C(0x5F7D601A),
          UINT32_C(0x19191107), UINT32_C(0x39FBAA22), UINT32_C(0xA82F7460),
          UINT32_C(0xD75B5786), UINT32_C(0x3105A6FC)},
         {UINT32_C(0x932F69A6), UINT32_C(0x9673DAC4), UINT32_C(0xB57D6EE6),
          UINT32_C(0xF5664B25), UINT32_C(0x0A3CDD3E), UINT32_C(0x1EDAC112),
          UINT32_C(0x42778563), UINT32_C(0x3CF84F8C)}},
    },
    {
        {{UINT32_C(0x65DE3040), UINT32_C(0xE36FD1B7), UINT32_C(0x8AA0D3FE),
          UINT32_C(0x240EADEA), UINT32_C(0x7F77F804), UINT32_C(0x76971431),
          UINT32_C(0x591E9694), UINT32_C(0x6FCC933E)},
         {UINT32_C(0x18F48742), UINT32_C(0x3218D92B), UINT32_C(0x5E1B4001),
          UINT32_C(0x215F13E9), UINT32_C(0x7A8D69B9), UINT32_C(0xCDF333CD),
          UINT32_C(0xD2FD134F), UINT32_C(0x14F159B1)}},
        {{UINT32_C(0x07A50C16), UINT32_C(0x2D1228D6), UINT32_C(0x29AE42FD),
          UINT32_C(0x0DFD80F6), UINT32_C(0xBB8F3512), UINT32_C(0x6C18B122),
          UINT32_C(0x303F3DCA), UINT32_C(0x0FE61243)},
         {UINT32_C(0xDA50709B), UINT32_C(0x43A29F4D), UINT32_C(0x4B92BF7B),
          UINT32_C(0x3FF58C08), UINT32_C(0xDFCEF797), UINT32_C(0x62DC6B41),
          UINT32_C(0xC7B83F32), UINT32_C(0x43F9525A)}},
        {{UINT32_C(0x15F08F5B), UINT32_C(0x17EBBC9A), UINT32_C(0x8BB3E932),
          UINT32_C(0xBCD3B640), UINT32_C(0x510BBD36), UINT32_C(0xD46FBB9F),
          UINT32_C(0xCF65442B), UINT32_C(0x389ABBA8)},
         {UINT32_C(0xB575545C), UINT32_C(0x3A3DAFE4), UINT32_C(0xE1D0994D),
          UINT32_C(0x6AB985EC), UINT32_C(0x69E1DB27), UINT32_C(0xCC2A697B),
          UINT32_C(0x271581DC), UINT32_C(0x0D483E18)}},
        {{UINT32_C(0xC046D968), UINT32_C(0x380D4095), UINT32_C(0x55D3318B),
          UINT32_C(0x53039755), UINT32_C(0x91CE6FFC), UINT32_C(0x57FA7629),
          UINT32_C(0xA4ADB641), UINT32_C(0x0A0F2885)},
         {UINT32_C(0x6E5C2909), UINT32_C(0x8B99AF1B), UINT32_C(0xB8794175),
          UINT32_C(0xBDFE7FFD), UINT32_C(0x795ED786), UINT32_C(0x2CFB948A),
          UINT32_C(0x0FD0DF66), UINT32_C(0x11FE7465)}},
        {{UINT32_C(0x22E152E2), UINT32_C(0xFC2CC2BD), UINT32_C(0xE30BCEB3),
          UINT32_C(0xCF6AB96B), UINT32_C(0xBC89B689), UINT32_C(0xAE89C041),
          UINT32_C(0xE7523AB6), UINT32_C(0x6813430C)},
         {UINT32_C(0x40A4FA33), UINT32_C(0x3F49E728), UINT32_C(0x857CB0C9),
          UINT32_C(0x025DE1B7), UINT32_C(0x11EA5EA5), UINT32_C(0x6D71465A),
          UINT32_C(0x46C8D7CB), UINT32_C(0x6651F7B9)}},
        {{UINT32_C(0x5268098F), UINT32_C(0xD05F1DCE), UINT32_C(0x0DC75030),
          UINT32_C(0x891DBB68), UINT32_C(0xEA916291), UINT32_C(0xD939E428),
          UINT32_C(0xEA37D060), UINT32_C(0x5F8EECCC)},
         {UINT32_C(0x8DC5D544), UINT32_C(0x885F1EA8), UINT32_C(0x57E7448F),
          UINT32_C(0xFD3B3D17), UINT32_C(0x79531DE0), UINT32_C(0x5FC791A8),
          UINT32_C(0x42E66DAA), UINT32_C(0x780C1AAF)}},
        {{UINT32_C(0x397BB28F), UINT32_C(0x19697778), UINT32_C(0xAAA9069D),
          UINT32_C(0x5EC31D44), UINT32_C(0x3CA24A6F), UINT32_C(0xDC2DFEAA),
          UINT32_C(0x80BED770), UINT32_C(0x3F66CFCA)},
         {UINT32_C(0x1A102662), UINT32_C(0x2B6B8215), UINT32_C(0xC5D34CEB),
          UINT32_C(0x44B4D7A4), UINT32_C(0x88AFECF2), UINT32_C(0x17E0FDE6),
          UINT32_C(0xCFF8D214), UINT32_C(0x0DEFA14B)}},
        {{UINT32_C(0x8365CA84), UINT32_C(0x14035AA4), UINT32_C(0x197CE2B7),
          UINT32_C(0x309CEEF0), UINT32_C(0xED39AF37), UINT32_C(0x21305426),
          UINT32_C(0xD2EA583A), UINT32_C(0x10D01D11)},
         {UINT32_C(0x9FA5C766), UINT32_C(0x3F2E9749), UINT32_C(0xD70549D4),
          UINT32_C(0x98357584), UINT32_C(0xD279946D), UINT32_C(0x8FF80803),
          UINT32_C(0x99DF1253), UINT32_C(0x53DBC433)}},
        {{UINT32_C(0x5329F12F), UINT32_C(0x1D0D9EFA), UINT32_C(0xBE1F007F),
          UINT32_C(0xBC9F74CF), UINT32_C(0x18EE4DBC), UINT32_C(0xD7F2AA9A),
          UINT32_C(0x3A792753), UINT32_C(0x634BF4CF)},
         {UINT32_C(0x2FA6255A), UINT32_C(0xD5DC72AD), UINT32_C(0xF3BC00C5),
          UINT32_C(0xEE69EA43), UINT32_C(0xD8147A1A), UINT32_C(0xEA930F61),
          UINT32_C(0xF4E9AD37), UINT32_C(0x25E1368D)}},
        {{UINT32_C(0xB7C955EC), UINT32_C(0x9422AAF7), UINT32_C(0x6A74D634),
          UINT32_C(0x7C710761), UINT32_C(0x305EE420), UINT32_C(0x4ED89932),
          UINT32_C(0x2E937289), UINT32_C(0x07E42212)},
         {UINT32_C(0x28566C88), UINT32_C(0x7EBB2313), UINT32_C(0xC27ED656),
          UINT32_C(0xC7ED9C7A), UINT32_C(0xBF14FB3B), UINT32_C(0xF77F3873),
          UINT32_C(0xEB957520), UINT32_C(0x447AA1E5)}},
        {{UINT32_C(0xB5C5E016), UINT32_C(0x3E3CEC7E), UINT32_C(0xBDE44D26),
          UINT32_C(0xB33DDFF7), UINT32_C(0x66E820DD), UINT32_C(0x2056E9C7),
          UINT32_C(0xF8196FE2), UINT32_C(0x21A9E5D4)},
         {UINT32_C(0x88040C97), UINT32_C(0x86CB0A17), UINT32_C(0xFF515D49),
          UINT32_C(0x18AD8AE7), UINT32_C(0x226A400A), UINT32_C(0xCB8A564A),
          UINT32_C(0x8B72A0D2), UINT32_C(0x6DB48979)}},
        {{UINT32_C(0x6324DED2), UINT32_C(0x4365074B), UINT32_C(0xAEDAF0F8),
          UINT32_C(0x9EFB5CC6), UINT32_C(0xC0792B14), UINT32_C(0xCF952C3C),
          UINT32_C(0x97ED965E), UINT32_C(0x70B82AB9)},
         {UINT32_C(0x3ACEBCE7), UINT32_C(0x931B9886), UINT32_C(0x18C2425A),
          UINT32_C(0xDA850491), UINT32_C(0xE499F7FB), UINT32_C(0xD88E1E27),
          UINT32_C(0x960981DE), UINT32_C(0x61D3F246)}},
        {{UINT32_C(0x8393EB0A), UINT32_C(0x1D8EA227), UINT32_C(0x7863FB53),
          UINT32_C(0x9DCC23D2), UINT32_C(0xD5EBD297), UINT32_C(0x961B2337),
          UINT32_C(0x5BFED1E9), UINT32_C(0x0A96F8B2)},
         {UINT32_C(0xFE7DD2B7), UINT32_C(0x39EA1803), UINT32_C(0xE5F7772A),
          UINT32_C(0x7E4817BB), UINT32_C(0xD44A41EF), UINT32_C(0x3668C5FF),
          UINT32_C(0xE11F8E11), UINT32_C(0x78227653)}},
        {{UINT32_C(0xD024880B), UINT32_C(0x272D6933), UINT32_C(0xF236FD8A),
          UINT32_C(0x733C029F), UINT32_C(0x604868F0), UINT32_C(0xBA5C20BD),
          UINT32_C(0x321175C2), UINT32_C(0x33F211AE)},
         {UINT32_C(0x9FD79FE3), UINT32_C(0xE40010FB), UINT32_C(0xA685A59F),
          UINT32_C(0x9C6EA1DC), UINT32_C(0x8EB9889D), UINT32_C(0x79963FFC),
          UINT32_C(0x5F67108D), UINT32_C(0x15434E7D)}},
        {{UINT32_C(0xD68B670F), UINT32_C(0x42C14BBF), UINT32_C(0x23F1AA69),
          UINT32_C(0x2021AC9D), UINT32_C(0xAEA04636), UINT32_C(0xBF4C6D74),
          UINT32_C(0xBD1FB11D), UINT32_C(0x1E4D2F8E)},
         {UINT32_C(0x37911AA6), UINT32_C(0x4B0CF0E3), UINT32_C(0x2C484507),
          UINT32_C(0x7542D928), UINT32_C(0x889542DC), UINT32_C(0x68836751),
          UINT32_C(0xFE2282A0), UINT32_C(0x05F229F7)}},
        {{UINT32_C(0x409B2067), UINT32_C(0xAF269E8B), UINT32_C(0xA860F075),
          UINT32_C(0x6C749952), UINT32_C(0x5DF7C7F6), UINT32_C(0xCB7492DA),
          UINT32_C(0xE8E591E1), UINT32_C(0x2B010A7F)},
         {UINT32_C(0x04D9E871), UINT32_C(0xF7446577), UINT32_C(0x5E68408E),
          UINT32_C(0xC2E0A2A3), UINT32_C(0xD0F0BAAD), UINT32_C(0xD512E9A6),
          UINT32_C(0xC6BE34A3), UINT32_C(0x3E2F73E1)}},
    },
    {
        {{UINT32_C(0x2EC65BB4), UINT32_C(0x6C466C8E), UINT32_C(0xB1FC8F92),
          UINT32_C(0x912FFAE5), UINT32_C(0xB50A522D), UINT32_C(0x7587BE5D),
          UINT32_C(0x649847CF), UINT32_C(0x15939FF7)},
         {UINT32_C(0xF464794E), UINT32_C(0x69E81D63), UINT32_C(0x6D3F858E),
          UINT32_C(0x7BB6EEE3), UINT32_C(0x10813BBB), UINT32_C(0x24FE5C01),
          UINT32_C(0x6D80756C), UINT32_C(0x0C491F97)}},
        {{UINT32_C(0xA5FF3510), UINT32_C(0xBAD1C256), UINT32_C(0x99C1B7B2),
          UINT32_C(0xF06F38A2), UINT32_C(0x049312D6), UINT32_C(0xF7C0F164),
          UINT32_C(0x5749B3E4), UINT32_C(0x073C5374)},
         {UINT32_C(0x55211A81), UINT32_C(0xD6761480), UINT32_C(0xDFA98F45),
          UINT32_C(0xF34CB5DB), UINT32_C(0xB4AA4967), UINT32_C(0xAF59FA47),
          UINT32_C(0x8214BE48), UINT32_C(0x116935B9)}},
        {{UINT32_C(0x9FE10E46), UINT32_C(0x1D86FA00), UINT32_C(0x0B5B8494),
          UINT32_C(0x73B8099C), UINT32_C(0xA1102BE7), UINT32_C(0x9A6EA98D),
          UINT32_C(0x5514CA21), UINT32_C(0x3DE1948B)},
         {UINT32_C(0xD0AAAA53), UINT32_C(0x5D18ED69), UINT32_C(0x3C952B98),
          UINT32_C(0x17BF7DFF), UINT32_C(0x7DDBD937), UINT32_C(0xC60143FE),
          UINT32_C(0x6F2F10C4), UINT32_C(0x214F2F55)}},
        {{UINT32_C(0x02F047D0), UINT32_C(0xB2F28695), UINT32_C(0x923F52BF),
          UINT32_C(0x80952DFE), UINT32_C(0xA5017C3E), UINT32_C(0x56F3306B),
          UINT32_C(0x052DADFB), UINT32_C(0x5DD62F07)},
         {UINT32_C(0xD5274F90), UINT32_C(0xDD11592D), UINT32_C(0xE471965B),
          UINT32_C(0x40632FF3), UINT32_C(0x7E618430), UINT32_C(0xAD1939A8),
          UINT32_C(0x33F19556), UINT32_C(0x5DD9CAD2)}},
        {{UINT32_C(0xC1094747), UINT32_C(0x7B0AA88C), UINT32_C(0xF6753A0C),
          UINT32_C(0xCFA6B95D), UINT32_C(0x2A252A4D), UINT32_C(0xE81AFADA),
          UINT32_C(0xD3770570), UINT32_C(0x364CAB7C)},
         {UINT32_C(0xB4610A19), UINT32_C(0xE99D8252), UINT32_C(0x55ED9AD3),
          UINT32_C(0xB22B2FEC), UINT32_C(0xBEBE7FED), UINT32_C(0x328ACBDD),
          UINT32_C(0xFBEDFE84), UINT32_C(0x1D379D61)}},
        {{UINT32_C(0x5EDF8C9C), UINT32_C(0xD9EFFFFA), UINT32_C(0x0CE548EC),
          UINT32_C(0x9BAA7181), UINT32_C(0x5FA8FEEB), UINT32_C(0xEB458AEB),
          UINT32_C(0x0904D841), UINT32_C(0x18C5E691)},
         {UINT32_C(0x8F33D2E5), UINT32_C(0xFCEFAE28), UINT32_C(0x6FAFDA18),
          UINT32_C(0xB3CF853E), UINT32_C(0x427D6218), UINT32_C(0x05DE94BA),
          UINT32_C(0x3731D3E9), UINT32_C(0x021D8AED)}},
        {{UINT32_C(0xE92719DA), UINT32_C(0x06C8C318), UINT32_C(0x1A65DFDB),
          UINT32_C(0x1F7CDE12), UINT32_C(0x4B672A2D), UINT32_C(0x9B4D531E),
          UINT32_C(0x115FAF11), UINT32_C(0x3E39CC63)},
         {UINT32_C(0x0037AF60), UINT32_C(0xC9C3F339), UINT32_C(0x02B43D27),
          UINT32_C(0xC1C67587), UINT32_C(0xC42DF26B), UINT32_C(0x46B77CDD),
          UINT32_C(0xEBFA97A7), UINT32_C(0x7235F2B0)}},
        {{UINT32_C(0xE898094E), UINT32_C(0xAF7FFC9A), UINT32_C(0x146A27E3),
          UINT32_C(0x8D18AB93), UINT32_C(0x8AEC0416), UINT32_C(0x1376B797),
          UINT32_C(0x8D91C25E), UINT32_C(0x746A1B1C)},
         {UINT32_C(0x0EBDE2E3), UINT32_C(0x16DCCCC1), UINT32_C(0x8CE7D61E),
          UINT32_C(0xFE4ABD41), UINT32_C(0xE25F1551), UINT32_C(0xB9830395),
          UINT32_C(0xB885A943), UINT32_C(0x543493D7)}},
        {{UINT32_C(0x24EBCFC0), UINT32_C(0x52C659E6), UINT32_C(0xD38367A4),
          UINT32_C(0x72E3CA91), UINT32_C(0x4D168F4F), UINT32_C(0xA3086AAC),
          UINT32_C(0x5D64207B), UINT32_C(0x656ACFEE)},
         {UINT32_C(0xBA196A9E), UINT32_C(0xBE697CBA), UINT32_C(0x97DFFEC2),
          UINT32_C(0x6A737ACC), UINT32_C(0x54F04DBD), UINT32_C(0x393E2661),
          UINT32_C(0x4B0E92BD), UINT32_C(0x4FFF7C24)}},
        {{UINT32_C(0x828EC659), UINT32_C(0xC709CC59), UINT32_C(0xCBDEACB3),
          UINT32_C(0xB275AC8C), UINT32_C(0xF7922523), UINT32_C(0xA8D08921),
          UINT32_C(0x400A6459), UINT32_C(0x68B92F96)},
         {UINT32_C(0xDFBECB97), UINT32_C(0x45803EC2), UINT32_C(0x7515D696),
          UINT32_C(0x49464E05), UINT32_C(0x8F03E969), UINT32_C(0xF39CA961),
          UINT32_C(0x1CD7C79F), UINT32_C(0x605065A1)}},
        {{UINT32_C(0x97F1A97A), UINT32_C(0xB91C03DC), UINT32_C(0x201FFB53),
          UINT32_C(0x2F6D50BB), UINT32_C(0x46241856), UINT32_C(0x39D67D40),
          UINT32_C(0x74D04805), UINT32_C(0x0A2C0256)},
         {UINT32_C(0x28374A6D), UINT32_C(0xD289B94C), UINT32_C(0x10EDD6FC),
          UINT32_C(0x1176C73A), UINT32_C(0x56AE631E), UINT32_C(0x890E9C39),
          UINT32_C(0x6027F549), UINT32_C(0x30451CF1)}},
        {{UINT32_C(0xDF8F4DDB), UINT32_C(0x0CB33FDC), UINT32_C(0x87FF6E63),
          UINT32_C(0xD9C540DE), UINT32_C(0x55A1D8E4), UINT32_C(0xD8445732),
          UINT32_C(0x8AC403A6), UINT32_C(0x1497403D)},
         {UINT32_C(0x6A4BAAC6), UINT32_C(0xA2591C40), UINT32_C(0x48DD3E5D),
          UINT32_C(0xF493CF1F), UINT32_C(0xB69AF047), UINT32_C(0x7B9AE39F),
          UINT32_C(0x3782B110), UINT32_C(0x293123C0)}},
        {{UINT32_C(0xB7A36B62), UINT32_C(0x14921836), UINT32_C(0x4CA3AA39),
          UINT32_C(0x5AC82430), UINT32_C(0x52F601CA), UINT32_C(0x01303AA6),
          UINT32_C(0x2B43BB72), UINT32_C(0x7EE1E6C7)},
         {UINT32_C(0x64D44957), UINT32_C(0x7F82B37B), UINT32_C(0xDA4A6FEC),
          UINT32_C(0x840D0654), UINT32_C(0x0290F75D), UINT32_C(0xFC806FA1),
          UINT32_C(0x4C62F0E8), UINT32_C(0x3027FE4A)}},
        {{UINT32_C(0xCD0D3AC0), UINT32_C(0x34E68AB5), UINT32_C(0xE9BC85BD),
          UINT32_C(0xE6B0B8C1), UINT32_C(0x99533831), UINT32_C(0xE00F5052),
          UINT32_C(0xCDC83750), UINT32_C(0x11327DA7)},
         {UINT32_C(0x4656A428), UINT32_C(0x6D991DF0), UINT32_C(0x86228F26),
          UINT32_C(0x6A7BE349), UINT32_C(0x3019CDC5), UINT32_C(0x6BF85E3D),
          UINT32_C(0x576913A4), UINT32_C(0x42200D2F)}},
        {{UINT32_C(0x707B940F), UINT32_C(0x420D9259), UINT32_C(0x3C5E39BB),
          UINT32_C(0x1BB1FFE1), UINT32_C(0xE40D018E), UINT32_C(0x83D6BA36),
          UINT32_C(0x044EC576), UINT32_C(0x139BD842)},
         {UINT32_C(0xC6DE63E8), UINT32_C(0x3C79F8D2), UINT32_C(0x96F1FB0B),
          UINT32_C(0x49150B1D), UINT32_C(0x1358A13B), UINT32_C(0x66616053),
          UINT32_C(0xD5DDFD9F), UINT32_C(0x187CA3CF)}},
        {{UINT32_C(0x8D5AEE84), UINT32_C(0x0675370F), UINT32_C(0xDC269114),
          UINT32_C(0x30AA7D65), UINT32_C(0x5AFC6DC1), UINT32_C(0x295F7FE8),
          UINT32_C(0x55674339), UINT32_C(0x49452029)},
         {UINT32_C(0xA6F209EC), UINT32_C(0x7EB1926B), UINT32_C(0xDC72C3E3),
          UINT32_C(0x5232B9D1), UINT32_C(0xAB52141B), UINT32_C(0xCD788D79),
          UINT32_C(0xFDD9611F), UINT32_C(0x3EB561BE)}},
    },
    {
        {{UINT32_C(0xE22241AD), UINT32_C(0x09DB342C), UINT32_C(0x2A566653),
          UINT32_C(0x2EAB852F), UINT32_C(0xCA6E59F3), UINT32_C(0x970843ED),
          UINT32_C(0xA18C2D89), UINT32_C(0x6490013E)},
         {UINT32_C(0xC7A691CC), UINT32_C(0x52293350), UINT32_C(0xB2079F14),
          UINT32_C(0x6544B49D), UINT32_C(0x52DCF090), UINT32_C(0xC49C5598),
          UINT32_C(0x8817A2C7), UINT32_C(0x4069B6FC)}},
        {{UINT32_C(0xC86B40F4), UINT32_C(0x0E4A4B0C), UINT32_C(0x51F6F853),
          UINT32_C(0x2B5350E1), UINT32_C(0x1033BEC4), UINT32_C(0xDE26FDE2),
          UINT32_C(0xC0E9B971), UINT32_C(0x4DE9D2E7)},
         {UINT32_C(0xD315AD57), UINT32_C(0x716605FD), UINT32_C(0x392B101A),
          UINT32_C(0x5627D732), UINT32_C(0x81A9F40A), UINT32_C(0x628EDFC6),
          UINT32_C(0x5AB9C99D), UINT32_C(0x4BD2A96C)}},
        {{UINT32_C(0xBFBD288A), UINT32_C(0x2C8DF2A1), UINT32_C(0xF4CF7C09),
          UINT32_C(0x260C4F1E), UINT32_C(0x90E796CB), UINT32_C(0x88A26186),
          UINT32_C(0x323E0702), UINT32_C(0x105ACC3A)},
         {UINT32_C(0x667664CF), UINT32_C(0xA8ADA467), UINT32_C(0x3B518622),
          UINT32_C(0x41144C1B), UINT32_C(0xD8B99FE1), UINT32_C(0x4A532B87),
          UINT32_C(0x2289C308), UINT32_C(0x4A51C289)}},
        {{UINT32_C(0x1D6F6880), UINT32_C(0x201DDA61), UINT32_C(0x62029898),
          UINT32_C(0x47A964D4), UINT32_C(0x426C8CA5), UINT32_C(0xE44E2EEE),
          UINT32_C(0x09625DBA), UINT32_C(0x02A51821)},
         {UINT32_C(0xB45B3DFB), UINT32_C(0x170C626E), UINT32_C(0x5C8343A9),
          UINT32_C(0xFC7F1F71), UINT32_C(0xE549F040), UINT32_C(0xE6CF246F),
          UINT32_C(0x2F903ACE), UINT32_C(0x4ACF60AE)}},
        {{UINT32_C(0x81C807EC), UINT32_C(0x91715352), UINT32_C(0x47174A58),
          UINT32_C(0x72AC60C3), UINT32_C(0xA0F12F61), UINT32_C(0xAD62D06F),
          UINT32_C(0xAA899C0D), UINT32_C(0x325C2792)},
         {UINT32_C(0x9D8BA267), UINT32_C(0x53A1E392), UINT32_C(0xCDACCB05),
          UINT32_C(0x5DC088A5), UINT32_C(0x5025CB69), UINT32_C(0x5BB9127F),
          UINT32_C(0x69214616), UINT32_C(0x25D2B42E)}},
        {{UINT32_C(0xDDB55121), UINT32_C(0x4DE5D58A), UINT32_C(0x84DE0677),
          UINT32_C(0x688AA2F5), UINT32_C(0x63AA25E0), UINT32_C(0xF7925A39),
          UINT32_C(0x85D4DEA5), UINT32_C(0x4FB42FC7)},
         {UINT32_C(0x8F134390), UINT32_C(0x957B933B), UINT32_C(0x4B9BF8C2),
          UINT32_C(0xB360DD2C), UINT32_C(0xFFFF96CD), UINT32_C(0x45E6767F),
          UINT32_C(0x1E01D5C3), UINT32_C(0x26D0A6A9)}},
        {{UINT32_C(0x5A0A98EA), UINT32_C(0xC7FC5714), UINT32_C(0xE7535AF6),
          UINT32_C(0xDBB06F30), UINT32_C(0xDF4ACD0D), UINT32_C(0x555B22E3),
          UINT32_C(0x2EFD2FBE), UINT32_C(0x3A011AAF)},
         {UINT32_C(0xE9166B20), UINT32_C(0x341C7733), UINT32_C(0xFB19590A),
          UINT32_C(0x84619E8E), UINT32_C(0x10574C96), UINT32_C(0x8EF989FD),
          UINT32_C(0x0F55F9A2), UINT32_C(0x61ACFAAE)}},
        {{UINT32_C(0x6DEAB094), UINT32_C(0x8C8A33F2), UINT32_C(0x96022EBC),
          UINT32_C(0x4A8E5D9F), UINT32_C(0x7DDA92E8), UINT32_C(0xA10DF82C),
          UINT32_C(0xD1CF3815), UINT32_C(0x33A19462)},
         {UINT32_C(0xA489D67F), UINT32_C(0xE3FF8E43), UINT32_C(0x225064AA),
          UINT32_C(0xD4B6136F), UINT32_C(0x92F5E662), UINT32_C(0xE1721D2A),
          UINT32_C(0xA90A33C6), UINT32_C(0x4C4F03D7)}},
        {{UINT32_C(0xA3463B4A), UINT32_C(0x70885B35), UINT32_C(0xDF9D0194),
          UINT32_C(0x974BC40E), UINT32_C(0x273957F4), UINT32_C(0x1AF71E18),
          UINT32_C(0x9900CB0D), UINT32_C(0x58EF684B)},
         {UINT32_C(0x20A49A4A), UINT32_C(0xB09970C8), UINT32_C(0x42067458),
          UINT32_C(0x3F28403F), UINT32_C(0xBD7D1AD5), UINT32_C(0x153FF2C4),
          UINT32_C(0xE97A90F7), UINT32_C(0x7912CC2E)}},
        {{UINT32_C(0x8F034D9F), UINT32_C(0xF653DF59), UINT32_C(0x1C409CCF),
          UINT32_C(0xCA167177), UINT32_C(0x175F3583), UINT32_C(0x21F47005),
          UINT32_C(0xFAAFB66F), UINT32_C(0x13B8A94B)},
         {UINT32_C(0x96052C8D), UINT32_C(0x64534EE3), UINT32_C(0x8D674024),
          UINT32_C(0x09304DD1), UINT32_C(0x0D7A7E2A), UINT32_C(0xEB468AC3),
          UINT32_C(0xCD62052C), UINT32_C(0x40347256)}},
        {{UINT32_C(0xFFF11C0E), UINT32_C(0x0F089165), UINT32_C(0x8D69A45C),
          UINT32_C(0x383562C9), UINT32_C(0x3125FE61), UINT32_C(0x7AB3EF9D),
          UINT32_C(0xE0735F3A), UINT32_C(0x32C042BC)},
         {UINT32_C(0x4E268D91), UINT32_C(0x420077C8), UINT32_C(0x44695B4F),
          UINT32_C(0x7FB42082), UINT32_C(0x448A133E), UINT32_C(0xFA83216F),
          UINT32_C(0x93062EB3), UINT32_C(0x1C660607)}},
        {{UINT32_C(0xEF9E04DE), UINT32_C(0xA0FCBACA), UINT32_C(0x5B86F69A),
          UINT32_C(0xAEF9EECB), UINT32_C(0xC39D4C99), UINT32_C(0x73D2E95F),
          UINT32_C(0x923A5BA8), UINT32_C(0x098C74F7)},
         {UINT32_C(0x4F68DECF), UINT32_C(0x5B8C95C8), UINT32_C(0x58976551),
          UINT32_C(0xCFF2E101), UINT32_C(0xBE5CAF91), UINT32_C(0x5032AE48),
          UINT32_C(0xE09BC8AE), UINT32_C(0x5CCB9008)}},
        {{UINT32_C(0x3714D3BF), UINT32_C(0x41A38F20), UINT32_C(0x17366520),
          UINT32_C(0x24136533), UINT32_C(0xFAE17B01), UINT32_C(0xF12F314C),
          UINT32_C(0xFC9AD43B), UINT32_C(0x4AA0C969)},
         {UINT32_C(0x8BBAC026), UINT32_C(0xD8AB5F72), UINT32_C(0x526992DC),
          UINT32_C(0x35128269), UINT32_C(0xD19880AA), UINT32_C(0xA2EF6E44),
          UINT32_C(0xDBF47628), UINT32_C(0x28BB3623)}},
        {{UINT32_C(0x3BA25C35), UINT32_C(0x294742BA), UINT32_C(0x061555B7),
          UINT32_C(0x39D3BC9B), UINT32_C(0xDE6EA1A0), UINT32_C(0x944E3ABC),
          UINT32_C(0x57EBD394), UINT32_C(0x4FDC6415)},
         {UINT32_C(0xE981E649), UINT32_C(0xB615C1DA), UINT32_C(0x8BE3C95F),
          UINT32_C(0xAF7EDB34), UINT32_C(0x71F7221F), UINT32_C(0x38573AE8),
          UINT32_C(0x668CF414), UINT32_C(0x1B30FF04)}},
        {{UINT32_C(0xA57A9A4E), UINT32_C(0x48EFF6A2), UINT32_C(0x74A59C19),
          UINT32_C(0x04BA2F73), UINT32_C(0x6779C5DA), UINT32_C(0x5FDE389D),
          UINT32_C(0x6612F160), UINT32_C(0x258E2B24)},
         {UINT32_C(0x6D116D41), UINT32_C(0xCE8D7A0B), UINT32_C(0xEE2706C8),
          UINT32_C(0xAF660436), UINT32_C(0xF81D6398), UINT32_C(0xFFAD6FE9),
          UINT32_C(0x14BA128A), UINT32_C(0x4FE5EC54)}},
        {{UINT32_C(0xBD4B886C), UINT32_C(0x7D5E8299), UINT32_C(0xDB0DB148),
          UINT32_C(0x5403A46E), UINT32_C(0x76A808D7), UINT32_C(0x32F49FC0),
          UINT32_C(0xD3B9A641), UINT32_C(0x6D483FD7)},
         {UINT32_C(0x3952C70F), UINT32_C(0x731DF122), UINT32_C(0xCB5E6081),
          UINT32_C(0xB5CABAC1), UINT32_C(0x7AFA8F59), UINT32_C(0x12FA297D),
          UINT32_C(0x6AC91952), UINT32_C(0x3272360A)}},
    }};

/*-
 * Q := 2P, both projective, Q and P same pointers OK
 * Autogenerated: op3/dbl_proj.op3
 * https://eprint.iacr.org/2015/1060 Alg 6
 * ASSERT: a = -3
 */
static void point_double(pt_prj_t *Q, const pt_prj_t *P) {
    /* temporary variables */
    fe_t t0, t1, t2, t3, t4;
    /* constants */
    const limb_t *b = const_b;
    /* set pointers for legacy curve arith */
    const limb_t *X = P->X;
    const limb_t *Y = P->Y;
    const limb_t *Z = P->Z;
    limb_t *X3 = Q->X;
    limb_t *Y3 = Q->Y;
    limb_t *Z3 = Q->Z;

    /* the curve arith formula */
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_square(t0, X);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_square(t1, Y);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_square(t2, Z);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t3, X, Y);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t3, t3, t3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t4, Y, Z);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(Z3, X, Z);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(Z3, Z3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(Y3, b, t2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(Y3, Y3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(X3, Y3, Y3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(Y3, X3, Y3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(X3, t1, Y3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(Y3, t1, Y3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(Y3, X3, Y3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(X3, X3, t3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t3, t2, t2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t2, t2, t3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(Z3, b, Z3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(Z3, Z3, t2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(Z3, Z3, t0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t3, Z3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(Z3, Z3, t3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t3, t0, t0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t0, t3, t0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(t0, t0, t2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t0, t0, Z3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(Y3, Y3, t0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t0, t4, t4);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(Z3, t0, Z3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(X3, X3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(Z3, t0, t1);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(Z3, Z3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(Z3, Z3, Z3);
}

/*-
 * R := Q + P where R and Q are projective, P affine.
 * R and Q same pointers OK
 * R and P same pointers not OK
 * Autogenerated: op3/add_mixed.op3
 * https://eprint.iacr.org/2015/1060 Alg 5
 * ASSERT: a = -3
 */
static void point_add_mixed(pt_prj_t *R, const pt_prj_t *Q, const pt_aff_t *P) {
    /* temporary variables */
    fe_t t0, t1, t2, t3, t4;
    /* constants */
    const limb_t *b = const_b;
    /* set pointers for legacy curve arith */
    const limb_t *X1 = Q->X;
    const limb_t *Y1 = Q->Y;
    const limb_t *Z1 = Q->Z;
    const limb_t *X2 = P->X;
    const limb_t *Y2 = P->Y;
    fe_t X3;
    fe_t Y3;
    fe_t Z3;
    limb_t nz;

    /* check P for affine inf */
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_nonzero(&nz, P->Y);

    /* the curve arith formula */
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t0, X1, X2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t1, Y1, Y2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t3, X2, Y2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t4, X1, Y1);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t3, t3, t4);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t4, t0, t1);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(t3, t3, t4);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t4, Y2, Z1);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t4, t4, Y1);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(Y3, X2, Z1);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(Y3, Y3, X1);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(Z3, b, Z1);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(X3, Y3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(Z3, X3, X3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(X3, X3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(Z3, t1, X3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(X3, t1, X3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(Y3, b, Y3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t1, Z1, Z1);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t2, t1, Z1);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(Y3, Y3, t2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(Y3, Y3, t0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t1, Y3, Y3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(Y3, t1, Y3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t1, t0, t0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t0, t1, t0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(t0, t0, t2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t1, t4, Y3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t2, t0, Y3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(Y3, X3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(Y3, Y3, t2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(X3, t3, X3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(X3, X3, t1);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(Z3, t4, Z3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t1, t3, t0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(Z3, Z3, t1);

    /* if P is inf, throw all that away and take Q */
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_selectznz(R->X, nz, Q->X, X3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_selectznz(R->Y, nz, Q->Y, Y3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_selectznz(R->Z, nz, Q->Z, Z3);
}

/*-
 * R := Q + P all projective.
 * R and Q same pointers OK
 * R and P same pointers not OK
 * Autogenerated: op3/add_proj.op3
 * https://eprint.iacr.org/2015/1060 Alg 4
 * ASSERT: a = -3
 */
static void point_add_proj(pt_prj_t *R, const pt_prj_t *Q, const pt_prj_t *P) {
    /* temporary variables */
    fe_t t0, t1, t2, t3, t4, t5;
    /* constants */
    const limb_t *b = const_b;
    /* set pointers for legacy curve arith */
    const limb_t *X1 = Q->X;
    const limb_t *Y1 = Q->Y;
    const limb_t *Z1 = Q->Z;
    const limb_t *X2 = P->X;
    const limb_t *Y2 = P->Y;
    const limb_t *Z2 = P->Z;
    limb_t *X3 = R->X;
    limb_t *Y3 = R->Y;
    limb_t *Z3 = R->Z;

    /* the curve arith formula */
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t0, X1, X2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t1, Y1, Y2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t2, Z1, Z2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t3, X1, Y1);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t4, X2, Y2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t3, t3, t4);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t4, t0, t1);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(t3, t3, t4);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t4, Y1, Z1);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t5, Y2, Z2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t4, t4, t5);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t5, t1, t2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(t4, t4, t5);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(X3, X1, Z1);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(Y3, X2, Z2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(X3, X3, Y3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(Y3, t0, t2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(Y3, X3, Y3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(Z3, b, t2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(X3, Y3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(Z3, X3, X3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(X3, X3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(Z3, t1, X3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(X3, t1, X3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(Y3, b, Y3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t1, t2, t2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t2, t1, t2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(Y3, Y3, t2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(Y3, Y3, t0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t1, Y3, Y3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(Y3, t1, Y3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t1, t0, t0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(t0, t1, t0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(t0, t0, t2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t1, t4, Y3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t2, t0, Y3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(Y3, X3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(Y3, Y3, t2);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(X3, t3, X3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_sub(X3, X3, t1);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(Z3, t4, Z3);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(t1, t3, t0);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_add(Z3, Z3, t1);
}

/* constants */
#define RADIX 5
#define DRADIX (1 << RADIX)
#define DRADIX_WNAF ((DRADIX) << 1)

/*-
 * precomp for wnaf scalar multiplication:
 * precomp[0] = 1P
 * precomp[1] = 3P
 * precomp[2] = 5P
 * precomp[3] = 7P
 * precomp[4] = 9P
 * ...
 */
static void precomp_wnaf(pt_prj_t precomp[DRADIX / 2], const pt_aff_t *P) {
    int i;

    fe_copy(precomp[0].X, P->X);
    fe_copy(precomp[0].Y, P->Y);
    fe_copy(precomp[0].Z, const_one);
    point_double(&precomp[DRADIX / 2 - 1], &precomp[0]);

    for (i = 1; i < DRADIX / 2; i++)
        point_add_proj(&precomp[i], &precomp[DRADIX / 2 - 1], &precomp[i - 1]);
}

/* fetch a scalar bit */
static int scalar_get_bit(const unsigned char in[32], int idx) {
    int widx, rshift;

    widx = idx >> 3;
    rshift = idx & 0x7;

    if (idx < 0 || widx >= 32) return 0;

    return (in[widx] >> rshift) & 0x1;
}

/*-
 * Compute "regular" wnaf representation of a scalar.
 * See "Exponent Recoding and Regular Exponentiation Algorithms",
 * Tunstall et al., AfricaCrypt 2009, Alg 6.
 * It forces an odd scalar and outputs digits in
 * {\pm 1, \pm 3, \pm 5, \pm 7, \pm 9, ...}
 * i.e. signed odd digits with _no zeroes_ -- that makes it "regular".
 */
static void scalar_rwnaf(int8_t out[52], const unsigned char in[32]) {
    int i;
    int8_t window, d;

    window = (in[0] & (DRADIX_WNAF - 1)) | 1;
    for (i = 0; i < 51; i++) {
        d = (window & (DRADIX_WNAF - 1)) - DRADIX;
        out[i] = d;
        window = (window - d) >> RADIX;
        window += scalar_get_bit(in, (i + 1) * RADIX + 1) << 1;
        window += scalar_get_bit(in, (i + 1) * RADIX + 2) << 2;
        window += scalar_get_bit(in, (i + 1) * RADIX + 3) << 3;
        window += scalar_get_bit(in, (i + 1) * RADIX + 4) << 4;
        window += scalar_get_bit(in, (i + 1) * RADIX + 5) << 5;
    }
    out[i] = window;
}

/*-
 * Compute "textbook" wnaf representation of a scalar.
 * NB: not constant time
 */
static void scalar_wnaf(int8_t out[257], const unsigned char in[32]) {
    int i;
    int8_t window, d;

    window = in[0] & (DRADIX_WNAF - 1);
    for (i = 0; i < 257; i++) {
        d = 0;
        if ((window & 1) && ((d = window & (DRADIX_WNAF - 1)) & DRADIX))
            d -= DRADIX_WNAF;
        out[i] = d;
        window = (window - d) >> 1;
        window += scalar_get_bit(in, i + 1 + RADIX) << RADIX;
    }
}

/*-
 * Simultaneous scalar multiplication: interleaved "textbook" wnaf.
 * NB: not constant time
 */
static void var_smul_wnaf_two(pt_aff_t *out, const unsigned char a[32],
                              const unsigned char b[32], const pt_aff_t *P) {
    int i, d, is_neg, is_inf = 1, flipped = 0;
    int8_t anaf[257] = {0};
    int8_t bnaf[257] = {0};
    pt_prj_t Q = {0};
    pt_prj_t precomp[DRADIX / 2];

    precomp_wnaf(precomp, P);
    scalar_wnaf(anaf, a);
    scalar_wnaf(bnaf, b);

    for (i = 256; i >= 0; i--) {
        if (!is_inf) point_double(&Q, &Q);
        if ((d = bnaf[i])) {
            if ((is_neg = d < 0) != flipped) {
                fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_opp(Q.Y, Q.Y);
                flipped ^= 1;
            }
            d = (is_neg) ? (-d - 1) >> 1 : (d - 1) >> 1;
            if (is_inf) {
                /* initialize accumulator */
                fe_copy(Q.X, &precomp[d].X);
                fe_copy(Q.Y, &precomp[d].Y);
                fe_copy(Q.Z, &precomp[d].Z);
                is_inf = 0;
            } else
                point_add_proj(&Q, &Q, &precomp[d]);
        }
        if ((d = anaf[i])) {
            if ((is_neg = d < 0) != flipped) {
                fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_opp(Q.Y, Q.Y);
                flipped ^= 1;
            }
            d = (is_neg) ? (-d - 1) >> 1 : (d - 1) >> 1;
            if (is_inf) {
                /* initialize accumulator */
                fe_copy(Q.X, &lut_cmb[0][d].X);
                fe_copy(Q.Y, &lut_cmb[0][d].Y);
                fe_copy(Q.Z, const_one);
                is_inf = 0;
            } else
                point_add_mixed(&Q, &Q, &lut_cmb[0][d]);
        }
    }

    if (is_inf) {
        /* initialize accumulator to inf: all-zero scalars */
        fe_set_zero(Q.X);
        fe_copy(Q.Y, const_one);
        fe_set_zero(Q.Z);
    }

    if (flipped) {
        /* correct sign */
        fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_opp(Q.Y, Q.Y);
    }

    /* convert to affine -- NB depends on coordinate system */
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_inv(Q.Z, Q.Z);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(out->X, Q.X, Q.Z);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(out->Y, Q.Y, Q.Z);
}

/*-
 * Variable point scalar multiplication with "regular" wnaf.
 */
static void var_smul_rwnaf(pt_aff_t *out, const unsigned char scalar[32],
                           const pt_aff_t *P) {
    int i, j, d, diff, is_neg;
    int8_t rnaf[52] = {0};
    pt_prj_t Q = {0}, lut = {0};
    pt_prj_t precomp[DRADIX / 2];

    precomp_wnaf(precomp, P);
    scalar_rwnaf(rnaf, scalar);

#if defined(_MSC_VER)
    /* result still unsigned: yes we know */
#pragma warning(push)
#pragma warning(disable : 4146)
#endif

    /* initialize accumulator to high digit */
    d = (rnaf[51] - 1) >> 1;
    for (j = 0; j < DRADIX / 2; j++) {
        diff = (1 - (-(d ^ j) >> (8 * sizeof(int) - 1))) & 1;
        fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_selectznz(Q.X, diff, Q.X,
                                                              precomp[j].X);
        fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_selectznz(Q.Y, diff, Q.Y,
                                                              precomp[j].Y);
        fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_selectznz(Q.Z, diff, Q.Z,
                                                              precomp[j].Z);
    }

    for (i = 50; i >= 0; i--) {
        for (j = 0; j < RADIX; j++) point_double(&Q, &Q);
        d = rnaf[i];
        /* is_neg = (d < 0) ? 1 : 0 */
        is_neg = (d >> (8 * sizeof(int) - 1)) & 1;
        /* d = abs(d) */
        d = (d ^ -is_neg) + is_neg;
        d = (d - 1) >> 1;
        for (j = 0; j < DRADIX / 2; j++) {
            diff = (1 - (-(d ^ j) >> (8 * sizeof(int) - 1))) & 1;
            fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_selectznz(
                lut.X, diff, lut.X, precomp[j].X);
            fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_selectznz(
                lut.Y, diff, lut.Y, precomp[j].Y);
            fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_selectznz(
                lut.Z, diff, lut.Z, precomp[j].Z);
        }
        /* negate lut point if digit is negative */
        fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_opp(out->Y, lut.Y);
        fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_selectznz(lut.Y, is_neg,
                                                              lut.Y, out->Y);
        point_add_proj(&Q, &Q, &lut);
    }

#if defined(_MSC_VER)
#pragma warning(pop)
#endif

    /* conditionally subtract P if the scalar was even */
    fe_copy(lut.X, precomp[0].X);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_opp(lut.Y, precomp[0].Y);
    fe_copy(lut.Z, precomp[0].Z);
    point_add_proj(&lut, &lut, &Q);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_selectznz(Q.X, scalar[0] & 1,
                                                          lut.X, Q.X);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_selectznz(Q.Y, scalar[0] & 1,
                                                          lut.Y, Q.Y);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_selectznz(Q.Z, scalar[0] & 1,
                                                          lut.Z, Q.Z);

    /* convert to affine -- NB depends on coordinate system */
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_inv(Q.Z, Q.Z);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(out->X, Q.X, Q.Z);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(out->Y, Q.Y, Q.Z);
}

/*-
 * Fixed scalar multiplication: comb with interleaving.
 */
static void fixed_smul_cmb(pt_aff_t *out, const unsigned char scalar[32]) {
    int i, j, k, d, diff, is_neg = 0;
    int8_t rnaf[52] = {0};
    pt_prj_t Q = {0}, R = {0};
    pt_aff_t lut = {0};

    scalar_rwnaf(rnaf, scalar);

    /* initalize accumulator to inf */
    fe_set_zero(Q.X);
    fe_copy(Q.Y, const_one);
    fe_set_zero(Q.Z);

#if defined(_MSC_VER)
    /* result still unsigned: yes we know */
#pragma warning(push)
#pragma warning(disable : 4146)
#endif

    for (i = 1; i >= 0; i--) {
        for (j = 0; i != 1 && j < RADIX; j++) point_double(&Q, &Q);
        for (j = 0; j < 27; j++) {
            if (j * 2 + i > 51) continue;
            d = rnaf[j * 2 + i];
            /* is_neg = (d < 0) ? 1 : 0 */
            is_neg = (d >> (8 * sizeof(int) - 1)) & 1;
            /* d = abs(d) */
            d = (d ^ -is_neg) + is_neg;
            d = (d - 1) >> 1;
            for (k = 0; k < DRADIX / 2; k++) {
                diff = (1 - (-(d ^ k) >> (8 * sizeof(int) - 1))) & 1;
                fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_selectznz(
                    lut.X, diff, lut.X, lut_cmb[j][k].X);
                fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_selectznz(
                    lut.Y, diff, lut.Y, lut_cmb[j][k].Y);
            }
            /* negate lut point if digit is negative */
            fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_opp(out->Y, lut.Y);
            fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_selectznz(
                lut.Y, is_neg, lut.Y, out->Y);
            point_add_mixed(&Q, &Q, &lut);
        }
    }

#if defined(_MSC_VER)
#pragma warning(pop)
#endif

    /* conditionally subtract P if the scalar was even */
    fe_copy(lut.X, lut_cmb[0][0].X);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_opp(lut.Y, lut_cmb[0][0].Y);
    point_add_mixed(&R, &Q, &lut);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_selectznz(Q.X, scalar[0] & 1,
                                                          R.X, Q.X);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_selectznz(Q.Y, scalar[0] & 1,
                                                          R.Y, Q.Y);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_selectznz(Q.Z, scalar[0] & 1,
                                                          R.Z, Q.Z);

    /* convert to affine -- NB depends on coordinate system */
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_inv(Q.Z, Q.Z);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(out->X, Q.X, Q.Z);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_mul(out->Y, Q.Y, Q.Z);
}

/*-
 * Wrapper: simultaneous scalar mutiplication.
 * outx, outy := a * G + b * P
 * where P = (inx, iny).
 * Everything is LE byte ordering.
 */
static void point_mul_two(unsigned char outx[32], unsigned char outy[32],
                          const unsigned char a[32], const unsigned char b[32],
                          const unsigned char inx[32],
                          const unsigned char iny[32]) {
    pt_aff_t P;

    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_from_bytes(P.X, inx);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_from_bytes(P.Y, iny);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_to_montgomery(P.X, P.X);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_to_montgomery(P.Y, P.Y);
    /* simultaneous scalar multiplication */
    var_smul_wnaf_two(&P, a, b, &P);

    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_from_montgomery(P.X, P.X);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_from_montgomery(P.Y, P.Y);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_to_bytes(outx, P.X);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_to_bytes(outy, P.Y);
}

/*-
 * Wrapper: fixed scalar mutiplication.
 * outx, outy := scalar * G
 * Everything is LE byte ordering.
 */
static void point_mul_g(unsigned char outx[32], unsigned char outy[32],
                        const unsigned char scalar[32]) {
    pt_aff_t P;

    /* fixed scmul function */
    fixed_smul_cmb(&P, scalar);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_from_montgomery(P.X, P.X);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_from_montgomery(P.Y, P.Y);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_to_bytes(outx, P.X);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_to_bytes(outy, P.Y);
}

/*-
 * Wrapper: variable point scalar mutiplication.
 * outx, outy := scalar * P
 * where P = (inx, iny).
 * Everything is LE byte ordering.
 */
static void point_mul(unsigned char outx[32], unsigned char outy[32],
                      const unsigned char scalar[32],
                      const unsigned char inx[32],
                      const unsigned char iny[32]) {
    pt_aff_t P;

    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_from_bytes(P.X, inx);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_from_bytes(P.Y, iny);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_to_montgomery(P.X, P.X);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_to_montgomery(P.Y, P.Y);
    /* var scmul function */
    var_smul_rwnaf(&P, scalar, &P);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_from_montgomery(P.X, P.X);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_from_montgomery(P.Y, P.Y);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_to_bytes(outx, P.X);
    fiat_id_GostR3410_2001_CryptoPro_B_ParamSet_to_bytes(outy, P.Y);
}


#include <openssl/ec.h>

/* the zero field element */
static const unsigned char const_zb[32] = {0};

/*-
 * An OpenSSL wrapper for simultaneous scalar multiplication.
 * r := n * G + m * q
 */
    int
    point_mul_two_id_GostR3410_2001_CryptoPro_B_ParamSet(
        const EC_GROUP *group, EC_POINT *r, const BIGNUM *n, const EC_POINT *q,
        const BIGNUM *m, BN_CTX *ctx) {
    int ret = 0;
    unsigned char b_x[32];
    unsigned char b_y[32];
    unsigned char b_n[32];
    unsigned char b_m[32];
    BIGNUM *x = NULL, *y = NULL;

    BN_CTX_start(ctx);
    x = BN_CTX_get(ctx);
    if ((y = BN_CTX_get(ctx)) == NULL
        /* pull out coords as bytes */
        || !EC_POINT_get_affine_coordinates(group, q, x, y, ctx) ||
        BN_bn2lebinpad(x, b_x, 32) != 32 || BN_bn2lebinpad(y, b_y, 32) != 32 ||
        BN_bn2lebinpad(n, b_n, 32) != 32 || BN_bn2lebinpad(m, b_m, 32) != 32)
        goto err;
    /* do the simultaneous scalar multiplication */
    point_mul_two(b_x, b_y, b_n, b_m, b_x, b_y);
    /* check for infinity */
    if (CRYPTO_memcmp(const_zb, b_x, 32) == 0 &&
        CRYPTO_memcmp(const_zb, b_y, 32) == 0) {
        if (!EC_POINT_set_to_infinity(group, r)) goto err;
    } else {
        /* otherwise, pack the bytes into the result */
        if (BN_lebin2bn(b_x, 32, x) == NULL ||
            BN_lebin2bn(b_y, 32, y) == NULL ||
            !EC_POINT_set_affine_coordinates(group, r, x, y, ctx))
            goto err;
    }
    ret = 1;
err:
    BN_CTX_end(ctx);
    return ret;
}

/*-
 * An OpenSSL wrapper for variable point scalar multiplication.
 * r := m * q
 */
    int
    point_mul_id_GostR3410_2001_CryptoPro_B_ParamSet(const EC_GROUP *group,
                                                     EC_POINT *r,
                                                     const EC_POINT *q,
                                                     const BIGNUM *m,
                                                     BN_CTX *ctx) {
    int ret = 0;
    unsigned char b_x[32];
    unsigned char b_y[32];
    unsigned char b_m[32];
    BIGNUM *x = NULL, *y = NULL;

    BN_CTX_start(ctx);
    x = BN_CTX_get(ctx);
    if ((y = BN_CTX_get(ctx)) == NULL
        /* pull out coords as bytes */
        || !EC_POINT_get_affine_coordinates(group, q, x, y, ctx) ||
        BN_bn2lebinpad(x, b_x, 32) != 32 || BN_bn2lebinpad(y, b_y, 32) != 32 ||
        BN_bn2lebinpad(m, b_m, 32) != 32)
        goto err;
    /* do the variable scalar multiplication */
    point_mul(b_x, b_y, b_m, b_x, b_y);
    /* check for infinity */
    if (CRYPTO_memcmp(const_zb, b_x, 32) == 0 &&
        CRYPTO_memcmp(const_zb, b_y, 32) == 0) {
        if (!EC_POINT_set_to_infinity(group, r)) goto err;
    } else {
        /* otherwise, pack the bytes into the result */
        if (BN_lebin2bn(b_x, 32, x) == NULL ||
            BN_lebin2bn(b_y, 32, y) == NULL ||
            !EC_POINT_set_affine_coordinates(group, r, x, y, ctx))
            goto err;
    }
    ret = 1;
err:
    BN_CTX_end(ctx);
    return ret;
}

/*-
 * An OpenSSL wrapper for fixed scalar multiplication.
 * r := n * G
 */
    int
    point_mul_g_id_GostR3410_2001_CryptoPro_B_ParamSet(const EC_GROUP *group,
                                                       EC_POINT *r,
                                                       const BIGNUM *n,
                                                       BN_CTX *ctx) {
    int ret = 0;
    unsigned char b_x[32];
    unsigned char b_y[32];
    unsigned char b_n[32];
    BIGNUM *x = NULL, *y = NULL;

    BN_CTX_start(ctx);
    x = BN_CTX_get(ctx);
    if ((y = BN_CTX_get(ctx)) == NULL || BN_bn2lebinpad(n, b_n, 32) != 32)
        goto err;
    /* do the fixed scalar multiplication */
    point_mul_g(b_x, b_y, b_n);
    /* check for infinity */
    if (CRYPTO_memcmp(const_zb, b_x, 32) == 0 &&
        CRYPTO_memcmp(const_zb, b_y, 32) == 0) {
        if (!EC_POINT_set_to_infinity(group, r)) goto err;
    } else {
        /* otherwise, pack the bytes into the result */
        if (BN_lebin2bn(b_x, 32, x) == NULL ||
            BN_lebin2bn(b_y, 32, y) == NULL ||
            !EC_POINT_set_affine_coordinates(group, r, x, y, ctx))
            goto err;
    }
    ret = 1;
err:
    BN_CTX_end(ctx);
    return ret;
}



#endif /* __SIZEOF_INT128__ */
