# vali

A [Varlink] C implementation and code generator.

## Building

vali depends on [json-c] and [aml].

To compile vali, run these commands:

    meson setup build/
    ninja -C build/

## Library API

The library API is documented in the [header] and can be browsed on the [website].

### Client

To open a connection:

```c
struct vali_client *client = vali_client_connect_unix("/run/org.example.ftl");
```

### Service

To listen on a Unix socket:

```c
struct vali_service *service = vali_service_create();
vali_service_set_call_handler(service, handler);
vali_service_listen_unix(service, "/run/org.example.ftl");
```

Read below for information about creating a handler.

## Code generation

Given a Varlink definition file:

```varlink
interface org.example.ftl

method Jump(latitude: float, longitude: float) -> ()
```

A header and a source file can be generated:

```shell
vali generate --prefix=ftl org.example.ftl.varlink org.example.ftl.h org.example.ftl.c
```

The generated code exposes client methods:

```c
const struct ftl_Jump_in in = {
	.latitude = 37.56,
	.longitude = 126.99,
};
ftl_Jump(client, &in, NULL, NULL);
```

It also contains a call handler implementing the Varlink service:

```c
static void handle_jump(struct ftl_Jump_service_call call, const struct ftl_Jump_in *in) {
	printf("Jump: latitude=%f longitude=%f\n", in->latitude, in->longitude);
	ftl_Jump_close_with_reply(call, NULL);
}

static const struct ftl_handler ftl_handler = {
	.Jump = handle_jump,
};

int main(int argc, char *argv[]) {
	struct vali_service *service = vali_service_create();
	vali_service_set_call_handler(service, ftl_get_call_handler(&ftl_handler));

	return 0;
}
```

See [`example/`] for a more complete example.

## License

MIT

[Varlink]: https://varlink.org/
[json-c]: https://github.com/json-c/json-c
[aml]: https://github.com/any1/aml
[header]: ./include/vali.h
[website]: https://emersion.pages.freedesktop.org/vali
[`example/`]: ./example/
