//
// Copyright 2025 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#ifndef PXR_USD_IMAGING_USD_SKEL_IMAGING_ANIMATION_SCHEMA_H
#define PXR_USD_IMAGING_USD_SKEL_IMAGING_ANIMATION_SCHEMA_H

/// \file

#include "pxr/usdImaging/usdSkelImaging/api.h"

#include "pxr/imaging/hd/schema.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

// --(BEGIN CUSTOM CODE: Declares)--
// --(END CUSTOM CODE: Declares)--

#define USD_SKEL_IMAGING_ANIMATION_SCHEMA_TOKENS \
    (skelAnimation) \
    (joints) \
    (translations) \
    (rotations) \
    (scales) \
    (blendShapes) \
    (blendShapeWeights) \

TF_DECLARE_PUBLIC_TOKENS(UsdSkelImagingAnimationSchemaTokens, USDSKELIMAGING_API,
    USD_SKEL_IMAGING_ANIMATION_SCHEMA_TOKENS);

//-----------------------------------------------------------------------------

// Corresponds to UsdSkelAnimation.
//

class UsdSkelImagingAnimationSchema : public HdSchema
{
public:
    /// \name Schema retrieval
    /// @{

    UsdSkelImagingAnimationSchema(HdContainerDataSourceHandle container)
      : HdSchema(container) {}

    /// Retrieves a container data source with the schema's default name token
    /// "skelAnimation" from the parent container and constructs a
    /// UsdSkelImagingAnimationSchema instance.
    /// Because the requested container data source may not exist, the result
    /// should be checked with IsDefined() or a bool comparison before use.
    USDSKELIMAGING_API
    static UsdSkelImagingAnimationSchema GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer);

    /// @}

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

    /// \name Member accessor
    /// @{

    USDSKELIMAGING_API
    HdTokenArrayDataSourceHandle GetJoints() const;

    USDSKELIMAGING_API
    HdVec3fArrayDataSourceHandle GetTranslations() const;

    USDSKELIMAGING_API
    HdQuatfArrayDataSourceHandle GetRotations() const;

    USDSKELIMAGING_API
    HdVec3hArrayDataSourceHandle GetScales() const;

    USDSKELIMAGING_API
    HdTokenArrayDataSourceHandle GetBlendShapes() const;

    USDSKELIMAGING_API
    HdFloatArrayDataSourceHandle GetBlendShapeWeights() const; 

    /// @}

    /// \name Schema location
    /// @{

    /// Returns a token where the container representing this schema is found in
    /// a container by default.
    USDSKELIMAGING_API
    static const TfToken &GetSchemaToken();

    /// Returns an HdDataSourceLocator (relative to the prim-level data source)
    /// where the container representing this schema is found by default.
    USDSKELIMAGING_API
    static const HdDataSourceLocator &GetDefaultLocator();

    /// @}

    /// \name Data source locators for members
    ///
    /// The following methods return an HdDataSourceLocator (relative to the
    /// prim-level data source) where the data source for a member can be found.
    ///
    /// This is often useful for checking intersection against the
    /// HdDataSourceLocatorSet sent with HdDataSourceObserver::PrimsDirtied.
    /// @{

    /// Prim-level relative data source locator to locate joints.
    USDSKELIMAGING_API
    static const HdDataSourceLocator &GetJointsLocator();

    /// Prim-level relative data source locator to locate translations.
    USDSKELIMAGING_API
    static const HdDataSourceLocator &GetTranslationsLocator();

    /// Prim-level relative data source locator to locate rotations.
    USDSKELIMAGING_API
    static const HdDataSourceLocator &GetRotationsLocator();

    /// Prim-level relative data source locator to locate scales.
    USDSKELIMAGING_API
    static const HdDataSourceLocator &GetScalesLocator();

    /// Prim-level relative data source locator to locate blendShapes.
    USDSKELIMAGING_API
    static const HdDataSourceLocator &GetBlendShapesLocator();

    /// Prim-level relative data source locator to locate blendShapeWeights.
    USDSKELIMAGING_API
    static const HdDataSourceLocator &GetBlendShapeWeightsLocator();
    /// @} 

    /// \name Schema construction
    /// @{

    /// \deprecated Use Builder instead.
    ///
    /// Builds a container data source which includes the provided child data
    /// sources. Parameters with nullptr values are excluded. This is a
    /// low-level interface. For cases in which it's desired to define
    /// the container with a sparse set of child fields, the Builder class
    /// is often more convenient and readable.
    USDSKELIMAGING_API
    static HdContainerDataSourceHandle
    BuildRetained(
        const HdTokenArrayDataSourceHandle &joints,
        const HdVec3fArrayDataSourceHandle &translations,
        const HdQuatfArrayDataSourceHandle &rotations,
        const HdVec3hArrayDataSourceHandle &scales,
        const HdTokenArrayDataSourceHandle &blendShapes,
        const HdFloatArrayDataSourceHandle &blendShapeWeights
    );

    /// \class UsdSkelImagingAnimationSchema::Builder
    /// 
    /// Utility class for setting sparse sets of child data source fields to be
    /// filled as arguments into BuildRetained. Because all setter methods
    /// return a reference to the instance, this can be used in the "builder
    /// pattern" form.
    class Builder
    {
    public:
        USDSKELIMAGING_API
        Builder &SetJoints(
            const HdTokenArrayDataSourceHandle &joints);
        USDSKELIMAGING_API
        Builder &SetTranslations(
            const HdVec3fArrayDataSourceHandle &translations);
        USDSKELIMAGING_API
        Builder &SetRotations(
            const HdQuatfArrayDataSourceHandle &rotations);
        USDSKELIMAGING_API
        Builder &SetScales(
            const HdVec3hArrayDataSourceHandle &scales);
        USDSKELIMAGING_API
        Builder &SetBlendShapes(
            const HdTokenArrayDataSourceHandle &blendShapes);
        USDSKELIMAGING_API
        Builder &SetBlendShapeWeights(
            const HdFloatArrayDataSourceHandle &blendShapeWeights);

        /// Returns a container data source containing the members set thus far.
        USDSKELIMAGING_API
        HdContainerDataSourceHandle Build();

    private:
        HdTokenArrayDataSourceHandle _joints;
        HdVec3fArrayDataSourceHandle _translations;
        HdQuatfArrayDataSourceHandle _rotations;
        HdVec3hArrayDataSourceHandle _scales;
        HdTokenArrayDataSourceHandle _blendShapes;
        HdFloatArrayDataSourceHandle _blendShapeWeights;

    };

    /// @}
};

PXR_NAMESPACE_CLOSE_SCOPE

#endif
