// Do not edit this file! Generated by Ragel 6.10.
// Ragel.exe -J -o ../../../../../src/com/badlogic/gdx/utils/JsonSkimmer.java JsonSkimmer.rl
/*******************************************************************************
 * Copyright 2024 See AUTHORS file.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/

package com.badlogic.gdx.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.JsonSkimmer.JsonToken.TokenType;
import com.badlogic.gdx.utils.JsonValue.ValueType;

/** Lightweight event-based JSON parser. All values are provided as strings to reduce work when many values are ignored.
 * @author Nathan Sweet */
public class JsonSkimmer {
	final JsonToken nameString, value;
	int[] stack = new int[8];
	protected final CharArray buffer = new CharArray();

	public JsonSkimmer () {
		nameString = new JsonToken(buffer);
		value = new JsonToken(buffer);
	}

	public void parse (String json) {
		char[] data = json.toCharArray();
		parse(data, 0, data.length);
	}

	public void parse (Reader reader) {
		char[] data = new char[1024];
		int offset = 0;
		try {
			while (true) {
				int length = reader.read(data, offset, data.length - offset);
				if (length == -1) break;
				if (length == 0) {
					char[] newData = new char[data.length * 2];
					System.arraycopy(data, 0, newData, 0, data.length);
					data = newData;
				} else
					offset += length;
			}
		} catch (IOException ex) {
			throw new SerializationException("Error reading input.", ex);
		} finally {
			StreamUtils.closeQuietly(reader);
		}
		parse(data, 0, offset);
	}

	public void parse (InputStream input) {
		Reader reader;
		try {
			reader = new InputStreamReader(input, "UTF-8");
		} catch (Exception ex) {
			throw new SerializationException("Error reading stream.", ex);
		}
		parse(reader);
	}

	public void parse (FileHandle file) {
		Reader reader;
		try {
			reader = file.reader("UTF-8");
		} catch (Exception ex) {
			throw new SerializationException("Error reading file: " + file, ex);
		}
		try {
			parse(reader);
		} catch (Exception ex) {
			throw new SerializationException("Error parsing file: " + file, ex);
		}
	}

	public void parse (char[] data, int offset, int length) {
		stop = false;
		int cs, p = offset, pe = length, eof = pe, top = 0;
		int[] stack = this.stack;

		JsonToken nameString = this.nameString, value = this.value, string = value, name = null;
		nameString.chars = data;
		value.chars = data;
		RuntimeException parseRuntimeEx = null;

		boolean debug = false;
		if (debug) System.out.println();

		try {
		%%{
			machine json;

			prepush {
				if (top == stack.length) stack = this.stack = Arrays.copyOf(stack, stack.length << 1);
			}

			action startObject {
				if (debug) System.out.println("startObject: " + name);
				push(name, true);
				if (stop) return;
				name = null;
				fcall object;
			}
			action endObject {
				if (debug) System.out.println("endObject");
				pop();
				if (stop) return;
				fret;
			}
			action startArray {
				if (debug) System.out.println("startArray: " + name);
				push(name, false);
				if (stop) return;
				name = null;
				fcall array;
			}
			action endArray {
				if (debug) System.out.println("endArray");
				pop();
				if (stop) return;
				fret;
			}
			action comment {
				int start = p;
				if (data[p++] == '/') {
					while (p != eof && data[p] != '\n')
						p++;
					p--;
				} else {
					while (p + 1 < eof && (data[p] != '*' || data[p + 1] != '/'))
						p++;
					p++;
				}
				if (debug) System.out.println("comment " + new String(data, start - 1, p - start + 2));
			}
			action unquotedName {
				if (debug) System.out.println("unquotedName");
				int start = p;
				string.start = start;
				boolean ws = false;
				outer:
				while (true) {
					switch (data[p]) {
					case '\\':
						string.unescape = true;
						break;
					case '/':
						if (p + 1 == eof) break;
						char c = data[p + 1];
						if (c == '/' || c == '*') break outer;
						break;
					case ' ':
					case '\t':
						ws = true;
						break;
					case ':':
					case '\r':
					case '\n':
						break outer;
					}
					if (debug) System.out.println("name char: '" + data[p] + "'");
					p++;
					if (p == eof) break;
				}
				p--;
				if (ws) {
					while (true) {
						switch (data[p]) {
						case ' ':
						case '\t':
							p--;
							continue;
						}
						break;
					}
				}
				string.length = p - start + 1;
			}
			action unquotedValue {
				if (debug) System.out.println("unquotedValue");
				int start = p;
				string.start = start;
				boolean ws = false;
				outer:
				while (true) {
					switch (data[p]) {
					case '\\':
						string.unescape = true;
						break;
					case '/':
						if (p + 1 == eof) break;
						char c = data[p + 1];
						if (c == '/' || c == '*') break outer;
						break;
					case ' ':
					case '\t':
						ws = true;
						break;
					case '\r':
					case '\n':
					case '}':
					case ']':
					case ',':
						break outer;
					}
					if (debug) System.out.println("value char: '" + data[p] + "'");
					p++;
					if (p == eof) break;
				}
				p--;
				if (ws) {
					while (true) {
						switch (data[p]) {
						case ' ':
						case '\t':
							p--;
							continue;
						}
						break;
					}
				}
				string.length = p - start + 1;
				string.type = TokenType.other;
				if (string.length == 4) {
					if (data[start] == 't' && data[start + 1] == 'r' && data[start + 2] == 'u' && data[start + 3] == 'e')
						string.type = TokenType.trueValue;
					else if (data[start] == 'n' && data[start + 1] == 'u' && data[start + 2] == 'l' && data[start + 3] == 'l')
						string.type = TokenType.nullValue;
				} else if (string.length == 5) {
					if (data[start] == 'f' && data[start + 1] == 'a' && data[start + 2] == 'l' && data[start + 3] == 's'
						&& data[start + 4] == 'e') string.type = TokenType.falseValue;
				}
			}
			action quotedString {
				if (debug) System.out.println("quotedString");
				string.start = ++p;
				outer:
				while (true) {
					switch (data[p]) {
					case '\\':
						string.unescape = true;
						p++;
						break;
					case '"':
						break outer;
					}
					if (debug) System.out.println("quoted char: '" + data[p] + "'");
					p++;
					if (p == eof) break;
				}
				string.length = p - string.start;
			}
			action startName {
				name = nameString; // Next element has a name.
				string = nameString; // Parse next string to nameString.
				if (debug) System.out.println("name start " + p);
			}
			action endName {
				if (debug) System.out.println("name: " + p + ", " + name);
				nameString.unescape = false;
				string = value;
			}
			action endValue {
				if (debug) System.out.println("value: " + name + "=" + value);
				value(name, value);
				if (stop) return;
				value.unescape = false;
				value.type = TokenType.other;
				name = null;
				string = value;
			}

			comment = ("//" | "/*") @comment;
			ws = [\t \r\n] | comment;
			ws2 = [\t ] | comment;
			comma = "," | ([\r\n] ws* ","?);
			quotedString = '"' @quotedString;
			nameString  = quotedString | (^[":,/\r\n\t }] >unquotedName);
			valueString = quotedString | (^[":,/\r\n\t {[\]] >unquotedValue);
			value = "{" @startObject | "[" @startArray | valueString %endValue;
			nameValue = nameString >startName %endName ws* ":" ws* value;
			object := ws* nameValue? ws2* <: (comma ws* nameValue ws2*)** :>> (","? ws* "}" @endObject);
			array := ws* value? ws2* <: (comma ws* value ws2*)** :>> (","? ws* "]" @endArray);
			main := ws* value ws*;

			write init;
			write exec;
		}%%
		} catch (RuntimeException ex) {
			parseRuntimeEx = ex;
		}

		if (p < pe) {
			int lineNumber = 1;
			for (int i = 0; i < p; i++)
				if (data[i] == '\n') lineNumber++;
			int start = Math.max(0, p - 32);
			throw new SerializationException("Error parsing JSON on line " + lineNumber + " near: "
				+ new String(data, start, p - start) + "*ERROR*" + new String(data, p, Math.min(64, pe - p)), parseRuntimeEx);
		}
		if (parseRuntimeEx != null) throw new SerializationException("Error parsing JSON: " + new String(data), parseRuntimeEx);
	}

	%% write data;

	protected boolean stop;

	/** Causes parsing to stop after the current or next object, array, or value. */
	public void stop () {
		stop = true;
	}

	public boolean isStopped () {
		return stop;
	}

	/** Called when an object or array is encountered in the JSON.
	 * @param name Reused after this method returns.
	 * @param object True when an object was encountered, else it was an array. */
	protected void push (@Null JsonToken name, boolean object) {
	}

	/** Called when the end of an object or array is encountered in the JSON. */
	protected void pop () {
	}

	/** Called when a value is encountered in the JSON.
	 * @param name Reused after this method returns.
	 * @param value Reused after this method returns. */
	protected void value (@Null JsonToken name, JsonToken value) {
	}

	static public class JsonToken {
		final CharArray buffer;
		public char[] chars;

		public int start, length;
		public boolean unescape;
		public TokenType type = TokenType.other;

		JsonToken (CharArray buffer) {
			this.buffer = buffer;
		}

		/** If {@link #unescape} is true, an unescaped string is allocated for the comparison. */
		public boolean equalsString (String string) {
			if (string == null) return false;
			if (unescape) return toString().equals(string);
			int n = length;
			if (string.length() != n) return false;
			char[] chars = this.chars;
			for (int c = start, s = 0; s < n; c++, s++)
				if (chars[c] != string.charAt(s)) return false;
			return true;
		}

		/** Allocates an unescaped string.
		 * @return "null" if this token represents null. */
		public String toString () {
			if (type == TokenType.nullValue) return "null";
			return unescape ? unescape() : new String(chars, start, length);
		}

		/** Returns a new JsonValue with {@link ValueType} of null, boolean, or string. */
		public JsonValue value () {
			switch (type) {
			case nullValue:
				return new JsonValue(ValueType.nullValue);
			case trueValue:
				return new JsonValue(true);
			case falseValue:
				return new JsonValue(false);
			default:
				return new JsonValue(toString());
			}
		}

		private boolean equals (String string) {
			int n = length;
			char[] chars = this.chars;
			for (int c = start, s = 0; s < n; c++, s++)
				if (chars[c] != string.charAt(s)) return false;
			return true;
		}

		private String unescape () {
			char[] chars = this.chars;
			buffer.size = 0;
			buffer.ensureCapacity(length + 16);
			outer:
			for (int i = start, n = i + length; i < n;) {
				char c = chars[i++];
				if (c != '\\') {
					buffer.append(c);
					continue;
				}
				if (i == n) throw new SerializationException("Illegal escape sequence: \\");
				c = chars[i++];
				switch (c) {
				case 'u':
					if (i + 4 > n) throw new SerializationException("Illegal escape sequence: \\u");
					buffer.size += Character.toChars( //
						(Character.digit(chars[i++], 16) << 12) //
							| (Character.digit(chars[i++], 16) << 8) //
							| (Character.digit(chars[i++], 16) << 4) //
							| Character.digit(chars[i++], 16),
						buffer.items, buffer.size);
					continue outer;
				case '"':
				case '\\':
				case '/':
					break;
				case 'b':
					c = '\b';
					break;
				case 'f':
					c = '\f';
					break;
				case 'n':
					c = '\n';
					break;
				case 'r':
					c = '\r';
					break;
				case 't':
					c = '\t';
					break;
				default:
					throw new SerializationException("Illegal escaped character: \\" + c);
				}
				buffer.append(c);
			}
			return buffer.toString();
		}

		static public enum TokenType {
			nullValue, trueValue, falseValue, other
		}
	}
}
