/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.MaterialStubList;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubElementFactory;
import com.intellij.psi.stubs.StubElementRegistryService;
import com.intellij.psi.stubs.StubList;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StubBase<T extends PsiElement>
extends ObjectStubBase<StubElement<?>>
implements StubElement<T> {
    private static volatile boolean ourStubReloadingProhibited;
    private StubList myStubList;
    private volatile T myPsi;
    private static final AtomicReferenceFieldUpdater<StubBase<?>, PsiElement> myPsiUpdater;

    protected StubBase(@Nullable StubElement parent, IStubElementType<?, ?> elementType) {
        this(parent, (IElementType)elementType);
    }

    @ApiStatus.Internal
    public StubList getStubList() {
        return this.myStubList;
    }

    @ApiStatus.Internal
    public void setStubList(StubList stubList) {
        this.myStubList = stubList;
    }

    @ApiStatus.Experimental
    protected StubBase(@Nullable StubElement parent, @Nullable IElementType elementType) {
        super(parent);
        this.myStubList = parent == null ? new MaterialStubList(10) : ((StubBase)parent).myStubList;
        this.myStubList.addStub(this, (StubBase)parent, elementType);
        if (parent == null && !(this instanceof PsiFileStub)) {
            throw new PsiInvalidElementAccessException((PsiElement)this.getPsi(), "stub hierarchy is invalid: the parent of " + this + " (" + this.getClass() + ") is null, even though it's not a PsiFileStub", null);
        }
    }

    @Override
    public StubElement<?> getParentStub() {
        return (StubElement)this.myParent;
    }

    @Override
    public PsiFileStub<?> getContainingFileStub() {
        StubBase rootStub = (StubBase)this.myStubList.get(0);
        if (!(rootStub instanceof PsiFileStub)) {
            return null;
        }
        return (PsiFileStub)((Object)rootStub);
    }

    @Override
    @NotNull
    public List<StubElement<?>> getChildrenStubs() {
        List<StubElement<?>> list = this.myStubList.getChildrenStubs(this.id);
        if (list == null) {
            StubBase.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    @Nullable
    public <P extends PsiElement, S extends StubElement<P>> S findChildStubByType(@NotNull IStubElementType<S, P> elementType) {
        if (elementType == null) {
            StubBase.$$$reportNull$$$0(1);
        }
        return this.myStubList.findChildStubByType(this.id, elementType);
    }

    @Override
    @ApiStatus.Experimental
    @Nullable
    public final StubElement<PsiElement> findChildStubByElementType(@NotNull IElementType elementType) {
        if (elementType == null) {
            StubBase.$$$reportNull$$$0(2);
        }
        return this.myStubList.findChildStubByType(this.id, elementType);
    }

    public void setPsi(@NotNull T psi) {
        if (psi == null) {
            StubBase.$$$reportNull$$$0(3);
        }
        assert (this.myPsi == null || this.myPsi == psi);
        this.myPsi = psi;
    }

    @Nullable
    private T getCachedPsi() {
        return this.myPsi;
    }

    @Override
    public T getPsi() {
        IElementType elementType;
        Object psi = this.myPsi;
        if (psi != null) {
            return psi;
        }
        StubElementRegistryService stubElementRegistryService = StubElementRegistryService.getInstance();
        StubElementFactory<?, ?> factory = stubElementRegistryService.getStubFactory(elementType = this.getElementType());
        if (factory == null) {
            throw new IllegalStateException("Stub factory is null for the element type: " + elementType);
        }
        psi = factory.createPsi(this);
        return (T)(myPsiUpdater.compareAndSet(this, (PsiElement)null, (PsiElement)psi) ? psi : (PsiElement)Objects.requireNonNull(this.myPsi));
    }

    @Override
    public <E extends PsiElement> E @NotNull [] getChildrenByType(@NotNull IElementType elementType, E[] array) {
        if (elementType == null) {
            StubBase.$$$reportNull$$$0(4);
        }
        List<StubElement<?>> childrenStubs = this.getChildrenStubs();
        int count2 = StubBase.countChildren(elementType, childrenStubs);
        array = (PsiElement[])ArrayUtil.ensureExactSize(count2, array);
        if (count2 == 0) {
            if (array == null) {
                StubBase.$$$reportNull$$$0(5);
            }
            return array;
        }
        StubBase.fillFilteredChildren((IElementType)elementType, array, childrenStubs);
        if (array == null) {
            StubBase.$$$reportNull$$$0(6);
        }
        return array;
    }

    @Override
    public <E extends PsiElement> E @NotNull [] getChildrenByType(@NotNull TokenSet filter2, E[] array) {
        if (filter2 == null) {
            StubBase.$$$reportNull$$$0(7);
        }
        List<StubElement<?>> childrenStubs = this.getChildrenStubs();
        int count2 = StubBase.countChildren(filter2, childrenStubs);
        array = (PsiElement[])ArrayUtil.ensureExactSize(count2, array);
        if (count2 == 0) {
            if (array == null) {
                StubBase.$$$reportNull$$$0(8);
            }
            return array;
        }
        StubBase.fillFilteredChildren((TokenSet)filter2, array, childrenStubs);
        if (array == null) {
            StubBase.$$$reportNull$$$0(9);
        }
        return array;
    }

    @Override
    public <E extends PsiElement> E @NotNull [] getChildrenByType(@NotNull IElementType elementType, @NotNull ArrayFactory<? extends E> f) {
        if (elementType == null) {
            StubBase.$$$reportNull$$$0(10);
        }
        if (f == null) {
            StubBase.$$$reportNull$$$0(11);
        }
        List<StubElement<?>> childrenStubs = this.getChildrenStubs();
        int count2 = StubBase.countChildren(elementType, childrenStubs);
        PsiElement[] result = (PsiElement[])f.create(count2);
        if (count2 > 0) {
            StubBase.fillFilteredChildren((IElementType)elementType, (PsiElement[])result, childrenStubs);
        }
        if (result == null) {
            StubBase.$$$reportNull$$$0(12);
        }
        return result;
    }

    private static int countChildren(IElementType elementType, List<? extends StubElement<?>> childrenStubs) {
        int count2 = 0;
        int childrenStubsSize = childrenStubs.size();
        for (int i = 0; i < childrenStubsSize; ++i) {
            StubElement<?> childStub = childrenStubs.get(i);
            if (childStub.getElementType() != elementType) continue;
            ++count2;
        }
        return count2;
    }

    private static int countChildren(TokenSet types, List<? extends StubElement<?>> childrenStubs) {
        int count2 = 0;
        int childrenStubsSize = childrenStubs.size();
        for (int i = 0; i < childrenStubsSize; ++i) {
            StubElement<?> childStub = childrenStubs.get(i);
            if (!types.contains(childStub.getElementType())) continue;
            ++count2;
        }
        return count2;
    }

    private static <E extends PsiElement> void fillFilteredChildren(IElementType type, E[] result, List<? extends StubElement<?>> childrenStubs) {
        int count2 = 0;
        int childrenStubsSize = childrenStubs.size();
        for (int i = 0; i < childrenStubsSize; ++i) {
            StubElement<?> childStub = childrenStubs.get(i);
            if (childStub.getElementType() != type) continue;
            result[count2++] = childStub.getPsi();
        }
        assert (count2 == result.length);
    }

    private static <E extends PsiElement> void fillFilteredChildren(TokenSet set, E[] result, List<? extends StubElement<?>> childrenStubs) {
        int count2 = 0;
        int childrenStubsSize = childrenStubs.size();
        for (int i = 0; i < childrenStubsSize; ++i) {
            StubElement<?> childStub = childrenStubs.get(i);
            if (!set.contains(childStub.getElementType())) continue;
            result[count2++] = childStub.getPsi();
        }
        assert (count2 == result.length);
    }

    @Override
    public <E extends PsiElement> E @NotNull [] getChildrenByType(@NotNull TokenSet filter2, @NotNull ArrayFactory<? extends E> f) {
        if (filter2 == null) {
            StubBase.$$$reportNull$$$0(13);
        }
        if (f == null) {
            StubBase.$$$reportNull$$$0(14);
        }
        List<StubElement<?>> childrenStubs = this.getChildrenStubs();
        int count2 = StubBase.countChildren(filter2, childrenStubs);
        PsiElement[] array = (PsiElement[])f.create(count2);
        if (count2 == 0) {
            if (array == null) {
                StubBase.$$$reportNull$$$0(15);
            }
            return array;
        }
        StubBase.fillFilteredChildren((TokenSet)filter2, (PsiElement[])array, childrenStubs);
        if (array == null) {
            StubBase.$$$reportNull$$$0(16);
        }
        return array;
    }

    @Override
    @Nullable
    public <E extends PsiElement> E getParentStubOfType(@NotNull Class<E> parentClass) {
        if (parentClass == null) {
            StubBase.$$$reportNull$$$0(17);
        }
        for (Stub parent = (StubElement)this.myParent; parent != null; parent = parent.getParentStub()) {
            Object psi = parent.getPsi();
            if (!parentClass.isInstance(psi)) continue;
            return (E)psi;
        }
        return null;
    }

    @Override
    @Deprecated
    public IStubElementType<?, ?> getStubType() {
        IElementType elementType = this.getElementType();
        if (elementType instanceof IStubElementType) {
            return (IStubElementType)elementType;
        }
        throw new IllegalStateException("Stub type is null for the element type: " + elementType);
    }

    @Override
    @ApiStatus.Experimental
    public IElementType getElementType() {
        return this.myStubList.getStubElementType(this.id);
    }

    @Override
    @ApiStatus.Experimental
    public ObjectStubSerializer<?, ? extends Stub> getStubSerializer() {
        ObjectStubSerializer<?, Stub> serializer2;
        IElementType elementType = this.getElementType();
        ObjectStubSerializer<?, Stub> objectStubSerializer = serializer2 = elementType != null ? StubElementRegistryService.getInstance().getStubSerializer(elementType) : null;
        if (serializer2 == null) {
            throw new IllegalStateException("Stub serializer is null for the element type: " + elementType + ", this =" + this);
        }
        return serializer2;
    }

    public Project getProject() {
        return this.getPsi().getProject();
    }

    public String printTree() {
        StringBuilder builder = new StringBuilder();
        this.printTree(builder, 0);
        return builder.toString();
    }

    private void printTree(StringBuilder builder, int nestingLevel) {
        for (int i = 0; i < nestingLevel; ++i) {
            builder.append("  ");
        }
        builder.append(this).append('\n');
        for (StubElement<?> child : this.getChildrenStubs()) {
            ((StubBase)child).printTree(builder, nestingLevel + 1);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName();
    }

    public int compareByOrderWith(ObjectStubBase<?> another) {
        return Integer.compare(this.getStubId(), another.getStubId());
    }

    @ApiStatus.Internal
    public static void checkDeserializationCreatesNoPsi(PsiFileStub<?> @NotNull [] roots) {
        if (roots == null) {
            StubBase.$$$reportNull$$$0(18);
        }
        if (ourStubReloadingProhibited) {
            return;
        }
        for (PsiFileStub<?> root : roots) {
            if (!(root instanceof StubBase)) continue;
            StubList stubList = ((StubBase)((Object)root)).getStubList();
            for (int i = 0; i < stubList.size(); ++i) {
                Object cachedPsi;
                StubBase<?> each = stubList.getCachedStub(i);
                Object v0 = cachedPsi = each == null ? null : super.getCachedPsi();
                if (cachedPsi == null) continue;
                ourStubReloadingProhibited = true;
                throw new AssertionError((Object)("Stub deserialization shouldn't create PSI: " + cachedPsi + "; " + each));
            }
        }
    }

    static {
        myPsiUpdater = AtomicReferenceFieldUpdater.newUpdater(StubBase.class, PsiElement.class, "myPsi");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/StubBase";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClass";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenStubs";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/StubBase";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenByType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findChildStubByType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findChildStubByElementType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setPsi";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenByType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getParentStubOfType";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "checkDeserializationCreatesNoPsi";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

