/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.model;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.Icon;
import kotlin.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.model.TypeFieldPair;
import org.jetbrains.yaml.meta.model.YamlArrayType;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.meta.model.YamlScalarType;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLValue;

@ApiStatus.Internal
public class Field {
    private static final Pattern PATTERN_ANYTHING = Pattern.compile(".*");
    private final String myName;
    private final MetaTypeSupplier myMetaTypeSupplier;
    private YamlMetaType myMainType;
    private boolean myIsRequired;
    private boolean myEditable;
    private boolean myDeprecated;
    @Nullable
    private Pattern myNamePattern;
    private boolean myEmptyValueAllowed;
    private boolean myIsMany;
    private Relation myOverriddenDefaultRelation;
    private Pair<String, List<String>> myRequiredSiblingValues;
    private final Map<Relation, YamlMetaType> myPerRelationTypes;

    public Field(@NonNls @NotNull String name, @NotNull YamlMetaType mainType) {
        if (name == null) {
            Field.$$$reportNull$$$0(0);
        }
        if (mainType == null) {
            Field.$$$reportNull$$$0(1);
        }
        this.myEditable = true;
        this.myDeprecated = false;
        this.myPerRelationTypes = new HashMap<Relation, YamlMetaType>();
        this.myName = name;
        this.myMainType = mainType;
        if (this.myMainType instanceof YamlArrayType) {
            this.myMainType = ((YamlArrayType)this.myMainType).getElementType();
            this.myIsMany = !(this.myMainType instanceof YamlArrayType);
        }
        this.myMetaTypeSupplier = null;
    }

    public Field(@NonNls @NotNull String name, @NotNull MetaTypeSupplier supplier) {
        if (name == null) {
            Field.$$$reportNull$$$0(2);
        }
        if (supplier == null) {
            Field.$$$reportNull$$$0(3);
        }
        this.myEditable = true;
        this.myDeprecated = false;
        this.myPerRelationTypes = new HashMap<Relation, YamlMetaType>();
        this.myName = name;
        this.myMetaTypeSupplier = supplier;
    }

    @NotNull
    public Field withDefaultRelation(@NotNull Relation relation) {
        if (relation == null) {
            Field.$$$reportNull$$$0(4);
        }
        this.myOverriddenDefaultRelation = relation;
        Field field = this;
        if (field == null) {
            Field.$$$reportNull$$$0(5);
        }
        return field;
    }

    @NotNull
    public Field withRequiredSibling(String key, List<String> values) {
        this.myRequiredSiblingValues = new Pair((Object)key, values);
        Field field = this;
        if (field == null) {
            Field.$$$reportNull$$$0(6);
        }
        return field;
    }

    public Pair<String, List<String>> getRequiredSibling() {
        return this.myRequiredSiblingValues;
    }

    public Field withRelationSpecificType(@NotNull Relation relation, @NotNull YamlMetaType specificType) {
        if (relation == null) {
            Field.$$$reportNull$$$0(7);
        }
        if (specificType == null) {
            Field.$$$reportNull$$$0(8);
        }
        this.myPerRelationTypes.put(relation, specificType);
        return this;
    }

    @NotNull
    public Field withMultiplicityMany() {
        Field field = this.withMultiplicityManyNotOne(true);
        if (field == null) {
            Field.$$$reportNull$$$0(9);
        }
        return field;
    }

    @NotNull
    public Field withMultiplicityManyNotOne(boolean manyNotOne) {
        this.myIsMany = manyNotOne;
        Field field = this;
        if (field == null) {
            Field.$$$reportNull$$$0(10);
        }
        return field;
    }

    @Contract(pure=true)
    public boolean isMany() {
        return this.myIsMany;
    }

    @NotNull
    public Field setRequired() {
        this.myIsRequired = true;
        Field field = this;
        if (field == null) {
            Field.$$$reportNull$$$0(11);
        }
        return field;
    }

    @NotNull
    public Field setDeprecated() {
        this.myDeprecated = true;
        Field field = this;
        if (field == null) {
            Field.$$$reportNull$$$0(12);
        }
        return field;
    }

    @NotNull
    public Field setNonEditable() {
        this.myEditable = false;
        Field field = this;
        if (field == null) {
            Field.$$$reportNull$$$0(13);
        }
        return field;
    }

    @Contract(pure=true)
    public final boolean isRequired() {
        return this.myIsRequired;
    }

    @Contract(pure=true)
    public final boolean isEditable() {
        return this.myEditable;
    }

    @Contract(pure=true)
    public boolean isDeprecated() {
        return this.myDeprecated;
    }

    @Contract(pure=true)
    public final String getName() {
        return this.myName;
    }

    @Contract(pure=true)
    @NotNull
    public YamlMetaType getType(@NotNull Relation relation) {
        if (relation == null) {
            Field.$$$reportNull$$$0(14);
        }
        YamlMetaType yamlMetaType = this.myPerRelationTypes.getOrDefault((Object)relation, this.getMainType());
        if (yamlMetaType == null) {
            Field.$$$reportNull$$$0(15);
        }
        return yamlMetaType;
    }

    @Contract(pure=true)
    @NotNull
    public YamlMetaType getDefaultType() {
        YamlMetaType yamlMetaType = this.getType(this.getDefaultRelation());
        if (yamlMetaType == null) {
            Field.$$$reportNull$$$0(16);
        }
        return yamlMetaType;
    }

    @NotNull
    public Relation getDefaultRelation() {
        if (this.myOverriddenDefaultRelation != null) {
            Relation relation = this.myOverriddenDefaultRelation;
            if (relation == null) {
                Field.$$$reportNull$$$0(17);
            }
            return relation;
        }
        if (this.myIsMany || this.getMainType() instanceof YamlArrayType) {
            Relation relation = Relation.SEQUENCE_ITEM;
            if (relation == null) {
                Field.$$$reportNull$$$0(18);
            }
            return relation;
        }
        Relation relation = this.getMainType() instanceof YamlScalarType ? Relation.SCALAR_VALUE : Relation.OBJECT_CONTENTS;
        if (relation == null) {
            Field.$$$reportNull$$$0(19);
        }
        return relation;
    }

    @NotNull
    public Field withEmptyValueAllowed(boolean allow) {
        this.myEmptyValueAllowed = allow;
        Field field = this;
        if (field == null) {
            Field.$$$reportNull$$$0(20);
        }
        return field;
    }

    @NotNull
    public final Field withAnyName() {
        Field field = this.withAnyName(true);
        if (field == null) {
            Field.$$$reportNull$$$0(21);
        }
        return field;
    }

    @NotNull
    public Field withAnyName(boolean allowAnyName) {
        this.myNamePattern = allowAnyName ? PATTERN_ANYTHING : null;
        Field field = this;
        if (field == null) {
            Field.$$$reportNull$$$0(22);
        }
        return field;
    }

    @NotNull
    public Field withNamePattern(@NotNull Pattern pattern) {
        if (pattern == null) {
            Field.$$$reportNull$$$0(23);
        }
        this.myNamePattern = pattern.pattern().equals(PATTERN_ANYTHING.pattern()) ? PATTERN_ANYTHING : pattern;
        Field field = this;
        if (field == null) {
            Field.$$$reportNull$$$0(24);
        }
        return field;
    }

    public final boolean isAnyNameAllowed() {
        return PATTERN_ANYTHING == this.myNamePattern;
    }

    public final boolean isByPattern() {
        return this.myNamePattern != null;
    }

    public final boolean acceptsFieldName(@NotNull String actualName) {
        if (actualName == null) {
            Field.$$$reportNull$$$0(25);
        }
        if (this.myNamePattern == null) {
            return false;
        }
        if (this.myNamePattern == PATTERN_ANYTHING) {
            return true;
        }
        return this.myNamePattern.matcher(actualName).matches();
    }

    public final boolean isEmptyValueAllowed() {
        return this.myEmptyValueAllowed;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[").append(this.getName()).append("]@");
        result.append(Integer.toHexString(this.hashCode()));
        result.append(" : ");
        result.append(this.getMainType().getTypeName());
        List nonDefaultTypes = this.myPerRelationTypes.entrySet().stream().filter(e -> e.getValue() == this.getMainType()).map(e -> String.valueOf(e.getKey()) + ":" + String.valueOf(e.getValue())).collect(Collectors.toList());
        if (!nonDefaultTypes.isEmpty()) {
            result.append(nonDefaultTypes);
        }
        return result.toString();
    }

    @NotNull
    public List<LookupElementBuilder> getKeyLookups(@NotNull YamlMetaType ownerClass, @NotNull PsiElement insertedScalar) {
        if (ownerClass == null) {
            Field.$$$reportNull$$$0(26);
        }
        if (insertedScalar == null) {
            Field.$$$reportNull$$$0(27);
        }
        if (this.isByPattern()) {
            List<LookupElementBuilder> list = Collections.emptyList();
            if (list == null) {
                Field.$$$reportNull$$$0(28);
            }
            return list;
        }
        LookupElementBuilder lookup = LookupElementBuilder.create((Object)new TypeFieldPair(ownerClass, this), (String)this.getName()).withTypeText(this.getMainType().getDisplayName(), true).withIcon(this.getLookupIcon()).withStrikeoutness(this.isDeprecated());
        if (this.isRequired()) {
            lookup = lookup.bold();
        }
        List<LookupElementBuilder> list = Collections.singletonList(lookup);
        if (list == null) {
            Field.$$$reportNull$$$0(29);
        }
        return list;
    }

    @Nullable
    public PsiReference getReferenceFromKey(@NotNull YAMLKeyValue keyValue) {
        if (keyValue == null) {
            Field.$$$reportNull$$$0(30);
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public PsiReference[] getReferencesFromKey(@NotNull YAMLKeyValue keyValue) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean hasRelationSpecificType(@NotNull Relation relation) {
        if (relation == null) {
            Field.$$$reportNull$$$0(32);
        }
        return relation == this.getDefaultRelation() || this.myPerRelationTypes.containsKey((Object)relation);
    }

    @Nullable
    public Icon getLookupIcon() {
        return this.myIsMany ? AllIcons.Json.Array : this.getMainType().getIcon();
    }

    @NotNull
    public Field resolveToSpecializedField(@NotNull YAMLValue element) {
        if (element == null) {
            Field.$$$reportNull$$$0(33);
        }
        if (this.myMetaTypeSupplier == null) {
            Field field = this;
            if (field == null) {
                Field.$$$reportNull$$$0(34);
            }
            return field;
        }
        YamlMetaType specializedType = this.myMetaTypeSupplier.getSpecializedType(element);
        if (specializedType == null) {
            Field field = this;
            if (field == null) {
                Field.$$$reportNull$$$0(35);
            }
            return field;
        }
        Field field = this.cloneWithNewType(specializedType);
        if (field == null) {
            Field.$$$reportNull$$$0(36);
        }
        return field;
    }

    private Field cloneWithNewType(@NotNull YamlMetaType newType) {
        if (newType == null) {
            Field.$$$reportNull$$$0(37);
        }
        Field result = this.newField(newType);
        result.myIsRequired = this.myIsRequired;
        result.myEditable = this.myEditable;
        result.myDeprecated = this.myDeprecated;
        result.myNamePattern = this.myNamePattern;
        result.myEmptyValueAllowed = this.myEmptyValueAllowed;
        result.myIsMany = this.myIsMany;
        result.myOverriddenDefaultRelation = this.myOverriddenDefaultRelation;
        result.myPerRelationTypes.putAll(this.myPerRelationTypes);
        return result;
    }

    @NotNull
    protected Field newField(@NotNull YamlMetaType type) {
        if (type == null) {
            Field.$$$reportNull$$$0(38);
        }
        return new Field(this.myName, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private YamlMetaType getMainType() {
        if (this.myMainType != null) {
            YamlMetaType yamlMetaType = this.myMainType;
            if (yamlMetaType != null) return yamlMetaType;
            Field.$$$reportNull$$$0(39);
            return yamlMetaType;
        }
        assert (this.myMetaTypeSupplier != null);
        MetaTypeSupplier metaTypeSupplier = this.myMetaTypeSupplier;
        // MONITORENTER : metaTypeSupplier
        if (this.myMainType == null) {
            try {
                YamlMetaType mainType = this.myMetaTypeSupplier.getMainType();
                assert (!(this.myMainType instanceof YamlArrayType)) : "Type supplier must not provide array types";
                this.myMainType = mainType;
            }
            catch (Exception e) {
                throw new RuntimeException("Supplier failed to return a metatype for field: " + String.valueOf(this), e);
            }
        }
        YamlMetaType yamlMetaType = this.myMainType;
        // MONITOREXIT : metaTypeSupplier
        if (yamlMetaType != null) return yamlMetaType;
        Field.$$$reportNull$$$0(40);
        return yamlMetaType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 9, 10, 11, 12, 13, 15, 16, 17, 18, 19, 20, 21, 22, 24, 28, 29, 34, 35, 36, 39, 40 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 4: 
            case 7: 
            case 14: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relation";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 28: 
            case 29: 
            case 34: 
            case 35: 
            case 36: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/meta/model/Field";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specificType";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualName";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerClass";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertedScalar";
                break;
            }
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyValue";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newType";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/meta/model/Field";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "withDefaultRelation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "withRequiredSibling";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "withMultiplicityMany";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "withMultiplicityManyNotOne";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "setRequired";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "setDeprecated";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "setNonEditable";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultType";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultRelation";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "withEmptyValueAllowed";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "withAnyName";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "withNamePattern";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyLookups";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToSpecializedField";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "withDefaultRelation";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 28: 
            case 29: 
            case 34: 
            case 35: 
            case 36: 
            case 39: 
            case 40: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "withRelationSpecificType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "withNamePattern";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "acceptsFieldName";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getKeyLookups";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceFromKey";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesFromKey";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "hasRelationSpecificType";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "resolveToSpecializedField";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "cloneWithNewType";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "newField";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 9, 10, 11, 12, 13, 15, 16, 17, 18, 19, 20, 21, 22, 24, 28, 29, 34, 35, 36, 39, 40 -> new IllegalStateException(string);
        };
    }

    public static interface MetaTypeSupplier {
        @NotNull
        public YamlMetaType getMainType();

        @Nullable
        default public YamlMetaType getSpecializedType(@NotNull YAMLValue element) {
            if (element == null) {
                MetaTypeSupplier.$$$reportNull$$$0(0);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/yaml/meta/model/Field$MetaTypeSupplier", "getSpecializedType"));
        }
    }

    public static enum Relation {
        SCALAR_VALUE,
        SEQUENCE_ITEM,
        OBJECT_CONTENTS;

    }
}

