/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.http;

import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.crt.AsyncCallback;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.http.Http2ConnectionSetting;
import software.amazon.awssdk.crt.http.Http2Request;
import software.amazon.awssdk.crt.http.Http2Stream;
import software.amazon.awssdk.crt.http.Http2StreamManagerOptions;
import software.amazon.awssdk.crt.http.HttpClientConnectionManagerOptions;
import software.amazon.awssdk.crt.http.HttpManagerMetrics;
import software.amazon.awssdk.crt.http.HttpMonitoringOptions;
import software.amazon.awssdk.crt.http.HttpProxyOptions;
import software.amazon.awssdk.crt.http.HttpRequest;
import software.amazon.awssdk.crt.http.HttpRequestBase;
import software.amazon.awssdk.crt.http.HttpRequestBodyStream;
import software.amazon.awssdk.crt.http.HttpStreamBaseResponseHandler;
import software.amazon.awssdk.crt.http.HttpStreamResponseHandlerNativeAdapter;
import software.amazon.awssdk.crt.io.ClientBootstrap;
import software.amazon.awssdk.crt.io.SocketOptions;
import software.amazon.awssdk.crt.io.TlsConnectionOptions;
import software.amazon.awssdk.crt.io.TlsContext;

public class Http2StreamManager
extends CrtResource {
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final int DEFAULT_HTTPS_PORT = 443;
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private final URI uri;
    private final int port;
    private final int maxConnections;
    private final int idealConcurrentStreamsPerConnection;
    private final int maxConcurrentStreamsPerConnection;
    private final CompletableFuture<Void> shutdownComplete = new CompletableFuture();

    public static Http2StreamManager create(Http2StreamManagerOptions options) {
        return new Http2StreamManager(options);
    }

    private Http2StreamManager(Http2StreamManagerOptions options) {
        options.validateOptions();
        HttpClientConnectionManagerOptions connectionManagerOptions = options.getConnectionManagerOptions();
        URI uri = connectionManagerOptions.getUri();
        ClientBootstrap clientBootstrap = connectionManagerOptions.getClientBootstrap();
        SocketOptions socketOptions = connectionManagerOptions.getSocketOptions();
        boolean useTls = HTTPS.equals(uri.getScheme());
        TlsContext tlsContext = connectionManagerOptions.getTlsContext();
        TlsConnectionOptions tlsConnectionOptions = connectionManagerOptions.getTlsConnectionOptions();
        int maxConnections = connectionManagerOptions.getMaxConnections();
        int port = connectionManagerOptions.getPort();
        if (port == -1 && (port = uri.getPort()) == -1) {
            if (HTTP.equals(uri.getScheme())) {
                port = 80;
            }
            if (HTTPS.equals(uri.getScheme())) {
                port = 443;
            }
        }
        int maxConcurrentStreamsPerConnection = options.getMaxConcurrentStreamsPerConnection();
        int idealConcurrentStreamsPerConnection = options.getIdealConcurrentStreamsPerConnection();
        this.uri = uri;
        this.port = port;
        this.maxConnections = maxConnections;
        this.idealConcurrentStreamsPerConnection = idealConcurrentStreamsPerConnection;
        this.maxConcurrentStreamsPerConnection = maxConcurrentStreamsPerConnection;
        int proxyConnectionType = 0;
        String proxyHost = null;
        int proxyPort = 0;
        TlsContext proxyTlsContext = null;
        int proxyAuthorizationType = 0;
        String proxyAuthorizationUsername = null;
        String proxyAuthorizationPassword = null;
        HttpProxyOptions proxyOptions = connectionManagerOptions.getProxyOptions();
        if (proxyOptions != null) {
            proxyConnectionType = proxyOptions.getConnectionType().getValue();
            proxyHost = proxyOptions.getHost();
            proxyPort = proxyOptions.getPort();
            proxyTlsContext = proxyOptions.getTlsContext();
            proxyAuthorizationType = proxyOptions.getAuthorizationType().getValue();
            proxyAuthorizationUsername = proxyOptions.getAuthorizationUsername();
            proxyAuthorizationPassword = proxyOptions.getAuthorizationPassword();
        }
        HttpMonitoringOptions monitoringOptions = connectionManagerOptions.getMonitoringOptions();
        long monitoringThroughputThresholdInBytesPerSecond = 0L;
        int monitoringFailureIntervalInSeconds = 0;
        if (monitoringOptions != null) {
            monitoringThroughputThresholdInBytesPerSecond = monitoringOptions.getMinThroughputBytesPerSecond();
            monitoringFailureIntervalInSeconds = monitoringOptions.getAllowableThroughputFailureIntervalSeconds();
        }
        this.acquireNativeHandle(Http2StreamManager.http2StreamManagerNew(this, clientBootstrap.getNativeHandle(), socketOptions.getNativeHandle(), useTls && tlsContext != null ? tlsContext.getNativeHandle() : 0L, useTls && tlsConnectionOptions != null ? tlsConnectionOptions.getNativeHandle() : 0L, Http2ConnectionSetting.marshallSettingsForJNI(options.getInitialSettingsList()), uri.getHost().getBytes(UTF8), port, proxyConnectionType, proxyHost != null ? proxyHost.getBytes(UTF8) : null, proxyPort, proxyTlsContext != null ? proxyTlsContext.getNativeHandle() : 0L, proxyAuthorizationType, proxyAuthorizationUsername != null ? proxyAuthorizationUsername.getBytes(UTF8) : null, proxyAuthorizationPassword != null ? proxyAuthorizationPassword.getBytes(UTF8) : null, connectionManagerOptions.isManualWindowManagement(), monitoringThroughputThresholdInBytesPerSecond, monitoringFailureIntervalInSeconds, maxConnections, idealConcurrentStreamsPerConnection, maxConcurrentStreamsPerConnection, options.hasPriorKnowledge(), options.shouldCloseConnectionOnServerError(), options.getConnectionPingPeriodMs(), options.getConnectionPingTimeoutMs()));
        this.addReferenceTo(clientBootstrap);
        if (useTls) {
            this.addReferenceTo(tlsContext);
        }
    }

    public CompletableFuture<Http2Stream> acquireStream(Http2Request request, HttpStreamBaseResponseHandler streamHandler) {
        return this.acquireStream((HttpRequestBase)request, streamHandler);
    }

    public CompletableFuture<Http2Stream> acquireStream(HttpRequest request, HttpStreamBaseResponseHandler streamHandler) {
        return this.acquireStream((HttpRequestBase)request, streamHandler);
    }

    private CompletableFuture<Http2Stream> acquireStream(HttpRequestBase request, HttpStreamBaseResponseHandler streamHandler) {
        CompletableFuture<Http2Stream> completionFuture = new CompletableFuture<Http2Stream>();
        AsyncCallback acquireStreamCompleted = AsyncCallback.wrapFuture(completionFuture, null);
        if (this.isNull()) {
            completionFuture.completeExceptionally(new IllegalStateException("Http2StreamManager has been closed, can't acquire new streams"));
            return completionFuture;
        }
        try {
            Http2StreamManager.http2StreamManagerAcquireStream(this.getNativeHandle(), request.marshalForJni(), request.getBodyStream(), new HttpStreamResponseHandlerNativeAdapter(streamHandler), acquireStreamCompleted);
        }
        catch (CrtRuntimeException ex) {
            completionFuture.completeExceptionally(ex);
        }
        return completionFuture;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public HttpManagerMetrics getManagerMetrics() {
        if (this.isNull()) {
            throw new IllegalStateException("HttpClientConnectionManager has been closed, can't fetch metrics");
        }
        return Http2StreamManager.http2StreamManagerFetchMetrics(this.getNativeHandle());
    }

    private void onShutdownComplete() {
        this.releaseReferences();
        this.shutdownComplete.complete(null);
    }

    @Override
    protected boolean canReleaseReferencesImmediately() {
        return false;
    }

    @Override
    protected void releaseNativeHandle() {
        if (!this.isNull()) {
            Http2StreamManager.http2StreamManagerRelease(this.getNativeHandle());
        }
    }

    public CompletableFuture<Void> getShutdownCompleteFuture() {
        return this.shutdownComplete;
    }

    private static native long http2StreamManagerNew(Http2StreamManager var0, long var1, long var3, long var5, long var7, long[] var9, byte[] var10, int var11, int var12, byte[] var13, int var14, long var15, int var17, byte[] var18, byte[] var19, boolean var20, long var21, int var23, int var24, int var25, int var26, boolean var27, boolean var28, int var29, int var30) throws CrtRuntimeException;

    private static native void http2StreamManagerRelease(long var0) throws CrtRuntimeException;

    private static native void http2StreamManagerAcquireStream(long var0, byte[] var2, HttpRequestBodyStream var3, HttpStreamResponseHandlerNativeAdapter var4, AsyncCallback var5) throws CrtRuntimeException;

    private static native HttpManagerMetrics http2StreamManagerFetchMetrics(long var0) throws CrtRuntimeException;
}

