/*
 * Decompiled with CFR 0.152.
 */
package dafny;

import dafny.Array;
import dafny.DafnySequence;
import dafny.NonLazyDafnySequence;
import dafny.TypeDescriptor;
import java.util.Iterator;

final class StringDafnySequence
extends NonLazyDafnySequence<Character> {
    private final String string;

    StringDafnySequence(String string) {
        this.string = string;
    }

    @Override
    public Array<Character> toArray() {
        return Array.wrap(this.string.toCharArray());
    }

    @Override
    public TypeDescriptor<Character> elementType() {
        return TypeDescriptor.CHAR;
    }

    @Override
    public Character select(int i) {
        return Character.valueOf(this.string.charAt(i));
    }

    @Override
    public int length() {
        return this.string.length();
    }

    @Override
    public <R> DafnySequence<R> update(int i, R t) {
        assert (t != null) : "Precondition Violation";
        StringBuilder sb = new StringBuilder(this.string);
        sb.setCharAt(i, ((Character)t).charValue());
        return new StringDafnySequence(sb.toString());
    }

    @Override
    public boolean contains(Object t) {
        assert (t != null) : "Precondition Violation";
        return this.string.indexOf(((Character)t).charValue()) != -1;
    }

    @Override
    public DafnySequence<Character> subsequence(int lo, int hi) {
        return new StringDafnySequence(this.string.substring(lo, hi));
    }

    @Override
    DafnySequence.Copier<Character> newCopier(final int length) {
        return new DafnySequence.Copier<Character>(){
            private final StringBuilder sb;
            {
                this.sb = new StringBuilder(length);
            }

            @Override
            public void copyFrom(DafnySequence<Character> source) {
                if ((source = source.force()) instanceof StringDafnySequence) {
                    this.sb.append(((StringDafnySequence)source).string);
                } else {
                    for (char c : source) {
                        this.sb.append(c);
                    }
                }
            }

            @Override
            public NonLazyDafnySequence<Character> result() {
                return new StringDafnySequence(this.sb.toString());
            }
        };
    }

    @Override
    public Iterator<Character> iterator() {
        final int n = this.string.length();
        return new Iterator<Character>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < n;
            }

            @Override
            public Character next() {
                return Character.valueOf(StringDafnySequence.this.string.charAt(this.i++));
            }
        };
    }

    @Override
    public boolean equalsNonLazy(NonLazyDafnySequence<Character> obj) {
        if (obj instanceof StringDafnySequence) {
            return this.string.equals(((StringDafnySequence)obj).string);
        }
        return super.equalsNonLazy(obj);
    }

    @Override
    public int hashCode() {
        return this.string.hashCode();
    }

    @Override
    public String verbatimString() {
        return this.string;
    }

    @Override
    public String toString() {
        return this.string;
    }
}

