/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AddIpamOperatingRegion;
import software.amazon.awssdk.services.ec2.model.AddIpamOperatingRegionSetCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.IpamMeteredAccount;
import software.amazon.awssdk.services.ec2.model.IpamTier;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateIpamRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateIpamRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(CreateIpamRequest.getter(CreateIpamRequest::dryRun)).setter(CreateIpamRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateIpamRequest.getter(CreateIpamRequest::description)).setter(CreateIpamRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<List<AddIpamOperatingRegion>> OPERATING_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OperatingRegions").getter(CreateIpamRequest.getter(CreateIpamRequest::operatingRegions)).setter(CreateIpamRequest.setter(Builder::operatingRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingRegion").unmarshallLocationName("OperatingRegion").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AddIpamOperatingRegion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateIpamRequest.getter(CreateIpamRequest::tagSpecifications)).setter(CreateIpamRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateIpamRequest.getter(CreateIpamRequest::clientToken)).setter(CreateIpamRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Tier").getter(CreateIpamRequest.getter(CreateIpamRequest::tierAsString)).setter(CreateIpamRequest.setter(Builder::tier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tier").unmarshallLocationName("Tier").build()}).build();
    private static final SdkField<Boolean> ENABLE_PRIVATE_GUA_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnablePrivateGua").getter(CreateIpamRequest.getter(CreateIpamRequest::enablePrivateGua)).setter(CreateIpamRequest.setter(Builder::enablePrivateGua)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablePrivateGua").unmarshallLocationName("EnablePrivateGua").build()}).build();
    private static final SdkField<String> METERED_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MeteredAccount").getter(CreateIpamRequest.getter(CreateIpamRequest::meteredAccountAsString)).setter(CreateIpamRequest.setter(Builder::meteredAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeteredAccount").unmarshallLocationName("MeteredAccount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, DESCRIPTION_FIELD, OPERATING_REGIONS_FIELD, TAG_SPECIFICATIONS_FIELD, CLIENT_TOKEN_FIELD, TIER_FIELD, ENABLE_PRIVATE_GUA_FIELD, METERED_ACCOUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateIpamRequest.memberNameToFieldInitializer();
    private final Boolean dryRun;
    private final String description;
    private final List<AddIpamOperatingRegion> operatingRegions;
    private final List<TagSpecification> tagSpecifications;
    private final String clientToken;
    private final String tier;
    private final Boolean enablePrivateGua;
    private final String meteredAccount;

    private CreateIpamRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.description = builder.description;
        this.operatingRegions = builder.operatingRegions;
        this.tagSpecifications = builder.tagSpecifications;
        this.clientToken = builder.clientToken;
        this.tier = builder.tier;
        this.enablePrivateGua = builder.enablePrivateGua;
        this.meteredAccount = builder.meteredAccount;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasOperatingRegions() {
        return this.operatingRegions != null && !(this.operatingRegions instanceof SdkAutoConstructList);
    }

    public final List<AddIpamOperatingRegion> operatingRegions() {
        return this.operatingRegions;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final IpamTier tier() {
        return IpamTier.fromValue(this.tier);
    }

    public final String tierAsString() {
        return this.tier;
    }

    public final Boolean enablePrivateGua() {
        return this.enablePrivateGua;
    }

    public final IpamMeteredAccount meteredAccount() {
        return IpamMeteredAccount.fromValue(this.meteredAccount);
    }

    public final String meteredAccountAsString() {
        return this.meteredAccount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOperatingRegions() ? this.operatingRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.tierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enablePrivateGua());
        hashCode = 31 * hashCode + Objects.hashCode(this.meteredAccountAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIpamRequest)) {
            return false;
        }
        CreateIpamRequest other = (CreateIpamRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.description(), other.description()) && this.hasOperatingRegions() == other.hasOperatingRegions() && Objects.equals(this.operatingRegions(), other.operatingRegions()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.tierAsString(), other.tierAsString()) && Objects.equals(this.enablePrivateGua(), other.enablePrivateGua()) && Objects.equals(this.meteredAccountAsString(), other.meteredAccountAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateIpamRequest").add("DryRun", (Object)this.dryRun()).add("Description", (Object)this.description()).add("OperatingRegions", this.hasOperatingRegions() ? this.operatingRegions() : null).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("ClientToken", (Object)this.clientToken()).add("Tier", (Object)this.tierAsString()).add("EnablePrivateGua", (Object)this.enablePrivateGua()).add("MeteredAccount", (Object)this.meteredAccountAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "OperatingRegions": {
                return Optional.ofNullable(clazz.cast(this.operatingRegions()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Tier": {
                return Optional.ofNullable(clazz.cast(this.tierAsString()));
            }
            case "EnablePrivateGua": {
                return Optional.ofNullable(clazz.cast(this.enablePrivateGua()));
            }
            case "MeteredAccount": {
                return Optional.ofNullable(clazz.cast(this.meteredAccountAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("OperatingRegion", OPERATING_REGIONS_FIELD);
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Tier", TIER_FIELD);
        map.put("EnablePrivateGua", ENABLE_PRIVATE_GUA_FIELD);
        map.put("MeteredAccount", METERED_ACCOUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateIpamRequest, T> g) {
        return obj -> g.apply((CreateIpamRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private String description;
        private List<AddIpamOperatingRegion> operatingRegions = DefaultSdkAutoConstructList.getInstance();
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;
        private String tier;
        private Boolean enablePrivateGua;
        private String meteredAccount;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIpamRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.description(model.description);
            this.operatingRegions(model.operatingRegions);
            this.tagSpecifications(model.tagSpecifications);
            this.clientToken(model.clientToken);
            this.tier(model.tier);
            this.enablePrivateGua(model.enablePrivateGua);
            this.meteredAccount(model.meteredAccount);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<AddIpamOperatingRegion.Builder> getOperatingRegions() {
            List<AddIpamOperatingRegion.Builder> result = AddIpamOperatingRegionSetCopier.copyToBuilder(this.operatingRegions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOperatingRegions(Collection<AddIpamOperatingRegion.BuilderImpl> operatingRegions) {
            this.operatingRegions = AddIpamOperatingRegionSetCopier.copyFromBuilder(operatingRegions);
        }

        @Override
        public final Builder operatingRegions(Collection<AddIpamOperatingRegion> operatingRegions) {
            this.operatingRegions = AddIpamOperatingRegionSetCopier.copy(operatingRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operatingRegions(AddIpamOperatingRegion ... operatingRegions) {
            this.operatingRegions(Arrays.asList(operatingRegions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operatingRegions(Consumer<AddIpamOperatingRegion.Builder> ... operatingRegions) {
            this.operatingRegions(Stream.of(operatingRegions).map(c -> (AddIpamOperatingRegion)((AddIpamOperatingRegion.Builder)AddIpamOperatingRegion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getTier() {
            return this.tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(IpamTier tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        public final Boolean getEnablePrivateGua() {
            return this.enablePrivateGua;
        }

        public final void setEnablePrivateGua(Boolean enablePrivateGua) {
            this.enablePrivateGua = enablePrivateGua;
        }

        @Override
        public final Builder enablePrivateGua(Boolean enablePrivateGua) {
            this.enablePrivateGua = enablePrivateGua;
            return this;
        }

        public final String getMeteredAccount() {
            return this.meteredAccount;
        }

        public final void setMeteredAccount(String meteredAccount) {
            this.meteredAccount = meteredAccount;
        }

        @Override
        public final Builder meteredAccount(String meteredAccount) {
            this.meteredAccount = meteredAccount;
            return this;
        }

        @Override
        public final Builder meteredAccount(IpamMeteredAccount meteredAccount) {
            this.meteredAccount(meteredAccount == null ? null : meteredAccount.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIpamRequest build() {
            return new CreateIpamRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateIpamRequest> {
        public Builder dryRun(Boolean var1);

        public Builder description(String var1);

        public Builder operatingRegions(Collection<AddIpamOperatingRegion> var1);

        public Builder operatingRegions(AddIpamOperatingRegion ... var1);

        public Builder operatingRegions(Consumer<AddIpamOperatingRegion.Builder> ... var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder tier(String var1);

        public Builder tier(IpamTier var1);

        public Builder enablePrivateGua(Boolean var1);

        public Builder meteredAccount(String var1);

        public Builder meteredAccount(IpamMeteredAccount var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

