"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getTooltipAnchorPositionSelector = void 0;
var settings_1 = require("../../../../specs/settings");
var create_selector_1 = require("../../../../state/create_selector");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var crosshair_utils_1 = require("../../crosshair/crosshair_utils");
var compute_chart_dimensions_1 = require("./compute_chart_dimensions");
var compute_small_multiple_scales_1 = require("./compute_small_multiple_scales");
var get_cursor_band_1 = require("./get_cursor_band");
var get_projected_pointer_position_1 = require("./get_projected_pointer_position");
exports.getTooltipAnchorPositionSelector = create_selector_1.createCustomCachedSelector([
    compute_chart_dimensions_1.computeChartDimensionsSelector,
    get_settings_specs_1.getSettingsSpecSelector,
    get_cursor_band_1.getCursorBandPositionSelector,
    get_projected_pointer_position_1.getProjectedPointerPositionSelector,
    compute_small_multiple_scales_1.computeSmallMultipleScalesSelector,
], function (chartDimensions, settings, cursorBandPosition, projectedPointerPosition, _a) {
    var _b, _c;
    var horizontal = _a.horizontal, vertical = _a.vertical;
    if (!cursorBandPosition) {
        return null;
    }
    var topPos = (_b = vertical.scale(projectedPointerPosition.verticalPanelValue)) !== null && _b !== void 0 ? _b : 0;
    var leftPos = (_c = horizontal.scale(projectedPointerPosition.horizontalPanelValue)) !== null && _c !== void 0 ? _c : 0;
    var panel = {
        width: horizontal.bandwidth,
        height: vertical.bandwidth,
        top: chartDimensions.chartDimensions.top + topPos,
        left: chartDimensions.chartDimensions.left + leftPos,
    };
    return crosshair_utils_1.getTooltipAnchorPosition(settings.rotation, cursorBandPosition, projectedPointerPosition, panel, settings_1.isTooltipType(settings.tooltip) ? undefined : settings.tooltip.stickTo);
});
//# sourceMappingURL=get_tooltip_position.js.map