/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.ad.settings.ADEnabledSetting;
import org.opensearch.ad.settings.AnomalyDetectorSettings;
import org.opensearch.ad.transport.SuggestAnomalyDetectorParamAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.ValidationException;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.transport.SuggestConfigParamRequest;
import org.opensearch.transport.client.node.NodeClient;
import org.owasp.encoder.Encode;

public class RestAnomalyDetectorSuggestAction
extends BaseRestHandler {
    private static final String ANOMALY_DETECTOR_SUGGEST_ACTION = "anomaly_detector_suggest_action";
    private volatile TimeValue requestTimeout;

    public RestAnomalyDetectorSuggestAction(Settings settings, ClusterService clusterService) {
        this.requestTimeout = (TimeValue)AnomalyDetectorSettings.AD_REQUEST_TIMEOUT.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.AD_REQUEST_TIMEOUT, it -> {
            this.requestTimeout = it;
        });
    }

    public String getName() {
        return ANOMALY_DETECTOR_SUGGEST_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/%s/{%s}", "/_plugins/_anomaly_detection/detectors", "_suggest", "type")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!ADEnabledSetting.isADEnabled()) {
            throw new IllegalStateException("AD functionality is disabled. To enable update plugins.anomaly_detection.enabled to true");
        }
        try {
            XContentParser parser = request.contentParser();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
            String typesStr = request.param("type");
            AnomalyDetector config = this.parseConfig(parser);
            if (config != null) {
                return channel -> {
                    SuggestConfigParamRequest suggestAnomalyDetectorParamRequest = new SuggestConfigParamRequest(AnalysisType.AD, config, typesStr, this.requestTimeout);
                    client.execute((ActionType)SuggestAnomalyDetectorParamAction.INSTANCE, (ActionRequest)suggestAnomalyDetectorParamRequest, (ActionListener)new RestToXContentListener(channel));
                };
            }
            ValidationException validationException = new ValidationException();
            validationException.addValidationError("fail to parse config");
            throw validationException;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(Encode.forHtml((String)e.getMessage()));
        }
    }

    private AnomalyDetector parseConfig(XContentParser parser) throws IOException {
        try {
            return AnomalyDetector.parse(parser, null, null, new TimeValue(1L, TimeUnit.MINUTES), null);
        }
        catch (Exception e) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationError(e.getMessage());
            throw validationException;
        }
    }
}

