/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.UniversalConnectionPoolManagerBase;
import oracle.ucp.common.FailoverEvent;
import oracle.ucp.common.FailoverEventHandlerTask;
import oracle.ucp.common.Failoverable;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.util.TaskHandle;
import oracle.ucp.util.TaskManager;
import oracle.ucp.util.TaskManagerException;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.UCPTaskBase;

public abstract class FailoverEventHandlerTaskBase
extends UCPTaskBase<Object>
implements FailoverEventHandlerTask,
Diagnosable {
    static final String CLASS_NAME = FailoverEventHandlerTaskBase.class.getName();
    private final AtomicBoolean m_terminate = new AtomicBoolean(false);
    private Failoverable m_failoverableObject;
    private TaskHandle<Object> m_taskHandle = null;

    public FailoverEventHandlerTaskBase(Failoverable failoverableObject) throws UniversalConnectionPoolException {
        this.setFailoverableObject(failoverableObject);
    }

    @Override
    public void handleEvent(FailoverEvent event) throws UniversalConnectionPoolException {
        this.m_failoverableObject.handleFailoverEvent(event);
    }

    @Override
    public abstract void run();

    @Override
    public Failoverable getFailoverableObject() {
        return this.m_failoverableObject;
    }

    @Override
    public void setFailoverableObject(Failoverable failoverableObject) throws UniversalConnectionPoolException {
        if (failoverableObject == null) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(58);
        }
        this.m_failoverableObject = failoverableObject;
    }

    @Override
    public boolean isTerminate() {
        return this.m_terminate.get();
    }

    @Override
    public void setTerminate(boolean terminate) {
        this.m_terminate.set(terminate);
    }

    @Override
    public void start() {
        this.m_terminate.set(false);
        if (null == this.m_taskHandle) {
            this.m_taskHandle = this.getTaskManager().submitTask(this);
        } else {
            this.trace(Level.WARNING, CLASS_NAME, "start", "attempt to start the running failover task", null, null, new Object[0]);
        }
    }

    protected TaskManager getTaskManager() {
        return UniversalConnectionPoolManagerBase.getTaskManager();
    }

    @Override
    public void waitTerminate() {
        this.m_terminate.set(true);
        if (null != this.m_taskHandle) {
            try {
                this.m_taskHandle.get(100000L);
                this.m_taskHandle = null;
            }
            catch (TaskManagerException e) {
                this.trace(Level.WARNING, CLASS_NAME, "waitTerminate", "", null, e, new Object[0]);
            }
        }
    }

    @Override
    public boolean isCritical() {
        return true;
    }

    @Override
    public Diagnosable getDiagnosable() {
        return DiagnosticsCollectorImpl.getCommon();
    }
}

