/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.border.MatteBorder;

public class IconBorder
extends MatteBorder {
    private static final long serialVersionUID = -5657747462265533365L;
    private int _horizontalIconAlignment = -1;
    private int _verticalIconAlignment = -1;

    public IconBorder(Icon icon) {
        super(0, 0, 0, icon.getIconWidth(), icon);
        this._verticalIconAlignment = 1;
    }

    public IconBorder(Icon icon, int verticalIconAlignment) {
        super(0, 0, 0, icon.getIconWidth(), icon);
        this._verticalIconAlignment = verticalIconAlignment;
    }

    public IconBorder(Insets borderInsets, Icon icon) {
        super(borderInsets, icon);
        if (borderInsets.right > 0 || borderInsets.left > 0) {
            this._verticalIconAlignment = 1;
        } else if (borderInsets.top > 0 || borderInsets.bottom > 0) {
            this._horizontalIconAlignment = 11;
        }
    }

    public IconBorder(int top, int left, int bottom, int right, Icon icon) {
        super(top, left, bottom, right, icon);
        if (right > 0 || left > 0) {
            this._verticalIconAlignment = 1;
        } else if (top > 0 || bottom > 0) {
            this._horizontalIconAlignment = 11;
        }
    }

    public int getHorizontalIconAlignment() {
        return this._horizontalIconAlignment;
    }

    public void setHorizontalIconAlignment(int horizontalIconAlignment) {
        this._horizontalIconAlignment = horizontalIconAlignment;
    }

    public int getVerticalIconAlignment() {
        return this._verticalIconAlignment;
    }

    public void setVerticalIconAlignment(int verticalIconAlignment) {
        this._verticalIconAlignment = verticalIconAlignment;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.getHorizontalIconAlignment() == -1 && this.getVerticalIconAlignment() == -1 || this.tileIcon == null) {
            super.paintBorder(c, g, x, y, width, height);
        } else {
            Insets insets = this.getBorderInsets(c);
            Color oldColor = g.getColor();
            g.translate(x, y);
            if (this.tileIcon != null) {
                Color color = this.color = this.tileIcon.getIconWidth() == -1 ? Color.gray : null;
            }
            if (this.color != null) {
                g.setColor(this.color);
                g.fillRect(0, 0, width - insets.right, insets.top);
                g.fillRect(0, insets.top, insets.left, height - insets.top);
                g.fillRect(insets.left, height - insets.bottom, width - insets.left, insets.bottom);
                g.fillRect(width - insets.right, 0, insets.right, height - insets.bottom);
            } else if (this.tileIcon != null) {
                int ypos;
                int xpos;
                int iconAlignment;
                int starty;
                int startx;
                Graphics cg;
                int tileW = this.tileIcon.getIconWidth();
                int tileH = this.tileIcon.getIconHeight();
                if (insets.top > 0) {
                    cg = g.create();
                    cg.setClip(0, 0, width, insets.top);
                    startx = insets.left;
                    starty = 0;
                    iconAlignment = this.getVerticalIconAlignment();
                    if (!c.getComponentOrientation().isLeftToRight()) {
                        if (iconAlignment == 10) {
                            iconAlignment = 4;
                        } else if (iconAlignment == 11) {
                            iconAlignment = 2;
                        }
                    }
                    switch (iconAlignment) {
                        case 2: 
                        case 10: {
                            xpos = startx;
                            ypos = starty;
                            break;
                        }
                        case 0: {
                            xpos = startx + (width - tileW) / 2;
                            ypos = starty;
                            break;
                        }
                        default: {
                            xpos = startx + width - tileW;
                            ypos = starty;
                        }
                    }
                    this.tileIcon.paintIcon(c, cg, xpos, ypos);
                    cg.dispose();
                }
                if (insets.left > 0) {
                    cg = g.create();
                    cg.setClip(0, insets.top, insets.left, height - insets.top);
                    starty = insets.top;
                    startx = 0;
                    switch (this.getVerticalIconAlignment()) {
                        case 1: 
                        case 10: {
                            xpos = startx;
                            ypos = starty;
                            break;
                        }
                        case 0: {
                            xpos = startx;
                            ypos = starty + (height - tileH) / 2;
                            break;
                        }
                        default: {
                            xpos = startx;
                            ypos = starty + height - tileH;
                        }
                    }
                    this.tileIcon.paintIcon(c, cg, xpos, ypos);
                    cg.dispose();
                }
                if (insets.bottom > 0) {
                    cg = g.create();
                    cg.setClip(insets.left, height - insets.bottom, width - insets.left, insets.bottom);
                    starty = height - insets.bottom;
                    startx = insets.left;
                    iconAlignment = this.getHorizontalIconAlignment();
                    if (!c.getComponentOrientation().isLeftToRight()) {
                        if (iconAlignment == 10) {
                            iconAlignment = 4;
                        } else if (iconAlignment == 11) {
                            iconAlignment = 2;
                        }
                    }
                    switch (iconAlignment) {
                        case 2: 
                        case 10: {
                            xpos = startx;
                            ypos = starty;
                            break;
                        }
                        case 0: {
                            xpos = startx + (width - tileW) / 2;
                            ypos = starty;
                            break;
                        }
                        default: {
                            xpos = startx + width - tileW;
                            ypos = starty;
                        }
                    }
                    this.tileIcon.paintIcon(c, cg, xpos, ypos);
                    cg.dispose();
                }
                if (insets.right > 0) {
                    cg = g.create();
                    cg.setClip(width - insets.right, insets.top, insets.right, height - insets.top - insets.bottom);
                    starty = insets.top;
                    startx = width - insets.right;
                    switch (this.getVerticalIconAlignment()) {
                        case 1: 
                        case 10: {
                            xpos = startx;
                            ypos = starty;
                            break;
                        }
                        case 0: {
                            xpos = startx;
                            ypos = starty + (height - tileH) / 2;
                            break;
                        }
                        default: {
                            xpos = startx;
                            ypos = starty + height - tileH;
                        }
                    }
                    this.tileIcon.paintIcon(c, cg, xpos, ypos);
                    cg.dispose();
                }
            }
            g.translate(-x, -y);
            g.setColor(oldColor);
        }
    }
}

