/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.workflow.admin.resource;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.keycloak.models.ModelException;
import org.keycloak.models.workflow.ResourceType;
import org.keycloak.models.workflow.Workflow;
import org.keycloak.models.workflow.WorkflowProvider;
import org.keycloak.representations.workflows.WorkflowRepresentation;
import org.keycloak.services.ErrorResponse;

@Extension(name="x-smallrye-profile-admin", value="")
public class WorkflowResource {
    private final WorkflowProvider provider;
    private final Workflow workflow;

    public WorkflowResource(WorkflowProvider provider, Workflow workflow) {
        this.provider = provider;
        this.workflow = workflow;
    }

    @DELETE
    @Tag(name="Workflows")
    @Operation(summary="Delete workflow", description="Delete the workflow and its configuration.")
    @APIResponses(value={@APIResponse(responseCode="204", description="No Content"), @APIResponse(responseCode="400", description="Bad Request")})
    public void delete() {
        try {
            this.provider.removeWorkflow(this.workflow);
        }
        catch (ModelException me) {
            throw ErrorResponse.error(me.getMessage(), Response.Status.BAD_REQUEST);
        }
    }

    @PUT
    @Consumes(value={"application/yaml", "application/json"})
    @Tag(name="Workflows")
    @Operation(summary="Update workflow", description="Update the workflow configuration. This method does not update the workflow steps.")
    @APIResponses(value={@APIResponse(responseCode="204", description="No Content"), @APIResponse(responseCode="400", description="Bad Request")})
    public void update(WorkflowRepresentation rep) {
        try {
            rep.setId(this.workflow.getId());
            this.provider.updateWorkflow(this.workflow, rep);
        }
        catch (ModelException me) {
            throw ErrorResponse.error(me.getMessage(), Response.Status.BAD_REQUEST);
        }
    }

    @GET
    @Produces(value={"application/yaml", "application/json"})
    @Tag(name="Workflows")
    @Operation(summary="Get workflow", description="Get the workflow representation. Optionally exclude the workflow id from the response.")
    @APIResponses(value={@APIResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=WorkflowRepresentation.class))}), @APIResponse(responseCode="400", description="Bad Request")})
    public WorkflowRepresentation toRepresentation(@Parameter(description="Indicates whether the workflow id should be included in the representation or not - defaults to true") @QueryParam(value="includeId") Boolean includeId) {
        WorkflowRepresentation rep = this.provider.toRepresentation(this.workflow);
        if (Boolean.FALSE.equals(includeId)) {
            rep.setId(null);
        }
        return rep;
    }

    @POST
    @Path(value="activate/{type}/{resourceId}")
    @Tag(name="Workflows")
    @Operation(summary="Activate workflow for resource", description="Activate the workflow for the given resource type and identifier. Optionally schedule the first step using the notBefore parameter.")
    @APIResponses(value={@APIResponse(responseCode="204", description="No Content"), @APIResponse(responseCode="400", description="Bad Request")})
    public void activate(@Parameter(description="Resource type") @PathParam(value="type") ResourceType type, @Parameter(description="Resource identifier") @PathParam(value="resourceId") String resourceId, @Parameter(description="Optional value representing the time to schedule the first workflow step. The value is either an integer representing the seconds from now, an integer followed by 'ms' representing milliseconds from now, or an ISO-8601 date string.") @QueryParam(value="notBefore") String notBefore) {
        Object resource = this.provider.getResourceTypeSelector(type).resolveResource(resourceId);
        if (resource == null) {
            throw new BadRequestException("Resource with id " + resourceId + " not found");
        }
        if (notBefore != null) {
            this.workflow.setNotBefore(notBefore);
        }
        this.provider.activate(this.workflow, type, resourceId);
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="deactivate/{type}/{resourceId}")
    @Tag(name="Workflows")
    @Operation(summary="Deactivate workflow for resource", description="Deactivate the workflow for the given resource type and identifier.")
    @APIResponses(value={@APIResponse(responseCode="204", description="No Content"), @APIResponse(responseCode="400", description="Bad Request")})
    public void deactivate(@Parameter(description="Resource type") @PathParam(value="type") ResourceType type, @Parameter(description="Resource identifier") @PathParam(value="resourceId") String resourceId) {
        Object resource = this.provider.getResourceTypeSelector(type).resolveResource(resourceId);
        if (resource == null) {
            throw new BadRequestException("Resource with id " + resourceId + " not found");
        }
        this.provider.deactivate(this.workflow, resourceId);
    }
}

