/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow;

import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.workflow.DefaultWorkflowExecutionContext;
import org.keycloak.models.workflow.Workflow;
import org.keycloak.models.workflow.WorkflowEvent;
import org.keycloak.models.workflow.WorkflowInvalidStateException;
import org.keycloak.models.workflow.WorkflowStateProvider;
import org.keycloak.models.workflow.WorkflowStep;
import org.keycloak.models.workflow.WorkflowTransactionalTask;

final class ScheduleWorkflowTask
extends WorkflowTransactionalTask {
    private static final Logger log = Logger.getLogger(ScheduleWorkflowTask.class);
    private final DefaultWorkflowExecutionContext context;

    ScheduleWorkflowTask(DefaultWorkflowExecutionContext context) {
        super(context.getSession());
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(KeycloakSession session) {
        KeycloakContext context = session.getContext();
        RealmModel realm = context.getRealm();
        if (realm == null) {
            return;
        }
        DefaultWorkflowExecutionContext workflowContext = new DefaultWorkflowExecutionContext(session, this.context);
        Workflow workflow = workflowContext.getWorkflow();
        WorkflowEvent event = workflowContext.getEvent();
        WorkflowStep firstStep = (WorkflowStep)workflow.getSteps().findFirst().orElseThrow(() -> new WorkflowInvalidStateException("No steps found for workflow " + workflow.getName()));
        log.debugf("Scheduling first step '%s' of workflow '%s' for resource %s based on on event %s with notBefore %d", new Object[]{firstStep.getProviderId(), workflow.getName(), event.getResourceId(), event.getOperation(), workflow.getNotBefore()});
        String originalAfter = firstStep.getAfter();
        try {
            firstStep.setAfter(workflow.getNotBefore());
            WorkflowStateProvider stateProvider = (WorkflowStateProvider)session.getProvider(WorkflowStateProvider.class);
            stateProvider.scheduleStep(workflow, firstStep, event.getResourceId(), workflowContext.getExecutionId());
        }
        finally {
            firstStep.setAfter(originalAfter);
        }
    }

    public String toString() {
        WorkflowEvent event = this.context.getEvent();
        return "eventType=" + String.valueOf(event.getOperation()) + ",resourceType=" + String.valueOf(event.getResourceType()) + ",resourceId=" + event.getResourceId();
    }
}

