/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.marshal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.exporter.internal.marshal.CodedOutputStream;
import io.opentelemetry.exporter.internal.marshal.MarshalerContext;
import io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshaler;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshaler2;
import io.opentelemetry.exporter.internal.marshal.UnsafeString;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.resources.Resource;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class StatelessMarshalerUtil {
    private static final MarshalerContext.Key GROUPER_KEY = MarshalerContext.key();
    private static final MarshalerContext.Key ATTRIBUTES_SIZE_CALCULATOR_KEY = MarshalerContext.key();
    private static final int MAX_INNER_LOOP_SIZE = 2040;
    private static final long MOST_SIGNIFICANT_BIT_MASK = -9187201950435737472L;

    public static <T> Map<Resource, Map<InstrumentationScopeInfo, List<T>>> groupByResourceAndScope(Collection<T> dataList, Function<T, Resource> getResource, Function<T, InstrumentationScopeInfo> getInstrumentationScope, MarshalerContext context) {
        Map result = context.getIdentityMap();
        Grouper grouper = context.getInstance(GROUPER_KEY, () -> new Grouper());
        grouper.initialize(result, getResource, getInstrumentationScope, context);
        dataList.forEach(grouper);
        return result;
    }

    public static int sizeStringWithContext(ProtoFieldInfo field, @Nullable String value, MarshalerContext context) {
        if (value == null || value.isEmpty()) {
            return StatelessMarshalerUtil.sizeBytes(field, 0);
        }
        if (context.marshalStringNoAllocation()) {
            int utf8Size = StatelessMarshalerUtil.getUtf8Size(value, context);
            context.addSize(utf8Size);
            return StatelessMarshalerUtil.sizeBytes(field, utf8Size);
        }
        byte[] valueUtf8 = MarshalerUtil.toBytes(value);
        context.addData(valueUtf8);
        return StatelessMarshalerUtil.sizeBytes(field, valueUtf8.length);
    }

    private static int sizeBytes(ProtoFieldInfo field, int length) {
        if (length == 0) {
            return 0;
        }
        return field.getTagSize() + CodedOutputStream.computeLengthDelimitedFieldSize(length);
    }

    public static <T> int sizeRepeatedMessageWithContext(ProtoFieldInfo field, List<? extends T> messages, StatelessMarshaler<T> marshaler, MarshalerContext context) {
        if (messages.isEmpty()) {
            return 0;
        }
        int size = 0;
        int fieldTagSize = field.getTagSize();
        for (int i = 0; i < messages.size(); ++i) {
            T message = messages.get(i);
            int sizeIndex = context.addSize();
            int fieldSize = marshaler.getBinarySerializedSize(message, context);
            context.setSize(sizeIndex, fieldSize);
            size += fieldTagSize + CodedOutputStream.computeUInt32SizeNoTag(fieldSize) + fieldSize;
        }
        return size;
    }

    public static <T> int sizeRepeatedMessageWithContext(ProtoFieldInfo field, Collection<? extends T> messages, StatelessMarshaler<T> marshaler, MarshalerContext context, MarshalerContext.Key key) {
        if (messages instanceof List) {
            return StatelessMarshalerUtil.sizeRepeatedMessageWithContext(field, (List)messages, marshaler, context);
        }
        if (messages.isEmpty()) {
            return 0;
        }
        RepeatedElementSizeCalculator sizeCalculator = context.getInstance(key, () -> new RepeatedElementSizeCalculator());
        sizeCalculator.initialize(field, marshaler, context);
        messages.forEach(sizeCalculator);
        return sizeCalculator.size;
    }

    public static <K, V> int sizeRepeatedMessageWithContext(ProtoFieldInfo field, Map<K, V> messages, StatelessMarshaler2<K, V> marshaler, MarshalerContext context, MarshalerContext.Key key) {
        if (messages.isEmpty()) {
            return 0;
        }
        RepeatedElementPairSizeCalculator sizeCalculator = context.getInstance(key, () -> new RepeatedElementPairSizeCalculator());
        sizeCalculator.initialize(field, marshaler, context);
        messages.forEach(sizeCalculator);
        return sizeCalculator.size;
    }

    public static int sizeRepeatedMessageWithContext(ProtoFieldInfo field, Attributes attributes, StatelessMarshaler2<AttributeKey<?>, Object> marshaler, MarshalerContext context) {
        if (attributes.isEmpty()) {
            return 0;
        }
        RepeatedElementPairSizeCalculator sizeCalculator = context.getInstance(ATTRIBUTES_SIZE_CALCULATOR_KEY, () -> new RepeatedElementPairSizeCalculator());
        sizeCalculator.initialize(field, marshaler, context);
        attributes.forEach((BiConsumer)sizeCalculator);
        return sizeCalculator.size;
    }

    public static <T> int sizeMessageWithContext(ProtoFieldInfo field, T element, StatelessMarshaler<T> marshaler, MarshalerContext context) {
        int sizeIndex = context.addSize();
        int fieldSize = marshaler.getBinarySerializedSize(element, context);
        int size = field.getTagSize() + CodedOutputStream.computeUInt32SizeNoTag(fieldSize) + fieldSize;
        context.setSize(sizeIndex, fieldSize);
        return size;
    }

    public static <K, V> int sizeMessageWithContext(ProtoFieldInfo field, K key, V value, StatelessMarshaler2<K, V> marshaler, MarshalerContext context) {
        int sizeIndex = context.addSize();
        int fieldSize = marshaler.getBinarySerializedSize(key, value, context);
        int size = field.getTagSize() + CodedOutputStream.computeUInt32SizeNoTag(fieldSize) + fieldSize;
        context.setSize(sizeIndex, fieldSize);
        return size;
    }

    private static int getUtf8Size(String string, MarshalerContext context) {
        return StatelessMarshalerUtil.getUtf8Size(string, context.marshalStringUnsafe());
    }

    static int getUtf8Size(String string, boolean useUnsafe) {
        if (useUnsafe && UnsafeString.isAvailable() && UnsafeString.isLatin1(string)) {
            byte[] bytes = UnsafeString.getBytes(string);
            return string.length() + StatelessMarshalerUtil.countNegative(bytes);
        }
        return StatelessMarshalerUtil.encodedUtf8Length(string);
    }

    private static int countNegative(byte[] bytes) {
        int i;
        int count = 0;
        int offset = 0;
        for (i = 1; i <= bytes.length / 2040 + 1; ++i) {
            long tmp = 0L;
            int limit = Math.min(i * 2040, bytes.length & 0xFFFFFFF8);
            while (offset < limit) {
                long value = UnsafeString.getLong(bytes, offset);
                tmp += (value & 0x8080808080808080L) >>> 7;
                offset += 8;
            }
            if (tmp == 0L) continue;
            for (int j = 0; j < 8; ++j) {
                count += (int)(tmp & 0xFFL);
                tmp >>>= 8;
            }
        }
        for (i = offset; i < bytes.length; ++i) {
            count += bytes[i] >>> 31;
        }
        return count;
    }

    private static int encodedUtf8Length(String string) {
        int i;
        int utf16Length;
        int utf8Length = utf16Length = string.length();
        for (i = 0; i < utf16Length && string.charAt(i) < '\u0080'; ++i) {
        }
        while (i < utf16Length) {
            char c = string.charAt(i);
            if (c < '\u0800') {
                utf8Length += 127 - c >>> 31;
            } else {
                utf8Length += StatelessMarshalerUtil.encodedUtf8LengthGeneral(string, i);
                break;
            }
            ++i;
        }
        if (utf8Length < utf16Length) {
            throw new IllegalArgumentException("UTF-8 length does not fit in int: " + ((long)utf8Length + 0x100000000L));
        }
        return utf8Length;
    }

    private static int encodedUtf8LengthGeneral(String string, int start) {
        int utf16Length = string.length();
        int utf8Length = 0;
        for (int i = start; i < utf16Length; ++i) {
            char c = string.charAt(i);
            if (c < '\u0800') {
                utf8Length += 127 - c >>> 31;
                continue;
            }
            utf8Length += 2;
            if (!Character.isSurrogate(c)) continue;
            if (Character.codePointAt(string, i) != c) {
                ++i;
                continue;
            }
            utf8Length -= 2;
        }
        return utf8Length;
    }

    static void writeUtf8(CodedOutputStream output, String string, int utf8Length, MarshalerContext context) throws IOException {
        StatelessMarshalerUtil.writeUtf8(output, string, utf8Length, context.marshalStringUnsafe());
    }

    static void writeUtf8(CodedOutputStream output, String string, int utf8Length, boolean useUnsafe) throws IOException {
        if (useUnsafe && UnsafeString.isAvailable() && string.length() == utf8Length && UnsafeString.isLatin1(string)) {
            byte[] bytes = UnsafeString.getBytes(string);
            output.write(bytes, 0, bytes.length);
        } else {
            StatelessMarshalerUtil.encodeUtf8(output, string);
        }
    }

    private static void encodeUtf8(CodedOutputStream output, String in) throws IOException {
        char c;
        int i;
        int utf16Length = in.length();
        for (i = 0; i < utf16Length && (c = in.charAt(i)) < '\u0080'; ++i) {
            output.write((byte)c);
        }
        if (i == utf16Length) {
            return;
        }
        while (i < utf16Length) {
            c = in.charAt(i);
            if (c < '\u0080') {
                output.write((byte)c);
            } else if (c < '\u0800') {
                output.write((byte)(0x3C0 | c >>> 6));
                output.write((byte)(0x80 | 0x3F & c));
            } else if (!Character.isSurrogate(c)) {
                output.write((byte)(0x1E0 | c >>> 12));
                output.write((byte)(0x80 | 0x3F & c >>> 6));
                output.write((byte)(0x80 | 0x3F & c));
            } else {
                int codePoint = Character.codePointAt(in, i);
                if (codePoint != c) {
                    output.write((byte)(0xF0 | codePoint >>> 18));
                    output.write((byte)(0x80 | 0x3F & codePoint >>> 12));
                    output.write((byte)(0x80 | 0x3F & codePoint >>> 6));
                    output.write((byte)(0x80 | 0x3F & codePoint));
                    ++i;
                } else {
                    output.write((byte)63);
                }
            }
            ++i;
        }
    }

    private StatelessMarshalerUtil() {
    }

    private static class Grouper<T>
    implements Consumer<T> {
        private Map<Resource, Map<InstrumentationScopeInfo, List<T>>> result;
        private Function<T, Resource> getResource;
        private Function<T, InstrumentationScopeInfo> getInstrumentationScope;
        private MarshalerContext context;

        private Grouper() {
        }

        void initialize(Map<Resource, Map<InstrumentationScopeInfo, List<T>>> result, Function<T, Resource> getResource, Function<T, InstrumentationScopeInfo> getInstrumentationScope, MarshalerContext context) {
            this.result = result;
            this.getResource = getResource;
            this.getInstrumentationScope = getInstrumentationScope;
            this.context = context;
        }

        @Override
        public void accept(T data) {
            InstrumentationScopeInfo instrumentationScopeInfo;
            List<Object> elementList;
            Resource resource = this.getResource.apply(data);
            Map<Object, List<Object>> scopeInfoListMap = this.result.get(resource);
            if (scopeInfoListMap == null) {
                scopeInfoListMap = this.context.getIdentityMap();
                this.result.put(resource, scopeInfoListMap);
            }
            if ((elementList = scopeInfoListMap.get(instrumentationScopeInfo = this.getInstrumentationScope.apply(data))) == null) {
                elementList = this.context.getList();
                scopeInfoListMap.put((InstrumentationScopeInfo)((Object)instrumentationScopeInfo), (List<T>)elementList);
            }
            elementList.add(data);
        }
    }

    private static class RepeatedElementSizeCalculator<T>
    implements Consumer<T> {
        private int size;
        private int fieldTagSize;
        private StatelessMarshaler<T> marshaler;
        private MarshalerContext context;

        private RepeatedElementSizeCalculator() {
        }

        void initialize(ProtoFieldInfo field, StatelessMarshaler<T> marshaler, MarshalerContext context) {
            this.size = 0;
            this.fieldTagSize = field.getTagSize();
            this.marshaler = marshaler;
            this.context = context;
        }

        @Override
        public void accept(T element) {
            int sizeIndex = this.context.addSize();
            int fieldSize = this.marshaler.getBinarySerializedSize(element, this.context);
            this.context.setSize(sizeIndex, fieldSize);
            this.size += this.fieldTagSize + CodedOutputStream.computeUInt32SizeNoTag(fieldSize) + fieldSize;
        }
    }

    private static class RepeatedElementPairSizeCalculator<K, V>
    implements BiConsumer<K, V> {
        private int size;
        private int fieldTagSize;
        private StatelessMarshaler2<K, V> marshaler;
        private MarshalerContext context;

        private RepeatedElementPairSizeCalculator() {
        }

        void initialize(ProtoFieldInfo field, StatelessMarshaler2<K, V> marshaler, MarshalerContext context) {
            this.size = 0;
            this.fieldTagSize = field.getTagSize();
            this.marshaler = marshaler;
            this.context = context;
        }

        @Override
        public void accept(K key, V value) {
            int sizeIndex = this.context.addSize();
            int fieldSize = this.marshaler.getBinarySerializedSize(key, value, this.context);
            this.context.setSize(sizeIndex, fieldSize);
            this.size += this.fieldTagSize + CodedOutputStream.computeUInt32SizeNoTag(fieldSize) + fieldSize;
        }
    }
}

