/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.insert;

import jakarta.persistence.Tuple;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Subquery;
import jakarta.persistence.metamodel.EntityType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.Incubating;
import org.hibernate.query.criteria.JpaConflictClause;
import org.hibernate.query.criteria.JpaCriteriaInsertSelect;
import org.hibernate.query.criteria.JpaPredicate;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmQuerySource;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.cte.SqmCteStatement;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.insert.AbstractSqmInsertStatement;
import org.hibernate.query.sqm.tree.insert.SqmConflictClause;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;

@Incubating
public class SqmInsertSelectStatement<T>
extends AbstractSqmInsertStatement<T>
implements JpaCriteriaInsertSelect<T> {
    private SqmQueryPart<?> selectQueryPart;

    public SqmInsertSelectStatement(SqmRoot<T> targetRoot, NodeBuilder nodeBuilder) {
        super(targetRoot, SqmQuerySource.HQL, nodeBuilder);
        this.selectQueryPart = new SqmQuerySpec(nodeBuilder);
    }

    public SqmInsertSelectStatement(Class<T> targetEntity, NodeBuilder nodeBuilder) {
        super(new SqmRoot(nodeBuilder.getDomainModel().entity(targetEntity), "_0", false, nodeBuilder), SqmQuerySource.CRITERIA, nodeBuilder);
        this.selectQueryPart = new SqmQuerySpec(nodeBuilder);
    }

    private SqmInsertSelectStatement(NodeBuilder builder, SqmQuerySource querySource, Set<SqmParameter<?>> parameters, Map<String, SqmCteStatement<?>> cteStatements, SqmRoot<T> target, List<SqmPath<?>> insertionTargetPaths, SqmConflictClause<T> conflictClause, SqmQueryPart<?> selectQueryPart) {
        super(builder, querySource, parameters, cteStatements, target, insertionTargetPaths, conflictClause);
        this.selectQueryPart = selectQueryPart;
    }

    @Override
    public SqmInsertSelectStatement<T> copy(SqmCopyContext context) {
        SqmInsertSelectStatement existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmInsertSelectStatement<T> sqmInsertSelectStatementCopy = new SqmInsertSelectStatement<T>(this.nodeBuilder(), context.getQuerySource() == null ? this.getQuerySource() : context.getQuerySource(), this.copyParameters(context), this.copyCteStatements(context), ((SqmRoot)this.getTarget()).copy(context), null, null, (SqmQueryPart<?>)this.selectQueryPart.copy(context));
        context.registerCopy(this, sqmInsertSelectStatementCopy);
        sqmInsertSelectStatementCopy.setInsertionTargetPaths(this.copyInsertionTargetPaths(context));
        if (this.getConflictClause() != null) {
            sqmInsertSelectStatementCopy.setConflictClause((SqmConflictClause<T>)((SqmConflictClause)this.getConflictClause()).copy(context));
        }
        return sqmInsertSelectStatementCopy;
    }

    @Override
    public void validate(@Nullable String hql) {
        List<SqmPath<?>> insertionTargetPaths = this.getInsertionTargetPaths();
        List<SqmSelectableNode<?>> selections = this.getSelectQueryPart().getFirstQuerySpec().getSelectClause().getSelectionItems();
        this.verifyInsertTypesMatch(insertionTargetPaths, selections);
        this.getSelectQueryPart().validateQueryStructureAndFetchOwners();
    }

    @Override
    public SqmInsertSelectStatement<T> select(CriteriaQuery<Tuple> criteriaQuery) {
        SqmSelectStatement selectStatement = (SqmSelectStatement)criteriaQuery;
        this.putAllCtes(selectStatement);
        this.setSelectQueryPart((SqmQueryPart<?>)selectStatement.getQueryPart());
        return this;
    }

    public SqmQueryPart<?> getSelectQueryPart() {
        return this.selectQueryPart;
    }

    public void setSelectQueryPart(SqmQueryPart<?> selectQueryPart) {
        this.selectQueryPart = selectQueryPart;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitInsertSelectStatement(this);
    }

    @Override
    public <U> Subquery<U> subquery(EntityType<U> type) {
        throw new UnsupportedOperationException("INSERT cannot be basis for subquery");
    }

    @Override
    public JpaPredicate getRestriction() {
        return null;
    }

    @Override
    public SqmInsertSelectStatement<T> setInsertionTargetPaths(Path<?> ... insertionTargetPaths) {
        super.setInsertionTargetPaths((Path[])insertionTargetPaths);
        return this;
    }

    @Override
    public SqmInsertSelectStatement<T> setInsertionTargetPaths(List<? extends Path<?>> insertionTargetPaths) {
        super.setInsertionTargetPaths((List)insertionTargetPaths);
        return this;
    }

    @Override
    public SqmInsertSelectStatement<T> onConflict(JpaConflictClause<T> conflictClause) {
        super.onConflict(conflictClause);
        return this;
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        super.appendHqlString(hql, context);
        hql.append(' ');
        this.selectQueryPart.appendHqlString(hql, context);
        JpaConflictClause conflictClause = this.getConflictClause();
        if (conflictClause != null) {
            ((SqmConflictClause)conflictClause).appendHqlString(hql, context);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof SqmInsertSelectStatement)) {
            return false;
        }
        SqmInsertSelectStatement that = (SqmInsertSelectStatement)object;
        return Objects.equals(this.selectQueryPart, that.selectQueryPart) && Objects.equals(this.getTarget(), that.getTarget()) && Objects.equals(this.getInsertionTargetPaths(), that.getInsertionTargetPaths()) && Objects.equals(this.getConflictClause(), that.getConflictClause()) && Objects.equals(this.getCteStatements(), that.getCteStatements());
    }

    public int hashCode() {
        return Objects.hash(this.selectQueryPart, this.getTarget(), this.getInsertionTargetPaths(), this.getConflictClause(), this.getCteStatements());
    }
}

