/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.infinispan.module.factory;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import java.util.Objects;
import org.infinispan.telemetry.InfinispanSpan;
import org.infinispan.telemetry.SafeAutoClosable;

public class OpenTelemetrySpan<T>
implements InfinispanSpan<T> {
    private final Span span;

    public OpenTelemetrySpan(Span span) {
        this.span = Objects.requireNonNull(span);
    }

    public SafeAutoClosable makeCurrent() {
        Scope scope = this.span.makeCurrent();
        return () -> ((Scope)scope).close();
    }

    public void complete() {
        this.span.end();
    }

    public void recordException(Throwable throwable) {
        this.span.setStatus(StatusCode.ERROR, "Error during the cache request processing");
        this.span.recordException(throwable);
    }
}

