/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations.userprofile.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class UPAttributeRequired
implements Cloneable {
    private Set<String> roles;
    private Set<String> scopes;

    public UPAttributeRequired() {
    }

    public UPAttributeRequired(Set<String> roles, Set<String> scopes) {
        this.roles = roles;
        this.scopes = scopes;
    }

    @JsonIgnore
    public boolean isAlways() {
        return !(this.roles != null && !this.roles.isEmpty() || this.scopes != null && !this.scopes.isEmpty());
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public Set<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(Set<String> scopes) {
        this.scopes = scopes;
    }

    public String toString() {
        return "UPAttributeRequired [isAlways=" + this.isAlways() + ", roles=" + this.roles + ", scopes=" + this.scopes + "]";
    }

    protected UPAttributeRequired clone() {
        HashSet<String> scopes = this.scopes == null ? null : new HashSet<String>(this.scopes);
        HashSet<String> roles = this.roles == null ? null : new HashSet<String>(this.roles);
        return new UPAttributeRequired(roles, scopes);
    }

    public int hashCode() {
        return Objects.hash(this.roles, this.scopes);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UPAttributeRequired other = (UPAttributeRequired)obj;
        return Objects.equals(this.roles, other.roles) && Objects.equals(this.scopes, other.scopes);
    }
}

