/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social.instagram;

import org.keycloak.Config;
import org.keycloak.broker.oidc.OAuth2IdentityProviderConfig;
import org.keycloak.broker.provider.AbstractIdentityProviderFactory;
import org.keycloak.broker.social.SocialIdentityProviderFactory;
import org.keycloak.common.Profile;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.social.instagram.InstagramIdentityProvider;

public class InstagramIdentityProviderFactory
extends AbstractIdentityProviderFactory<InstagramIdentityProvider>
implements SocialIdentityProviderFactory<InstagramIdentityProvider>,
EnvironmentDependentProviderFactory {
    public static final String PROVIDER_ID = "instagram";

    public String getName() {
        return "Instagram";
    }

    public InstagramIdentityProvider create(KeycloakSession session, IdentityProviderModel model) {
        return new InstagramIdentityProvider(session, new OAuth2IdentityProviderConfig(model));
    }

    public OAuth2IdentityProviderConfig createConfig() {
        return new OAuth2IdentityProviderConfig();
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public boolean isSupported(Config.Scope config) {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.INSTAGRAM_BROKER);
    }
}

