/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.origin;

import java.time.Duration;
import java.util.Properties;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.caching.internal.origin.OriginReader;
import org.gradle.caching.internal.origin.OriginWriter;
import org.gradle.internal.hash.HashCode;

public class OriginMetadataFactory {
    private static final String BUILD_INVOCATION_ID_KEY = "buildInvocationId";
    private static final String TYPE_KEY = "type";
    private static final String IDENTITY_KEY = "identity";
    private static final String CACHE_KEY = "buildCacheKey";
    private static final String CREATION_TIME_KEY = "creationTime";
    private static final String EXECUTION_TIME_KEY = "executionTime";
    private final String currentBuildInvocationId;
    private final PropertiesConfigurator additionalProperties;

    public OriginMetadataFactory(String currentBuildInvocationId, PropertiesConfigurator additionalProperties) {
        this.additionalProperties = additionalProperties;
        this.currentBuildInvocationId = currentBuildInvocationId;
    }

    public OriginWriter createWriter(String identity, Class<?> workType, HashCode buildCacheKey, Duration elapsedTime) {
        return outputStream -> {
            Properties properties = new Properties();
            properties.setProperty(BUILD_INVOCATION_ID_KEY, this.currentBuildInvocationId);
            properties.setProperty(TYPE_KEY, workType.getCanonicalName());
            properties.setProperty(IDENTITY_KEY, identity);
            properties.setProperty(CACHE_KEY, buildCacheKey.toString());
            properties.setProperty(CREATION_TIME_KEY, Long.toString(System.currentTimeMillis()));
            properties.setProperty(EXECUTION_TIME_KEY, Long.toString(elapsedTime.toMillis()));
            this.additionalProperties.configure(properties);
            properties.store(outputStream, "Generated origin information");
        };
    }

    public OriginReader createReader() {
        return inputStream -> {
            Properties properties = new Properties();
            properties.load(inputStream);
            String originBuildInvocationId = properties.getProperty(BUILD_INVOCATION_ID_KEY);
            String originBuildCacheKey = properties.getProperty(CACHE_KEY);
            String executionTimeAsString = properties.getProperty(EXECUTION_TIME_KEY);
            if (originBuildInvocationId == null || executionTimeAsString == null) {
                throw new IllegalStateException("Cached result format error, corrupted origin metadata");
            }
            Duration originalExecutionTime = Duration.ofMillis(Long.parseLong(executionTimeAsString));
            return new OriginMetadata(originBuildInvocationId, HashCode.fromString((String)originBuildCacheKey), originalExecutionTime);
        };
    }

    public static interface PropertiesConfigurator {
        public void configure(Properties var1);
    }
}

