/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.constraint.dialog;

import docking.widgets.table.RowObjectFilterModel;
import docking.widgets.table.columnfilter.ColumnBasedTableFilter;
import docking.widgets.table.columnfilter.ColumnConstraintSet;
import docking.widgets.table.columnfilter.LogicOperation;
import docking.widgets.table.constraint.dialog.ColumnFilterData;
import docking.widgets.table.constraint.dialog.ColumnFilterDialogModel;
import docking.widgets.table.constraint.dialog.DialogFilterCondition;
import docking.widgets.table.constraint.dialog.DialogFilterConditionSet;
import docking.widgets.table.constrainteditor.ColumnConstraintEditor;
import java.util.ArrayList;
import java.util.List;

public class DialogFilterRow {
    private ColumnFilterDialogModel<?> dialogModel;
    private DialogFilterConditionSet<?> columnConditionSet;
    private LogicOperation logicOperation;

    public DialogFilterRow(ColumnFilterDialogModel<?> dialogModel, LogicOperation logicOperation) {
        this.dialogModel = dialogModel;
        this.logicOperation = logicOperation;
        this.doSetColumnData(this.getAllColumnData().get(0));
    }

    public <T> DialogFilterRow(ColumnFilterDialogModel<?> dialogModel, ColumnConstraintSet<?, T> columnFilter) {
        this.dialogModel = dialogModel;
        this.columnConditionSet = new DialogFilterConditionSet<T>(this, columnFilter);
        this.logicOperation = columnFilter.getLogicOperation();
    }

    public void setColumnData(ColumnFilterData<?> columnData) {
        this.doSetColumnData(columnData);
        this.dialogModel.dialogFilterRowChanged(this);
    }

    public LogicOperation getLogicOperation() {
        return this.logicOperation;
    }

    private <T> void doSetColumnData(ColumnFilterData<T> columnData) {
        this.columnConditionSet = new DialogFilterConditionSet<T>(this, columnData);
    }

    public List<ColumnFilterData<?>> getAllColumnData() {
        return this.dialogModel.getAllColumnFilterData();
    }

    public ColumnFilterData<?> getColumnFilterData() {
        return this.columnConditionSet.getColumnFilterData();
    }

    public boolean hasValidFilterValue() {
        return this.columnConditionSet.hasValidFilterValue();
    }

    public List<DialogFilterCondition<?>> getFilterConditions() {
        return new ArrayList(this.columnConditionSet.getFilterConditions());
    }

    public DialogFilterCondition<?> addFilterCondition() {
        return this.columnConditionSet.addFilterCondition();
    }

    void addToTableFilter(ColumnBasedTableFilter<?> tableColumnFilter) {
        this.columnConditionSet.addToTableFilter(tableColumnFilter, this.logicOperation);
    }

    Object getDataSource() {
        return this.dialogModel.getDataSource();
    }

    void editorValueChanged(ColumnConstraintEditor<?> editor) {
        this.dialogModel.editorValueChanged(editor);
    }

    void conditionSetChanged(DialogFilterConditionSet<?> conditionSet) {
        this.dialogModel.dialogFilterRowChanged(this);
    }

    RowObjectFilterModel<?> getTableModel() {
        return this.dialogModel.getTableModel();
    }

    void delete() {
        this.dialogModel.deleteFilterRow(this);
    }

    public String toString() {
        return "{\n\toperation: " + String.valueOf((Object)this.logicOperation) + ",\n\tconditions: " + String.valueOf(this.columnConditionSet) + "\n}";
    }
}

