/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.plugin.core.reloc.ElfRelocationFixupHandler;
import ghidra.app.util.bin.format.elf.relocation.X86_32_ElfRelocationType;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.util.CodeUnitInsertionException;

public class Elfx86_32bitRelocationFixupHandler
extends ElfRelocationFixupHandler {
    public Elfx86_32bitRelocationFixupHandler() {
        super(X86_32_ElfRelocationType.class);
    }

    public boolean processRelocation(Program program, Relocation relocation, Address oldImageBase, Address newImageBase) throws MemoryAccessException, CodeUnitInsertionException {
        if (relocation.getStatus() != Relocation.Status.APPLIED) {
            return false;
        }
        X86_32_ElfRelocationType type = (X86_32_ElfRelocationType)this.getRelocationType(relocation.getType());
        if (type == null) {
            return false;
        }
        switch (type) {
            case R_386_32: 
            case R_386_PC32: 
            case R_386_GOT32: 
            case R_386_PLT32: 
            case R_386_COPY: 
            case R_386_GLOB_DAT: 
            case R_386_JMP_SLOT: 
            case R_386_RELATIVE: 
            case R_386_GOTOFF: 
            case R_386_GOTPC: {
                return this.process32BitRelocation(program, relocation, oldImageBase, newImageBase);
            }
        }
        return false;
    }

    public boolean handlesProgram(Program program) {
        if (!"Executable and Linking Format (ELF)".equals(program.getExecutableFormat())) {
            return false;
        }
        Language language = program.getLanguage();
        if (language.getLanguageDescription().getSize() != 32) {
            return false;
        }
        Processor processor = language.getProcessor();
        return processor.equals((Object)Processor.findOrPossiblyCreateProcessor((String)"x86"));
    }
}

