/*
 * Decompiled with CFR 0.152.
 */
package ghidra.server.security;

import ghidra.framework.remote.GhidraPrincipal;
import ghidra.server.UserManager;
import ghidra.server.security.AuthenticationModule;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.security.URIParameter;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class JAASAuthenticationModule
implements AuthenticationModule {
    private boolean allowUserToSpecifyName;
    private String loginContextName;
    private File jaasConfigFile;

    public JAASAuthenticationModule(String loginContextName, boolean allowUserToSpecifyName, File jaasConfigFile) throws IllegalArgumentException {
        this.loginContextName = loginContextName;
        this.allowUserToSpecifyName = allowUserToSpecifyName;
        this.jaasConfigFile = jaasConfigFile;
        if (jaasConfigFile == null) {
            throw new IllegalArgumentException("JAAS config file not specified");
        }
        if (!jaasConfigFile.exists() || !jaasConfigFile.isFile()) {
            throw new IllegalArgumentException("JAAS config file does not exist or is not file: " + jaasConfigFile.getAbsolutePath());
        }
        this.getJAASConfig();
    }

    private Configuration getJAASConfig() {
        try {
            URI jaasConfigFileUri = this.jaasConfigFile.toURI();
            Configuration cfg = Configuration.getInstance("JavaLoginConfig", new URIParameter(jaasConfigFileUri));
            AppConfigurationEntry[] authEntry = cfg.getAppConfigurationEntry(this.loginContextName);
            if (authEntry == null) {
                throw new IllegalArgumentException("Missing '" + this.loginContextName + "' entry in JAAS config file: " + String.valueOf(this.jaasConfigFile));
            }
            return cfg;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("JAAS config error", e);
        }
    }

    @Override
    public String authenticate(UserManager userMgr, Subject subject, Callback[] callbacks) throws LoginException {
        GhidraPrincipal principal = GhidraPrincipal.getGhidraPrincipal((Subject)subject);
        AtomicReference loginName = new AtomicReference();
        try {
            Configuration jaasCfg = this.getJAASConfig();
            LoginContext loginCtx = new LoginContext(this.loginContextName, null, loginModuleCallbacks -> loginName.set(this.copyCallbackValues(callbacks, loginModuleCallbacks, principal)), jaasCfg);
            loginCtx.login();
        }
        catch (IllegalArgumentException e) {
            throw new LoginException("JAAS configuration error: " + e.getMessage());
        }
        catch (LoginException e) {
            if (e instanceof FailedLoginException) {
                throw e;
            }
            throw new FailedLoginException(e.getMessage());
        }
        finally {
            PasswordCallback srcPcb = AuthenticationModule.getFirstCallbackOfType(PasswordCallback.class, callbacks);
            if (srcPcb != null) {
                srcPcb.clearPassword();
            }
        }
        String loginNameResult = (String)loginName.get();
        return loginNameResult != null ? loginNameResult : principal.getName();
    }

    @Override
    public Callback[] getAuthenticationCallbacks() {
        return AuthenticationModule.createSimpleNamePasswordCallbacks(this.allowUserToSpecifyName);
    }

    @Override
    public boolean anonymousCallbacksAllowed() {
        return false;
    }

    @Override
    public boolean isNameCallbackAllowed() {
        return this.allowUserToSpecifyName;
    }

    private String copyCallbackValues(Callback[] srcInstances, Callback[] destInstances, GhidraPrincipal principal) throws IOException {
        PasswordCallback destPcb;
        PasswordCallback srcPcb = AuthenticationModule.getFirstCallbackOfType(PasswordCallback.class, srcInstances);
        NameCallback srcNcb = AuthenticationModule.getFirstCallbackOfType(NameCallback.class, srcInstances);
        String userName = null;
        NameCallback destNcb = AuthenticationModule.getFirstCallbackOfType(NameCallback.class, destInstances);
        if (destNcb != null) {
            userName = this.allowUserToSpecifyName && srcNcb != null ? srcNcb.getName() : principal.getName();
            destNcb.setName(userName);
        }
        if ((destPcb = AuthenticationModule.getFirstCallbackOfType(PasswordCallback.class, destInstances)) != null) {
            if (srcPcb == null) {
                throw new IOException("Missing password callback value");
            }
            destPcb.setPassword(srcPcb.getPassword());
        }
        return userName;
    }
}

