/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.transform;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Arrays;
import java.util.Optional;
import org.jungrapht.visualization.PropertyLoader;
import org.jungrapht.visualization.VisualizationServer;
import org.jungrapht.visualization.VisualizationViewer;
import org.jungrapht.visualization.control.GraphElementAccessor;
import org.jungrapht.visualization.control.LensGraphMouse;
import org.jungrapht.visualization.control.LensTransformSupport;
import org.jungrapht.visualization.transform.LensSupport;
import org.jungrapht.visualization.transform.LensTransformer;
import org.jungrapht.visualization.util.ItemSupport;

public abstract class AbstractLensSupport<V, E, M extends LensGraphMouse>
extends ItemSupport
implements LensSupport<M> {
    private static final String LENS_STROKE_WIDTH = "jungrapht.lensStrokeWidth";
    protected VisualizationViewer<V, E> vv;
    protected VisualizationViewer.GraphMouse graphMouse;
    protected LensTransformer lensTransformer;
    protected M lensGraphMouse;
    protected LensPaintable lensPaintable;
    protected LensControls lensControls;
    protected String defaultToolTipText;
    boolean active;
    Runnable manager;
    protected GraphElementAccessor<V, E> pickSupport;
    protected boolean useGradient;
    protected static final String instructions = "<html><center>Mouse-Drag the Lens center to move it<p>Mouse-Drag the Lens edge or handles to resize it<p>MouseWheel inside lens changes magnification</center></html>";

    protected AbstractLensSupport(Builder<V, E, M, ?, ?> builder) {
        this.vv = builder.vv;
        this.lensGraphMouse = builder.lensGraphMouse;
        this.defaultToolTipText = Optional.ofNullable(builder.defaultToolTipText).orElse(this.vv.getToolTipText());
        this.graphMouse = Optional.ofNullable(builder.graphMouse).orElse(this.vv.getGraphMouse());
        this.lensGraphMouse = builder.lensGraphMouse;
        this.lensGraphMouse.setKillSwitch(Optional.ofNullable(builder.killSwitch).orElse(this::deactivate));
        this.lensTransformer = builder.lensTransformer;
        this.pickSupport = Optional.ofNullable(builder.pickSupport).orElse(this.vv.getPickSupport());
        this.useGradient = builder.useGradient;
        this.addItemListener(builder.itemListener);
    }

    public AbstractLensSupport(VisualizationViewer<V, E> vv, M lensGraphMouse) {
        this.vv = vv;
        this.graphMouse = vv.getGraphMouse();
        this.defaultToolTipText = vv.getToolTipText();
        this.lensGraphMouse = lensGraphMouse;
        this.lensGraphMouse.setKillSwitch(this::deactivate);
    }

    @Override
    public void setManager(Runnable manager) {
        this.manager = manager;
    }

    public boolean allowed() {
        return !(this.vv.getTransformSupport() instanceof LensTransformSupport);
    }

    @Override
    public void activate(boolean state) {
        this.active = state;
        if (state) {
            this.activate();
        } else {
            this.deactivate();
        }
    }

    @Override
    public void activate() {
        this.graphMouse = this.vv.getGraphMouse();
        if (this.listenerList.getListenerCount() > 0) {
            this.fireItemStateChanged(new ItemEvent(this, 701, this, 1));
        }
    }

    @Override
    public void deactivate() {
        this.vv.setGraphMouse(this.graphMouse);
        if (this.listenerList.getListenerCount() > 0) {
            this.fireItemStateChanged(new ItemEvent(this, 701, this, 2));
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public LensTransformer getLensTransformer() {
        return this.lensTransformer;
    }

    @Override
    public M getGraphMouse() {
        return this.lensGraphMouse;
    }

    private static Shape[] getRectangularLensHandles(Rectangle2D lensShape) {
        float handlePercentage = 0.01f * Float.parseFloat(System.getProperty("jungrapht.lensHandlePercentage", "3.f"));
        double size = Math.max(lensShape.getWidth(), lensShape.getHeight()) * (double)handlePercentage;
        Shape[] handles = new Shape[]{AbstractLensSupport.diamondShape(new Rectangle2D.Double(lensShape.getCenterX() - size / 2.0, lensShape.getMinY() - size / 2.0, size, size)), AbstractLensSupport.diamondShape(new Rectangle2D.Double(lensShape.getMaxX() - size / 2.0, lensShape.getCenterY() - size / 2.0, size, size)), AbstractLensSupport.diamondShape(new Rectangle2D.Double(lensShape.getCenterX() - size / 2.0, lensShape.getMaxY() - size / 2.0, size, size)), AbstractLensSupport.diamondShape(new Rectangle2D.Double(lensShape.getMinX() - size / 2.0, lensShape.getCenterY() - size / 2.0, size, size))};
        return handles;
    }

    private static Shape diamondShape(Rectangle2D bounds) {
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(bounds.getMinX(), bounds.getCenterY());
        ((Path2D)path).lineTo(bounds.getCenterX(), bounds.getMinY());
        ((Path2D)path).lineTo(bounds.getMaxX(), bounds.getCenterY());
        ((Path2D)path).lineTo(bounds.getCenterX(), bounds.getMaxY());
        path.closePath();
        return path;
    }

    public LensPaintable getLensPaintable() {
        return this.lensPaintable;
    }

    public void setLensPaintable(LensPaintable lensPaintable) {
        this.lensPaintable = lensPaintable;
    }

    public LensControls getLensControls() {
        return this.lensControls;
    }

    public void setLensControls(LensControls lensControls) {
        this.lensControls = lensControls;
    }

    static {
        PropertyLoader.load();
    }

    public static abstract class Builder<V, E, M extends LensGraphMouse, T extends AbstractLensSupport<V, E, M>, B extends Builder<V, E, M, T, B>>
    implements LensSupport.Builder<M, B> {
        protected VisualizationViewer<V, E> vv;
        protected VisualizationViewer.GraphMouse graphMouse;
        protected M lensGraphMouse;
        protected String defaultToolTipText;
        protected Runnable killSwitch;
        protected LensTransformer lensTransformer;
        protected GraphElementAccessor<V, E> pickSupport;
        protected boolean useGradient;
        protected ItemListener itemListener;

        public B self() {
            return (B)this;
        }

        protected Builder(VisualizationViewer<V, E> vv) {
            this.vv = vv;
        }

        public B graphMouse(VisualizationViewer.GraphMouse graphMouse) {
            this.graphMouse = graphMouse;
            return this.self();
        }

        public B lensGraphMouse(M lensGraphMouse) {
            this.lensGraphMouse = lensGraphMouse;
            return this.self();
        }

        public B defaultToolTipText(String defaultToolTipText) {
            this.defaultToolTipText = defaultToolTipText;
            return this.self();
        }

        public B killSwitch(Runnable killSwitch) {
            this.killSwitch = killSwitch;
            return this.self();
        }

        public B lensTransformer(LensTransformer lensTransformer) {
            this.lensTransformer = lensTransformer;
            return this.self();
        }

        public B pickSupport(GraphElementAccessor<V, E> pickSupport) {
            this.pickSupport = pickSupport;
            return this.self();
        }

        public B useGradient(boolean useGradient) {
            this.useGradient = useGradient;
            return this.self();
        }

        public B itemListener(ItemListener itemListener) {
            this.itemListener = itemListener;
            return this.self();
        }

        public abstract T build();
    }

    public static class LensPaintable
    implements VisualizationServer.Paintable {
        RectangularShape lensShape;
        Paint paint = Color.getColor("jungrapht.lensColor", Color.decode("0xFAFAFA"));
        float[] dist;
        Color[] colors;
        boolean useGradient;

        public LensPaintable(LensTransformer lensTransformer, boolean useGradient) {
            this.lensShape = lensTransformer.getLens().getLensShape();
            this.useGradient = useGradient;
            if (useGradient) {
                Color darker = ((Color)this.paint).darker();
                this.colors = new Color[]{new Color(darker.getRed(), darker.getGreen(), darker.getBlue(), 0), new Color(darker.getRed(), darker.getGreen(), darker.getBlue(), 255)};
                this.dist = new float[]{0.0f, 1.0f};
            }
        }

        public LensPaintable(LensTransformer lensTransformer) {
            this(lensTransformer, false);
        }

        public Paint getPaint() {
            return this.paint;
        }

        public void setPaint(Paint paint) {
            this.paint = paint;
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            Paint oldPaint = g2d.getPaint();
            if (this.useGradient) {
                RadialGradientPaint gradientPaint = new RadialGradientPaint(new Point2D.Double(this.lensShape.getCenterX(), this.lensShape.getCenterY()), (float)this.lensShape.getWidth(), this.dist, this.colors);
                g2d.setPaint(gradientPaint);
            } else {
                g2d.setPaint(this.paint);
            }
            g2d.fill(this.lensShape);
            g2d.setPaint(oldPaint);
        }

        @Override
        public boolean useTransform() {
            return true;
        }
    }

    public static class LensControls
    implements VisualizationServer.Paintable {
        RectangularShape lensShape;
        Paint lensControlsDrawColor = Color.getColor("jungrapht.lensControlsColor", Color.gray);
        Paint lensControlsFillColor = Color.getColor("jungrapht.lensColor", Color.decode("0xFAFAFA"));
        float lensStrokeWidth = Float.parseFloat(System.getProperty("jungrapht.lensStrokeWidth", "2.0f"));

        public LensControls(LensTransformer lensTransformer) {
            this.lensShape = lensTransformer.getLens().getLensShape();
        }

        public Paint getPaint() {
            return this.lensControlsDrawColor;
        }

        public void setPaint(Paint paint) {
            this.lensControlsDrawColor = paint;
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            RenderingHints savedRenderingHints = g2d.getRenderingHints();
            RenderingHints renderingHints = (RenderingHints)savedRenderingHints.clone();
            renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHints(renderingHints);
            g2d.setPaint(this.lensControlsDrawColor);
            Stroke savedStroke = g2d.getStroke();
            g2d.setStroke(new BasicStroke(Math.max(this.lensStrokeWidth, (float)((int)(1.0 / g2d.getTransform().getScaleX())))));
            g2d.draw(this.lensShape);
            int centerX = (int)Math.round(this.lensShape.getCenterX());
            int centerY = (int)Math.round(this.lensShape.getCenterY());
            g2d.draw(new Ellipse2D.Double((double)centerX - this.lensShape.getWidth() / 40.0, (double)centerY - this.lensShape.getHeight() / 40.0, this.lensShape.getWidth() / 20.0, this.lensShape.getHeight() / 20.0));
            Ellipse2D.Double killShape = new Ellipse2D.Double(this.lensShape.getMinX() + this.lensShape.getWidth(), this.lensShape.getMinY(), this.lensShape.getWidth() / 20.0, this.lensShape.getHeight() / 20.0);
            g2d.setPaint(this.lensControlsFillColor);
            g2d.fill(killShape);
            double radius = ((RectangularShape)killShape).getWidth() / 2.0;
            double xmin = killShape.getCenterX() - radius * Math.cos(0.7853981633974483);
            double ymin = killShape.getCenterY() - radius * Math.sin(0.7853981633974483);
            double xmax = killShape.getCenterX() + radius * Math.cos(0.7853981633974483);
            double ymax = killShape.getCenterY() + radius * Math.sin(0.7853981633974483);
            g2d.setPaint(this.lensControlsDrawColor);
            g2d.draw(new Line2D.Double(xmin, ymin, xmax, ymax));
            g2d.draw(new Line2D.Double(xmin, ymax, xmax, ymin));
            if (this.lensShape instanceof Rectangle2D) {
                Arrays.stream(AbstractLensSupport.getRectangularLensHandles((Rectangle2D)this.lensShape)).forEach(g2d::draw);
            }
            g2d.setStroke(savedStroke);
            g2d.setRenderingHints(savedRenderingHints);
        }

        @Override
        public boolean useTransform() {
            return true;
        }
    }
}

