/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf;

import ghidra.app.util.bin.BinaryReader;
import java.io.IOException;

public record DWARFLengthValue(long length, int intSize) {
    public static DWARFLengthValue read(BinaryReader reader, int defaultPointerSize) throws IOException {
        long startOffset = reader.getPointerIndex();
        long length = reader.readNextUnsignedInt();
        int intSize = 4;
        if (length == 0xFFFFFFFFL) {
            length = reader.readNextLong();
            intSize = 8;
        } else {
            if (length >= 0xFFFFFFF0L) {
                throw new IOException("Reserved DWARF length value: %x. Unknown extension.".formatted(length));
            }
            if (length == 0L) {
                if (DWARFLengthValue.isAllZerosUntilEOF(reader)) {
                    reader.setPointerIndex(reader.length());
                    return null;
                }
                if (reader.isBigEndian() && defaultPointerSize == 8) {
                    length = reader.readNextUnsignedInt();
                    intSize = 8;
                }
                if (length == 0L) {
                    throw new IOException("Invalid DWARF length 0 at 0x%x".formatted(startOffset));
                }
            }
        }
        return new DWARFLengthValue(length, intSize);
    }

    private static boolean isAllZerosUntilEOF(BinaryReader reader) throws IOException {
        reader = reader.clone();
        while (reader.hasNext()) {
            if (reader.readNextByte() == 0) continue;
            return false;
        }
        return true;
    }
}

