/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree.nodes;

import docking.widgets.tree.GTreeNode;
import generic.theme.GIcon;
import ghidra.app.plugin.core.symboltree.nodes.SymbolNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolTreeDataFlavor;
import ghidra.program.model.listing.Library;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import java.awt.datatransfer.DataFlavor;
import java.util.Comparator;
import javax.swing.Icon;

public class LibrarySymbolNode
extends SymbolNode {
    private static final String ORDINAL_PREFIX = "Ordinal_";
    private static final Icon LIBRARY_ICON = new GIcon("icon.plugin.symboltree.node.library");
    private static Comparator<GTreeNode> CHILD_COMPARATOR = (o1, o2) -> {
        Symbol s2;
        SymbolNode symbolNode1 = (SymbolNode)((Object)o1);
        SymbolNode symbolNode2 = (SymbolNode)((Object)o2);
        Symbol s1 = symbolNode1.getSymbol();
        Integer result = LibrarySymbolNode.tryToCompareExternalLocationsByOrdinal(s1, s2 = symbolNode2.getSymbol());
        if (result != null) {
            return result;
        }
        return o1.compareTo(o2);
    };
    private String tooltip;

    private static Integer tryToCompareExternalLocationsByOrdinal(Symbol s1, Symbol s2) {
        Object so1 = s1.getObject();
        if (!(so1 instanceof ExternalLocation)) {
            return null;
        }
        Object so2 = s2.getObject();
        if (!(so2 instanceof ExternalLocation)) {
            return null;
        }
        String n1 = s1.getName();
        String n2 = s2.getName();
        if (n1.startsWith(ORDINAL_PREFIX) && n2.startsWith(ORDINAL_PREFIX)) {
            try {
                int ordinal1 = Integer.parseInt(n1.substring(ORDINAL_PREFIX.length()));
                int ordinal2 = Integer.parseInt(n2.substring(ORDINAL_PREFIX.length()));
                return ordinal1 - ordinal2;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    LibrarySymbolNode(Program program, Symbol symbol) {
        super(program, symbol);
        String name = symbol.getName();
        String externalLibraryPath = program.getExternalManager().getExternalLibraryPath(name);
        this.tooltip = "External Library Symbol - " + name;
        if (externalLibraryPath != null) {
            this.tooltip = this.tooltip + " - " + externalLibraryPath;
        }
    }

    @Override
    public Comparator<GTreeNode> getChildrenComparator() {
        return CHILD_COMPARATOR;
    }

    @Override
    public Icon getIcon(boolean expanded) {
        return LIBRARY_ICON;
    }

    @Override
    public String getToolTip() {
        return this.tooltip;
    }

    @Override
    public void setNodeCut(boolean isCut) {
        throw new UnsupportedOperationException("Cannot cut a library node");
    }

    @Override
    public boolean supportsDataFlavors(DataFlavor[] dataFlavors) {
        for (DataFlavor flavor : dataFlavors) {
            if (!(flavor instanceof SymbolTreeDataFlavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Namespace getNamespace() {
        return (Library)this.symbol.getObject();
    }
}

