/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStreamImpl;

public class MemBufferImageInputStream
extends ImageInputStreamImpl {
    private MemBuffer buf;

    public MemBufferImageInputStream(MemBuffer buf, ByteOrder byteOrder) {
        this.buf = buf;
        this.setByteOrder(byteOrder);
    }

    public int getConsumedLength() {
        return (int)this.streamPos;
    }

    @Override
    public int read() throws IOException {
        try {
            return this.buf.getByte((int)this.streamPos++) & 0xFF;
        }
        catch (MemoryAccessException e) {
            --this.streamPos;
            return -1;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            int value = this.read();
            if (value < 0) {
                return i;
            }
            b[off + i] = (byte)value;
        }
        return len;
    }
}

