/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.op;

import ghidra.pcode.emu.jit.analysis.JitAllocationModel;
import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.op.IntBinOpGen;
import ghidra.pcode.emu.jit.gen.op.OpGen;
import ghidra.pcode.emu.jit.gen.type.TypeConversions;
import ghidra.pcode.emu.jit.op.JitIntAddOp;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.objectweb.asm.MethodVisitor;

public enum IntAddOpGen implements IntBinOpGen<JitIntAddOp>
{
    GEN;


    static void generateMpIntLegAdd(JitCodeGenerator gen, int idx, boolean takesCarry, boolean givesCarry, boolean storesResult, MethodVisitor mv) {
        if (takesCarry) {
            mv.visitLdcInsn((Object)32);
            mv.visitInsn(125);
            mv.visitInsn(93);
            mv.visitInsn(88);
            TypeConversions.generateIntToLong(JitType.IntJitType.I4, JitType.LongJitType.I8, TypeConversions.Ext.ZERO, mv);
            mv.visitInsn(97);
        } else {
            TypeConversions.generateIntToLong(JitType.IntJitType.I4, JitType.LongJitType.I8, TypeConversions.Ext.ZERO, mv);
        }
        mv.visitVarInsn(21, idx);
        TypeConversions.generateIntToLong(JitType.IntJitType.I4, JitType.LongJitType.I8, TypeConversions.Ext.ZERO, mv);
        mv.visitInsn(97);
        if (storesResult) {
            if (givesCarry) {
                mv.visitInsn(92);
            }
            TypeConversions.generateLongToInt(JitType.LongJitType.I8, JitType.IntJitType.I4, TypeConversions.Ext.ZERO, mv);
            mv.visitVarInsn(54, idx);
        } else if (!givesCarry) {
            mv.visitInsn(88);
        }
    }

    private void generateMpIntAdd(JitCodeGenerator gen, JitType.MpIntJitType type, MethodVisitor mv) {
        int legCount = type.legsAlloc();
        try (JitAllocationModel.JvmTempAlloc result = gen.getAllocationModel().allocateTemp(mv, "result", legCount);){
            OpGen.generateMpLegsIntoTemp(result, legCount, mv);
            for (int i = 0; i < legCount; ++i) {
                boolean isLast = i == legCount - 1;
                boolean takesCarry = i != 0;
                IntAddOpGen.generateMpIntLegAdd(gen, result.idx(i), takesCarry, !isLast, true, mv);
            }
            OpGen.generateMpLegsFromTemp(result, legCount, mv);
        }
    }

    @Override
    public boolean isSigned() {
        return false;
    }

    @Override
    public JitType afterLeft(JitCodeGenerator gen, JitIntAddOp op, JitType lType, JitType rType, MethodVisitor rv) {
        return TypeConversions.forceUniform(gen, lType, rType, TypeConversions.Ext.ZERO, rv);
    }

    @Override
    public JitType generateBinOpRunCode(JitCodeGenerator gen, JitIntAddOp op, JitControlFlowModel.JitBlock block, JitType lType, JitType rType, MethodVisitor rv) {
        JitType jitType = rType = TypeConversions.forceUniform(gen, rType, lType, TypeConversions.Ext.ZERO, rv);
        Objects.requireNonNull(jitType);
        JitType jitType2 = jitType;
        int n = 0;
        block6: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.MpIntJitType.class, JitType.MpIntJitType.class}, (Object)jitType2, n)) {
                case 0: {
                    JitType.IntJitType t = (JitType.IntJitType)jitType2;
                    rv.visitInsn(96);
                    break block6;
                }
                case 1: {
                    JitType.LongJitType t = (JitType.LongJitType)jitType2;
                    rv.visitInsn(97);
                    break block6;
                }
                case 2: {
                    JitType.MpIntJitType t = (JitType.MpIntJitType)jitType2;
                    if (t.size() != lType.size()) {
                        n = 3;
                        continue block6;
                    }
                    this.generateMpIntAdd(gen, t, rv);
                    break block6;
                }
                case 3: {
                    JitType.MpIntJitType t = (JitType.MpIntJitType)jitType2;
                    throw new AssertionError((Object)"forceUniform didn't work?");
                }
                default: {
                    throw new AssertionError();
                }
            }
            break;
        }
        return rType;
    }
}

