/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.plugin;

import generic.cache.FixedSizeMRUCachingFactory;
import generic.stl.Pair;
import ghidra.feature.vt.api.correlator.address.ExactMatchAddressCorrelator;
import ghidra.feature.vt.api.correlator.address.LinearAddressCorrelator;
import ghidra.feature.vt.api.correlator.address.VTHashedFunctionAddressCorrelator;
import ghidra.feature.vt.gui.plugin.VTSessionSupplier;
import ghidra.features.codecompare.correlator.CodeCompareAddressCorrelator;
import ghidra.framework.options.Options;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.util.AddressCorrelation;
import ghidra.program.util.AddressCorrelator;
import ghidra.program.util.DiscoverableAddressCorrelator;
import ghidra.util.classfinder.ClassSearcher;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;

public class AddressCorrelatorManager {
    private static final String ADDRESS_CORRELATORS_ELEMENT_NAME = "ADDRESS_CORRELATORS";
    private static final String ADDRESS_CORRELATOR_SUB_ELEMENT_NAME = "CORRELATOR";
    private static final String ADDRESS_CORRELATOR_NAME_KEY = "NAME";
    private static final String ADDRESS_CORRELATOR_OPTIONS_SUB_ELEMENT = "OPTIONS";
    private static final int DATA_CORRELATION_CACHE_SIZE = 5;
    private static final int FUNCTION_CORRELATION_CACHE_SIZE = 5;
    private static final Comparator<? super AddressCorrelator> CORRELATOR_COMPARATOR = (c1, c2) -> {
        int p2;
        int p1 = c1.getPriority();
        int d = p1 - (p2 = c2.getPriority());
        if (d != 0) {
            return d;
        }
        String n1 = c1.getClass().getSimpleName();
        String n2 = c2.getClass().getSimpleName();
        return n1.compareTo(n2);
    };
    private List<AddressCorrelator> correlatorList;
    private FixedSizeMRUCachingFactory<Pair<Function, Function>, AddressCorrelation> functionCache = new FixedSizeMRUCachingFactory(key -> this.getFunctionCorrelator((Function)key.first, (Function)key.second), 5);
    private FixedSizeMRUCachingFactory<Pair<Data, Data>, AddressCorrelation> dataCache = new FixedSizeMRUCachingFactory(key -> this.getDataCorrelator((Data)key.first, (Data)key.second), 5);

    public AddressCorrelatorManager(VTSessionSupplier sessionSupplier) {
        this.correlatorList = new ArrayList<AddressCorrelator>();
        this.initializeAddressCorrelators(sessionSupplier);
    }

    private void initializeAddressCorrelators(VTSessionSupplier sessionSupplier) {
        this.correlatorList.add(new ExactMatchAddressCorrelator(sessionSupplier));
        this.correlatorList.add(new VTHashedFunctionAddressCorrelator());
        this.correlatorList.add((AddressCorrelator)new CodeCompareAddressCorrelator());
        this.correlatorList.add(new LinearAddressCorrelator());
        this.correlatorList.addAll(this.initializeAddressCorrelators());
        this.correlatorList.sort(CORRELATOR_COMPARATOR);
    }

    private List<AddressCorrelator> initializeAddressCorrelators() {
        List instances = ClassSearcher.getInstances(DiscoverableAddressCorrelator.class);
        return new ArrayList<AddressCorrelator>(instances);
    }

    public AddressCorrelation getCorrelator(Function source, Function destination) {
        return (AddressCorrelation)this.functionCache.get((Object)new Pair((Object)source, (Object)destination));
    }

    public AddressCorrelation getCorrelator(Data source, Data destination) {
        return (AddressCorrelation)this.dataCache.get((Object)new Pair((Object)source, (Object)destination));
    }

    private AddressCorrelation getFunctionCorrelator(Function source, Function destination) {
        for (AddressCorrelator correlator : this.correlatorList) {
            AddressCorrelation correlation = correlator.correlate(source, destination);
            if (correlation == null) continue;
            return correlation;
        }
        return null;
    }

    private AddressCorrelation getDataCorrelator(Data source, Data destination) {
        for (AddressCorrelator correlator : this.correlatorList) {
            AddressCorrelation correlation = correlator.correlate(source, destination);
            if (correlation == null) continue;
            return correlation;
        }
        return null;
    }

    public void readConfigState(SaveState saveState) {
        Element correlatorsRootElement = saveState.getXmlElement(ADDRESS_CORRELATORS_ELEMENT_NAME);
        if (correlatorsRootElement == null) {
            return;
        }
        List correlatorElements = correlatorsRootElement.getChildren(ADDRESS_CORRELATOR_SUB_ELEMENT_NAME);
        for (Element correlatorElement : correlatorElements) {
            String className = correlatorElement.getAttributeValue(ADDRESS_CORRELATOR_NAME_KEY);
            List optionsList = correlatorElement.getChildren(ADDRESS_CORRELATOR_OPTIONS_SUB_ELEMENT);
            Element optionsElement = (Element)optionsList.get(0);
            List optionsContentList = optionsElement.getChildren("CATEGORY");
            Element optionsContent = (Element)optionsContentList.get(0);
            ToolOptions options = new ToolOptions(optionsContent);
            this.updateCorrelatorOptions(className, (Options)options);
        }
    }

    private void updateCorrelatorOptions(String className, Options newOptions) {
        for (AddressCorrelator correlator : this.correlatorList) {
            if (!correlator.getClass().getName().equals(className)) continue;
            ToolOptions options = correlator.getOptions();
            options.copyOptions(newOptions);
            correlator.setOptions(options);
        }
    }

    public void writeConfigState(SaveState saveState) {
        Element correlatorsRootElement = new Element(ADDRESS_CORRELATORS_ELEMENT_NAME);
        for (AddressCorrelator correlator : this.correlatorList) {
            Element correlatorSubElement = new Element(ADDRESS_CORRELATOR_SUB_ELEMENT_NAME);
            correlatorSubElement.setAttribute(ADDRESS_CORRELATOR_NAME_KEY, correlator.getClass().getName());
            ToolOptions options = correlator.getOptions();
            Element optionsSubElement = new Element(ADDRESS_CORRELATOR_OPTIONS_SUB_ELEMENT);
            Element optionsXMLContent = options.getXmlRoot(true);
            optionsSubElement.addContent((Content)optionsXMLContent);
            correlatorSubElement.addContent((Content)optionsSubElement);
            correlatorsRootElement.addContent((Content)correlatorSubElement);
        }
        saveState.putXmlElement(ADDRESS_CORRELATORS_ELEMENT_NAME, correlatorsRootElement);
    }

    public Options getOptions(Class<?> class1) {
        for (AddressCorrelator correlator : this.correlatorList) {
            if (!class1.isAssignableFrom(correlator.getClass())) continue;
            return correlator.getOptions();
        }
        return null;
    }

    public void setOptions(Class<?> class1, Options options) {
        this.updateCorrelatorOptions(class1.getName(), options);
    }
}

