/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.proxy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.IconRegistry;
import org.freeplane.features.icon.Tag;
import org.freeplane.features.icon.TagCategories;
import org.freeplane.features.icon.mindmapmode.MIconController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.proxy.AbstractProxy;
import org.freeplane.plugin.script.proxy.Proxy;

public class TagsProxy
extends AbstractProxy<NodeModel>
implements Proxy.Tags {
    TagsProxy(NodeModel delegate, ScriptContext scriptContext) {
        super(delegate, scriptContext);
    }

    public List<String> getTags() {
        MIconController iconController = this.iconController();
        return iconController.getTags((NodeModel)this.getDelegate()).stream().map(Tag::getContent).collect(Collectors.toList());
    }

    public List<String> getCategorizedTags() {
        MIconController iconController = this.iconController();
        NodeModel node = (NodeModel)this.getDelegate();
        IconRegistry iconRegistry = node.getMap().getIconRegistry();
        TagCategories tagCategories = iconRegistry.getTagCategories();
        return iconController.extendCategories(iconController.getTags(node), tagCategories).stream().map(tag -> tag.getContent()).collect(Collectors.toList());
    }

    public SortedSet<String> getCategories() {
        MIconController iconController = this.iconController();
        NodeModel node = (NodeModel)this.getDelegate();
        IconRegistry iconRegistry = node.getMap().getIconRegistry();
        TagCategories tagCategories = iconRegistry.getTagCategories();
        String tagCategorySeparator = tagCategories.getTagCategorySeparator();
        return iconController.extendCategories(iconController.getTags(node), tagCategories).stream().map(tag -> tag.categoryTags(tagCategorySeparator)).flatMap(Collection::stream).map(Tag::getContent).collect(Collectors.toCollection(TreeSet::new));
    }

    public List<? extends Icon> getIcons() {
        MIconController iconController = this.iconController();
        return iconController.getTagIcons((NodeModel)this.getDelegate());
    }

    private MIconController iconController() {
        return (MIconController)this.getModeController().getExtension(IconController.class);
    }

    public void setTags(Collection<String> tags) {
        List<Tag> tagList = this.freeplaneTags(tags);
        MIconController iconController = this.iconController();
        iconController.setTags((NodeModel)this.getDelegate(), tagList, false);
    }

    private List<Tag> freeplaneTags(Collection<String> keywords) {
        return keywords.stream().map(this::createTag).collect(Collectors.toList());
    }

    public void add(String keyword) {
        MIconController iconController = this.iconController();
        ArrayList<Tag> tagList = new ArrayList<Tag>(iconController.getTags((NodeModel)this.getDelegate()));
        tagList.add(this.createTag(keyword));
        iconController.setTags((NodeModel)this.getDelegate(), tagList, false);
    }

    private Tag createTag(String keyword) {
        return new Tag(keyword);
    }

    public void add(int index, String keyword) {
        MIconController iconController = this.iconController();
        ArrayList<Tag> tagList = new ArrayList<Tag>(iconController.getTags((NodeModel)this.getDelegate()));
        tagList.add(index, this.createTag(keyword));
        iconController.setTags((NodeModel)this.getDelegate(), tagList, false);
    }

    public void add(Collection<String> keywords) {
        MIconController iconController = this.iconController();
        ArrayList<Tag> tagList = new ArrayList<Tag>(iconController.getTags((NodeModel)this.getDelegate()));
        tagList.addAll(this.freeplaneTags(keywords));
        iconController.setTags((NodeModel)this.getDelegate(), tagList, false);
    }

    public boolean remove(String keyword) {
        MIconController iconController = this.iconController();
        ArrayList tagList = new ArrayList(iconController.getTags((NodeModel)this.getDelegate()));
        boolean result = tagList.remove(this.createTag(keyword));
        iconController.setTags((NodeModel)this.getDelegate(), tagList, false);
        return result;
    }

    public String remove(int index) {
        MIconController iconController = this.iconController();
        ArrayList tagList = new ArrayList(iconController.getTags((NodeModel)this.getDelegate()));
        Tag result = (Tag)tagList.remove(index);
        iconController.setTags((NodeModel)this.getDelegate(), tagList, false);
        return result == null ? null : result.getContent();
    }

    public boolean remove(Collection<String> keywords) {
        MIconController iconController = this.iconController();
        ArrayList tagList = new ArrayList(iconController.getTags((NodeModel)this.getDelegate()));
        boolean result = tagList.removeAll(this.freeplaneTags(keywords));
        iconController.setTags((NodeModel)this.getDelegate(), tagList, false);
        return result;
    }

    public boolean contains(String searched) {
        return this.getTags().contains(searched);
    }

    public boolean containsAny(Collection<String> searched) {
        HashSet<String> set = new HashSet<String>(this.getTags());
        return searched.stream().anyMatch(set::contains);
    }

    public boolean containsAll(Collection<String> searched) {
        return new HashSet<String>(this.getTags()).containsAll(searched);
    }

    public boolean containsCategory(String searched) {
        return this.getCategories().contains(searched);
    }

    public boolean containsAnyCategory(Collection<String> searched) {
        SortedSet<String> categories = this.getCategories();
        return searched.stream().anyMatch(categories::contains);
    }

    public boolean containsAllCategories(Collection<String> searched) {
        return this.getCategories().containsAll(searched);
    }
}

