/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.modules.syntax;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.library.modules.ModuleDependency;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.LinkedHashMultimap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.SetMultimap;
import java.util.Set;
import java.util.stream.Collectors;

@PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
public final class AllowedModuleDependencies {
    private final SetMultimap<String, String> allowedModuleDependenciesByName = LinkedHashMultimap.create();

    private AllowedModuleDependencies() {
    }

    private AllowedModuleDependencies allowDependencies(String originModuleName, Set<String> allowedTargetModuleNames) {
        this.allowedModuleDependenciesByName.putAll(originModuleName, allowedTargetModuleNames);
        return this;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public RequiringAllowedTargets fromModule(String moduleName) {
        return new RequiringAllowedTargets(moduleName);
    }

    DescribedPredicate<ModuleDependency<?>> asPredicate() {
        return DescribedPredicate.describe(this.getDescription(), moduleDependency -> this.allowedModuleDependenciesByName.get((Object)moduleDependency.getOrigin().getName()).contains(moduleDependency.getTarget().getName()));
    }

    private String getDescription() {
        return this.allowedModuleDependenciesByName.asMap().entrySet().stream().map(originToTargets -> (String)originToTargets.getKey() + " -> " + originToTargets.getValue()).collect(Collectors.joining(", ", "{ ", " }"));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public static Creator allow() {
        return new Creator();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public final class RequiringAllowedTargets {
        private final String originModuleName;

        private RequiringAllowedTargets(String originModuleName) {
            this.originModuleName = originModuleName;
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
        public AllowedModuleDependencies toModules(String ... targetModuleNames) {
            return AllowedModuleDependencies.this.allowDependencies(this.originModuleName, ImmutableSet.copyOf(targetModuleNames));
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public static final class Creator {
        private Creator() {
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
        public RequiringAllowedTargets fromModule(String moduleName) {
            return new AllowedModuleDependencies().new RequiringAllowedTargets(moduleName);
        }
    }
}

