/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.control;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardItemContainer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardItemRenderer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardItemViewSettings;
import org.jkiss.dbeaver.ui.dashboard.navigator.HandlerDashboardViewItem;
import org.jkiss.dbeaver.ui.dashboard.view.DashboardItemViewSettingsDialog;

public abstract class DashboardRendererAbstract
implements DashboardItemRenderer {
    @Override
    public void fillDashboardToolbar(final @NotNull DashboardItemContainer itemContainer, @NotNull IContributionManager manager, final @NotNull Composite chartComposite, final @NotNull DashboardItemViewSettings dashboardConfig) {
        if (!UIUtils.isInDialog((Control)chartComposite)) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)new Action("View in popup", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.FIT_WINDOW)){

                public void run() {
                    HandlerDashboardViewItem.openDashboardViewDialog(itemContainer);
                }
            });
            manager.add((IAction)new Action("Refresh chart", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.REFRESH)){

                public void run() {
                    DashboardRendererAbstract.this.refreshChart(itemContainer, chartComposite, dashboardConfig);
                }
            });
            manager.add((IAction)new Action("Settings", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.CONFIGURATION)){

                public void run() {
                    DashboardItemViewSettingsDialog dialog = new DashboardItemViewSettingsDialog(UIUtils.getActiveShell(), itemContainer, itemContainer.getItemConfiguration().getViewConfiguration());
                    dialog.open();
                }
            });
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)new Action("Close", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.CLOSE)){

                public void run() {
                    itemContainer.getGroup().selectItem(itemContainer);
                    ActionUtils.runCommand((String)"org.jkiss.dbeaver.ui.dashboard.remove", (IServiceLocator)itemContainer.getGroup().getView().getWorkbenchSite());
                }
            });
        }
    }

    protected void refreshChart(DashboardItemContainer itemContainer, Composite chartComposite, DashboardItemViewSettings dashboardConfig) {
        itemContainer.getGroup().selectItem(itemContainer);
        ActionUtils.runCommand((String)"org.jkiss.dbeaver.ui.chart.refresh", (IServiceLocator)itemContainer.getGroup().getView().getWorkbenchSite());
    }
}

